<?php

namespace App\Events;

use App\Models\Item;
use Illuminate\Broadcasting\Channel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class DrawPrize implements ShouldBroadcast
{
    use SerializesModels;

    public $item;
    public $itemId;
    public $itemImage;

    public function __construct(Item $item)
    {
        $this->item = $item->item;
        $this->itemId = $item->id;
        $this->itemImage = $item->image;
    }

    public function broadcastOn()
    {
        return new Channel('draw-channel');
    }
    
    public function broadcastAs()
    {
        return 'DrawPrize';
    }
}
