<?php

namespace App\Http\Controllers\Api;

use App\Models\Item;
use App\Models\AutoDraw;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\ItemResource;
use App\Http\Resources\SeedResource;
use App\Http\Requests\StoreItemRequest;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\UpdateItemRequest;


class ItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response\Json\AnonymousResourceCollection
     */
    public function index()
    {
        return ItemResource::collection(Item::query()->orderBy('id', 'asc')->get());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreItemRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreItemRequest $request)
    {
        $data = $request->validated();
        if ($request->hasFile('image')) {
            // Get the uploaded file
            $image = $request->file('image');

            // Store the image in the storage folder
            $path = $image->store('uploads', 'public');

            // Add the image path to the data array
            $data['image'] = '/public/storage/'.$path;
        }
        $item = Item::create($data);
        return response(new ItemResource($item), 201);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function show(Item $item)
    {
        return new ItemResource($item);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateItemRequest  $request
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateItemRequest $request, Item $item)
    {
        $data = $request->validated();
        if ($request->hasFile('image')) {
            // Get the uploaded file
            $image = $request->file('image');

            // Store the image in the storage folder
            $path = $image->store('uploads', 'public');

            // Add the image path to the data array
            $data['image'] = '/public/storage/'.$path;
        }
        $item->update($data);
    }

    public function seed(Request $request, $id) {
        $data = AutoDraw::findOrFail($id);
        $data->check = $request->check;
        $data->save();
        return response('', 201);
    }

    public function checkSeed() {
        $data = AutoDraw::get()->first();
        return $data;
        // return json()->response([$data]);
    }

    // public function checkSeedDelete(Request $request, $id) {
    //     $data = AutoDraw::findOrFail($id);
    //     $data->check = $request->check;
    //     // return json()->response([$data]);
    // }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function destroy(Item $item)
    {
        $item->delete();
        return response("", 204);
    }
}
