<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class ImageController extends Controller
{
    public function show($filename)
    {
        $path = storage_path('app/public/uploads/' . $filename);

        if (!file_exists($path)) {
            abort(404);
        }

        $image = Image::make($path);

        // Optionally, you can apply any image manipulation operations here
        // Example: $image->resize(500, 500);

        return $image->response();
    }
}