<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\DrawController;
use App\Http\Controllers\Api\ItemController;
use App\Http\Controllers\Api\ParticipantController;

header('Access-Control-Allow-Origin: *');
//Access-Control-Allow-Origin: *
header('Access-Control-Allow-Methods:  POST, GET, OPTIONS, PUT, DELETE');
header('Access-Control-Allow-Headers:  Content-Type, X-Auth-Token, Origin, Authorization');

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function() {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    Route::apiResource('/items', ItemController::class);
    Route::apiResource('/participants', ParticipantController::class);
    // Route::post('/items/{item}', [ItemController::class, 'update'])->name('item.update');
    // Route::post('/items/seed', [ItemController::class, 'seed'])->name('seed.store');
    Route::get('/items/check/seed-check', [ItemController::class, 'checkSeed'])->name('seed.check');
    Route::post('/items/check/seed-check/{id}', [ItemController::class, 'seed'])->name('seed.check.do');
    Route::post('/participants/import', [ParticipantController::class, 'import'])->name('import.participants');

    Route::post('/draw', [DrawController::class, 'draw']);
});

Route::post('/signup', [AuthController::class, 'signup']);
Route::post('/login', [AuthController::class, 'login']);

