<?php

// namespace App\Http\Controllers\Api;

// use App\Events\DrawPrize;
// use App\Http\Controllers\Controller;
// use App\Models\Item;
// use Illuminate\Http\Request;

// class DrawController extends Controller
// {
//     public function draw(Request $request)
//     {
//         // Get all items with non-zero quantity
//         $items = Item::where('quantity', '>', 0)->get();

//         // Extract the probabilities and calculate the total probability
//         $probabilities = $items->pluck('probability');
//         $totalProbability = $probabilities->sum();

//         // Generate a random number between 0 and the total probability
//         $randomNumber = mt_rand() / mt_getrandmax() * $totalProbability;

//         // Determine the winning prize based on the random number and item probabilities
//         $accumulatedProbability = 0;
//         $winningItem = null;

//         foreach ($items as $item) {
//             $accumulatedProbability += $item->probability;

//             if ($randomNumber <= $accumulatedProbability) {
//                 $winningItem = $item;
//                 break;
//             }
//         }

//         if ($winningItem) {
//             // Dispatch the DrawPrize event
//             // event(new DrawPrize($winningItem));

//             // Update the quantity of the winning item
//             // $winningItem->decrement('quantity');

//             return response()->json([
//                 'message' => 'Prize drawn successfully',
//                 'data' => [
//                     'item' => $winningItem->item,
//                     'itemId' => $winningItem->id,
//                     'itemImage' => $winningItem->image,
//                     'quantity' => $winningItem->quantity,
//                     'probability' => $winningItem->probability
//                 ]
//             ]);
//         } else {
//             return response()->json(['message' => 'No prize available'], 400);
//         }
//     }
// }


namespace App\Http\Controllers\Api;

use App\Events\DrawPrize;
use App\Http\Controllers\Controller;
use App\Models\Participant;
use Illuminate\Http\Request;

class DrawController extends Controller
{
    public function draw(Request $request)
    {
        // Get all active participants (status = 1)
        $participants = Participant::where('status', 1)->get();

        if ($participants->isEmpty()) {
            return response()->json(['message' => 'No active participants available'], 400);
        }

        // Randomly select a participant
        $winningParticipant = $participants->random();

        // Optionally, you can set the winner's status to 0 so they can't be drawn again
        $winningParticipant->update(['status' => 0]);

        return response()->json([
            'message' => 'Participant drawn successfully',
            'data' => [
                'name' => $winningParticipant->name,
                'participantId' => $winningParticipant->id,
                'status' => $winningParticipant->status
            ]
        ]);
    }
}
