<?php

namespace App\Http\Controllers\Api;

use App\Models\Participant;
use App\Models\AutoDraw;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\ParticipantResource;
use App\Http\Resources\SeedResource;
use App\Http\Requests\StoreParticipantRequest;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\UpdateParticipantRequest;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ParticipantsImport;


class ParticipantController extends Controller
{
    public function index()
    {
        return ParticipantResource::collection(Participant::query()->orderBy('id', 'asc')->get());
    }

    public function store(StoreParticipantRequest $request)
    {
        $data = $request->validated();
        $participant = Participant::create($data);
        return response(new ParticipantResource($participant), 201);
    }

    public function show(Participant $participant)
    {
        return new ParticipantResource($participant);
    }

    public function update(UpdateParticipantRequest $request, Participant $participant)
    {
        $data = $request->validated();
        $participant->update($data);
        return new ParticipantResource($participant);
    }

    public function destroy(Participant $participant)
    {
        $participant->delete();
        return response("", 204);
    }
    

    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls,csv'
        ]);
    
        try {
            Excel::import(new ParticipantsImport, $request->file('file'));
            
            return response()->json([
                'message' => 'Participants imported successfully'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Error importing file: ' . $e->getMessage()
            ], 500);
        }
    }
}