<?php

namespace App\Listeners;

use App\Events\DrawPrize;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class DrawPrizeListener implements ShouldQueue
{
    use InteractsWithQueue;

    /**
     * Handle the event.
     *
     * @param  DrawPrize  $event
     * @return void
     */
    public function handle(DrawPrize $event)
    {
        // Perform the logic to update the quantity of the selected prize
        // Example: Update the quantity of the prize in the database

        // Send the response to other clients
        event(new PrizeDrawn($event->prize));
    }
}

