<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Laravel Echo Server Information
    |--------------------------------------------------------------------------
    |
    | Here you may specify the host and port of the Laravel Echo server
    | that will handle broadcasting events for your application.
    |
    */

    'host' => env('LARAVEL_ECHO_SERVER_HOST', 'http://localhost'),
    'port' => env('LARAVEL_ECHO_SERVER_PORT', 6001),

    /*
    |--------------------------------------------------------------------------
    | Broadcast Authentication
    |--------------------------------------------------------------------------
    |
    | The client drivers that should be used to authenticate the broadcasting
    | channels. The `null` driver uses the Laravel session authentication.
    |
    | Supported: "jwt", "api", "null"
    |
    */

    'auth_driver' => env('BROADCAST_AUTH_DRIVER', 'null'),

    /*
    |--------------------------------------------------------------------------
    | Redis Connection Information
    |--------------------------------------------------------------------------
    |
    | Here you may specify the connection information for the Redis server
    | used by your application to publish broadcast events.
    |
    */

    'redis' => [
        'host' => env('REDIS_HOST', 'localhost'),
        'port' => env('REDIS_PORT', 6379),
        'password' => env('REDIS_PASSWORD', null),
        'database' => env('REDIS_DB', 0),
    ],

];
