<?php

namespace App\Http\Controllers;

use App\Models\QrCode;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class QrCodeController extends Controller
{
    public function generate()
    {
        $code = Str::uuid();
        $qr = QrCode::format('png')->size(300)->generate(route('verify.qr', $code));

        $filename = "qr_{$code}.png";
        Storage::put("public/qrcodes/{$filename}", $qr);

        QrCode::create([
            'user_id' => auth()->id(),
            'code' => $code,
        ]);

        return view('dashboard.qr', [
            'qr_path' => asset("storage/qrcodes/{$filename}"),
            'link' => route('verify.qr', $code),
        ]);
    }
}
