<?php

namespace App\Http\Controllers;

use App\Models\QrCode;
use Illuminate\Http\Request;

class QrController extends Controller
{
    public function scannerPage()
    {
        return view('admin.scanner');
    }

    public function show(Request $request)
    { 
        $code = $request->query('code');
        $qr = QrCode::where('code',$code)->get()->first();
        
        // Option 1: Inline base64
        $link = url("/validate-qr?code={$qr->code}&day={$qr->day}");
        $qrCode = $qr->label;
        $qrDay = $qr->day;
        // $qrImage = \SimpleSoftwareIO\QrCode\Facades\QrCode::format('png')->size(500)->generate($link);
        // $qrImageUrl = 'data:image/png;base64,' . base64_encode($qrImage);
        $qrImageUrl = asset("storage/qrcodes/{$code}".'.png');

        return view('qr-show', [
            'qrImageUrl' => $link,
            'qrCode' => $qrCode,
            'qrDay' => $qrDay,
            'code' => $code
        ]);
    }

    public function validateQr(Request $request)
    {
        $code = $request->query('code');
    
        $qr = QrCode::where('code', $code)->first();
    
        if (!$qr) {
            return view('qr.invalid', ['message' => 'QR Code not found.']);
        }
    
        // Define event schedule
        $eventDays = [
            'day1' => '2025-07-25',
            'day2' => '2025-07-26',
            'day3' => '2025-07-27',
        ];
    
        $today = now()->toDateString();
    
        // Determine current event day
        $currentDay = collect($eventDays)->search($today);
    
        if (!$currentDay) {
            return view('admin.qr-invalid', ['message' => 'Today is not a valid event day.']);
        }
    
        // Check if the QR is for today
        if ($qr->day !== $currentDay) {
            return view('admin.qr-invalid', ['message' => "This QR is only valid for {$qr->day}, not today."]);
        }
    
        // Check if already used
        if ($qr->is_used) {
            return view('admin.qr-invalid', ['message' => 'This QR code has already been used.']);
        }
    
        // Mark as used
        $qr->is_used = true;
        $qr->save();
    
        return view('admin.qr-valid', ['qr' => $qr]);
    }

    public function validateQrAjax(Request $request)
    {
        $code = $request->input('code');
        $qr = QrCode::where('code', $code)->first();

        if (!$qr) {
            return response()->json(['status' => 'error', 'message' => 'QR not found.']);
        }

        // Check event day validity
        $eventDays = [
            'day1' => '2025-07-25',
            'day2' => '2025-07-26',
            'day3' => '2025-07-27',
        ];

        $today = now()->toDateString();
        $currentDay = collect($eventDays)->search($today);

        if (!$currentDay) {
            return response()->json(['status' => 'error', 'message' => 'Today is not an event day.', 'label' => $qr->label, 'day' => $qr->day]);
        }

        if ($qr->day !== $currentDay) {
            return response()->json(['status' => 'error', 'message' => "QR is for {$qr->day}, not today."]);
        }

        if ($qr->is_used) {
            return response()->json(['status' => 'error', 'message' => 'QR already used.', 'label' => $qr->label, 'day' => $qr->day]);
        }

        // Mark as used
        $qr->is_used = true;
        $qr->save();

        return response()->json([
            'status' => 'success',
            'message' => 'QR is valid.',
            'label' => $qr->label,
            'day' => $qr->day
        ]);
    }
}
