<?php

namespace App\Http\Controllers;

use App\Models\QrCode;
use Illuminate\Http\Request;

class QrVerificationController extends Controller
{
    public function verify($code)
    {
        $qr = QrCode::where('code', $code)->first();

        if (!$qr || !$qr->is_active) {
            return response()->view('qr.invalid', [], 404);
        }

        return view('qr.valid', ['qr' => $qr]);
    }
}
