@extends('layouts.app')

@section('title', 'QR Code Generator')

@section('content')
    <h2>Generate QR Code</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form method="POST" action="{{ route('admin.qr-generator') }}">
        @csrf

        <div class="mb-3">
            <label class="form-label">Name/Company</label>
            <input type="text" name="label" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Day</label>
            <select name="day" class="form-select" required>
                <option value="day1">Day 1</option>
                <option value="day2">Day 2</option>
                <option value="day3">Day 3</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Number of QR Codes to Generate</label>
            <input type="number" name="quantity" class="form-control" min="1" max="100" value="1">
        </div>


        <button type="submit" class="btn btn-primary">Generate QR</button>
    </form>
@endsection
