@extends('layouts.app')
@section('content')

<div class="container">
    <h2 class="mb-4">Generated QR Codes</h2>

    @if($qrs->count())
        <table id="qrTable" class="table table-striped">
            <thead>
                <tr>
                    <th>Label</th>
                    <th>Day</th>
                    <th>Used</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($qrs as $qr)
                    <tr>
                        <td>{{ $qr->label }}</td>
                        <td>{{ ucfirst($qr->day) }}</td>
                        <td>
                            @if($qr->is_used)
                                <span class="badge bg-danger">Used</span>
                            @else
                                <span class="badge bg-success">Unused</span>
                            @endif
                        </td>
                        <td>{{ $qr->created_at->format('F j, Y') }}</td>
                        <td>
                            <a target="_blank" href="{{ route('qr.show', 'code='.$qr->code) }}" class="btn btn-sm btn-outline-primary">Show</a>
                            <button class="btn btn-sm btn-secondary copy-btn"
                                data-link="{{ route('qr.show', ['code' => $qr->code]) }}">
                                Copy Link
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>No QR codes found.</p>
    @endif
</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function() {
        $('#qrTable').DataTable({
            // pageLength: 10,
            responsive: true,
            "order": [[ 4, 'desc' ]]
        });
        const buttons = document.querySelectorAll('.copy-btn');

        buttons.forEach(button => {
            button.addEventListener('click', function () {
                const link = this.getAttribute('data-link');
                navigator.clipboard.writeText(link)
                    .then(() => {
                        this.innerText = 'Copied!';
                        setTimeout(() => {
                            this.innerText = 'Copy Link';
                        }, 1500);
                    })
                    .catch(err => {
                        console.error('Failed to copy: ', err);
                        alert('Copy failed. Please try again.');
                    });
            });
        });

    });
</script>
@endpush
