<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'My App')</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar bg-dark text-white" style="min-width: 250px; height: 100vh;">
            <div class="sidebar-header text-center py-3">
                <h3>Admin Panel</h3>
            </div>
            <ul class="list-unstyled">
                <li><a href="{{ route('admin.dashboard') }}" class="text-white p-3 d-block">Dashboard</a></li>
                @if(auth()->user()->role == 1)
                <li><a href="{{ route('admin.create-user') }}" class="text-white p-3 d-block">Create User</a></li>
                @endif
                <li><a href="{{ route('admin.qr-generator') }}" class="text-white p-3 d-block">QR Generator</a></li>
                <li><a href="{{ route('admin.qr-list') }}" class="text-white p-3 d-block">View All QR Codes</a></li>
                <li><a href="{{ route('logout') }}" class="text-white p-3 d-block" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Logout</a></li>
            </ul>
        </div>

        <!-- Main Content Area -->
        <div class="container-fluid" style="flex: 1;">
            @include('layouts.nav') <!-- Optional top bar -->
            <div class="container mt-4">
                @yield('content')
            </div>
        </div>
    </div>

    <!-- Logout form -->
    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
        @csrf
    </form>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    @stack('scripts')
</body>
</html>
