@extends('layouts.guest')

@section('content')
<div id="qr-composite" style="position: relative; width: 625px; height: 625px;">
    <!-- Background Image -->
     @if($qrDay == 'day1')
        <img src="{{ asset('images/friday_pass.png') }}" style="width: 100%; height: 100%; object-fit: cover;" />
     @elseif($qrDay == 'day2')
        <img src="{{ asset('images/saturday_pass.png') }}" style="width: 100%; height: 100%; object-fit: cover;" />
     @else
        <img src="{{ asset('images/sunday_pass.png') }}" style="width: 100%; height: 100%; object-fit: cover;" />
     @endif

    <!-- QR Code in Center -->
    <div style="display:flex; flex-direction: column; justify-content: space-around; align-items: center;position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 350px; height: 350px; background: white; border-radius: 10px;">
        <img src="data:image/png;base64,{{ base64_encode(QrCode::format('png')->size(300)->generate($qrImageUrl)) }}" />
        <div class="code" style="font-family: Roboto; line-height: 16px;">{{ $qrCode }}</div>
    </div>
</div>

<!-- Image Output -->
<div id="result" class="mt-4"></div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
    window.addEventListener('load', () => {
        const qrDiv = document.getElementById('qr-composite');
        html2canvas(qrDiv).then(canvas => {
            const dataUrl = canvas.toDataURL('image/png');
            // Hide the div so only the rendered image is shown
            qrDiv.style.display = 'none';
            // Insert the rendered image
            const result = document.getElementById('result');
            const img = document.createElement('img');
            img.src = dataUrl;
            img.style.width = '100%';
            img.style.maxWidth = '625px';
            img.setAttribute('download', '{{ $qrCode }}.png');
            result.appendChild(img);
        });
    });
</script>
@endpush