<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\QrController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ProfileController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    if (auth()->check()) {
        return redirect('/dashboard');
    }
    return redirect('/login');
})->middleware('guest');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});


Route::middleware(['auth'])->group(function () {
    Route::get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/admin/create-user', [AdminController::class, 'createUser'])->name('admin.create-user');
    Route::post('/create-user', [AdminController::class, 'storeUser'])->name('admin.store-user');
    Route::match(['get', 'post'], '/admin/qr-generator', [AdminController::class, 'qrGenerator'])->name('admin.qr-generator');
    Route::get('/admin/qr-list', [App\Http\Controllers\AdminController::class, 'qrList'])->name('admin.qr-list');
    Route::get('/validate-qr', [QrController::class, 'validateQr'])->name('qr.validate');
    Route::get('/qr', [QrController::class, 'show'])->name('qr.show');
    Route::post('/logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');
});
Route::get('/qr/scanner', [QrController::class, 'scannerPage'])->name('qr.scanner');
Route::post('/api/validate-qr', [QrController::class, 'validateQrAjax']);



require __DIR__.'/auth.php';
