<?php $__env->startSection('content'); ?>

<div class="container">
    <h2 class="mb-4">Generated QR Codes</h2>

    <?php if($qrs->count()): ?>
        <table id="qrTable" class="table table-striped">
            <thead>
                <tr>
                    <th>Label</th>
                    <th>Day</th>
                    <th>Used</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $qrs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($qr->label); ?></td>
                        <td><?php echo e(ucfirst($qr->day)); ?></td>
                        <td>
                            <?php if($qr->is_used): ?>
                                <span class="badge bg-danger">Used</span>
                            <?php else: ?>
                                <span class="badge bg-success">Unused</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($qr->created_at->format('F j, Y')); ?></td>
                        <td>
                            <a target="_blank" href="<?php echo e(route('qr.show', 'code='.$qr->code)); ?>" class="btn btn-sm btn-outline-primary">Show</a>
                            <button class="btn btn-sm btn-secondary copy-btn"
                                data-link="<?php echo e(route('qr.show', ['code' => $qr->code])); ?>">
                                Copy Link
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>No QR codes found.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#qrTable').DataTable({
            // pageLength: 10,
            responsive: true,
            "order": [[ 4, 'desc' ]]
        });
        const buttons = document.querySelectorAll('.copy-btn');

        buttons.forEach(button => {
            button.addEventListener('click', function () {
                const link = this.getAttribute('data-link');
                navigator.clipboard.writeText(link)
                    .then(() => {
                        this.innerText = 'Copied!';
                        setTimeout(() => {
                            this.innerText = 'Copy Link';
                        }, 1500);
                    })
                    .catch(err => {
                        console.error('Failed to copy: ', err);
                        alert('Copy failed. Please try again.');
                    });
            });
        });

    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slklwimy/public_html/internal_ticketing/resources/views/admin/qr-list.blade.php ENDPATH**/ ?>