<?php $__env->startSection('content'); ?>
<div id="qr-composite" style="position: relative; width: 625px; height: 625px;">
    <!-- Background Image -->
     <?php if($qrDay == 'day1'): ?>
        <img src="<?php echo e(asset('images/friday_pass.png')); ?>" style="width: 100%; height: 100%; object-fit: cover;" />
     <?php elseif($qrDay == 'day2'): ?>
        <img src="<?php echo e(asset('images/saturday_pass.png')); ?>" style="width: 100%; height: 100%; object-fit: cover;" />
     <?php else: ?>
        <img src="<?php echo e(asset('images/sunday_pass.png')); ?>" style="width: 100%; height: 100%; object-fit: cover;" />
     <?php endif; ?>

    <!-- QR Code in Center -->
    <div style="display:flex; flex-direction: column; justify-content: space-around; align-items: center;position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 350px; height: 350px; background: white; border-radius: 10px;">
        <img src="data:image/png;base64,<?php echo e(base64_encode(QrCode::format('png')->size(300)->generate($qrImageUrl))); ?>" />
        <div class="code" style="font-family: Roboto; line-height: 16px;"><?php echo e($qrCode); ?></div>
    </div>
</div>

<!-- Image Output -->
<div id="result" class="mt-4"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
    window.addEventListener('load', () => {
        const qrDiv = document.getElementById('qr-composite');
        html2canvas(qrDiv).then(canvas => {
            const dataUrl = canvas.toDataURL('image/png');
            // Hide the div so only the rendered image is shown
            qrDiv.style.display = 'none';
            // Insert the rendered image
            const result = document.getElementById('result');
            const img = document.createElement('img');
            img.src = dataUrl;
            img.style.width = '100%';
            img.style.maxWidth = '625px';
            img.setAttribute('download', '<?php echo e($qrCode); ?>.png');
            result.appendChild(img);
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slklwimy/public_html/internal_ticketing/resources/views/qr-show.blade.php ENDPATH**/ ?>