<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'My App'); ?></title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar bg-dark text-white" style="min-width: 250px; height: 100vh;">
            <div class="sidebar-header text-center py-3">
                <h3>Admin Panel</h3>
            </div>
            <ul class="list-unstyled">
                <li><a href="<?php echo e(route('admin.dashboard')); ?>" class="text-white p-3 d-block">Dashboard</a></li>
                <?php if(auth()->user()->role == 1): ?>
                <li><a href="<?php echo e(route('admin.create-user')); ?>" class="text-white p-3 d-block">Create User</a></li>
                <?php endif; ?>
                <li><a href="<?php echo e(route('admin.qr-generator')); ?>" class="text-white p-3 d-block">QR Generator</a></li>
                <li><a href="<?php echo e(route('admin.qr-list')); ?>" class="text-white p-3 d-block">View All QR Codes</a></li>
                <li><a href="<?php echo e(route('logout')); ?>" class="text-white p-3 d-block" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Logout</a></li>
            </ul>
        </div>

        <!-- Main Content Area -->
        <div class="container-fluid" style="flex: 1;">
            <?php echo $__env->make('layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <!-- Optional top bar -->
            <div class="container mt-4">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>

    <!-- Logout form -->
    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
        <?php echo csrf_field(); ?>
    </form>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/slklwimy/public_html/internal_ticketing/resources/views/layouts/app.blade.php ENDPATH**/ ?>