<?php
/**
 * Title: Testimonials page
 * Slug: yith-wonder/testimonials-page
 * Categories: yith-wonder-pages
 * Block Types: core/post-content
 * Description: A corporate page template to show your testimonials and quotes in a masonry layout using columns.
 *
 * @package yith-wonder
 * @since 1.0.0
 */

?>
<!-- wp:group {"layout":{"contentSize":"900px"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center","fontSize":"medium"} -->
<p class="has-text-align-center has-medium-font-size"><?php echo esc_html_x( 'Fusce gravida ut nisi et facilisis. Nullam ut mi fermentum, posuere dolor id, ultricies ipsum. Duis urna ipsum, tincidunt ut lorem.', 'demo-contents', 'yith-wonder' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"130px"} -->
<div style="height:130px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"style":{"spacing":{"blockGap":"var:preset|spacing|70"}}} -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"large"} -->
<h2 class="has-large-font-size" style="font-style:normal;font-weight:600"><?php echo esc_html_x( 'Bringing value between different brands', 'demo-contents', 'yith-wonder' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php echo esc_html_x( 'Fusce gravida ut nisi et facilisis. Nullam ut mi fermentum, posuere dolor id, ultricies ipsum. Duis urna ipsum, tincidunt ut lorem.', 'demo-contents', 'yith-wonder' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40"}}},"backgroundColor":"secondary-background","textColor":"secondary-foreground"} -->
<div class="wp-block-group has-secondary-foreground-color has-secondary-background-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><!-- wp:quote {"className":"is-style-yith-wonder-quote-with-icon","fontSize":"medium"} -->
<blockquote class="wp-block-quote is-style-yith-wonder-quote-with-icon has-medium-font-size"><?php echo wp_kses_post( _x( '<p>Here I can find original items, low prices without to lose quality or sustainability. Love it!</p><cite>MARTHA RAMOS</cite>', 'demo-contents', 'yith-wonder' ) ); ?></blockquote>
<!-- /wp:quote -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:image {"align":"right","sizeSlug":"full","linkDestination":"none","className":"is-style-yith-wonder-image-creative"} -->
<figure class="wp-block-image alignright size-full is-resized is-style-yith-wonder-image-creative"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/demo-content/testimonials/testimonials-image-3.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:html -->
<div style="margin-bottom: -150px"></div>
<!-- /wp:html --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40"}}},"backgroundColor":"secondary-background","textColor":"secondary-foreground"} -->
<div class="wp-block-group has-secondary-foreground-color has-secondary-background-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><!-- wp:quote {"className":"is-style-yith-wonder-quote-with-icon","fontSize":"medium"} -->
<blockquote class="wp-block-quote is-style-yith-wonder-quote-with-icon has-medium-font-size"><?php echo wp_kses_post( _x( '<p>I don\'t usually leave reviews but I have decided to for Wonder. I love there clothing and accessories I\'ve never had a problem returning and parcels always arrive well within time stated.</p><cite>JOCELYN ERICSSON</cite>', 'demo-contents', 'yith-wonder' ) ); ?></blockquote>
<!-- /wp:quote -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:image {"align":"right","sizeSlug":"full","linkDestination":"none","className":"is-style-yith-wonder-image-creative-2"} -->
<figure class="wp-block-image alignright size-full is-resized is-style-yith-wonder-image-creative-2"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/demo-content/testimonials/testimonials-image-4.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:html -->
<div style="margin-bottom: -150px"></div>
<!-- /wp:html --></div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40"}}},"backgroundColor":"secondary-background","textColor":"secondary-foreground"} -->
<div class="wp-block-group has-secondary-foreground-color has-secondary-background-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><!-- wp:quote {"className":"is-style-yith-wonder-quote-with-icon","fontSize":"medium"} -->
<blockquote class="wp-block-quote is-style-yith-wonder-quote-with-icon has-medium-font-size"><?php echo wp_kses_post( _x( '<p>First order and will be back! Ordered 4 items and couldn\'t be happier with choices. Amazing value, will definitely be ordering more.</p><cite>PAULA PERCUSSION</cite>', 'demo-contents', 'yith-wonder' ) ); ?></blockquote>
<!-- /wp:quote -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:image {"align":"right","sizeSlug":"full","linkDestination":"none","className":"is-style-yith-wonder-image-creative"} -->
<figure class="wp-block-image alignright size-full is-resized is-style-yith-wonder-image-creative"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/demo-content/testimonials/testimonials-image-2.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:html -->
<div style="margin-bottom: -150px"></div>
<!-- /wp:html --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40"}}},"backgroundColor":"secondary-background","textColor":"secondary-foreground"} -->
<div class="wp-block-group has-secondary-foreground-color has-secondary-background-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><!-- wp:quote {"className":"is-style-yith-wonder-quote-with-icon","fontSize":"medium"} -->
<blockquote class="wp-block-quote is-style-yith-wonder-quote-with-icon has-medium-font-size"><?php echo wp_kses_post( _x( '<p>I\'m super happy with the quality and sizing of my items. Such good value for money! So stylish too. I will definitely be purchasing again!</p><cite>MIKE DANCIN</cite>', 'demo-contents', 'yith-wonder' ) ); ?></blockquote>
<!-- /wp:quote -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:image {"align":"right","sizeSlug":"full","linkDestination":"none","className":"is-style-yith-wonder-image-creative"} -->
<figure class="wp-block-image alignright size-full is-resized is-style-yith-wonder-image-creative"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/demo-content/testimonials/testimonials-image-1.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:spacer {"height":"30px"} -->
<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:html -->
<div style="margin-bottom: -150px"></div>
<!-- /wp:html --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
