/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2022-09-15 01:46:49 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int(11) DEFAULT '0',
  `actions_succeeded_count` int(11) DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=4298 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=25663 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2814 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_xyz_ips_short_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short_code` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2022-08-23 05:28:26", "2022-08-23 05:28:26", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20220915_thenationals", "e76d8f6d82fd8a761054_20220915014630", "21", "2022-09-15 01:46:49", "nationals_admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-09-15 01:46:30\";s:7:\"Version\";s:5:\"1.5.0\";s:9:\"VersionWP\";s:5:\"6.0.2\";s:9:\"VersionDB\";s:6:\"5.7.39\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:21:\"20220915_thenationals\";s:4:\"Hash\";s:35:\"e76d8f6d82fd8a761054_20220915014630\";s:8:\"NameHash\";s:57:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:67:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:15:\"nationals_admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:69:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:36:\"/home/slklwimy/public_html/nationals\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1110;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7002;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-09-15 01:46:30\";s:7:\"Version\";s:5:\"1.5.0\";s:9:\"VersionWP\";s:5:\"6.0.2\";s:9:\"VersionDB\";s:6:\"5.7.39\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20220915_thenationals\";s:4:\"Hash\";s:35:\"e76d8f6d82fd8a761054_20220915014630\";s:8:\"NameHash\";s:57:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:75:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:50:\"/home/slklwimy/public_html/nationals/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:70:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:139:\"/home/slklwimy/public_html/nationals/wp-content/backups-dup-lite/tmp/20220915_thenationals_e76d8f6d82fd8a761054_20220915014630_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:45:\"/home/slklwimy/public_html/nationals/wp-admin\";i:1;s:48:\"/home/slklwimy/public_html/nationals/wp-includes\";i:2;s:57:\"/home/slklwimy/public_html/nationals/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:36:\"/home/slklwimy/public_html/nationals\";i:1;s:36:\"/home/slklwimy/public_html/nationals\";i:2;s:47:\"/home/slklwimy/public_html/nationals/wp-content\";i:3;s:55:\"/home/slklwimy/public_html/nationals/wp-content/uploads\";i:4;s:55:\"/home/slklwimy/public_html/nationals/wp-content/plugins\";i:5;s:58:\"/home/slklwimy/public_html/nationals/wp-content/mu-plugins\";i:6;s:54:\"/home/slklwimy/public_html/nationals/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:68:\"/home/slklwimy/public_html/nationals/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://slk.lwi.mybluehost.me/nationals", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://slk.lwi.mybluehost.me/nationals", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "The Nationals", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Just another WordPress site", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "cbzncorpdedi@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:301:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"sp_result/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"sp_result/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"sp_result/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"sp_result/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"sp_result/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"sp_result/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"sp_result/([^/]+)/embed/?$\";s:42:\"index.php?sp_result=$matches[1]&embed=true\";s:30:\"sp_result/([^/]+)/trackback/?$\";s:36:\"index.php?sp_result=$matches[1]&tb=1\";s:38:\"sp_result/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?sp_result=$matches[1]&paged=$matches[2]\";s:45:\"sp_result/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?sp_result=$matches[1]&cpage=$matches[2]\";s:34:\"sp_result/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?sp_result=$matches[1]&page=$matches[2]\";s:26:\"sp_result/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"sp_result/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"sp_result/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"sp_result/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"sp_result/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"sp_result/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"sp_outcome/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"sp_outcome/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"sp_outcome/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"sp_outcome/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"sp_outcome/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"sp_outcome/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"sp_outcome/([^/]+)/embed/?$\";s:43:\"index.php?sp_outcome=$matches[1]&embed=true\";s:31:\"sp_outcome/([^/]+)/trackback/?$\";s:37:\"index.php?sp_outcome=$matches[1]&tb=1\";s:39:\"sp_outcome/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?sp_outcome=$matches[1]&paged=$matches[2]\";s:46:\"sp_outcome/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?sp_outcome=$matches[1]&cpage=$matches[2]\";s:35:\"sp_outcome/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?sp_outcome=$matches[1]&page=$matches[2]\";s:27:\"sp_outcome/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"sp_outcome/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"sp_outcome/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"sp_outcome/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"sp_outcome/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"sp_outcome/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"sp_column/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"sp_column/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"sp_column/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"sp_column/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"sp_column/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"sp_column/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"sp_column/([^/]+)/embed/?$\";s:42:\"index.php?sp_column=$matches[1]&embed=true\";s:30:\"sp_column/([^/]+)/trackback/?$\";s:36:\"index.php?sp_column=$matches[1]&tb=1\";s:38:\"sp_column/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?sp_column=$matches[1]&paged=$matches[2]\";s:45:\"sp_column/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?sp_column=$matches[1]&cpage=$matches[2]\";s:34:\"sp_column/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?sp_column=$matches[1]&page=$matches[2]\";s:26:\"sp_column/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"sp_column/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"sp_column/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"sp_column/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"sp_column/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"sp_column/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"sp_metric/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"sp_metric/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"sp_metric/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"sp_metric/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"sp_metric/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"sp_metric/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"sp_metric/([^/]+)/embed/?$\";s:42:\"index.php?sp_metric=$matches[1]&embed=true\";s:30:\"sp_metric/([^/]+)/trackback/?$\";s:36:\"index.php?sp_metric=$matches[1]&tb=1\";s:38:\"sp_metric/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?sp_metric=$matches[1]&paged=$matches[2]\";s:45:\"sp_metric/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?sp_metric=$matches[1]&cpage=$matches[2]\";s:34:\"sp_metric/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?sp_metric=$matches[1]&page=$matches[2]\";s:26:\"sp_metric/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"sp_metric/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"sp_metric/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"sp_metric/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"sp_metric/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"sp_metric/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"sp_performance/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"sp_performance/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"sp_performance/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"sp_performance/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"sp_performance/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"sp_performance/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"sp_performance/([^/]+)/embed/?$\";s:47:\"index.php?sp_performance=$matches[1]&embed=true\";s:35:\"sp_performance/([^/]+)/trackback/?$\";s:41:\"index.php?sp_performance=$matches[1]&tb=1\";s:43:\"sp_performance/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?sp_performance=$matches[1]&paged=$matches[2]\";s:50:\"sp_performance/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?sp_performance=$matches[1]&cpage=$matches[2]\";s:39:\"sp_performance/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?sp_performance=$matches[1]&page=$matches[2]\";s:31:\"sp_performance/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"sp_performance/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"sp_performance/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"sp_performance/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"sp_performance/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"sp_performance/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"sp_statistic/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"sp_statistic/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"sp_statistic/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"sp_statistic/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"sp_statistic/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"sp_statistic/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"sp_statistic/([^/]+)/embed/?$\";s:45:\"index.php?sp_statistic=$matches[1]&embed=true\";s:33:\"sp_statistic/([^/]+)/trackback/?$\";s:39:\"index.php?sp_statistic=$matches[1]&tb=1\";s:41:\"sp_statistic/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?sp_statistic=$matches[1]&paged=$matches[2]\";s:48:\"sp_statistic/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?sp_statistic=$matches[1]&cpage=$matches[2]\";s:37:\"sp_statistic/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?sp_statistic=$matches[1]&page=$matches[2]\";s:29:\"sp_statistic/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"sp_statistic/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"sp_statistic/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"sp_statistic/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"sp_statistic/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"sp_statistic/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:41:\"index.php?sp_event=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:35:\"index.php?sp_event=$matches[1]&tb=1\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?sp_event=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?sp_event=$matches[1]&cpage=$matches[2]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?sp_event=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"team/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"team/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"team/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"team/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"team/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"team/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:19:\"team/(.+?)/embed/?$\";s:40:\"index.php?sp_team=$matches[1]&embed=true\";s:23:\"team/(.+?)/trackback/?$\";s:34:\"index.php?sp_team=$matches[1]&tb=1\";s:31:\"team/(.+?)/page/?([0-9]{1,})/?$\";s:47:\"index.php?sp_team=$matches[1]&paged=$matches[2]\";s:38:\"team/(.+?)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?sp_team=$matches[1]&cpage=$matches[2]\";s:27:\"team/(.+?)(?:/([0-9]+))?/?$\";s:46:\"index.php?sp_team=$matches[1]&page=$matches[2]\";s:34:\"player/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"player/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"player/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"player/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"player/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"player/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"player/([^/]+)/embed/?$\";s:42:\"index.php?sp_player=$matches[1]&embed=true\";s:27:\"player/([^/]+)/trackback/?$\";s:36:\"index.php?sp_player=$matches[1]&tb=1\";s:35:\"player/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?sp_player=$matches[1]&paged=$matches[2]\";s:42:\"player/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?sp_player=$matches[1]&cpage=$matches[2]\";s:31:\"player/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?sp_player=$matches[1]&page=$matches[2]\";s:23:\"player/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"player/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"player/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"player/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"player/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"player/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"staff/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"staff/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"staff/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"staff/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"staff/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"staff/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"staff/([^/]+)/embed/?$\";s:41:\"index.php?sp_staff=$matches[1]&embed=true\";s:26:\"staff/([^/]+)/trackback/?$\";s:35:\"index.php?sp_staff=$matches[1]&tb=1\";s:34:\"staff/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?sp_staff=$matches[1]&paged=$matches[2]\";s:41:\"staff/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?sp_staff=$matches[1]&cpage=$matches[2]\";s:30:\"staff/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?sp_staff=$matches[1]&page=$matches[2]\";s:22:\"staff/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"staff/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"staff/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"staff/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"staff/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"staff/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"league/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?sp_league=$matches[1]&feed=$matches[2]\";s:42:\"league/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?sp_league=$matches[1]&feed=$matches[2]\";s:23:\"league/([^/]+)/embed/?$\";s:42:\"index.php?sp_league=$matches[1]&embed=true\";s:35:\"league/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?sp_league=$matches[1]&paged=$matches[2]\";s:17:\"league/([^/]+)/?$\";s:31:\"index.php?sp_league=$matches[1]\";s:47:\"season/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?sp_season=$matches[1]&feed=$matches[2]\";s:42:\"season/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?sp_season=$matches[1]&feed=$matches[2]\";s:23:\"season/([^/]+)/embed/?$\";s:42:\"index.php?sp_season=$matches[1]&embed=true\";s:35:\"season/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?sp_season=$matches[1]&paged=$matches[2]\";s:17:\"season/([^/]+)/?$\";s:31:\"index.php?sp_season=$matches[1]\";s:46:\"venue/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?sp_venue=$matches[1]&feed=$matches[2]\";s:41:\"venue/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?sp_venue=$matches[1]&feed=$matches[2]\";s:22:\"venue/([^/]+)/embed/?$\";s:41:\"index.php?sp_venue=$matches[1]&embed=true\";s:34:\"venue/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?sp_venue=$matches[1]&paged=$matches[2]\";s:16:\"venue/([^/]+)/?$\";s:30:\"index.php?sp_venue=$matches[1]\";s:49:\"position/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?sp_position=$matches[1]&feed=$matches[2]\";s:44:\"position/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?sp_position=$matches[1]&feed=$matches[2]\";s:25:\"position/([^/]+)/embed/?$\";s:44:\"index.php?sp_position=$matches[1]&embed=true\";s:37:\"position/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?sp_position=$matches[1]&paged=$matches[2]\";s:19:\"position/([^/]+)/?$\";s:33:\"index.php?sp_position=$matches[1]\";s:45:\"role/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?sp_role=$matches[1]&feed=$matches[2]\";s:40:\"role/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?sp_role=$matches[1]&feed=$matches[2]\";s:21:\"role/([^/]+)/embed/?$\";s:40:\"index.php?sp_role=$matches[1]&embed=true\";s:33:\"role/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?sp_role=$matches[1]&paged=$matches[2]\";s:15:\"role/([^/]+)/?$\";s:29:\"index.php?sp_role=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=45&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:6:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:31:\"elementor-pro/elementor-pro.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";i:4;s:51:\"insert-php-code-snippet/insert-php-code-snippet.php\";i:5;s:27:\"sportspress/sportspress.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "twentytwentyone", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "twentytwentyone", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:51:\"insert-php-code-snippet/insert-php-code-snippet.php\";s:25:\"xyz_ips_network_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "45", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1676784506", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:206:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:18:\"manage_sportspress\";b:1;s:24:\"view_sportspress_reports\";b:1;s:14:\"edit_sp_config\";b:1;s:14:\"read_sp_config\";b:1;s:16:\"delete_sp_config\";b:1;s:15:\"edit_sp_configs\";b:1;s:22:\"edit_others_sp_configs\";b:1;s:18:\"publish_sp_configs\";b:1;s:23:\"read_private_sp_configs\";b:1;s:17:\"delete_sp_configs\";b:1;s:25:\"delete_private_sp_configs\";b:1;s:27:\"delete_published_sp_configs\";b:1;s:24:\"delete_others_sp_configs\";b:1;s:23:\"edit_private_sp_configs\";b:1;s:25:\"edit_published_sp_configs\";b:1;s:22:\"manage_sp_config_terms\";b:1;s:20:\"edit_sp_config_terms\";b:1;s:22:\"delete_sp_config_terms\";b:1;s:22:\"assign_sp_config_terms\";b:1;s:13:\"edit_sp_event\";b:1;s:13:\"read_sp_event\";b:1;s:15:\"delete_sp_event\";b:1;s:14:\"edit_sp_events\";b:1;s:21:\"edit_others_sp_events\";b:1;s:17:\"publish_sp_events\";b:1;s:22:\"read_private_sp_events\";b:1;s:16:\"delete_sp_events\";b:1;s:24:\"delete_private_sp_events\";b:1;s:26:\"delete_published_sp_events\";b:1;s:23:\"delete_others_sp_events\";b:1;s:22:\"edit_private_sp_events\";b:1;s:24:\"edit_published_sp_events\";b:1;s:21:\"manage_sp_event_terms\";b:1;s:19:\"edit_sp_event_terms\";b:1;s:21:\"delete_sp_event_terms\";b:1;s:21:\"assign_sp_event_terms\";b:1;s:16:\"edit_sp_calendar\";b:1;s:16:\"read_sp_calendar\";b:1;s:18:\"delete_sp_calendar\";b:1;s:17:\"edit_sp_calendars\";b:1;s:24:\"edit_others_sp_calendars\";b:1;s:20:\"publish_sp_calendars\";b:1;s:25:\"read_private_sp_calendars\";b:1;s:19:\"delete_sp_calendars\";b:1;s:27:\"delete_private_sp_calendars\";b:1;s:29:\"delete_published_sp_calendars\";b:1;s:26:\"delete_others_sp_calendars\";b:1;s:25:\"edit_private_sp_calendars\";b:1;s:27:\"edit_published_sp_calendars\";b:1;s:24:\"manage_sp_calendar_terms\";b:1;s:22:\"edit_sp_calendar_terms\";b:1;s:24:\"delete_sp_calendar_terms\";b:1;s:24:\"assign_sp_calendar_terms\";b:1;s:12:\"edit_sp_team\";b:1;s:12:\"read_sp_team\";b:1;s:14:\"delete_sp_team\";b:1;s:13:\"edit_sp_teams\";b:1;s:20:\"edit_others_sp_teams\";b:1;s:16:\"publish_sp_teams\";b:1;s:21:\"read_private_sp_teams\";b:1;s:15:\"delete_sp_teams\";b:1;s:23:\"delete_private_sp_teams\";b:1;s:25:\"delete_published_sp_teams\";b:1;s:22:\"delete_others_sp_teams\";b:1;s:21:\"edit_private_sp_teams\";b:1;s:23:\"edit_published_sp_teams\";b:1;s:20:\"manage_sp_team_terms\";b:1;s:18:\"edit_sp_team_terms\";b:1;s:20:\"delete_sp_team_terms\";b:1;s:20:\"assign_sp_team_terms\";b:1;s:13:\"edit_sp_table\";b:1;s:13:\"read_sp_table\";b:1;s:15:\"delete_sp_table\";b:1;s:14:\"edit_sp_tables\";b:1;s:21:\"edit_others_sp_tables\";b:1;s:17:\"publish_sp_tables\";b:1;s:22:\"read_private_sp_tables\";b:1;s:16:\"delete_sp_tables\";b:1;s:24:\"delete_private_sp_tables\";b:1;s:26:\"delete_published_sp_tables\";b:1;s:23:\"delete_others_sp_tables\";b:1;s:22:\"edit_private_sp_tables\";b:1;s:24:\"edit_published_sp_tables\";b:1;s:21:\"manage_sp_table_terms\";b:1;s:19:\"edit_sp_table_terms\";b:1;s:21:\"delete_sp_table_terms\";b:1;s:21:\"assign_sp_table_terms\";b:1;s:14:\"edit_sp_player\";b:1;s:14:\"read_sp_player\";b:1;s:16:\"delete_sp_player\";b:1;s:15:\"edit_sp_players\";b:1;s:22:\"edit_others_sp_players\";b:1;s:18:\"publish_sp_players\";b:1;s:23:\"read_private_sp_players\";b:1;s:17:\"delete_sp_players\";b:1;s:25:\"delete_private_sp_players\";b:1;s:27:\"delete_published_sp_players\";b:1;s:24:\"delete_others_sp_players\";b:1;s:23:\"edit_private_sp_players\";b:1;s:25:\"edit_published_sp_players\";b:1;s:22:\"manage_sp_player_terms\";b:1;s:20:\"edit_sp_player_terms\";b:1;s:22:\"delete_sp_player_terms\";b:1;s:22:\"assign_sp_player_terms\";b:1;s:12:\"edit_sp_list\";b:1;s:12:\"read_sp_list\";b:1;s:14:\"delete_sp_list\";b:1;s:13:\"edit_sp_lists\";b:1;s:20:\"edit_others_sp_lists\";b:1;s:16:\"publish_sp_lists\";b:1;s:21:\"read_private_sp_lists\";b:1;s:15:\"delete_sp_lists\";b:1;s:23:\"delete_private_sp_lists\";b:1;s:25:\"delete_published_sp_lists\";b:1;s:22:\"delete_others_sp_lists\";b:1;s:21:\"edit_private_sp_lists\";b:1;s:23:\"edit_published_sp_lists\";b:1;s:20:\"manage_sp_list_terms\";b:1;s:18:\"edit_sp_list_terms\";b:1;s:20:\"delete_sp_list_terms\";b:1;s:20:\"assign_sp_list_terms\";b:1;s:13:\"edit_sp_staff\";b:1;s:13:\"read_sp_staff\";b:1;s:15:\"delete_sp_staff\";b:1;s:14:\"edit_sp_staffs\";b:1;s:21:\"edit_others_sp_staffs\";b:1;s:17:\"publish_sp_staffs\";b:1;s:22:\"read_private_sp_staffs\";b:1;s:16:\"delete_sp_staffs\";b:1;s:24:\"delete_private_sp_staffs\";b:1;s:26:\"delete_published_sp_staffs\";b:1;s:23:\"delete_others_sp_staffs\";b:1;s:22:\"edit_private_sp_staffs\";b:1;s:24:\"edit_published_sp_staffs\";b:1;s:21:\"manage_sp_staff_terms\";b:1;s:19:\"edit_sp_staff_terms\";b:1;s:21:\"delete_sp_staff_terms\";b:1;s:21:\"assign_sp_staff_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:9:\"sp_player\";a:2:{s:4:\"name\";s:6:\"Player\";s:12:\"capabilities\";a:21:{s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:12:\"delete_posts\";b:1;s:10:\"edit_posts\";b:1;s:12:\"upload_files\";b:1;s:14:\"edit_sp_player\";b:1;s:14:\"read_sp_player\";b:1;s:15:\"edit_sp_players\";b:1;s:25:\"edit_published_sp_players\";b:1;s:22:\"assign_sp_player_terms\";b:1;s:13:\"edit_sp_event\";b:1;s:13:\"read_sp_event\";b:1;s:14:\"edit_sp_events\";b:1;s:24:\"edit_published_sp_events\";b:1;s:21:\"assign_sp_event_terms\";b:1;s:12:\"edit_sp_team\";b:1;s:12:\"read_sp_team\";b:1;s:13:\"edit_sp_teams\";b:1;s:23:\"edit_published_sp_teams\";b:1;s:20:\"assign_sp_team_terms\";b:1;}}s:8:\"sp_staff\";a:2:{s:4:\"name\";s:5:\"Staff\";s:12:\"capabilities\";a:26:{s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:12:\"delete_posts\";b:1;s:10:\"edit_posts\";b:1;s:12:\"upload_files\";b:1;s:13:\"edit_sp_staff\";b:1;s:13:\"read_sp_staff\";b:1;s:14:\"edit_sp_staffs\";b:1;s:24:\"edit_published_sp_staffs\";b:1;s:21:\"assign_sp_staff_terms\";b:1;s:13:\"edit_sp_event\";b:1;s:13:\"read_sp_event\";b:1;s:14:\"edit_sp_events\";b:1;s:24:\"edit_published_sp_events\";b:1;s:21:\"assign_sp_event_terms\";b:1;s:12:\"edit_sp_team\";b:1;s:12:\"read_sp_team\";b:1;s:13:\"edit_sp_teams\";b:1;s:23:\"edit_published_sp_teams\";b:1;s:20:\"assign_sp_team_terms\";b:1;s:14:\"edit_sp_player\";b:1;s:14:\"read_sp_player\";b:1;s:15:\"edit_sp_players\";b:1;s:25:\"edit_published_sp_players\";b:1;s:22:\"assign_sp_player_terms\";b:1;}}s:16:\"sp_event_manager\";a:2:{s:4:\"name\";s:13:\"Event Manager\";s:12:\"capabilities\";a:35:{s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:12:\"delete_posts\";b:1;s:10:\"edit_posts\";b:1;s:12:\"upload_files\";b:1;s:17:\"manage_categories\";b:1;s:13:\"edit_sp_event\";b:1;s:13:\"read_sp_event\";b:1;s:15:\"delete_sp_event\";b:1;s:14:\"edit_sp_events\";b:1;s:21:\"edit_others_sp_events\";b:1;s:17:\"publish_sp_events\";b:1;s:16:\"delete_sp_events\";b:1;s:26:\"delete_published_sp_events\";b:1;s:24:\"edit_published_sp_events\";b:1;s:21:\"manage_sp_event_terms\";b:1;s:19:\"edit_sp_event_terms\";b:1;s:21:\"delete_sp_event_terms\";b:1;s:21:\"assign_sp_event_terms\";b:1;s:12:\"edit_sp_team\";b:1;s:12:\"read_sp_team\";b:1;s:13:\"edit_sp_teams\";b:1;s:23:\"edit_published_sp_teams\";b:1;s:20:\"assign_sp_team_terms\";b:1;s:14:\"edit_sp_player\";b:1;s:14:\"read_sp_player\";b:1;s:15:\"edit_sp_players\";b:1;s:25:\"edit_published_sp_players\";b:1;s:22:\"assign_sp_player_terms\";b:1;s:13:\"edit_sp_staff\";b:1;s:13:\"read_sp_staff\";b:1;s:14:\"edit_sp_staffs\";b:1;s:24:\"edit_published_sp_staffs\";b:1;s:21:\"assign_sp_staff_terms\";b:1;}}s:15:\"sp_team_manager\";a:2:{s:4:\"name\";s:12:\"Team Manager\";s:12:\"capabilities\";a:57:{s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:12:\"delete_posts\";b:1;s:10:\"edit_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:12:\"upload_files\";b:1;s:20:\"edit_published_posts\";b:1;s:14:\"edit_sp_player\";b:1;s:14:\"read_sp_player\";b:1;s:16:\"delete_sp_player\";b:1;s:15:\"edit_sp_players\";b:1;s:22:\"edit_others_sp_players\";b:1;s:18:\"publish_sp_players\";b:1;s:17:\"delete_sp_players\";b:1;s:27:\"delete_published_sp_players\";b:1;s:25:\"edit_published_sp_players\";b:1;s:22:\"assign_sp_player_terms\";b:1;s:13:\"edit_sp_staff\";b:1;s:13:\"read_sp_staff\";b:1;s:15:\"delete_sp_staff\";b:1;s:14:\"edit_sp_staffs\";b:1;s:21:\"edit_others_sp_staffs\";b:1;s:17:\"publish_sp_staffs\";b:1;s:16:\"delete_sp_staffs\";b:1;s:26:\"delete_published_sp_staffs\";b:1;s:24:\"edit_published_sp_staffs\";b:1;s:21:\"assign_sp_staff_terms\";b:1;s:13:\"edit_sp_event\";b:1;s:13:\"read_sp_event\";b:1;s:15:\"delete_sp_event\";b:1;s:14:\"edit_sp_events\";b:1;s:21:\"edit_others_sp_events\";b:1;s:17:\"publish_sp_events\";b:1;s:16:\"delete_sp_events\";b:1;s:26:\"delete_published_sp_events\";b:1;s:24:\"edit_published_sp_events\";b:1;s:21:\"manage_sp_event_terms\";b:1;s:19:\"edit_sp_event_terms\";b:1;s:21:\"delete_sp_event_terms\";b:1;s:21:\"assign_sp_event_terms\";b:1;s:12:\"edit_sp_team\";b:1;s:12:\"read_sp_team\";b:1;s:13:\"edit_sp_teams\";b:1;s:23:\"edit_published_sp_teams\";b:1;s:20:\"assign_sp_team_terms\";b:1;s:12:\"edit_sp_list\";b:1;s:12:\"read_sp_list\";b:1;s:14:\"delete_sp_list\";b:1;s:13:\"edit_sp_lists\";b:1;s:16:\"publish_sp_lists\";b:1;s:15:\"delete_sp_lists\";b:1;s:25:\"delete_published_sp_lists\";b:1;s:23:\"edit_published_sp_lists\";b:1;s:20:\"assign_sp_list_terms\";b:1;}}s:17:\"sp_league_manager\";a:2:{s:4:\"name\";s:14:\"League Manager\";s:12:\"capabilities\";a:176:{s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_sportspress\";b:1;s:24:\"view_sportspress_reports\";b:1;s:14:\"edit_sp_config\";b:1;s:14:\"read_sp_config\";b:1;s:16:\"delete_sp_config\";b:1;s:15:\"edit_sp_configs\";b:1;s:22:\"edit_others_sp_configs\";b:1;s:18:\"publish_sp_configs\";b:1;s:23:\"read_private_sp_configs\";b:1;s:17:\"delete_sp_configs\";b:1;s:25:\"delete_private_sp_configs\";b:1;s:27:\"delete_published_sp_configs\";b:1;s:24:\"delete_others_sp_configs\";b:1;s:23:\"edit_private_sp_configs\";b:1;s:25:\"edit_published_sp_configs\";b:1;s:22:\"manage_sp_config_terms\";b:1;s:20:\"edit_sp_config_terms\";b:1;s:22:\"delete_sp_config_terms\";b:1;s:22:\"assign_sp_config_terms\";b:1;s:13:\"edit_sp_event\";b:1;s:13:\"read_sp_event\";b:1;s:15:\"delete_sp_event\";b:1;s:14:\"edit_sp_events\";b:1;s:21:\"edit_others_sp_events\";b:1;s:17:\"publish_sp_events\";b:1;s:22:\"read_private_sp_events\";b:1;s:16:\"delete_sp_events\";b:1;s:24:\"delete_private_sp_events\";b:1;s:26:\"delete_published_sp_events\";b:1;s:23:\"delete_others_sp_events\";b:1;s:22:\"edit_private_sp_events\";b:1;s:24:\"edit_published_sp_events\";b:1;s:21:\"manage_sp_event_terms\";b:1;s:19:\"edit_sp_event_terms\";b:1;s:21:\"delete_sp_event_terms\";b:1;s:21:\"assign_sp_event_terms\";b:1;s:16:\"edit_sp_calendar\";b:1;s:16:\"read_sp_calendar\";b:1;s:18:\"delete_sp_calendar\";b:1;s:17:\"edit_sp_calendars\";b:1;s:24:\"edit_others_sp_calendars\";b:1;s:20:\"publish_sp_calendars\";b:1;s:25:\"read_private_sp_calendars\";b:1;s:19:\"delete_sp_calendars\";b:1;s:27:\"delete_private_sp_calendars\";b:1;s:29:\"delete_published_sp_calendars\";b:1;s:26:\"delete_others_sp_calendars\";b:1;s:25:\"edit_private_sp_calendars\";b:1;s:27:\"edit_published_sp_calendars\";b:1;s:24:\"manage_sp_calendar_terms\";b:1;s:22:\"edit_sp_calendar_terms\";b:1;s:24:\"delete_sp_calendar_terms\";b:1;s:24:\"assign_sp_calendar_terms\";b:1;s:12:\"edit_sp_team\";b:1;s:12:\"read_sp_team\";b:1;s:14:\"delete_sp_team\";b:1;s:13:\"edit_sp_teams\";b:1;s:20:\"edit_others_sp_teams\";b:1;s:16:\"publish_sp_teams\";b:1;s:21:\"read_private_sp_teams\";b:1;s:15:\"delete_sp_teams\";b:1;s:23:\"delete_private_sp_teams\";b:1;s:25:\"delete_published_sp_teams\";b:1;s:22:\"delete_others_sp_teams\";b:1;s:21:\"edit_private_sp_teams\";b:1;s:23:\"edit_published_sp_teams\";b:1;s:20:\"manage_sp_team_terms\";b:1;s:18:\"edit_sp_team_terms\";b:1;s:20:\"delete_sp_team_terms\";b:1;s:20:\"assign_sp_team_terms\";b:1;s:13:\"edit_sp_table\";b:1;s:13:\"read_sp_table\";b:1;s:15:\"delete_sp_table\";b:1;s:14:\"edit_sp_tables\";b:1;s:21:\"edit_others_sp_tables\";b:1;s:17:\"publish_sp_tables\";b:1;s:22:\"read_private_sp_tables\";b:1;s:16:\"delete_sp_tables\";b:1;s:24:\"delete_private_sp_tables\";b:1;s:26:\"delete_published_sp_tables\";b:1;s:23:\"delete_others_sp_tables\";b:1;s:22:\"edit_private_sp_tables\";b:1;s:24:\"edit_published_sp_tables\";b:1;s:21:\"manage_sp_table_terms\";b:1;s:19:\"edit_sp_table_terms\";b:1;s:21:\"delete_sp_table_terms\";b:1;s:21:\"assign_sp_table_terms\";b:1;s:14:\"edit_sp_player\";b:1;s:14:\"read_sp_player\";b:1;s:16:\"delete_sp_player\";b:1;s:15:\"edit_sp_players\";b:1;s:22:\"edit_others_sp_players\";b:1;s:18:\"publish_sp_players\";b:1;s:23:\"read_private_sp_players\";b:1;s:17:\"delete_sp_players\";b:1;s:25:\"delete_private_sp_players\";b:1;s:27:\"delete_published_sp_players\";b:1;s:24:\"delete_others_sp_players\";b:1;s:23:\"edit_private_sp_players\";b:1;s:25:\"edit_published_sp_players\";b:1;s:22:\"manage_sp_player_terms\";b:1;s:20:\"edit_sp_player_terms\";b:1;s:22:\"delete_sp_player_terms\";b:1;s:22:\"assign_sp_player_terms\";b:1;s:12:\"edit_sp_list\";b:1;s:12:\"read_sp_list\";b:1;s:14:\"delete_sp_list\";b:1;s:13:\"edit_sp_lists\";b:1;s:20:\"edit_others_sp_lists\";b:1;s:16:\"publish_sp_lists\";b:1;s:21:\"read_private_sp_lists\";b:1;s:15:\"delete_sp_lists\";b:1;s:23:\"delete_private_sp_lists\";b:1;s:25:\"delete_published_sp_lists\";b:1;s:22:\"delete_others_sp_lists\";b:1;s:21:\"edit_private_sp_lists\";b:1;s:23:\"edit_published_sp_lists\";b:1;s:20:\"manage_sp_list_terms\";b:1;s:18:\"edit_sp_list_terms\";b:1;s:20:\"delete_sp_list_terms\";b:1;s:20:\"assign_sp_list_terms\";b:1;s:13:\"edit_sp_staff\";b:1;s:13:\"read_sp_staff\";b:1;s:15:\"delete_sp_staff\";b:1;s:14:\"edit_sp_staffs\";b:1;s:21:\"edit_others_sp_staffs\";b:1;s:17:\"publish_sp_staffs\";b:1;s:22:\"read_private_sp_staffs\";b:1;s:16:\"delete_sp_staffs\";b:1;s:24:\"delete_private_sp_staffs\";b:1;s:26:\"delete_published_sp_staffs\";b:1;s:23:\"delete_others_sp_staffs\";b:1;s:22:\"edit_private_sp_staffs\";b:1;s:24:\"edit_published_sp_staffs\";b:1;s:21:\"manage_sp_staff_terms\";b:1;s:19:\"edit_sp_staff_terms\";b:1;s:21:\"delete_sp_staff_terms\";b:1;s:21:\"assign_sp_staff_terms\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:7:{i:1663208906;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1663219706;a:5:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1663219719;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1663222309;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1663222371;a:1:{s:31:\"eael_remove_unused_options_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1663738106;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "theme_mods_twentytwentytwo", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1661236498;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}s:18:\"nav_menu_locations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("124", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("125", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4257", "_site_transient_timeout_theme_roots", "1663207978", "no");
INSERT INTO `wp_options` VALUES("4258", "_site_transient_theme_roots", "a:3:{s:12:\"twentytwenty\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("131", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1663206305;s:7:\"checked\";a:3:{s:12:\"twentytwenty\";s:3:\"2.0\";s:15:\"twentytwentyone\";s:3:\"1.6\";s:15:\"twentytwentytwo\";s:3:\"1.2\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.2.0.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.6.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.2.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("3287", "xyz_ips_sort_order", "desc", "yes");
INSERT INTO `wp_options` VALUES("3288", "xyz_ips_sort_field_name", "id", "yes");
INSERT INTO `wp_options` VALUES("153", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("4278", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1663249473", "no");
INSERT INTO `wp_options` VALUES("4279", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1663206273", "no");
INSERT INTO `wp_options` VALUES("4280", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1663249473", "no");
INSERT INTO `wp_options` VALUES("4281", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: WooCommerce 6.9 Released, High-Performance Order Storage Targeted for 7.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137816\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/woocommerce-6-9-released-high-performance-order-storage-targeted-for-7-1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3877:\"<p><a href=\"https://developer.woocommerce.com/2022/09/14/woocommerce-6-9-released/\">WooCommerce 6.9</a> was released today and was quickly followed up with <a href=\"https://developer.woocommerce.com/2022/09/14/woocommerce-6-9-1-fix-release/\">6.9.1</a> after a bug caused some stores to produce a warning or a fatal error, depending on the site&#8217;s PHP version. </p>\n\n\n\n<p>This release brings the new Cart and Checkout blocks into core as beta features. These blocks have been available in the <a href=\"https://woocommerce.com/products/woocommerce-gutenberg-products-block/\">WooCommerce Blocks plugin</a> since version 2.6 was released in May 2020. They enable store owners to better customize the purchase flow experience with the power of blocks. </p>\n\n\n\n<p>After two years of testing, the Cart and Checkout blocks are <a href=\"https://woocommerce.com/document/cart-checkout-blocks-support-status/\">compatible</a> with more than a dozen payment gateways and shipping options, as well as 19 popular extensions.</p>\n\n\n\n<img />\n\n\n\n<p>WooCommerce 6.9 improves filtering products by updating the URL (without reloading the page) when visitors use filters with the All Products blocks. Dropdown attribute filters now allow for users to select multiple terms when the query type is set to <code>AND</code>.</p>\n\n\n\n<p>As the core team warned last month, <a href=\"https://wptavern.com/woocommerce-to-stop-registering-customizer-options-in-upcoming-6-9-release\">WooCommerce will no longer register Customizer options when a block theme is active</a> as of version 6.9.</p>\n\n\n\n<p>These are just a few highlights from the 6.9 release, which includes 90 fixes, additions, updates, enhancements, tweaks, and more, from 39 contributors. Check out the <a href=\"https://github.com/woocommerce/woocommerce/blob/release/6.9/changelog.txt\">6.9 changelog</a> for all the details.</p>\n\n\n\n<p>The WooCommerce development team also published a <a href=\"https://developer.woocommerce.com/2022/09/14/high-performance-order-storage-progress-report/\">progress report</a> on the High-Performance Order Storage (HPOS) project, more commonly known as custom order tables. This long-awaited improvement promises significant performance gains for stores. It is a major change that will impact extension developers in different ways. In May, WooCommerce core developers <a href=\"https://wptavern.com/woocommerce-calls-for-early-testing-on-custom-order-table-migrations\">called for early testing on custom order table migrations</a>.</p>\n\n\n\n<p>&#8220;We’ve decided to rename Custom Order Tables to <em>High-Performance Order Storage</em> to make it more clear and more understandable what this change is about and what it should bring everyone,&#8221; WooCommerce core team lead Peter Fabian  said. &#8220;We want our users to understand the why of our work more easily. We also understand that the original name has been around for a long time and some people might still prefer it over the new one, and that is, of course, fine.&#8221;</p>\n\n\n\n<p>WooCommerce has been testing HPOS extensively and has started upgrading Woo-owned extensions. The team plans to present a feature complete version in WooCommerce 7.1, which is expected in November.</p>\n\n\n\n<p>&#8220;This timeline depends on the number of defects we discover during the testing phase,&#8221; Fabian said. &#8220;Also note that this means the core implementation is production ready, not necessarily that every extension or plugin a site may use is compatible yet.&#8221;</p>\n\n\n\n<p>When HPOS makes its debut in WooCommerce core, it will be strictly opt-in as the rest of the extension ecosystem works to make their plugins compatible. As greater numbers of WooCommerce products adopt HPOS, core will be able to turn it on by default. Fabian said his team expects that HPOS could become the default experience for stores by August 2023.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Sep 2022 21:51:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"Post Status: WP 6.1 walkthrough replay • WebP no go • Matt: Core needs to be more editorial • Survey: How do you learn WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=121827\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"https://poststatus.com/wp-6-1-walkthrough-replay-webp-no-go-matt-core-needs-to-be-more-editorial-survey-how-do-you-learn-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16901:\"<h2 id=\"h-this-week-at-wordpress-org-september-12-2022\">This Week at WordPress.org (September 12, 2022)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">WordPress 6.1 walkthrough replay • Matt: WebP no go • Matt: Core needs to be more editorial • Survey: How do you learn WordPress? </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div id=\"kt-info-box_b3b811-01\" class=\"wp-block-kadence-infobox\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kt-info-svg-icon kt-info-svg-icon-ic_ban\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\"><a href=\"https://make.wordpress.org/core/2022/08/10/proposal-stop-merging-experimental-apis-from-gutenberg-to-wordpress-core/\">WP 6.1 Feature Freeze 1 Week to Go</a></h2><p class=\"kt-blocks-info-box-text\">WordPress Beta 1 & Feature Freeze is <a href=\"https://make.wordpress.org/core/2022/07/26/wordpress-6-1-planning-roundup-v2/\">coming on September 20</a>. Here\'s what we know so far:<br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f6b6-1f3fb-200d-2642-fe0f.png\" alt=\"🚶🏻‍♂️\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/09/14/6-1-product-walk-through-recap/\">6.1 Product Walk-Through Recap</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f50c.png\" alt=\"🔌\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">Matt: Core needs to be more editorial</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4f8.png\" alt=\"📸\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/09/11/webp-in-core-for-6-1/\">Matt: WebP no go for Core for 6.1</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4da.png\" alt=\"📚\" class=\"wp-smiley\" /> <a href=\"Survey: How did you learn WordPress?\">Survey: How did you learn WordPress?</a><br /><br /></p></div></div></div>\n\n\n\n<h2 id=\"h-news\">News</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/news/2022/09/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\">Dropping security updates for WordPress versions 3.7 through 4.0</a></li></ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_598f7a-1a\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"wp-container-3 wp-block-columns\">\n<div class=\"wp-container-1 wp-block-column\">\n<h2 id=\"h-accessibility\"><a href=\"https://make.wordpress.org/accessibility\">Accessibility</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/accessibility/2022/08/29/use-of-accessibility-ready-tag-for-block-based-themes/\">Use of accessibility-ready tag for block-based themes</a></li></ul>\n\n\n\n<h2 id=\"h-community\">Community</h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/community/2022/08/31/wordpress-events-organiser-training/\">WordPress Events Organiser Training</a></li><li><a href=\"https://make.wordpress.org/community/2022/08/15/call-for-ideas-wordcamp-us-2022-contributor-day/\">Call for Ideas: WordCamp US 2022 Contributor Day</a></li><li><a href=\"https://us.wordcamp.org/2022/what-is-contributor-day/\">What is Contributor Day?</a></li></ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/09/14/6-1-product-walk-through-recap/\">6.1 Product Walk-Through Recap</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/12/lets-make-wordpress-officially-support-sqlite/\">Let’s make WordPress officially support SQLite</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/11/new-is_login_screen-function-for-determining-if-a-page-is-the-login-screen/\">New is_login_screen() function for determining if a page is the login screen</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">Canonical Plugins Revisited</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/11/webp-in-core-for-6-1/\">WebP in Core for 6.1</a></li></ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/09/14/dev-chat-agenda-september-13-2022/\">Dev Chat Agenda, September 13, 2022</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/13/editor-chat-agenda-14th-september-2022/\">Editor Chat Agenda: 14th September 2022</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/11/devchat-summary-september-11-2022/\">Devchat summary, September 11, 2022</a></li></ul>\n\n\n\n<h2 id=\"h-design\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/design/2022/09/12/design-share-aug-28-sep-9/\">Design Share: Aug 28-Sep 9</a></li><li><a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\">TT3 default theme: Announcing style variation selections</a></li></ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/docs/2022/09/14/agenda-for-docs-team-bi-weekly-meeting-27-september-2022/\">Agenda for Docs Team Bi-Weekly Meeting 27 September 2022</a></li><li><a href=\"https://make.wordpress.org/docs/2022/09/14/summary-of-docs-team-meeting-september-13-2022/\">Summary of Docs Team Meeting September 13, 2022</a></li><li><a href=\"https://make.wordpress.org/docs/2022/08/30/summary-of-docs-team-biweekly-meeting-august-30-2022/#:~:text=Tracker/issues/225-,Advanced,-Admin\">WordPress Advanced Administration Handbook</a></li></ul>\n\n\n\n<h3 id=\"h-developer-articles-devhub\">Developer Articles (DevHub)</h3>\n\n\n\n<ul><li><a href=\"https://developer.wordpress.org/block-editor/reference-guides/filters/global-styles-filters/\">Global Styles Filters</a></li><li><a href=\"https://developer.wordpress.org/themes/basics/tools-resources/\">Tools & Resources</a></li><li><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/propagating-updates/\">Propagating updates for block types</a></li></ul>\n\n\n\n<h2><a href=\"https://wordpress.org/five-for-the-future/\">Five for the Future</a></h2>\n\n\n\n<ul><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/214\">Deactivate inactive pledges</a></li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/212\">Remove contributor hours when account banned</a>&nbsp;</li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/210\">Use last 5ftF contribution as inactivity criteria</a></li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/208\">Hyperlink not readable on Program Expectations page</a></li></ul>\n\n\n\n<h2 id=\"h-hosting\">Hosting</h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/hosting/2022/09/11/wordcamp-us-2022-contributor-day-summary/\">WordCamp US 2022 Contributor Day: Summary</a></li></ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/marketing/2022/09/14/agenda-wordpress-global-marketing-team-meeting-september-14-2022/\">Agenda, WordPress global Marketing Team meeting, September 14, 2022</a></li><li><a href=\"https://make.wordpress.org/marketing/2022/09/13/notes-wordpress-global-marketing-team-meeting-september-07-2022/\">Notes, WordPress global Marketing Team meeting, September 7, 2022</a></li></ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/meta/2022/09/05/improving-devhub-code-references/\">Improving DevHub Code References</a></li><li><a href=\"https://make.wordpress.org/meta/2022/09/01/simplifying-the-admin-bar-global-navigation-menu/\">Simplifying the Admin Bar & Global Navigation Menu</a></li></ul>\n</div>\n\n\n\n<div class=\"wp-container-2 wp-block-column\">\n<h2 id=\"h-mobile\">Mobile</h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/mobile/2022/09/11/call-for-testing-wordpress-for-android-20-7/\">Call for Testing: WordPress for Android 20.7</a></li><li><a href=\"https://make.wordpress.org/mobile/2022/09/06/call-for-testing-wordpress-for-ios-20-7/\">Call for Testing: WordPress for iOS 20.7</a></li><li><a href=\"https://make.wordpress.org/updates/2022/09/06/mobile-team-update-september-6th/\">Mobile Team Update – September 6th</a></li></ul>\n\n\n\n<h2 id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/openverse/2022/09/13/community-meeting-recap-13-september-2022/\">Community Meeting Recap (13 September 2022)</a></li><li><a href=\"https://make.wordpress.org/openverse/2022/09/07/frontend-release-v3-4-8-and-a-call-for-a11y-testing/\">Frontend Release v3.4.8 and a call for a11y testing</a></li></ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/09/13/performance-team-meeting-summary-13-september-2022/\">Performance team meeting summary 13 September 2022</a></li></ul>\n\n\n\n<h2 id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/plugins/2022/09/13/heroku-free-tier-being-retired/\">Heroku Free Tier Being Retired</a></li><li><a href=\"https://make.wordpress.org/plugins/2022/09/09/top-reasons-not-to-use-setlocale-for-character-encoding-conversion/\">Top reasons not to use setlocale() for character encoding conversion</a></li><li><a href=\"https://make.wordpress.org/updates/2022/09/13/plugin-review-team-12-sept-2022/\">Plugin Review Team: 12 Sept 2022</a></li></ul>\n\n\n\n<h2 id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/polyglots/2022/09/13/weekly-polyglots-chat-september-14-2022-1300-utc/\">Weekly Polyglots Chat – September. 14, 2022 (13:00 UTC)</a></li></ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/themes/2022/09/12/testing-and-feedback-for-using-block-based-template-parts-in-classic-themes/\">Testing and Feedback for using block based template parts in classic themes</a></li><li><a href=\"https://make.wordpress.org/updates/2022/09/12/test-team-update-12-september-2022/\">Test Team Update: 12 September 2022</a></li></ul>\n\n\n\n<h2 id=\"h-themes\"><a href=\"https://make.wordpress.org/themes\">Themes</a></h2>\n\n\n\n<ul><li><strong><a href=\"https://make.wordpress.org/themes/2022/09/12/testing-and-feedback-for-using-block-based-template-parts-in-classic-themes/\">Testing and Feedback for using block based template parts in classic themes</a></strong></li><li><a href=\"https://make.wordpress.org/updates/2022/09/14/themes-team-update-september-14-2022/\">Themes team update September 14, 2022</a></li></ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/individual-learner-survey/\">How did you learn WordPress?</a></li><li><a href=\"https://make.wordpress.org/training/2022/09/14/training-team-meeting-recap-for-september-13-2022/\">Training Team Meeting Recap for September 13, 2022</a></li><li><a href=\"https://make.wordpress.org/training/2022/09/14/discussion-reimagining-the-training-team-contributor-roles/\">[Discussion] Reimagining the Training Team contributor roles</a></li><li><a href=\"https://make.wordpress.org/training/2022/09/13/august-sprint-retrospective/\">August Sprint Retrospective</a></li><li><a href=\"https://make.wordpress.org/training/2022/09/12/meeting-agenda-for-september-14-2022/\">Meeting Agenda for September 14, 2022</a></li><li><a href=\"https://make.wordpress.org/training/2022/09/11/wordcamp-us-2022/\">WordCamp US 2022</a></li></ul>\n\n\n\n<h3 id=\"h-video-tutorials\">Video Tutorials</h3>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/tutorial/customizing-a-footer-with-patterns/\">Customizing a footer with patterns</a></li><li><a href=\"https://learn.wordpress.org/tutorial/styling-your-wordpress-block/\">Styling your WordPress Blocks</a></li><li><a href=\"https://learn.wordpress.org/tutorial/customizing-a-header-with-patterns/\">Customizing a header with patterns</a></li><li><a href=\"https://learn.wordpress.org/tutorial/converting-a-shortcode-into-a-block/\">Converting a Shortcode into a&nbsp;Block</a></li></ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops:</h3>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/?meeting=lets-code-what-happens-when-you-make-theme-changes-in-the-editor\">Let’s code! What Happens When You Make Theme Changes in the Editor?</a></li><li><a href=\"https://learn.wordpress.org/?meeting=security\">Security</a></li><li><a href=\"https://learn.wordpress.org/?meeting=uncovering-the-cover-block\">Uncovering the Cover Block</a></li><li><a href=\"https://learn.wordpress.org/?meeting=lets-build-a-custom-block-in-one-hour\">Let’s Build a Custom Block in One Hour</a></li><li><a href=\"https://learn.wordpress.org/?meeting=block-theme-builders-choosing-using-fonts\">Block Theme Builders: Choosing & Using Fonts</a></li><li><a href=\"https://learn.wordpress.org/?meeting=block-theme-global-styles-customization\">Block & Theme Global Styles Customization</a></li><li><a href=\"https://learn.wordpress.org/?meeting=all-about-reusable-blocks\">All About Reusable Blocks</a></li><li><a href=\"https://learn.wordpress.org/?meeting=lets-code-a-beginners-guide-to-block-locking-in-block-themes\">Let’s code! A Beginners Guide to Block Locking in Block Themes</a><a href=\"https://github.com/courtneyr-dev/make-wp/#test\"></a></li></ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li></ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul><li><a href=\"https://thephp.foundation/blog/2022/08/30/php-core-roundup-5/\">PHP Core Roundup #5</a></li><li><a href=\"https://tc39.es/#proposals\">ECMAScript Proposals</a></li></ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/business-membership/\">your whole team</a> can <a href=\"https://poststatus.com/post-status-membership-club/\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Sep 2022 19:22:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: #42 – Marcel Schmitz on Finding Work With Codeable and Working With WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=137320\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/podcast/42-marcel-schmitz-on-finding-work-with-codeable-and-working-with-woocommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:40987:\"<p>On the podcast today we have <a href=\"https://profiles.wordpress.org/schmitzoide/\">Marcel Schmitz</a>.</p>\n\n\n\n<p>Marcel is a freelancer at <a href=\"https://www.codeable.io/\">Codeable</a> for <a href=\"https://pluginslab.com/\">Pluginslab</a>, a small agency based in Porto, Portugal, which by good coincidence is where WordCamp Europe took place this year.</p>\n\n\n\n<p>He first got first involved with WordPress back in 2011, taking advantage of the platform because it was easy to make client websites; not having to create a complete CMS solution from scratch. It&#8217;s been an unbreakable relationship since then. However, it&#8217;s been a journey of constant change. Mobile came along, and Marcel’s been connecting apps to WordPress since 2012, building mobile apps that use AR and Gutenberg to connect with WooCommerce.</p>\n\n\n\n<p>We talk on the podcast today about the opportunities Codeable has offered him and how it fits in with his life. As you’ll hear, he’s pretty keen on the fact that it gives him a reliable stream of work without the need for him to go out and find it.</p>\n\n\n\n<p>Codeable is a platform which connects developers with clients needing work. They find the clients, and the developer does the work. But what’s really involved in this transaction? What kind of work is available on the platform? Who can join, and how can Codeable and the clients both be sure that the developers are qualified and able to carry out the projects that they take on?</p>\n\n\n\n<p>Marcel certainly seems to have had a very positive experience with Codeable and explains the nuts and bolts of how you get started, what developers need to bring to the table and how Codeable mediates disputes which might arise.</p>\n\n\n\n<p>Towards the end of the podcast, we talk about Marcel’s work using AR and WooCommerce, as well as a brief foray into how he sees headless WordPress working with WooCommerce in the future; what are the benefits and what are some of the drawbacks?</p>\n\n\n\n<p>Typically, when we record the podcast, there’s not a lot of background noise, but that’s not always the case with these WordCamp Europe interviews. We were competing against crowds and the air-conditioning. Whilst the podcasts are more than listenable, I hope that you understand that the vagaries of the real world were at play.</p>\n\n\n\n<h2>Useful links.</h2>\n\n\n\n<p><a href=\"https://www.codeable.io/\">Codeable</a></p>\n\n\n\n<p><a href=\"https://woocommerce.com/\">WooCommerce</a></p>\n\n\n\nTranscript<div>\n<p>[00:00:00] Nathan Wrigley: Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox as a podcast, which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case finding WooCommerce work through Codeable.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy and paste that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m very keen to hear from you and hopefully get you all your idea featured on the show. Head over to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Marcel Schmitz. Marcel is a freelancer at Codeable for pluginslab, a small agency based in Porto, Portugal, which by good coincidence is where WordCamp Europe took place this year.</p>\n\n\n\n<p>He first got involved with WordPress back in 2011, taking advantage of the platform because it was easy to create clients&#8217; websites, not having to create a complete CMS solution from scratch.</p>\n\n\n\n<p>It&#8217;s been an unbreakable relationship since then. However, it&#8217;s been a journey of constant change. Mobile came along, and Marcel&#8217;s been connecting apps to WordPress since 2012. Building mobile apps that use AR and Gutenberg to connect with WooCommerce.</p>\n\n\n\n<p>We talk on the podcast today about the opportunities Codeable has afforded him and how it fits in with his life. As you&#8217;ll hear, he&#8217;s pretty keen on the fact that it gives him a reliable stream of work without the need for him to go out and find it.</p>\n\n\n\n<p>Codeable is a platform which connects developers with clients needing work. They find the clients and the developer does the work. But what&#8217;s really involved in this transaction? What kind of work is available on the platform? Who can join, and how can Codeable and the clients both be sure that the developers are qualified and able to carry out the projects that they take on?</p>\n\n\n\n<p>Marcel certainly seems to have had a very positive experience with Codeable and explains the nuts and bolts of how you get started, what developers need to bring to the table and how Codeable mediates disputes which might arise.</p>\n\n\n\n<p>Towards the end of the podcast, we talk about Marcel&#8217;s work using AR and WooCommerce. As well as a brief foray into how he sees headless WordPress, working with WooCommerce in the future. What are the benefits and what are some of the drawbacks?</p>\n\n\n\n<p>Typically when we record the podcast, there&#8217;s not a lot of background noise, but that&#8217;s not always the case with these WordCamp Europe interviews. We were competing against crowds and the air conditioning. And whilst the podcasts are more than listable, I hope that you understand that the vagaries of the real world were at play.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading over to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Marcel Schmitz.</p>\n\n\n\n<p>I am joined by Marcel Schmitz. Hello, Marcel.</p>\n\n\n\n<p>[00:04:09] Marcel Schmitz: Hello. Thank you.</p>\n\n\n\n<p>[00:04:10] Nathan Wrigley: It&#8217;s very nice to have you here. First of all, let&#8217;s get a few introductions out the way. Tell us a little bit about WordCamp Europe and why you are here.</p>\n\n\n\n<p>[00:04:16] Marcel Schmitz: So, WordCamp Europe is very special to me because I&#8217;ve been living in Porto for 35 years. I was, born in Brazil I have German citizenship and yeah, my parents came here in 1988, so I&#8217;m here the whole time and I&#8217;m not gonna change this city for any other. I&#8217;m very much in love with the city. So obviously WordCamp Europe is very special for me, especially because I&#8217;m getting all my friends, WordPress friends, together in the city that I know very well, show them around. So yeah, it&#8217;s super special occasion.</p>\n\n\n\n<p>[00:04:46] Nathan Wrigley: It&#8217;s just the nicest of spots isn&#8217;t it? Yeah. So really kind of unusual for you in that you basically can go home to your own bed in the evening,</p>\n\n\n\n<p>[00:04:56] Marcel Schmitz: Right. That&#8217;s very unusual. That&#8217;s also at the same time, very practical, I guess I have the flexibility to just jump home very quickly, grab my things and just go with it. Nonetheless, for the last two days I&#8217;ve been at a hotel. It&#8217;s easier with the logistic at home, with my wife, my kid going to school because they&#8217;re still in school by this time of year. So for me not to interfere with their normal schedule, I&#8217;m just staying in a hotel.</p>\n\n\n\n<p>[00:05:23] Nathan Wrigley: That&#8217;s really ingenious. Your reason for being here is what? As far as I know, you&#8217;re not got a speaking engagement. You&#8217;re here as a, as an attendee?</p>\n\n\n\n<p>[00:05:31] Marcel Schmitz: Correct, yeah. That&#8217;s correct. This time, and every WordCamp Europe, we have also Codeable experts here. Which are people who I work with every day. And we have also people from Codeable staff here. So one of the main reasons to attend this is obviously to meet all these people. There are a lot of experts that we didn&#8217;t get to meet in person for a long time. It has been a couple of years. It&#8217;s one of the reasons is that obviously.</p>\n\n\n\n<p>And the second reason I would say there&#8217;s a lot of good talks that I would like to keep up. There&#8217;s new things that came out. There&#8217;s also other people from other teams, from Automattic, from WooCommerce etcetera, that I would like very much to meet.</p>\n\n\n\n<p>That&#8217;s basically it. It&#8217;s such a good opportunity to be in person with everyone, and to be together after all these years. It just makes it a wonderful time everyone being together.</p>\n\n\n\n<p>[00:06:15] Nathan Wrigley: Can I just try to paint a picture of your work life? In that you, I&#8217;m guessing that your large amount of your income comes from Codeable.</p>\n\n\n\n<p>[00:06:23] Marcel Schmitz: Yes, that&#8217;s right.</p>\n\n\n\n<p>[00:06:24] Nathan Wrigley: So, not necessarily dwelling on the Codeable piece itself yet, but just tell us what is it that you do? How does your work flow towards you? Are you basically taking on work that Codeable put in your inbox, if you like, and you can accept and decline things? And have you found that way of living to be enjoyable or is it stressful? Do you have to generate a lot of your own work or does it just land in your lap?</p>\n\n\n\n<p>[00:06:47] Marcel Schmitz: Right. So we have a very special place in our platform where everybody who&#8217;s an expert, who got access and who got admitted to the platform has a list of opportunities. And those are clients who come in. They register their projects. They have a project description. They ask for a specific area of expertise, and we just browse those projects. And we just get to choose whatever wanna work with. Basically what starts then is a conversation between us, the experts and the client.</p>\n\n\n\n<p>So multiple experts can come in and also ask questions and present themselves. And yeah, after a couple of messages we exchange, we talked about the project, we scope it out. And that basically then the clients decides if you want to hire us or not. Basically, I look for the job that I want.</p>\n\n\n\n<p>I read what the client needs to do. If it fits my area of expertise, I&#8217;m gonna interact with the client. That is an awesome way to do it for me, because you get to pick how much you wanna work. If you will have a planned a couple of days off, you can do that. You can also talk with a client, this is gonna take four weeks, five weeks, six weeks, whatever time it will take to complete the project. And you can add a little bit buffer to that so you can manage anything in between. So it&#8217;s absolutely not stressful, is actually something that gives you the most control possible as a freelancer, right?</p>\n\n\n\n<p>[00:08:03] Nathan Wrigley: Let&#8217;s just sort of dig a little bit deeper into that then. So you&#8217;re looking at your inbox for things to drop into it, where you, you are given an opportunity and you can peruse it and decide if it&#8217;s for you or not. And then how does it go from there? You say, actually this piece of work I&#8217;m interested in, and then you just hand it back to Codeable and they say, okay, we&#8217;ll communicate. And how is it confirmed that Marcel ,you&#8217;ve got the job and not somebody else?</p>\n\n\n\n<p>[00:08:23] Marcel Schmitz: Right. So all the communications are done by the experts themselves. So Codeable does not interfere with the conversation between the expert and the client. If we find that the task is interesting to us, we just start typing in what we call the workroom and that project that is there is gonna be then the place where the conversation happens between the client and the expert themselves.</p>\n\n\n\n<p>And so it is then up to the client to decide if he wants to work with that specific expert. The client has access to a profile and on the profile, the experts say what they&#8217;re good at, what their area of expertise, their work portfolio, everything that it worked before. And they can also read reviews that other previous clients have left for that specific expert.</p>\n\n\n\n<p>[00:09:02] Nathan Wrigley: How do you get the bonafides to be an expert? In other words, if I was to hire you and you&#8217;ve got on your portfolio, that I dunno you maybe a React expert or something like that. Where does the trust come from? Apart from the reviews, I can see that you&#8217;ve done this piece of work, and you&#8217;ve obviously got an amazing litany of reviews and everything that you&#8217;ve done everybody&#8217;s happy with. But when you launch into the platform, presumably there must be some kind of vetting process where you&#8217;ve got to prove that you can actually do what you claim you do.</p>\n\n\n\n<p>[00:09:27] Marcel Schmitz: Right. So, the vetting process is multi-phase process that goes from interviews to coding to a time where you do some trial and you have to present some code. You are also given a small task. You have to communicate with a client. So then from the Codeable side, there are people who are gonna look at that who are gonna evaluate if that&#8217;s at their standard, what they&#8217;re requiring. And that&#8217;s not only in the coding part on the technical part that you have to be an expertise.</p>\n\n\n\n<p>Also on the soft skills, like talking to the client, being polite, being able to explain what is happening or what is he&#8217;s going to do. So for an expert that comes in and has zero in their project count, zero in their client count, it will very much rely on what he writes as his presentation on his portfolio. Obviously these are people who are, are not starting as the developers right now, right? So they&#8217;ve previously worked either with other agencies or they have been freelancers themselves. So, they already have some expertise and some experience in different areas, that they&#8217;re gonna present in their profiles, right?</p>\n\n\n\n<p>And after the first project and the second and the third coming in, those numbers are gonna be coming up. Reviews are gonna come up. But I guess the most important part, I&#8217;m pretty sure this is what happens with most of the experts, is that the conversation that we have with the client at that moment for that project is the most important tool that you have.</p>\n\n\n\n<p>And it is what the client is gonna rely the most. If he understands that you know what you&#8217;re talking about, or if he feels comfortable that your solutions that you&#8217;re providing your, they have a problem and you have a solution and you explain it very clearly, and the client feels comfortable with your replies. That&#8217;s exactly what the client is gonna be inclined to work with you. And then later, perhaps gonna look at the profile and see what you&#8217;ve done in the past. But I think if you really show in that conversation that you know how to solve that problem, he&#8217;s gonna be very comfortable hiring you.</p>\n\n\n\n<p>[00:11:17] Nathan Wrigley: If you work for an agency or something like that, there&#8217;s a career path, isn&#8217;t there? There&#8217;s a trajectory. You start on the, the lower rung of the ladder. And as time goes on, you move up towards the top or you may flip to a different agency or something like that. Is there things built into systems like Codeable to enable you to do that? In other words, do you have to reauthenticate yourself as an expert every few years? And can you say actually now I&#8217;d, I&#8217;d also like to add this badge to my portfolio? I&#8217;ve done some work in React and I can claim that I&#8217;m good at that as well.</p>\n\n\n\n<p>[00:11:46] Marcel Schmitz: Right. You can always do that, right. So you can always update and can you always go there and say, oh, I&#8217;ve worked for the first time on a React project. I&#8217;ve learned React, and it went very well. Now I can go out there and say, I am now have the experience in React, and I&#8217;m gonna propose myself as a React developer. Yes, you can definitely do that.</p>\n\n\n\n<p>And also on the platform, you can work as a freelancer by yourself. You don&#8217;t have to be belonging to an agency or you don&#8217;t have to have a company behind it. But if you have, like it is in my case, there is one person, one face, one name, and you indicate that you belong to an agency, and you just name other persons that might interact with your name on the platform so that everybody knows, okay, this is Marcel&#8217;s company, but there might be people talking on behalf of Marcel.</p>\n\n\n\n<p>They will be clearly identified. They will talk with them. So, the adding of the expertise can also come from other agencies, having other experts coming into the agency. But for that to happen also Codeable needs to know that they need to know who are those people. And that&#8217;s basically how we then make sure that everybody knows exactly what they&#8217;re doing, right.</p>\n\n\n\n<p>[00:12:50] Nathan Wrigley: If I was to work in an agency and let&#8217;s say I was the agency owner, and I suddenly took on 3,000 staff, this would be the death of my business because I couldn&#8217;t afford payroll. But I&#8217;m just wondering about the piece in there of, is there a limit, do you know if there&#8217;s a limit? In other words, if 6,000 people show up tomorrow with the bonafides to say, I can do React at a really high level, do they all get taken into the platform or is there some kind of system to protect the people who&#8217;ve first through the door if you&#8217;d like?</p>\n\n\n\n<p>[00:13:17] Marcel Schmitz: Right. So I wouldn&#8217;t say 6,000 is acceptable in the platform. It&#8217;s not viable. There is no way somebody would show up in the platform with that many experts, because, I mean for him to get those 6,000, he has to have already the infrastructure to deal with them, right? There are certainly people who have, 15, 20, expertise or people working for the agency. I dunno if there&#8217;s a limit, but I would say 20, 30 is enough. But the funny thing is that there are three more times projects than experts right now at the platform.</p>\n\n\n\n<p>That&#8217;s a good problem to have, right? It&#8217;s not that easily solvable, it&#8217;s not just adding more experts and experts because the whole issue is you have to be good at communicating. You have to speak English perfect. Well, not perfectly, but at least in a way that people understand you. And you have to be obviously presentable. There are some opportunities and times where you go and have a consultation call that involves a video call. There&#8217;s a lot of other elements to that, that will try to make that client feel comfortable with the platform.</p>\n\n\n\n<p>And people when they get in this platform, because it is not like any other platform out there. They will struggle initially a little bit into getting into the whole way of functioning, right? So it is not an easy onboarding. It&#8217;s not as easy as, here&#8217;s an agency with 300 developers, let&#8217;s put them on the platform and problem solved. Because there&#8217;s still a lot of communication to go, right?</p>\n\n\n\n<p>And there are clients who don&#8217;t want to just hire another agency for that, and just have one face representing them. They wanna have close contact to whoever is developing their project. They wanna know exactly what&#8217;s going on. They don&#8217;t want to have a chain to go through to know why that specific code didn&#8217;t work, why the test fails or something like that. So it&#8217;s very, very unique to smaller teams, or even like down to this one freelance developer who just gained the trust of this client, and he&#8217;s gonna hire you over and over again.</p>\n\n\n\n<p>[00:15:04] Nathan Wrigley: You mentioned that there was three times, at the moment we&#8217;re recording this when WordCamp Europe is on. So maybe the numbers will go up. Maybe they&#8217;ll go down. But, roughly at the moment there&#8217;s three times more people offering work than there are people to fulfill that work. </p>\n\n\n\n<p>[00:15:15] Marcel Schmitz: Correct.</p>\n\n\n\n<p>[00:15:17] Nathan Wrigley: A housing market analogy might be it&#8217;s a seller&#8217;s market. So that&#8217;s quite something.</p>\n\n\n\n<p>[00:15:20] Marcel Schmitz: It is.</p>\n\n\n\n<p>[00:15:21] Nathan Wrigley: So you get to turn things down because they&#8217;re not, well, you can cherry pick basically.</p>\n\n\n\n<p>[00:15:26] Marcel Schmitz: You can cherry pick. That&#8217;s the whole beauty of it. And it goes back to your question where you asked, if you feel stressful, if you feel, uh, happy or okay. That&#8217;s exactly it. So you get to choose which project you wanna work with. And also the same way that the clients get a read on you as an expert in how we communicate and how you interact with the client.</p>\n\n\n\n<p>The same we get from the client, right. So if the client spends time explaining what he wants. If he puts the documentation out. If he provides you with screenshots. If he has drawn on a piece of paper, anything that he wants to build, that shows that the client has interest and the time to invest in whatever he wants to do, right? So when we go cherry pick is not only about the project that we feel comfortable with. It&#8217;s also in regards to the client. So we&#8217;ll try to figure out if there&#8217;s a good client to have, or to try at least get this project going. And I can say in my portfolio of clients, I&#8217;ve worked with 160 different clients already, and it&#8217;s been 70 percent of the work is repetitive, is returning clients that come back and wants something else.</p>\n\n\n\n<p>That goes to show that it&#8217;s all about communication, about building that trust. And that&#8217;s also one of the reasons why we have this ratio, right? Three more times project and experts because we tend to keep old clients, right. And they&#8217;re gonna obviously post on the platform as well. Obviously immediately be picked up by you and you will work on them. So you have less time to get new clients in, right?</p>\n\n\n\n<p>[00:16:47] Nathan Wrigley: Do Codeable help you in, let&#8217;s say you run up against something, a problem. Are you left to your own devices or is there support and help there? And then another sort of slightly related question? Equipment, technology, the computer, the internet connection. Does any of that get rolled into the, the thing that Codeable provide? In other words, once you join the platform, are there certain minimum things that you must have? Certain commitments in terms of I&#8217;m gonna work this many hours a week, you must have a computer of this standard. Just run all of that by us.</p>\n\n\n\n<p>[00:17:13] Marcel Schmitz: Right? Sure. So, there&#8217;s absolutely no minimum technical requirements at all, because by the time you get to the vetting process, you will pass through a process, whether they will eventually know what you&#8217;re doing, right. And a developer that has been doing this for many many years knows exactly what he needs and what he wants. So in the technical aspect, there&#8217;s absolutely no minimal requirements.</p>\n\n\n\n<p>As to the support that Codeable provides, 100%. New experts that come in, they usually have a hard time picking tasks. Other more, more experienced experts go in faster and communicate in a faster pace than the recently joined ones. And so Codeable sometimes go and help those people pick projects for them, right. And there&#8217;s also like Slack, which is an awesome tool that we use to promote projects that weren&#8217;t picked up because there&#8217;s so many coming in, they were overlooked or there&#8217;s so many people looking for any other types of projects.</p>\n\n\n\n<p>So new experts that come in, they will get support from Codeable, and they have Codeable staff to pick some of the projects for them. Like this first project, good first projects to have for them to start building their client relationship.</p>\n\n\n\n<p>[00:18:18] Nathan Wrigley: In terms of the way that Codeable keeps itself going, obviously there must be some sort of financial benefit to Codeable providing you with all this stuff. How does that work? Do they suggest a fee or are you in charge of what you are gonna be charging for a particular project or do they set a fee for a certain type of work and, what&#8217;s their cut, and all of that kind of stuff?</p>\n\n\n\n<p>[00:18:35] Marcel Schmitz: So, that&#8217;s another very good aspect of belonging to the Codeable community because we get to fix our own price, but there is a range. So the minimum would be $70 an hour and the maximum would be $120 an hour. So it&#8217;s the higher end rate that I would say in the WordPress area. But then again, that means that you have to position yourself within what do you think is your expertise worth. In my case, I&#8217;ve been working with WooCommerce for more than 10 years.</p>\n\n\n\n<p>I&#8217;m a little bit on the upper range. But also, I&#8217;m also very quickly able to tell the person what he needs to do, and how many hours it&#8217;s gonna take for me to do that. So it&#8217;s all on our hands. So we have the scope of the project, and we&#8217;re gonna go there, and this takes eight hour. My rate is such and such. And we put the estimate on the workroom. And on top of that, Codeable then charges the client 17.5 percent, and then it also takes from our ends 10%.</p>\n\n\n\n<p>So we contribute with 10% of our revenue, to the platform for them to keep the work going and to help us get the clients and also to mitigate any conflict that there is. Right. So if there is any disputes of some sorts, Codeable will immediately be the middle part of that. And we&#8217;ll try to get everything together. And the client, the 17.5%, same thing. So if the client doesn&#8217;t find an expert, if nobody replies, if they need some sort of an additional information about how to build a project or how to promote it into the platform, Codeable will also be there to help him out. So that&#8217;s how they build their, their business around that.</p>\n\n\n\n<p>[00:20:02] Nathan Wrigley: We&#8217;ve talked a lot about it from your side, so let&#8217;s just flip it very quickly before we get onto the WooCommerce bit to close it out. From the client perspective, you just mentioned that things go wrong, right? Agencies, freelancers and clients, they&#8217;re not always a match made in heaven. Things do go pear shaped and, you know, disagreements arise. Let&#8217;s talk about that. How do you ensure, how do you basically do quality assurance? What is the disagreement process? And are you, as a member of Codeable, it sounds like you are kind of immune from that discussion. They take that a bit away from you.</p>\n\n\n\n<p>[00:20:31] Marcel Schmitz: Well, not immediately. So obviously you are responsible for everything that you do with the, um, project in particular and with the client, all the communication. And sometimes when a client does find that something is missing was not done according to scope or the expert is not responding or is not being clear.</p>\n\n\n\n<p>Immediately the client can contact the support team and the support team will contact the expert and try to get things sorted out, right. Most of the time I would say I never had a dispute where Codeable would needs to apply, there&#8217;s a certain way for them to solve this dispute, right. So there&#8217;s a form that we fill out and everybody explains their part, and they then mitigate this. But until it reaches that point, you have a lot of opportunity to talk to the client. So in my experience at the beginning, I had a couple of clients were more difficult ones and you sort of like learn from that experience, right.</p>\n\n\n\n<p>And, and sometimes the client also understands that it didn&#8217;t understand before how the platform works, and all the change requests that come after that. How, why should I pay for a change request? This is obviously it should be red instead of green, right. But it&#8217;s not written green, it&#8217;s written red, right. So all these little bits can obviously build up to then not getting into a good relationship. It&#8217;s mainly up to you and yeah, Codeable helps you also mitigate that before they themselves present us. Okay. We are here, we&#8217;re gonna help solve this.</p>\n\n\n\n<p>[00:21:46] Nathan Wrigley: Is your expertise in Codeable then, WooCommerce, is that the thing that you&#8217;ve nailed your flag, you&#8217;ve that to the mast?</p>\n\n\n\n<p>[00:21:51] Marcel Schmitz: Yes. 100%.</p>\n\n\n\n<p>[00:21:54] Nathan Wrigley: So tell us about your interest in WooCommerce. Why WooCommerce as opposed to just regular WordPress? Is that just an area that you got interested in? Do you love e-commerce? It&#8217;s obviously a bit more of a niche and there&#8217;s actual money to be made from those websites, which is quite interesting.</p>\n\n\n\n<p>[00:22:07] Marcel Schmitz: Correct. So my initial interest in WooCommerce goes back to a dream that I once had, that I thought would be my business in the future. That would be have a marketplace online to sell different products and to have, to help local shops around my city to have their products online and sell them.</p>\n\n\n\n<p>And when I came first in contact with WooCommerce and the ability that we have to build a store online and don&#8217;t spend no money at all in getting there. It&#8217;s very fascinating. And then all the things that come with it, the scalability and the fact that you can connect it to other mediums. The fact that you can make it so fast that it&#8217;s not comparable to other platforms.</p>\n\n\n\n<p>So everything that goes around WooCommerce is very interesting. But the building of the business, the helping others build their business, and they got fired, now they wanna do something else. They have an idea and you come in and say, hey, this is WooCommerce. This is how you set up subscriptions, or this is how you sell courses and et cetera. It&#8217;s fascinating how people get inspired by the platform and by the tool and how you can help them get there and have a successful business out of that. That is the fascinating part of it.</p>\n\n\n\n<p>[00:23:10] Nathan Wrigley: This next sentence is based upon no data whatsoever, but I&#8217;m gonna ask it anyway. It feels like the pandemic may have been a good time to be into WooCommerce. Is that true?</p>\n\n\n\n<p>[00:23:23] Marcel Schmitz: Yes, that&#8217;s 100%. I don&#8217;t have any specific data as well, but I&#8217;ve seen my work increase three times during the pandemic. And a lot of them were first time businesses that wanted to go online and they wanted to start a new thing, and this was their opportunity. Many of them come with very little knowledge what is to sell a product, because sell a product is not only put it out there and get the money. It&#8217;s also providing support, pre-sales questions, everything that has to do with a broken product or anything that doesn&#8217;t work on the website. So there&#8217;s a lot of other things around the business and online business.</p>\n\n\n\n<p>So, definitely the pandemic gave a huge opportunity for those experts to increase in our number of clients. But I would say the most important part that I picked up from this time was how people found a new way to get their living and to build a business. And some of them are quite up there right now so, they&#8217;re basically not going back to their previous job and what they were doing before.</p>\n\n\n\n<p>[00:24:19] Nathan Wrigley: So with the analogy of a seesaw, it goes up, it also goes down. During the pandemic, up it goes and are we seeing a decline?</p>\n\n\n\n<p>[00:24:27] Marcel Schmitz: No.</p>\n\n\n\n<p>[00:24:28] Nathan Wrigley: Really, okay.</p>\n\n\n\n<p>[00:24:29] Marcel Schmitz: Defininitely not.</p>\n\n\n\n<p>[00:24:30] Nathan Wrigley: It&#8217;s, maintaining, it&#8217;s gone up and it stays up.</p>\n\n\n\n<p>[00:24:32] Marcel Schmitz: It is. And I think one of the reasons behind that is because these people that during the pandemic started doing their businesses, they told others and they are an example for others. And maybe those other who didn&#8217;t quite have a hard time as the previous ones had during the pandemic, they started think, oh, maybe this can be a side business, or maybe I can do something as I do my regular work. And so it&#8217;s constantly increasing.</p>\n\n\n\n<p>[00:24:56] Nathan Wrigley: That&#8217;s absolutely fascinating. Again, based upon no data, I would&#8217;ve assumed it to go down. So couple of years ago, came onto my radar that Shopify was just going like the bomb. Everybody was talking about it. It was increasing. Seems like that conversation continues. It seems like it&#8217;s going really well. If I were a developer and I wanted to go for Shopify development or I wanted to go to WooCommerce development, clearly you&#8217;ve gone for Woo. Just paint the picture of why Woo, not a proprietary SaaS.</p>\n\n\n\n<p>[00:25:26] Marcel Schmitz: You can do anything that you want with WooCommerce, anything, right. And Shopify is for a specific type of online business, it&#8217;s not for everyone. And you as a developer are very limited within the Shopify platform. The limitation is to. probably in some type of business, is not bad because it also provides stability of the platform.</p>\n\n\n\n<p>There are certain critical areas of a e-commerce solution that cannot fail. Payment methods cannot fail. The shipping part cannot fail. People have to check out. There is the conversion rate that has to be assured so that the business is successful. And WooCommerce on the other side gives you so much more flexibility in changing things around that we&#8217;ll meet the client&#8217;s expections. But also at the same time, it makes you more responsible for doing everything right, right?</p>\n\n\n\n<p>Every single developer that works with WordPress and with WooCommerce has seen code that is probably not up to standards, right. There are many different ways to do the same thing. And so with WooCommerce, you have so much flexibility, but if you do it exactly by code, by standard, you&#8217;re gonna get that performance that you need. You&#8217;re gonna get every single bit of customization that a client wants.</p>\n\n\n\n<p>And we&#8217;ve done a couple of conversions from Shopify to WooCommerce where they say this now finally feels like I can do anything that I want. But you have always obviously to explain, yeah, you can do anything they want, but it comes with a price. You have to be also more responsible. The things that we request, right? Because not everybody understands that changing a checkout page may influence how people check out, or if they even check out at all. So that comes with responsibilities as well.</p>\n\n\n\n<p>[00:26:59] Nathan Wrigley: You were talking earlier about the fact that you can cherry pick a little bit. If somebody came into the Codeable platform and said, I just need a basic WooCommerce site, that maybe is something that you are not interested in these days, because you&#8217;ve gone through that a number of times I imagine, and maybe the interest isn&#8217;t there. And when we were setting up this interview, you mentioned all sorts of incredibly ingenious and interesting things that you are doing on the other end. You&#8217;re basically using WooCommerce as a conduit to push data to mobile platforms and all that. Tell us about some of the exciting, cutting edge stuff that you&#8217;ve been involved in recently.</p>\n\n\n\n<p>[00:27:28] Marcel Schmitz: Well, just to go up to your question previously a normal website that comes in, a regular business, small shop. I would not immediately reject it because it&#8217;s small. It&#8217;s exactly on that opportunity that I think it&#8217;s the most fascinating, right? So, because it&#8217;s a green project. It&#8217;s very new. There are so many things that can be done. There is an idea. There is a product. There is a person who&#8217;s gonna invest in that and is gonna put effort into working on that project.</p>\n\n\n\n<p>And there&#8217;s a lot of opportunities to guide that person into the right direction, right. And if the results come quick, the person will immediately figure out that you&#8217;re a good partner for them to work as the technology goes. As far as more complicated projects, yeah I think one of the most interesting ones is an app that we did for a client that were selling ear rings.</p>\n\n\n\n<p>And you would use your phone camera to emulate how they look on your ears. So you would just point the camera towards your face, and you would choose the earrings that would match you the best. And all of that was done using WooCommerce on the background. The 3d models that were attached to the products within WooCommerce, and they were just using the Rest API to upload them to the app. And basically everything worked natively. So the browsing of the products, looking up the descriptions, doing the augmented reality stuff, that was all based on WooCommerce, yeah.</p>\n\n\n\n<p>[00:28:43] Nathan Wrigley: Yeah. That&#8217;s incredible. And probably very interesting.</p>\n\n\n\n<p>[00:28:45] Marcel Schmitz: It&#8217;s awesome. And, also at the same time is very challenging. And the challenging part here was get the 3d model right. Because it was so impactful that the color has to be there. The shape has to be there, because you&#8217;re emulating a 3d object in an environment. The shadow has also to be right. The cool part about that was that on iOS, we are so advanced with augmented reality right now, that if I would be in this room and the light would be coming from a direction, the 3d model would understand where the light comes from and it would change the shadow on that 3d object. So it make, looks more natural on yourself. And that was the surprising part of that project. And, and it was really interesting.</p>\n\n\n\n<p>[00:29:25] Nathan Wrigley: Very quickly just to wrap it up, because sadly we&#8217;re running out of time. We have restrictions on the amount of time that we can go. One of the things that you mentioned in the information that you passed to me was headless. Headless WooCommerce, just like I said briefly, tell us what that all means.</p>\n\n\n\n<p>[00:29:39] Marcel Schmitz: I do think that the headless word carries too much negative connotation, because it has become a trend almost like, hey, I&#8217;m an awesome developer. I can completely detach the front end from the back end. And I&#8217;ve implemented 1000 different packages or libraries or whatever. And this works very fast. Awesome. Right, but what can you do else with it? Can you install plugins and they do show up on the front end? Can you change the checkout page for anything that you would like to have? No, you can&#8217;t.</p>\n\n\n\n<p>So what I found fascinating about headless is not everything has to run on the server, right? So if you have a regular WooCommerce store, most of the HTML that you see on the screen is firstly generated on the server and then passed to the browser. As we have more advanced computers, we have browsers are more capable, some of that job can be done on the client side and client side means on the browser, right?</p>\n\n\n\n<p>So headless for me, it&#8217;s super interesting because, there are upcoming technologies who will divide the work that the server does and the work that the client will do. Not everything should be on the client side as well. So there&#8217;s no extreme. There&#8217;s like not 8, not 80. We have to find a 40 in the middle.</p>\n\n\n\n<p>And that&#8217;s the challenging part. So with some of the parts, and that&#8217;s what I&#8217;ve been experimenting lately, can be done in a headless way. Browsing through a project catalog doesn&#8217;t need server work. It can be everything done in the client work. But then again, the checkout page, it can be completely detached from the server, but should it be? Is that the real solution for the problem?</p>\n\n\n\n<p>Do we have a problem in that regard? Because we can also supercharge the server and the checkout page can also be awesomely fast, and we don&#8217;t need to bring all the work to the client side, right? But what&#8217;s fascinating is that we have so much tools right now, the Rest API is at it&#8217;s best right now, and we can do anything with them and we can check out, we can work with a cart. Gutenberg is obviously a tool that you use to make everything work on the front end side. It works faster. It is much more easier for the clients to manage and to build the pages. But it doesn&#8217;t have to be everything on the client&#8217;s side. That&#8217;s where I see the challenge to decide where to put the weight.</p>\n\n\n\n<p>[00:31:40] Nathan Wrigley: Marcel Schmitz, thank you for joining us. Thanks for telling about how you find work and about the interesting work that you do.</p>\n\n\n\n<p>[00:31:46] Marcel Schmitz: Thank you very much Thank you.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Sep 2022 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"WPTavern: Gutenberg Contributors Call on Theme Authors to Test Using Block-Based Template Parts in Classic Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137803\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"https://wptavern.com/gutenberg-contributors-call-on-theme-authors-to-test-using-block-based-template-parts-in-classic-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3710:\"<p>If you watched <a href=\"https://wordpress.tv/2022/09/12/a-chat-with-matt-mullenweg-wordcamp-us-2022-qa/\">Matt Mullenweg&#8217;s Q&amp;A session</a> at WordCamp US last weekend, it&#8217;s evident that there are significant parts of the community still clinging to the Classic Editor who would be happy for it to be supported indefinitely. For whatever reason, millions users are not ready to switch &#8211; some prefer the old editor, don&#8217;t like blocks, don&#8217;t want to learn a new system, or simply find the newer versions of WordPress too confusing. </p>\n\n\n\n<p>In recognition that some users may need a transitional bridge over to the block editor, with an opportunity to dip their toes into it without breaking their whole site design, Gutenberg 14.1 will introduce the ability for theme authors to <a href=\"https://github.com/WordPress/gutenberg/pull/42729\">use block-based template parts in classic and hybrid themes</a>.</p>\n\n\n\n<p>Anne McCarthy, who coordinates the FSE outreach program and Gutenberg testing, <a href=\"https://make.wordpress.org/themes/2022/09/12/testing-and-feedback-for-using-block-based-template-parts-in-classic-themes/\">posted</a> to the Make Themes blog, calling on theme authors to test it out.</p>\n\n\n\n<p>&#8220;Gradual adoption options remains a focus for the project and, increasingly, there are more ways to adopt parts rather than the whole of a feature coming to the latest version of WordPress,&#8221; McCarthy said. &#8220;The aim is to allow folks to adopt what they need as they are ready in a way that is still future forward.&#8221;</p>\n\n\n\n<p>Theme authors will need to specify block-template-parts theme support and use Gutenberg trunk or Gutenberg 14.1 when it’s released on September 15th, 2022. Then they can add block-based template parts as HTML files placed into the parts directory inside the root of the theme. These can then be output inside the theme&#8217;s PHP templates using the block_template_part function.</p>\n\n\n\n<p>&#8220;Users will see a new &#8216;Template Parts&#8217; menu visible under &#8216;Appearance,&#8217; which displays a list of template parts,&#8221; McCarthy said. &#8220;From there, all theme blocks are available, but the environment is inherently limited compared to block themes. For example, users can edit existing template parts but not delete them or create new ones.&#8221;</p>\n\n\n\n<p>McCarthy suggested a few use cases for adding block-based template parts to classic themes &#8211; enabling authors to offer a header template part that allows users to set a video or image background, adjust the focal point, move blocks around, or offer a footer with design blocks locked but content that is easy to edit.</p>\n\n\n\n<p>&#8220;While this feature is currently aimed at providing options for themes, plugins can also explore extending this functionality to enable the same UI for users,&#8221; McCarthy said. </p>\n\n\n\n<p>Block themes represent just 2.5% of WordPress themes in the directory, so this new capability is applicable to the majority of themes. Motivating classic theme authors to support this in their themes is another challenge if they don&#8217;t see the benefit to users or determine that the different editing experience would be too confusing. It may have an easier entry point through plugins, as users may be more likely to embrace a different editing UI for plugin functionality.</p>\n\n\n\n<p>For more technical details and code examples for adding theme support, check out the <a href=\"https://make.wordpress.org/themes/2022/09/12/testing-and-feedback-for-using-block-based-template-parts-in-classic-themes/\">post</a> outlining how to test using block-based template parts in classic themes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Sep 2022 03:46:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: National Harbor, Maryland to Host WordCamp US and Community Summit, August 23-25, 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137777\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/national-harbor-maryland-to-host-wordcamp-us-and-community-summit-august-23-25-2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4087:\"<p>WordCamp US 2022 has concluded after two days of presentations and a contributor day last weekend. Some attendees are still making their way home with hearts full of good memories until the next time they can gather in person again.</p>\n\n\n\n<p>Outside of the main event, attendees had many opportunities to network, connect with new friends, and finally meet people they have been working with on the web for years.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Happy Friday from <a href=\"https://twitter.com/hashtag/WCUS?src=hash&ref_src=twsrc%5Etfw\">#WCUS</a> 2022! <a href=\"https://t.co/6SE30ZBm0z\">pic.twitter.com/6SE30ZBm0z</a></p>&mdash; WordPress Women of Color (@wpwomenofcolor) <a href=\"https://twitter.com/wpwomenofcolor/status/1568327720551223296?ref_src=twsrc%5Etfw\">September 9, 2022</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Spent the weekend in San Diego doing my first WordCamp after several years of being away. I am totally overwhelmed realizing how much I missed doing these.<br /><br />Can\'t wait to start jet-setting around again with my WordPress/travel crew. See y\'all next time&#8230;<a href=\"https://twitter.com/hashtag/wcus?src=hash&ref_src=twsrc%5Etfw\">#wcus</a> <a href=\"https://t.co/mpJcGg3Mgr\">pic.twitter.com/mpJcGg3Mgr</a></p>&mdash; Robby McCullough (@RobbyMcCullough) <a href=\"https://twitter.com/RobbyMcCullough/status/1569751746947465217?ref_src=twsrc%5Etfw\">September 13, 2022</a></blockquote>\n</div>\n\n\n\n<p>The event&#8217;s organizers have invited attendees to share their photos in the <a href=\"https://photos.google.com/share/AF1QipOOuLeVk5qZoEPlR2yFPA4OIRtoiSwpEZtwejsxUmjEPbYsu6rZMIuZne53wqqm3Q?pli=1&key=aldTSWJ4Qk5CeWRmdUpWVWgtYnhoMTBlSXlUUUV3\">WCUS Community Photo Album</a> on Google Photos.</p>\n\n\n\n<img />\n\n\n\n<p>The Job Posting board is back in business and shows several dozen agencies, product, and hosting companies hiring for roles across the WordPress ecosystem. Many of these companies were also sponsors of the event.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">A lot of companies are hiring in WordPress! <a href=\"https://twitter.com/hashtag/WCUS?src=hash&ref_src=twsrc%5Etfw\">#WCUS</a> <a href=\"https://t.co/lE2SaIhf2h\">pic.twitter.com/lE2SaIhf2h</a></p>&mdash; Brad Williams (@williamsba) <a href=\"https://twitter.com/williamsba/status/1568976628705013761?ref_src=twsrc%5Etfw\">September 11, 2022</a></blockquote>\n</div>\n\n\n\n<p>All the sessions from WCUS were recorded and will be <a href=\"https://wordpress.tv/event/wordcamp-us-2022/\">coming to WordPress.tv</a> soon. In the meantime, sessions can be viewed through the livestream recording on YouTube. There are separate videos for the Sun track (<a href=\"https://www.youtube.com/watch?v=ql4hhXWcdik\">Friday</a> and <a href=\"https://us.wordcamp.org/2022/livestream/sun-sat/\">Saturday</a>), and the Palm track (<a href=\"https://us.wordcamp.org/2022/livestream/palm-fri/\">Friday</a> and <a href=\"https://us.wordcamp.org/2022/livestream/palm-sat/\">Saturday</a>). The recording of Matt Mullenweg&#8217;s Q&amp;A is <a href=\"https://wordpress.tv/event/wordcamp-us-2022/\">available on WordPress.tv</a>. He answered questions about improving contributor experience, accessibility, the timeline for multilingual features in core, and more.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>At the end of his Q&amp;A session, Mullenweg announced the location of <a href=\"https://us.wordcamp.org/2022/announcing-wordcamp-us-2023/\">the next WordCamp US</a>. In 2023, the event will take place on the East coast at <a href=\"https://www.nationalharbor.com/\">National Harbor, Maryland</a>, a waterfront convention center located along the Potomac River, 20 minutes from Washington, D.C. The dates are set for August 23-25, which will include contributor days, presentations and workshops, and a WordPress Community Summit. Organizers said the event will focus on learning and creation.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Sep 2022 20:32:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: Matt Mullenweg Renews Push for Canonical Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137744\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/matt-mullenweg-renews-push-for-canonical-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8930:\"<p>During WordCamp US&#8217; contributor day this weekend, Matt Mullenweg <a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">published</a> a renewed call for WordPress&#8217; Make teams to adopt a plugin-first approach when developing new features for core. He revived the notion of canonical plugins, <a href=\"https://wordpress.org/news/2009/12/canonical-plugins/\">first introduced to the WordPress community in 2009</a> as a means for delivering optional features to users with a higher level of confidence than regular plugins:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Canonical plugins would be plugins that are community developed (multiple developers, not just one person) and address the most popular functionality requests with superlative execution. These plugins would be GPL and live in the WordPress.org repo, and would be developed in close connection with WordPress core. There would be a very strong relationship between core and these plugins that ensured that a) the plugin code would be secure and the best possible example of coding standards, and b) that new versions of WordPress would be tested against these plugins prior to release to ensure compatibility. There would be a screen within the Plugins section of the WordPress admin to feature these canonical plugins as a kind of Editor’s Choice or Verified guarantee. These plugins would be a true extension of core WordPress in terms of compatibility, security and support.</p>\n<cite>Jen Mylo &#8211; <a href=\"https://wordpress.org/news/2009/12/canonical-plugins/\">Canonical Plugins (Say What?)</a></cite></blockquote>\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/\">WordPress Plugins Directory</a> is just one plugin away from crossing 60,000 (at the time of publishing). In contrast to the idea of canonical plugins, the official directory is still like the wild west in terms of what users can expect from plugin authors. Mullenweg cited several plugin scenarios that are not ideal for users &#8211; such as a plugin being controlled by a single company and evolving to go more towards a pro version or removing previously free functionality and putting it behind an upgrade. </p>\n\n\n\n<p>Canonical plugins are meant to provide a trustworthy alternative to plugins where authors&#8217; motivations may not put users first. It also provides an avenue for core contributors to demonstrate the demand for features they want to land in WordPress. &nbsp;A few projects like MP6,&nbsp;Gutenberg, and&nbsp;the REST API have taken this path into core.</p>\n\n\n\n<p>&#8220;We are reaching a point where core needs to be more editorial and say &#8216;no&#8217; to features coming in as ad hoc as they sometimes do, and my hope is that more Make teams use this as an opportunity to influence the future of WordPress through a plugin-first approach that gives them the luxury of faster development and release cycles (instead of three times per year), less review overhead, and and path to come into core if the plugin becomes a runaway success,&#8221; Mullenweg said. </p>\n\n\n\n<p>&#8220;I am very conscious that when people are aiming to have something in core, a &#8216;no&#8217; or &#8216;not now&#8217; can be frustrating and sometimes create artificial pressure to put something in before it’s ready, as I believe happened with the REST API in WP 4.4.&#8221;</p>\n\n\n\n<p>In a related <a href=\"https://make.wordpress.org/core/2022/09/11/webp-in-core-for-6-1/\">post</a> that inspired the renewed discussion on canonical plugins, Mullenweg weighed in on the controversial WebP by default proposal that had recently <a href=\"https://wptavern.com/webp-by-default-on-hold-for-6-1-after-new-objections-from-wordpress-lead-developers\">received new objections</a> from WordPress lead developers. Contributors have been working feverishly to revise their approach in time for 6.1.</p>\n\n\n\n<p>Mullenweg recommended these new features as a prime candidate for the canonical plugin pathway, suggesting it would give more time for the ecosystem around WebP to mature:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>&nbsp;I am interested in supporting new formats and improving performance, but I think this change being pushed by default to users when they upgrade to 6.1 is a lot for right now, including with some of the clunky interactions OSes still have around webp (and HEIC!) files.</p>\n\n\n\n<p>I’m happy for support for working for webp and HEIC files to stay in&nbsp;core, as we should be liberal in what we accept and work with, but not with the change to convert everything to webp when JPEGs are uploaded.</p>\n</blockquote>\n\n\n\n<p>The Performance team <a href=\"https://wordpress.slack.com/archives/C02KGN5K076/p1662980866303979?thread_ts=1662925534.926459&cid=C02KGN5K076\">plans to discuss</a> this in tomorrow&#8217;s scheduled chat. It&#8217;s not clear yet whether the recent WebP by default efforts will be punted to canonical plugin status or if some part of it may still land in 6.1. </p>\n\n\n\n<p>Responses to the call for more canonical plugins were mixed, as some immediately recognized the increased burden on maintainers of these plugins. </p>\n\n\n\n<p>&#8220;WP just needs to get over it’s aversion to optional features,&#8221; WordPress developer Jon Brown said. &#8220;Features that can be enabled/disabled. &#8216;Decisions not options&#8217; is a great ethos when it’s about keeping things simple for users but it seems to have been thrown out the window with Gutenberg UX, and turned into axiom when discussing adding trivially simply options to the settings page.&#8221;</p>\n\n\n\n<p>iThemes-sponsored contributor Timothy Jacobs said he is not necessarily in support of adding more options to Core but thinks canonical plugins could be presented in a similar way to options.</p>\n\n\n\n<p>&#8220;That doesn’t mean the UI has to be just searching through the plugins directory for something you want,&#8221; Jacobs said. &#8220;The canonical plugins could be exposed in maybe a &#8216;settings-like&#8217; UI. I think Import methods are a bit hidden away in the Tools menu, but something like that perhaps.&#8221;</p>\n\n\n\n<p>Core contributor Torsten Landsiedel said the difference between canonical plugins and <a href=\"https://make.wordpress.org/core/handbook/about/release-cycle/features-as-plugins/\">feature plugins</a> is not clear. The distinction may be that canonical plugins include those that may never belong in core but are still important for users.</p>\n\n\n\n<p>&#8220;It sounds like the &#8216;WordPress importer&#8217; plugin could be a canonical plugin,&#8221; Landsiedel said. &#8220;Not sure if this a good example for a *thriving* plugin. Does not support featured images, struggles with high amounts of posts/media, etc.</p>\n\n\n\n<p>&#8220;The useful Health Check plugin struggles with missing people helping out.</p>\n\n\n\n<p>&#8220;How do we prevent those plugins (whatever called) from not getting enough contributors? I think an importer is a crucial tool, but also not necessary in core (I can install it if I need it, that’s okay) – but it should work and at the moment this does not work well. But I don’t see much interest from the dev community to help fix this (maybe because they use WP CLI and do not care about this plugin?)&#8221;</p>\n\n\n\n<p>WordPress core contributor Colin Stewart said that while he agrees features as plugins first is useful for new features, it requires &#8220;a much better metric than &#8216;runaway success,&#8217; for inclusion in core. </p>\n\n\n\n<p>&#8220;Some features are important for stability, and protect users from issues that give them a headache multiple times during their website’s lifetime, but aren’t something users might think to search for in the plugin repository, or install on sight,&#8221; Stewart said. &#8220;Rollback is such a feature, as is Site Health, Privacy Export/Erase, and such.</p>\n\n\n\n<p>&#8220;A formal decision-making process for proposals would be incredibly helpful. This topic is coming up regularly now.&#8221;</p>\n\n\n\n<p>Mullenweg offered nearly two dozen ideas for canonical plugins the Make teams could consider and suggested the teams themselves could likely come up with better ideas. Imagining all these new features in play, it would be like a renaissance of innovation in the admin. This is an exciting prospect that could benefit WordPress users as long as the plugins are featured in such a way that they are easy to adopt. Early commenters on the idea raise legitimate concerns about the lack of maintainers, as history shows support for some of the existing canonical plugins is somewhat patchy.</p>\n\n\n\n<p>&#8220;I hope it sparks discussion at contributor day and beyond on how we can utilize plugins better to increase the speed of evolution for WordPress, keep core light, fast, and opinionated, and do so while saying &#8216;yes&#8217; to more ideas and experimentation,&#8221; Mullenweg said.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Sep 2022 02:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: WCUS Q&amp;A\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=61957\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2022/09/wcus-qa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:677:\"<p><a href=\"https://us.wordcamp.org/\">WordCamp United States</a> was in San Diego this year, a really lovely town. It felt like a throwback because of the venue we had to limit tickets quite a bit, so it felt like a WCUS from a decade ago.</p>\n\n\n\n<p>I&#8217;ll probably do this year&#8217;s State of the Word in December again with a livestream and small live audience, so for WCUS we did a brief introduction to the upcoming WordPress 6.1 release, and focused on audience Q&amp;A. Those are always fun for me because you never know what question will come next. Here&#8217;s the video if you&#8217;d like to catch up on it:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Sep 2022 23:51:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Gutenberg Times: WordCamp US, What’s new in WordPress 6.1, Style Variations and The Future of Themes  – Weekend Edition 228\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=22049\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"https://gutenbergtimes.com/wordcamp-us-whats-new-in-wordpress-6-1-style-variationx-and-the-future-of-themes-weekend-edition-228/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15879:\"<p>Howdy, </p>\n\n\n\n<p>Greeting from San Diego and WordCamp US Contributor Day! The last four days were filled with catching up with friends, conversations about new cool developments, themes and contributing to WordPress. </p>\n\n\n\n<p>But the time didn&#8217;t stay still, and there is so much more happening around Gutenberg and WordPress. </p>\n\n\n\n<p>This is a video heavy edition with recordings from WordCamp US talks, as well as new workshops available on WordPress TV. </p>\n\n\n\n<p>Enjoy. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n\n\n<div class=\"is-layout-flow wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-s\">Conversations at WordCamp US</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#1-p\">What&#8217;s New in WordPress 6.1</a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li><li><a href=\"https://gutenbergtimes.com/feed/#4-u\">Using the Block editor</a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 id=\"0-s\">Conversations at WordCamp US</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/arturgrabo\">Artur Grabowski</a></strong> gave me a demo of <a href=\"https://extendify.com/launch/\"><strong>Launch, a new product by Extendify</strong></a>. The team works with hosting companies to install  a most modern onboarding experience for their WordPress customers to reduce the very high churn rate of 50% customers leaving for SaaS CMSs. Launch provides the &#8220;most fool-proof solution to onboard WordPress customers with just a few clicks&#8221; the new site owner sees a personalized site with vertical-specific copy and images. It integrates seamless with WordPress instance, is built with native WordPress components and does not use 3rd party page builders. </p>\n\n\n\n<img /><em>Extendify Launch screenshot, courtesy of Extendify</em>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/UglyRobotDev\">Aaron Edwards</a></strong> demonstrated the early beta version of Iamjinn&#8217;s newest product: a plugin to bring the <a href=\"https://infiniteuploads.com/imajinn/\"><strong>magic of AI Image generation to WordPress</strong></a>. The prompt for testing the image generation API was &#8220;Young female assembling blocks in the right corner of a car repair shop&#8221; The first set was generated was in the style of Mexican painter Frida Kahlo, the second set in the style of Spanish painter Salvador Dalí and the third in Comic Book Style. </p>\n\n\n\n<img />\n\n\n\n<p>Last week, I spent Sunday morning in <a href=\"https://www.midjourney.com/home/#about\">Midjourney&#8217;s Discord </a>server and created <a href=\"https://gutenbergtimes.com/typography-for-all-blocks-refined-template-editing-context-patterns-weekend-edition-227/\">last week&#8217;s  featured image</a> with a similar prompt. So, I was thrilled when I met Aaron Edwards, and he was willing to give me a tour and access to the early Beta. If you are interested, you can request beta access, too.</p>\n\n\n\n<h2 id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>In her post <a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\"><strong>TT3 default theme: Announcing style variation selections</strong></a>, <strong>Channing Ritter</strong> wrote: &#8220;These variations were selected in an effort to feature the most drastically different set of variations possible — so in many ways, we were looking at what would work best as a collection versus selecting our favorite standalone submissions.&#8221; </p>\n\n\n\n\n<p>You can see the variations in below video.</p>\n\n\n\n\n\n\n\n\n<p>In her article, <a href=\"https://wptavern.com/wordpress-announces-10-style-variation-selections-for-twenty-twenty-three-theme\"><strong>WordPress Announces 10 Style Variation Selections for Twenty Twenty-Three Theme</strong></a>, <strong>Sarah Gooding</strong> covers the unveiling of the style variations submitted by community contributors to be bundles with the new default theme.</p>\n\n\n\n<h3 id=\"1-p\">What&#8217;s New in WordPress 6.1</h3>\n\n\n\n<p>If you&#8217;d like to get a head start on what changes will come with WordPress 6.1 you have a few options. </p>\n\n\n\n<p><strong><a href=\"https://twitter.com/brandedwithj\">Jonathan Pantani</a></strong> announced that the release team will hold a <a href=\"https://make.wordpress.org/core/2022/09/05/6-1-product-walk-through/\"><strong>6.1 Product Walk-Through</strong></a> on September 13 at 16:00 UTC (12:00 EDT). &#8220;WordPress 6.1 release squad members will join #core contributors from&nbsp;<a href=\"https://make.wordpress.org/core/tag/core/\">#core</a>&nbsp;and the broader WordPress community to conduct an informal preview of the major features in the upcoming release.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>September 19th, 2022, starting at 6pm MDT / 8 pm EDT, I will be <a href=\"https://www.meetup.com/boulderwp/events/sdwswsydcmbzb/\"><strong>discussion WordPress 6.1 new features</strong></a> in a virtual meeting with the members of WordPress Meetup group in Boulder, CO. You can join us via Meetup</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/carlodaniele\"><strong>Carlo Daniele </strong></a>did a deep dive via his blog post for Kinsta: <a href=\"https://kinsta.com/blog/wordpress-6-1/\"><strong>What’s New in WordPress 6.1: JPEG to WebP Conversion, Fluid Typography, Improved Template System, and Much More!</strong></a></p>\n\n\n\n<div class=\"is-layout-flow wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>🎙️ </strong> New episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-71-fluid-typography-block-api/\">Gutenberg Changelog #71 – Gutenberg 13.8, Fluid Typography, updates to the  Block API and more</a> &#8211; with co-hosts Grzegorz Ziolkowski and Birgit Pauli-Haack </p>\n</div></div>\n\n\n\n<h2 id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>You can watch the recording of <strong>Rich Tabor</strong>&#8216;s talk at WordCamp US about <strong><a href=\"https://www.youtube.com/watch?v=GOwnksYkH18&t=15266s\">A New Era of WordPress Themes is Here: Block Themes</a></strong> from  the live stream on YouTube. Tabor also tweeted the essence of the talks in <a href=\"https://twitter.com/richard_tabor/status/1568690789550821376\">this Twitter Thread</a> including links to mentioned references and plugins. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/marktimemedia\">Michelle Schlup</a></strong> walked us through the evolution of themes in WordPress, the advent of Design Systems, the Atomic design of Block themes and the concerns and consideration of a change in how you create Themes in WordPress. Her talk at WordCamp US is <a href=\"https://youtu.be/GOwnksYkH18?t=18904\">available on YouTube</a> (via the livestream). Her slidedeck is available on Speakerdeck: <a href=\"https://speakerdeck.com/marktimemedia/the-future-of-themes-designing-for-the-block-editor-and-beyond\"><strong>The Future of Themes: Designing for the Block Editor and Beyond</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>In this video: <strong><a href=\"https://wordpress.tv/2022/09/05/styling-your-wordpress-blocks/\">Styling your WordPress Blocks</a></strong>, J<strong>onathan Bossenger</strong> guides new block developers through the process of styling the Edit component and the save function of a newly created WordPress block. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Nick Diego </strong>invited WordCamp US attendees: <strong><a href=\"https://www.youtube.com/watch?v=-hWtGDLc_Nk&t=19020s\">Let’s build a Custom Block in 15 Minutes</a></strong>. You need to watch the YouTube recording from the live stream to find out if 15 min are enough. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> presented on <strong><a href=\"https://youtu.be/ql4hhXWcdik?t=27186\">Extending WordPress with Slotfills</a> </strong>and you can watch it via YouTube. He also published his code on GitHub: <a href=\"https://github.com/ryanwelcher/wordpress-slot-fill-system\">WordPress Slotfill System</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://www.youtube.com/watch?v=-hWtGDLc_Nk&t=15524s\"><strong>Customizing Core Blocks for Clients</strong></a> was the topic of <strong>Alex Ball</strong>&#8216;s talk at WordCamp US</p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<h2 id=\"4-u\">Using the Block editor</h2>\n\n\n\n<p>In this video on WordPress TV, <strong>Sarah Snow </strong>reveals: <strong><a href=\"http://wordpress.tv/2022/08/28/how-do-they-do-that-the-very-basics-of-block-theme-development/\">How Do They Do That? The (Very) Basics of Block Theme&nbsp;Development</a>.</strong> Have you ever wondered how block themes are developed from an idea, through a Figma file, into WordPress, and beyond? If so, this recording of social learning space event is for you.  Snow walked intermediate WordPress users through the high-level process many theme developers take to design a theme from start to finish. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/circlecube\">Evan Mullins</a></strong>&#8216; talk at WordCamp US was titled: <a href=\"https://www.youtube.com/watch?v=-hWtGDLc_Nk&t=20030s\"><strong>FSE For the Win</strong></a>. Mullins wrote in the session description: &#8220;Personal branding and online presence are made easier with full site editing! Do you have a personal site? Is it attractive? Is it current? No more excuses, full site editing makes it too easy not to put your best website out for the world to see. Put up a photo with a few links, a resume, recent projects, a collection of your favorite social media, a simple link tree, etc. We’ll go through some fun examples and see some blocks and block patterns to quickly get up and running.&#8221; See the YouTube livestream.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://wordpress.tv/2022/08/24/creating-a-new-header-with-blocks/\">Creating a new header with&nbsp;blocks </a></strong>was the topic of <strong>Wes Theron</strong>&#8216;s workshop on meetup. The recording is now available on WordPress TV. Explore how to build a header from scratch using a block theme! Gain a more profound understanding of how blocks are nested to create a header, and how to replace a header template part.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Darren Either</strong> created a recording of how he created the first iteration of the <a href=\"https://www.youtube.com/watch?v=2Es9nOtK6to\"><strong>Woo Swag Store homepage</strong></a> using FSE, Basti Theme, and various WooCommerce store editing features. The <a href=\"https://woocommerce.com/document/basti-theme/\">Basti theme by Anariel Design</a> is available in the WooCommerce Marketplace, <a href=\"https://www.anarieldesign.com/documentation/basti/\">documented here</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Anders Norén</strong> published his fourth block theme called <a href=\"https://wordpress.org/themes/bjork/\"><strong>Bjork</strong></a>, and introduced it <a href=\"https://andersnoren.se/introducing-bjork/\"><strong>in his blog post</strong></a>. He wrote: &#8220;Björk has a very classic blog theme structure, with a sidebar navigation to the left and the content to the right. You’ve seen hundreds of these WordPress themes before – I’ve released like six of them myself – but with the advent of block themes, everything old is new again. There aren’t many block themes with this structure on the theme directory yet.&#8221;</p>\n\n\n\n<p><strong>Sarah Gooding</strong> reviewed it in this article for the WPTavern: <a href=\"https://wptavern.com/anders-noren-releases-bjork-a-free-wordpress-block-theme-for-blogs-and-personal-websites\"><strong>Anders Norén Releases Björk, a Free WordPress Block Theme for Blogs and Personal Websites</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Marko Segota</strong> explains in his post, <a href=\"https://www.anarieldesign.com/how-to-create-header-in-a-block-wordpress-theme/\"><strong>How to Create a Header in a Block WordPress Theme (FSE)?</strong></a> &#8220;For a long time header layout was the least customizable part of a WordPress theme, but with the full-site editing (FSE) (that’s changed.&#8221; he wrote. </p>\n\n\n\n\n<p><em>Featured Image: Auto-genrated Image by Imajinn AI Block</em></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Sep 2022 03:54:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Post Status: Post Status Excerpt (No. 68) — On the Road to WordCamp US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=121658\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://poststatus.com/on-the-road-to-wordcamp-us/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:41476:\"<div class=\"wp-container-7 wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">In this episode Dan and Ny are tired! — but excited about heading to their first WordCamp of any kind. They talk about the things they\'re looking forward to seeing and doing at WCUS and in San Diego. Lots of interesting speakers and talks! Contributor day! Karaoke. Food comes up — a lot.  </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">29</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-drop-cap\">Dan and Ny are looking forward to attending <a href=\"https://us.wordcamp.org/2022/\">WordCamp US</a> this week, which is a first for them both. In a slightly more casual conversation touching their usual topics — the business of WordPress, careers, and community — they share the things they\'re looking forward to seeing and doing at WCUS and in San Diego. </p>\n\n\n\n<blockquote><p>So it\'s hard for people in the community to kind of branch out and communicate online. So imagine how hard it is for people who are new!</p><cite><strong>Nyasha Green</strong></cite></blockquote>\n\n\n\n<p>Some of the WCUS sessions they\'re interested in have to do with <a href=\"https://patchstack.com/articles/wordpress-bug-bounty/\">WordPress security and bug bounty programs</a>, cross-cultural communication, WordPress and performance, and getting young people into WordPress. Other tech and open source conferences also come up, as Ny is planning to attend <a href=\"https://2022.allthingsopen.org/\">All Things Open 2022</a> in Raleigh, North Carolina.</p>\n\n\n\n<p>Finally, Ny and Dan discover they both have non-tech backgrounds and started reading J.R.R. Tolkien at an early age. Ny talks about learning several languages and reading <em>The Hobbit</em> in Latin.</p>\n\n\n\n<div class=\"wp-container-10 wp-block-columns has-theme-palette-8-background-color has-background\" id=\"WP-Engine\">\n<div class=\"wp-container-8 wp-block-column\">\n<h3><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/pagely\">Pagely</a></h3>\n\n\n\n<p>Top-Tier Managed WordPress hosting solutions for Enterprise, the Public Sector, and Media companies. We invented Managed WordPress and we never stopped raising the bar. <strong>Expect Extraordinary!</strong></p>\n</div>\n\n\n\n<div class=\"wp-container-9 wp-block-column is-vertically-aligned-center\"><div class=\"wp-block-image\">\n<a href=\"https://poststat.us/pagely/\"><img width=\"752\" height=\"752\" src=\"https://cdn.poststatus.com/wp-content/uploads/2016/02/Pagely-Mark-Black-752x752.png\" alt=\"Pagely\" class=\"wp-image-93218\" title=\"WP Engine\" /></a></div></div>\n</div>\n\n\n\n<h3><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f44b.png\" alt=\"👋\" class=\"wp-smiley\" /> Credits</h3>\n\n\n\n<ul id=\"block-a3e9962f-97ca-4009-be8e-db47b5d1fddf\"><li><a href=\"https://twitter.com/Ny_The_Creator\">Nyasha Green</a>, Editorial Director at&nbsp;<a href=\"https://twitter.com/_MasterWP\">MasterWP</a>&nbsp;(Twitter)</li><li><a href=\"https://twitter.com/dan_knauss\">Dan Knauss</a><span>, Editor for </span><a href=\"https://twitter.com/post_status\">Post Status</a><span> (Twitter)</span></li><li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a>, Web Producer intern for Post Status (Twitter)</li></ul>\n\n\n\n<p class=\"has-background\">Every week <strong><a href=\"https://poststatus.com/podcast/the-excerpt/\">Post Status Excerpt</a></strong> will bring you a conversation about important news and issues in the WordPress community and business ecosystem. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /><br /><br />You can listen to <a href=\"https://poststatus.com/podcast/the-excerpt/\">past episodes</a> of <strong>The Excerpt</strong>, <a href=\"https://poststatus.com/category/post-status-podcasts/\">browse all our podcasts</a>, and don’t forget to subscribe on <a href=\"https://open.spotify.com/show/1m3xwXbe0MG5BzFVPtB0A7\">Spotify</a>, Amazon Music, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://castro.fm/podcast/c53552c6-1ee0-4fc4-9de4-08ed6bf1ee4d\">Castro</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://player.fm/series/wordpress-post-status-podcasts\">Player.fm</a>, <a href=\"https://pca.st/05rR\">Pocket Casts</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or by <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h1 id=\"h-transcript\">Transcript</h1>\n\n\n\n<p><strong>Dan Knauss:</strong> Morning. Ny</p>\n\n\n\n<p><strong>Nyasha Green:</strong> good morning, Dan. How are you?</p>\n\n\n\n<p><strong>Dan Knauss:</strong> All right. It\'s gonna be a busy, busy week prepping for travel to, um, word camp us. I\'m I\'m sure you\'re running fast and. hopefully getting some, some rest in there too, but how, how are things going</p>\n\n\n\n<p><strong>Nyasha Green:</strong> on there? I actually am getting rest. I think the holiday helped, but yeah, I\'m definitely running around like a chicken with a Ted cut off and , I\'m hoping I don\'t forget to pack anything, but I\'m very excited.</p>\n\n\n\n<p>This is going to be my first big word camp and my first time in San Diego. So I\'m super excited.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, me too. Yeah. I. haven\'t been down LA in a while, but yeah, never San Diego and first word camp. Um, yeah, the labor day was nice. It\'s one of those, uh, Canada has every province finds a way to have a, a long weekend every month.</p>\n\n\n\n<p>So you have a, there\'s always a Monday in the month off and they coincide with the us one. It probably as much as possible, although Thanksgiving is totally different time and oh yeah. so it\'s, it\'s interesting when you, you really, the rest of the world gets dragged along by the us holiday schedule, especially the big.</p>\n\n\n\n<p>Shopping ones and you know, nothing stops, email, doesn\'t stop, everything keeps going. And you know, sometimes it\'s a, it\'s a family day or , you know, a long weekend and no one else is, is, uh, aware of that.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> It sounds lovely.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> It can be, yeah. I I\'ve been slow to, to adjust to it. They kind of sneak up on me. well, what are you, what are you anticipating doing at, um, at word camp?</p>\n\n\n\n<p>What are you looking forward to?</p>\n\n\n\n<p><strong>Nyasha Green:</strong> I\'m looking forward to meeting a lot more people in the community. I\'ve only met a lot of people through, um, like Twitter, mostly and you know, the occasional popup on a podcast. So I\'m really excited to meet different people and talk with them and pick their brains. Oh yeah.</p>\n\n\n\n<p>In private. So that\'s going to be very awesome. What about you?</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Well, there\'s some, some lots of good talks. I\'m. wondering how I can fit that in and the hallway stuff. And there I\'ve, I\'ve met a, a number of our, our members and people. I happened to have known for a long time earlier this year at one, at a retreat we did.</p>\n\n\n\n<p>Um, but yeah, there will be a lot of people I meet for the first time. And it just, it seems like a lot to try to fit in at one point, but I\'m looking forward to contributor day where maybe someone where I can get, I can get. Oriented and, and doing something helpful. I, I, I really wanna get some time to, um, figure out how to ease into, to some things I can help with on a weekly basis.</p>\n\n\n\n<p>And it\'s just been kind of nuts lately. So that\'s been tricky. Yeah,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> that\'s gonna be awesome. I\'m really looking forward to that as well. Like I think with all of us in a room, it\'ll be a little easier than trying to, you know, do it over at the internet.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Oh yeah. Yeah. There\'s so much stuff that can be explained directly.</p>\n\n\n\n<p>Um, Synchronis communication at least, or if someone right there at your shoulder, um, that, you know, one more tab, one more thing to read. You know, I find like after, you know, after the productive hours of, of work 3, 4, 5 hours of if it\'s reading intensive and man, I just have to read a lot of stuff. It, you just lose that attention and processing ability.</p>\n\n\n\n<p>Um, Do you find that? Do you just. Where you\'re trying to read, you\'re scanning through something and you just like, what, what am I, oh yeah. What is, what was this about?</p>\n\n\n\n<p><strong>Nyasha Green:</strong> And constantly starting over. Oh yeah. it happens a lot.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> and when you\'re actually trying to learn a workflow or a process or a tool or something like that, you kind of want to get it in muscle memories.</p>\n\n\n\n<p>You wanna get it, or in some kind of whatever, part of your brain where you just don\'t have to like driving, you don\'t have to think about it. And, um, yeah, it\'s good to do that. First thing in the morning.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Um, is this your first work camp? Like big one? Yeah. Yeah, yeah. And</p>\n\n\n\n<p><strong>Dan Knauss:</strong> of any of any really? Um, when I was, um, first lived in a, in a city that was big enough to have things like that.</p>\n\n\n\n<p>Although I don\'t, I don\'t think Milwaukee\'s ever had a. I don\'t know. I wouldn\'t, I shouldn\'t say that there there\'s, there\'s a ton of WordPress people there mm-hmm um, I don\'t know if they\'ve had a, a word camp, but they didn\'t back then. So I was the, the little open source tech scene was taking off and it was mostly DRAL people around the Makerspace and those of us who did things in WordPress, where, um, well, WordPress was.</p>\n\n\n\n<p>Quite young at that point, I was more into Jula.</p>\n\n\n\n<p>There was that going on? So, you know, there was, there was kind of a general, there was a, um, bar camp that was a big deal, um, bar camp. What is that have bar camps like food bar? It was, um, it was not a platform specific thing, but it was getting dominated by the local Dal people and, uh, which I was totally into as well.</p>\n\n\n\n<p>Um, but it was a more general, um, uh, coder camp hacker kind of hacker space filled up with tons of kids and. You know, we\'re all younger then. Um, and I\'m yeah. I\'m, I\'m curious about the age demographics, uh, you know, I, I feel WordPress and word camps. We really need to, um, find ways to diversify in all directions, including oh yeah.</p>\n\n\n\n<p>Uh, age.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Oh, I\'m definitely interested in that as well. my, um, husband actually asked me, he was like, is gonna be a lot of people your age. And I was like, I don\'t know. Um, you know, , I know in some people at the company, my age that are going, but I was like, I don\'t know. I was like, this is going to be an interesting experience and it\'s not just WordPress.</p>\n\n\n\n<p>Um, I\'ve been to a lot of other big, uh, tech conventions though, and conferences and meetups mm-hmm and they\'ve been pretty diverse in terms of age, um, even race as well. I\'m really interested to see how work camp compares, especially since I\'m going to all things open in November. I\'m really excited for that.</p>\n\n\n\n<p>That\'s in Raleigh. and yeah, I\'m just very excited for my first work camp. I\'m I\'m already like prepping to go to work camp Asia as well. So hopefully it just blows my mind and I wanna go to all of them. I</p>\n\n\n\n<p><strong>Dan Knauss:</strong> wish, I wish I, well, I may be a few more here and there, but yeah, I\'d love to, um, yeah, Raleigh, I lived there for a number of years and university years and they\'re not real nice, nice place.</p>\n\n\n\n<p>So you\'ll have to write about that or tell us all about the all things. Yeah, we\'ll talk about it. Mm-hmm um, but more of a broad creator, uh, economy focused conference, I think. Right. Um, but</p>\n\n\n\n<p><strong>Nyasha Green:</strong> well, all things open source mm-hmm yeah. Yeah. So yeah,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> age diversity is great. I like it. I I\'ve enjoyed when I went back to classroom university.</p>\n\n\n\n<p>Teaching part-time a few years back after raising my own kids. And it was totally different than when like 20 years before when I had started. And hadn\'t, you know, I was, I was barely older than my students. um, I don\'t know. The dead perspective is sometimes nice when you\'ve meowed out and understand people need connection and confidence.</p>\n\n\n\n<p>Ahead of technical skill, you know, otherwise they just think you\'re saying you\'re doing everything wrong. Mm-hmm and yeah. So it\'s, it\'s great to have all, all ages. I love having older people around too, for their experience and usually come or</p>\n\n\n\n<p><strong>Nyasha Green:</strong> approach. Are you, are you going to be in dad mode at work camp?</p>\n\n\n\n<p>Oh, I don\'t</p>\n\n\n\n<p><strong>Dan Knauss:</strong> know. I don\'t know where I. I can come in at all. never really know. It depends on how much I sleep and I don\'t think there\'s that much sleeping that happens when you\'ve got party after party. Another other things going on. Um, yeah, I\'ll try to. Keep the energy up, but I\'m old. I ,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> you\'re not old.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> yeah, I can fool people, but oh yeah. It\'s an old,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> so when we get to karaoke and it\'s time for our duet, I don\'t wanna hear you say, oh, now I can\'t do this. I\'m tired.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> you pick a song yet? You got a place</p>\n\n\n\n<p><strong>Nyasha Green:</strong> where I have six or seven songs. So you can\'t tell me no, like, I\'m gonna say Dan, like you can\'t say no to all six</p>\n\n\n\n<p><strong>Dan Knauss:</strong> or seven.</p>\n\n\n\n<p>Okay. As soon as I open my mouth, though, you\'re gonna be like, okay.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> That\'s it? No, no, no. That\'s, that\'s what karaoke is for you. Don\'t take people who can sing to karaoke. That\'s the worst. That ruins karaoke</p>\n\n\n\n<p><strong>Dan Knauss:</strong> ah, yeah. Yeah. I haven\'t been in to one in a while. I like watching \'em there\'s a, a terrible place to eat dive bar, you know?</p>\n\n\n\n<p>And they\'ve like two kinds of bad Canadian beer. Okay. Downtown here. And it\'s just a weird place, but it\'s, it\'s right down from a, a, a. tall building that has a, a lot of retired people in it. And there were these, um, cute elderly ladies that would, would come down there and do do it along with, it was just the weirdest group of people.</p>\n\n\n\n<p>It was all ages and all love it kinds. And so, you know, some people were really fabulous at it and others were just fabulously. amateur and, um, you never know what you\'d get. It was, it was just great to watch. Um, I, I don\'t know that I\'ve seen that many. I\'ve definitely seen some, uh, in-home large house party, Asian karaoke that.</p>\n\n\n\n<p>it was just a D totally different thing. Oh,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> I love it. We, we did Korean style karaoke in Vegas. And when was that? March? Oh my God. I loved it so much. We just had like buckets of Soju and like, we were singing all night and dancing. I had a tambourine. It was so great. I slept in the Uber on the way back to the whole hotel.</p>\n\n\n\n<p>was wonderful. there\'s</p>\n\n\n\n<p><strong>Dan Knauss:</strong> always someone who, who thinks they\'re really good and is really earnest. And they\'re, you know, the dog\'s starting to how and .</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Oh, that\'s me. That\'s me. Oh, that\'s me. I can\'t wait. Oh, that\'s me. I\'m ready. I\'m ready. I\'m so ready.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> yeah, I know. Mm. Yeah, I was, I was not trained properly, but at, at any kind of music really too bad.</p>\n\n\n\n<p>My, my girls are, they\'ve had tons of tons of musical. Instruction, which they enjoy. But now I, I wanna kick their, their butts out into the street for busking. You can get be a licensed busker in Edmonton, in the summers. Um, but that\'s a totally different thing when you\'re performing live with other people.</p>\n\n\n\n<p>And it\'s a big, big confidence jump. Even if you do have the skills confidence. You gotta, you gotta push yourself out there and do it, I guess. So it\'s not, not my thing, but I wish I wish I could.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Well, we will make them proud this year. Somehow. See if someone gets video, it\'ll be okay. Oh, well,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> if anything ends up on the internet, that might be bad.</p>\n\n\n\n<p>I\'m I\'m not gonna share</p>\n\n\n\n<p><strong>Nyasha Green:</strong> that. No it for, okay. We\'ll discuss this later, so, okay. What speakers or sessions are you most excited to see at word? Um,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> I want, well I\'m Robert Rowley is a fun, you know, wild and crazy guy. I\'ve enjoyed talking books and random things with, and, and security is he he\'s with he\'s the security advocate at patch stack.</p>\n\n\n\n<p>And. Uh, he\'s, he\'s giving a talk. He did a really cool, crazy thing he\'s done before he did for us, but he he\'s done mm-hmm before where he teaches lock, picking, it\'s sort of a side hobby and he uses it to talk about security and philosophy of life and, and all kinds of, um, things like that. And so I\'m sure he\'s gonna.</p>\n\n\n\n<p>Entertaining and interesting. And it\'s, it\'s just security is a topic. I, I really like, and I\'ve paid more attention cuz he writes in podcasts about it quite a bit. Um, patch stack has a really cool, um, approach where they\'re, they\'re really encouraging collaboration through a network that they, um, I don\'t.</p>\n\n\n\n<p>It, it\'s a very, it\'s an open network. They sponsored, I, I guess they\'re kind of the ringleader, but anyone can, can join in the security profession and try to work to keep WordPress safe. I know they just, um, they partnered with hosting her to provide their, um, services. Um, both of those companies are, um, I think lot Vian, uh, mm-hmm multi.</p>\n\n\n\n<p>business members of, of post status. And they\'re, it\'s nice to see people get together and collaborate. And so they\'re providing it is security, uh, heads up, Hey, update your stuff inside your hosting panel, if you\'re with hosting or, and I noticed that that last little, there was three security, um, uh, patches in the, the little maintenance and security release that, that went out.</p>\n\n\n\n<p>Um, mm. the other day, a few days ago, last week. Um, and you don\'t initially find out all the details about it. And Robert later, um, commented on it, that they were actually, the security stuff was, was hunted down. There\'s a WordPress bug bounty program. Google has one too, where you can get mm-hmm money by finding.</p>\n\n\n\n<p>So it was, it was something that couldn\'t actually likely be exploited, but, um, within the parameters of, I guess, finding. Some kind of proof of concept that something could be exploited under certain conditions. You, you know, they, they patch that, check it out, learn some things. And, uh, so I think everyone usually assumes that there\'s something bad going on.</p>\n\n\n\n<p>Like some bad guys found something or it\'s, it\'s at risk. And sometimes it\'s just penetration testing analysis from the good guys and then they\'re fixing it so nice. It should be good press when, when things get better and stronger, uh, what\'s your number one session, man? I like there\'s all kinds of good stuff in here.</p>\n\n\n\n<p>Um,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> I think my favorite, favorite, favorite? is an anthropologist, a WordPress developer and a lawyer walking to a bar. Mm. Yeah. Cassandra Decker is doing that one about just communicating in the community, which is something I actually wrote about this, um, wrote about this week. And it talks about how to talk about talk with people in the community that may be from different walks of life.</p>\n\n\n\n<p>And that title really caught my eye because. I was interested in all three of these careers at one point, you know, I am a WordPress developer now I was interested in being an anthropologist. I even learned Latin for it. oh, really? And the, yeah, I\'m reading the Hobbit in Latin right now. My Latin is like S shotty.</p>\n\n\n\n<p>That was a while ago, but I\'m trying to relearn it. So I\'m reading the Hobbit in Latin and then I also was accepted in the law school, but I didn\'t. So I was like, oh, I\'m really, I\'m really interested in this. And I\'m interested in what she has to say. And, you know, it\'s always, I\'m always interested in opening up communication in the community as well.</p>\n\n\n\n<p>So that\'s my absolute favorite. I\'m not missing that one.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. That sounds really interesting. I love it. When people do interdisciplinary things or break out of the bubble and, and stuff like that. Mm-hmm , um, I, I didn\'t know that. So, you know, you\'re such. Non argumentative personality. I wouldn\'t think law would be attractive to you.</p>\n\n\n\n<p>Are you making</p>\n\n\n\n<p><strong>Nyasha Green:</strong> fun of me?</p>\n\n\n\n<p><strong>Dan Knauss:</strong> yeah, you\'d be a great lawyer. Um, you\'re making</p>\n\n\n\n<p><strong>Nyasha Green:</strong> fun of me. Oh my God. Yeah.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Latin. Um, yeah, I, I had to crash course one summer. Um, when I was doing, I did up to some level of, of graduate work in literature and. Literary cultural studies and Renaissance medieval stuff. And yeah, so we have these odd, odd backgrounds we could have might have explored at at one point, but language.</p>\n\n\n\n<p>You never really, you can\'t never go wrong. Like that\'s just cool to know, but you must be pretty good if you can read any of, of the Hobbit in, in Latin, which is crazy because Tolkin. Was this major, you know, Brian has probably, if, if you\'re not a token buff, Brian cords is probably said quite a few things.</p>\n\n\n\n<p>He seems to be quite a fan.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Mm. Um, I, I really like him a lot. Um, my grandmother actually, she had a copy of the Hobbit. I started reading. I tried to read when I was really young and I was like, okay, that goes back on the shelf. And then I read at a later age. So in order to help, I also have it in Spanish. I can speak Spanish and speaking Spanish.</p>\n\n\n\n<p>And I guess my limited English I\'m, I\'m joking. Um, Latin comes. It comes kind of easy when I can recognize it, you know, in different languages and I\'m learning Korean right now, so, oh yeah, I know that right. Duo. Yeah. So I\'ll probably eventually get the ho in Korean. So I guess</p>\n\n\n\n<p><strong>Dan Knauss:</strong> the Hobbit would be easier than Lord of the rings cuz oh yeah.</p>\n\n\n\n<p>yeah. I was trying to imagine, like, how would you do Latin? Does Tolkin knew so many languages? Mm-hmm and then he makes. All these Elish languages and different ways of writing it, the war and, or, oh yeah. All these things. Like how, how would you flatten that? All I\'ve always been curious about that. I, haven\'t not gotten fluent enough in another language to really feel, you know, like how do, when you\'re representing an, a different language mm-hmm, in your own language, like, um, Hemingway like used these and thousand and stuff when he\'s like, I think people are speaking in Spanish and, and things, and.</p>\n\n\n\n<p>I think it was in for whom the bell tolls mm-hmm how do you indicate a foreign language? You can do kind of dialect or accents and stuff, but, um, that would be tough, especially to learn, I guess, you know, you\'re fluent. If you\'re reading a foreign language and you\'re reading their creative manipulation of it to pretend to be.</p>\n\n\n\n<p>doing another foreign language.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Yeah. The books I have. Um, I read them on my iPad because, you know, anytime I don\'t understand anything, I can just click and find the word or find the, a reference for the phrase. But they\'re geared toward people who already speak English, who are trained to learn these other languages.</p>\n\n\n\n<p>Um, it was something I discovered, cuz I was gonna start with children\'s book. I was like, okay, I\'ll get like cat and a hat in Latin and stuff like that, which I did find some of those as well. And then it was like some people have, they were like the. It\'s written in different languages and, um, they have learning ones geared toward English speakers.</p>\n\n\n\n<p>I was like, oh my God. Yes. Cause I love the habit. I was reading it like every year at one point. So it was like, I\'m, I\'m so familiar with it in English, maybe, you know, it\'ll help. And then like I was on the first page in Latin for like three days. I was like, okay, let\'s just break all of this down. And then Spanish, you know, I was going a little faster cuz I can read Spanish, probably the best I can speak it, but I can read it the best.</p>\n\n\n\n<p>So that\'s just getting a really familiar. That you\'re really familiar with and going for it in a different language. I feel like that\'s very helpful. You know, the most helpful is talking to people, but the second most helpful.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> I, yeah, I, I envy that. I wish I, um, had time to go back and, and do more of languages and, and just reading, um, books, uh, and fiction again.</p>\n\n\n\n<p>But when I was, yeah, early, that was one of the, the first big books. I read all the tol and stuff. And we had a record, my brother and I , we had a record where it was a, it was like, it was based on the cartoon version of the Hobbit and the dramatic reading. Yeah. I\'ve seen it. Yeah. I could probably do the whole thing.</p>\n\n\n\n<p>Um,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> love it. .</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. Well, what else is is cool in, in here? I know, um, Molana cap is, is doing, is teaching, um, WP CLI do you use that at all? I\'ve it\'s been a long time since I played around with it, but</p>\n\n\n\n<p><strong>Nyasha Green:</strong> I do, I do cool. it doesn\'t make me the happiest, but I do. Cool. No, it\'s cool. I it\'s, I, I know it\'s useful. I just it\'s me.</p>\n\n\n\n<p>It\'s not, yeah, it\'s not WSP CLI it\'s me. I\'m the issue.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> She\'s on that. I know that one kind of jumped. Oh, and the performance, there\'s a performance session with the Felix arts toos going to he\'s on the performance team and has had a, a lot to contribute on that. So, um, I\'m not sure. I guess, talking, talking about, um, performance at scale.</p>\n\n\n\n<p>I\'m not sure if this is geared towards probably developers. Hosting people. I\'m just, I\'m curious what, what I might learn there. Um,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> I like a WordPress for the next generation. Mm. Um, that\'s the one I\'m very interested in. I think Columbia, I\'m so sorry if I say your name, wrong Hodge is doing it. Just talking about, um, entry, uh, barriers for young people and.</p>\n\n\n\n<p>You know, I talk a lot about that. I\'m very excited and, um, it\'s going to be a business talk. So I\'m very excited to go to that one as well, and like soak up knowledge so I can like turn around and use it to help people that\'s get into the community.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> That\'s really, I important. Have you, so you\'re the meetups that you\'re working on starting?</p>\n\n\n\n<p>How how\'s that going along? Do you think you\'ll reach a younger demographic with.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Yeah, I\'ve had, um, there are people who weren\'t even that I\'m mentoring in tech that weren\'t interested in. WordPress. They\'re interested in now solely after everything I\'ve said to them solely because they know that we\'re, they\'re going to be meetups near them.</p>\n\n\n\n<p>So they know that they\'ll be, you know, someone nearby to talk to. About getting into the community versus trying to do it all online. As we talk about, it\'s so hard to get it\'s. So it\'s hard for people in the community to kind of branch out and communicate online. So imagine how hard it is for people who are new and, you know, just having that in person meet up or that person nearby and to be able to meet other people in the community.</p>\n\n\n\n<p>It\'s already getting people, you know, my age and younger, who wants to come into the community. So I think it\'s going to be like a big push for word present in these areas that I\'m.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Good. Yeah, that\'s really needed. And, um, I hope, hope we\'ll hear more about the mentoring program that Josepha floated on, on Twitter says his, um, yes.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> In the words I\'m so excited. I\'m so excited about that. I cannot wait.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. Um, really, really an important one, I think. And cuz it does so many things at, at once it\'s um, this just good for people and, and. Relationships, um, anchors people in meaning and, and value that, um, you know, it\'s very basic human stuff.</p>\n\n\n\n<p>Um, if we were just training people, technically, you know, that\'s, that\'s not that that\'s not that interesting. Yeah. Mm-hmm ,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> I mean, it\'s needed to, but yeah, you\'re right. It\'s not that interesting.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> well, it\'s always an open source. It\'s always tended to. A culture and belonging mm-hmm and, um, mentoring is really what it is.</p>\n\n\n\n<p>It\'s a better way to, to approach it, um, to give people not just training options, but relationship options, where you\'re learning from a real person, who\'s connects to other people in this cooperative project. That\'s that\'s.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Yeah, I\'m really excited. This is to be so awesome. Like, I, I don\'t sound as excited as I am because I\'m tired, but I will have energy Thursday when I get there Thursday.</p>\n\n\n\n<p>Yeah. Do I get there Thursday? I should probably look into that. It\'s Tuesday, but yeah, I will have a lot of energy when I get there.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. I don\'t miss. All right. Miss your flight. Uh</p>\n\n\n\n<p><strong>Nyasha Green:</strong> oh yeah, no, I\'m flying with, uh, one of my coworkers, so she\'s not gonna let me miss my flight. Thank God. How long</p>\n\n\n\n<p><strong>Dan Knauss:</strong> is it for you?</p>\n\n\n\n<p>You prob you might have further to go than, than me. Um,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> it\'s only four and a half hours. Five. You gotta direct know it\'s not five, four and a half. Yeah, I got, I got a nonstop direct from Charlotte. So I\'m only 15 minutes away from the airport. I discovered this weekend when I was picking my brother and uncle up.</p>\n\n\n\n<p>So I am not far at all from the airport. That is lovely because when I stayed in South Carolina, I would have to drive either an hour and a half to Charlotte to FL somewhere or two hours to Charleston. And it sucked . So it was a all day travel event to go places.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. That\'s. Eh, travel can be the older you get the, not such a fun thing, but, uh,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> okay.</p>\n\n\n\n<p>Dad. Yeah.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> well, it\'s better without kids along some of the time, but uh, older, older kids. Um, but I\'m going on my own, but yeah, no direct flights anymore. Uh, from, from here, I, I don\'t think, but it\'s about six hours altogether.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> What\'s the first thing you\'re doing when you, when you land, like what, what\'s the first thing you want to do?</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Huh? I don\'t know. I\'ll just, uh, I\'ll get over to the place, get over to the joint and unpack, uh, see what\'s going on. I\'m sure people will be pretty well assembled by then. um, gotcha. The town and country. Um, I don\'t know if I don\'t get I\'ll probably want, want to quick do that and then find somewhere to. Um, late or, well, I\'ll probably do that in the way it\'ll be fairly late.</p>\n\n\n\n<p>So I don\'t know. It might just step out. That\'s so interested.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Yeah. We, there might be like good, good night street food. I don\'t know. This is my first time in San Diego. I\'m really excited. So. , I don\'t know the first thing I\'m doing. I think I\'m enjoying being in California. I love California. I don\'t care what part put me in it I\'ll go.</p>\n\n\n\n<p>So that\'s my first thing.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> I never really been in the Northern end of it. It would probably be more my speed. I don\'t know, originally from the Northeast and a lot of time in the Midwest and in south it\'s, uh, I\'m kind of biased on the Eastern end of the the country and, um, people who aren\'t that relaxed.</p>\n\n\n\n<p>Oh,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> whatever</p>\n\n\n\n<p><strong>Dan Knauss:</strong> I need. I need a certain amount of road rage around, uh,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> um, oh, I\'m sure you\'ll get that. I feel like , that\'s that\'s American the American way. No,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> I, I don\'t miss that, but you know, I, I did like the Northeastern, um, punchiness of, oh, it\'s not necessarily unfriendly, but willingness to engage with people.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Blunt, blunt, strangers.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. Yeah. The. Seinfeld experience isn\'t too, too far off the reality, or maybe as it used to be. I, I always enjoy, um, living in a, in a city where you can\'t really control or predict, predict what\'s gonna happen in public space. And, um, for all the soup around here, I haven\'t found a soup Nazi yet, but there\'s usually there\'s usually a good place or some.</p>\n\n\n\n<p>Food mogul who controls access to the, the good bond me or something like that. And you gotta please them to make sure. You\'re getting the good stuff</p>\n\n\n\n<p><strong>Nyasha Green:</strong> now I\'m hungry. I love bombing. I\'m so hungry. Yeah. I that\'s, I really want to, yeah. I wanna try like good Italian and Mexican. I heard it\'s really good in San Diego, but also I wanna try some really good, different Vietnamese, Thai and Japanese.</p>\n\n\n\n<p>Those are my, I don\'t know if I\'ll have enough stomach for</p>\n\n\n\n<p><strong>Dan Knauss:</strong> I\'ll follow you around. Yeah. I\'ve. Enjoy that a lot too. And Edmonton\'s great for all things, Asian and really just in general, it\'s surprising. Um, when you move out here, not knowing anything about it, how much, uh, how much there is and good eats, um, Definitely.</p>\n\n\n\n<p>Yeah. The tacos. Um, I\'ve been making margaritas lately cuz the summer\'s ending and I don\'t know, I just got inspired to, uh, to do that. It\'s a really nice drink. I, Milwaukee was great for Mexican. I missed a lot of the places that were were there. That\'s and they\'re a little weak on that. Maybe here. There\'s a few good few good places.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Well, I guess next week, we\'re going to talk about like food, right? Like where we ate at work camp. mm-hmm yeah, this is where the word press community ate during word camp with Dan and I, I</p>\n\n\n\n<p><strong>Dan Knauss:</strong> like it. I know there\'s a contingent. That\'s all interested in the, um, in and out burger. I don\'t know if they\'re big Laki fans, but I\'ve never been to an in and out burger, but</p>\n\n\n\n<p><strong>Nyasha Green:</strong> I love in and out.</p>\n\n\n\n<p>I eat it every time I go to the west coast, I have to eat it like. It\'s not, I couldn\'t even tell you why it\'s so good. It\'s like, not even great, but I love it. And I\'m yes.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Hmm. I don\'t have to try it. I, I don\'t know. I mean, I\'m neutral. um, sounds kind of like the white castle, you know, for. Chicago people. Um, don\'t get a bunch of sliders.</p>\n\n\n\n<p>I remember the first time as a kid, when I was Chicago, you have to go to white, white castle. Um, I don\'t know if that\'s even a thing anymore. I miss, um, I haven\'t heard people mention that in a long time. And man from North Carolina, I don\'t, I, I miss the, just the. Franchise unpredictable barbecues and big victims and spicy stuff.</p>\n\n\n\n<p>But, uh, BOJ angles had was really good. Hot curly fries, poor BOJ</p>\n\n\n\n<p><strong>Nyasha Green:</strong> angles. what that, yeah. That\'s where everybody comes here and wants Bojangles. Um, is that considered</p>\n\n\n\n<p><strong>Dan Knauss:</strong> good? My brother walked there when he was in high school once and he\'d get all these bags of curly fries. The only thing I liked. Oh. And.</p>\n\n\n\n<p>Someone had like milkshakes with big chunks of peach in them in</p>\n\n\n\n<p><strong>Nyasha Green:</strong> the summer cook cookout, cookout. That\'s what people like here. They like to come get cookout and Bojangles mm-hmm Bojangles is good. I do like Bojangles cookout is okay. Um, I, I see the, I see the nostalgia and stuff. Why people like it personally, and I hope nobody from North Carolina.</p>\n\n\n\n<p>Is like listening in, sorry, Dan. I think the barbecue is way better in South Carolina. I have not been inspired yet to eat more barbecue here. I\'m actually like every time I go home, I eat barbecue cuz I\'m like, I just can\'t eat it in North Carolina, but it\'s only been a month. I\'ll give North Carolina about two more chances to get me some good barbecue.</p>\n\n\n\n<p>That might be true,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> but I\'d take, I take anything. No, one\'s no one\'s doing it up. Um, no, that, that was the Mississippi culture guaranteed that there was always a Sunday Southern barbecue somewhere in Milwaukee. Mm-hmm but uh, I\'ve missed. a long time since then. And you might be right. I was in Aiken, uh, outside Columbia mm-hmm South Carolina, 1993 in the summer at this that\'s a beautiful old town, these big streets and trees pre automobile.</p>\n\n\n\n<p>Um, and there was a staying at this kind of cool little. Old fashioned estate that is probably as old as the town. And, uh, they brought in a, um, a, uh, bluegrass band and, you know, roasting the pig in the mm-hmm back garden for eight hours or so, I dunno, it takes a long time. Um, yeah, that was good. That\'s the most memorable one I\'ve I\'ve been at.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> Oh yeah. You gotta come to South Carolina. I would invite you now, but it\'s like two last minute, but you know, SU the Southern funeral. So I\'ve been back and forth for a funeral arrangements and oh yeah. When I, last time I went, they had burnt ends, macaroni and cheese, barbecue hash, and like chopped barbecue.</p>\n\n\n\n<p>Hash rice, which people probably don\'t know what hash is outside of the south. Mm. Um, uh, they had cream corn and like stuffing and, uh, coleslaw and baked beans and ribs. And I was like, oh my God. Yeah. Somebody make a, made a five. Flavored pound cake. Like I was like, I gotta go. Y\'all like, I\'ve gained too much weight.</p>\n\n\n\n<p>Like I have to go. I have to see people this week. Like my cheeks are swollen. Like everybody know let\'s everybody stop cooking. And then they\'re like, well, we\'re frying chicken tomorrow. Please stop everybody. Stop. please. You</p>\n\n\n\n<p><strong>Dan Knauss:</strong> got reminded of your mortality. You may as well eat well</p>\n\n\n\n<p><strong>Nyasha Green:</strong> you\'re right. Move yourself.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> You\'re right along, faster, down. Hard to attack</p>\n\n\n\n<p><strong>Nyasha Green:</strong> trackers. I\'m I\'m here for a good time. Not a long time.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> yeah. Yeah. Well, yeah, it\'s hard to, hard to pass up. Good, good food. Yeah. Maybe I\'ll make it back out to the so Southeast sometime and yeah, I miss, I been away long enough from a place to, to start to. Miss or remember things affectionately.</p>\n\n\n\n<p>Uh,</p>\n\n\n\n<p><strong>Nyasha Green:</strong> oh yeah. And I gotta bring you your moon pies. I remember you said yeah.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Little things like that from man. I don\'t miss working outside in the summers there though. I I\'ll come in the winter.</p>\n\n\n\n<p><strong>Nyasha Green:</strong> yeah, do, yeah, we have two weeks of winter now, so you\'ll be completely fine.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Awesome. Oh, well that\'s gonna warm here too.</p>\n\n\n\n<p>All right. Well, I will let you and I. Get through our short week here and oh yeah. Try to pack our bags and, and then, yeah, we\'re gonna sounds like we\'re gonna have a good time. Yeah. We\'re</p>\n\n\n\n<p><strong>Nyasha Green:</strong> gonna meet up in San Diego. We can\'t have a bad time. I\'m not gonna have a bad time. So you\'re not gonna have a bad time.</p>\n\n\n\n<p>No. All right. That\'s math. . </p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 Sep 2022 00:15:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WordPress.com Defies Marked Increase in Russian Takedown Demands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137723\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/wordpress-com-defies-marked-increase-in-russian-takedown-demands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3531:\"<p>Automattic <a href=\"https://transparency.automattic.com/2022/09/07/transparency-report-update-january-june-2022/\">published</a> its bi-annual transparency report this week, which highlights the different information and takedown demands received across the company&#8217;s services. </p>\n\n\n\n<p>Historically, Automattic has used these reports as an opportunity to publicly reaffirm its commitment to actively pushing back against requests that violate users&#8217; freedom of speech and bring attention to abusive takedown demands. In 2014, the company <a href=\"https://wptavern.com/automattic-open-sources-its-dmca-process-docs-on-github\">open sourced its DMCA takedown process documents</a> to help others implement their own processes. Past transparency reports have included information on intellectual property disputes, IRUs (reports from dedicated government Internet Referral Units), national security letters, government information requests, and other issues related to hosted content.</p>\n\n\n\n<p>In 2021, Automattic published a <a href=\"https://transparency.automattic.com/\">unified landing page</a> for WordPress.com and Tumblr&#8217;s transparency reports, which are now hosted on the same site, aimed at making it easier to navigate and compare the data. In the future this may include the company&#8217;s other products like Day One and Pocket Casts, as relevant requests come in.</p>\n\n\n\n<p>The most recent <a href=\"https://transparency.automattic.com/2022/09/07/transparency-report-update-january-june-2022/\">report</a> for the first half of 2022, includes information on the Russian censorship requests WordPress.com received.</p>\n\n\n\n<p>&#8220;Over the past six months, in the wake of the Russian invasion of Ukraine, we have seen a marked increase in the number of takedown demands that target content which is critical of the Russian government and associates,&#8221; WordPress.com Community Guardian Stephen McLeod Blythe said. He cited specific examples relating to the Russian invasion of Ukraine:</p>\n\n\n\n<ul>\n<li>Fundraising for Ukranian aid</li>\n\n\n\n<li>Outlining Russian history with a perspective on what led to the war in Ukraine</li>\n\n\n\n<li>Alleging criminal activity on the part of Russian oligarchs, and their personal connections to Putin</li>\n\n\n\n<li>Publishing commentary from former Russian soldiers who were critical of the military involvement in Ukraine</li>\n</ul>\n\n\n\n<p>&#8220;In all of these cases, given our concerns about access to critical information from within Russia, and the implications for freedom of expression, we made the determination that we would&nbsp;<strong>not</strong>&nbsp;geoblock the content at issue,&#8221; Blythe said.</p>\n\n\n\n<p>The report also included information on how Automattic resolved IP blocks from two major ISPs in Colombia, after the country blocked Tumblr without disclosing the reason. Colombia&#8217;s Ministry of Technologies and Communications had blocked the service after discovering a spam blog on the network. Despite the fact that Automattic had already removed the blog, the process of unblocking Tumblr took months.</p>\n\n\n\n<p>&#8220;Situations such as these are not uncommon, and, as the above example demonstrates, the issue of government censorship online or regional platform blocks cannot be reflected solely by the numbers of takedown demands that are received,&#8221; Blythe said. &#8220;As a result, we are committed to continually reviewing and expanding the information that we are able to share in our transparency report.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Sep 2022 21:16:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordCamp US 2022 Kicks Off Today, Free Livestream Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137691\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/wordcamp-us-2022-kicks-off-today-free-livestream-available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2178:\"<p>WordCamp US 2022 is underway in San Diego, California, following last night&#8217;s welcome party for speakers, sponsors, organizers, and volunteers. For many attendees, this is their first in-person WordPress event since 2019, before the pandemic began shutting down conferences.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Good times tonight at the Sponsors / Speakers / Volunteers / Organizers welcoming party. Took the time to practice some photography for this week. <a href=\"https://twitter.com/hashtag/WCUS?src=hash&ref_src=twsrc%5Etfw\">#WCUS</a> <a href=\"https://t.co/g8fJPtz3Mi\">pic.twitter.com/g8fJPtz3Mi</a></p>&mdash; Daniel Schutzsmith (At #WCUS WordCamp US) (@schutzsmith) <a href=\"https://twitter.com/schutzsmith/status/1568114598871728128?ref_src=twsrc%5Etfw\">September 9, 2022</a></blockquote>\n</div>\n\n\n\n<p>Unlike previous events, where attendees numbered in the thousands, this year tickets were capped at 650. They were sold out the first day they went on sale. A smaller crowd should make for a more intimate event where attendees have a higher chance of bumping into the people they hoped to meet.</p>\n\n\n\n<p>Opening remarks are expected at 9am PDT. WordCamp US&#8217; <a href=\"https://us.wordcamp.org/2022/schedule/\">schedule</a> includes 41 sessions over the span of two days. Those who are not able to attend in person can still catch the livestream for both tracks, without any special ticket required. Access is free and presentations will be shown live as they are happening on the two tracks:</p>\n\n\n\n<p>Sun Track: <a href=\"https://us.wordcamp.org/2022/livestream/sun-fri/\">https://us.wordcamp.org/2022/livestream/sun-fri/</a></p>\n\n\n\n<p>Palm Track <a href=\"https://us.wordcamp.org/2022/livestream/palm-fri/\">https://us.wordcamp.org/2022/livestream/palm-fri/</a></p>\n\n\n\n<p>Virtual participants can use the #WCUS hashtag on Twitter to join in the global conversation. </p>\n\n\n\n<p>On Saturday, September 10, Matt Mullenweg will deliver an address at 4:45 pm -5:30 pm PDT and answer live questions from WordCamp US attendees. This will also be streamed live as the last session of the event.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Sep 2022 14:24:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: WordPress Announces 10 Style Variation Selections for Twenty Twenty-Three Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137672\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wptavern.com/wordpress-announces-10-style-variation-selections-for-twenty-twenty-three-theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3191:\"<p>WordPress&#8217; design team has announced the winners of the challenge to create a style variation for the upcoming Twenty Twenty-Three (TT3) default theme. Organizers received <a href=\"https://github.com/WordPress/twentytwentythree/issues?page=1&q=is%3Aissue+is%3Aopen+label%3A%22%5BType%5D+Style+Variation%22\">38 submissions</a> from 19 contributors (some submitted multiple variations) hailing from eight countries. </p>\n\n\n\n<p>Given the wide range of colors and typography combinations, TT3 is gearing up to be a vehicle for a diverse set of styles from WordPress&#8217; community of designers. Submissions included creative variations for all kinds of design moods &#8211; dark with high contrast, bright yellow with a smaller universal type size, a gradient aubergine background, and many more. </p>\n\n\n\n<p>Automattic design director Channing Ritter <a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\">published</a> the selections that made the cut to be shipped with Twenty Twenty-Three:</p>\n\n\n\n\n\n\n\n<p>&#8220;These variations were selected in an effort to feature the most drastically different set of variations possible — so in many ways, we were looking at what would work best as a collection versus selecting our favorite standalone submissions,&#8221; Ritter said.</p>\n\n\n\n<p>The selections are not in their final form. Contributors will continue iterating on them, under the direction of design team leaders, until the WordPress 6.1 beta period begins on September 20.</p>\n\n\n\n<p>&#8220;Some of the changes suggested may be a bit aspirational, but let’s continue pushing to see how opinionated we can make each of these variations,&#8221; Ritter said.</p>\n\n\n\n<p>Submissions that were not chosen to ship with TT3 may still have a path towards inclusion via an official child theme of the default theme. Contributors <a href=\"https://github.com/WordPress/twentytwentythree/issues/73\">discussed</a> how this might work and have closed the issue in favor of creating a separate project for it after TT3 has launched.</p>\n\n\n\n<p>&#8220;I particularly like the idea of continuing to create style variations beyond those that are bundled with TT3,&#8221; Automattic-sponsored contributor Sarah Norris said. &#8220;I think this is a great opportunity to introduce people to block themes and building variations, with the help of the community and experienced block-themers. It also provides a space to test Gutenberg PRs, in a similar way to how <code>emptytheme</code> is currently used, but with more opinionated settings enabled.</p>\n\n\n\n<p>&#8220;I&#8217;m not sure about this being part of the current TT3 project, and in my opinion, it would be best to start this initiative soon after TT3 has launched.&#8221; </p>\n\n\n\n<p>In the meantime, contributors plan to refine the selected variations, and the child theme project can proceed without affecting the theme&#8217;s current timeline.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/#comment-26608\">announcement</a> to see each of the selected variations in more detail.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Sep 2022 21:21:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: Anders Norén Releases Björk, a Free WordPress Block Theme for Blogs and Personal Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/anders-noren-releases-bjork-a-free-wordpress-block-theme-for-blogs-and-personal-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3853:\"<p>WordPress theme author Anders Norén is at it again with a new&nbsp;minimal block theme for blogs and personal websites.&nbsp;<a href=\"https://wordpress.org/themes/bjork/\">Björk</a> is the 129th block theme to hit the directory and Norén&#8217;s 25th free WordPress theme. It follows the <a href=\"https://wptavern.com/poe-a-bold-new-portfolio-theme-with-30-block-patterns-and-10-style-variations\">release of Poe</a>, a portfolio style theme, less than two months ago.</p>\n\n\n\n<p>Although Norén said he is a fan of the Icelandic singer, his new theme is named for his favorite tree. Björk is the Swedish name for birch.</p>\n\n\n\n<p>&#8220;Birch trees are incredibly resilient, which is why you can find them closer to the tree line on the Swedish&nbsp;<a href=\"https://en.wikipedia.org/wiki/Fell\">fjäll</a>&nbsp;than any other type of tree,&#8221; Norén said. &#8220;They’re also very pretty to look at.&#8221; </p>\n\n\n\n<p>The default style for the theme certainly has a birch-like appearance with its white background and use of <a href=\"https://fonts.google.com/specimen/Albert+Sans\">Albert Sans</a>, a Google font designed by Danish type designer Andreas Rasmussen who was inspired by the type-characteristics of Scandinavian architects and designers in the early 20th century.</p>\n\n\n\n<img />\n\n\n\n<p>Desktop viewers will see a sticky sidebar menu for quick navigation links. This disappears on smaller screen sizes in favor of a hamburger menu. </p>\n\n\n\n<p>&#8220;Björk has a very classic blog theme structure, with a sidebar navigation to the left and the content to the right,&#8221; Norén said in a post <a href=\"https://andersnoren.se/introducing-bjork/\">introducing the new theme</a>. &#8220;You’ve seen hundreds of these WordPress themes before – I’ve released like six of them myself – but with the advent of block themes, everything old is new again. There aren’t a lot of block themes with this structure on the theme directory yet.&#8221;</p>\n\n\n\n<p>Björk includes seven different theme styles, in addition to the default, which can instantly change the look of the website.</p>\n\n\n\n<img />\n\n\n\n<p>Norén has also included more than 15 block patterns, which enable users to mix and match and quickly build their own layouts for the front page or other pages. Patterns include designs for featured items with an image, heading, paragraph and button, a testimonials section, multiple hero patterns, call-to-action patterns, and more.</p>\n\n\n\n<img />\n\n\n\n<p>When you install and activate the theme for the first time, you get all of the layouts in place, including the front page. This makes it easy for users to get started by simply replacing the content or rearranging it to suit their unique needs. <a href=\"https://andersnoren.se/themes/bjork/\">Check out the demo</a> to see approximately how it will look once installed. </p>\n\n\n\n<p>Björk was built using Norén&#8217;s Davis Blocks theme as a foundation, the same framework used to build Poe, his last release. It&#8217;s a small package, with just 500 lines of CSS and no JavaScript.</p>\n\n\n\n<p>Björk is available to <a href=\"https://wordpress.org/themes/bjork/\">download for free on WordPress.org</a> or via the &#8220;Add New&#8221; themes screen in the admin.</p>\n\n\n\n<p>&#8220;The Site Editor has really come a long way in a short amount of time,&#8221;  Norén said. &#8220;The most noticeable difference is that I’m having a lot more fun building block themes now compared to when I released&nbsp;<a href=\"https://andersnoren.se/teman/tove-wordpress-theme/\">Tove</a>, my first block theme, a year ago. With the features&nbsp;<a href=\"https://wptavern.com/wordpress-6-1-to-focus-on-refining-full-site-editing-next-phase-collaboration-and-multilingual-features-anticipated-in-2023-2025\">coming in WordPress 6.1</a>&nbsp;in October, it’s only up from here.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Sep 2022 16:47:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: iThemes Patches Vulnerability in BackupBuddy, Wordfence Tracks 5 Million Exploit Attempts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137631\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/ithemes-patches-vulnerability-in-backupbuddy-wordfence-tracks-5-million-exploit-attempts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1879:\"<p>BackupBuddy, a commercial plugin from iThemes that performs scheduled backups with remote storage options, has patched a vulnerability that allowed for arbitrary file download by unauthenticated users. iThemes <a href=\"https://ithemes.com/blog/wordpress-vulnerability-report-special-edition-september-6-2022-backupbuddy/\">published an advisory</a> for its users, indicating that the vulnerability affects versions 8.5.8.0 through 8.7.4.1 and is being actively exploited.</p>\n\n\n\n<p>Wordfence reviewed its data and found that attackers began targeting this vulnerability on August 26, 2022. The company has <a href=\"https://www.wordfence.com/blog/2022/09/psa-nearly-5-million-attacks-blocked-targeting-0-day-in-backupbuddy-plugin/\">blocked nearly 5 million attacks</a> targeting the vulnerability since that time.</p>\n\n\n\n<p>Wordfence found that the method BackupBuddy used to download locally stored files was insecurely implemented, making it possible for unauthenticated users to download any file stored on the server.</p>\n\n\n\n<p>&#8220;Due to this vulnerability being actively exploited, and its ease of exploitation, we are sharing minimal details about this vulnerability,&#8221; Wordfence threat analyst Chloe Chamberland said.</p>\n\n\n\n<p>Wordfence found the majority of the attacks are attempting to read sensitive files, including the following:</p>\n\n\n\n<ul>\n<li>/etc/passwd</li>\n\n\n\n<li>/wp-config.php</li>\n\n\n\n<li>.my.cnf</li>\n\n\n\n<li>.accesshash</li>\n</ul>\n\n\n\n<p>iThemes published specific indicators of compromise and detailed steps to detect if a site was attacked. The company outlined additional steps for sites that have been compromised. </p>\n\n\n\n<p>All BackupBuddy users are advised to update to the patched version 8.7.5. iThemes made it available to all users, regardless of their current BackupBuddy licensing status, due to the severity of the vulnerability.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Sep 2022 19:42:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"Post Status: WordPress 6.1 Walkthrough, Dropping 3.7 – 4.0 Security Updates, WordPress Advanced Administration Handbook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=121526\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://poststatus.com/wordpress-6-1-walkthrough-dropping-3-7-4-0-security-updates-wordpress-advanced-administration-handbook/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13815:\"<h2 id=\"h-this-week-at-wordpress-org-september-5-2022\">This Week at WordPress.org (September 5, 2022)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Get ready for WordPress 6.1! There\'s a live walkthrough coming for it on September 13, and the feature freeze is September 20. Other important news: security updates will no longer be backported for WordPress 3.7-4.0, and there\'s a new Advanced WordPress Administration handbook.  </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div id=\"kt-info-box_b3b811-01\" class=\"wp-block-kadence-infobox\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kt-info-svg-icon kt-info-svg-icon-fe_alertTriangle\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\"><a href=\"https://make.wordpress.org/core/2022/08/10/proposal-stop-merging-experimental-apis-from-gutenberg-to-wordpress-core/\">Get Ready for WordPress 6.1</a></h2><p class=\"kt-blocks-info-box-text\">Feature freeze is coming on September 20, 2022. <br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f6b6-200d-2642-fe0f.png\" alt=\"🚶‍♂️\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/09/05/6-1-product-walk-through/\">6.1 Product Walk-Through</a> <br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f53d.png\" alt=\"🔽\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2022/09/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\">Dropping security updates for WordPress versions 3.7 through 4.0</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4da.png\" alt=\"📚\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/hosting/2022/09/07/wordpress-advanced-administration-handbook/\">WordPress Advanced Administration Handbook</a></p></div></div></div>\n\n\n\n<h2 id=\"h-news\">News</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/news/2022/09/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\">Dropping security updates for WordPress versions 3.7 through 4.0</a></li><li><a href=\"https://wordpress.org/news/2022/09/the-month-in-wordpress-august-2022/\">The Month in WordPress – August 2022</a></li><li><a href=\"https://wordpress.org/news/2022/09/episode-38-all-about-learnwp-with-special-guest-hauwa-abashiya/\">WP Briefing: Episode 38: All About LearnWP with Special Guest Hauwa Abashiya</a></li></ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_598f7a-1a\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"wp-container-17 wp-block-columns\">\n<div class=\"wp-container-15 wp-block-column\">\n<h2 id=\"h-accessibility\"><a href=\"https://make.wordpress.org/accessibility\">Accessibility</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/accessibility/2022/08/29/use-of-accessibility-ready-tag-for-block-based-themes/\">Use of accessibility-ready tag for block-based themes</a></li></ul>\n\n\n\n<h2 id=\"h-community\">Community</h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/community/2022/09/07/2023-global-sponsorship-working-group/\">2023 Global Sponsorship Working Group</a></li></ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/09/05/6-1-product-walk-through/\">6.1 Product Walk-Through</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/01/a-week-in-core-august-29-2022/\">A Week in Core – August 29, 2022</a></li></ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/09/07/core-editor-chat-summary-7th-september-2022/\">Core Editor chat summary: 7th September 2022</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/05/editor-chat-agenda-7th-september-2022/\">Editor chat agenda – 7th September 2022</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/07/devchat-agenda-postponed-to-september-11/\">Devchat agenda: postponed to September 11</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/01/dev-chat-summary-august-31-2022/\">Dev Chat Summary, August 31, 2022</a></li></ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/docs/2022/08/30/summary-of-docs-team-biweekly-meeting-august-30-2022/\"></a><a href=\"https://make.wordpress.org/docs/2022/09/05/documentation-team-meeting-postponed-to-wcus-contributor-day/\">Documentation team meeting postponed to WCUS Contributor Day</a></li><li><a href=\"https://make.wordpress.org/docs/2022/08/30/summary-of-docs-team-biweekly-meeting-august-30-2022/#:~:text=Tracker/issues/225-,Advanced,-Admin\">WordPress Advanced Administration Handbook</a></li></ul>\n\n\n\n<h2><a href=\"https://wordpress.org/five-for-the-future/\">Five for the Future</a></h2>\n\n\n\n<ul><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/214\">Deactivate inactive pledges</a></li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/212\">Remove contributor hours when account banned</a>&nbsp;</li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/210\">Use last 5ftF contribution as inactivity criteria</a></li></ul>\n\n\n\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/hosting/2022/09/07/wordpress-advanced-administration-handbook/\">WordPress Advanced Administration Handbook</a></li><li><strong>PROPOSAL:</strong> <a href=\"https://make.wordpress.org/hosting/2022/08/18/proposal-updating-wp_memory_limit/\">Updating WP_MEMORY_LIMIT</a></li></ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/marketing/2022/09/07/agenda-global-marketing-team-meeting-september-7-2022/\">Agenda, global Marketing Team meeting, September 7, 2022</a></li></ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/meta/2022/09/05/improving-devhub-code-references/\">Improving DevHub Code References</a></li><li><a href=\"https://make.wordpress.org/meta/2022/09/01/simplifying-the-admin-bar-global-navigation-menu/\">Simplifying the Admin Bar & Global Navigation Menu</a></li></ul>\n\n\n\n<h2 id=\"h-mobile\"><a href=\"https://make.wordpress.org/mobile\">Mobile</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/mobile/2022/09/06/call-for-testing-wordpress-for-ios-20-7/\">Call for Testing: WordPress for iOS 20.7</a></li></ul>\n</div>\n\n\n\n<div class=\"wp-container-16 wp-block-column\">\n<h2 id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/openverse/2022/09/07/frontend-release-v3-4-8-and-a-call-for-a11y-testing/\">Frontend Release v3.4.8 and a call for a11y testing</a></li><li><a href=\"https://make.wordpress.org/openverse/2022/09/07/community-meeting-recap-6-september-2022/\">Community meeting recap (6 September 2022)</a></li><li><a href=\"https://make.wordpress.org/openverse/2022/09/05/openverse-biweekly-update-september-5th/\">Openverse Biweekly Update – September 5th</a></li><li><a href=\"https://make.wordpress.org/openverse/2022/09/02/applying-ecs-to-the-ingestion-server-data-refresh/\">Applying ECS to the ingestion server/data refresh</a></li></ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/09/06/performance-team-meeting-summary-6-september-2022/\">Performance team meeting summary 6 September 2022</a></li><li><strong>Proposal:</strong> <a href=\"https://github.com/WordPress/performance/issues/455\">Database performance Health Checks</a></li></ul>\n\n\n\n<h2 id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/updates/2022/08/29/plugin-review-team-29-aug-2022/\">Plugin Review Team: 29 Aug 2022</a></li></ul>\n\n\n\n<h2 id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/polyglots/2022/09/07/word-counting-type-setting-for-locales/\">Word counting type setting for Locales</a></li><li><a href=\"https://make.wordpress.org/polyglots/2022/09/07/agenda-weekly-polyglots-chat-sep-7-2022-700-utc/\">Agenda: Weekly Polyglots Chat – Sep. 7, 2022 (7:00 UTC)</a></li><li><a href=\"https://make.wordpress.org/polyglots/2022/09/06/announcement-wordpress-translation-day-2022/\">Announcement: WordPress Translation Day 2022</a></li></ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/test/2022/09/06/fse-program-back-to-basics-summary/\">FSE Program Back to Basics Summary</a></li></ul>\n\n\n\n<h2 id=\"h-themes\"><a href=\"https://make.wordpress.org/themes\">Themes</a></h2>\n\n\n\n<ul><li><strong>FEEDBACK REQUESTED:</strong> <a href=\"https://make.wordpress.org/themes/2022/08/15/testing-and-feedback-for-the-fluid-typography-feature/\">Testing and Feedback for the Fluid Typography Feature</a></li><li><a href=\"https://make.wordpress.org/updates/2022/08/16/themes-team-update-august-16-2022/\"></a><a href=\"https://make.wordpress.org/themes/2022/08/23/themes-team-meeting-notes-august-23-2022/\">Themes Team Meeting Notes –&nbsp;August 23, 2022</a></li><li><a href=\"https://make.wordpress.org/updates/2022/08/30/test-team-update-30-august-2022/\">Test Team Update: 30 August 2022</a></li></ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/training/2022/09/07/training-team-meeting-recap-september-6/\">Training Team Meeting Recap –&nbsp;September 6</a></li><li><a href=\"https://make.wordpress.org/training/2022/09/07/proposal-for-github-process-updates/\">Proposal for GitHub Process Updates</a></li></ul>\n\n\n\n<h3 id=\"h-tutorials\">Tutorials</h3>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/tutorial/styling-your-wordpress-block/\">Styling your WordPress Blocks</a></li></ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops:</h3>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/?meeting=all-about-reusable-blocks\">All About Reusable Blocks</a></li><li><a href=\"https://learn.wordpress.org/?meeting=lets-code-a-beginners-guide-to-block-locking-in-block-themes\">Let’s code! A Beginners Guide to Block Locking in Block Themes</a></li></ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li></ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul><li><a href=\"https://thephp.foundation/blog/2022/08/30/php-core-roundup-5/\">PHP Core Roundup #5</a></li><li><a href=\"https://tc39.es/#proposals\">ECMAScript Proposals</a></li></ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/business-membership/\">your whole team</a> can <a href=\"https://poststatus.com/post-status-membership-club/\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Sep 2022 18:47:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: WordPress To Drop Security Updates for Versions 3.7 Through 4.0 by December, 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137618\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/wordpress-to-drop-security-updates-for-versions-3-7-through-4-0-by-december-2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2453:\"<p>WordPress&#8217; Security Team <a href=\"https://make.wordpress.org/security/2022/09/07/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\">announced</a> it will be dropping support for versions 3.7 through 4.0 on December 1, 2022. To give some context for how old these versions are, in 2013, <a href=\"https://wptavern.com/wordpress-3-7-released-wordpress-now-updates-itself\">WordPress 3.7 introduced automatic background updates</a> and <a href=\"https://wptavern.com/wordpress-3-8-parker-released\">3.8 updated the admin</a> with a new design <a href=\"https://make.wordpress.org/design/2013/03/09/as-a-continuation-of-the-work-begun-in/\">based on the MP6 plugin</a>.</p>\n\n\n\n<p>WordPress&#8217; official policy is that the security team only provides support for the most recent version, but as a courtesy has extended backporting security fixes to older versions that are able to receive automatic updates.</p>\n\n\n\n<p>&#8220;Until now, these courtesy backports have included all versions of WordPress supporting automatic updates,&#8221; 10up-sponsored Security Team member Peter Wilson said. &#8220;Versions WordPress 3.7 – 4.0 have reached levels of usage, namely&nbsp;<a href=\"https://wordpress.org/about/stats/\">less than 1% of total installs</a>, where the benefit of providing these updates is outweighed by the effort involved.&#8221;</p>\n\n\n\n<p>More than half of all WordPress sites are on the latest version &#8211; 6.0+ (54.3%), and security updates will still be available to more than 99% of sites on older versions after this change. Wilson said the decision to drop support for 3.7 through 4.0 was based off the information reported on the <a href=\"https://wordpress.org/about/stats/\">statistics</a> page.</p>\n\n\n\n<img /><a href=\"https://wordpress.org/about/stats/\">WordPress version stats</a> &#8211; 9/7/2022\n\n\n\n<p>&#8220;The effect of this imbalance means that the Security team spends most of the time preparing backports for the vast minority of WordPress installations,&#8221; Wilson said. &#8220;By dropping support for these older versions, the newer versions of WordPress will become more secure as more time can be focused on their needs.&#8221;</p>\n\n\n\n<p>Over the next three months, versions 4.0 and older will receive their final updates and will also display a non-dismissible notice in the dashboard, advising users to upgrade to the latest version as their sites will no longer receive security updates.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Sep 2022 16:37:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WordPress.org blog: Dropping security updates for WordPress versions 3.7 through 4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13466\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wordpress.org/news/2022/09/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1323:\"<p>As of December 1, 2022 the WordPress Security Team will no longer provide security updates for WordPress versions 3.7 through 4.0.</p>\n\n\n\n<p>These versions of WordPress were first released eight or more years ago so the vast majority of WordPress installations run a more recent version of WordPress. The chances this will affect your site, or sites, is very small.</p>\n\n\n\n<p>If you are unsure if you are running an up-to-date version of WordPress, please log in to your site’s dashboard. Out of date versions of WordPress will display a notice that looks like this:</p>\n\n\n\n<img width=\"698\" height=\"81\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/update-notice.png?resize=698%2C81&ssl=1\" alt=\"WordPress update notice: \" />\n\n\n\n<p>In WordPress versions 3.8 &#8211; 4.0, the version you are running is displayed in the bottom of the “At a Glance” section of the dashboard. In WordPress 3.7 this section is titled “Right Now”.</p>\n\n\n\n<img width=\"1024\" height=\"295\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/09/at-a-glance-widget.png?resize=1024%2C295&ssl=1\" alt=\"\" />\n\n\n\n<p>The Make WordPress Security blog has further details about <a href=\"https://make.wordpress.org/security/2022/09/07/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\">the process to end support</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Sep 2022 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Peter Wilson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Gutenberg Contributors Make Progress on Distraction Free Mode\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137582\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/gutenberg-contributors-make-progress-on-distraction-free-mode\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3318:\"<p>During last week&#8217;s <a href=\"https://make.wordpress.org/core/2022/08/31/editor-chat-summary-10-august-2022-2-2-2/\">Editor chat meeting</a>, Automattic-sponsored Gutenberg contributor Andrei Draganescu reported that he is &#8220;slowly but definitely going to&nbsp;<a rel=\"noreferrer noopener\" href=\"https://github.com/WordPress/gutenberg/pull/41740\" target=\"_blank\">introduce distraction free mode</a>,&#8221; a project he has been working on since <a href=\"https://wptavern.com/gutenberg-contributors-begin-early-exploration-of-a-new-distraction-free-mode\">early explorations</a> began in February. The PR he referenced (<a href=\"https://github.com/WordPress/gutenberg/pull/41740\">#41740</a>) is an extension of those explorations that takes the mode even further towards the objective of removing visual clutter when the focus is on editing text content.</p>\n\n\n\n<p>&#8220;Until now the preference, when toggled on, would only hide some of the toolbar icons and a few other non-essential UI items,&#8221; Draganescu said. &#8220;With this PR the preference will have a more drastic effect, turning the UI into a blank page.&#8221;</p>\n\n\n\n\n\n\n\n<p>Whereas the previous explorations were more focused on&nbsp;removing UI from the canvas, the demo video above shows how Draganescu&#8217;s PR takes it even further to create a full-page writing-focused environment. This iteration does the following:</p>\n\n\n\n<ul>\n<li>hides the top toolbar, makes it appear on hover over its normal occupied<br />area</li>\n\n\n\n<li>removes many top toolbar buttons</li>\n\n\n\n<li>automatically closes any open sidebars</li>\n\n\n\n<li>hides the insertion point indicator</li>\n\n\n\n<li>hides the block toolbar</li>\n</ul>\n\n\n\n<p>The menu to turn on this mode would be added to the three-dot drop-down menu under the other alternative modes.</p>\n\n\n\n<img />\n\n\n\n<p>Draganescu said there are a few outstanding bugs and the UI copy is still under consideration (distraction free, toggle interface), but he said he thinks it will be &#8220;a great complement to the incoming &#8216;zoomed out mode.\'&#8221; </p>\n\n\n\n<p>Gutenberg engineer Riad Benguella created an experimental <a href=\"https://github.com/WordPress/gutenberg/pull/41156\">PR for the zoom-out view</a> idea for the site editor, where the focus is on site building and composing patterns, allowing users to move sections around without affecting inner blocks. It makes it easier to build templates without worrying about block editing. Draganescu said if this code lands, it may lend some foundation to the distraction free mode.</p>\n\n\n\n<p>This feature has generally received positive feedback, with a few minor suggestions to correct issues with dismissing the screen and the autosave message. The team does not seem to be in a rush to land distraction free mode in Gutenberg but significant progress has been made over the past six months.</p>\n\n\n\n<p>With distractions increasing in the the digital world, some of the most reliable and efficient interfaces are those committed to staying distraction free. The current Fullscreen mode falls short here, as different parts of the interface pop in and out of view when the mouse is moved around the screen. Draganescu&#8217;s attempt at making a new, distraction free UI, more tailored to writing, would be a welcome addition to Gutenberg.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Sep 2022 01:47:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Do The Woo Community: Builder Tips from WordCampUS Speakers Part_3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72861\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://dothewoo.io/builder-tips-from-wordcampus-speakers-part_3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:417:\"<p>Tips from Rich Tabor, Cassandra Decker, Robert Rowley, Daisy Olsen, Ronnie Burt, Amber Hinds, Jonathan Desrosiers and Ronald Gijsel</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/builder-tips-from-wordcampus-speakers-part_3/\">Builder Tips from WordCampUS Speakers Part_3</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Sep 2022 11:31:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Post Status: What is a WordPress developer?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=121418\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/what-is-a-wordpress-developer/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1186:\"<p>That was <a href=\"https://poststatus.com/whats-a-wordpress-developer/\">the question</a> on <a href=\"https://dothewoo.io/defining-a-worpress-developer/\">an episode</a> of <strong>Woo DevChat</strong> with <strong>Ebonie Butler</strong>, <strong>Lisa Canini</strong>, <strong>Robbie Adair</strong>, and <strong>Kathy Zant</strong>. It\'s an interesting to compare their views and experiences with the ones shared by <strong>Zach Stepek</strong>, <strong>Till Krüss</strong>, and <strong>Carl Alexander</strong> while discussing the same question on <a href=\"https://poststatus.us6.list-manage.com/track/click?u=ff3456b27ebe0be0155087894&id=a8f0a4c9fb&e=f7eab97ac0\">an earlier episode</a>. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://dothewoo.io/defining-a-worpress-developer/\">What is a WordPress Developer with Ebonie, Lisa, Kathy and Robbie</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\nhttps://poststatus.us6.list-manage.com/track/click?u=ff3456b27ebe0be0155087894&#038;id=a8f0a4c9fb&#038;e=f7eab97ac0\n</div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Sep 2022 01:50:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WordPress.org blog: The Month in WordPress – August 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13445\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2022/09/the-month-in-wordpress-august-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14582:\"<p>August has been a busy month, with the redesign of WordPress.org, new localized content on Learn WordPress, and the WordPress 6.0.2 security and maintenance release. But that&#8217;s not all! Read on to catch up on the latest WordPress news.</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h2>WordPress 6.1 walk-through scheduled for September 13, 2022</h2>\n\n\n\n<p>Save the date! A <strong>live interactive walk-through of WordPress 6.1 is coming up on September 13, 2022, at 16:00 UTC</strong>. The event will take place <a href=\"http://dotorgzoom.wordpress.com/\">via Zoom</a> and include a discussion of new major features, resolved tickets, and potential blockers.</p>\n\n\n\n<p>Attendance is open to anyone who wants to know more about what’s coming in the next major release. If you are unable to attend, the event will be recorded for on-demand viewing.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://make.wordpress.org/core/2022/09/05/6-1-product-walk-through/\">Learn more about the WordPress 6.1 product walk-through</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>The WordPress.org Homepage and Download page got a new jazz-inspired look</h2>\n\n\n\n<p>The <a href=\"https://wordpress.org/news/2022/08/a-new-wordpress-org-homepage-and-download-page/\">redesign of the WordPress.org homepage and download page</a> went live on August 15, 2022. The new pages highlight the benefits of using WordPress while making it easy to access resources for getting started. The look and feel build on the jazzy aesthetic that WordPress is known for.</p>\n\n\n\n<img width=\"1024\" height=\"599\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/08/launch-featured.png?resize=1024%2C599&ssl=1\" alt=\"WordPress.org homepage\" class=\"wp-image-13323\" />\n\n\n\n<p>In addition, <a href=\"https://make.wordpress.org/meta/2022/09/01/simplifying-the-admin-bar-global-navigation-menu/\">the admin bar and global navigation menu have been updated</a> to simplify and better organize the content across the WordPress.org network. Expect more design updates and iterations as efforts to refresh the website continue.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Check out the new <a href=\"https://wordpress.org/\">WordPress.org homepage</a> and <a href=\"https://wordpress.org/download/\">download page</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Gutenberg versions 13.9 and 14.0 are here</h2>\n\n\n\n<p>Two new versions of Gutenberg were released last month:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/08/17/whats-new-in-gutenberg-13-9-17-august/\"><strong>Gutenberg 13.9</strong></a> became available for download on August 17, 2022. This release continues to iterate and polish the user interface (UI), interaction, and engine work for site editing.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/\"><strong>Gutenberg 14.0</strong></a> brings a lot of enhancements, including extra block supports in the UI, a revamped List block, and more. It shipped on August 31, 2022.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>This <a href=\"https://make.wordpress.org/core/2022/08/25/core-editor-improvement-refining-the-template-creation-experience/\">new post in the &#8220;Core Editor Improvement&#8221; series</a> focuses on the template creation enhancements coming in WordPress 6.1. You can explore them now with the <a href=\"https://wordpress.org/plugins/gutenberg/\">Gutengerg plugin</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>New localized content on Learn WordPress</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is currently expanding the non-English resources available on the platform! Last month, some members of the Training Team hosted <a href=\"https://wordpress.tv/2022/08/17/%e3%83%96%e3%83%ad%e3%83%83%e3%82%af%e3%82%a8%e3%83%87%e3%82%a3%e3%82%bf%e3%83%bc%e3%81%a7%e3%83%9b%e3%83%bc%e3%83%a0%e3%83%9a%e3%83%bc%e3%82%b8%e3%82%92%e4%bd%9c%e3%82%8d%e3%81%86%ef%bc%81/\">the first free online workshops in Japanese</a>. Following its success, two more sessions will be held on September 7 and 17, 2022. Get the details in the <a href=\"https://learn.wordpress.org/online-workshops/\">online workshop calendar</a>.</p>\n\n\n\n<p>In addition, learners have access to:</p>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorials/?series=&topic=&language=pt_BR&captions=&wp_version=\">Portuguese tutorials</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/lesson-plans/greek/\">Greek lesson plans</a></li>\n</ul>\n\n\n\n<p>Curious about what else is new on Learn WordPress? <a href=\"https://make.wordpress.org/updates/2022/09/01/whats-new-on-learnwp-august-2022/\">Check out the learning materials released in August 2022</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p class=\"has-extra-large-font-size\">Enter the educational world of the Training Team and its Learn initiative in <a href=\"https://wordpress.org/news/2022/09/episode-38-all-about-learnwp-with-special-guest-hauwa-abashiya/\">the latest episode of WP Briefing</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Team updates: WordPress 6.0.2 maintenance release, Twenty Twenty-Three kickoff, and more</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/08/wordpress-6-0-2-security-and-maintenance-release/\">WordPress 6.0.2 is now available</a>. This security and maintenance release features 12 bug fixes on Core, 5 bug fixes for the Block Editor, and 3 security fixes.</li>\n\n\n\n<li>The new <a href=\"https://make.wordpress.org/design/2022/08/10/twenty-twenty-three-default-theme-project-kickoff/\">Twenty Twenty-Three (TT3) theme</a>, which will ship with the WordPress 6.1 release, is now in development. The theme will bundle a collection of style variations designed by community members. The final curated set is expected to be chosen by September 7, 2022.</li>\n\n\n\n<li>The <a href=\"https://make.wordpress.org/community/2022/08/19/meetup-organizer-newsletter-august-2022/\">August edition of the Meetup Organizer Newsletter</a> shares tips on how to join and support the <a href=\"https://make.wordpress.org/community/2022/07/08/call-for-supporters-reactivating-wordpress-meetups-around-the-world/\">Meetup Reactivation project</a>.</li>\n\n\n\n<li>The feedback tool for <a href=\"https://translate.wordpress.org/\">translate.wordpress.org</a> is now available for all WordPress.org users that have opted into notifications. Learn more in the latest edition of the <a href=\"https://make.wordpress.org/polyglots/2022/08/22/polyglots-monthly-newsletter-august-2022/\">Polyglots Monthly Newsletter</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meta/2022/09/05/improving-devhub-code-references/\">Code references in DevHub (WordPress Developer Docs)</a> are now easier to use, understand and navigate.</li>\n\n\n\n<li>Members of the Documentation Team kicked off discussions around the <a href=\"https://make.wordpress.org/docs/2022/08/10/kick-off-wordpress-6-1-release-docs/\">WordPress 6.1 release docs</a>.</li>\n\n\n\n<li>The <a href=\"https://make.wordpress.org/core/2022/08/09/bug-scrub-schedule-for-6-1/\">bug scrub schedule for WordPress 6.1</a> was published last month. Anyone can join these sessions to learn, help, or even <a href=\"https://make.wordpress.org/core/handbook/tutorials/leading-bug-scrubs/\">lead one</a>.</li>\n\n\n\n<li>To celebrate World Photography Day (August 19), the Photos Team <a href=\"https://make.wordpress.org/photos/2022/08/18/wordpress-world-photography-day-challenge-2022/\">set up a fun photo challenge</a> to contribute to the <a href=\"https://wordpress.org/photos/t/worldphotographyday22/\">WordPress Photo Directory</a>. The initiative may be over, but photo contributions are always open!</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/performance/2022/08/09/core-performance-team-rep-nominations/\">Nominations</a> for the Performance Team Reps are open until September 9, 2022.</li>\n\n\n\n<li>Why is Gutenberg being developed on GitHub? Is Gutenberg part of core? <a href=\"https://make.wordpress.org/core/2022/08/18/wordpress-development-setup/\">Get answers</a> to these and other common questions about WordPress core and Gutenberg.</li>\n\n\n\n<li>Members of the Full Site Editing Outreach program <a href=\"https://make.wordpress.org/test/2022/08/25/hallway-hangout-discussion-on-block-themes-25-aug/\">joined a Hallway Hangout session to talk about block themes</a>, from workflow changes to tools they are using and more.</li>\n\n\n\n<li>The latest edition of People of WordPress features <a href=\"https://wordpress.org/news/2022/08/people-of-wordpress-bud-kraus/\">Bud Kraus</a> and his inspiring WordPress journey.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>The Testing Team is looking for <a href=\"https://make.wordpress.org/test/2022/08/10/testing-testing-calls-for-testing-facilitators/\">facilitators to expand testing efforts</a> across the project.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Feedback &amp; testing requests</h2>\n\n\n\n<ul>\n<li>Are you a meetup organizer or member? Complete the 2021-2022 <a href=\"https://make.wordpress.org/community/2022/08/02/announcing-the-2021-2022-annual-meetup-survey/\">Annual Meetup Survey</a> (available in 14 languages) to help strengthen this global WordPress program.</li>\n\n\n\n<li>Members of the Core Team are looking for feedback on a <a href=\"https://make.wordpress.org/core/2022/08/19/a-new-system-for-simply-and-reliably-updating-html-attributes/\">new system for updating HTML attributes</a>. The call is open until September 9, 2022.</li>\n\n\n\n<li>There’s a new proposal to <a href=\"https://make.wordpress.org/core/2022/08/10/proposal-stop-merging-experimental-apis-from-gutenberg-to-wordpress-core/\">harmonize the process of merging new APIs from the Gutenberg plugin</a> to the WordPress core. Share your thoughts by September 7, 2022.</li>\n\n\n\n<li>Version 20.6 of WordPress for <a href=\"https://make.wordpress.org/mobile/2022/08/23/call-for-testing-wordpress-for-android-20-6/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2022/08/22/call-for-testing-wordpress-for-ios-20-6/\">iOS</a> is available for testing.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Gutenberg 13.8 introduced the first version of fluid typography, a new feature that allows theme authors to define text size that can scale and adapt to changes in screen size. <a href=\"https://make.wordpress.org/themes/2022/08/15/testing-and-feedback-for-the-fluid-typography-feature/\">Help shape its future by joining this testing call</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Event updates &amp; WordCamps</h2>\n\n\n\n<ul>\n<li><a href=\"https://us.wordcamp.org/2022/wcus-what-you-need-to-know/\">Get ready for WordCamp US</a>! The event is happening on September 9 through 11, 2022, in San Diego, California. <a href=\"https://us.wordcamp.org/2022/schedule/\">Check out the schedule</a> and tune into the <a href=\"https://us.wordcamp.org/2022/livestream/\">WCUS livestream</a> if you are attending virtually.</li>\n\n\n\n<li>Openverse announced that they will be participating in the WordCamp US <a href=\"https://us.wordcamp.org/2022/contributor-day/\">Contributor Day</a> remotely. <a href=\"https://make.wordpress.org/openverse/2022/08/30/openverse-remote-contributor-day-at-wordcamp-us-2022/\">Learn how you can get involved</a>.</li>\n\n\n\n<li><a href=\"https://asia.wordcamp.org/2023/\">WordCamp Asia</a> organizers <a href=\"https://asia.wordcamp.org/2023/tickets-now-on-sale/\">sold out</a> the first batch of standard and micro sponsor tickets in one day. The second batch will be released soon.</li>\n\n\n\n<li>Planning for WordCamp Europe 2023 is in full swing! You can still <a href=\"https://europe.wordcamp.org/2023/call-for-organisers/\">apply to be an organizer</a>.</li>\n\n\n\n<li>Join #WPDiversity with a <a href=\"https://www.eventbrite.com/e/speaker-workshop-for-indian-women-in-the-wordpress-community-sept-24-25-tickets-348466712317\">free, online speaker workshop for Indian women</a> in the WordPress community. The event will take place on September 24-25, 2022.</li>\n\n\n\n<li>Don’t miss these other upcoming WordCamps:\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1f3-1f1f1.png\" alt=\"🇳🇱\" class=\"wp-smiley\" /> <a href=\"https://netherlands.wordcamp.org/2022/\">WordCamp Netherlands</a>, The Netherlands on September 15-16, 2022</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ea-1f1f8.png\" alt=\"🇪🇸\" class=\"wp-smiley\" /> <a href=\"https://pontevedra.wordcamp.org/2022/\">WordCamp Pontevedra</a>, Spain on September 24-25, 2022</li>\n</ul>\n</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>The Call for Speakers for WordCamp Asia is closing soon! <a href=\"https://asia.wordcamp.org/2023/call-for-speakers/\">Submit your application by September 30, 2022</a>, and help reach <a href=\"https://asia.wordcamp.org/2023/speaker-diversity-goals/\">WCAsia&#8217;s speaker diversity goals</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<p><strong><em><strong><em><strong><em>Have a story that we should include in the next issue of The Month in WordPress? <strong><em>Fill out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this quick form</em></strong></a><strong><em> to let us know.</em></strong></em></strong></em></strong></em></strong></p>\n\n\n\n<p><em><em>The following folks contributed to this edition of The Month in WordPress: <a href=\"https://profiles.wordpress.org/laurlittle/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>laurlittle</a>, <a href=\"https://profiles.wordpress.org/mysweetcate/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mysweetcate</a>, <a href=\"https://profiles.wordpress.org/chaion07/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chaion07</a>, <a href=\"https://profiles.wordpress.org/bsanevans/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bsanevans</a>, <a href=\"https://profiles.wordpress.org/priethor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>priethor</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>.</em></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2022 13:23:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WordPress.org blog: WP Briefing: Episode 38: All About LearnWP with Special Guest Hauwa Abashiya\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13425\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wordpress.org/news/2022/09/episode-38-all-about-learnwp-with-special-guest-hauwa-abashiya/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20613:\"<p>In the thirty-eighth episode of the WordPress Briefing, join Josepha Haden Chomphosy and special guest Hauwa Abashiya for a discussion on the WordPress Training team and LearnWP initiative. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a> <br />Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2>Guests</h2>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a>&nbsp;</p>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://heropress.com/essays/finding-my-global-family/\">Hauwa Abashiya HeroPress Essay</a><br /><a href=\"https://make.wordpress.org/training\">make.wordpress.org/training</a><br /><a href=\"http://make.wordpress.org\">make.wordpress.org</a><br /><a href=\"https://wordpress.org/news/2022/08/wordpress-6-0-2-security-and-maintenance-release/\">WordPress 6.0.2 Security and Maintenance Release</a><br /><a href=\"https://asia.wordcamp.org/2023/call-for-speakers/\">WordCamp Asia call for speakers </a>(deadline extended to September 30, 2022)<br /><a href=\"https://us.wordcamp.org/2022/livestream/\">WordCamp US Livestream information</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13425\"></span>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello, everyone! And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of some of the ideas behind the WordPress open source project and the community around it, as well as get a small list of big things coming up in the next two weeks. I’m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:42]&nbsp;</strong></p>\n\n\n\n<p>Helping people who are new to WordPress learn how to make the most out of their CMS used to be one of the most clearly impactful things I ever did as a contributor. Whether it was making sure a brand new installation simply worked, or if the original setup needed to grow along with a solopreneur&#8217;s growing business needs, I found great joy in seeing how my local community was learning new tools together.</p>\n\n\n\n<p>You&#8217;ve probably heard me talk about the Learn WP initiative or the training team on this podcast before, but you might still be a little shy to get started with the team. So I have invited one of their team reps today to talk through what the team does.</p>\n\n\n\n<p>All right. I have with us today Hauwa Abashiya. She is one of the team reps for the training team and also works on the learn.wordpress.org site. Thank you for joining me today, Hauwa.</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:01:33]&nbsp;</strong></p>\n\n\n\n<p>And thank you for having me, Josepha, quite exciting to be on your podcast.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:01:37]&nbsp;</strong></p>\n\n\n\n<p>Oh, I, you know, when we were talking about doing this topic, I was like, you know, who would be an excellent person is Hauwa. Like you were such an interesting person to work with when we were working on the <a href=\"https://wordpress.org/news/2020/12/simone/\">5.6 release</a>. And then also, you just have such a lovely way of explaining the complicated things that we have going on in WordPress and especially on the training side of things. And so you were the first person that came to mind for me.</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:02:02]</strong></p>\n\n\n\n<p>Thank you.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:02:03]</strong></p>\n\n\n\n<p>Speaking of all the learn.wordpress.org things, you&#8217;ve been contributing to the WordPress project as a team rep for the training team for a bit. But that&#8217;s not really where you started. Can you tell me a bit about how you found your way to this team?&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:02:15]</strong></p>\n\n\n\n<p>Well, I started by attending a WordCamp, and that was WordCamp Brighton. And if anyone&#8217;s read my <a href=\"https://heropress.com/essays/finding-my-global-family/\">article on HeroPress</a>, then they will know that I learned WordPress in one week. Went through beginner sessions of it. And then, I was like, yeah, let me just go turn up and see what it&#8217;s like.</p>\n\n\n\n<p>So turned up, and I met some wonderful people there. One of them being <a href=\"https://profiles.wordpress.org/miss_jwo/\">Jenny Wong</a>, who introduced me to the London meetup team. So, I then went there. They were looking for volunteers because they were planning WordCamp London for 2019. And me being me, I was like, yeah, sure. Why not? And got thrown into the deep end, but no, an amazing team.</p>\n\n\n\n<p>I got to meet some really amazing people. And yeah, just went from there then, you know, because I was doing stuff with WordCamp London, ended up going to WordCamp Europe. And I think there&#8217;s probably quite a lot of people who say they fully got into contributing in WordCamp Europe. So I was doing little bits and pieces then on like, marketing team and then met <a href=\"https://profiles.wordpress.org/jessecowens/\">Jesse [Owens]</a>  at the training team cause <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> introduced me to him and just went from there.</p>\n\n\n\n<p>And then in terms of team rep, I mean, <a href=\"https://wordpress.org/support/users/courane01/\">Courtney Robertson</a> sent out SOS, because Learn had just launched, and there were a couple of things that we needed. So that was during the soft launch. And I was like, yeah, sure. I&#8217;ll help you. I&#8217;m not doing much. And that&#8217;s how I ended up doing team rep.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:03:46]</strong></p>\n\n\n\n<p>I love that so many initial stories in the WordPress community start with like, well, I went to a WordCamp cause I was like, what in the world is this? And then people were like, we need some help. And I thought to myself, what else am I doing? Like, so many stories start that way. And I just love it.&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:04:03]</strong></p>\n\n\n\n<p>Yeah.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:03]</strong></p>\n\n\n\n<p>So you mentioned learn.wordpress.org. That is a part of the training team in the WordPress project. Correct?</p>\n\n\n\n<p>Yeah. So can you give us an idea of the difference between the two? Cause like normally, with a project as big as Learn, you would expect to see like a whole separate team. But these are two intertwined teams using two intertwined concepts.</p>\n\n\n\n<p>And so can you give us an idea of the difference between them?&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:04:29]</strong></p>\n\n\n\n<p>So I like to see learners, that&#8217;s the content. So it&#8217;s the content that we have on the platform, and the training team wrangles all the content on Learn. So that would be like your videos, your lesson plans, and online workshops. Yeah, so we wrangle the content that&#8217;s on there.</p>\n\n\n\n<p>We try to bring a lot of different teams together, and that&#8217;s one of the things the beauty, I think, of Learn is that there is a lot of cross-team collaboration, which started from the beginning and I think just will continue and get better and better.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:59]</strong></p>\n\n\n\n<p>Yeah. And the workshops, those are once a week, right?&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:05:04]</strong></p>\n\n\n\n<p>Yeah. So you have online workshops, which used to be called social learning spaces, which used to be called discussion groups. So those run once a week. There&#8217;s a number running, and there are some that are launching in Japan. And I think <a href=\"https://profiles.wordpress.org/bsanevans/\">Ben Evans</a> has been quite key in getting quite a lot of those going, and I think <a href=\"https://profiles.wordpress.org/piyopiyofox/\">Destiny Kanno</a> as well.</p>\n\n\n\n<p>So, that&#8217;s the beauty is you get to see a lot more languages coming up. Those run once a week. And then we obviously have lesson plans, which traditionally that&#8217;s what the training team used to always make for Meetup organizers. So if you didn&#8217;t have a speaker, you could go and get a lesson plan and run through something, or anybody could pick one up.</p>\n\n\n\n<p>So they are used mainly by like our Meetup users and then people who are running any boot camps or sessions, or you wanna just take somebody through WordPress and teach them, you can pick one up and run through it. And now we&#8217;ve got courses on Learn, which is quite exciting. Got a couple of courses.</p>\n\n\n\n<p>And I know there&#8217;s about three or four courses in development. There is a bit more WordPress development based rather than user based. There&#8217;s a fourth piece of content, and that is just the general workshop. So tutorials, I think no tutorials is what we&#8217;re calling them now. So there&#8217;s like all our online videos.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:06:17]</strong></p>\n\n\n\n<p>I tell you terminology in any project, the age and size of WordPress is hard to keep everything straight, but especially when you&#8217;ve just changed it you&#8217;re like, what do we call it though?&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:06:27]</strong></p>\n\n\n\n<p>Yeah.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:06:30]</strong></p>\n\n\n\n<p>So if I understand correctly, because as you mentioned, like you have this post up on HeroPress, you don&#8217;t actually come from a training background. Like you aren&#8217;t a teacher or corporate trainer or anything, but you have really committed to contributing to the training team and to learn.wordpress.org.</p>\n\n\n\n<p>So, from your perspective, from like the, I&#8217;m not a trainer perspective, what&#8217;s the most exciting thing for learn.wordpress.org in the near future?&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:06:58]</strong></p>\n\n\n\n<p>I think it&#8217;s the collaboration. It&#8217;s the potential that Learn has. So I don&#8217;t have a training background, but interestingly enough, I come from Kaduna, Nigeria. And Kaduna cause all the states in Nigeria have a tagline, and, Kaduna is actually the center of learning. So there must be some link there, so yeah.</p>\n\n\n\n<p>So, I think the beauty of that is you don&#8217;t have to have a training background. You can come in and impart your knowledge, and there are people available in the team that can help you impart that knowledge. So if it&#8217;s like a lesson plan that you wanna draw up, we&#8217;ve got people that can help and assist in that.</p>\n\n\n\n<p>Or you wanna run an online workshop. There are people that can assist you. And I think that&#8217;s also the beauty of WordPress is that we&#8217;re all there to help each other. So just seeing that and seeing how, as time has gone on how the team has actually just been growing cause more and more people are coming.</p>\n\n\n\n<p>And then with that, you&#8217;ve got more of like the different languages coming in, and I know we might touch on that later, but it&#8217;s, I think to me, that is the beauty that anyone can actually now come in and learn. And Learn as this platform that is accessible to everybody. So it&#8217;s not necessarily behind a, like a paywall or anything, which is, there&#8217;s nothing wrong with that, but there are people that it&#8217;s like, well, okay, you can access something by the community for the community.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:08:32]</strong></p>\n\n\n\n<p>I think like your last thought there, something that&#8217;s by the community for the community. That&#8217;s one of the things that I noticed early on about the WordPress community. So I&#8217;ve been in the WordPress community for a long time, but when I started doing the administrative back office, things that are invisible and no one wants to know about, because it&#8217;s boring.</p>\n\n\n\n<p>When I started doing that work, one of the things I noticed and that I really treasure the most about the WordPress community is that they want to do things together. They want to look at the problem together. They want to find a solution together. And a lot of times they just want to learn together as well.</p>\n\n\n\n<p>We see that there is a real, I don&#8217;t know, not, it&#8217;s not a safety and numbers question. I think it is a long-standing feeling that we can all kind of get further together and that we are better together. And so I like your thought there.</p>\n\n\n\n<p>You mentioned, though, translations, and I know that this came up at WordCamp Europe.</p>\n\n\n\n<p>We don&#8217;t actually have a lot of translated content on learn.wordpress.org. There&#8217;s some technical issues that exist there, but are there a few languages that we already are sort of seeing translated courses for? Translated lessons for?&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:09:47]</strong></p>\n\n\n\n<p>Yeah. So we have a couple in Hindi, I believe. And I know we&#8217;ve got some Greek translations that have been coming up, so I know, I think it was last year WordCamp India, during contributor day, we had quite a lot of people translating stuff then, and I suppose the online WordCamps that we&#8217;ve been able to rank. Cause I think our first like face to face is this year, so they didn&#8217;t do that much translation there, but we&#8217;ve seen an increase in people wanting to translate.&nbsp;</p>\n\n\n\n<p>And I think those are the ones that come to mind. And I know Japanese, I think that was just recently, in the last two weeks, somebody&#8217;s translated one or two of the tutorials have been translated.</p>\n\n\n\n<p>But we’re getting more and more requests coming through. And I know we kind of touched on this in our earlier discussion, but it&#8217;s like, how do you manage that? Cause you&#8217;re right, we don&#8217;t have a way to easily manage polyglots on Learn at the moment or WordPress in general. But I think seeing that, and I keep saying to people, I don&#8217;t wanna lose that engagement cause if you&#8217;ve got the people engaged, let them just do it.</p>\n\n\n\n<p>And I don&#8217;t normally say this, but let them do it, and we&#8217;ll figure out how to sort out the whole pile when it comes in later. Because you kind of don&#8217;t want to lose them because I feel like if we say, no, we&#8217;ll wait until that comes in, we&#8217;ll lose a lot of the engagement. And come that time, people will be like, oh no, I&#8217;m not that interested. Or it might be an even more effort to try and bring more people on board.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:11:18]</strong></p>\n\n\n\n<p>That&#8217;s always a struggle, like wanting to be able to get something good out without insisting that it be perfect. Like that whole perfect is the enemy of the good sort of concept.&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:11:30]</strong></p>\n\n\n\n<p>Yeah. Mm-hmm&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:11:30]</strong></p>\n\n\n\n<p>When we were talking about this way back in June, I was like, I obviously would love to get a perfect solution out immediately, but like, you&#8217;re right.</p>\n\n\n\n<p>In the meantime, do we just be if you don&#8217;t speak English, you cannot learn here?</p>\n\n\n\n<p>Like that&#8217;s not fair.</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:11:45]</strong></p>\n\n\n\n<p>No.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:11:46]&nbsp;</strong></p>\n\n\n\n<p>We want everyone to be able to learn here in their own languages, and yeah. That&#8217;s just a living, breathing issue with a global project, I think.&nbsp;</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:11:56]</strong></p>\n\n\n\n<p>Yeah.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:11:57]</strong></p>\n\n\n\n<p>Now that we left us on like a really juicy topic, just the lightest thing we could find. Is there anything else that you wanna be sure to share with the WordPress Briefing listeners before we head out?</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:12:10]</strong></p>\n\n\n\n<p>Come and join the training team. Like I said, you don&#8217;t have to be a trainer. You can come in, and help us take notes. You can come in and edit, and review. If you are a subject matter expert, we also have the <a href=\"https://make.wordpress.org/training/handbook/faculty-program/\">faculty program</a>, which was launched. Was it a month ago now?</p>\n\n\n\n<p>Sorry. Days, months, weeks merge for me these days. But yeah, so that&#8217;s like a dedicated volunteer team. And in there, we&#8217;ve got content creators, editors, subject matter experts, and just admin stuff. If you wanna help us with the admin stuff. If you&#8217;re a GitHub guru, get in touch cause we are trying to automate some of our processes, and we could use the help, but yeah, just come join us.</p>\n\n\n\n<p>Join one of our meetings, which run on Tuesdays at 7 AM UTC and 4:00 PM UTC.&nbsp;</p>\n\n\n\n<p>Yes, that&#8217;s right. I get my time right.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:13:03]&nbsp;</strong></p>\n\n\n\n<p>If it&#8217;s not right, we&#8217;ll put it. We&#8217;ll correct it in the show notes.&nbsp;</p>\n\n\n\n<p>Also, if you are not necessarily familiar with the WordPress project and how to get started with contributions, you can find the training team and a lot of information about them and all the other teams on make.wordpress.org.</p>\n\n\n\n<p>I will share that in the show notes as well. make.wordpress.org/training is where you can find Hauwa&#8217;s team. Hauwa, thank you again for joining me today.</p>\n\n\n\n<p><strong>[Hauwa Abashiya 00:13:30]</strong></p>\n\n\n\n<p>No, thank you for having me. It&#8217;s just a wonderful treat. I get to listen to you, and now I get to be on it.&nbsp;</p>\n\n\n\n<p>So, yeah, it&#8217;s good.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:13:37]</strong></p>\n\n\n\n<p>I hope that some of you feel inspired to stop by and see what the team is up to learn something new about WordPress or contribute a little something yourself. And with that, I&#8217;ll bring us home with the small list of big things. First thing, there was a freshly pressed minor release last week. You probably didn&#8217;t notice it.</p>\n\n\n\n<p>It probably went quite smoothly in the background and never interrupted you at all. However, if you want to read what was in it, you can head to wordpress.org/news now, or click on the link in the show notes.&nbsp;</p>\n\n\n\n<p>Second thing, is that coming up at the end of this week, September 9th, 2022, WordCamp US is back and ready to help broaden your WordPress knowledge. If you will be there, I hope it is a wonderful time, but if you won&#8217;t be there in person, I&#8217;ll include a link to register for the live stream, or you can watch all of those sessions afterward on wp.tv or the WordPress YouTube channel.</p>\n\n\n\n<p>Third thing on our list of small list of big things is that WordPress Translation Day is coming up. That&#8217;s normally at the end of September, it coincides with a global day of appreciation for translators just generally across the world. And so that is coming, it&#8217;s normally around the 28th or so.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:14:55]</strong></p>\n\n\n\n<p>So put that in your calendars. As soon as I have any information, as soon as I have a link to share with you all, I will have that for you as well.&nbsp;</p>\n\n\n\n<p>And the final thing on my list today is that if you are hoping to speak at WordCamp Asia, 2023, you have 10 more days, September 15th, 2022**, to apply for that.</p>\n\n\n\n<p>We need topics of all sorts, from security hardening and backend development to entrepreneurial best practices, WordPress out of the box all the way back around to the importance of securing open source freedom. Even when people don&#8217;t know they need them. If you&#8217;ve got something you&#8217;re a bit passionate about, something that you are a passionate expert about especially, we want to see your application. And that, my friends, is your small list of big things.</p>\n\n\n\n<p>Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy. And I&#8217;ll see you again in a couple of weeks.</p>\n\n\n\n<p><br />** <em><strong>Special note: the deadline to apply as a speaker to WordCamp Asia was extended to September 30th, 2022, after the recording of this episode.</strong></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2022 12:01:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Gutenberg Times: Gutenberg Changelog #72 Gutenberg 13.9, 14.01, WordPress 6.02, Themes and Design Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=22015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-72-gutenberg-14-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49122:\"<p>Birgit Pauli-Haack and Nick Diego discuss highlights from Gutenberg 13.9, 14.01, WordPress 6.02, Themes and Design Tools.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2>Nick Diego</h2>\n\n\n\n<p>developer advocate at WP Engine, plugin developer and themes builder. He is also a core contributor. Running Triage sessions in the core editor channel and is on the WordPress 6.1 release squad</p>\n\n\n\n<ul>\n<li>Follow him on Twitter: <a href=\"https://twitter.com/nickmdiego\">@nickmdiego</a></li>\n\n\n\n<li>WordPress Profile: <a href=\"https://profiles.wordpress.org/ndiego/\">@ndiego</a></li>\n</ul>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/designing-style-variations-for-twenty-twenty-three-the-good-the-bad-and-everything-else/\">Designing Style Variations for Twenty Twenty-Three: The Good, the Bad, and Everything Else</a> by Justin Tadlock</p>\n\n\n\n<h2>WordCamp US</h2>\n\n\n\n<ul>\n<li><a href=\"https://us.wordcamp.org/2022/schedule/\">WordCamp US Schedule</a></li>\n\n\n\n<li><a href=\"https://us.wordcamp.org/2019/make-room-practice-the-pac-man-concept/\">Make Room: Practice the Pac Man Concept</a></li>\n</ul>\n\n\n\n<h2>@WordPress/Create-Block package</h2>\n\n\n\n<p>Ryan Welcher <a href=\"https://www.youtube.com/watch?v=TDMkbVOdQu0\">new release of the @wordpress/create-block package</a></p>\n\n\n\n<p>Documentation </p>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-create-block/\">@wordpress/create-block package</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-create-block/packages-create-block-external-template/\">@wordpress/create-block External Template</a></li>\n</ul>\n\n\n\n<h2>Themes</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2022/08/25/hallway-hangout-discussion-on-block-themes-25-aug/\">Hallway Hangout: Discussion on Block Themes (25 Aug)</a></p>\n\n\n\n<p>WordPress 6.0.2</p>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/08/wordpress-6-0-2-security-and-maintenance-release/\">Release announcement</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/08/23/wordpress-6-0-2-rc1-is-now-available/\">Changelog</a></li>\n\n\n\n<li>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56112\">#56112</a><strong> – Allow remote pattern registration in theme.json when core patterns are disabled</strong></li>\n</ul>\n\n\n\n<p>Gutenberg 13.9</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/08/17/whats-new-in-gutenberg-13-9-17-august/\">What’s new in Gutenberg 13.9? (17 August)</a></li>\n\n\n\n<li><a href=\"https://wptavern.com/gutenberg-13-9-adds-new-shortcut-to-wrap-selected-text-in-quotes\">Gutenberg 13.9 Adds New Shortcut to Wrap Selected Text in Quotes</a></li>\n</ul>\n\n\n\n<p>Gutenberg 14.0</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/\">What’s new in Gutenberg 14.0? (31 August)</a></p>\n\n\n\n<p>Before the end</p>\n\n\n\n<p><a href=\"https://wpengine.com/builders/\">WP Engine: Builders Resource &#8211; Explore the basics of creating powerful WordPress websites.</a></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"is-layout-flow wp-block-group\"><div class=\"wp-block-group__inner-container\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-larger-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p> </p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello, and welcome to our 72nd episode of the Gutenberg Changelog. In today&#8217;s episode, we will talk about Gutenberg 13.9, Gutenberg 14.01, WordPress 6.02, and a lot of things about themes and design tools in the editor. And I am Birgit Pauli-Haack, curator at the Gutenberg Times and WordPress Developer Advocate. And today, I have a special guest on the show, it&#8217;s Nick Diego, Developer Advocate at WP Engine, Plugin Developer, and Themes Builder.</p>\n\n\n\n<p>And I just learned he is also from the hospitality industry. So, we have a whole new show. He&#8217;s also a Core Contributor on WordPress and running triage sessions every Tuesday in the core editor channel. And he&#8217;s also a teammate of mine on the 6.1 release squad. Good afternoon, Nick. Thank you so much for coming to the show today. How are you?</p>\n\n\n\n<p><em>Nick Diego</em>: I&#8217;m doing great. Thank you for having me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, sure. I should probably also mention that you were part of the group of experts on the developer hours meet up, where a group of contributors answer questions from the audience. We should schedule some more, what do you think?</p>\n\n\n\n<p><em>Nick Diego:</em> We should.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, in the meantime, until that happens, you held or will hold also build up basics events on the learn WordPress online meetup, thank you for those. Most events were recorded and are uploaded to WordPress TV. So, you get a lot of Nick Diego on WordPress TV.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah, exactly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So, what have you learned that&#8230; what are the most common concepts that are harder to understand for people?</p>\n\n\n\n<p><em>Nick Diego:</em> Well, first of all, those online workshops are so important for engaging directly with the community and WordPress builders. A lot of people aren&#8217;t keeping up with what&#8217;s happening in Gutenberg, they have businesses to run, websites to build, right?</p>\n\n\n\n<p>And WordPress is developing so quickly as we&#8217;ll see in today&#8217;s episode with all the things that have happened in the latest releases. And so, it&#8217;s a great time to connect with them and just to cover the basics. One of my main series is builder basics, where we talk about really the fundamentals, like how to work with row blocks and group blocks and that thing.</p>\n\n\n\n<p>And I think people really get a lot out of that. And so, I&#8217;m also really excited for the new 2023 theme because it&#8217;s going to incorporate a lot of the new functionality that we&#8217;re seeing in WordPress and provide users a place to look and see a working functional example of all the new stuff that&#8217;s coming in WordPress.</p>\n\n\n\n<p>So, a couple ways. There are online workshops and all the other developer relations stuff that we&#8217;re doing, hopefully, we can help get people up to speed more quickly than they would on their own.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So, if you don&#8217;t have them signed up for the meetup yet, where you get all the announcements of all the new workshops that are coming there. Sometimes, there are months with 2025 workshops. Well, month of August wasn&#8217;t so good because we were&#8230; many of the faculty were on vacation, but definitely sign up and join the group.</p>\n\n\n\n<p>Sometimes, there are 20. Sometimes, there are 60 in there, I have noticed. And most of them are recorded. So, even if you&#8217;ve missed them&#8230; but it&#8217;s hard to watch the recording when there is some life interaction with people in there. So, Nick, you mentioned the 2023 theme and the update here is that the theme is a base theme.</p>\n\n\n\n<p>And there was a call for the community to send in style variations, that&#8217;s style variations, or something like a skin of a theme that follows the theme, but you can change color, fonts, and other things, spacings, and all the good things. And the community submitted actually 33 style variations.</p>\n\n\n\n<p>And next week, the team will learn&#8230; the team will decide which ones are bundled with the default theme. And I look through them, I like quite a few. So, did you get a look at them?</p>\n\n\n\n<p><em>Nick Diego</em>: I did. I did. And some of my fellow colleagues submitted a couple. It&#8217;s a really exciting project, reach out into the community and get designs from other community members, it really makes you feel like this is a community project and WordPress is open-source and we have a big community. I really like the direction they took with this and the designs that have come out of it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, there are all voices in the community that you don&#8217;t need, every year new theme, just add new styling there or so not every WordPress is going to change a theme every year, so. But you&#8217;re right, it&#8217;s actually the reference theme for all the new features.</p>\n\n\n\n<p>And if the listeners want to learn more about style variations and how to create them and what it was working on one of them for the 2023 theme, Justin Tadlock, takes you along in his new post on his experience designing the style variations on the Gutenberg Times.</p>\n\n\n\n<p>And I love this sentiment, although there are 1,400 words in there, but I&#8217;m just picking those from Justin&#8217;s post. So, there was a&#8230; and I quote them. “So, there was a small part of me that remembered exactly why I fell in love with WordPress in the first place.</p>\n\n\n\n<p>I felt like that same 21-year old kid who had just learned to edit a theme style CSS file to make some minor color changes. This was the WordPress that I remembered from so long. The one where themes were not hundreds of files and thousands of lines of code.” So, back to the basics and back to just do change the styling.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. It&#8217;s such a great quote from Justin and I completely agree. I think that because with block themes and this movement that we&#8217;re on, it&#8217;s really making themes a lot more accessible, it&#8217;s brand new, so it&#8217;s something new that you need to learn.</p>\n\n\n\n<p>But it is creating simpler themes that can be visually unique with just a few lines of code. And I think that provides a lot of power to users, especially in the low code, no code movement, I think there&#8217;s a lot of exciting things happening there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it&#8217;s back to the thinkers that can just change some things and have immediate gratification that they see it right away. There is no build spot on. There is no PHP thing or, yeah. So, it&#8217;s good. Well, WordCamp US is coming up next week. I am so excited to go to San Diego on Wednesday night. I can hardly wait. How about you?</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah, I&#8217;ll be there Thursday, but yeah. No, this is actually my first WordCamp.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, really?</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. I was planning to go the 2022 one, but then the world fell apart. So, yeah, I&#8217;m very excited to be going.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Okay. Well, awesome. Yeah. So, I&#8217;m glad I&#8217;m going to see you there. So, I knew that you would be there, but I didn&#8217;t know that was your first WordCamp, so yeah. Go through that post on, I don&#8217;t know if it&#8217;s what WordCamp US or WordCamp Europe what to do when it&#8217;s your first time.</p>\n\n\n\n<p><em>Nick Diego</em>: I saw that, yeah. I saw that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s so spot on. Yeah. So, don&#8217;t worry dear listeners, if you didn&#8217;t get a ticket, there will be live streams of the talks and workshops, and they will all be recorded and available on records to be sometime later this year. So, there are quite a few block editor-related talks on the schedule.</p>\n\n\n\n<p>So, Alex Ball will talk about customizing core blocks for clients. Very interesting topic. I have lots of discussions about that topic. Evan Mullins has a talk titled FSE for the win, it&#8217;s a lightning talk. And Daisy Olsen&#8217;s workshop on Saturday morning is about creating your first block theme.</p>\n\n\n\n<p>Rich Tabor, always a great presenter, will talk about the new era of WordPress themes is here, block themes. And I saw you on the roster of a lightning talk. What will it be about?</p>\n\n\n\n<p><em>Nick Diego</em>: Well, the title of my talk is a little, I guess, attention grabbing it&#8217;s build a custom block in 15 minutes. So, the goal of this presentation is to demystify the complexities of block development in WordPress. It&#8217;s something I&#8217;ve heard a lot. Oh, building block is really challenging. It requires new skills, whether it&#8217;s JavaScript or React.</p>\n\n\n\n<p>And the idea behind this is to show that you can actually build something quite functional in a short amount of time. And hopefully, inspire the&#8230; either that you&#8217;re watching it through the live stream or you&#8217;re attending, inspire people to build their own.</p>\n\n\n\n<p>Because I&#8217;d be the first person to say that building blocks can be challenging depending on the complexity of your project, but it&#8217;s never been easier to get started with block development. We&#8217;ll actually talk about it later today. But there have been so many tools built by the WordPress community that makes getting started with block development easier.</p>\n\n\n\n<p>And you combine that with some of the internal block supports, some block controls that are available directly from WordPress. And you can really get started pretty quickly in less than 15 minutes as I will demonstrate. So, very excited to be giving the presentation.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That&#8217;s awesome. I&#8217;m probably going to sneak in there. I&#8217;m going to be in the accessibility testing workshop, but I will sneak out and come see your talk. I hope that everyone&#8217;s punctual there.</p>\n\n\n\n<p><em>Nick Diego</em>: Hopefully, I can do it.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: We know afterwards.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah, exactly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. But what are the other talks that you are interested in?</p>\n\n\n\n<p><em>Nick Diego</em>: So, I&#8217;m really interested in&#8230; well, I’m very excited to see Rich&#8217;s talk. And as you mentioned, Rich is a great presenter. But I&#8217;m excited to learn more about things I don&#8217;t know much about. So, there&#8217;s getting started with WP-CLI, CLI. And then, there&#8217;s another one by WordPress Through the Terminal by Milana Cap.</p>\n\n\n\n<p>And I don&#8217;t know much about them. And I think it&#8217;d be a great opportunity to learn more. It’s one of the areas of WordPress that I should be better at, so I&#8217;m excited to learn from those folks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, yeah. Both are great presenters. So, if you&#8217;re in San Diego, the listeners, and we cross path, please don&#8217;t be shy. Introduce yourself. And I want to meet you. And even if I&#8217;m in a conversation with others at WordCamps, we try to follow the PacMan rule, I don&#8217;t know. Do you know about that, Nick?</p>\n\n\n\n<p><em>Nick Diego</em>: I learned of it, but I did not know prior to seeing the description here.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So, when we stand in a group of people and you always do, you have two people, then another one came said, &#8220;Hey, glad to see you.&#8221; And then, you talk about things, you chat together. We don&#8217;t make close circles. We always leave one opening so other people can walk in and join us.</p>\n\n\n\n<p>So, it&#8217;s an explicit permission to join a new group of people. And that&#8217;s how you meet people. That&#8217;s how the community works. So, definitely welcome to do this, and I will always make sure there is a spot for you.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah, that&#8217;s really great.</p>\n\n\n\n<h3><strong>Community Contributions</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So, we are on the section of community contributions. And Ryan Welcher did a Twitch stream this week about the new features of the create-block package. And I have actually the YouTube link for you and the show notes because he just finished uploading it to YouTube. Twitch only saves the video for 14 days and that&#8217;s&#8230; so, Ryan always downloads them and uploads them to YouTube, he edits them sometimes.</p>\n\n\n\n<p>And he was exploring the new release of the WordPress create-block package. And he thinks it&#8217;s a game changer. I think so, too. So, he goes over the new features, the flags for the, speaking of CLI, the flags of the terminal program for no plugin and variant flags that have been added to the tool.</p>\n\n\n\n<p>These flags increase the usability because they allow the users to add a new block to an existing plugin and or theme, and also provide the ability for a template to provide different variants for a block, like either a dynamic block or a static version, for instance. So, it&#8217;s going to be a really cool if you, yeah, do you want to say something about that?</p>\n\n\n\n<p><em>Nick Diego</em>: Well, a little bit of sneak peek. So, the create-block package is absolutely fantastic. I will actually be using the create-block package during my presentation, that&#8217;s what makes it possible to build a block in 15 minutes. So, there&#8217;s really no way to get started with block development. And Ryan&#8217;s did a fantastic job both working on the package itself, and then also educating folks.</p>\n\n\n\n<p>He actually runs an online workshop through the meetup, through the training team as well talking about building custom block. So, can&#8217;t say enough good things about Ryan and the work he&#8217;s done there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. Yeah. No, I feel the same way. If you are more the reading type learner, Ryan also updated documentation pages for the create-block package. And we have the link in the show note, and there&#8217;s also an added section to it for how to create templates for the tool, your custom templates.</p>\n\n\n\n<p>So, you can use them for agency specific scaffolding and standardize some of the work there as well. Okay, got that done. Speaking of themes and I have the feeling there will be more talk about themes or, yeah. Anne McCarthy gathered about 15 theme developers from the community from the FSE program, FSE, Full Site Editing Outreach Program.</p>\n\n\n\n<p>And they discussed various aspects of theme development with Full Site Editing and starts also Figma and design systems was a topic, and how they can work together with the theme JSON. Figma also has a theme, a JSON file operation, then custom block development, or how to organize pattern libraries in her post and concludes.</p>\n\n\n\n<p>And I quote, &#8220;While there is both excitement and interest in what block themes unlock.&#8221; It&#8217;s also clear that there is a buildup of pain points to address whether through clearer resources or changes to good look itself. Now, besides that conclusion is, if you are a theme developer hearing from people who already worked with block themes.</p>\n\n\n\n<p>And some of them are no strangers to our listeners, it&#8217;s Ellen Bauer, Carolina Nymark, Rich Tabor, Ana Zagora, Herb Miller. It&#8217;ll jump your discovery or speed up your knowledge. So, I really urge you to just listen into people talking about the things.</p>\n\n\n\n<h3><strong>WordPress 6.0.2</strong></h3>\n\n\n\n<p>Okay. So, now, let&#8217;s move on to the releases. First up is the WordPress 6.0 release. It&#8217;s a security maintenance release with a few bug fixers for the block editor. And it was released, I forgot, it was, I think, August 30th.</p>\n\n\n\n<p><em>Nick Diego</em>: Something like that, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. But there was one thing in there that you worked mainly on it, that&#8217;s allow remote pattern registration in theme JSON when code patterns are disabled. So, what was that about?</p>\n\n\n\n<p><em>Nick Diego</em>: Well, I&#8217;ll give you props for originally flagging this issue.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Thank you.</p>\n\n\n\n<p><em>Nick Diego</em>: And it&#8217;s where a lot of times, theme developers want to disable the core patterns that come with WordPress. You&#8217;re building your theme and you want to provide your own patterns, which makes perfect sense. And there&#8217;s an easy flag to do that.</p>\n\n\n\n<p>But unfortunately, when you would do that, you would basically turn off your ability to pull down patterns from the pattern directory. So, it stymied the growth of the pattern directory, because theme developers couldn&#8217;t both use their own patterns, shut down the core patterns and then pull down from the pattern directory.</p>\n\n\n\n<p>And so, this little, fairly simple change allows that to happen. So, now, you could include your pattern with your own theme, and you could also pick and choose from the pattern directory and include those with your theme. Little simple change but I think an important one for people to actually use the pattern directory.</p>\n\n\n\n<p>Because now, if you wanted to, you could put all your patterns on the pattern directory and then just create a custom theme and then pull them down from the pattern directory into your theme. So, it really opens the doors to a lot of different ways you might want to work with patterns and themes, which I think is exciting. So, glad to see this push through.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, I&#8217;m really glad that made it. But when I thought about, not when I thought about it, I got it from other theme developers who said, okay. So, I was thinking how could we curate the block directory without having a lot of additional changes in Gutenberg?</p>\n\n\n\n<p>And I think that change was really good. And now, you can curate, even if you are not a theme developer, but you are working for an agency and your developers have a theme for you and you want to add some of the patterns from the directory you want because of fun or whatever.</p>\n\n\n\n<p>You can just add the theme, edit the theme, JSON file and add disabled core patterns, but also edit the same JSON file to pull up. I don&#8217;t know, four or five patterns that you like or from your favorite designer. So, it&#8217;s really cool. But of course having 200 or whatever, how many patterns are in there now? I think it&#8217;s 18?</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. And I think that&#8217;s one of the things that turns people off in the pattern directory is you open up the&#8230; you&#8217;re just getting everything. And this way, it allows you to really pick and choose what you want to include, which I think is what most people are looking for.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So, that is already available. If you have updated your WordPress instance to 6.0.2, and there were others, the link in show notes will have the changelog from the make blog, so you can look what are the fixes, where in there, it was a security and maintenance release fix release. So, there are no new features. And this is actually not a new feature it&#8217;s just a-</p>\n\n\n\n<p><em>Nick Diego</em>: A bug. I considered it a bug, yeah.</p>\n\n\n\n<h3><strong>Gutenberg 13.9 and 14.0</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. All right. So, the last time we had a changelog recording, it was for Gutenberg 13.8. Now, today, we discussed 13.9 and 14. And there were a few enhancements in 13.9. For instance, the media and text blog got a new help for the image settings control.</p>\n\n\n\n<p>So, it&#8217;s a little bit clearer what it actually does. The post author block now renders HTML in the editor for the author description that is&#8230; there is this user profile section in the WP admin. And when you write the description for a user that&#8217;s pulled in into a theme, you can actually add HTML to it.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah, it&#8217;s really helpful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: &#8230; I didn&#8217;t read it yet. So, that&#8217;s definitely an enhancement or going back to original feature set. The post feature image now has a link target and attributes. Not quite sure. I&#8217;m fail to see the, oh, you can&#8230; link target is you can open up a new window.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah, exactly, a new tab. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right. And I also like that query title in the search template or the search result template. Now, you get some variations there. That is really cool. And then, is the transforms. Transforms is such a powerful tool. But I don&#8217;t think a whole lot of people, developers or plug-in developers or theme viewers are actually using it.</p>\n\n\n\n<p>Now, you can unwrap the group. It&#8217;s actually only a change in or an add-on to the transform menu that you actually can do this&#8230; the box that are assembled into a group can now be separated again. It&#8217;s the same as the more options menu, but it&#8217;s much faster to get there.</p>\n\n\n\n<p>And transforms, it&#8217;s actually a huge topic. And later this year, we&#8217;re probably going to talk a lot more about it because there&#8217;s some work in progress. Do you want to take the layout style?</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. So, we are breezing by many, many enhancements because we would be here all day if we were talking about each one. But under global styles, you can now add a disabled layout style, theme support flag to opt out of all layout styles, which it just provides developers with more flexibility about how they want styles to be applied. And then, the next one which I&#8217;m really excited about, and I think it&#8217;s so minor. And I&#8217;m excited because this is my ticket.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I saw that.</p>\n\n\n\n<p><em>Nick Diego</em>: But it enabled opacity on global styles for color pickers. So, if you&#8217;re in the normal block editor, when you add a color you can actually change the opacity on that color. They&#8217;re nobody&#8217;s no fault of anybody just got left off in global styles, so that got added. So, adding consistency. So, now, you can basically change opacity on colors throughout the all of WordPress, which is fantastic.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Good job. Thank you, Nick.</p>\n\n\n\n<p><em>Nick Diego</em>: Well, I think that Ellen Bauer pinged me about that and I&#8217;m like, I can fix that one. That one&#8217;s easy. I can do that. And then, for elements, update the load order of CSS in the site editor. We have a lot going on in the editor with different style sheets and different way things are loaded.</p>\n\n\n\n<p>And with time, we&#8217;re starting to see these&#8230; figuring out the optimal way to load styles and making sure that nothing&#8230; things don&#8217;t interact negatively with one another. So, a nice enhancement there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. It&#8217;s also about the hierarchy, now who comes first. Yeah.</p>\n\n\n\n<p><em>Nick Diego</em>: Exactly. It can get very tricky because we have, what we have the theme, we have core, we have user styles that they edit in global styles. So, there&#8217;s a lot going on in the site editor for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And then, we have edited stuff from the theme and it&#8217;s really&#8230; I&#8217;m glad that someone is actually organizing that. So, it&#8217;s not too complicated anymore. The site editor also got up some changes or some enhancements. Well, so, the author nicename template creation is now available for now.</p>\n\n\n\n<p>I think that concludes with the fallback template for content, all template possibilities that you could create with a site editor, author nicename, it&#8217;s not the username, it&#8217;s a different field in the profile, but you can now do it with that instead of the author name, so.</p>\n\n\n\n<p>And now, that all the templates are there, we also finally got the view side link in the editor. And I think a lot of millions of people probably are so glad that is actually now available. You don&#8217;t have…</p>\n\n\n\n<p><em>Nick Diego</em>: I would hear it so much. I would hear it so much. Where&#8217;s the view site button? And now we have it, which is amazing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, we have it. And I think it needs to be more intelligent. So, because when I edit the single page or single post or template, I want to click view site and then see it, but it goes to the homepage. But it&#8217;s one step at a time and I&#8217;m glad I don&#8217;t have to open browsers and do all that, which reminds me so much of previous of WordPress scenarios.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. No, it&#8217;s definitely a huge improvement, but more work to be done, for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Like Everything in WordPress, you have a first version and then you see what do the people want? What do we do? Let&#8217;s try it first and see what we need. So, I think that&#8230; is that all for 13.9 that we want to point out?</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. I mean, there&#8217;s a lot of bug fixes, just a lot of improvements. But I think the meat of new features comes in 14.0.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I think there was a lot as of the 13.9 was really a cleanup things and that continued. There were also in the background, some changes continued from lodash and from the testing that were continued from, and I think the last three or four plugin releases actually. And I&#8217;m right? Yeah.</p>\n\n\n\n<p>We are at the end of 13.9. In comes Gutenberg 14. And it was just released this week on August 31st. And it came with an enhancement. I would like to change that a little bit up. Let&#8217;s start with the design tools first, because that&#8217;s what everybody&#8217;s waiting for.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. This is I&#8217;m so excited about. So, to focus on the example of a paragraph block, one of the things that was missing from the paragraph block was the ability to change the font family and the typography controls. We had all the other stuff but not font family.</p>\n\n\n\n<p>Similarly, you couldn&#8217;t change margin and padding. Now, there&#8217;s good reasons why those, that functionality wasn&#8217;t in Gutenberg yet. There were still some things that needed to be fixed and whether it&#8217;s visualization for margin and padding or interactions with web bonds to do those font family.</p>\n\n\n\n<p>But we finally cut the green light on all this stuff. And there&#8217;s a huge project underway to provide consistency across as many blocks as possible. So, in 14.0, you&#8217;ll now see, for example, font family across not all we&#8217;re not quite done yet, but most blocks. So, it&#8217;s because there&#8217;s that muscle memory.</p>\n\n\n\n<p>When you learn how to change font family on one block, and then you go to the next one, you expect that to be there, right? And so, this huge process of standardizing design tools across blocks to me is super exciting. I hear from it all the time from users, why can&#8217;t I do this here? But I can&#8217;t do it here.</p>\n\n\n\n<p>And huge effort was made in 14.0. And it&#8217;s continuing. And we&#8217;ll be continuing to 14.1. We got tons of typography support, tons of spacing, padding and margin support. And we also got a lot of color supports as well that were missing. So, there&#8217;s a lot there and I encourage you to check out 14.0, because there may have been something you were desperately wanting and it most likely will be in 14.0, if not, 14.1.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And well, think about how many blocks are there. They&#8217;ll need to be updated. So, that&#8217;s a huge effort for contributors. I&#8217;m not sure, I haven&#8217;t looked at the copays yet, but some blocks do it differently than other blocks in the background. So, it&#8217;s always a&#8230; you can&#8217;t just copy paste like you would do it in a Google doc. You definitely have to think about things.</p>\n\n\n\n<p><em>Nick Diego</em>: There&#8217;s no magic switch you can just turn on then, so.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Now, you with theme JSON when every block has it. But up until now, that wasn&#8217;t possible yet. And now, that the controls are there, you also have them in the theme JSON file, so for your theme.</p>\n\n\n\n<p><em>Nick Diego</em>: And that&#8217;s a really good point, because I&#8217;m sure there are some people listening when I&#8217;m saying, look at all this new functionality, they might be like, I don&#8217;t want my users to have that. You can always turn this stuff off in theme JSON. So, before you&#8230; even if you wanted it, you couldn&#8217;t have it, now you can have it. But if you don&#8217;t want it can be turned off, so that&#8217;s an important component for those that want to turn off stuff.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it&#8217;s WordPress. If you have new features, we need the code to switch it off. It&#8217;s definitely MO4. It&#8217;s a standard for WordPress, right? All right. So, we mentioned it also before in 13.9, no, with Ryan Welcher&#8217;s Twitch stream, the create-block has a new variant flag as well as a no plugin flag that is in the enhancement section of the release.</p>\n\n\n\n<p>I also wanted to point out a few other things from the block library. One is a setting to hide the prefix for the archive title. I don&#8217;t know how many people come to me for the classic theme to remove the category string from the archive page or the archive title. And now, with block theme, it wasn&#8217;t possible. So, now, it is. It has come in and it was actually a blocker for people.</p>\n\n\n\n<p><em>Nick Diego</em>: It&#8217;s really funny. This is actually a really interesting issue because the archive title is just it&#8230; the block is just a wrapper around the PHP function that&#8217;s been in WordPress forever. And so, there are people who&#8217;ve been building WordPress forever like, oh, I know how to do that, there&#8217;s just the filter to do that.</p>\n\n\n\n<p>But then, you have the people that are coming at WordPress in a no code situation and they need the control for that in the block editor. So, it&#8217;s a really interesting like little microcosm of the two worlds coming together and it&#8217;s like you can change it in the filter with PHP, if you know how to do that. Or now, we have the ability to turn off the prefix, which I think is awesome.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And it enhances WordPress because you&#8230; a user, whenever, you would do this before. Now, they are. So, I&#8217;m really excited about that. Even if you know how to develop, yeah, just making a check mark in an interface is so much easier than, yeah. And open up your development environment, make that change, upload to the server and then, yeah, all…</p>\n\n\n\n<p><em>Nick Diego</em>: Google how to do it because you forgot.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And then, now, the post-date block on the query block or the post template. Now, you can also select that the date is the last modified date instead of the published date, which is actually also an enhancement that wasn&#8217;t before in WordPress. And so, you always have the latest date of the modification for the post, if all, or page in your Cloud.</p>\n\n\n\n<p>And now, we come to the next big feature, which is the list block has a version two, and it&#8217;s now out of experiments and available in the plugin out of the box. And give it for the next three weeks, a big testing because it will come to retro 6.1, we hope.</p>\n\n\n\n<p>It&#8217;s not yet clear, but because it&#8217;s coming rather late in there. But it&#8217;s out of experiments. The list items can now be easily better sorted with a much more improved user experience. Did you get a chance to use it yet?</p>\n\n\n\n<p><em>Nick Diego</em>: Oh, yeah. And one of the things that always frustrated me, the original list block, because I kept like, I&#8217;d want to change the order of my list items, and you could. And not that I should have expected that, but you&#8217;re so used to moving blocks around. I&#8217;m like, why can&#8217;t I move this list item? Well, now you can. And it works great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. Yeah. So, it&#8217;s the little things.</p>\n\n\n\n<p><em>Nick Diego</em>: It is, it is.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It adds up. And also, in 14.0, we have a few global style changes.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. I can talk about these. So, I&#8217;ve always been a big fan of block gap. And block gap is something that, not everything is making use of, but it&#8217;s the gap between blocks. And those that use it, it&#8217;s an incredibly powerful tool. And one of the things that&#8217;s neat now is the introduction of axial gap support.</p>\n\n\n\n<p>So, one of the things that you have is if you imagine columns or buttons that are in a row. Before when you set block gap, it was the gap between the blocks, what happens on mobile when those blocks are displayed vertically. And well, now, you can control both the horizontal gap as well as the vertical gap, which is really powerful.</p>\n\n\n\n<p>One of the things I hear a lot about or had heard a lot about was the lack of responsive controls within WordPress. And we&#8217;re starting to see how we&#8217;re not getting some interface where you define what you want on mobile and define what you want on tablet. But we&#8217;re getting these more holistic approaches to dealing with different devices and axial gap is one of them.</p>\n\n\n\n<p>So, really great to see. And then, another one, which is, I think honestly, a game changer when it comes to where we&#8217;re going in WordPress is what are called spacing presets. So, if you were changing margin or even block gap or padding, you&#8217;d get a little slider or you could type in a pixel number or you&#8230; it&#8217;s free form.</p>\n\n\n\n<p>For users, that&#8217;s hard. It&#8217;s also hard for anybody. Because if you want to have consistent padding or spacing throughout your site and you keep having to enter in a specific number or use a slider, you get, did I add five pixels over here? Did I add 10 over here? I get lost.</p>\n\n\n\n<p>So, spacing stuff simplifies that UI where you can define how many steps of padding or margin, how many steps of space so you could have small, medium, large, extra, large, whatever you want. And by enabling this, WordPress provides a set scale.</p>\n\n\n\n<p>But in theme at JSON, you can define your own scale. So, I&#8217;ve been playing around with the defining my own scale and it&#8217;s great, and not to go too deep into this, but I&#8217;m very happy. When you define your own scale, you can also define a scale that uses fluid spacing.</p>\n\n\n\n<p>So, not only can you define small, medium, large, you can make that spacing value using clamp fluid. So, you can have small on desktop as different from small on mobile. And all of a sudden, you have a very fluid website that&#8217;s adapting based on old devices and it&#8217;s quite amazing.</p>\n\n\n\n<p>And it&#8217;s going to take some retooling in how people build themes a little bit that really take advantage of this stuff, but it makes block themes super powerful. And we&#8217;re actually going to start seeing that in the 2023 theme. So, that&#8217;s why back to our original discussion why 2023 is such an important thing, important theme, is this going to provide a real world example of how to use some of this stuff, so.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And that combined with the fluid typography, it has been in the plugin for quite a bit now, but it&#8217;s coming to 6.1. Definitely, it&#8217;s really getting better together for the mobile responsiveness and all that. I had a conversation with plugin developers.</p>\n\n\n\n<p>And they had, I think, six view port changes that you can make to the block. And I was thinking, okay, who would actually want that? Who has the patience and the perseverance to change layout for six different view ports? And-</p>\n\n\n\n<p><em>Nick Diego</em>: For every block, too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: For every block, yeah. So, as you said, the scaling of this is a little bit different. So, on the last item for the global styles we&#8217;re going to talk about is the pseudo element supports for button elements. That is the hub and other pseudo elements for the buttons that you want to.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. Focus and active. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Focus and active, yeah. Thank you for helping me out. And we had this already for the link element. And now, we also have it for the button element, and it&#8217;s both in the interface as well as available for theme JSON.</p>\n\n\n\n<p><em>Nick Diego:</em> Yeah. Having these additional supports for elements is really great. And it allows you to pull a lot of that CSS that you had in your own style sheet and put it back into the theme JSON. Granted theme JSON, they&#8217;re getting quite big. But the beauty is you can edit it directly in the global style. So, it&#8217;s very powerful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Awesome. So, good things are coming to WordPress with the next version. I&#8217;m just going through that. And we have some more features, one more feature with&#8230; for the patterns, this new bundle of collections of header and footer block patterns in the plugin, because the directory is not working right with all the dynamic stuff. So, they bundled a few more collections there.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. It&#8217;s nice to see those updated. The ones that have been there have been in there for a while.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, yeah. I think the pattern when, the first introduced like the 5.5 or something like that. So, they&#8217;re coming&#8230; new things are coming in the pattern. There&#8217;s one feature that I really like, it&#8217;s the merging of blocks that you allow, that you can merge wrap blocks or into wrap blocks from both and list group and all that. It&#8217;s a nice quality of life change.</p>\n\n\n\n<p>And it needs a little bit, it takes more to explain that than show that. So, we probably need to do a demo on that and will be demoed on any of the talks that are on workers, learning on workers, not learning WordPress online, meetup groups. I&#8217;m sure some of them will demo that. And that, I think unless we overlooked something, we are at the end of it.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. Well, I mean, for the listeners, we breeze through a lot here. These two releases 5.9 and 14.0 super impactful, but they&#8217;re also give you a really good look about what&#8217;s coming in 6.1. We&#8217;ve had full site editing and block themes in WordPress for a while now.</p>\n\n\n\n<p>If you&#8217;ve been hesitant to jump in 6.1 is going to have a lot of things that you might have been looking for in order to get started and jump in. So, very excited for 6.1, and having all of this stuff included in core.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And the next version is 14.1. Of course, the next&#8230; and it will be released on September 14. That&#8217;s interesting because on September 13, it&#8217;s going to be the walkthrough. That&#8217;s a preliminary date. It hasn&#8217;t been officially announced, but it&#8217;s for you listeners here.</p>\n\n\n\n<p>You heard it here first. But it&#8217;s when the release leads from a core, technically leads from core and block editor go through what&#8217;s going to be released and demo some of the things. So, we have all the priorities, right? The last version that will make it into WordPress 6.1 of the good note plugin is probably&#8230; so the feature releases on September 20th, there will be a release candidate of WordPress 14.2.</p>\n\n\n\n<p>So, whatever gets into that release in that milestone will be wrapped up and pushed into WordPress 6.0. And I think the editor release leads will do some last. And of course, the triage will go through that and see what&#8217;s happening there.</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. And I have a lot to do with the next few months.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. All of us, because we are going through all the PRs and mark all for dev notes. So, there is a team. And Milana is doing the same for core, for the track tickets to find the dev notes that need to be published, and then we publish them. So, that&#8217;s going to be a really interesting thing.</p>\n\n\n\n<p>And I learn so much when I do that. It&#8217;s just mine. I don&#8217;t know where my brain do, it does that. But yeah, I just keep adding to it. So, we are almost at the end of the show. Is there anything, Nick, that you wanted to share with our listeners that you didn&#8217;t get to yet?</p>\n\n\n\n<p><em>Nick Diego</em>: Yeah. I mean, I&#8217;ll do a short plug here. So, our developer relations team at WP Engine, we do a lot of contributing to both the docs team and training and to core. But we also do, produce our own content, take supplement, some of the things that are already out in the world.</p>\n\n\n\n<p>And so, if you just go to wpengine.com/builders, it&#8217;s all just tutorials and articles on building with modern WordPress, very topical to what we&#8217;ve talked about today, talking about fluid typography. One of my favorite articles that I just released is about contextual patterns, which I don&#8217;t think that many people know about or use.</p>\n\n\n\n<p>But it&#8217;s a great way of functionality that&#8217;s in Gutenberg and in WordPress to take your theme to the next level. So, yeah, lots of great content. But of course, we&#8217;re always contributing to training docs as well, so.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I really like what you&#8217;re doing there. All of the articles are really well go deep, sometimes, deep developer wise, sometimes, content creator wise. So, it&#8217;s a great mixture for any target audience pretty much. That&#8217;s terrific. So, thank you for joining me today, sharing your knowledge and opinions with our listeners. And I&#8217;m looking forward to meeting you in-person.</p>\n\n\n\n<p><em>Nick Diego</em>: I know. Yeah. I can&#8217;t wait. Well, thank you very much for having me. I remember listening to this podcast a year ago, once I started working on WordPress full time. So, I think I&#8217;ve peaked now that I&#8217;m on the show now, so.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. You made it.</p>\n\n\n\n<p><em>Nick Diego</em>: That&#8217;s right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That&#8217;s what I thought. When Doc Pop invited me to the Pope Magazine. He said, &#8220;I made it.&#8221;</p>\n\n\n\n<p><em>Nick Diego</em>: That&#8217;s right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Dear listeners, our next show will be recorded on September 15th. So, there&#8217;s 13, walkthrough, 14 release, 15th Gutenberg changelog recording. It will be released shortly after. And we will have the brilliant Channing Ritter from the WordPress design team on the show. As always the show notes will be published on gutenburgtimes.com/podcast.</p>\n\n\n\n<p>This is episode 72. And if you have questions or suggestions or news, you want us to include send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>, that&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. Or, just shoot me a DM or PM on Slack or Twitter. It&#8217;s all opened for us, for you. Thank you again, Nick, for joining us. What&#8217;s your Twitter handle?</p>\n\n\n\n<p><em>Nick Diego</em>: Just Nick Diego, @nickdiego on Twitter. Wow, I should notice it, it&#8217;s actually @nickmdiego on Twitter. It was hard to get Nick Diego.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, you need to kick the Nick Diego out who has your handle.</p>\n\n\n\n<p><em>Nick Diego</em>: Exactly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Well this is it. Thanks all. And be well. And if I see you on WordCamp US, please, I&#8217;m looking forward to it. Take care.</p>\n\n\n\n<p><em>Nick Diego</em>: Thanks so much.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right, bye-bye.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2022 20:11:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"Gutenberg Times: Typography for all blocks, Refined Template editing, context patterns – Weekend Edition 227\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=21934\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"https://gutenbergtimes.com/typography-for-all-blocks-refined-template-editing-context-patterns-weekend-edition-227/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:29822:\"<p>Howdy, </p>\n\n\n\n<p>I am finally home in Sarasota, Florida with just enough time to do laundry, get over the jetlag and clear the backlog of messages after being away from the computer for three  weeks. Next week, I&#8217;ll be gone again to <a href=\"https://us.wordcamp.org/2022/schedule/\">San Diego and WordCamp US</a> (WCUS). I am so excited to see lots of friends and make new ones! If you can&#8217;t make it, there will be a <a href=\"https://us.wordcamp.org/2022/livestream/\">livestream of all sessions</a>, except the workshops.</p>\n\n\n\n<p>If you plan to attend WCUS, please let me know. I want to meet you and see you again! Don&#8217;t be shy.  Introduce yourself. Even if I am in conversation with someone else. At WordCamps, people practice the the Pac-Man rule &#8211; when standing in a group chatting, we leave a space so a new person can join the conversation. </p>\n\n\n\n\n\n<p>Now let&#8217;s catch up on two weeks of Gutenberg updates and posts. It&#8217;s again a long list, stoke full of creativity, features and discussion. </p>\n\n\n\n<p>Be well, </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n<div class=\"is-layout-flow wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-tools-plugins-and-themes-for-site-owners-and-nocode-site-builders-using-the-block-editor\">Tools, plugins and themes for site owners and nocode site builders </a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li><li><a href=\"https://gutenbergtimes.com/feed/#5-s\">Upcoming WordPress events</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#6-word-camps-around-the-world\">WordCamps around the World</a></li><li><a href=\"https://gutenbergtimes.com/feed/#1-l\">Learn WordPress Online Meetups</a></li></ul></li></ul></div>\n</div></div>\n\n\n\n\n<h2 id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>Anne McCarthy</strong> published another post in the <em>Core Editor improvement</em> serie about <a href=\"https://make.wordpress.org/core/2022/08/25/core-editor-improvement-refining-the-template-creation-experience/\"><strong>Refining the template creation experience</strong></a>. She wrote: <em>&#8220;Alongside&nbsp;<a href=\"https://make.wordpress.org/core/2022/07/21/core-editor-improvement-deeper-customization-with-more-template-options/\" target=\"_blank\" rel=\"noreferrer noopener\">more template options</a>&nbsp;comes some exciting refinements to the overall experience that should allow you to move faster with more accuracy to do what you want to do. In isolation, these enhancements might not catch your attention but, when viewed collectively, it’s clear that the template experience has been greatly improved.&nbsp;&#8221; </em></p>\n\n\n\n<p>McCarthy goes into great detail of the template editing workflow and the videos are quite ilustrative. Many of you, who have been experimenting with block themes, might get great joy out of the fact that there is now a <strong>View Site</strong> link available in the editor.  All will be available in WordPress 6.1, scheduled for release on November 1, 2022. If you don&#8217;t want to wait that long, install the latest version of the Gutenberg plugin. </p>\n\n\n\n<img />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Courtney Robertson</strong> posted the <a href=\"https://make.wordpress.org/updates/2022/09/01/whats-new-on-learnwp-august-2022/\">latest from the training team.</a> The post includes a list of new tutorials available about the block editor.  These short ,8 to 10 minutes long, free videos are ideal for on-demand direct learners.</p>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/creating-a-new-header-with-blocks/\">Creating a new header with blocks</a> </li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/customizing-your-post-content-layout/\">Customizing your post content layout</a> </li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/using-the-create-block-tool/\">Using the create-block tool</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/creating-a-landing-page-with-a-block-theme/\">Creating a landing page with a block theme</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/building-a-home-page-with-a-block-theme/\">Building a home page with a block theme</a></li>\n</ul>\n\n\n\n<p>Below you also find the upcoming events from the Learning WordPress Online Meetup group. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Wes Theron</strong> posted a <a href=\"https://make.wordpress.org/training/2022/09/01/summary-update-courses-currently-in-development-1-september-2022/\">Summary Update: Courses Currently in Development (1 September 2022)</a>. They are all course for the block editor: </p>\n\n\n\n<ul>\n<li>Block&nbsp;Development Course</li>\n\n\n\n<li>Two Block Theme Development Courses</li>\n\n\n\n<li>Create your First App with&nbsp;Gutenberg&nbsp;Data Course</li>\n</ul>\n\n\n\n<p>We will keep you posted on when those course will be opened up for enrollment. They all will be part of the Learn.WordPress site. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/one_maggie\"><strong>Maggie Cabrera</strong>,</a> member of the WordPress Themes team and first-time release lead, published<strong> <a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/\">What’s new in Gutenberg 14.0? (31 August)</a></strong>. The new release come with lots refinement updates, especially regarding consistence of the interface, for instance, 30 core block received UI support for typography settings. The highlights: </p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/#highlight-1\">Enhanced List block using inner blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/#add-axial-gap-control-to-styles\">Add axial gap control to Styles</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/#pseudo-elements-supports-on-button-elements\">Pseudo-elements supports on button elements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/#appearance-tools-available-for-opt-in-via-theme-supports\">Appearance tools available for opt-in via theme supports</a></li>\n</ul>\n\n\n\n<p>This week, we produced again a Gutenberg Changelog episode (#72) and my special guest was Nick Diego. We talked about Gutenberg 13.9 and 14.0 releases and WordPress 6.0.2 Security and Maintenance release. We also touched on WCUS and theme releated topics. </p>\n\n\n\n<img /><em>Nick Diego, WPEngine and Birgit Pauli-Haack making Gutenberg Changelog episode #72</em>\n\n\n\n<div class=\"is-layout-flow wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>🎙️ </strong> New episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-71-fluid-typography-block-api/\">Gutenberg Changelog #71 – Gutenberg 13.8, Fluid Typography, updates to the  Block API and more</a> &#8211; with co-hosts Grzegorz Ziolkowski and Birgit Pauli-Haack </p>\n</div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Officially, Friday was the last day to respond to the <strong><a href=\"https://make.wordpress.org/test/2022/08/13/fse-program-testing-call-16-back-to-basics/\">16th FSE call for Testing Back to the Basics</a></strong>, but <strong>Anne McCarthy</strong> wrote in the Slack channel &#8220;I was out hiking in the mountains for most of this week so will be catching up on the feedback that came in today and early next week as I begin the write up too. Thanks to everyone who has responded and for the patience! This also means that if you really want to sneak in a response over the weekend, you can&#8221;. </p>\n\n\n\n<p><strong>James Koster</strong>, design team, published on his private blog <a href=\"https://jameskoster.design/2022/08/24/revising-the-presentation-of-key-site-editor-features/\">Revising the presentation of key Site Editor&nbsp;features</a>. He wrote: &#8220;I’ve been ideating on how we might present site editor features with more appropriate weighting, so that the overall experience feels more like a design tool.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>If you want to know more about Style variations, how to create them and what it was like working on one for the Twenty-Twenty Three theme,&nbsp; <strong>Justin Tadlock</strong> takes you along for his <a href=\"https://gutenbergtimes.com/designing-style-variations-for-twenty-twenty-three-the-good-the-bad-and-everything-else/\"><strong>experience designing a style variation</strong></a>.</p>\n\n\n\n<p>I appreciated this sentiment from Tadlock&#8217;s post: “<em>There was a small part of me that remembered exactly why I fell in love with WordPress in the first place. I felt like that same 21-year-old kid who had just learned to edit a theme’s style.css file to make some minor color changes. This was the WordPress that I remembered from so long ago. The one where themes were not 100s of files and 1,000s of lines of code.</em>”&nbsp; </p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 id=\"2-tools-plugins-and-themes-for-site-owners-and-nocode-site-builders-using-the-block-editor\">Tools, plugins and themes for site owners and nocode site builders </h2>\n\n\n\n<p><strong>Jeff Chandler</strong> is now writing for the Torque magazine and discovered: <a href=\"https://torquemag.io/2022/08/the-quote-block-we-deserve-is-finally-here/\"><strong>The Quote Block We Deserve Is Finally Here</strong></a>. He wrote: &#8220;It’s wonderful. I can copy and paste multiple paragraphs of text into a quote. I can paste or create lists inside of a Quote. I can select multiple paragraphs that exist within the content and turn that into a Quote.&nbsp;&#8220;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/lesley_pizza\">Lesley Sim</a></strong>, co-founder of <strong>Newsletter Glue </strong>describes in here latest newsleter post <a href=\"https://newsletterglue.com/blog/newsletter/archive/big-changes-coming-to-newsletter-glue/\"><strong>Big Changes are Coming</strong></a> how style variations will arrive at the plugin&#8217;s template designer, as well as Global styles and automated newsletters. With the latter, there will be dragons in form of breaking changes coming your way in 4 to 6 weeks . So stay tuned! </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> published his <strong><a href=\"https://www.youtube.com/watch?v=bmZ0_-6kKeI\">Gutenberg Block News</a> </strong>video and quick five minute show with the latest in the space: He covers the plugin release 14.0 &#8211; AI Image plugin and FSE Studio by WPEngine, both still in private beta and alpha testing. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post, <strong>Fränk Klein</strong> asks <a href=\"https://humanmade.com/2022/08/24/can-we-please-stop-saying-gutenberg/\"><strong>Can we please stop saying ‘Gutenberg’?</strong></a> and bemoans the confusion  around various terms, he encounters in the WordPress universe. If you feel confused, too, let Klein explain what he thinks is the root cause, and what are more precise terms could be used when talking or writing about features of the block editor.  </p>\n\n\n\n<p>BTW: There hasn&#8217;t been any decision yet for on the <a href=\"https://make.wordpress.org/core/2022/07/27/giving-fse-a-more-user-friendly-name/\"><strong>renaming of Full-site-editing</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/vikasprogrammer\">Vikas Singhal</a> </strong>announced on <a href=\"https://twitter.com/vikasprogrammer/status/1564935567879864321\">Twitter</a>, the release of the <a href=\"https://wordpress.org/plugins/gutena-forms/\"><strong>Gutena Forms plugin</strong></a> in the repository. He continues: &#8220;We try to make it as native as the core blocks, which means: super flexible , easy to fonfigure,  light weight (&amp; no jQuery)  and available as a single block plugin&#8221;. </p>\n\n\n\n<p>Despite it being a single block plugin, it doesn&#8217;t come up in the Inserter search. You would need to install it via the Plugins page. </p>\n\n\n\n<p>The design options are fairly intuitive and you are presented with four prebuild forms to start out. You are also able to edit the submission message and error message below the form in the editor. Also, options for the form actions are to send a message (via email) or to enter a URL to externally handle the processing of the submitted form values.</p>\n\n\n\n<p>It&#8217;s certainly a great start. Some documentation wouldn&#8217;t hurt especially the difference between a Form Group and a Form Field block,  how to use the URL action option and an explanation of the design options. </p>\n\n\n\n<img />\n\n\n\n<p><a href=\"https://twitter.com/CometMarie\"><strong>Marie Comet</strong> </a>built a new plugin: <a href=\"https://github.com/MarieComet/convert-classic-to-gutenberg\"><strong>Convert classic to Gutenberg</strong></a> (GitHub). In the Readme she wrote: &#8220;This WordPress plugin provides an interface to convert posts built with the Classic (old) Editor to Gutenberg. Classic content is parsed and converted to blocks.&#8221; </p>\n\n\n\n<p><strong><a href=\"https://twitter.com/jeffr0\">Jeff Chandler</a></strong> has tested it and wants you to <a href=\"https://torquemag.io/2022/08/check-out-this-new-plugin-that-converts-posts-published-in-the-classic-editor-into-blocks/\"><strong>Check Out This New Plugin That Converts Posts Published in the Classic Editor Into Blocks</strong></a> (via Torque Magazine)</p>\n\n\n\n<h2 id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p><strong>Ryan Welcher</strong> published the recording of this week&#8217;s Twitch stream <a href=\"https://www.youtube.com/watch?v=TDMkbVOdQu0\"><strong>Overview of the new flags in the 4.0 release of create-block</strong></a> on YouTube. He goes over the new &#8211;<code>-no-plugin</code> and <code>--variant</code> flags that have been added to the <em>create-block</em> tool. These flags greatly increase the usability of the tool by allowing users to add a new blocks to an existing plugin ( or theme ) and by providing the ability for a template to provide  variants of a block, such as a dynamic and static version.</p>\n\n\n\n<p>If you are more the reading type learner, Welcher also updated the <a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-create-block/\">documentation pages for the create-block package</a>, and added a section on <a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-create-block/packages-create-block-external-template/\">how to create custom templates for the tool</a>, so you can use them for agency specific scaffolding.&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>A couple weeks ago, <strong><a href=\"https://twitter.com/tommcfarlin\">Tom McFarlin</a></strong>, long time independent WordPress back end developer started on a quest to write  &#8216;<a href=\"https://tommcfarlin.com/writing-tutorials-in-these-gutenberg-times/\">better&#8217; block development tutorials</a>. In his <a href=\"https://tommcfarlin.com/learning-to-build-block-editor-blocks-1/\"><strong>A Backend Engineer Learns to Build Block Editor Blocks, Part 1</strong></a>, he walk you through the pre-requisites and creating a block plugin from scratch, explains dependencies and the Block API using block.json file. He also suggests a certain folder structure for the plugin and you can now activate the plugin in your development site. It doesn&#8217;t do anything yet, but you have the skeleton working. Further in the tutorial you learn about the <code>edit()</code> and `save()` functions to display a string in the editor and on the front end of your site. In the reference section you&#8217;ll find short explanations of terms and links to the WordPress <a href=\"https://developer.wordpress.org/block-editor/\">block editor handbook</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In a <a href=\"https://make.wordpress.org/test/2022/08/25/hallway-hangout-discussion-on-block-themes-25-aug/\"><strong>Hangout Hallway</strong></a>, <strong>Anne McCarthy</strong> gathered about 15 theme developers to discussed various aspects of theme development with full-site editing, styles, Figma and Design Systems and how they can work together with theme.json &#8211; Custom block development, how to organize Pattern Libraries.&nbsp; In her post McCarthy concludes: “&nbsp;.. <em>while there is both excitement and interest in what block themes unlock, it’s also clear that there are a build up of pain points to address, whether through clearer resources or changes to Gutenberg itself</em>. “&nbsp;</p>\n\n\n\n<p>If you are a theme developer hearing from people, like Ellen Bauer, Carolina Nymark, Rich Tabor, Ana Segota, Herb Miller, who have been working and building block themes for quite some time already, it will jumpstart your discovery and speed up your knowledge aquisition. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest post, <a href=\"https://wpengine.com/builders/page-creation-patterns/\"><strong>What are Page Creation Patterns in WordPress?</strong></a>, Nick Diego explains the nature of context aware block patterns, used for a specific use case; for instance, when create a new Page your user can select full page patterns, or if they use a particular custome post type, you can offer different set of patterns. He writes &#8220;Combine this functionality with&nbsp;<a href=\"https://wpengine.com/builders/block-locking-api/\">block locking</a>, and you could present users with an extremely curated editing experience.&#8221; </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n\n<div class=\"ngl-articles pure ngl-articles-50_50 ngl-articles-frontend\">\n\n	\n	<div class=\"ngl-articles-wrap ngl-articles-webview\">\n	\n						\n			<div class=\"ngl-article-mobile\">\n				<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n					<tr>\n						<td valign=\"top\">\n							<div class=\"ngl-article-mob-wrap\">\n							<div class=\"ngl-article-featured\"><a href=\"https://gutenbergtimes.com/live-q-a-block-first-approach-at-pew-research-center/\" target=\"_self\" rel=\"\"><img src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2022/07/Screen-shot-Pew-Research-Center-july-0222-.png?w=652&ssl=1\" /></a></div><div class=\"ngl-article-title\"><a href=\"https://gutenbergtimes.com/live-q-a-block-first-approach-at-pew-research-center/\" target=\"_self\" rel=\"\"><span>Live Q &#038; A: Block-First Approach at Pew Research Center</span></a></div><div class=\"ngl-article-excerpt\">On July 22, 2022, Michael Piccorossi, Head of Digital Strategy and Seth Rubenstein, Lead Developer at Pew Research Center talked to co-hosts Anne McCarthy, WordPress Product Liason and Birgit Pauli-Haack,&hellip; <a href=\"https://gutenbergtimes.com/live-q-a-block-first-approach-at-pew-research-center/\" class=\"ngl-article-read-more\" target=\"_self\">Read more.</a></div>							</div>\n						</td>\n					</tr>\n				</table>\n			</div>\n			\n			\n			\n\n		\n						\n			<div class=\"ngl-article-mobile\">\n				<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n					<tr>\n						<td valign=\"top\">\n							<div class=\"ngl-article-mob-wrap\">\n							<div class=\"ngl-article-featured\"><a href=\"https://gutenbergtimes.com/conditionally-registering-patterns-in-themes-with-third-party-blocks/\" target=\"_self\" rel=\"\"><img src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2022/07/unsupported-block-in-pattern.jpg?w=652&ssl=1\" /></a></div><div class=\"ngl-article-title\"><a href=\"https://gutenbergtimes.com/conditionally-registering-patterns-in-themes-with-third-party-blocks/\" target=\"_self\" rel=\"\"><span>Conditionally Registering Patterns in Themes with Third-Party Blocks</span></a></div><div class=\"ngl-article-excerpt\">What happens when a theme registers a pattern with a third-party block? If the user has the block plugin installed, it appears as it should. WordPress also does a good&hellip; <a href=\"https://gutenbergtimes.com/conditionally-registering-patterns-in-themes-with-third-party-blocks/\" class=\"ngl-article-read-more\" target=\"_self\">Read more.</a></div>							</div>\n						</td>\n					</tr>\n				</table>\n			</div>\n			\n			\n			\n\n		\n						\n			<div class=\"ngl-article-mobile\">\n				<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n					<tr>\n						<td valign=\"top\">\n							<div class=\"ngl-article-mob-wrap\">\n							<div class=\"ngl-article-featured\"><a href=\"https://gutenbergtimes.com/layouts-and-wide-alignments-in-wordpress-then-now-and-upcoming-changes/\" target=\"_self\" rel=\"\"><img src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2022/08/rubiks-cube-code-bg.jpg?w=652&ssl=1\" /></a></div><div class=\"ngl-article-title\"><a href=\"https://gutenbergtimes.com/layouts-and-wide-alignments-in-wordpress-then-now-and-upcoming-changes/\" target=\"_self\" rel=\"\"><span>Layouts and Wide Alignments in WordPress: Then, Now, and Upcoming Changes</span></a></div><div class=\"ngl-article-excerpt\">For most of WordPress&#8217; history, the platform accepted a single layout width, defined by the active theme&#8217;s global $content_width variable. Theme authors were required to handle the CSS for it&hellip; <a href=\"https://gutenbergtimes.com/layouts-and-wide-alignments-in-wordpress-then-now-and-upcoming-changes/\" class=\"ngl-article-read-more\" target=\"_self\">Read more.</a></div>							</div>\n						</td>\n					</tr>\n				</table>\n			</div>\n			\n			\n			\n\n		\n						\n			<div class=\"ngl-article-mobile\">\n				<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n					<tr>\n						<td valign=\"top\">\n							<div class=\"ngl-article-mob-wrap\">\n							<div class=\"ngl-article-featured\"><a href=\"https://gutenbergtimes.com/designing-style-variations-for-twenty-twenty-three-the-good-the-bad-and-everything-else/\" target=\"_self\" rel=\"\"><img src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2022/08/rough-draft-site-editor.jpg?w=652&ssl=1\" /></a></div><div class=\"ngl-article-title\"><a href=\"https://gutenbergtimes.com/designing-style-variations-for-twenty-twenty-three-the-good-the-bad-and-everything-else/\" target=\"_self\" rel=\"\"><span>Designing Style Variations for Twenty Twenty-Three: The Good, the Bad, and Everything Else</span></a></div><div class=\"ngl-article-excerpt\">Since the release of Twenty Ten, the WordPress community has gotten a new default theme almost every year. This has allowed the platform to amass a well-designed and solid body&hellip; <a href=\"https://gutenbergtimes.com/designing-style-variations-for-twenty-twenty-three-the-good-the-bad-and-everything-else/\" class=\"ngl-article-read-more\" target=\"_self\">Read more.</a></div>							</div>\n						</td>\n					</tr>\n				</table>\n			</div>\n			\n			\n			\n\n		\n		\n		</div>\n\n</div>\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 id=\"5-s\">Upcoming WordPress events</h2>\n\n\n\n<p><strong>November 18, 2022</strong><br /><a href=\"https://www.wordfest.live/2022/november/\"><strong>WordFest Live 2022</strong></a></p>\n\n\n\n<p><strong>October 11-13, 2022</strong><br /><a href=\"https://woosesh.com/\"><strong>WooSesh 2022</strong></a></p>\n\n\n\n<h3 id=\"6-word-camps-around-the-world\">WordCamps around the World</h3>\n\n\n\n<p>September 3 + 4, 2022<br /><a href=\"https://kathmandu.wordcamp.org/2022/\"><strong>WordCamp Kathmandu</strong></a>, Nepal</p>\n\n\n\n<p>September 9 – 11, 2022<br /><strong><a href=\"https://us.wordcamp.org/2022/\">WordCamp US</a></strong>&nbsp;in San Diego</p>\n\n\n\n<p>September 15 + 16, 2022<br /><a href=\"https://netherlands.wordcamp.org/2022/\"><strong>WordCamp Netherlands</strong></a>&nbsp;at the&nbsp;<a href=\"https://www.burgerszoo.com/\">Royal Burger’s Zoo</a>&nbsp;in Arnhem</p>\n\n\n\n<p>September 24 + 25, 2022<br /><a href=\"https://pontevedra.wordcamp.org/2022\"><strong>WordCamp Pontevedra</strong></a></p>\n\n\n\n<p>February 17 – 19, 2023<br /><strong><a href=\"https://asia.wordcamp.org/2023/\">WordCamp Asia</a></strong>, Bangkok, Thailand<br /><a href=\"https://asia.wordcamp.org/2023/call-for-speakers/\">Call for speaker was just published</a>. Deadline: September 15th, 2022 (UTC +7)<br />Contributor Day is planned for February 17, 2023 (Day 1)</p>\n\n\n\n<h3 id=\"1-l\">Learn WordPress Online Meetups</h3>\n\n\n\n<p>September 6, 2022, 5 pm EDT / 21:00 UTC <br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/288046219/\"><strong>Customizing a footer with patterns</strong></a> with Wes Theron</p>\n\n\n\n<p>September 6, 2022 4 pm EDT / 20:00 UTC<br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/287786811/\"><strong>The Creative Side of Blocks, Vol. 2</strong></a>&nbsp;with Brian Gardner</p>\n\n\n\n<p>September 8, 2022, 10 am EDT / 14:00 UTC<br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/288235087/\"><strong>A Beginners Guide to Block Locking in Block Themes</strong></a> with Jonathan Bossenger</p>\n\n\n\n<p>September 14, 2022 1 AM EDT / 5 am UTC <br /><strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/288127107/\">Showcasing Content with Query Loops</a> </strong>with Wes Theron</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><em>If you are curious about the featured image, I spent about an hour on <strong>Midjourney&#8217;s <a href=\"https://midjourney.gitbook.io/docs/\">Discord server</a></strong><a href=\"https://midjourney.gitbook.io/docs/\"> interacting with their Imaging AI bot</a> to create illustrations. . It&#8217;s a fascinating journey. </em>It&#8217;s also addictive. </p>\n\n\n\n<p><em><strong>Don McKenzie</strong>, designer at Deephaven, shared is experience in <a href=\"https://deephaven.io/blog/2022/08/08/AI-generated-blog-thumbnails/\"><strong>I replaced all our blog thumbnails using DALL·E 2 for $45: here’s what I learned</strong></a></em>. </p>\n\n\n\n<p><em><strong>Aaron Edwards</strong>, CTO at WPMUDEV, <a href=\"https://twitter.com/UglyRobotDev/status/1565030948428828675\">posted on Twitter</a> a preview of a new plugin he has been working on to</em><strong><em> bring <a href=\"https://imagen.research.google/\">Google&#8217;s Imagen</a> generated into your WordPress</em> editor. </strong></p>\n\n\n\n\n<p>Featured Image: Young female in car repair shop created by <a href=\"https://www.midjourney.com/home/\">Midjourney AI</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 03 Sep 2022 20:39:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Gutenberg 13.9 Adds New Shortcut to Wrap Selected Text in Quotes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137551\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/gutenberg-13-9-adds-new-shortcut-to-wrap-selected-text-in-quotes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3825:\"<p>Wouldn&#8217;t it be convenient to select a sentence or paragraph and instantly wrap it with quotes by tapping on the quote key? This is a fun little feature that was tucked into the <a href=\"https://make.wordpress.org/core/2022/08/17/whats-new-in-gutenberg-13-9-17-august/\">Gutenberg 13.9</a> changelog last month with very little fanfare:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Rich text: Add character shortcuts for wrapping selection. (<a href=\"https://github.com/WordPress/gutenberg/pull/42469\">42469</a>)</p>\n</blockquote>\n\n\n\n<p>The new shortcut is a rich text feature contributed by Automattic-sponsored WordPress core committer Ella van Durpe. It works in a similar way that <a href=\"https://core.trac.wordpress.org/ticket/31571\">pasting a link over selection</a> will auto-link the text instead of replace it, a feature that landed seven years ago which she also worked on.</p>\n\n\n\n<p>The new quotes shortcut escaped my notice until I saw George Mamadashvili&#8217;s quick video demo on Twitter: </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">My new favorite Block Editor shortcut is the ability to wrap selected text in quotes. Select text and press `, \' or \". <br /><br />This nifty little feature shipped with Gutenberg 13.9. However, the editor always supported air quotes. <a href=\"https://t.co/VnPqv6E44U\">pic.twitter.com/VnPqv6E44U</a></p>&mdash; George Mamadashvili (@Mamaduka) <a href=\"https://twitter.com/Mamaduka/status/1565761697989726209?ref_src=twsrc%5Etfw\">September 2, 2022</a></blockquote>\n</div>\n\n\n\n<p>This is a clever feature that is commonly supported by IDE&#8217;s like IntelliJ and PyCharm. Although wrapping with quotes is likely the most common use case for this type of shortcut, it also supports wrapping the selection with a back tick (<code>`</code>), which will automatically wrap it in a code tag instead of replacing the selection with a back tick. van Durpe demonstrated this in the <a href=\"https://github.com/WordPress/gutenberg/pull/42469\">PR</a> with a gif:</p>\n\n\n\n<img />\n\n\n\n<p>If you frequently copy and paste text that is meant to be in quotes, or code that needs backticks, this new shortcut is a major timesaver and one of the most exciting features to land in <a href=\"https://make.wordpress.org/core/2022/08/17/whats-new-in-gutenberg-13-9-17-august/\">13.9</a>. van Durpe said it was generalized to work with any characters, such as pressing <code>(</code> to wrap the selection in parenthesis, instead of deleting the selection. However, this was scaled back a bit during the review before the PR was merged.</p>\n\n\n\n<p>&#8220;I&#8217;m a bit worried with expanding these to characters that are natural openers because I suspect it&#8217;s a typical action to select a word and type the first letter of what should replace it — parentheses and quotation marks, in particular, would have a much higher incidence of cases where the intention is indeed to replace the selected text with the mark, not to wrap it in them,&#8221; Gutenberg lead architect Matias Ventura said. </p>\n\n\n\n<p>Ventura concluded that it&#8217;s worth testing but suggested more characters be added incrementally to focus feature announcements on the ones they are more certain about &#8220;without the ones that could be problematic tainting the feature.&#8221; This is possibly the reason it wasn&#8217;t highlighted in the release post.</p>\n\n\n\n<p>The backtick and quote characters are the only two included in this iteration of the feature. It&#8217;s not easy for users to discover in the natural course of using the editor, so it might need a little promotion for people to start using it enough to know if it&#8217;s going to become one of those indispensable features or something that is inadvertently causing frustration.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 03 Sep 2022 03:29:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Jetpack Performance Team Takes Over WP Super Cache Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137516\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/jetpack-performance-team-takes-over-wp-super-cache-development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4657:\"<p><a href=\"https://wordpress.org/plugins/wp-super-cache/\">WP Super Cache</a>, one of the oldest and most widely used static caching plugins for WordPress, is changing hands. After 15 years, the plugin&#8217;s author, <a href=\"https://odd.blog/\">Donncha Ó Caoimh</a>, is handing over maintenance and development to Jetpack&#8217;s performance team.</p>\n\n\n\n<p>If you have been building WordPress sites since the early days, you are almost guaranteed to have used WP Super Cache on at least one project (or hundreds). It is based on an earlier plugin called WP Cache 2 that Ó Caoimh <a href=\"https://odd.blog/2007/11/05/wordpress-super-cache-01/\">forked in 2007</a> when its author had lost interest and was no longer developing it.</p>\n\n\n\n<p>Jetpack&#8217;s performance team manages the <a href=\"https://jetpack.com/boost/\">Jetpack Boost</a>&nbsp;plugin, used by more than 100,000 sites, and the&nbsp;<a href=\"https://jetpack.com/features/design/content-delivery-network/\">CDN</a>. In today&#8217;s <a href=\"https://jetpack.com/blog/wp-super-cache-joins-the-jetpack-family/\">announcement</a>, Jetpack assured current users that they will still be able to &#8220;enjoy its core features without a new plugin or a connection to Jetpack.&#8221;</p>\n\n\n\n<p>“We’re excited to start working on WP Super Cache,” Jetpack Performance Lead Mark George said. “Our goal is to create an experience where anyone can make their site extremely fast without being an expert. We want to help make sure that WP Super Cache remains a reliable and easy option for that.”</p>\n\n\n\n<p>This change in hands is not an acquisition. Ó Caoimh, who was the very first Automattic employee, confirmed the company did not buy the plugin from him. </p>\n\n\n\n<p>&#8220;I&#8217;ve worked in Automattic since the company was founded, so they&#8217;ve supported the development of the plugin all along,&#8221; he said. &#8220;Really, the plugin is moving sideways in the company, from one developer to a team.</p>\n\n\n\n<p>&#8220;I just don&#8217;t have time to work on it properly. I&#8217;m working on other projects, mainly <a href=\"https://crowdsignal.com/\">Crowdsignal</a> now, and it was hard to find time to work on it. Jetpack will be able to do a lot more with it than I ever could.&#8221; </p>\n\n\n\n<p>Ó Caoimh said the support burden for the plugin isn&#8217;t that bad, despite it being active on more than two million WordPress sites. </p>\n\n\n\n<p>&#8220;The plugin has a &#8216;debug log&#8217; that will log (almost) everything it does to a file, which makes it easier to figure out why a problem is happening a lot of the time,&#8221; Ó Caoimh said. &#8220;Unfortunately, due to time constraints, I wasn&#8217;t able to give the support forums the time it deserved either. Now, a team in Automattic will be helping answer questions and solve problems. It can only be a good thing for users of the plugin.&#8221;</p>\n\n\n\n<p>Ó Caoimh said handing over maintenance and development to the Jetpack team frees up time for his family and eliminates a source of stress, as he was worried that WP Super Cache wasn&#8217;t getting the attention it needed.</p>\n\n\n\n<p>&#8220;In the past I worked on this late into the night but I have a family, and they come first,&#8221; he said. </p>\n\n\n\n<p>The Jetpack team already has plans to modernize the plugin and will be investing more resources in support and new features. </p>\n\n\n\n<p>&#8220;While we research new features to help make WordPress sites cache faster, we will begin updating the WP Super Cache UI to bring it in line with modern standards, so it is easier to use,&#8221; Jetpack VP of Marketing Rob Pugh said. &#8220;In addition, we’ll be working behind the scenes to ensure it’s compatible with our other performance features like Jetpack Boost.&#8221;</p>\n\n\n\n<p>After 15 years, it&#8217;s impressive that WP Super Cache has maintained a 4.3 out of&nbsp;5&nbsp;stars rating on WordPress.org with 1,296&nbsp;reviews. With the Jetpack team&#8217;s resources, support in the forums is likely to improve, and users can expect to see more improvements as the plugin now has a team of people moving it forward.</p>\n\n\n\n<p>&#8220;I have no regrets handing over the plugin to Jetpack,&#8221; Ó Caoimh said. &#8220;It&#8217;s one thing to create and maintain a plugin that might be used by a handful of sites, but this plugin is used by two million sites. If I introduced a subtle error that impacted people using WordPress in a manner I hadn&#8217;t thought of that might cause problems for thousands of websites. The itch that I scratched by creating WP Super Cache has well and truly been scratched and has long healed.&#8221; </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Sep 2022 20:46:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Post Status: Post Status Excerpt (No. 67) — What Does Professionalism Mean in WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=114431\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://poststatus.com/what-does-professionalism-mean-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:56786:\"<div class=\"wp-container-21 wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Dan and Eric discuss their top picks for WordPress news stories of the week and the topic of professionalism. What is it — what does it mean for us in the WordPress community, and how does it relate to a healthy open source project and business ecosystem? </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">29</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<blockquote><p><em>We\'re not afraid to let our human side show</em>.</p><cite><strong>Erik Karkovack</strong></cite></blockquote>\n\n\n\n<p class=\"has-drop-cap\">In this episode of Post Status Draft, <strong>Eric Karkovack</strong> joins <strong>Dan Knauss</strong> to discuss their top picks for important topics and news stories in the WordPress world this week. </p>\n\n\n\n<p>Finally, Dan and Eric take up the topic of &#8220;professionalism.&#8221; What is it — what does it mean for us in the WordPress community, and how does it relate to a healthy open source project and business ecosystem?</p>\n\n\n\n<h2>Eric\'s Top News Picks</h2>\n\n\n\n<ol><li><strong>WP-Optimize</strong>&#8216;s <a href=\"https://wptavern.com/wp-optimize-denies-allegations-of-cheating-performance-tools\">&#8220;Cheating&#8221; Scandal</a> (WP Tavern)</li><li><strong>WebP</strong> in <strong>WordPress 6.1</strong> in <a href=\"https://poststatus.com/webp-by-default-is-on-hold/\">on hold again / &#8220;being reconsidered&#8221;</a> (Post Status)</li><li><strong>WordPres</strong>s.com&nbsp;<a href=\"https://poststatus.com/the-500-website/\">Now Offering $499 Websites</a> (Post Status)</li></ol>\n\n\n\n<h2>Dan\'s Top News Picks</h2>\n\n\n\n<ol><li><strong>Unethical &#8220;GPL clubs&#8221; and &#8220;piracy&#8221;</strong> — and what we can do about it. (An <a href=\"https://poststatus.slack.com/archives/CHNM7Q7T8/p1661633866043009\">emerging discussion</a> <a href=\"https://poststatus.slack.com/archives/C0413T6GD/p1662030800848389?thread_ts=1661635391.530579&cid=C0413T6GD\">in Post Status Slack</a> and <a href=\"https://twitter.com/michelleames/status/1565330137134108673\">on Twitter</a>.)</li><li><strong>Gravity Forms</strong> acquires <strong>Gravity Flow</strong> and <strong>Gravity Experts</strong>, a pair of product and service businesses in the Gravity Forms ecosystem developed by <strong>Steven Henty</strong>, Director of Product Development for <a href=\"http://www.rocketgenius.com\">Rocketgenius</a> – the creators of <a href=\"https://www.stevenhenty.com/gravityforms\">Gravity Forms</a>.</li><li><strong>Post Status\'s <a href=\"https://poststatus.com/member-spotlight-jonathan-bossenger/\">Member Spotlight</a> </strong>for this week is on <strong>Jonathan Bossenger</strong>. What he says (and personally represents) touches some ideas about professionalism in the WordPress ecosystem and here at Post Status.</li></ol>\n\n\n\n<div class=\"wp-container-24 wp-block-columns has-theme-palette-8-background-color has-background\" id=\"WP-Engine\">\n<div class=\"wp-container-22 wp-block-column\">\n<h3><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/a2-hosting\">A2 Hosting</a></h3>\n\n\n\n<p><strong>A2Hosting offers solutions for WordPress and WooCommerce that are both blazing fast and ultra-reliable.</strong> WordPress can be easily deployed on <em>ANY</em> web hosting plan from A2: Shared, VPS, or Dedicated. A2 also offers Managed WordPress and WooCommerce Hosting. Take a look at <a href=\"http://a2hosting.com\" target=\"_blank\" rel=\"noreferrer noopener\">a2hosting.com</a> today!</p>\n</div>\n\n\n\n<div class=\"wp-container-23 wp-block-column is-vertically-aligned-center\"><div class=\"wp-block-image\">\n<a href=\"https://poststatus.com/planet/feed/a2hosting.com\"><img width=\"304\" height=\"304\" src=\"https://cdn.poststatus.com/wp-content/uploads/2022/07/88b63da0-f90b-11e6-bc40-730c4553c727.png\" alt=\"A2 Hosting\" class=\"wp-image-101225\" title=\"WP Engine\" /></a></div></div>\n</div>\n\n\n\n<h3 id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the Show</h3>\n\n\n\n<ul><li><a href=\"https://poststatus.com/how-green-is-webp-really/\">How Green is WebP Really?</a> (Post Status)</li><li><a href=\"https://raidboxes.io/en/blog/wordpress/wordpress-internet-nachhaltig/\">Is There Such Thing as a Sustainable Internet? How Green is WordPress?</a> (raidboxes)</li><li><a href=\"https://almanac.httparchive.org/en/2021/\">Web Almanac</a> (HTTP Archive)</li><li><a href=\"https://en.wikipedia.org/wiki/Elinor_Ostrom\">Elinor Ostrom</a>, <a href=\"https://www.science.org/doi/abs/10.1126/science.1172133\">A General Framework for Analyzing Sustainability of Social-Ecological Systems</a> (<em>Science</em>, 2009) Ostrom identified &#8220;ten subsystem variables that affect the likelihood of successful self-organization of efforts to achieve a sustainable socio-ecological systems by the communities involved.&#8221; These variables seem incredibly relevant as things we can do in the WordPress ecosystem to engage in self-regulation and self-governance to deal with bad actors and quality issues. (<a href=\"https://blogs.lse.ac.uk/lsereviewofbooks/2012/06/17/elinor-ostroms-work-on-governing-the-commons-an-appreciation/\">Summary at The London School of Economics</a>)</li><li><a href=\"https://poststatus.com/nulled-themes-and-plugins/\">Nulled Themes and Plugins</a> (Post Status)</li><li><a href=\"https://locusmag.com/2017/09/cory-doctorow-demon-haunted-world/\">Demon-Haunted World</a> (Cory Doctorow) &#8220;Cheating is a given&#8230;&#8221;</li><li><a href=\"https://poststatus.com/we-dont-need-no-stinkin-standards/\">We don’t need no stinkin’ standards!</a> (Post Status) </li><li>Eric Karkovac, <a href=\"https://poststatus.com/writing-is-a-challenging-but-needed-profession-in-wordpress/\">Writing is a Challenging But Needed Profession in WordPress</a> (Post Status)</li><li><a href=\"https://www.linkedin.com/in/sarahschulman/?originalSubdomain=ca\">Sarah Schulman</a>, <a href=\"https://www.trampoline-effect.ca/\"><em>The Trampoline Effect: Redesigning Our Social Safety Net</em></a> (On Professionalism as a mask of invulnerability.)</li><li><a href=\"https://poststatus.com/member-spotlight-jonathan-bossenger/\">Jonathan Bossenger</a>, our Member Spotlight this week (Post Status)</li><li><a href=\"https://poststatus.com/building-and-sustaining-the-wordpress-community-through-mentorship/\">Building and sustaining community through mentorship</a> (Post Status)</li><li><a href=\"https://poststatus.com/what-does-five-for-the-future-mean-to-you-2/\">Mentorship as Contribution</a> (Post Status)</li></ul>\n\n\n\n<h3><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f44b.png\" alt=\"👋\" class=\"wp-smiley\" /> Credits</h3>\n\n\n\n<ul id=\"block-a3e9962f-97ca-4009-be8e-db47b5d1fddf\"><li><a href=\"https://twitter.com/karks88\">Eric Karkovack</a>, Freelance WordPress Web Developer (Twitter)</li><li><a href=\"https://twitter.com/dan_knauss\">Dan Knauss</a>, Editor for <a href=\"https://twitter.com/post_status\">Post Status</a> (Twitter)</li><li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a>, Web Producer intern for Post Status (Twitter)</li></ul>\n\n\n\n<p class=\"has-background\">Every week <strong><a href=\"https://poststatus.com/podcast/the-excerpt/\">Post Status Excerpt</a></strong> will bring you a conversation about important news and issues in the WordPress community and business ecosystem. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /><br /><br />You can listen to <a href=\"https://poststatus.com/podcast/the-excerpt/\">past episodes</a> of <strong>The Excerpt</strong>, <a href=\"https://poststatus.com/category/post-status-podcasts/\">browse all our podcasts</a>, and don’t forget to subscribe on <a href=\"https://open.spotify.com/show/1m3xwXbe0MG5BzFVPtB0A7\">Spotify</a>, Amazon Music, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://castro.fm/podcast/c53552c6-1ee0-4fc4-9de4-08ed6bf1ee4d\">Castro</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://player.fm/series/wordpress-post-status-podcasts\">Player.fm</a>, <a href=\"https://pca.st/05rR\">Pocket Casts</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or by <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h1 id=\"h-transcript\">Transcript</h1>\n\n\n\n<p><strong>Dan Knauss:</strong> Hey, Eric, how are you doing?</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> I\'m good. How are you?</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Not bad. Um, yeah, another, another week coming, coming down to, uh, to a close and assembling the, the stories that matter. We want to, um, get into our often jampacked newsletter and thinking about, um, weird camp coming up. And, um, I think everyone\'s getting geared up for that.</p>\n\n\n\n<p>Um, So what\'s, what\'s on the top of your mind this week, I wanted to kinda run through the top three, um, news stories of, um, the commentary issues, questions in the WordPress space that, uh, matter to you. And I\'ve gotta got a few, two.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> I think the biggest thing that came out to me is that, uh, the whole WebP support in, uh, WordPress six point ones kind of being reconsidered at the moment.</p>\n\n\n\n<p>Yeah. Thought that was, uh, a lot of community pushback on, uh, how they were going to implement it and kind of nice to see the, uh, leadership, uh, in, you know, the developers take a step back and kind of think things through again,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> right. Yeah, that\'s gone back and forth quite a bit. I, I got a little lost, um, keeping up and like, like you and your earlier writing about it.</p>\n\n\n\n<p>I, I think a lot of us feel, boy that would turning that on by default, um, is, is not something we like is there should be. An option or at least, uh, I don\'t know. I could see, I could see putting in a default for new installs or something like that, but for, to suddenly switch, um, potentially, um, everyone over from JPEGs or, or whatever, that\'s, isn\'t that the main sticking point.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Yeah, basically it would take, um, what was being proposed was that if you uploaded a, a JPEG or a PNG file or whatever, uh, WordPress would automatically convert it to a WebP and use. And so there\'s, you know, talk about, well, that takes up a lot of server resources. Um, WebP isn\'t supported in every browser.</p>\n\n\n\n<p>There\'s like specific versions of safari that are a few years old that don\'t, you know, uh, support it yet. And just all the files that it\'s gonna create, cuz you know, WordPress creates three or four versions of every image you upload. And if it\'s doing that again for WebP versions, You know, some folks on cheaper hosting accounts could run outta space.</p>\n\n\n\n<p>Right. And then there\'s the whole idea of, you know, WordPress is all about controlling your content and controlling your process. And to me, that\'s kind of a, the oddity of it. It\'s like, well, they\'re gonna force you to use this format that by the way Google created and you know, yeah. Not everybody wants to use it.</p>\n\n\n\n<p>I, I think, you know, having a check box makes a lot of sense, right?</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, there\'s, uh, I was looking at, um, working on, um, towards editing on the, uh, web Almanac, um, which a number of WordPress people contribute to each year for, um, CMS section of that. And, um, their data set where they compile, um, run a bunch of queries on a test population and, you know, see how many are using WordPress and Elementor stands out to, and, you know, WordPress is just.</p>\n\n\n\n<p>Weighing the numbers are, are way out there. And you start to think about, um, the dramatic impact it, it would have with, um, Switching a format to, you know, suddenly becoming very heavily used, like, um, like WebP, which, which I\'ve kind of been in favor of, uh, from a sustainability perspective, because end performance it\'s, it\'s generally faster and is gonna use less bandwidth and let\'s storage.</p>\n\n\n\n<p>But if you duplicate, you still have all those old JPEGs and you duplicate that. And yeah, you\'re really adding a lot in that, in that respect, it\'s not saving, uh, saving the planets and. Particularly well, um, but I haven\'t seen that side of the discussion come up, um, on it, but I, I, uh, I know there are people who care about, um, just how much we\'ve got in the cloud.</p>\n\n\n\n<p>That\'s just junk and it\'s taken cost in electrons, power every day. Um, so it, it will be interesting to see how that gets, that gets sorted out. Um, I\'m sure more efficient formats are where we\'re headed. um, so my, my, um, my number one pick is, is not really something that\'s been tackled yet. I\'m sure people are starting to write.</p>\n\n\n\n<p>I haven\'t, uh, I have to let things settle and think about a bit, but there\'s a, there\'s a big running discussion that started in two channels, two threads and, and, uh, post data is slack. Piracy G or unethical behavior with cloning, um, you know, G GPL clubs that get hold of a commercial license and crack, uh, WordPress plugins and, and so on, and then re resell this, uh, cheaply.</p>\n\n\n\n<p>Um, that\'s always been a thing. Uh, I think I remember that going on in ju. Um, there\'s we all know the reasons why that\'s a bad idea, hurts people\'s businesses. There\'s often malware that comes along as a payload with your free, cheap cracked software. Um, but this, at the same time, one of the big culprits here, um, was adding in some, adding in some new product that is sort of specialized at a niche.</p>\n\n\n\n<p>And it\'s not, you know, it\'s not, uh, Cheap plugins are some quite high end things targeted at hosts. Um, so it\'s a, it can be really devastating to some people\'s business model. If, if it were, um, if it was costing them, their target audience, some people feel actually, you shouldn\'t worry about this because the only people using it or kids or people who aren\'t your customers anyway, um, but this one particular.</p>\n\n\n\n<p>Hosting, uh, pirated, uh, GPL club. Where\'s archives, spammed, a ton of people, including people who are in the middle of this discussion. Uh, just at that moment, um, got a lot of Twitter, DMS and, and other things, uh, straight at people who totally don\'t want is going on. So, um, Allie Niman suggested, well, you know, one way we could come combat, this is go at the host and say, there.</p>\n\n\n\n<p>Spamming. Um, there\'s been some discussion of what could we do collectively to fight back and protect the ecosystem. Um, have you taken a look at those discussions or seen this come up in the past and have thoughts on it?</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Yeah. There have been a number of cases over the years where people\'s plugins have been forked and stolen and, you know, resold that\'s.</p>\n\n\n\n<p>I mean, I, I wonder how many of those plugins are actually in product. Especially on high level sites. I mean, if you are a web designer who is, you know, partaking in something like that, uh, you know, clients may have these things on their sites and not know it. I wouldn\'t think there\'s a huge number, but yeah, I think Allie\'s, uh, you know, Suggestion of going after hosting is, is, is a good one.</p>\n\n\n\n<p>I think maybe it could go after payment gateways too. I know, like, especially PayPal has been rough on anyone. Who\'s doing anything sketchy over the years. You know, if, if that\'s gets reported, they may get their, uh, their payment gateway shut down, which, you know, could kind of cripple their ability to redistribute this stuff.</p>\n\n\n\n<p>But yeah, I mean, I do think WordPress leadership should speak out on it. You know, I, I know that\'s, I mean, it\'s not just a WordPress issue. It\'s, it\'s a software issue. It\'s an open source issue, but you know, just some sort of statement, you know, maybe even at word camp us about, you know, let\'s protect this ecosystem.</p>\n\n\n\n<p>Let\'s make sure. You know, everybody\'s playing by the rules and that we, you know, if we find someone who\'s not, we should, you know, make, uh, everyone aware of.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, exactly. I\'ve I\'ve often thought, man, I wish there was some advocacy. I wish we had like a nonprofit or, or some collective where we supported, uh, advocacy for open source to both educate people who know nothing about it, the consumers and everyone else and just show, Hey, look, this is a professional space where people are making, living from small.</p>\n\n\n\n<p>Freelancers solo people. Who\'ve been at it a long time, basically family businesses, all the way up to, um, in the bigger, the bigger companies that are heavily by everyone else. It\'s a, it\'s a big family and, uh, they\'re real people here. And if you, you support these products, it\'s, uh, it\'s hurting us. So there\'s kind of that, um, The, uh, tending the collective governments, governance of an industry as a commons like this, an open source one there\'s, there should be things that, um, outside of the project, even that, that people in, in the WordPress business.</p>\n\n\n\n<p>Can do that would kind of be on the list of Eleanor Ostrom\'s, um, things that healthy ecosystems, healthy commons do to, uh, to protect themselves where you, you find the bad actors and find ways to suppress and discourage that. And sometimes if they\'re internal to the community, you wanna, you know, not completely.</p>\n\n\n\n<p>Demonize them, but give some kind of carrots and stick so that there\'s incentives to come back and be a good contributor. And you know, some host, straight anger, rage on the internet is just adding to useless stressful stuff. Maybe there\'s a win in this and on the advocacy and education side. But, uh, I also threw out the idea that since the WordPress foundation does legal.</p>\n\n\n\n<p>Defense of the WordPress trademark. Uh, this is like one step away. Suppose you had good citizens who are doing five for the future. Um, and they\'re, they don\'t have quite the means to individually defend themselves in the same way or they\'re are there ways we could, um, pull together and help each other through, um, through that, through the foundation or something like that?</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Um, yeah, you would think there, there could at least be some sort. Guide to, uh, steps you can take, you know, I know they, they have lawyers working on their side, as you said, to protect trademarks and, and things like that. You know, even if it\'s just general advice to come out and say, Hey, your, your, your, your plugin has been selling on the black market.</p>\n\n\n\n<p>Here\'s what you can do. Here\'s some resources that would, you know, seem like at least the basic way to, to help.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. And I think it\'s kind of a black eye for. Uh, for any, any business ecosystem, uh, people looking to get into it. Um, it may not understand quite what\'s going on, but it looks if it looks like you\'re laying down to predators, um, who have gotten entrenched it\'s it\'s not a good.</p>\n\n\n\n<p>Sign for the healthiness of the ecosystem. And it, it would, um, definitely be good for morale to have some, some clear boundaries defined and say like, this is not okay in our, in our world. And we\'re not gonna support this anyway and find what we can do to limit it. Um, over, I wrote about this a few weeks ago, because FIUs had on their blog.</p>\n\n\n\n<p>A pretty long post about dealing with this. Um, and we\'ve, we\'ve done this before people getting courseware stolen. It can be content that can be all kinds of things getting ripped off. Um, When you, you may or may not have any intellectual property rights over it. If it\'s, if it\'s GP stuff, um, some is some isn\'t.</p>\n\n\n\n<p>Um, but they, they actually had some interesting, uh, case studies or, or people who, who didn\'t fly off the handle, they would get, ultimately you\'re getting support requests from people who have. This pirate did stuff. And sometimes they don\'t know, um, what they\'ve done or what situation they\'re in. And someone had found that it was kind of a teachable moment where they could educate and, and convert some of these people into customers and say like, oh, okay, we\'re not gonna give you support until you\'re actually our customer.</p>\n\n\n\n<p>And some people just needed that. They just needed the education, I guess. So, um, there\'s maybe there is some win possible there. Um, All right. Well, what\'s your, uh, what\'s your next pick?</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Okay. Well, I have to go with the, uh, little scandal about, uh, WP optimize and the alleged cheating on, uh, performance tests by, uh, turning off all JavaScript.</p>\n\n\n\n<p>Um, and when it\'s, uh, under a, a testing user agent, I guess it\'s, it\'s able to detect that. Say okay. It\'s GT metrics or it\'s, uh, page feed insights. And in that case, we\'re gonna turn off all of our, all of your site\'s JavaScript to boost your score and make you feel good about yourself, right?</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. So that got quickly compared to the Volkswagen scandal a few years back, and there may have been another manufacturer car manufacturer doing that when you hook the cars up to a, uh, Uh, emissions test, um, they, uh, turn the catalytic converter and filters on and rest of the time, uh, it, it\'s not on and you get, um, better performance on the road.</p>\n\n\n\n<p>And, um, I don\'t, if it yeah, probably affects fuel economy. Right. Um,</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> yeah, I think it was, I want to, I think it does. And then it also, I mean, the pollutants that came out of those cars on the road,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Way more than the legal limit. Yeah, yeah, yeah. Really bad. And so they had, it was a huge blow for the, um, for the brand, uh, a huge amount of distrust, uh, and, and a blow for what everyone, you know, probably was a really solid brand Volkswagen.</p>\n\n\n\n<p>Um, the. The interesting. I, I remember I, this was a, when I was teaching writing last, um, there was a Corey doctoral piece about this. Well, it brought it in as an example, and he was talking about we\'re dangerously going into a. A future where software can be so sophisticated, we don\'t really know what it\'s doing.</p>\n\n\n\n<p>And we don\'t even really know if the experience we\'re having is software mediated with an there\'s an algorithm that is manipulating the semi virtual experience we\'re having. So is your, is your WordPress really? You know, what\'s it doing? Uh, who\'s it talking to, um, Are you, are you, when you think you\'re doing tests, are you getting valid, um, results?</p>\n\n\n\n<p>So to me, the trust issue is, is interesting. Um, how, how has the response been from, um, from the company that has allegedly this, this code in it that is sort of a cheater code on, um, op optimization tests.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Yeah. So Sarah Gooding at the WP Tavern put. Article together that, uh, spoke with, uh, one of the lead developers of WP optimize.</p>\n\n\n\n<p>And, uh, according to him, it was a code that was forked over from another plugin. And I have to plea ignorance on the name of that plugin right now. But, uh, apparently they were in talks to maybe, um, acquire this plugin. And at the time they decided to, um, kind of merge some code in there to make it, um, You know, to get ready for this big merger they were gonna have, which ended up falling through.</p>\n\n\n\n<p>And then, um, it ended up that they forgot the code was in there. The deal fell through. And, um, they weren\'t quite sure why the code was still in there or, you know, kind of pleaded ignorance on it. Um, but then Sarah also came up with a, an article the day after that, uh, kind of dug into it more where I guess, you know, this, the, um, the, the settings in this plugin are also a little bit up too, so they\'re not, uh, completely clear on what they\'re doing.</p>\n\n\n\n<p>And so, you know, there\'s, it, it, it may be not an intentional thing, but at the same time, it still doesn\'t look very good. Right.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, it will be interesting to see how quickly and how well that that clears up. Um, yeah, I really care about the trust, the trust issues, and you know, again, kind of like the, the piracy, if, if you, if there\'s a widespread perception of, we can\'t trust.</p>\n\n\n\n<p>Certain brands or theoretically any hypothetically anyone in the, in our ecosystem. It it\'s a, that\'s a really bad consequence where so much trust is at, at the core of making open source work. But in a sense, it\'s open source working. Someone looked at the code</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> yeah. It\'s interesting that somebody was able to test that and found that what it was doing.</p>\n\n\n\n<p>And I mean, I don\'t know. I I\'m, I\'m not a huge believer in these metrics. Um, you know, they, I don\'t wanna say they\'re made up, but they\'re, they are kind of made up and they don\'t always reflect, I don\'t think, you know, the actual user experience. Right. But, you know, I think any of these systems we bring out, somebody\'s gonna find a way to cheat on them.</p>\n\n\n\n<p>And if you wanna cheat on your performance test and get yourself, you know, a little bit of an ego boost by saying, oh, I scored a 99. You. And so be it, um, you, you are the one that kind of has to live with it, but I think the plugin should, at the very least be very clear about what they\'re doing and you know, what it\'s used for.</p>\n\n\n\n<p>What\'s good about it. And, you know, here\'s how you shouldn\'t use it. Um, which, you know, they apparently did not do in this case. Sure.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, it, it does pose again to me, like interesting questions about what could we do better as a community collectively to incentivize good behavior around performance. Can there be kind of a general working standard or guidance on for plugin authors and for users?</p>\n\n\n\n<p>What, what we\'re looking for? What makes afor, what, what\'s the margin of, of a good performance plugin or just. I wish if you had details, when you\'re down, you you\'re in the.org repo, how many queries does has add to your page? What kind of, what are the main dependencies here? Um, is there a quick way to get a heads up on that sometimes, um, before you in install something and then find out , um, all, all of, um, all of the work being done in performance core is, is really outstanding and.</p>\n\n\n\n<p>I it\'s probably wrong to think about it as this is just a core, that\'s their problem. And this is a, a core thing. There\'s, there\'s a huge plug in ecosystem where, uh, testing and standards could be, um, a bit more rigorous and that it sort of came up a bit with a proposal from, um, uh, Felix aren\'t to, um, um, look at to when, when plugins are submitted.</p>\n\n\n\n<p>Um, To, uh, test specifically around performance and security, a little bit more rigorously.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> And yeah, I mean, we have, I mean, you know, where I live, we have, uh, energy star appliances, right. That means that they\'re certified as being efficient. You know, maybe there\'s a third party out there that can do that for plugins, or I don\'t know if the word price folks would wanna do that necessarily, but, you know, we have, yeah.</p>\n\n\n\n<p>You could have like some sort of, uh, certification system that says, Hey, this plug. You know, performs well and is lean and is secure. Yeah, of course that, you know, it\'s hard with software because there\'s no guarantees. Um, of course your refrigerator could break the day after you bring it home. But you know, things interesting to thank see if somebody would ever, uh, come up with something like that, that you know, and how legitimate it could.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Sure. Yeah, that could be really useful. Um, maybe if it was a consensus or amongst hosts who, you know, doing anything at scale, the, the, the performance, um, matters in dollars in significant dollars. Um, and yeah, we should think more about that. Um, my, my next pick was, um, Gravity acquires gravity. Um, the, uh, uh, gravity forms, um, uh, acquire G gravity flow and, uh, and the services, um, oriented.</p>\n\n\n\n<p>Um, what was it name,</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> name, uh, gravity experts. I think.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, gravity experts. Okay. Um, not too familiar with those, but these are, uh, product and, and services in the gravity forms ecosystem that, um, we\'re are owned and were owned and developed by, um, one of, uh, gravity\'s team members. Um, so that\'s, that\'s kind of an interesting story is I don\'t, I\'m not aware of anyone, anyone else building an E plug in ecosystem.</p>\n\n\n\n<p>Around their product and working that closely where your employees are, are developed. Uh, I would assume, uh, encouraged to develop a product or service related to it on their own, and then maybe it really takes off and bring it back in into the, um, parent company. Um, Is that, is that something unusual they\'ve innovated with it\'s you\'re not being taken over by a big, uh, a conglomerate it\'s it\'s the family you\'re already</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> in.</p>\n\n\n\n<p>Yeah. I kind of think that\'s interesting. Isn\'t it? I mean, you do a side project based on your everyday job and then your boss essentially buys your product. It\'s like getting a really good bonus at work. You don\'t don\'t really get that. So I, I, I kind of think it\'s cool though. Um, you know, gravity forms, if you use it a lot, I mean, you notice there are tons of, you know, official extensions and they have a whole third party directory now and they go through and certify certain add-ons, uh, third party add-ons on their site that you can look through.</p>\n\n\n\n<p>So, you know, kind of a neat thing. I mean like gravity flow. Um, allows you to really do some complex things with, um, what happens when a form gets submitted. You can tie it in with a bunch of third party services or have it do different things on your site. So I think that just is such a natural fit for gravity forms that, you know, why wouldn\'t they wanna sell something that does that.</p>\n\n\n\n<p>Right. Um, and then gravity experts is a service. That\'ll do a lot of customization and. As I mentioned to you off the air, I think that, you know, they probably get a lot of customization requests through their support. Sure. Um, and I\'ve actually just from my own experience, found their support to be awesome.</p>\n\n\n\n<p>They tend to, I mean, they don\'t mind sending you code snippets to use for, to achieve certain things. Um, this steps it up a whole other level. Um, you know, if you need customization services, well, we have that too. Um, you know, why not keep that all in house and you. And maybe some of the customizations they create could end up being products on their own too.</p>\n\n\n\n<p>I think it would be a great way to kind of continue to grow their</p>\n\n\n\n<p><strong>Dan Knauss:</strong> business. Yeah. It\'s a really, it\'s a really cool thing. And I, I wonder if anyone else is, is doing that. It, it, it occurs to me. The advantage of it is, is that, um, your own in internal people know that product best, but there\'s not really, if they\'re already working for you there, there\'s not.</p>\n\n\n\n<p>If you budget and, and allocate like, Hey, go and develop, you know, blue sky, even, you know, go and build, uh, add-ons for this. Um, and, and see what we come back with. It\'s a totally different thing. Um, the incentives are, are not there as if you\'re, you\'re building this as your own product and in if it\'s good enough, um, it\'s you, you gotta get it to the point of maturity and, and quality where a competitor.</p>\n\n\n\n<p>Might actually want it or someone else might. And, um, then I guess you\'re, you\'re really establishing value in a, um, a clear and somewhat more neutral way while still totally being within this, um, sub economy, this E gravity ecosystem. It\'s a smart, smart way to own and share it collectively and not smother.</p>\n\n\n\n<p>Creativity and things like that. And yeah, I just don\'t, there\'s no other way to, um, to do something like that in the usual, usual way where some outside company would absorb something else. And then maybe the quality, you know, there\'s just stereotype or fear the quality\'s gonna drop off cuz it\'s a different,</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> yeah.</p>\n\n\n\n<p>Usually we worry, even plugins get acquired, but not in this case because it\'s, you know, the OG has it now, so we don\'t have to worry about, you know, them. You know, making it less quality or, or not supporting it? Well,</p>\n\n\n\n<p><strong>Dan Knauss:</strong> yeah, it\'s a fantastic model. I think others should seriously take note. There\'s plenty of, um, plenty of other ecosystem plugins that, uh, have this potential for that kind of collaboration.</p>\n\n\n\n<p>Um, good one. Okay. So yeah. What\'s your, what\'s your third?</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Pick. So my third one is that, uh, wordpress.com this week announce that they\'re gonna start offering $499 websites to anyone who wants one it\'s, uh, supposed, supposed to be done within four business days. Uh, they\'ll give you a choice of themes or they\'ll pick one for you, which is kind of interesting.</p>\n\n\n\n<p>Um, you pick my theme. Um, I, I, I kind of wonder. Who the target is and what the strategy is here. Are they just trying to get you in the door? So that you\'re kind of part of their wordpress.com ecosystem you kind of, uh, a different, uh, different strategy? I would think.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, it\'s, uh, it\'s interesting. I did write about this, um, because it was, I, I love it when, you know, we have, we have about a 10 year, um, backlog, uh, Back issues and, you know, things that have, uh, we can look back and see the history on.</p>\n\n\n\n<p>And, um, I thought it was a further back, but it was just probably about a year ago that, um, wordpress.com did that for the first time where they introduced a premium, um, built with wordpress.com service, which this seems to be an add-on to that the, uh, part of. Same brand, but the, the initial one a year ago was, um, not supposed to compete with freelancers.</p>\n\n\n\n<p>It was priced at around $5,000, um, as a baseline that seems to have come down in their FAQ. Now it\'s, it\'s around three. So there\'s still this, this premium layer. And I think that was supposed to use, um, Agencies and people within the ecosystem to do some of this work. I\'m not, we really haven\'t got, I don\'t think anyone has dug into that or gotten numbers.</p>\n\n\n\n<p>We were very curious to, to see what, um, what might come out of that in, in terms of its success for wordpress.com and who\'s how many sites are being brought into it. What that it\'s, we\'re, we\'re very data poor. About the economics and details of the market. And that also made me think too, in this, in this story, that, um, is it, is that really competing or over the same piece of the pie or is there, is there so much there it\'s not, um, not a, not a threat to.</p>\n\n\n\n<p>So, so freelancers, small agencies, the way they, they might think, um, you can do very different things and I can see why.com wants to, you know, continually expand at, um, where it\'s easier to do that, where it\'s always had more market share at the lower end of, of the market. Uh, but when you\'re freelance, those, those are not necessarily the jobs you want.</p>\n\n\n\n<p>Um,</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> So I, I actually made a joke online that I would rather like farm up stuff I don\'t want to do to them because at that price point I\'m, you know, probably gonna lose money. So yeah, if they wanna take on that, that small stuff, that\'s, that\'s cool with me, but right. Um, it is kind of interesting to, to think that they\'re going after that, that market too.</p>\n\n\n\n<p>I. Right, but I think you\'re right about, about them not wanting about a lot of people on the lower end, going to wordpress.com to start out because it is kind of managed</p>\n\n\n\n<p><strong>Dan Knauss:</strong> for them. Right. And as they pivot more and more to presenting themselves as, as a managed WordPress host, um, with. With that market in mind.</p>\n\n\n\n<p>Um, you know, there, there are others already doing, doing this. Why, why let competitors have a, a free run at this? Um, they\'re doing the same thing, but.com now I\'ll Hey, you can, uh, you can install pretty much anything in the repo. I, I think, and there\'s a commercial ecosystem within there. You can buy Yost and everything else right from within there.</p>\n\n\n\n<p>So as it grows, it\'s not, you know, it\'s not. The way to look at that is still ecosystem growth with opportunities for, um, plugins and services and other things like that. But, um, I also feel like we looked so much at the market share number and where it\'s biggest is the, um, top 10 million plus active sites with WordPress installed.</p>\n\n\n\n<p>So it\'s, it\'s the bigger universe. And you assume that these are. People\'s personal blogs and so on. But, um, because they\'re not, it\'s just by traffic, you know, they\'re not in the top 10,000, but, um, when I did a lot more freelancing, a lot of the clients I had that were good would be established. Nonprofits, local governmental things, um, people with, with significant budgets, but they\'re their traffic is they don\'t care about it.</p>\n\n\n\n<p>Number one, that much necessarily. Um, they\'re not doing even doing much content marketing. Maybe they have a newsletter. They\'re speaking to a very. Specific audience that may be numbered in the hundreds or the thousands. They\'re doing a lot on social. So they would be considered in this low end of the market, but that\'s, um, but by assessing their site by traffic, but it\'s not a that\'s completely a misnomer, then they would have no, no use for a, um, A hired site builder, even they need, they need an agency or, or someone with a capacity to do support in the hosting and a rather much more elaborate feature set.</p>\n\n\n\n<p>Um, so that market, that market is always there. I, I, I think people forget that and you\'re not gonna be killed off by the $500, four day service.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> No. And, and I mean, if they they\'ve talked about, you know, wanting to compete with some of these proprietary systems like Wix, And I think that\'s kind of the same market.</p>\n\n\n\n<p>I mean, people that want to not spend a ton of money and maybe in this case, they don\'t even really wanna build it themselves. They just want something up there and maybe as they grow, they go to something bigger. But to start out, you know, it\'s not a huge investment and. You know, those are the folks that I think aren\'t necessarily attracted to freelancers, not just cuz of budget, but because you know, somebody wants to try a blog.</p>\n\n\n\n<p>Somebody wants to start their small business and with no guarantee of how long that\'s going to last, you know, is that client going to still be there for you in two years? And if they are, you know, what\'s the value. Are you getting so many support requests that you can\'t necessarily deal with? So in that way, I, I, I don\'t think this is a bad thing to kind of tie them all into that, that one service, uh, it might, it might be, you know, something more beneficial for them that where they can even leave at any time they want to.</p>\n\n\n\n<p>I mean, the business goes belly up, you know, it\'s, it\'s not as tangled and messy as it might be getting away from an agency or a freelancer.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. And I\'m, I much rather have them on, um, on.com or anything in the WordPress ecosystem than WX. Um, which I still, man, I have a, I was in, I\'ve had to use it again recently for a, a local nonprofit I\'m, uh, helping out.</p>\n\n\n\n<p>And, and I, I don\'t like, I don\'t like Wix . Um, and I\'m just thinking like, if, as this organization grows and what\'s needs, are it, it needs open source. It needs WordPress. It needs data security. Um, there. There are things that maybe they\'re not in a position to pay for, but they\'re at this point, but their success will get them into that at some point.</p>\n\n\n\n<p>Um, and there as a, um, running your own business, that\'s a kind of, you can only do that. You know, you, you can ask those questions and do the discovery and form the relationship and say, look, these are, these are the needs you really have. And, um, what\'s. What\'s really the best product or, or thing here. And sometimes that leads to long good relationships with, uh, a decent paying client who may get a lot bigger, um, in that budget at least.</p>\n\n\n\n<p>So.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Absolutely.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. All right. Well that, that all kind of ties in kind of nicely, um, to the last thing, um, kind of our topic we wanna open up for kind of long term discussion and get. People engaged with, um, kind of a big central one for, for post status. And, and I think everyone working in this space is, is professionalism.</p>\n\n\n\n<p>And what does it mean to be a WordPress professional? We say we\'re the post status is the community for WordPress professionals. And that\'s an interesting phrase that\'s really kind of come into, I would say, in the last five to 10 years, um, widespread use in our community. And what does that, what does that mean to you?</p>\n\n\n\n<p>Um, As an individual as a, and within the community and the, the business ecosystem, uh, to be a WordPress professional and professionalism in general.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Yeah. I mean, I think, you know, WordPress professionals kind of interesting, cuz it started out as a small blogging platform, right. And people were using it as more of a hobbyist thing.</p>\n\n\n\n<p>And then all of a sudden, you know, the theme and plugin markets kind of exploded and we. Using it as a full blown CMS and, you know, for all sorts of projects from, you know, the, the little tiny startups to enterprise. So I think the professionalism part of it is, you know, that there\'s a lot of traditional parts to professionalism.</p>\n\n\n\n<p>Like I, I think being polite and honest and, you know, hardworking and all those things come to come to mind, but then, um, it also meets kind of. The WordPress way. That\'s a little bit more relaxed. I think that kind of reflects, I think that reflects on Matt Mullenweg a little bit. He\'s not always, you know, the, uh, old fashioned stuff, shirt, CEO that mm-hmm , you know, gets up there and makes.</p>\n\n\n\n<p>You know, grand pronouncements necessarily. Um, but it also, I think, reflects on, you know, the word camp culture of just kind of going come as you are. Um, but generally, you know, being kind to one another being open, uh, to discussion doesn\'t always work out that way. But, um, yeah, I think it\'s, it\'s an interesting way to think about.</p>\n\n\n\n<p>WordPress these days. I mean, cuz a lot of us make a living with it. Um, either full time or at least part of the time and you know, the ground rules that applied for other sorts of businesses over the years don\'t necessarily, you know, apply here. Uh, it\'s a little bit different kind of ecosystem I think.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. It, it definitely is. I, I think people hear that. That word and there\'s sort of the, you know, the larger corporate stereotype of, um, well, there\'s, there\'s good thing. There\'s good. Basic definitions of, you know, you show up every day, you do the, you do the work every day, no matter what, um, the basics of it, but there\'s also the, um, the kind of the negative, um, connotations of professionals.</p>\n\n\n\n<p>Um, In, in a more corporate scaled up space, that\'s kind of lost the human and individual element, the personal element, and doesn\'t have this kind of big family community of relations necessarily. And I, I mentioned to you a, a friend, um, Sarah Shelman. Who\'s got a book. I think that touches this. She runs a, they do a lot with WordPress, but it\'s a, it\'s a social design agency.</p>\n\n\n\n<p>They\'re they\'re anthropologists and ethnographers who try to solve, um, Largely institutional social problems and municipal governments and lend advice on, um, dealing with things like homelessness and, and, uh, why do helping institutions often they\'re too bloodless and faceless and impersonal to help very real individual human problems.</p>\n\n\n\n<p>And, uh, I got to know, I got to know her. And there are people last year. I\'ll probably do it again. We\'re working with, um, kind of post COVID recovery projects or city is, um, funding. Uh, we just listened to people\'s stories and got them to talk about wellbeing and what that means for them. And, uh, it\'s, it\'s a very unusual kind of, wooy even kind of, hippie-ish, uh, weird thing that you don\'t usually associate with government, um, bureaucracies doing something like that.</p>\n\n\n\n<p>Individuals listening to each other and caring something about the experience and totality of each other\'s lives. Um, you know, that might be good for good for people.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> We use more of</p>\n\n\n\n<p><strong>Dan Knauss:</strong> that. Absolutely. Yeah. And she, we were talking about professionalism specifically after this and she said, Yes. The, the dysfunctional form of that, that we try to overcome is, is the sense that you\'ve got to create a mask of invulnerability.</p>\n\n\n\n<p>And I think that there\'s coinciding and even integral to word breast professionalism, WordPress professionals, and professionalism is that you can be known as a person who has. A full life and all these other things going on. And, uh, we talk about that and there\'s, there\'s not as much of this kind of informal or private segregation from the business side, especially, maybe on, you know, on those who\'ve been in it a long time or contributors and, uh, small businesses and, and so on.</p>\n\n\n\n<p>And that\'s a, really, a really healthy thing for people. And it translates to a healthy community and I think a healthy. Business ecosystem, um, because it takes the edge off of straight hard competition, the tendency for towards paranoia and reaction and meanness, uh, especially on remote and internet stuff.</p>\n\n\n\n<p>Um, I feel like that\'s a, a big part of it. And when we, uh, Michelle Frette featured, um, ran, uh, or featured, uh, member spotlight for. The week and, um, well known to many, many people, Jonathan Boer. Um, who\'s now at automatic as, um, working on training, which is a kind of newer and big thing there, um, impacting the, the community and doing code instruction.</p>\n\n\n\n<p>Um, and he said some really good things that, um, I think define. Him and others as a, a good model of, of what professionalism is. And he, you know, there\'s power to change lives and people finding, um, their footing in the community and in work here. And, um, what else was, was, was in here. It was just a very, there were very personal flavor to it.</p>\n\n\n\n<p>Um, we\'re not doing kind of faceless, um, Roles and cubicles here. A lot of people really value that freedom.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Yeah. I mean, you can see it as you know, we\'re not afraid to let our human side show, which I think is like really refreshing. I mean, if you look at a lot of the more traditional corporations out there, I mean, when do you see their leadership out there?</p>\n\n\n\n<p>Like just being humans. Um, and of course it\'s at a much greater scale, but, um, Just just even, even with, uh, Corey Miller, um, you know, talking about the struggles that he\'s had and, you know, I mean, he\'s a very successful person and you know, he, he and, uh, his family have done a lot in WordPress, but you know, he\'s still ha not afraid to show some vulnerability.</p>\n\n\n\n<p>I think that\'s so important. I mean, did you don\'t feel like you have to put up a facade? Um, you know, that\'s one thing I\'ve. Kind of felt comfortable with in the, in this, uh, community, is that if I\'m having a bad day, I can say that on Twitter and, you know, still being thankful for what I have. I could still say, it\'s not been a good day.</p>\n\n\n\n<p>I haven\'t done well. You know? Um, not every industry really accepts that and would, you know, applaud that. But I think ours generally does. And I think that\'s something we should not take for grant.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah. I, I, I really, uh, value that too. And, and agree with that. I think that, um, Jonathan and you, and I have probably been around this around the same period of time going back 20 years.</p>\n\n\n\n<p>So we\'re in the generation X category, um, where, um, yeah, we might have slack or tendencies, but I, I think it was still, it was still younger people and, and down to my kids\' ages, who. Really more comfortable with, um, not separating who they are in their private lives and you get messy, even, you know, politics and, and feelings about a variety of things that we don\'t.</p>\n\n\n\n<p>Um, you don\'t have to pretend that doesn\'t exist. It\'s it\'s a really, it can be a really fine line. You don\'t there\'s there\'s oversharing. There\'s there\'s stuff it has to balance out, but yeah, somehow. When we\'re healthy, uh, as a community advantages to work out. And Jonathan mentioned, um, post status is being a place that serves that by, um, not just you can go there for answers and social kind of hanging out and, um, Fun things and, and, and, uh, there\'s always plenty of good humor, but there\'s, he also mentioned having bigger philosophical discussions around business, open source and everything, WordPress related in a respectful and inclusive way.</p>\n\n\n\n<p>And, um, yeah, there\'s not, there\'s no way to define, there\'s no recipe for that, but we know it when, when we see it and that have being able to. Maintain a level of trust that comes from being real people to each other who care to know something and share things about each other. Um, and you know, the role that word camps play in that meetups for sure.</p>\n\n\n\n<p>Um, mentoring becoming more of a thing, um, that we talk about and, and support. Um, it, it allows the hard stuff, the bad feelings, conflicts competition. In theory, and I think we\'ve seen this happen. people can work, work it out. It takes the edge off of that and becomes, um, a way where I don\'t know, pressure valve a yeah, it, it definitely performs, um, a, a healthy service to, um, a way to check in and, and maybe help each other maintain a, a healthy.</p>\n\n\n\n<p>Community and, and business culture, um, that is, that is professional in our own, our own way. Um, and all the, all the normal ways you\'d think about showing up, getting stuff done, being reliable and, um, the best you can every day, but also showing up as a, as a real person who values, trust and kindness and respect, um, between each other.</p>\n\n\n\n<p>Yeah, the more of that, more of that, the better, but . Do you have any other, uh, thoughts on, um, on that topic or where we, where that could go, uh, hoping to pull more people into to discuss it? Um, since it seems, seems like one of those kind of pressures, commodities that, you know, it\'s actually not an economic thing.</p>\n\n\n\n<p>You can\'t, you can\'t buy.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> No, and it\'s, I think it it\'s good for your, for your own health, for the health of the community. And you know, when you can see others, whether you agree with them or not as, as a person, as opposed to, you know, sub distant object that you\'re, um, at odds with, or you want to, um, or you\'re competing against.</p>\n\n\n\n<p>It, it does take that edge off a little bit. It lets you just kind of take a deep breath and you know, I mean, we see arguments just like in any other community, but what I don\'t see is them becoming to the point where, um, at least in public where, you know, it it\'s just incredibly toxic. Um, and usually if things do go bad, there\'s always somebody else to come in and say, Hey, wait a minute.</p>\n\n\n\n<p>Let\'s, you know, take a deep breath, which. It\'s just, I think refreshing, I, I, I wish, and I won\'t go into it too far, but I wish we had, uh, you know, political leadership that could do the same thing we had, like, like, you know, a referee that could come in and voluntarily say, Hey, you guys don\'t agree, but that\'s okay.</p>\n\n\n\n<p>It\'s</p>\n\n\n\n<p><strong>Dan Knauss:</strong> tough. Yeah. And it\'s there, it\'s an ideal, we\'ll never be perfect at. Um, and. Yeah, to take one example, I\'m thinking about writing about, you know, one of the, um, a, a friend in, uh, uh, a country where democracy has been threatened and on the way and along a while. Um, and that\'s very widespread. We\'re all, we\'re seeing a lot of, uh, difficult times for some of the, the, the key values in the project, in the community and the, in our own lives.</p>\n\n\n\n<p>Um, and actually was. I think jailed and suppressed for things. He was blogging of a political nature on his WordPress blog in his, in his country. And, um, which you can imagine doesn\'t a number on you, um, psychologically and, and socially. And then of course, like anyone else, especially your plugin or theme author, or something like that, you run into what feels like unfairness at some point in.</p>\n\n\n\n<p>In the, um, in your work life, in the ecosystem of, um, how decisions get made, how, how things are handled. And, um, I, I feel for people sometimes when we\'re not at our best, or even when things are, are perfectly fine, it\'s not, everything is not gonna go your way all the time and it can feel oppressive or like people are not living up to, uh, levels.</p>\n\n\n\n<p>Transparency or kindness as, as they should. And I try to think, yeah, you know, there\'s people coming from a lot of different contexts where, um, you wanna be sensitive to all that, but there\'s also, there\'s also a need to kind of bear up with, we\'re not always at our best. We\'re not, everything is not consistent the way we think it should be.</p>\n\n\n\n<p>Um, but. That means try harder. Don\'t give up on it. Um, keep it\'s it\'s it\'s hard for a reason. It\'s not, uh, not something you can just take for granted. Um, yeah, and I wish there was more of it well said. Well, I look forward to, uh, clicking, publish on, on the piece you\'ve written for us that touches some of.</p>\n\n\n\n<p>Some of some of these things too, in the writing space that we both occupy and, um, the value that being able to write and talk well and respectfully and in an informed way, um, about things going on and in WordPress is really important. And I thankful for your steady part in it. I\'ve, you know, read you for a long time.</p>\n\n\n\n<p>This is, I think the first time we\'ve connected face to face and, um, yeah, I\'m glad. You\'re here and that you\'re there. doing what you do.</p>\n\n\n\n<p><strong>Eric Karkovack:</strong> Thank you. Thank you. It\'s been, uh, it\'s been awesome being here with you and, and, you know, I\'ve been a post status member for several years now and, you know, I\'ve just gotten so much out of it, just the connections.</p>\n\n\n\n<p>And just as you said, the philosophical discussions that go on and it it\'s, you know, it, it\'s a little bit of everything and I, I think it, it\'s a great representation of the community and as a.</p>\n\n\n\n<p><strong>Dan Knauss:</strong> Yeah, well, it\'s the, it\'s the members membership who makes it it\'s the community that shows up and, and, uh, that we keep carrying each other along and, and bringing in new people.</p>\n\n\n\n<p>It\'s it\'s great. But everyone, no one owns it. No one, no one can take full credit for it. We\'re glad to have you here. So thank you. Thank you.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Sep 2022 17:58:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Post Status: Post Status Picks for the Week of August 29\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=114397\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://poststatus.com/post-status-picks-for-the-week-of-august-29/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3311:\"<div class=\"has-background has-theme-palette-7-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Building an empire on free code: Matt talks WordPress outside the bubble. James Kemp, Anh Tran, and Phil Webster on WooCommerce options for licensing. Adam Silver on testimonials that help you grow. Anne Bovelett on accessibility and page builders. Jamie Marsland wonders if people building third-party plugins for the block editor have been too preoccupied with whether or not they could that they didn’t stop to ask if they should. Are they heading in the wrong direction? </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 id=\"h-post-status-podcast-picks\">Post Status Podcast Picks <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /></h2>\n\n\n\n<ul><li><strong>What\'s Your Problem</strong>: A fairly good &#8220;outside the WordPress bubble&#8221; <a href=\"https://www.pushkin.fm/podcasts/whats-your-problem/building-an-empire-on-free-code\">interview</a> with <strong>Matt Mullenweg</strong> by <strong>Jacob Goldstein</strong>. Among other things, they discuss how you can make money and &#8220;build an empire&#8221; on &#8220;free code.&#8221;</li><li><strong>Do The Woo</strong>: <strong>James Kemp</strong>, <strong>Anh Tran</strong>, and <strong>Phil Webster</strong> have <a href=\"https://dothewoo.io/software-licensing-solutions-for-woocommerce-builders-with-anh-phil-and-james/\">a discussion about the options for software licensing</a> with <strong>WooCommerce</strong>, both out-of-the-box or when you roll your own custom-built solution.</li><li><strong>Kitchen Sink WordPress</strong>: <strong>Adam Silver</strong> on <a href=\"https://kitchensinkwp.com/podcast-e444-using-testimonials-to-grow-your-business/\">how to use testimonials</a> to grow your business.</li><li><strong>Matt Report:</strong> <strong>Anne Bovelett</strong> explains <a href=\"https://mattreport.com/wordpress-accessibility-in-a-page-builder-world/\">why accessibility is important to her</a>, and how to make accessible sites with page builders.</li></ul>\n\n\n\n<h2>Video Pick:</h2>\n\n\n\n<ul><li><strong>PootlePress:</strong> <strong>Jamie Marsland</strong> asks if Gutenberg Third Party plugins are <a href=\"https://vimeo.com/734751088\">heading in the wrong direction</a> — with a few fun <strong>Jurassic Park</strong> clips.</li></ul>\n\n\n\n<div class=\"wp-container-29 wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/wordpress/week-in-review/\">Week in Review</a> — also available in <a href=\"https://poststatus.com/newsletter/\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" />  </p>\n\n\n\n<p>And don\'t miss <strong>the latest updates from the people making WordPress</strong>. We\'ve got you covered with <a href=\"https://poststatus.com/make-wordpress/\">This Week at WordPress.org</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2699.png\" alt=\"⚙\" class=\"wp-smiley\" /></p>\n</div></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Sep 2022 16:12:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Gutenberg Times: Designing Style Variations for Twenty Twenty-Three: The Good, the Bad, and Everything Else\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=21922\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"https://gutenbergtimes.com/designing-style-variations-for-twenty-twenty-three-the-good-the-bad-and-everything-else/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11004:\"<p>Since the release of Twenty Ten, the WordPress community has gotten a new default theme almost every year. This has allowed the platform to amass a well-designed and solid body of work. However, we needed to mix things up a bit, to make theme development exciting again. The next default theme, <a href=\"https://github.com/WordPress/twentytwentythree\">Twenty Twenty-Three</a>, will be a stripped-down base theme with a pool of style variations built by our design community.</p>\n\n\n\n<p>And the community has not disappointed. By the deadline of August 31, theme authors had submitted over 33 <a href=\"https://github.com/WordPress/twentytwentythree/issues?q=is%3Aissue+is%3Aopen+label%3A%22%5BType%5D+Style+Variation%22\">variations for consideration</a>. This was a reasonably significant turnout, considering that the <a href=\"https://make.wordpress.org/design/2022/08/10/twenty-twenty-three-default-theme-project-kickoff/\">project&#8217;s kick-off</a> was less than a month before. That is not much time to create and execute a design, and some people shared multiple.</p>\n\n\n\n<p>The final group of variations that will ship with Twenty Twenty-Three is set to be chosen by September 7. Not all will become an &#8220;official&#8221; variation. However, there is a <a href=\"https://github.com/WordPress/twentytwentythree/issues/73\">discussion that proposes</a> a separate child theme that would offer even more options.</p>\n\n\n\n<p>As one of the oldest theme authors in the WordPress community, I was excited about this effort. There was no way that I could pass on the challenge of designing a custom variation. Plus, it fit in line with some of the current work I was doing in finding pain points around FSE for theme authors.</p>\n\n\n\n<p>In this post, I will share my experience with <a href=\"https://developer.wordpress.org/themes/advanced-topics/theme-json/#global-styles-variations\">building a custom style variation</a> for Twenty Twenty-Three. </p>\n\n\n\n<h2>What Are Style Variations?</h2>\n\n\n\n<p>Style variations are one of my favorite features of modern WordPress, second only to block patterns. They allow theme authors to ship multiple design presets that users can choose between via the Styles panel in the site editor, as shown in the following screenshot:</p>\n\n\n\n<img />Example style variations for Twenty Twenty-Three.\n\n\n\n<p>Style variations can be as simple as a couple of color or font changes to entirely unique designs in their own right.</p>\n\n\n\n<h2>Before Beginning: The Right Mindset</h2>\n\n\n\n<p>The thing to keep in mind when designing a custom style variation is that you are not building a theme. You are skinning an existing theme.</p>\n\n\n\n<p>It is easy to get carried away with grand ideas about what is possible but only become disappointed with the limitations of the global settings and styles framework. You can change things like typography, colors, and spacing, but there are times when you&#8217;re stuck with chosen presets when they are used within templates. You also cannot arrange layout elements to your liking. That would require, at least, a child theme.</p>\n\n\n\n<p>Style variations are skins with a specific set of rules that you must follow. You do not quite have the full power of CSS at your disposal, but you can do some pretty nifty things under the current standard.</p>\n\n\n\n<p>Building a custom style variation is an easy introduction to modern theme development. It is a way to get your feet wet, to gain an understanding of how <code>theme.json</code> works.</p>\n\n\n\n<p>Designing a variation for Twenty Twenty-Three was also like trying to hit a moving target at times. Because the theme was under active development during this process, it meant that anything could change on any given day. And, the more complex a style variation was, the more likely a change to the base theme would affect it. This should not be the case for established themes, but it did create additional hurdles to clear.</p>\n\n\n\n<h2>Stepping into the Fray: Building a Custom *.json File</h2>\n\n\n\n<img />JSON file for a custom style variation.\n\n\n\n<p>Style variations are one of the easiest onramps to WordPress theme development because creators only need to work from within one file. The usual complexities around theme development are of no concern for such a project. And, because the global settings and styles feature has a standard ruleset, it&#8217;s easy to make a few changes and see quick results.</p>\n\n\n\n<p>Style variations are <code>*.json</code> files that live in a theme&#8217;s <code>/styles</code> folder. In the case of Twenty Twenty-Three, the organizational structure might look something like the following:</p>\n\n\n<pre class=\"wp-block-code\"><div><code class=\"hljs\">/twentytwentythree\n    /styles\n        /example-a.json\n        /example-b.json \n        /...\n    /theme.json\n    ...</code></div></pre>\n\n\n<p>Because my variation was named &#8220;<a href=\"https://github.com/WordPress/twentytwentythree/issues/86\">Rough Draft</a>,&#8221; it was located at <code>/styles/rough-draft.json</code>.</p>\n\n\n\n<p>Custom variations follow all the same rules as the <a href=\"https://developer.wordpress.org/block-editor/reference-guides/theme-json-reference/theme-json-living/\"><code>theme.json</code> standard</a>. The one exception is that variations have a <code>title</code> field to differentiate them from the theme&#8217;s default.</p>\n\n\n\n<p>The following is an example of what my variation&#8217;s JSON file looked like:</p>\n\n\n<pre class=\"wp-block-code\"><div><code class=\"hljs language-json\">{\n    <span class=\"hljs-attr\">\"version\"</span>: <span class=\"hljs-number\">2</span>,\n    <span class=\"hljs-attr\">\"title\"</span>: <span class=\"hljs-string\">\"Rough Draft\"</span>,\n    <span class=\"hljs-attr\">\"settings\"</span>: {},\n    <span class=\"hljs-attr\">\"styles\"</span>: {}\n}</code></div><small class=\"shcb-language\" id=\"shcb-language-6\"><span class=\"shcb-language__label\">Code language:</span> <span class=\"shcb-language__name\">JSON / JSON with Comments</span> <span class=\"shcb-language__paren\">(</span><span class=\"shcb-language__slug\">json</span><span class=\"shcb-language__paren\">)</span></small></pre>\n\n\n<p>With the basics out of the way, the variation can overwrite anything that is defined in the theme&#8217;s primary <code>theme.json</code> file. A creator can do something as simple as overwrite the <code>settings.color.palette</code> to create a new color scheme. Or, they can configure every possible setting and style under the standard ruleset, building a massively different work of art from the base theme design.</p>\n\n\n\n<h2>The Good: Wow, This Is Really Cool!</h2>\n\n\n\n<img />Single post view of custom style variation.\n\n\n\n<p>I have dabbled a bit here and there with custom style variations. I have long understood their potential, but I had yet to dive into a full-blown project, particularly one that could land in front of millions of users. I don&#8217;t know that my variation submission will be a part of the curated set, but it was just plain ol&#8217; fun tinkering with a design idea again. It was also far less stressful to not have to worry about every aspect of the theme.</p>\n\n\n\n<p>Given the time constraint, I pulled my initial idea from an old theme I had created. Then, I went to work, breaking as much as anyone could break (<em>don&#8217;t forget that I was also on a mission to find pain points</em>).</p>\n\n\n\n<p>There was a small part of me that remembered exactly why I fell in love with WordPress in the first place. I felt like that same 21-year-old kid who had just learned to edit a theme&#8217;s <code>style.css</code> file to make some minor color changes. This was the WordPress that I remembered from so long ago. The one where themes were not 100s of files and 1,000s of lines of code. It was about figuring out how to design for the first time and enjoying every minute of it, <em>warts and all</em>.</p>\n\n\n\n<p>If I&#8217;m being entirely honest, I probably took things a bit to the extreme. After looking at a few other variations, I realized I had customized quite a bit more than most folks. This is not necessarily a &#8220;good&#8221; or &#8220;bad&#8221; thing. Rather, it was more of a <em>Justin-does-not-know-when-to-stop</em> thing.</p>\n\n\n\n<p>At the time, with a looming deadline for submission, I was unable to customize every feature that I had in mind. There are simply so many possibilities that I could have continued working on this for weeks.</p>\n\n\n\n<h2>The Bad: Lingering Pain Points</h2>\n\n\n\n<img />Homepage view of custom style variation.\n\n\n\n<p>Between those moments of clarity and jaunts of glee were some rough moments. These were a necessary part of the process&#8212;someone needed to experience them.</p>\n\n\n\n<p>For example, why can I not control the <a href=\"https://github.com/WordPress/gutenberg/issues/39380\">gap between posts in a Query Loop</a> so that it matches the spacing elsewhere in the theme? There are still missing features or design tools support. Fortunately, some of the issues I either ran into or reported upstream were fixed during this process, such as <code>theme.json</code>-support for the <a href=\"https://github.com/WordPress/gutenberg/pull/43543\"><code>&lt;cite&gt;</code> element</a> and a <a href=\"https://github.com/WordPress/gutenberg/issues/43587\">duplicate background</a> on the Code block. Plus, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v14.0.0\">Gutenberg 14.0</a> added spacing and typography support for a boatload of blocks, both blockers for many theme authors who have tried to adopt FSE features.</p>\n\n\n\n<p>The upcoming WordPress 6.1 will continue to improve the lives of theme authors who are taking advantage of the <code>theme.json</code> toolset. Compared to a year ago, there are far fewer of those tiny irritations.</p>\n\n\n\n<p>Most of my initial issues were from building a design based on someone else&#8217;s system. It took me a bit to come to grips with Twenty Twenty-Three&#8217;s slug names, spacing presets, and similar bits. While I have a few opinions on a <a href=\"https://github.com/WordPress/gutenberg/issues/38998#issuecomment-1053727408\">standard naming system</a>, there are no right or wrong answers here. Plus, such <a href=\"https://github.com/WordPress/gutenberg/issues/38998\">discussions are a can of worms</a> that would only get in the way of the theme&#8217;s progress.</p>\n\n\n\n<p>I had to remember that I was skinning an existing theme. It was my job to apply my vision onto the canvas sitting in front of me. Once I was able to get in the right mindset for this project, that&#8217;s when all the fun began.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>As I look over the past few weeks, I am genuinely having a hard time remembering any <em>truly</em> frustrating moments. What I recall the most is just having a blast building my Twenty Twenty-Three variation and testing those that others built. I cannot wait for the theme and its curated set of styles to be unveiled to the community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Sep 2022 15:00:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Post Status: Writing is a Challenging But Needed Profession in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=114274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://poststatus.com/writing-is-a-challenging-but-needed-profession-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14334:\"<div class=\"wp-container-31 wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">The WordPress project, software, and community are equally important. They all play a role in ensuring growth, progress, and success. A sizeable economy of users, builders, and business owners depends on it. That’s why staying informed is vital. And so much of the reporting and learning opportunities come from unofficial sources. We need more people within the WordPress community who are interested in writing and more places to amplify their voices. </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">29</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n<p class=\"has-drop-cap\">Over the past decade, I’ve written about a lot of web-related subjects. I started with a focus on freelancing — mainly because that’s what I knew best. It was an area where I had experience and felt like I could be of help to others.</p>\n\n\n\n<p>However, WordPress soon became my topic of choice. The more projects I built with the content management system (CMS), the more I wanted to share. There was so much to learn and discover.</p>\n\n\n\n<blockquote><p>It’s easy to criticize someone or something from afar. For example, there’s a difference between critiquing a random stranger’s parenting style and that of your best friend. Proximity makes a difference.</p></blockquote>\n\n\n\n<p>And the software wasn’t my only inspiration. Having attended my first WordCamp in 2011, I was taken aback at how welcoming the WordPress community was. Not only could I level up my design and development skills, but I also had access to this incredible human resource.</p>\n\n\n\n<p>The experience took me from merely building websites to wanting to be a part of something bigger. The community is what made me truly care about WordPress. And I couldn’t help but want to give back.</p>\n\n\n\n<h2>The Challenges of Writing About WordPress</h2>\n\n\n\n<p>Writing about WordPress made perfect sense. I wasn’t the greatest developer — but I could share what I’ve learned. I also felt an obligation to ask questions about the direction of the software and how it impacts the community.</p>\n\n\n\n<p>Those deeper topics are often difficult to write about. Not only do they require some critical thinking (not my greatest skill), but they also need to strike a delicate balance. Because, while a post may nominally be about software, it’s people that are the real subject.</p>\n\n\n\n<p>As such, there are significant challenges in writing about WordPress and its community. What follows are some lessons and observations from my journey so far.</p>\n\n\n\n<h2 id=\"h-sometimes-you-re-close-to-your-subjects\">Sometimes You’re Close to Your Subjects</h2>\n\n\n\n<p>It’s easy to criticize someone or something from afar. For example, there’s a difference between critiquing a random stranger’s parenting style and that of your best friend. Proximity makes a difference.</p>\n\n\n\n<p>That applies to the WordPress community as well. While it’s global and we don’t all know each other personally, there are often connections. You may follow a particular person (or their employer) on social media. There’s a chance you use their product or service.</p>\n\n\n\n<p>This complicates things — especially when there’s a reason to be critical of a situation. For instance, I’ve written about product decisions that I found questionable. One was a plugin that set itself to <a href=\"https://speckyboy.com/ethical-dilemma-for-wordpress-plugin-developers/\" target=\"_blank\" rel=\"noreferrer noopener\">automatically update</a> without user consent. Another involved a plugin that <a href=\"https://speckyboy.com/wordpress-theme-plugin-license-expires/\" target=\"_blank\" rel=\"noreferrer noopener\">blocked access</a> to its settings screen after a user’s license expired.</p>\n\n\n\n<p>I use both plugins and have generally enjoyed the experience. Thus, it felt a bit awkward to discuss them publicly. Yet I also felt it was necessary to try and explore various points of view.</p>\n\n\n\n<p>In these scenarios, I hope to lay out both sides of an argument and spark a productive discussion. Not everyone’s going to agree — but that’s OK. No rule says the debate has to be comfortable.</p>\n\n\n\n<h2 id=\"h-you-have-to-fill-in-the-blanks-when-covering-wordpress-core\">You Have To Fill in the Blanks When Covering WordPress Core</h2>\n\n\n\n<p>Software is difficult to produce and maintain. And when an app is as widely-used as WordPress, the job is even tougher. There’s simply no way to please everyone.</p>\n\n\n\n<p>As users, we all have our WordPress pet peeves. In my case, the clutter of the dashboard tends to drive me crazy — especially on content-heavy websites. And the block editor still has several bumps to smooth out.</p>\n\n\n\n<p>And then there’s the overall direction of the WordPress project. It’s no secret that a lot of resources have been allocated towards the block editor and Full Site Editing. Meanwhile, this changing landscape can create unease among those who make a living with the software.</p>\n\n\n\n<p>Therefore, it’s vital to take a closer look at what’s happening. This empowers the community to prepare for change and allows their voices to be heard as things evolve.</p>\n\n\n\n<p>There are several challenges for writers who take on these topics. The biggest is that official information can be <a target=\"_blank\" href=\"https://speckyboy.com/new-wordpress-features-hard-to-find/\" rel=\"noreferrer noopener\">very difficult</a> to find. It may require searching through Slack channels or digging up a post from one of several <a target=\"_blank\" href=\"https://make.wordpress.org/\" rel=\"noreferrer noopener\">Make WordPress</a> blogs. And, even if you locate something relevant, there may still be some key information missing.</p>\n\n\n\n<p>Plus, the decision-making process isn’t always clear to those of us on the outside. A lack of context in this area can lead to speculation. That, in turn, has the potential to create distrust within the community.</p>\n\n\n\n<p>Writing about these subjects is a balancing act. You can only work with the facts you have. At the same time, it’s difficult to avoid speculating on how or why a decision was made.</p>\n\n\n\n<h2 id=\"h-discussing-project-leadership-is-tricky\">Discussing Project Leadership is Tricky</h2>\n\n\n\n<p>The structure of the WordPress project can be confusing when it comes to leadership. Matt Mullenweg is the co-founder of WordPress. He’s also heavily involved in its direction.</p>\n\n\n\n<p>In addition, he’s the founder of Automattic — a commercial entity that runs WordPress.com, among other products. The company also sponsors a significant number of WordPress contributors.</p>\n\n\n\n<p>Speaking of which, WordPress is also free and open-source. It depends on volunteers for virtually everything. Except that some contributors are paid by their employers to do so via the <a target=\"_blank\" href=\"https://wordpress.org/five-for-the-future/\" rel=\"noreferrer noopener\">Five for the Future</a> initiative. Got all of that?</p>\n\n\n\n<p>It’s a unique and seemingly complex arrangement. The result is a lot of gray area and uncertainty for even avid observers.</p>\n\n\n\n<p>While we typically know the project leads for various tasks, there are still questions about who’s doing what, and where decisions come from. Does Mullenweg have the final say over everything? Do sponsored contributors have more clout than volunteers? Where do the interests of WordPress.org and WordPress.com start to diverge?</p>\n\n\n\n<p>These are fair questions to ask. And in my experience, they’re very difficult to answer. Once again, the lack of clarity can lead to guessing games.</p>\n\n\n\n<h2 id=\"h-there-are-people-behind-the-code\">There Are People Behind the Code</h2>\n\n\n\n<p>Writers also need to take a measured approach when asking questions or leveling criticism. That’s because we’re not just talking about a product. Human beings make WordPress, and we must consider the impact of what we say.</p>\n\n\n\n<p>This is where the fuzzy details on leadership and decision-making make our job more difficult. We may hypothetically posit a question. But taken out of context, it could read as being hurtful or unfair.</p>\n\n\n\n<p>The basic rules of journalism apply — even if you’re not technically a journalist (Full disclosure: I’ve had no formal training in this area). But suffice to say that it’s best to stick to the facts. Making accusations without proof or passing along hearsay does you no favors.</p>\n\n\n\n<p>And when criticizing a feature or decision, we should include a detailed explanation. Instead of simply stating that a theme “is hard to use”, provide examples of <em>why</em> it was difficult. It’s still important to provide context — even if we don’t always get it from our subjects.</p>\n\n\n\n<p>Granted, we all make mistakes. And even the most careful writers will still face negative feedback.</p>\n\n\n\n<p>Sometimes it comes in the form of an old-fashioned internet troll. But it may also come from a place of misunderstanding. In that case, I’d encourage engaging on a personal level. An honest dialogue can produce positive results.</p>\n\n\n\n<h2 id=\"h-financial-resources-for-writers-are-scant\">Financial Resources for Writers Are Scant</h2>\n\n\n\n<p>If you want to cover the important issues and happenings in the WordPress community, it takes time and resources. For most writers in our space, these aren’t easy to come by.</p>\n\n\n\n<p>There are several online publications dedicated to the CMS and many more that provide at least some level of coverage. But news, analysis, and opinion aren’t necessarily what they’re looking for. Quick tips, tutorials, and plugin roundups get plenty of clicks and are somewhat evergreen. More importantly, they don’t run the risk of rubbing stakeholders the wrong way.</p>\n\n\n\n<p>And the few outlets that do encourage in-depth coverage tend to have very limited budgets. They aren’t full-time gigs. Writers often have to piece together roles at multiple publications. This doesn’t leave much time to dig into a topic.</p>\n\n\n\n<p>To be clear, I love having gigs at places like <a target=\"_blank\" href=\"https://speckyboy.com/react-javascript-snippets-ui-elements/\" rel=\"noreferrer noopener\">Speckyboy</a> and <a target=\"_blank\" href=\"https://thewpminute.com/\" rel=\"noreferrer noopener\">The WP Minute</a>. They’ve helped me to find my voice and feel closer to the WordPress community. But I also consider my situation to be an outlier. There don’t appear to be many opportunities for a writer who wants to take a similar path.</p>\n\n\n\n<p>Yet writing is only part of what I do. I’m still a freelance web designer and that makes up the bulk of my income. Writing is a passion and (thankfully) a way to boost my bottom line.</p>\n\n\n\n<p>Much like contributing to WordPress core, writing about the software takes some measure of passion. You do it because you love it — not for wealth and accolades.</p>\n\n\n\n<h2 id=\"h-wordpress-journalism-is-a-unique-and-important-niche\">WordPress Journalism Is a Unique and Important Niche</h2>\n\n\n\n<p>The WordPress project, software, and community are equally important. They all play a role in ensuring growth, progress, and success. A sizeable economy of users, builders, and business owners depends on it.</p>\n\n\n\n<p>That’s why staying informed is vital. And so much of the reporting and learning opportunities come from unofficial sources. These writers help us keep up with the news and teach us how to use new features. They’re a key part of the mission to democratize publishing. I’m honored to play a tiny part in it.</p>\n\n\n\n<p>Writing about WordPress isn’t always easy. There can be several obstacles — not least of which is having access to accurate information. But that hasn’t stopped the many talented bloggers and journalists out there from trying their best.</p>\n\n\n\n<p>If anything, we need more people within the community who are interested in writing and more places to amplify their voices. WordPress is in a constant state of change, and it takes a dedicated group to spread the word and ask difficult questions.</p>\n\n\n\n<p class=\"has-theme-palette-8-background-color has-background\"><strong>Want to write for Post Status?</strong> Please <a href=\"https://poststatus.com/contact/\">get in touch</a>.<br /><br />We are happy to compensate members of the WordPress community (and Post Status) who have experiences and insights to share or good questions worth exploring — about tech, business, and careers as well as the project and culture of WordPress. </p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-container-32 wp-block-group\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-image is-style-default\">\n<img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-86322\" width=\"188\" height=\"188\" /></div>\n\n\n<p class=\"has-medium-font-size\">You — and your whole team — can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a>.</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /></p>\n</div></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Sep 2022 13:52:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Eric Karkovack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Do The Woo Community: WooBits: Cultural Intelligence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72853\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://dothewoo.io/woobits-cultural-intelligence/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"<p>As part of the WordCampUS speaker series, I singled out this one because Cultural Intelligence resonated with me.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woobits-cultural-intelligence/\">WooBits: Cultural Intelligence</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Sep 2022 12:55:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Post Status: The $500 Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=114223\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://poststatus.com/the-500-website/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4610:\"<div class=\"wp-container-35 wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">A decade ago, Chris Butler\'s survey and report for Newfangled provided other agencies with the numbers that meaningfully define their market. WordPress agencies and freelancers could use something similar today. </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">29</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n<p class=\"has-drop-cap\">In 2021 WordPress.com <a href=\"https://poststatus.com/will-automattics-built-by-wordpress-compete-with-wordpress-freelancers/\">announced</a> a premium $4,900 website building service — builtbywp.com. It\'s still active but the <a href=\"https://builtbywp.com/#faq\">FAQ</a> says, &#8220;Our website design & development services start at $3,500 USD.&#8221;</p>\n\n\n\n<p>Now there\'s Built by WordPress.com <a href=\"https://wordpress.com/blog/2022/08/30/need-a-website-fast-let-us-do-it-for-you/\">Express</a> — where &#8220;in-house experts will build the site for you, all in four business days or less. The cost is $499, plus an additional purchase of the WordPress.com Premium plan.&#8221;</p>\n\n\n\n<p>There\'s no way not to see this <a href=\"https://wordpress.com/do-it-for-me/\">Do it for Me</a> service as competing with freelancers on the low end of the market, which <strong><a href=\"https://poststatus.com/will-automattics-built-by-wordpress-compete-with-wordpress-freelancers/\">Matt Mullenweg</a></strong> previously <a href=\"https://poststatus.com/will-automattics-built-by-wordpress-compete-with-wordpress-freelancers/\">claimed</a> was not the intention of the premium site building service last year. </p>\n\n\n\n<p>He also estimated that <strong>Automattic</strong> captures less than 5% of the revenue in the total WordPress ecosystem — much less than other large hosts. At the time, <strong>David Bisset</strong> writing for Post Status, asked for more transparency about &#8220;how many customers have been acquired and new sites built on WordPress.com.&#8221;</p>\n\n\n\n<p>The WordPress market share has always been highest and expanded the most in the broadest market — the top million active websites as measured by traffic. WordPress currently has around a 36% market share by that measure, but it falls to 14% in the top 10,000 most active sites. While sites with no (identifiable) CMS are still the largest and probably easiest area for growth, it\'s logical for WordPress.com to focus on the lower end of the market rather than leave it to other hosting companies. </p>\n\n\n\n<p>Inevitably, freelancers are going to feel the squeeze as commodified websites and website building services compete downward on price. The wisdom usually offered about this is sound: learn the price points where you can be most competitive and trade on unique value you can bring to clients. </p>\n\n\n\n<p>A geographically localized focus, an affinity-based or purpose-built niche of features, and personal referral networks are unique strengths. There are also plenty of important, high-budget clients whose websites never need or intend to serve millions of visitors. Built your own local or niche market analysis — current market share data for WordPress doesn\'t tell you much. </p>\n\n\n\n<p>A decade ago, <strong>Chris Butler</strong>&#8216;s <a href=\"https://www.newfangled.com/report-the-state-of-digital-marketing-for-small-a/\">survey and report</a> at <strong>Newfangled</strong> for other small agencies was really helpful in <a href=\"https://www.newfangled.com/the-results-of-newfangleds-state-of-digital-marketing-for-small-agencies-survey/\">getting the numbers that matter</a>. (I believe this survey was done more than once but not sustained over the years since then.) We could use something similar for WordPress agencies and freelancers. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://poststatus.com/will-automattics-built-by-wordpress-compete-with-wordpress-freelancers/\">Will Automattic compete with WordPress freelancers?</a></blockquote>\n</div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Sep 2022 15:13:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Do The Woo Community: Builder Tips from WordCampUS Speakers Part_2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72844\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://dothewoo.io/builder-tips-from-wordcampus-speakers-part_2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:433:\"<p>Listen in to these WooCommerce / WordPress builder tips from Ben Meredith, Christina Deemer, George Woodard, Nick Diego, Milana Cap and Micah Wood.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/builder-tips-from-wordcampus-speakers-part_2/\">Builder Tips from WordCampUS Speakers Part_2</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Sep 2022 09:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Post Status: WOOF for WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=114160\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://poststatus.com/woof/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:766:\"<p><a href=\"https://hiwooff.com/\"><strong>WOOF</strong></a> is a new directory for <strong>WooCommerce</strong> extensions. Their goal is to become the “yellow pages” for your WooCommerce add-on needs. Check out <a href=\"https://hiwooff.com/guidelines/\">the guidelines</a> for joining. </p>\n\n\n\n<p>Announced today by <strong>Dave Loodts</strong>, Dave <a href=\"https://poststatus.slack.com/archives/C02707KA3B8/p1661963824016359?thread_ts=1661957117.062089&cid=C02707KA3B8\">clarified in <strong>Post Status Slack</strong></a> that the WOOF directory is open to WordPress plugins too if they have Woo modules. Look for more clarification about that down the line. </p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 22:19:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Post Status: WordPress 6.0.2 Security and Maintenance Release: WordPress.org’s Bug Bounty Program at Work\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=114149\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://poststatus.com/wordfence-on-the-wordpress-6-0-2-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1758:\"<p><strong>Ram Dall</strong> over at <strong>Wordfence</strong> has <a href=\"https://www.wordfence.com/blog/2022/08/wordpress-core-6-0-2-security-maintenance-release-what-you-need-to-know/\">a good breakdown</a> of three vulnerabilities patched in <a href=\"https://wordpress.org/news/2022/08/wordpress-6-0-2-security-and-maintenance-release/\" target=\"_blank\" rel=\"noreferrer noopener\">the WordPress 6.0.2 Security and Maintenance Release</a>. One is a high severity SQLi vulnerability in the links functionality, and the other two are medium severity Cross-Site Scripting vulnerabilities.</p>\n\n\n\n<p>Ram notes:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Most actively used WordPress sites should be patched via automatic updates within the next 24 hours, and any sites that remain vulnerable would only be exploitable under very specific circumstances.</p></blockquote>\n\n\n\n<p><strong>Robert Rowley</strong> dug deeper for <strong>Patchstack</strong>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>There are also no proof of concepts (or exploitation steps) nor any reports of these bugs actively targeted in the wild. This is because the security bugs were reported and handled through <a href=\"https://hackerone.com/wordpress\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress.org\'s official Bug Bounty program</a> … as well as one WordPress security team member, <a href=\"https://profiles.wordpress.org/johnbillion/\" target=\"_blank\" rel=\"noreferrer noopener\">John Blackbourn</a> who at this time is sponsored by <a href=\"https://wordpress.org/five-for-the-future/pledge/human-made/\" target=\"_blank\" rel=\"noreferrer noopener\">Human Made</a>.</p></blockquote>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 22:04:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WordPress.org blog: People of WordPress: Bud Kraus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13385\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2022/08/people-of-wordpress-bud-kraus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12123:\"<p><strong>This month, as we approach <a href=\"https://us.wordcamp.org/2022/\">WordCamp US</a>, we feature Bud Kraus, a WordPress trainer who has made a career in helping others learn about software. He also shares how he has developed an approach to using technology in order to overcome longstanding difficulties with his eyesight.</strong></p>\n\n\n\n<p><strong>In this People of WordPress series, we share some of the inspiring stories of how WordPress and its global network of contributors can change people’s lives for the better.</strong></p>\n\n\n\n<img width=\"1014\" height=\"627\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/08/bud-kraus-aug-powp.jpg?resize=1014%2C627&ssl=1\" alt=\"Bud Kraus playing the guitar\" class=\"wp-image-13341\" /><em>Bud Kraus</em> with his guitar\n\n\n\n<h2>Teaching WordPress strengthens your understanding</h2>\n\n\n\n<p>Bud has taught web design since 1998, with students from more than 80 countries online or in person. He was determined not to let his sight difficulties stop him from his wish to  help others learn website building and maintenance skills.   </p>\n\n\n\n<p>As WordPress evolves and new features release, Bud decided to extend his training services around helping new and existing users improve and practice their skills. He supports others in open source through volunteering to speak at WordPress events, and encourages others to do so too. He also gives time to help produce material for the free-to-access resource <a href=\"https://learn.wordpress.org/\">Learn WordPress,</a> which is part of the WordPress.org project.&nbsp;</p>\n\n\n\n<p>As a contributor to the <a href=\"https://make.wordpress.org/test/\">Test</a> and <a href=\"https://make.wordpress.org/training/\">Training</a> teams, Bud is keen for others to try contributing to these areas and help support the project&#8217;s future development. One of his current training priorities is to help people with using the block editor and Full Site Editing. He is an advocate for the usability of WordPress today, saying: “I can design all aspects of a website now with a block.”</p>\n\n\n\n<h2>Using WordPress as a traditional developer</h2>\n\n\n\n<p>Bud’s WordPress journey began with a lunch at Grand Central Station in New York in 2009. A friend and former client was promoting the idea of using WordPress, which Bud initially resisted.</p>\n\n\n\n<p>“I’m a code guy…,” he told his friend at the time. “I will never use anything like that.”</p>\n\n\n\n<p>However, the friend persisted. Eventually, Bud gave it a try and found a new approach with things called themes and plugins. His first encounter was with <a href=\"https://wordpress.org/download/releases/\">WordPress 2.6</a>. Bud signed up with a hosting company and found a theme where he could learn to edit and understand child themes.</p>\n\n\n\n<p>He said: &#8220;Once I saw that you could edit anything and make it yours, I was hooked. The endorphins were freely coursing through my veins.&#8221; Bud was hooked.</p>\n\n\n\n<h2>Teaching WordPress strengthens your own understanding of the software</h2>\n\n\n\n<p>There’s an old saying that the best way to learn something new is to turn around and teach someone else.</p>\n\n\n\n<p>Bud was already an instructor at the Fashion Institute of Technology when he thought, “I could teach WordPress!”</p>\n\n\n\n<p>And so he did, packing classrooms all through those first years of WordPress as it swept through the design world and further.<br /><br />But Bud had more to discover. He said: &#8220;Two big things were about to happen that were really going to change my life. They would show me the way to the WordPress community – not that I even knew what that was.&#8221;</p>\n\n\n\n<h2>Sharing lessons learnt with the WordPress community</h2>\n\n\n\n<p>In 2014, one of his students suggested he start going to the New York WordPress Meetup.&nbsp;</p>\n\n\n\n<p>As he started going to WordCamps in New York City, he realized that WordPress was getting very large. What’s more, it had a community of people with whom he felt at home and could learn alongside.</p>\n\n\n\n<p>Bud gave a talk for the first time in 2016 at the only WordCamp to this day that has been held at the United Nations. He shared his knowledge of “Lessons Learned: Considerations For Teaching Your Clients WordPress.”&nbsp;</p>\n\n\n\n<img width=\"952\" height=\"1024\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/08/bud-kraus-1.jpg?resize=952%2C1024&ssl=1\" alt=\"Bud Kraus talking at a WordCamp\" class=\"wp-image-13340\" /><em>Bud Kraus speaks at WordCamps to help people use the software even more effectively</em>\n\n\n\n<p>From there, Bud went on to speak at other WordCamps in the US. He also volunteered as a speaker wrangler for his home camp in New York City in 2018 and 2019.</p>\n\n\n\n<h2>From speaking to writing about WordPress</h2>\n\n\n\n<p>At some point before the Covid-19 lockdown, Bud found another outlet, this time in writing.&nbsp;</p>\n\n\n\n<p>Bud heard a magazine was advertising for submissions related to WordPress.&nbsp;His first attempted article did not make the cut.</p>\n\n\n\n<p>So in his second submission, Bud took the risk of writing about something deeply personal – a topic he really didn’t want to write about at all.</p>\n\n\n\n<p>He gathered his courage and revealed to the entire web design world that he was legally blind.</p>\n\n\n\n<p>The article appeared as&nbsp; <strong>“</strong><a href=\"https://www.smashingmagazine.com/2018/05/using-low-vision-teach-wordpress/\"><strong>Using Low Vision As My Tool To Help Me Teach WordPress</strong></a><strong>”.</strong></p>\n\n\n\n<img width=\"510\" height=\"600\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/bud-kraus-2.jpg?resize=510%2C600&ssl=1\" alt=\"Bud Kraus\" class=\"wp-image-13426\" />Bud Kraus\n\n\n\n<p>Since the age of 37, Bud has had macular degeneration in both eyes, which affects his central vision. It is a leading cause of legal blindness in the United States and many other countries.&nbsp;</p>\n\n\n\n<p>He relies on his peripheral vision and finding ways to compensate. He also tends to see things in a flat dimension and has a difficulty discerning contrast&nbsp; &#8211; he&nbsp; is glad there are starting to be improvements in color contrasts in web design!<br /><br />He uses tools like Speech to Text, larger sized cursors and bigger font sizes, and heavily uses zooming back in and out when working with WordPress. He is able to recognize patterns but has to rely on detailed preparation and memorizing materials.&nbsp;</p>\n\n\n\n<p>In his first magazine article acknowledging this situation, he shared the added difficulties that technology creates for people with visual conditions, and tips that he had found to try and find alternative routes around them. He uses the technique of finding alternatives in his training work to help people learn and understand, realizing that all people have different ways of reading and understanding. His words and subsequent stories have inspired others and enabled more people to highlight accessibility. He describes himself as a ‘stakeholder in ensuring that the WordPress admin is accessible.’</p>\n\n\n\n<p>A year after its first publication, the piece became a WordCamp talk, ‘My Way with WordPress.’ The talk was a hit and started many conversations about accessibility and the importance of raising awareness.</p>\n\n\n\n<p>A few months later, he gave a Gutenberg talk at the first WordCamp Montclair. There was no way he could have done it from a laptop, so instead, he did it from his 27” desktop computer. </p>\n\n\n\n<p>Bud said: &#8220;It was a presentation on Gutenberg plugins. Since I couldn’t do this from a notebook screen (the screen is too small and the keyboard is hard for me to manipulate), it was decided that I would bring in my 27″ desktop machine to a WordCamp. I’m probably the first person to ever have done this. It was good thing I only lived a few miles away.&#8221;</p>\n\n\n\n<p>He added: “I sat behind my computer, did my thing, and every once in a while peered out to make sure people were still there.”</p>\n\n\n\n<h2>Different ways of contributing to WordPress</h2>\n\n\n\n<p>One of the main ways Bud supported the community around the software was through talks at WordCamps and helping others to speak. </p>\n\n\n\n<p>During the Covid-19 pandemic, he was keen to continue contributing when WordCamps were no longer meeting in person. He turned greater attention to supporting the <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> resource, a free to use learning platform made by and for the community itself.&nbsp;</p>\n\n\n\n<p>More training materials on the block editor can be found on Learn WordPress and his WordCamp talks are available on <a href=\"https://wordpress.tv/?s=kraus&speakers=bud-kraus\">WordPress.tv</a>.</p>\n\n\n\n<h2>Global reach and meaning through WordPress</h2>\n\n\n\n<img width=\"600\" height=\"800\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/08/bud-kraus-with-josepha.jpg?resize=600%2C800&ssl=1\" alt=\"Bud Kraus with Josepha\" class=\"wp-image-13342\" /><em>Bud Kraus with Josepha Haden Chomphosy at WordCamp Montclair, NJ 2022</em>\n\n\n\n<p>Bud’s training materials and willingness to talk about accessibility have helped so many people find their way with WordPress. He in turn is an advocate for the community around open source.</p>\n\n\n\n<p>He said: “The software is really good, and the people are even better.” &nbsp;</p>\n\n\n\n<p>He added: “I get a sense of accomplishment whenever I launch a new or redesigned site. It’s also given me a great feeling to know that many people have learned WordPress around the world from my <a href=\"https://wordpress.tv/?s=kraus&speakers=bud-kraus\">talks and presentations</a>. This might just be the most gratifying thing of all.”</p>\n\n\n\n<h2>Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to Abha Thakor (<a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>), Mary Baum (<a href=\"https://profiles.wordpress.org/marybaum/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>marybaum</a>), Surendra Thakor (<a href=\"https://profiles.wordpress.org/sthakor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sthakor</a>), Meher Bala (<a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>), Larissa Murillo (<a href=\"https://profiles.wordpress.org/lmurillom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lmurillom</a>), and Chloe Bringmann (<a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>), for work on this feature. Thank you too to Bud Kraus (<a href=\"https://profiles.wordpress.org/trynet/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>trynet</a>) for sharing his experiences.</p>\n\n\n\n<p>Thank you to Josepha Haden (<a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a>) and Topher DeRosia (<a href=\"https://profiles.wordpress.org/topher1kenobe/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>topher1kenobe</a>) for their support of the <em>People of WordPress</em> series.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\"><img width=\"180\" height=\"135\" src=\"https://i1.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" /><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 21:30:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Post Status: WordPress 6.0.2, Advanced Admin Handbook, Accessibility Tags for Block Themes, and Improving the Template Creation Experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=114004\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"https://poststatus.com/wordpress-6-0-2-advanced-admin-handbook-accessibility-tags-for-block-themes-and-improving-the-template-creation-experience/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14589:\"<h2 id=\"h-this-week-at-wordpress-org-august-29-2022\">This Week at WordPress.org (August 29, 2022)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">WordPress 6.0.2, Advanced Admin Handbook, Accessibility Tags for Block Themes, and Improving the Template Creation Experience </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div id=\"kt-info-box_b3b811-01\" class=\"wp-block-kadence-infobox\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kt-info-svg-icon kt-info-svg-icon-fe_arrowUpCircle\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\"><a href=\"https://make.wordpress.org/core/2022/08/10/proposal-stop-merging-experimental-apis-from-gutenberg-to-wordpress-core/\">Updates</a></h2><p class=\"kt-blocks-info-box-text\">Time to update! WordPress has an update available, but additionally these areas of the project are ready to be updated as well.  <br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f6e0.png\" alt=\"🛠\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2022/08/wordpress-6-0-2-security-and-maintenance-release/\">WordPress 6.0.2 Security and Maintenance Release</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4da.png\" alt=\"📚\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/docs/2022/08/30/summary-of-docs-team-biweekly-meeting-august-30-2022/#:~:text=Tracker/issues/225-,Advanced,-Admin\">WordPress Advanced Administration Handbook</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f9be.png\" alt=\"🦾\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/accessibility/2022/08/29/use-of-accessibility-ready-tag-for-block-based-themes/\">Use of accessibility-ready tag for block-based themes</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3d7.png\" alt=\"🏗\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/08/25/core-editor-improvement-refining-the-template-creation-experience/\">Core Editor Improvement: Refining the template creation experience</a><br />><br /></a><br /><br />><br /></a><br /><br /></p></div></div></div>\n\n\n\n<h2 id=\"h-news\">News</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/news/2022/08/wordpress-6-0-2-security-and-maintenance-release/\">WordPress 6.0.2 Security and Maintenance Release</a></li><li><a href=\"https://wordpress.org/news/2022/08/people-of-wordpress-bud-kraus/\">People of WordPress: Bud Kraus</a></li><li><a href=\"https://make.wordpress.org/meta/2022/09/01/simplifying-the-admin-bar-global-navigation-menu/\">Simplifying the Admin Bar & Global Navigation Menu</a></li></ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_598f7a-1a\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"wp-container-33 wp-block-columns\">\n<div class=\"wp-container-31 wp-block-column\">\n<h2 id=\"h-accessibility\"><a href=\"https://make.wordpress.org/accessibility\">Accessibility</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/accessibility/2022/08/29/use-of-accessibility-ready-tag-for-block-based-themes/\">Use of accessibility-ready tag for block-based themes</a></li></ul>\n\n\n\n<h2 id=\"h-community\">Community</h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/community/2022/08/31/wordpress-events-organiser-training/\">WordPress Events Organiser Training</a></li><li><a href=\"https://make.wordpress.org/community/2022/08/15/call-for-ideas-wordcamp-us-2022-contributor-day/\">Call for Ideas: WordCamp US 2022 Contributor Day</a></li><li><a href=\"https://us.wordcamp.org/2022/what-is-contributor-day/\">What is Contributor Day?</a></li></ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/\">What’s new in Gutenberg 14.0? (31 August)</a></li><li><a href=\"https://make.wordpress.org/core/2022/09/01/a-week-in-core-august-29-2022/\">A Week in Core – August 29, 2022</a></li><li><a href=\"https://make.wordpress.org/core/2022/08/25/core-editor-improvement-refining-the-template-creation-experience/\">Core Editor Improvement: Refining the template creation experience</a></li></ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/08/31/editor-chat-summary-10-august-2022-2-2-2/\">Editor chat summary: 31 August, 2022</a></li><li><a href=\"https://make.wordpress.org/core/2022/08/31/agenda-dev-chat-august-31-2022/\">Agenda, Dev Chat, August 31, 2022</a></li><li><a href=\"https://make.wordpress.org/core/2022/08/31/summary-dev-chat-august-24-2022/\">Summary, Dev Chat, August 24, 2022</a></li></ul>\n\n\n\n<h2 id=\"h-design\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/design/2022/08/29/design-share-aug-15-26/\">Design Share: Aug 15-26</a></li></ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/docs/2022/08/30/summary-of-docs-team-biweekly-meeting-august-30-2022/\">Summary of Docs Team Biweekly Meeting August 30, 2022</a></li><li><a href=\"https://make.wordpress.org/docs/2022/08/30/summary-of-docs-team-biweekly-meeting-august-30-2022/#:~:text=Tracker/issues/225-,Advanced,-Admin\">WordPress Advanced Administration Handbook</a></li></ul>\n\n\n\n<h2><a href=\"https://wordpress.org/five-for-the-future/\">Five for the Future</a></h2>\n\n\n\n<ul><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/214\">Deactivate inactive pledges</a></li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/212\">Remove contributor hours when account banned</a>&nbsp;</li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/210\">Use last 5ftF contribution as inactivity criteria</a></li><li><a href=\"https://github.com/WordPress/five-for-the-future/issues/208\">Hyperlink not readable on Program Expectations page</a></li></ul>\n\n\n\n<h2 id=\"h-hosting\">Hosting</h2>\n\n\n\n<ul><li><strong>PROPOSAL:</strong> <a href=\"https://make.wordpress.org/hosting/2022/08/18/proposal-updating-wp_memory_limit/\">Updating WP_MEMORY_LIMIT</a></li><li><a href=\"https://make.wordpress.org/hosting/2022/08/31/hosting-team-meeting-agenda-2022-08-31/\">Hosting Team meeting agenda 2022-08-31</a></li></ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/marketing/2022/08/31/notes-global-marketing-team-meeting-august-24-2022/\">Notes: Global Marketing Team Meeting, August 24, 2022</a></li><li><a href=\"https://make.wordpress.org/marketing/2022/08/30/agenda-marketing-meeting-august-31-2022/\">Agenda, Marketing meeting, August 31, 2022</a></li></ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/meta/2022/08/18/navigation/\">Navigation</a></li></ul>\n</div>\n\n\n\n<div class=\"wp-container-32 wp-block-column\">\n<h2 id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/openverse/2022/08/30/openverse-remote-contributor-day-at-wordcamp-us-2022/\">Openverse Remote Contributor Day at WordCamp US 2022</a></li></ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul><li>Proposal: <a href=\"https://github.com/WordPress/performance/issues/455\">Database performance Health Checks</a></li></ul>\n\n\n\n<h2 id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/updates/2022/08/29/plugin-review-team-29-aug-2022/\">Plugin Review Team: 29 Aug 2022</a></li></ul>\n\n\n\n<h2 id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/polyglots/2022/08/22/polyglots-monthly-newsletter-august-2022/\">Polyglots Monthly Newsletter: August 2022</a></li></ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/test/2022/08/13/fse-program-testing-call-16-back-to-basics/\">FSE Program Testing Call #16: Back to Basics</a></li><li><a href=\"https://make.wordpress.org/test/2022/08/16/week-in-test-16-august-2022/\">Week in Test: 16 August 2022</a></li></ul>\n\n\n\n<h2 id=\"h-themes\"><a href=\"https://make.wordpress.org/themes\">Themes</a></h2>\n\n\n\n<ul><li><strong>FEEDBACK REQUESTED:</strong> <a href=\"https://make.wordpress.org/themes/2022/08/15/testing-and-feedback-for-the-fluid-typography-feature/\">Testing and Feedback for the Fluid Typography Feature</a></li><li><a href=\"https://make.wordpress.org/updates/2022/08/16/themes-team-update-august-16-2022/\"></a><a href=\"https://make.wordpress.org/themes/2022/08/23/themes-team-meeting-notes-august-23-2022/\">Themes Team Meeting Notes –&nbsp;August 23, 2022</a></li><li><a href=\"https://make.wordpress.org/updates/2022/08/30/test-team-update-30-august-2022/\">Test Team Update: 30 August 2022</a></li></ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/updates/2022/09/01/whats-new-on-learnwp-august-2022/\">What’s new on LearnWP – August 2022</a></li><li><a href=\"https://make.wordpress.org/training/2022/07/27/information-sources-for-wp-6-1/\">Information Sources for WP 6.1</a></li><li><a href=\"https://make.wordpress.org/training/2022/08/31/august-24th-30th-supplemental-sme-meeting-recap/\">August 24th / 30th Supplemental SME Meeting Recap</a></li><li><a href=\"https://make.wordpress.org/training/2022/08/29/august-2022-monthly-faculty-meeting/\">August 2022 Monthly Faculty Meeting</a></li><li><a href=\"https://make.wordpress.org/training/2022/08/29/meeting-agenda-for-august-30-2022/\">Meeting Agenda for August 30, 2022</a></li><li><a href=\"https://make.wordpress.org/training/2022/08/29/training-team-meeting-recap-august-23/\">Training Team Meeting Recap –&nbsp;August 23</a></li><li><a href=\"https://make.wordpress.org/training/2022/08/27/documenting-the-successful-launch-of-japanese-online-workshops/\">Documenting the Successful Launch of Japanese Online Workshops</a></li></ul>\n\n\n\n<h3 id=\"h-video-tutorials\">Video Tutorials</h3>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/tutorial/creating-a-new-header-with-blocks/\">Creating a new header with blocks</a></li></ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops:</h3>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/?meeting=what-is-the-domain-name-system-2\">What is the Domain Name System?</a></li><li><a href=\"https://learn.wordpress.org/?meeting=introducing-domains-2\">Introducing… Domains!</a></li><li><a href=\"https://learn.wordpress.org/?meeting=showcasing-content-with-query-loops-4\">Showcasing Content with Query Loops</a></li><li><a href=\"https://learn.wordpress.org/?meeting=the-beginners-guide-to-full-site-editing\">The Beginner’s Guide to Full Site Editing</a></li><li><a href=\"https://learn.wordpress.org/?meeting=a-personal-site-in-1-2-3-with-patterns\">A Personal Site in 1, 2, 3 with Patterns</a><a href=\"https://github.com/courtneyr-dev/make-wp/#test\"></a></li></ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li></ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul><li><a href=\"https://thephp.foundation/blog/2022/08/30/php-core-roundup-5/\">PHP Core Roundup #5</a></li><li><a href=\"https://tc39.es/#proposals\">ECMAScript Proposals</a></li></ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/business-membership/\">your whole team</a> can <a href=\"https://poststatus.com/post-status-membership-club/\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 16:16:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Post Status: New pricing model at Business Bloomer aims at Purchasing Power Parity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=113971\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://poststatus.com/new-pricing-model-at-business-bloomer-aims-at-purchasing-power-parity/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1268:\"<p><strong>Rodolfo Melogli</strong> has changed the pricing structure at bto be more affordable to people around the globe. He\'s done this by calculating &#8220;Purchasing Power Parity.&#8221;</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><a href=\"https://en.wikipedia.org/wiki/Purchasing_power_parity\">Purchasing Power Parity (PPP)</a> is a metric that can be used to determine the actual “purchasing power” of a given country. A basket of goods purchased in the USA with USD is compared to the price of that same basket in a given country, in that country’s local currency. This ratio is never identical to the actual local currency exchange rate against USD. In fact, in some countries it’s much lower, which means that those goods can only be purchased using less USD than would be required in the USA.</p><p>Based on this metric, the PPP value helps with redefining prices. To better illustrate this, based on PPP data from the last 5 years, those in India may receive discounts of up to 75% on Business Bloomer WooCommerce online courses, those in South Africa may receive a 59% discount, Norway students may receive no discount, and so on. </p></blockquote>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 14:51:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: #41 – Laura Nelson on How To Create a Profitable Newsletter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=137279\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/podcast/41-laura-nelson-on-how-to-create-a-profitable-newsletter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:42472:\"<p>On the podcast today, we have <a href=\"https://profiles.wordpress.org/laurora/\">Laura Nelson</a>.</p>\n\n\n\n<p>Laura is a Content Marketer at WooCommerce where she’s responsible for creating and planning engaging content for their users.</p>\n\n\n\n<p>Prior to WooCommerce she worked at <a href=\"https://www.mailpoet.com/\">MailPoet</a>, an email marketing plugin for WordPress, and before that, she worked at Pragmatic, a UK based WordPress agency.</p>\n\n\n\n<p>She’s on the show to share her experience about how you can, and why you might want to, set up a paid email newsletter.</p>\n\n\n\n<p>When I hear the word newsletter, I’m typically thinking of the information which drops into your inbox on a regular basis. We’ve all surrendered our email addresses in return for some product or service. We agree to receive emails on the understanding that we can unsubscribe at some point. Perhaps a few of these emails really resonate with you, but it’s likely that you&#8217;ve unsubscribed from many as the content is no longer wanted.</p>\n\n\n\n<p>This kind of email marketing is not always viewed favourably, and is not the kind of technique that Laura is on podcast to talk about.</p>\n\n\n\n<p>Her pitch is that email newsletters can themselves be a product. That people will pay to receive your emails, and she’s got data and examples to back it up.</p>\n\n\n\n<p>I suppose that the closest analogy would be people who create an online course. You have an area of expertise; you do the hard work of creating the course and people will pay for a membership to have the benefit of learning from your expertise.</p>\n\n\n\n<p>Laura is describing something similar to that. The only difference being that instead of a course, people will pay to receive your emails, knowing that you’re going to bring value to them regularly.</p>\n\n\n\n<p>I know that this can be done, because, as you will hear, I’m a subscriber of some of the emails which Laura mentions.</p>\n\n\n\n<p>This is not a get rich quick scheme. It’s hard work and you’ve got to cultivate your audience and give them something of value, repeatedly.</p>\n\n\n\n<p>Typically, when we record the podcast, there’s not a lot of background noise, but that’s not always the case with these WordCamp Europe interviews. We were competing against crowds and the air-conditioning. Whilst the podcasts are more than listenable, I hope ‌you understand that the vagaries of the real world were at play.</p>\n\n\n\n<h2>Useful links.</h2>\n\n\n\n<p><a href=\"https://jacksflightclub.com/\">Jack&#8217;s Flight Club</a></p>\n\n\n\n<p><a href=\"https://www.densediscovery.com/\">Dense Discovery</a></p>\n\n\n\n<p><a href=\"https://www.dailycodingproblem.com/\">Daily Coding Problem</a></p>\n\n\n\n<p><a href=\"https://www.litmus.com/email-testing/\">Litmus Email Testing</a></p>\n\n\n\n<p><a href=\"https://www.emailonacid.com/\">Email on Acid</a></p>\n\n\n\nTranscript<div>\n<p>[00:00:00] Nathan Wrigley: Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case how WordPress can be the backbone of a profitable newsletter.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to share on the podcast, I&#8217;m keen to hear from you and hopefully get you all your idea featured on the show. Head over to WPTavern.com forward slash contact forward slash jukebox, and use the contact form there.</p>\n\n\n\n<p>So on the podcast today, we have Laura Nelson.</p>\n\n\n\n<p>Laura is a content marketer at WooCommerce, where she&#8217;s responsible for creating and planning engaging content for their users. Prior to WooCommerce she worked at MailPoet, an email marketing plugin for WordPress, and before that she worked at Pragmatic, a UK based WordPress agency.</p>\n\n\n\n<p>She&#8217;s on the show to explore her experience of how you can, and while you might want to set up a paid email newsletter.</p>\n\n\n\n<p>When I hear the word newsletter, I&#8217;m typically thinking about the information which drops into your inbox on a daily basis. We&#8217;ve all surrendered our email addresses in return for some product or service. We agree to receive emails on the understanding that we can unsubscribe at some point.</p>\n\n\n\n<p>Perhaps a few of these emails really resonate with you, but it&#8217;s likely that you unsubscribed from many as the content was no longer wanted. This kind of email marketing is not always viewed favorably, and it&#8217;s not the kind of technique that Laura is talking about on the podcast today. Her pitch is that email newsletters can themselves be a product? That people will pay to receive your emails, and she&#8217;s got data and examples to back it up.</p>\n\n\n\n<p>I suppose that the closest analogy would be people who create an online course. You have an area of expertise. You do the hard work of creating the course and people will pay for a membership to have the benefit of learning from your expertise.</p>\n\n\n\n<p>Laura is describing something similar to that. The only difference being that instead of a course, people will pay to receive your emails, knowing that you&#8217;re going to bring value to them regularly. I know that this can be done because as you will hear, I&#8217;m a ,subscriber to some of the emails which Laura mentioned.</p>\n\n\n\n<p>This is not a get rich quick scheme. It&#8217;s hard work and you&#8217;ve got to cultivate your audience and give them something of value, repeatedly.</p>\n\n\n\n<p>Typically when we record the podcast, there&#8217;s not a lot of background noise, but that&#8217;s not always the case with these WordCamp Europe interviews. We were competing against crowds and the air conditioning. And whilst the podcasts are more than listenable, I hope that you understand that the vagaries of the real world were a play.</p>\n\n\n\n<p>One last thing to mention is that I&#8217;ll be attending WordCamp US next week. And as a result there won&#8217;t be a podcast episode. If you&#8217;re going to be there. I do hope that our paths cross.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more about the podcast, you can find all the links in the show notes by heading to WPTavern.com forward slash podcast. And you&#8217;ll find all the other episodes of there as well.</p>\n\n\n\n<p>And so without further delay, I bring you Laura Nelson.</p>\n\n\n\n<p>I am joined on the podcast by Laura Nelson. Hello.</p>\n\n\n\n<p>[00:04:19] Laura Nelson: Hello.</p>\n\n\n\n<p>[00:04:20] Nathan Wrigley: Laura did a talk yesterday?</p>\n\n\n\n<p>[00:04:23] Laura Nelson: Yesterday afternoon. Yep. So I&#8217;m feeling pretty good today.</p>\n\n\n\n<p>[00:04:27] Nathan Wrigley: You&#8217;re feeling happy. Yeah, she did a talk at WordCamp Europe, 2022. What was it entitled? What was it about?</p>\n\n\n\n<p>[00:04:32] Laura Nelson: It was how to create a paid newsletter subscription in WordPress.</p>\n\n\n\n<p>[00:04:35] Nathan Wrigley: Okay, and did it go well?</p>\n\n\n\n<p>[00:04:38] Laura Nelson: I think so.</p>\n\n\n\n<p>[00:04:39] Nathan Wrigley: So we&#8217;re gonna be talking today about newsletters. Obviously newsletters, they do seem to be all the rage.</p>\n\n\n\n<p>[00:04:45] Laura Nelson: Yeah, every so often you hear like, email is dead, it&#8217;s all about TikTok and in fairness it is all about TikTok at the moment. But email marketing is amazing way to speak to your customers or your audience.</p>\n\n\n\n<p>[00:04:57] Nathan Wrigley: Does the data back that up then? Reliably over the last 20 years, we can say email still works?</p>\n\n\n\n<p>[00:05:02] Laura Nelson: Yeah, yeah. And conversion rates are far higher from email marketing than they are from like, if you tweet about your product or your services. Email marketing is golden in terms of conversion rates.</p>\n\n\n\n<p>[00:05:13] Nathan Wrigley: That&#8217;s interesting. Just the interface is a little bit more, how to describe it? TikTok&#8217;s a bit more ephemeral. There&#8217;s a lot going on, and there&#8217;s a lot making you wish to scroll past all of the things. I think it&#8217;s the only thing that&#8217;s been with me for 20 years.</p>\n\n\n\n<p>[00:05:26] Laura Nelson: Exactly. People are familiar with it. They know how it works, they know what to expect from an email. I think you&#8217;re capturing people at a good time, because generally they&#8217;re not gonna open their emails unless they have time to read your email. Whereas if you are like on Twitter and you&#8217;re like idly scrolling or you&#8217;ve got like two minutes, it forces them to stop, but they might not have time to take that information in. So email, it&#8217;s nice. It sits there. If you don&#8217;t have time to read it properly when you first open it, you can come back to it.</p>\n\n\n\n<p>[00:05:53] Nathan Wrigley: Yeah, that&#8217;s a good point. I was just thinking about that. And if I don&#8217;t log into Twitter for a few days, there&#8217;s almost no chance that I&#8217;m gonna see the things from three days ago, because I&#8217;m gonna start at the top. Yeah, that&#8217;s a really good point.</p>\n\n\n\n<p>So, when you&#8217;re talking about newsletters, presumably we&#8217;re talking about a piece where people have subscribed to a newsletter, and you are then offering content to them. Is that basically the model?</p>\n\n\n\n<p>[00:06:16] Laura Nelson: That&#8217;s right, yeah.</p>\n\n\n\n<p>[00:06:17] Nathan Wrigley: Okay, and you are talking about getting paid and generating revenue, and it almost sounds like it&#8217;s too good to be true. You throw together a newsletter and suddenly, you become incredibly wealthy. Of course that&#8217;s not the case. There&#8217;s probably a lot of hard work. There&#8217;s probably a lot of expertise required. Is that true?</p>\n\n\n\n<p>[00:06:33] Laura Nelson: Yes. I&#8217;d say the hardest part of this is building your list. So if you don&#8217;t already have people in your community or your audience available, you probably have to put a bit more effort into marketing. But in terms of expertise, you can write a newsletter about anything you want.</p>\n\n\n\n<p>The example I gave in my talk yesterday was a newsletter about cats, and that&#8217;s an interest. I&#8217;m not an expert on cats, I just think cats are cute. And so, you can use them in whatever ways you want. I definitely don&#8217;t think you have to be an expert in a specific subject. If you are good at writing, or if you have interesting or unusual opinions about things, you can easily make an email newsletter.</p>\n\n\n\n<p>[00:07:11] Nathan Wrigley: Before we pressed record, we talked about the fact that there is a rival platform, which I think by now probably most people have heard of. It&#8217;s called Substack. And you likened what you were describing in the talk and probably what we&#8217;re gonna be talking about as a, kind of an alternative to that.</p>\n\n\n\n<p>[00:07:26] Laura Nelson: Yes. That&#8217;s right. Substack is huge now, and I can&#8217;t remember the figures off the top of my head, but there are millions of subscribers across all the Substack newsletters, I guess you&#8217;d call them. And the solution that I&#8217;m gonna be talking to you about is an alternative to keep that in WordPress, rather than outsourcing that to a different platform.</p>\n\n\n\n<p>[00:07:46] Nathan Wrigley: Is there a strong reason in your head why you would not wish to go with the, it&#8217;s the SaaS versus WordPress argument. You could have this about a thousand different SaaS platforms. But is there a strong reason in your head why you wish to do it in WordPress and not just pay Substack the fee and get on with it over there?</p>\n\n\n\n<p>[00:08:00] Laura Nelson: I think WordPress, I mean, WordPress lends itself to content. Like WordPress is where you publish content. And we&#8217;re talking about sharing content in a newsletter. And I think like this method, what most appeals about it to me is the fact that everything is in one place, and it&#8217;s familiar.</p>\n\n\n\n<p>So if you already have a WordPress website or a business that&#8217;s using WordPress to power it then you don&#8217;t have to learn something new, it&#8217;s already, it&#8217;s just there. It can be extended onto what you are already doing.</p>\n\n\n\n<p>[00:08:27] Nathan Wrigley: The payment bit, we&#8217;ll probably unpick the payment puzzle, but is this basically a paywall thing? In other words, are you restricting content? Are you only sending out to people who&#8217;ve paid? Or is it that you embed other things inside the newsletters, you know, upsells and subscriptions that people might join and so on?</p>\n\n\n\n<p>[00:08:44] Laura Nelson: No, no, you are only sending the content to those who&#8217;ve paid. So it&#8217;s like a subscription, like you would, sign up to like a, I think you can get them for like dog and cat food, where they get delivered regularly. Then you, yeah, just like that. But instead you&#8217;re receiving content in your inbox.</p>\n\n\n\n<p>[00:08:58] Nathan Wrigley: So you are going to describe to us a system built where you go to the website, you&#8217;re engaged, you sign up, you begin receiving emails and if your subscription payment is cancelled, the emails fail, and it stops.</p>\n\n\n\n<p>[00:09:09] Laura Nelson: Yeah, that&#8217;s exactly it.</p>\n\n\n\n<p>[00:09:11] Nathan Wrigley: Okay, so what plugins are you using?</p>\n\n\n\n<p>[00:09:13] Laura Nelson: Yeah, so in addition to like being on a WordPress website, so disclaimer, I mean, if you&#8217;re not on WordPress, I don&#8217;t know why you&#8217;re listening to this.</p>\n\n\n\n<p>[00:09:19] Nathan Wrigley: No, that&#8217;s probably fair.</p>\n\n\n\n<p>[00:09:21] Laura Nelson: You&#8217;ll need like WooCommerce, MailPoet, which is an email marketing plugin for WordPress, and WooCommerce subscriptions.</p>\n\n\n\n<p>[00:09:28] Nathan Wrigley: So the basic WooCommerce to sort of bind the whole subscription thing together. You add the subscription thing on top. And then there&#8217;s MailPoet. Is there any cost to any of that?</p>\n\n\n\n<p>[00:09:36] Laura Nelson: Yeah, so WooCommerce subscriptions is $199 per year. MailPoet is free to use up to a thousand subscribers. So when you get beyond that, there&#8217;s tiered plans. But I think the lowest plan starts at around $12 or $15 per month. It&#8217;s quite reasonable.</p>\n\n\n\n<p>[00:09:53] Nathan Wrigley: I&#8217;ve heard, and I don&#8217;t know where this number comes from, but I&#8217;ve heard that if your email list is a thousand people, roughly you can become profitable. And what I mean by that is that you can become profitable enough for it to become an important part of what you do. And it always felt that that was like a really, quite a low number.</p>\n\n\n\n<p>But then having tried to create email lists in the past, I quickly realized actually a thousand is pretty hard to get to. It&#8217;s difficult to get people to surrender their email address. So is there any advice that you give to people essentially to give you their email address?</p>\n\n\n\n<p>[00:10:25] Laura Nelson: Yeah. I think what works best is honesty. Be upfront and honest about what you&#8217;re gonna be sending to them. That you&#8217;re not gonna pass on your, their email to somebody else. And when you&#8217;re going to, like the frequency that they can expect to receive emails from you.</p>\n\n\n\n<p>And then it&#8217;s just a case of making sure that the content that you&#8217;re including in it is really valuable, offers something a bit different or unique that they might not be able to read elsewhere. I mean, that&#8217;s like solid advice for if it&#8217;s a paid newsletter or not paid. And then it&#8217;s just another form of marketing.</p>\n\n\n\n<p>So I recommend including, including a link to sign up in all of your normal email signatures, like from your Gmail or whatever you use. Use your social networks. If you have a good community on Twitter, let them know about your newsletter. Basically, plug it everywhere that you possibly can.</p>\n\n\n\n<p>[00:11:13] Nathan Wrigley: Does the MailPoet solution, does it allow you to create, so forgive me, first of all, I&#8217;ve not used MailPoet, so I don&#8217;t know how the UI works, but does it allow you to basically create a post in WordPress, which is then fired out as an email?</p>\n\n\n\n<p>[00:11:25] Laura Nelson: Yes and no. So if you mean like a post in WordPress that you&#8217;d be able to go onto a WordPress website and see it in like the blog section. It wouldn&#8217;t work that way around. If you had published a blog post on WordPress and then use MailPoet to send an email, it&#8217;s a tick, like a widget, that you drag in and a tick that and you can include that entire blog post in your email.</p>\n\n\n\n<p>[00:11:45] Nathan Wrigley: Okay. So you create a normal blog post. Tick a box. When you click publish, it is converted to an email and sent out?</p>\n\n\n\n<p>[00:11:52] Laura Nelson: Yeah. Or you drag it into like your email template, and you can add other stuff around it.</p>\n\n\n\n<p>[00:11:56] Nathan Wrigley: Oh, okay. So you could put a different header and a different footer in? Okay.</p>\n\n\n\n<p>[00:11:59] Laura Nelson: And in the case of the paid news letter though, you&#8217;d probably, in order to get people to sign up and pay for this, you don&#8217;t want that content being available on your website for free. So you&#8217;d probably want to write the post within the email itself. So it only lives there and not elsewhere.</p>\n\n\n\n<p>[00:12:16] Nathan Wrigley: Yes, that wouldn&#8217;t make sense, would it? If it was a paid newsletter, and the content was available on your website.</p>\n\n\n\n<p>[00:12:21] Laura Nelson: But you could use WooCommerce memberships. You could guard that and make it a private post and then link to it it.</p>\n\n\n\n<p>[00:12:27] Nathan Wrigley: Okay. So as with all things WordPress, there&#8217;s a way.</p>\n\n\n\n<p>[00:12:30] Laura Nelson: Yeah. You can add another layer to this if you want to do that.</p>\n\n\n\n<p>[00:12:32] Nathan Wrigley: If somebody was to begin a completely new website. You know, they wanna talk about, I dunno, volcanoes or something. Then would you be able to do this on pretty modest hosting? Because it doesn&#8217;t feel like there&#8217;s a lot going on. Basic WordPress, basic WooCommerce, a couple of extra plugins, maybe really cheap hosting?</p>\n\n\n\n<p>[00:12:50] Laura Nelson: Uh, yeah. Really, unless you are planning on adding loads of other products to your store or adding loads and loads of other content to your website. You can keep this really lean and get away with really cheap posting. It wouldn&#8217;t take much, you just need a product page really.</p>\n\n\n\n<p>[00:13:05] Nathan Wrigley: The difficulty I think maybe is trying to get people to find your newsletter in the first place. And then of course there&#8217;s the problem of getting them to separate their email and give it to you. Have you got any advice for how you market your newsletter? Anything around there?</p>\n\n\n\n<p>[00:13:21] Laura Nelson: Yeah. It&#8217;s funny. Someone asked me this yesterday after the talk and I, I said I could probably do an entire other presentation on this exact topic.</p>\n\n\n\n<p>[00:13:30] Nathan Wrigley: Go deep, it&#8217;s good.</p>\n\n\n\n<p>[00:13:31] Laura Nelson: So, what I was saying earlier about being really upfront about what you&#8217;re gonna be sending, when you&#8217;re gonna be sending it. Know what you&#8217;re doing with their email address. And you just really need to show some value. So you need to make sure that the content that you are creating is unique or if you do have an expertise in a certain area, really let people know, like why that&#8217;s important to them.</p>\n\n\n\n<p>Content is all about problem solving for people. So you need to find out what problems people have. And if you can solve that in content, then let them know.</p>\n\n\n\n<p>[00:14:03] Nathan Wrigley: I&#8217;m guessing that some things are going to be more of a labour of love than other things. Again if you&#8217;re producing the volcano newsletter, I&#8217;m expecting in the low single digits.</p>\n\n\n\n<p>[00:14:12] Laura Nelson: Well you know, it&#8217;s a niche market I imagine. Maybe that would be more successful because you know, you get people who are really into something like that. You know, there&#8217;s probably not a lot. I dunno, I&#8217;m not, I&#8217;m not familiar with the volcano market. I&#8217;m not gonna lie, but, um, I kind of imagine there will be those niche areas like that, where if there&#8217;s not content being published about that or at least readily available to you, then you probably would pay. It&#8217;s like, oh yeah, I love that, and I&#8217;m really interested in that. So I would pay to receive.</p>\n\n\n\n<p>[00:14:40] Nathan Wrigley: Yeah. It&#8217;s interesting because of course you&#8217;ve gotta think about the person reading the content and whether volcanoes are gonna be of any interest to them, but also your ability to sustain this, is directly related to how interested you think it is.</p>\n\n\n\n<p>So, you know, if you genuinely have no interest in volcanoes and you embark on that mission, probably it&#8217;s gonna dry up fairly quickly, and so I wonder if often people in this chase the big thing, the big shiny, exciting thing only to discover, you know, what, actually on a deep, personal level, I&#8217;m not interested in this, and the newsletter dries up and falters and fails.</p>\n\n\n\n<p>[00:15:16] Laura Nelson: If you&#8217;re thinking about starting this up, you need to remember, it&#8217;s not just one email. It&#8217;s not just two. It has to have like longevity to it. So whatever it is, whatever topic you&#8217;re choosing, obviously you can&#8217;t possibly know what you might like to talk about or write about in six months time, but you need to make sure that the topic is either big enough or is like new things are happening in that area enough in order to sustain a long term newsletter.</p>\n\n\n\n<p>[00:15:42] Nathan Wrigley: I wonder if this is like a perfect extension to people who are already doing things. They might have got a YouTube channel. They might have a WordPress website and they&#8217;re producing things. Or in this case here we are on a podcast. It may be that you&#8217;ve got that kind of thing. It feels like a bit of a no brainer to just add this on as a kind of value add. So you could have, well, I don&#8217;t know, content that only subscribers get, or things like that. Is that where the market seems to be leading.</p>\n\n\n\n<p>[00:16:08] Laura Nelson: Absolutely. You obviously can start from scratch and it, technically it&#8217;s pretty easy to do so, in that respect. But, you&#8217;re gonna have more success if you already have, you need to make sure you already have an audience. And if you already have a business, you already have a customer base or an audience that are, are listening to you, and you&#8217;re communicating with. So yeah, I think it&#8217;s an obvious, like an easy fit for established businesses.</p>\n\n\n\n<p>[00:16:34] Nathan Wrigley: Yeah. So if you&#8217;ve got something going already. It&#8217;s almost like a missing piece of the jigsaw if you&#8217;re not doing it.</p>\n\n\n\n<p>[00:16:39] Laura Nelson: It&#8217;s not to be used to like plug your products or services. It&#8217;s not like, I guess if you were to run a, an eCommerce store and you sell products, it&#8217;s not to be used like that. It&#8217;s like a highlight of, oh, we got these new trainers in stock etc. You have to be adding something of value, like an opinion or some content that they can&#8217;t get elsewhere. I think one of the, um, examples I gave yesterday was digital downloads. Like if you&#8217;re really good photographer, you could share your photos in an email newsletter and let have access to use your photos, you know? Like on a weekly basis like, 10 new photos every week or fortnight or something.</p>\n\n\n\n<p>[00:17:18] Nathan Wrigley: So this is subscription, which means we must decide on a subscription term. Do you typically, would you say like go monthly? Is that, is that the easiest, least friction way to do it? Sort of asking people to separate money from their wallet, monthly, annually.</p>\n\n\n\n<p>[00:17:34] Laura Nelson: I&#8217;d offer both a monthly option and then a yearly, maybe it would just slightly discounted. Because it&#8217;s great. If you have people signed up for a year or they&#8217;ve committed to that year, that&#8217;s excellent. But I&#8217;d always give people the option of monthly.</p>\n\n\n\n<p>[00:17:45] Nathan Wrigley: My fear of offering an annual plan would be that I just dry up. You know, I&#8217;d be eight months in and I&#8217;d be, ah, I&#8217;ve got nothing else to say, and then I&#8217;ve got to think about the, the sort of refund process.</p>\n\n\n\n<p>[00:17:58] Laura Nelson: Yeah. If you do that, you would probably have to refund people, but offering a yearly option is something you could consider after you&#8217;ve got into the groove of creating a newsletter and you think you can see it has a longer life to it.</p>\n\n\n\n<p>[00:18:10] Nathan Wrigley: Yeah I know this, what we&#8217;ve been talking about is a WordPress thing. The piece that you described, the MailPoet and the WooCommerce bit is the way to get paid for that. Just briefly talking about alternative ways of doing that. The sponsorship bit, or the payment bit outside of WordPress. There&#8217;s things like Patreon and Ko-fi is that, an angle you&#8217;ve ever looked at or explored?</p>\n\n\n\n<p>[00:18:30] Laura Nelson: Yeah, and like Substack. They&#8217;re all like really great platforms to use. But they&#8217;re outside of WordPress. So, I think the kind of unique angle here or for this approach is, if you want everything to be all in one place, if you&#8217;re already creating content in WordPress, don&#8217;t spend your time copying and pacing it over to a different piece of software. You can have it all like in one dashboard, basically. Ownership is a big part of that.</p>\n\n\n\n<p>[00:18:59] Nathan Wrigley: Thorny question.</p>\n\n\n\n<p>[00:19:01] Laura Nelson: Mm-hmm.</p>\n\n\n\n<p>[00:19:01] Nathan Wrigley: Where are the email addresses stored?</p>\n\n\n\n<p>[00:19:03] Laura Nelson: Right? So in MailPoet, no one else can see your subscriber&#8217;s email addresses. MailPoet takes, email best practices and security very seriously. We don&#8217;t even see the emails that get sent out via MailPoet. So they&#8217;re stored on, I think it&#8217;s like your server, they belong with you.</p>\n\n\n\n<p>[00:19:22] Nathan Wrigley: Mm-hmm.</p>\n\n\n\n<p>[00:19:23] Laura Nelson: They don&#8217;t come to MailPoet at any point. They are yours.</p>\n\n\n\n<p>[00:19:26] Nathan Wrigley: That&#8217;s an interesting thing. And I guess you would need to be mindful of GDPR if you are storing people&#8217;s email addresses. Do you have any insight into whether those are in the database? Do you know whether they&#8217;re in an encrypted, in an encrypted form or not?</p>\n\n\n\n<p>[00:19:40] Laura Nelson: This is a technical question that I am not able to answer, I&#8217;m afraid. At least not confidently. I think I know the answer, but I absolutely wouldn&#8217;t want to go on a podcast and tell everybody the wrong thing if that&#8217;s okay.</p>\n\n\n\n<p>[00:19:51] Nathan Wrigley: That&#8217;s okay we could could look at that another time. And so have you got any good examples of newsletters where you could say, go and have a look at that one. Two or three that you think are really worthwhile where somebody&#8217;s done it just right. They&#8217;re doing really well.</p>\n\n\n\n<p>[00:20:03] Laura Nelson: So the first one&#8217;s called Dense Discovery. None of these examples are actually of paid, well, actually I can give some paid newsletter examples. Let me start with Dense Discovery, which you can pay for, but they handle the payment a slightly different way. It&#8217;s more like a tip based system. Like if you enjoy this, you know, become a friend of the newsletter. But from a content perspective, I would pay to receive Dense Discovery.</p>\n\n\n\n<p>If they offered it up as a subscription, I would do that. Cause I tip on a regular basis. It has a really good balance of the guy who&#8217;s created the newsletter called Kai, like his opinion, and his take on what&#8217;s happening in the world. There are some lovely resources for like design. He often shares like an illustrator and their work, as well as some like handy tools for like productivity at work.</p>\n\n\n\n<p>So it&#8217;s kind like a nice, a nice blend of content. And it&#8217;s really regular. I know when I&#8217;m gonna receive it. It&#8217;s the same time each week, and I know the quality of the content&#8217;s gonna be really, really good.</p>\n\n\n\n<p>[00:21:01] Nathan Wrigley: Can I just pause you there, and just go on a bit of a segue and we&#8217;ll come back to some other ones in a minute, because that just suddenly occurred to me. There&#8217;s something a bit meta going on there, because he&#8217;s not asking for a subscription, but what if you had an email newsletter, which was a, the sort of upsell for the paid newsletter?</p>\n\n\n\n<p>[00:21:17] Laura Nelson: Oh yeah.</p>\n\n\n\n<p>[00:21:18] Nathan Wrigley: If you know what I mean? So the newsletter itself contains a proportion of the content. Is that a thing?</p>\n\n\n\n<p>[00:21:24] Laura Nelson: Yeah, absolutely. And actually the next example I was going to give. I&#8217;d like to like add to disclaimer it, this isn&#8217;t of my interest but&#8217;s I can see it&#8217;s done really, really well, which is why I&#8217;m gonna mention it. It&#8217;s called Daily Coding Problem. So it uses this paid newsletter technique really interestingly. It&#8217;s basically they send like a coding problem. It&#8217;s designed to help programmers prepare for technical interviews. And if you are only a free subscriber, you don&#8217;t get to see the answer.</p>\n\n\n\n<p>[00:21:53] Nathan Wrigley: Oh.</p>\n\n\n\n<p>[00:21:53] Laura Nelson: Uhhuh.</p>\n\n\n\n<p>[00:21:54] Nathan Wrigley: That is intriguing. Yeah, that&#8217;s kind of like using the annoyance style isn&#8217;t it? Yeah.</p>\n\n\n\n<p>[00:21:58] Laura Nelson: So I mean, if you&#8217;re really confident with these, maybe you don&#8217;t, maybe you don&#8217;t need to see them, like the mystery. Yeah, you have to become a paid subscriber to see the solution.</p>\n\n\n\n<p>[00:22:07] Nathan Wrigley: That&#8217;s fascinating. So throw something out there. It&#8217;s a bit like if Wordle didn&#8217;t give you the answer.</p>\n\n\n\n<p>[00:22:12] Laura Nelson: I know. How annoying would that be?</p>\n\n\n\n<p>[00:22:14] Nathan Wrigley: Well, you&#8217;d pay.</p>\n\n\n\n<p>[00:22:16] Laura Nelson: Exactly.</p>\n\n\n\n<p>[00:22:17] Nathan Wrigley: And you&#8217;d get the answer every, every day. Yeah, that&#8217;s fascinating. So I mean that&#8217;s really unique isn&#8217;t it? But presumably most of it is about just the kind of stuff that you would ordinarily put on your website. You just make sure that the content&#8217;s really good, but you indicate they&#8217;ve got to the end of this newsletter, but there&#8217;s more.</p>\n\n\n\n<p>[00:22:32] Laura Nelson: Yeah, yeah.</p>\n\n\n\n<p>[00:22:32] Nathan Wrigley: You could find out more.</p>\n\n\n\n<p>[00:22:33] Laura Nelson: Absolutely. And another example, um, which I mentioned yesterday actually was Jack&#8217;s Flight Club.</p>\n\n\n\n<p>[00:22:38] Nathan Wrigley: Oh. I pay for Jack&#8217;s Flight Club.</p>\n\n\n\n<p>[00:22:40] Laura Nelson: You&#8217;re newsletter subscriber.</p>\n\n\n\n<p>[00:22:42] Nathan Wrigley: That&#8217;s fascinating. I hadn&#8217;t connected. I use the app.</p>\n\n\n\n<p>[00:22:46] Laura Nelson: Yeah.</p>\n\n\n\n<p>[00:22:47] Nathan Wrigley: But it is a newsletter, is and he got me through the newsletter. You&#8217;re right. Go on, tell them about Jack&#8217;s Flight Club.</p>\n\n\n\n<p>[00:22:52] Laura Nelson: Yeah, so Jack&#8217;s Flight Club, as we just heard, is, it&#8217;s a really popular one, uh, in the UK and Europe. And it sends you like error fairs and cheap flight deals. But if you&#8217;re not a paid subscriber, you don&#8217;t get all of the deals. And when you get the free version of email, they tell you which deals that you missed. So it really plays on that, like FOMO, like, you know, you&#8217;ve missed these incredibly cheap flights to Canada. You didn&#8217;t get that because you&#8217;re not a paid subscriber.</p>\n\n\n\n<p>[00:23:18] Nathan Wrigley: That&#8217;s right. And the interesting thing about that one is. That&#8217;s kind of opened my eyes up actually about where the price points may be. And maybe, maybe Jack is different, but it&#8217;s about if I recall, I think I paid about $40, something like that per year. So it was not really a lot. If you spread that over the, you know, it&#8217;s like $3 80 or a month</p>\n\n\n\n<p>[00:23:40] Laura Nelson: Yep.</p>\n\n\n\n<p>[00:23:40] Nathan Wrigley: That&#8217;s really not a significant amount, but presumably if Jack, I&#8217;m guessing there is a Jack, I don&#8217;t know, but presumably if Jack&#8217;s into the tens of thousands, hundreds of thousands. This</p>\n\n\n\n<p>is incredible… a million.</p>\n\n\n\n<p>[00:23:52] Laura Nelson: He&#8217;s got a million subscribers, million plus, yeah.</p>\n\n\n\n<p>[00:23:55] Nathan Wrigley: We can work the maths out there. Okay Jack&#8217;s doing well from newsletters.</p>\n\n\n\n<p>[00:23:58] Laura Nelson: Jack&#8217;s doing alright. Well, it&#8217;s the success of a newsletter that enabled him to take it to an app and, you know, grow this beyond just email content.</p>\n\n\n\n<p>[00:24:06] Nathan Wrigley: I want to be Jack.</p>\n\n\n\n<p>[00:24:08] Laura Nelson: Yeah, me too. I bet he&#8217;s on a yacht somewhere lovely, right. He&#8217;s not looking up cheap flights.</p>\n\n\n\n<p>[00:24:12] Nathan Wrigley: He&#8217;s no longer looking, but that really illustrates it perfectly. So it was something most people probably don&#8217;t care about flights at all. They&#8217;ll just look the flight when they&#8217;re going on holiday but here&#8217;s me, I&#8217;m intrigued. I want if there is a cheap deal out there. So it&#8217;s got me on that niche thing. Like the coding chap.</p>\n\n\n\n<p>And, I don&#8217;t know how long it took me. I think he was probably giving me the free one for six months.</p>\n\n\n\n<p>[00:24:35] Laura Nelson: Yep.</p>\n\n\n\n<p>[00:24:36] Nathan Wrigley: Do you know what he also did, which was curious, which was actually the hook. He offered a 20% discount in one of his emails. So that&#8217;s another interesting pricing strategy. He had his annual price and then he, for a week only, I think it was 20% off. That was the, the fishing rod that I happily bit on. And, and I think he&#8217;s got me for years to come.</p>\n\n\n\n<p>[00:24:56] Laura Nelson: Yeah. You can do that with this, and I&#8217;d recommend exploring things like that. Just jumping back to your question earlier about how to get paid subscribers. If you already run a successful newsletter, you can drop in the bit about you having a paid newsletter too, give &#8217;em a little taster of what they&#8217;ve missed or what they will miss if they don&#8217;t pay to subscribe and yeah, it got you.</p>\n\n\n\n<p>[00:25:17] Nathan Wrigley: It works. And interestingly enough, I am pretty difficult to get, and yet he got me. So it is, it is about the niche I think.</p>\n\n\n\n<p>[00:25:25] Laura Nelson: Yeah, yeah.</p>\n\n\n\n<p>[00:25:25] Nathan Wrigley: Well, let&#8217;s talk about the actual email itself. So we open up the email. Are there any sort of top tips about the way you should present things? I mean, are we looking for bright and colorful? Are we looking for more words than images? Are there trip wires that prevent the email clients from opening things? Because there&#8217;s just way too much text and it truncates it. Just give us what the email actually should be looking like.</p>\n\n\n\n<p>[00:25:47] Laura Nelson: Well, I mean, it does completely depend, like what you&#8217;re including in it. I wouldn&#8217;t be, if you are selling a like long form content style email, don&#8217;t be afraid of including lots of words. Because that&#8217;s what people are paying for. But in terms of spam filters, if you&#8217;re offering a paid newsletter subscription, I don&#8217;t think you&#8217;d have any issues because it&#8217;s usually things like the word free and like capital letters, lots of exclamation marks.</p>\n\n\n\n<p>[00:26:09] Nathan Wrigley: Emojis in the subject line, yeah.</p>\n\n\n\n<p>[00:26:12] Laura Nelson: Emojis in the subject line are okay, as long as they&#8217;re not overused. Yeah. Basically emails like don&#8217;t overdo anything.</p>\n\n\n\n<p>[00:26:20] Nathan Wrigley: Okay.</p>\n\n\n\n<p>[00:26:21] Laura Nelson: A good, combination of yeah, different things that works well. In terms of layout, I mean, just take a step back and think about what you&#8217;d like to read. If it&#8217;s a big wall of text, would that entice you to read it? I mean, some people maybe, but not no. So, and you can format the newsletter to look how you want. So you could add spaces, you can add some images, you can use columns if that&#8217;s better for your content, so.</p>\n\n\n\n<p>[00:26:45] Nathan Wrigley: The last time I was fiddling with email, I think we&#8217;re still stuck in tables. Are there big constraints still about the way that you can present things? So obviously on the web, our own WordPress websites, we can literally put anything anywhere, pixel by pixel, more or less. Are we confined with emails still? I mean are we still thinking about email clients from the year 2004 as a thing?</p>\n\n\n\n<p>[00:27:06] Laura Nelson: Yeah. Well, I mean email&#8217;s tricky because it will look different according to different email clients, and Outlook is forever a bug bear for those who create emails. But if you&#8217;re using email marketing software, I mean, I can only speak to MailPoet, and I&#8217;m not just trying to plug here. It&#8217;s just the one I&#8217;m most familiar with. Their templates are already fully responsive. Their templates are tested on all the different email clients. So you can kind of be pretty confident that unless you&#8217;ve gone in and really messed with that, they&#8217;re gonna work in most email clients.</p>\n\n\n\n<p>Litmus is a great tool if you&#8217;re not sure. Email on Acid to test your emails, to see what they&#8217;re going to look like on Outlook, on Gmail, all the big email.</p>\n\n\n\n<p>[00:27:47] Nathan Wrigley: And how do they work? You send Email on Acid an actual email and it then tells you, it gives you a rating or things to improve and so on.</p>\n\n\n\n<p>[00:27:54] Laura Nelson: It will show you how they look across the different email clients.</p>\n\n\n\n<p>[00:27:58] Nathan Wrigley: Tell us about the actual UI, about how you build email. I&#8217;ve logged into all sorts of services. Typically there&#8217;s a bunch of modules for want of a better word, a bit like in Gutenberg with blocks now. So you drag in a, an image and you could drag in a couple of columns and put the image to the left, and text to the right. Is it what you see is what you get kind of builder?</p>\n\n\n\n<p>[00:28:18] Laura Nelson: Yeah. Yeah. It is a WYSIWYG builder. It doesn&#8217;t use Gutenberg but I know the MailPoet team are looking to explore that option. But the email itself is a WYSIWYG editor where you drag and drop.</p>\n\n\n\n<p>[00:28:30] Nathan Wrigley: So it&#8217;s familiar? You&#8217;ll be right at home. Yeah.</p>\n\n\n\n<p>[00:28:32] Laura Nelson: I don&#8217;t like describing things as easy because I think different people have different perceptions of what&#8217;s easy, but this is the easiest email editor I&#8217;ve ever used, because it is simply you drag it and you drop it where you want it.</p>\n\n\n\n<p>[00:28:46] Nathan Wrigley: Do you get an opportunity to inspect it before you commit?</p>\n\n\n\n<p>[00:28:51] Laura Nelson: Yeah.</p>\n\n\n\n<p>[00:28:51] Nathan Wrigley: So it will send you a version you can inspect make sure the links are all working and so on.</p>\n\n\n\n<p>[00:28:56] Laura Nelson: Yeah, absolutely.</p>\n\n\n\n<p>[00:28:18] Nathan Wrigley: And does it check that stuff as well? So in other words, it will see that for example, you&#8217;ve overused images, Nathan. Stop with the images volcanoes. Or that there&#8217;s too much text typically. Does it give you any metrics about, what is that called even? Because I&#8217;ve seen that before, they do some sort of test in the background and give you a rating.</p>\n\n\n\n<p>[00:29:14] Laura Nelson: Like a readability.</p>\n\n\n\n<p>[00:29:15] Nathan Wrigley: Something along those lines, yeah.</p>\n\n\n\n<p>[00:29:17] Laura Nelson: It doesn&#8217;t, no. I think because the way MailPoet&#8217;s built and we don&#8217;t see your email content.</p>\n\n\n\n<p>[00:29:23] Nathan Wrigley: That&#8217;s interesting because it&#8217;s your WordPress site. So it&#8217;s your email. So it&#8217;s not phoning home any to any third parties.</p>\n\n\n\n<p>[00:29:29] Laura Nelson: It&#8217;s not but that&#8217;s a pretty interesting idea. Maybe I&#8217;ll pass it onto the team.</p>\n\n\n\n<p>[00:29:32] Nathan Wrigley: Oh okay.</p>\n\n\n\n<p>[00:29:33] Laura Nelson: That would be useful.</p>\n\n\n\n<p>[00:29:34] Nathan Wrigley: Can I take credit for that?</p>\n\n\n\n<p>[00:29:35] Laura Nelson: The feature will be called email read, readability by Nathan.</p>\n\n\n\n<p>[00:29:40] Nathan Wrigley: That&#8217;s great. Okay I&#8217;m happy with that. So Laura, just before we wrap up, where&#8217;s the best place to find out about, well, in this case, MailPoet, where do we go?</p>\n\n\n\n<p>[00:29:48] Laura Nelson: MailPoet.com. If you head to the blog, there&#8217;s some really great articles there about email marketing in general. How to build your list. There&#8217;s even a blog post about creating a paid newsletter. Like what my talk was on yesterday. Fantastic resource for all things email marketing.</p>\n\n\n\n<p>[00:30:04] Nathan Wrigley: Well Laura, well done for getting through your talk at WordCamp Europe.</p>\n\n\n\n<p>[00:30:07] Laura Nelson: Thank you. Thank you.</p>\n\n\n\n<p>[00:30:08] Nathan Wrigley: A nice relief and, very happy to have you on the podcast today.</p>\n\n\n\n<p>[00:30:12] Laura Nelson: Thank you so much for having me. It&#8217;s been a pleasure.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Post Status: Naming is Hard: Content Types on Learn WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=113897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://poststatus.com/naming-is-hard-content-types-on-learn-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1257:\"<p>Based on a <a href=\"https://make.wordpress.org/training/2022/07/03/discussion-naming-content-types-on-learn-wordpress/\">public discussion</a> led by <strong>Hugh Lashbrooke</strong>, <a href=\"https://learn.wordpress.org/workshops/\">Workshops</a> (5-15 minute instructional videos) are going to be called <strong>Tutorials</strong>, moving forward while <a href=\"https://learn.wordpress.org/social-learning/\">Social Learning Spaces</a> (live and collaborative learning sessions) have become <strong>Online Workshops</strong>. </p>\n\n\n\n<p>No change to <a href=\"https://learn.wordpress.org/courses/\">Courses</a> (long-form content with multiple lessons in multiple media formats) and <a href=\"https://learn.wordpress.org/lesson-plans/\">Lesson Plans</a> (structured plans that trainers can use to teach others).</p>\n\n\n\n<p>Definitely seems to move things toward greater simplicity and clarity. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/training/2022/07/03/discussion-naming-content-types-on-learn-wordpress/\">Discussion: Naming content types on Learn WordPress</a></blockquote>\n</div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 04:28:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Post Status: LearnDash: Plugin or SaaS?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=113919\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://poststatus.com/learndash-plugin-or-saas/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:883:\"<p>Or both — if you want both. It\'s <a href=\"https://www.learndash.com/pricing-and-purchase/\">LearnDash — and LearnDash Cloud</a>.</p>\n\n\n\n<p>I don\'t think I\'ve ever seen a WordPress plugin priced and marketed this well as both a <em>product</em> and a <em>service</em>. </p>\n\n\n\n<p>At least that\'s how most people think of it&#8230; A plugin is really a product with updates and support as a service. A SaaSified plugin is still the underlying WordPress product. </p>\n\n\n\n<p>What the customer cares about is what they can (or don\'t have to) do — as a site builder or developer, or as someone who wants all the technical details and heavy lifting to be taken off their plate. </p>\n\n\n\n<p>Both are open source. Both introduce different kinds of people to a community and ecosystem. </p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Aug 2022 23:09:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: WP-Optimize Denies Allegations of Cheating Performance Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137433\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/wp-optimize-denies-allegations-of-cheating-performance-tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11452:\"<p>Yesterday, we <a href=\"https://wptavern.com/wp-optimize-plugin-accused-of-cheating-pagespeed-and-other-performance-testing-tools\">published</a> allegations from Gijo Varghese against UpdraftPlus, the makers of WP-Optimize. Varghese is founder of FlyingProxy, a competing company, and identifies himself as a &#8220;performance enthusiast.&#8221; He accused the plugin of &#8220;cheating Pagespeed and other tools&#8221; by hiding JavaScript files from loading when users test their sites through popular performance testing tools. The code uses an odd set of obfuscated names for the testing tools, which drew his suspicion. </p>\n\n\n\n<p>Varghese neglected to mention in his <a href=\"https://twitter.com/GijoVarghese_/status/1563097754322501632?ref_src=twsrc%5Etfw%7Ctwcamp%5Etweetembed%7Ctwterm%5E1563097754322501632%7Ctwgr%5Ebf97b211fb13920391541b64137000b5ea1edc0c%7Ctwcon%5Es1_c10&ref_url=https%3A%2F%2Fwptavern.com%2Fwp-optimize-plugin-accused-of-cheating-pagespeed-and-other-performance-testing-tools\">tweet</a> that this is what happens when one of the plugin&#8217;s settings under Minify > JS is set to defer JavaScript. There are two radio button settings but they are confusing.  </p>\n\n\n\n<p>The first radio button allows users to defer selected JavaScript files. It says the files will be loaded asynchronously (not the same as defer), and then it also says that users should select the first radio button if they want to exclude scripts from page speed tests. It is not clear how the scripts will be loaded for the user or for testing sites. Excluding is not the same as deferring, so in this case the settings UI is somewhat misleading and should be more clear.</p>\n\n\n\n<img />\n\n\n\n<p>The second radio option is for users who are simply looking to defer all JavaScript. If one selects <em>&#8220;Defer using JavaScript (Use this method if you require support for <a href=\"https://www.w3schools.com/tags/att_script_defer.asp\">older browsers</a>),&#8221;</em> it should do exactly what it describes in the link:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>If the <code>defer</code> attribute is set, it specifies that the script is downloaded in parallel to parsing the page, and executed after the page has finished parsing.</p>\n</blockquote>\n\n\n\n<p> Even though the UI says it is deferring all files, WP-Optimize never loads the JavaScript for performance testing sites. In this second option, the exclusion of testing sites happens without the users&#8217; permission. If users had wanted that, they would have selected the previous radio button and explicitly identified which scripts to exclude.</p>\n\n\n\n<img />\n\n\n\n<p>Varghese left out some significant details in his original report, but it was accurate in that certain settings are misleading about what they actually do. He demonstrated this in a follow-up video where there is no manual entry of any scripts to exclude and the second radio option is checked.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>&#8220;They&#8217;re providing an option for users to cheat testing tools,&#8221; Varghese said. &#8220;Also, using names like &#8216;ighth&#8217; for Lighthouse and &#8216;tmetr&#8217; for GTmetrix clearly shows what they&#8217;re trying to do.</p>\n\n\n\n<p>&#8220;Most of the users try disabling and enabling different features to see which one is increasing the speed/scores in testing tools.&#8221; </p>\n\n\n\n<p>Varghese contends there is no need to do things differently for testing tools and humans, as this can be confusing for site owners. His allegation left out significant details and implied that all of this is hidden in the code. It is for one of the settings but not the other one. The interface implies that you must enter scripts manually to exclude from testing, but this is also misleading. </p>\n\n\n\n<p>WP-Optimize <a href=\"https://getwpo.com/wp-optimize-completely-rejects-false-allegations-of-gaming-page-speed-results/\">published a public response to the allegations</a> today, but has not revealed any of the results from the code investigation they completed. Instead, the company cited a video created by Peter Wilkinson from <a href=\"https://diviengine.com/\">Divi Engine</a>, who claims that users must manually enter scripts to make testing sites exclude them.</p>\n\n\n\n<p>Wilkinson is quoted as concluding that &#8220;Gijo Varghese has used deception to promote Flying Pages and Flying Press&#8221; in bringing this issue to public attention on Twitter.</p>\n\n\n\n<p>“In reality (from my research) WP-Optimize do not &#8216;cheat&#8217; Pagespeed tools when you install or Minify your JavaScript,&#8221; Wilkinson said.</p>\n\n\n\n<p>“To &#8216;cheat&#8217; the tools, you need to manually add the JS files you want to asynchronous load to a setting that clearly has the label &#8216;Use this if you have a completely independent script or would like to exclude scripts from page speed tests (PageSpeed Insights, GTMetrix…)\'&#8221;</p>\n\n\n\n<p>This is not the case. The easiest way to test is to install the plugin, turn on &#8220;defer all JavaScript,&#8221; and then view the source to see that performance tools are excluded.</p>\n\n\n\n<p>Since WP-Optimize&#8217;s public response to the issue did not include anything from their code investigation, I contacted them again. Their deputy lead Venkat Raj was not available to answer why other settings in the plugin silently remove JS for performance testing tools with the click of a radio button. Joe Miles, head of strategy for the company, shared the last information he received on the issue from Venkat Raj: </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>&#8220;The advanced setting used in the allegation is actually useful to find out whether the essential js/css files are actually slowing down the web page or not.  This feature is by default, turned ‘off’ and only enabled by advanced users who know what they’re doing.<br /><br />&#8220;You may use this feature if you have a completely independent script or would like to exclude scripts from page speed tests (PageSpeed Insights, GTMetrix&#8230;)<br /><br />&#8220;Independent scripts are for example &#8216;analytics&#8217; or &#8216;pixel&#8217; scripts. They are not required for the website to work. &#8216;<em>Use this if you have a completely independent stylesheet or would like to exclude stylesheets from page speed tests (PageSpeed Insights, GTMetrix&#8230;)</em>&#8216;</p>\n</blockquote>\n\n\n\n<p>This applies to the first radio button. The second button does not have any indication that it will turn off all scripts when using testing tools &#8211; nor does WP-Optimize&#8217;s team seem to be aware that it is available with the click of a radio button. </p>\n\n\n\n<p>Miles could not confirm whether this is how it is intended to work or if it is a bug. He also could not account for why the names of the popular testing sites were obfuscated in the code, but said the original developer &#8220;doesn&#8217;t work for us as it&#8217;s open source code repurposed from elsewhere.&#8221; </p>\n\n\n\n<p>&#8220;However, we believe this is a distraction from the false allegations, and what matters is that the UI is very clear for the settings are for, so users aren&#8217;t deceived,&#8221; Miles said.</p>\n\n\n\n<p>Raul Peixoto, author of the <a href=\"https://wordpress.org/plugins/fast-velocity-minify/\">Fast Velocity Minify</a> (FVM), the plugin from which WP-Optimize copied the code, said he can confirm that this code was part of FVM but said it was not used in the same way:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>The purpose of such code on FVM was completely different than the one on WP Optimize and furthermore it required for the users to manually enable this option via wp-admin (it was disabled by default).</p>\n\n\n\n<p>The purpose of that code was to selectively test the impact of new scripts or plugins in performance, and help developers decide if they should refactor, remove or replace heavy plugins or scripts.</p>\n\n\n\n<p>This existed on FVM to answer questions like these:<br />“I have a production site and my performance is low. What would be the performance if this plugin was simply not here, but without actually removing it from the site for regular users yet?”<br />“What would the performance be if I could defer all scripts, or specific scripts that are not currently compatible with defer, before actually doing that change for everyone?”</p>\n</blockquote>\n\n\n\n<p>An official explanation regarding its use on FVM is <a href=\"https://wordpress.org/support/topic/why-are-some-scripts-not-loaded-for-speed-testing-sites/\">available in the plugin&#8217;s support forum</a> as of this morning.</p>\n\n\n\n<p>&#8220;I suppose that the developers hired by WP Optimize did not understand what this was doing on FVM or under what settings, or perhaps, they may have felt tempted to use it as a hack,&#8221; Peixoto said.</p>\n\n\n\n<p>&#8220;We should also carefully remember that at that time, there were still no web vitals metrics publicly available, so using something like this would have yield better &#8216;measurable&#8217; results, thus offering a product advantage.&#8221;</p>\n\n\n\n<p>Piexoto said he &#8220;felt compelled&#8221; to remove this code two years ago because of how often it was abused by developers who were cheating on tests for their clients:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Fast forward some time, and I realized that some developers were actually using this to cheat on the tests for their clients, so I felt compelled to make the decision on FVM 3 (already late 2020) to remove this feature, which was met by a lot of protests of angry developers when their clients started complaining that their scores went down.</p>\n\n\n\n<p>I tried at that time, to explain that having a good score was not the same as having good web vitals metrics, but eventually I gave up on that, as some people cared more about the test results than the actual performance.</p>\n\n\n\n<p>After FVM 3 release, I am basically just maintaining it and doing small bug fixes when reported, as I have to focus on other things. I have removed that function and fixed a couple of bugs that were pending on version 3.2.9 and pushed an update, so thank you for referring this to me.</p>\n</blockquote>\n\n\n\n<p>For whatever reason, UpdraftPlus chose to merge this code into WP-Optimize in 2020 and, as reported yesterday, hasn&#8217;t touched the code since. </p>\n\n\n\n<p>What appeared to be a black and white issue yesterday is a more nuanced situation. WP-Optimize&#8217;s implementation of FVM&#8217;s code is poorly documented in the UI and misleading about how the scripts are loaded. It can lead site owners to activating it without being advanced users, and historically has a high potential for abuse. When Varghese discovered it, he exposed it in an inflammatory way, feeling certain he had found wrongdoing because of how inexplicably obfuscated the code is. This compounded the issue but started a broader, important conversation. </p>\n\n\n\n<p>Should users have this kind of easy access (two clicks) to turning off scripts for performance testing tools? How can developers in the same industry better communicate about potential harms to users that they see in others&#8217; products? What kind of code documentation requirements should agencies implement to prevent a situation like this where code needs to be investigated over the span of days in order to find out what it is intended to do?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Aug 2022 22:41:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Post Status: Naming is Hard: Social and Schema Images\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=113879\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://poststatus.com/naming-is-hard-social-and-schema-images/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:799:\"<p>This was <a href=\"https://joost.blog/social-schema-images-naming-considerations/\">a neat post</a> from <strong>Joost de Valk</strong> back in July where he did some thinking out loud about the challenges of naming in <strong>Schema.org</strong> image standards to distinguish between featured and poster images on social networks:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>I’ve been playing a lot with Schema and Social images recently and one thing has become clear: we need better naming of these images and we should probably improve the Schema.org image standards a bit. In this post I want to briefly discuss the different needs and my proposed (very simple) naming scheme.</p></blockquote>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Aug 2022 22:17:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Post Status: Talk about edge cases!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=113837\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/talk-about-edge-cases/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:935:\"<p>On August 8, <strong>wordpress.org</strong> was <a href=\"https://status.wordpress.org/2022/08/05/all-wordpress-org-services-are-currently/\">down for a few hours</a> after a Chicago data center outage. During the outage, a user of <strong>Salt Shaker</strong> reported the plugin <a href=\"https://wordpress.org/support/topic/white-screen-after-outage-of-wordpress-org/\">replaced salt keys with an outage notice</a>, leading to a WSOD on a customer\'s site:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Probably the plugin just scraped and copied what was displayed at <a href=\"https://api.wordpress.org/secret-key/1.1/salt/\">https://api.wordpress.org/secret-key/1.1/salt/</a>.</p><cite><a href=\"https://wordpress.org/support/topic/white-screen-after-outage-of-wordpress-org/\">wordpress.org support forum</a></cite></blockquote>\n\n\n\n<p></p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Aug 2022 21:35:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WordPress.org blog: WordPress 6.0.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13346\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2022/08/wordpress-6-0-2-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5700:\"<p><strong>WordPress 6.0.2</strong> is now available!</p>\n\n\n\n<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/query?milestone=6.0.2\">12 bug fixes on Core</a>, <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.0\">5 bug fixes</a> for the Block Editor, and 3 security fixes. Because this is a <strong>security release</strong>, it is recommended that you update your sites immediately. All versions since WordPress 3.7 have also been updated.</p>\n\n\n\n<p>WordPress 6.0.2 is a short-cycle release. You can review a summary of the main updates in this release by reading the <a href=\"https://make.wordpress.org/core/2022/08/23/wordpress-6-0-2-rc1-is-now-available/\">RC1 announcement</a>.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-1/\">version 6.1</a> planned for November 1, 2022.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.0.2.zip\">download WordPress 6.0.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-0-2\">visit the HelpHub site</a>.</p>\n\n\n\n<h2>Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for responsibly reporting vulnerabilities, and allowing them to be fixed in this release:</p>\n\n\n\n<ul>\n<li>Fariskhi Vidyan for finding a possible SQL injection within the Link API.</li>\n\n\n\n<li><a href=\"https://hackerone.com/entropy1337\">Khalilov Moe</a> for finding an XSS vulnerability on the Plugins screen.</li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> of the WordPress security team, for finding an output escaping issue within <code>the_meta()</code>.</li>\n</ul>\n\n\n\n<h2>Thank you to these WordPress contributors</h2>\n\n\n\n<p>The WordPress 6.0.2 release was led by <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">@sergeybiryukov</a> and <a href=\"https://profiles.wordpress.org/gziolo/\">@gziolo</a>.</p>\n\n\n\n<p>WordPress 6.0.2 would not have been possible without the contributions of more than 50 people. Their asynchronous coordination to deliver several enhancements and fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>,&nbsp;<a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/uofaberdeendarren/\">Darren Coutts</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>,&nbsp;<a href=\"https://profiles.wordpress.org/martinkrcho/\">eMKey</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/huubl/\">huubl</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jonmackintosh/\">jonmackintosh</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/paulkevan/\">paulkevan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a>,&nbsp;<a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>,&nbsp;<a href=\"https://profiles.wordpress.org/tommusrhodus/\">tommusrhodus</a>,&nbsp;<a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/webcommsat/\">webcommsat AbhaNonStopNewsUK</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Aug 2022 19:39:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Do The Woo Community: Builder Tips from WordCampUS Speakers Part_1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72834\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://dothewoo.io/builder-tips-from-wordcampus-speakers-part_1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:418:\"<p>Listen in to these WooCommerce / WordPress builder tips from Chris Lubkert, Michelle Schulp, Joey Daoud, Maddy Osman and Phil Crumm.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/builder-tips-from-wordcampus-speakers-part_1/\">Builder Tips from WordCampUS Speakers Part_1</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Aug 2022 09:17:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: WP-Optimize Plugin Accused of Cheating PageSpeed and Other Performance Testing Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137404\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/wp-optimize-plugin-accused-of-cheating-pagespeed-and-other-performance-testing-tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9158:\"<p><a href=\"https://wpspeedmatters.com/\">Gijo Varghese</a>, a developer who calls himself a &#8220;web performance enthusiast,&#8221; shocked WordPress users around the world over the weekend when he tweeted a screenshot of how <a href=\"https://wordpress.org/plugins/wp-optimize/\">WP-Optimize</a> is allegedly preventing select JavaScript files from loading when users test their sites through popular performance testing tools.</p>\n\n\n\n<p>&#8220;When a site is loaded, the JavaScript files are loaded only when the user-agent/browser is not Lighthouse/GTmetrix/Headless Chrome/Pingdom,&#8221; Varghese said. &#8220;No JS = high scores. But for real users, these JS files are loaded!&#8221;</p>\n\n\n\n<p> </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f6a8.png\" alt=\"🚨\" class=\"wp-smiley\" /> How \"WP Optimize\" is cheating PageSpeed and other testing tools <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f447.png\" alt=\"👇\" class=\"wp-smiley\" /><br /><br />When a site is loaded, the JavaScript files are loaded only when the user-agent/browser is not Lighthouse/GTmetrix/Headless Chrome/Pingdom.<br /><br />No JS = high scores. But for real users, these JS files are loaded! <a href=\"https://t.co/uuOiAOgvoo\">pic.twitter.com/uuOiAOgvoo</a></p>&mdash; Gijo Varghese (@GijoVarghese_) <a href=\"https://twitter.com/GijoVarghese_/status/1563097754322501632?ref_src=twsrc%5Etfw\">August 26, 2022</a></blockquote>\n</div>\n\n\n\n<p>Varghese confirmed that he was testing the free version of WP-Optimize, which is used on more than a million WordPress sites. UpdraftPlus acquired WP-Optimize in 2016 and claims that the tool &#8220;has everything you need to keep your website fast and thoroughly optimized.&#8221; A <a href=\"https://getwpo.com/\">commercial version</a> is also promoted through the free plugin that is hosted on WordPress.org.</p>\n\n\n\n<p>&#8220;Tell me, UpdraftPlus, how I&#8217;m supposed to continue trusting your company with my clients&#8217; backups when you use these deceptive and fraudulent practices?&#8221; one customer Adam Lowe <a href=\"https://twitter.com/adamslowe/status/1564325514319466503\">said</a> in response to Varghese&#8217;s discovery of the plugin not loading JS for performance tools. </p>\n\n\n\n<p>&#8220;Wow, all I can say is what an utter disappointment,&#8221; WordPress agency owner and developer Brian Jackson said.</p>\n\n\n\n<p>This type of alleged deception is eerily similar to a <a href=\"https://metacoffeedata.com/manipulating-google-lighthouse-results-scam-by-upwork-freelancer/\">scam</a> reported by someone who contracted a performance freelancer on Upwork who artificially manipulated Google Pagespeed results. Others participating in the discussion on Twitter compared it to the <a href=\"https://en.wikipedia.org/wiki/Volkswagen_emissions_scandal\">Volkswagon emissions scandal</a> where the carmaker was found to activate its emissions controls only during laboratory testing in order to meet the EPA&#8217;s requirements after a violation. The vehicles on the road emitted up to 40 times more nitrogen oxides while driving, as compared to how they performed in the rigged laboratory tests.</p>\n\n\n\n<p>Varghese and several other participants in the conversation concluded that this is why site owners should focus on what real world users are experiencing, instead of performance tool test scores.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Hopefully they wonder why their CrUX report data (or better, RUM data) didn\'t budge. The whole reasons we release CrUX publicly is to give developers some ground truth. There\'s endless ways to trick yourself into believing your lab data is representative of real users <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f61b.png\" alt=\"😛\" class=\"wp-smiley\" />.</p>&mdash; Rick Byers (@RickByers) <a href=\"https://twitter.com/RickByers/status/1564300948130123787?ref_src=twsrc%5Etfw\">August 29, 2022</a></blockquote>\n</div>\n\n\n\n<p>Even when focusing on real user experiences, site owners often rely on the tests to diagnose issues and see how a site&#8217;s performance can be improved. They don&#8217;t expect that a plugin will be hiding JS files from performance tools. Tricking the tests has eroded WP-Optimize&#8217;s credibility.</p>\n\n\n\n<p>&#8220;Wow. If true, this is as short sighted as it is inexcusable,&#8221; UpdraftPlus customer Johnathon William <a href=\"https://twitter.com/johnofhousejohn/status/1563216460737966080\">said</a>. &#8220;And it makes me wonder if I can trust their other product, UpdraftPlus, which I use to backup several client sites.&#8221; </p>\n\n\n\n<p>I contacted UpdraftPlus and lead developer David Anderson said the company was not aware of the issue with the code but related some of the backstory. UpdraftPlus was briefly in talks with the author of the <a href=\"https://wordpress.org/plugins/fast-velocity-minify/\">Fast Velocity Minify</a> plugin about the possibility of combining forces, in which he would maintain the minification module within WP-Optimize and gain more users. Ultimately they could not come to an agreement, but during that time WP-Optimize&#8217;s developers forked and adapted Fast Velocity Minify under the GPL. The developers who worked on that adaption are no longer with the company.</p>\n\n\n\n<p>&#8220;In the commit to our own source repository, 2.5 years ago (Jan 2020), the commit was labelled &#8216;Resolve &#8216;Add CSS and JS Minification GPL code from &#8216;Fast Velocity Minify&#8217; &#8211; Part 6&#8242;,&#8221; Anderson said. &#8220;Part of a series of initial merges of code that was re-factored to be cleaner and use our coding style preferences (but not change any functionality). So the apparent intention of the merge of those lines was to bring over refactored code without at that stage making any changes.</p>\n\n\n\n<p>&#8220;According to the commit history (i.e. the &#8216;git blame&#8217; function) no changes have been made to that code since, i.e. it is as-imported. (The history for WP Optimize is public in WordPress SVN too).&#8221;</p>\n\n\n\n<p>After a cursory examination of the code, Anderson concluded that his team may need to reexamine it, as they were not aware of what was added two years ago.</p>\n\n\n\n<p>&#8220;As I try to trace that function through the code within the plugins, the intention&nbsp;<strong>on the face of it</strong>&nbsp;appears to be that if the website visitor is a &#8216;bot,&#8217; then code that is pointless for bots won&#8217;t be carried out,&#8221; he said.</p>\n\n\n\n<p>&#8220;However having said that, 1) the bot names look to be heavily obfuscated/redacted, which is strange (why?), and&nbsp; 2) there are plenty of more obvious bots that aren&#8217;t listed there, such as the Googlebot itself. If that function was being put before me for review today, I&#8217;d certainly question why that is so. I can&#8217;t mind-read myself back 32 months ago, but, I remember it as being a long series of large patches, so it wasn&#8217;t being closely analysed on a line-by-line basis. We knew that we had identified FVM as a good plugin and our main focus was on adapting it to our structure and style, and those were the things I personally was looking at as the final reviewer.&#8221;</p>\n\n\n\n<p>In summary, UpdraftPlus&#8217; development team was not aware of this code until the Twitter thread was published over the weekend.</p>\n\n\n\n<p>&#8220;I&#8217;m certainly glad to have it brought to our intention,&#8221; Anderson said. &#8220;The associated code comment on a related fragment in its original source that it&#8217;s intended to prevent unnecessary requests for bots, but on a closer examination than that line got at the time, that&#8217;s something we&#8217;ll want to look at, as it does look questionable/strange, and we&#8217;ll be doing that by assigning it to a team member who&#8217;s our expert in JavaScript optimizations.&#8221;</p>\n\n\n\n<p>Anderson also said that if the JavaScript optimization experts cannot find any legitimate purpose for the code, &#8220;it will certainly be removed,&#8221; with a clear and unambiguous disclosure for the reasoning behind it.</p>\n\n\n\n<p>In the meantime, UpdraftPlus has <a href=\"https://wordpress.org/support/topic/code-under-investigate-in-wp-optimize/#utm_medium=referral&utm_source=facebook.com&utm_content=social\">published a notice</a> in the plugin&#8217;s support forum to inform users that the code is currently under investigation.</p>\n\n\n\n<p>&#8220;To be clear and set users’ minds at rest: the code in question is not dangerous, a virus, an infection, useful to hackers, or anything of that kind,&#8221; Anderson said. &#8220;The allegation is that its only purpose in existing is effectively to cheat on speed tests. Such code, if so, does not belong in WP Optimize and we will remove it with a new release. Our products’ integrity, and our customers’ trust, are essential for us (and deliberately putting things in open source code that compromises that is, frankly, a stupid thing to do).&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Aug 2022 23:15:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Matt: Sonic Sphere and Empyrean Gate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=60315\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://ma.tt/2022/08/sonic-sphere-and-empyrean-gate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1266:\"<p>If I had to pick one reason why I&#8217;d suggest every person should attend Burning Man at least once, it would be the art. (Second reason would be seeing <a href=\"https://burningman.org/about/10-principles/\">the principles in action</a>.) This year I am particularly excited to support two pieces, the first being the <a href=\"https://sonicsphere.art/\">Sonic Sphere</a> which has this great video introducing it:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>I got a chance to try out a smaller prototype of this and it was a great experience. You can read a bit about the history of the Kugel Auditorium that this is based on on <a href=\"https://ed.blog/2021/02/28/which-is-better-a-bitcoin-or-a-spherical-concert-hall/\">Ed Cooke&#8217;s blog post Which is more memorable, a Bitcoin or a Spherical Concert Hall?</a> The Sphere will be in <a href=\"https://what3words.com/circulation.later.chart\">Deep Playa (what3words)</a>. </p>\n\n\n\n<p>Another exciting new project is the <a href=\"https://www.entheosrising.org/empyrean-gate-art-installation\">Empyrean Gate at the Entheos camp</a>, which will be at 3 and Esplanade. Here are some renderings but I can&#8217;t wait to see how it turns out in person.</p>\n\n\n\n\n<img />\n\n\n\n<img />\n\n\n\n<img />\n\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 27 Aug 2022 16:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Catch Themes Releases Pentatonic: A New Block Theme for Bands and Musicians\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=137282\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/catch-themes-releases-pentatonic-a-new-block-theme-for-bands-and-musicians\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2525:\"<p>Block themes are expanding to include more niches beyond the simple one-column blogging themes, and <a href=\"https://catchthemes.com/\">Catch Themes</a> is one of the companies at the forefront of this new frontier. <a href=\"https://wordpress.org/themes/pentatonic/\">Pentatonic</a>, the company&#8217;s latest release on WordPress.org, is a free theme created for band and musicians.</p>\n\n\n\n<p>The theme uses core blocks to create sections that showcase the work of creative artists of all kinds. For example, the header uses the Cover block featuring a gradient image with the focal point picker set at a certain point. Site identity and navigation are organized within a group, followed by a Media and Text block header section. </p>\n\n\n\n<p>Upon install and activation, Pentatonic delivers a good experience for users. Clicking &#8220;Customize&#8221; takes users to the Site Editor with the front page loaded, looking nearly identical to the demo for the <a href=\"https://fse.catchthemes.com/pentatonic-free/\">free version</a>.</p>\n\n\n\n<img />\n\n\n\n<p>Pentatonic comes with 17 block patterns that users can easily mix and match to create their own unique pages. These include patterns for About Us, Call to Action, Featured Content, Sidebar, Music Podcasts, 404 Header, Archive header, Default footer, Footer with three columns, Default header, Recent with blog sidebar, Post header, Header with buttons, and more. Each section on the homepage can be recreated using a pattern on other pages or repeated/rearranged on the front page.</p>\n\n\n\n<img />\n\n\n\n<p>The theme also includes 11 templates and eight template parts, allowing users to make customizations to the 404 page, blog single posts, search results, post content, and others. </p>\n\n\n\n<p>The pro version of the theme includes access to custom blocks, such as a playlist, case study, skills bar, masonry, popup video, and more. The <a href=\"https://fse.catchthemes.com/pentatonic-pro/\">demo for the pro version</a> has a sticky music player at the bottom of the page, promotional popup video, podcast playlist, and other custom media additions that bands and artists may require.</p>\n\n\n\n<p>Pentatonic has been optimized to respond well to all screen sizes and looks just as good on mobile as it does on desktop. The theme is <a href=\"https://wordpress.org/themes/pentatonic/\">available for free on WordPress.org</a> where you can preview all the patterns and check out a preview of the whole theme in action that strongly resembles the demo hosted on Catch Themes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Aug 2022 21:38:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Post Status: Tech Roundup for the Week of August 22\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=106848\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://poststatus.com/tech-roundup-for-the-week-of-august-22/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5489:\"<div class=\"wp-container-7 wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">DigitalOcean\'s acquisition of Cloudways • Stop saying &#8220;Gutenberg!&#8221; • Build Mode Live with Brian Gardner and Sam Munoz • One week left to submit a style variation for TT3 • Cool Tool of the Week: Munir Kamal\'s Editor Plus </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">3</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n<h2 id=\"h-wordpress-development-around-the-web\">WordPress Development Around the Web</h2>\n\n\n\n<p><em>A glimpse of what’s going on in the world of development and design in the WordPress space.</em></p>\n\n\n\n<p><a href=\"https://www.bloomberg.com/news/articles/2022-08-23/digitalocean-to-buy-web-hosting-firm-cloudways-for-350-million\">Huge news in the hosting space</a>! <strong>DigitalOcean</strong> is set to acquire <strong>Cloudways</strong> for $350 million (USD). From a development perspective I hope this enables Cloudways to innovate even more in the coming years, but it does immediately pose the question: will DigitalOcean keep their competitors\' hosting services available on Cloudways. All signs point to the same business-as-usual, but only time will truly tell. Regardless, big congrats to Post Status members over there, <strong>Robert Jacobi</strong> and <strong>Zach Stepek</strong>.</p>\n\n\n\n<p><strong>Fränk Klein</strong> over at WordPress agency <strong>Human Made</strong> is asking us to <a href=\"https://humanmade.com/2022/08/24/can-we-please-stop-saying-gutenberg/\">stop saying ‘Gutenberg’.</a> This makes sense. We need to have a consistent vocabulary on how we talk about these things to each other and to stakeholders so we all understand what we’re discussing. I’ve gotten into the habit of saying “the Block Editor” when talking about the new interface for page building in core, but I never thought that we could also break down explaining the various parts to full site editing as well. Human Made does a good job of clarifying all of this, and it might even be a great addition to the WordPress documentation to have all these defined right up front somewhere.</p>\n\n\n\n<p>Speaking of hosting companies, Post Status members <strong>Sam Munoz</strong> and <strong>Brian Gardner</strong> from <strong>WPEngine</strong> have started <a href=\"https://wpengine.com/builders/build-mode-live-july-2022-sessions/\">a regular Zoom meeting</a> called <strong>Build Mode Live</strong> to help anyone with their questions and struggles around full site editing, the block editor, WordPress, and how it all impacts business owners. They’re bringing a design, development, builder, and business owner perspective to an area where we haven’t seen much open discussion. <a href=\"https://calendly.com/bgardner-wpe/build-mode?month=2022-09\">You can sign up to participate right now</a>!</p>\n\n\n\n<p>On the <strong>Make WordPress Design</strong> blog <strong>Channing Ritter</strong>, Design Director at <strong>Automattic</strong>, shared a reminder that there is <a href=\"https://make.wordpress.org/design/2022/08/24/tt3-default-theme-one-week-left-to-submit-style-variations/\">one week left to submit a variation to be included in the new Twenty Twenty Three theme</a> (TT3). There’s a <strong>Figma</strong> file <a href=\"https://make.wordpress.org/design/2022/08/10/twenty-twenty-three-default-theme-project-kickoff/\">attached to Channing\'s kickoff post</a> you can use for the variations. This builds on <a href=\"https://poststatus.com/tech-roundup-for-the-week-of-august-15-2022/\">the tools I shared last week</a> that reinforce the importance of a build flow from Figma to WordPress. All of it is very encouraging! It\'s great to see this process improving.</p>\n\n\n\n<div class=\"wp-container-8 wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<h2 id=\"h-cool-tool\">Cool Tool</h2>\n\n\n\n<p>Each week we’ll feature one cool tool that can help make your life easier as a WordPress builder.</p>\n\n\n\n<h3 class=\"has-theme-palette-1-color has-text-color\"><a href=\"https://wpeditorplus.com\"><span>Editor Plus</span></a></h3>\n\n\n\n<p>Have you been struggling with the lack of features in the block editor that you’ve grown accustomed to having in a page builder? <a href=\"https://wpeditorplus.com\">That is where <strong>Editor Plus</strong> comes in</a>! It helps you set background, margin, padding, icons, tabs, accordions, ratings, and even animation. I like most that these settings also stay in place even when you switch themes, keeping it from locking you into a specific theme forever. The plugin is led by serial developer <strong>Munir Kamal</strong>, who also runs <strong>Editors Kit</strong> and <strong>Gutenberg Hub</strong>. A bonus for users of this plugin is that there are also a ton of great video tutorials on how to extend Editor Plus to do almost anything.</p>\n</div></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Aug 2022 16:46:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Daniel Schutzsmith\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 15 Sep 2022 01:44:33 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Thu, 15 Sep 2022 01:30:33 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";s:16:\"content-encoding\";s:2:\"br\";}}s:5:\"build\";s:14:\"20211220193300\";}", "no");
INSERT INTO `wp_options` VALUES("144", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("4282", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1663249473", "no");
INSERT INTO `wp_options` VALUES("4283", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1663206273", "no");
INSERT INTO `wp_options` VALUES("4284", "_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b", "1663249473", "no");
INSERT INTO `wp_options` VALUES("4285", "_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2022/09/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\'>Dropping security updates for WordPress versions 3.7 through 4.0</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2022/09/the-month-in-wordpress-august-2022/\'>The Month in WordPress – August 2022</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/woocommerce-6-9-released-high-performance-order-storage-targeted-for-7-1\'>WPTavern: WooCommerce 6.9 Released, High-Performance Order Storage Targeted for 7.1</a></li><li><a class=\'rsswidget\' href=\'https://poststatus.com/wp-6-1-walkthrough-replay-webp-no-go-matt-core-needs-to-be-more-editorial-survey-how-do-you-learn-wordpress/\'>Post Status: WP 6.1 walkthrough replay • WebP no go • Matt: Core needs to be more editorial • Survey: How do you learn WordPress?</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/podcast/42-marcel-schmitz-on-finding-work-with-codeable-and-working-with-woocommerce\'>WPTavern: #42 – Marcel Schmitz on Finding Work With Codeable and Working With WooCommerce</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("4286", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1663217084", "no");
INSERT INTO `wp_options` VALUES("4287", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:5732;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4800;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2765;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2640;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2038;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1885;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1885;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1592;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1551;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1535;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1529;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1511;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1496;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1395;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1338;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1259;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1173;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1146;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1122;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1026;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:986;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:979;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:947;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:899;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:863;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:853;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:849;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:848;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:845;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:821;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:782;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:775;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:774;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:763;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:759;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:732;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:728;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:727;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:713;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:709;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:702;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:677;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:677;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:676;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:673;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:666;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:666;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:623;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:612;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:604;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:602;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:599;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:591;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:585;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:581;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:579;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:578;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:573;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:565;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:559;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:555;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:539;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:538;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:535;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:531;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:529;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:522;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:521;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:511;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:506;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:506;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:503;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:501;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:501;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:487;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:466;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:463;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:462;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:450;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:446;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:443;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:440;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:434;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:427;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:422;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:419;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:416;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:414;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:407;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:406;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:401;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:400;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:399;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:394;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:392;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:385;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:383;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:379;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:379;}}", "no");
INSERT INTO `wp_options` VALUES("4290", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1663206309;s:8:\"response\";a:4:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.0\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.2\";s:12:\"requires_php\";b:0;}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.7.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=2622511\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=2597493\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=2597493\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=2597493\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=2597493\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.2\";s:12:\"requires_php\";s:3:\"7.0\";}s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:49:\"w.org/plugins/essential-addons-for-elementor-lite\";s:4:\"slug\";s:35:\"essential-addons-for-elementor-lite\";s:6:\"plugin\";s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";s:11:\"new_version\";s:5:\"5.2.4\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/essential-addons-for-elementor-lite/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/essential-addons-for-elementor-lite.5.2.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/icon-256x256.png?rev=2598498\";s:2:\"1x\";s:88:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/icon-128x128.png?rev=2598498\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/banner-1544x500.gif?rev=2777119\";s:2:\"1x\";s:90:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/banner-772x250.gif?rev=2777119\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.2\";s:12:\"requires_php\";s:3:\"5.6\";}s:31:\"elementor-pro/elementor-pro.php\";O:8:\"stdClass\":17:{s:14:\"stable_version\";s:5:\"3.7.6\";s:12:\"last_updated\";s:19:\"2022-05-10 14:03:37\";s:11:\"new_version\";s:5:\"3.7.6\";s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:3:\"url\";s:36:\"https://elementor.com/pro/changelog/\";s:8:\"homepage\";s:26:\"https://elementor.com/pro/\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.2\";s:18:\"elementor_requires\";s:5:\"3.0.1\";s:7:\"package\";s:246:\"https://plugin-downloads.elementor.com/v1/plugin/package_download/MTY2MzI5MjcwNTplcC1USlVLQWpJUEZvMjhlTzBodmxncjE2MTU0NDExNjRTRE95NUJPZTNVOHM6MToyOGM1MDI3NmUwZGQwOWIzZDAxMWZkNTAwMzVhYmZiODpodHRwc0AvL3Nsay5sd2kubXlibHVlaG9zdC5tZS9uYXRpb25hbHM6MA==\";s:13:\"download_link\";s:246:\"https://plugin-downloads.elementor.com/v1/plugin/package_download/MTY2MzI5MjcwNTplcC1USlVLQWpJUEZvMjhlTzBodmxncjE2MTU0NDExNjRTRE95NUJPZTNVOHM6MToyOGM1MDI3NmUwZGQwOWIzZDAxMWZkNTAwMzVhYmZiODpodHRwc0AvL3Nsay5sd2kubXlibHVlaG9zdC5tZS9uYXRpb25hbHM6MA==\";s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:5:\"icons\";a:1:{s:3:\"svg\";s:75:\"https://storage.googleapis.com/web-public-files/Web%20Assets/icons/icon.svg\";}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:12:{s:11:\"new_version\";s:5:\"3.7.0\";s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:3:\"url\";s:36:\"https://elementor.com/pro/changelog/\";s:8:\"homepage\";s:26:\"https://elementor.com/pro/\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.2\";s:18:\"elementor_requires\";s:5:\"3.0.1\";s:7:\"package\";s:251:\"https://plugin-downloads.elementor.com/v1/plugin/previous_download/MTY2MzI5MjcwNTplcC1USlVLQWpJUEZvMjhlTzBodmxncjE2MTU0NDExNjRTRE95NUJPZTNVOHM6MTozLjcuMDo0MDNhZGIwMDYwNTZmNWVjNWRiNmZjMjI2YjkyMzQyZDpodHRwc0AvL3Nsay5sd2kubXlibHVlaG9zdC5tZS9uYXRpb25hbHM=\";s:13:\"download_link\";s:251:\"https://plugin-downloads.elementor.com/v1/plugin/previous_download/MTY2MzI5MjcwNTplcC1USlVLQWpJUEZvMjhlTzBodmxncjE2MTU0NDExNjRTRE95NUJPZTNVOHM6MTozLjcuMDo0MDNhZGIwMDYwNTZmNWVjNWRiNmZjMjI2YjkyMzQyZDpodHRwc0AvL3Nsay5sd2kubXlibHVlaG9zdC5tZS9uYXRpb25hbHM=\";s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:5:\"icons\";a:1:{s:3:\"svg\";s:75:\"https://storage.googleapis.com/web-public-files/Web%20Assets/icons/icon.svg\";}}s:10:\"conditions\";a:1:{i:0;a:1:{i:0;a:3:{s:4:\"type\";s:8:\"language\";s:9:\"languages\";a:27:{i:0;s:5:\"he_IL\";i:1;s:5:\"nl_NL\";i:2;s:5:\"en_GB\";i:3;s:5:\"en_NZ\";i:4;s:5:\"en_ZA\";i:5;s:5:\"en_AU\";i:6;s:5:\"en_CA\";i:7;s:5:\"sv_SE\";i:8;s:5:\"da_DK\";i:9;s:5:\"fr_FR\";i:10;s:5:\"nl_NL\";i:11;s:5:\"nb_NO\";i:12;s:5:\"de_AT\";i:13;s:2:\"fi\";i:14;s:5:\"it_IT\";i:15;s:5:\"nn_NO\";i:16;s:5:\"de_CH\";i:17;s:5:\"en_GB\";i:18;s:5:\"is_IS\";i:19;s:2:\"ga\";i:20;s:5:\"fr_BE\";i:21;s:5:\"nl_BE\";i:22;s:3:\"ast\";i:23;s:5:\"lb_LU\";i:24;s:5:\"es_ES\";i:25;s:5:\"pt_PT\";i:26;s:3:\"mlt\";}s:8:\"operator\";s:2:\"in\";}}}}s:5:\"cloud\";b:0;s:6:\"plugin\";s:31:\"elementor-pro/elementor-pro.php\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:4:{s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.5.0\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2605836\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2605835\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:51:\"insert-php-code-snippet/insert-php-code-snippet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:37:\"w.org/plugins/insert-php-code-snippet\";s:4:\"slug\";s:23:\"insert-php-code-snippet\";s:6:\"plugin\";s:51:\"insert-php-code-snippet/insert-php-code-snippet.php\";s:11:\"new_version\";s:5:\"1.3.3\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/insert-php-code-snippet/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/insert-php-code-snippet.1.3.3.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/insert-php-code-snippet/assets/icon-128x128.png?rev=1800967\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:78:\"https://ps.w.org/insert-php-code-snippet/assets/banner-772x250.jpg?rev=1800967\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"2.8\";}s:27:\"sportspress/sportspress.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/sportspress\";s:4:\"slug\";s:11:\"sportspress\";s:6:\"plugin\";s:27:\"sportspress/sportspress.php\";s:11:\"new_version\";s:6:\"2.7.15\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/sportspress/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/sportspress.2.7.15.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/sportspress/assets/icon-256x256.png?rev=1252005\";s:2:\"1x\";s:64:\"https://ps.w.org/sportspress/assets/icon-128x128.png?rev=1252005\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/sportspress/assets/banner-1544x500.png?rev=1405496\";s:2:\"1x\";s:66:\"https://ps.w.org/sportspress/assets/banner-772x250.png?rev=1405496\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.8\";}}s:7:\"checked\";a:8:{s:19:\"akismet/akismet.php\";s:5:\"4.2.5\";s:25:\"duplicator/duplicator.php\";s:5:\"1.5.0\";s:23:\"elementor/elementor.php\";s:5:\"3.7.2\";s:31:\"elementor-pro/elementor-pro.php\";s:5:\"3.7.6\";s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";s:5:\"5.2.3\";s:9:\"hello.php\";s:5:\"1.7.2\";s:51:\"insert-php-code-snippet/insert-php-code-snippet.php\";s:5:\"1.3.3\";s:27:\"sportspress/sportspress.php\";s:6:\"2.7.15\";}}", "no");
INSERT INTO `wp_options` VALUES("4291", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.5.0\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4292", "duplicator_version_plugin", "1.5.0", "yes");
INSERT INTO `wp_options` VALUES("4297", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-09-15 01:46:30\";s:7:\"Version\";s:5:\"1.5.0\";s:9:\"VersionWP\";s:5:\"6.0.2\";s:9:\"VersionDB\";s:6:\"5.7.39\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20220915_thenationals\";s:4:\"Hash\";s:35:\"e76d8f6d82fd8a761054_20220915014630\";s:8:\"NameHash\";s:57:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:67:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:36:\"/home/slklwimy/public_html/nationals\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1110;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7002;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-09-15 01:46:30\";s:7:\"Version\";s:5:\"1.5.0\";s:9:\"VersionWP\";s:5:\"6.0.2\";s:9:\"VersionDB\";s:6:\"5.7.39\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20220915_thenationals\";s:4:\"Hash\";s:35:\"e76d8f6d82fd8a761054_20220915014630\";s:8:\"NameHash\";s:57:\"20220915_thenationals_e76d8f6d82fd8a761054_20220915014630\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:50:\"/home/slklwimy/public_html/nationals/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:45:\"/home/slklwimy/public_html/nationals/wp-admin\";i:1;s:48:\"/home/slklwimy/public_html/nationals/wp-includes\";i:2;s:57:\"/home/slklwimy/public_html/nationals/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:36:\"/home/slklwimy/public_html/nationals\";i:1;s:36:\"/home/slklwimy/public_html/nationals\";i:2;s:47:\"/home/slklwimy/public_html/nationals/wp-content\";i:3;s:55:\"/home/slklwimy/public_html/nationals/wp-content/uploads\";i:4;s:55:\"/home/slklwimy/public_html/nationals/wp-content/plugins\";i:5;s:58:\"/home/slklwimy/public_html/nationals/wp-content/mu-plugins\";i:6;s:54:\"/home/slklwimy/public_html/nationals/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:68:\"/home/slklwimy/public_html/nationals/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:143;}", "yes");
INSERT INTO `wp_options` VALUES("631", "_transient_health-check-site-status-result", "{\"good\":14,\"recommended\":5,\"critical\":0}", "yes");
INSERT INTO `wp_options` VALUES("154", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("176", "eael_setup_wizard", "complete", "yes");
INSERT INTO `wp_options` VALUES("177", "eael_save_settings", "a:54:{s:9:\"post-grid\";s:0:\"\";s:13:\"post-timeline\";s:0:\"\";s:10:\"fancy-text\";i:1;s:12:\"creative-btn\";i:1;s:10:\"count-down\";i:1;s:12:\"team-members\";i:1;s:12:\"testimonials\";i:1;s:8:\"info-box\";i:1;s:8:\"flip-box\";i:1;s:14:\"call-to-action\";i:1;s:11:\"dual-header\";i:1;s:11:\"price-table\";i:1;s:12:\"twitter-feed\";s:0:\"\";s:13:\"facebook-feed\";s:0:\"\";s:19:\"advanced-data-table\";s:0:\"\";s:10:\"data-table\";i:1;s:14:\"filter-gallery\";i:1;s:15:\"image-accordion\";i:1;s:14:\"content-ticker\";i:1;s:7:\"tooltip\";i:1;s:13:\"adv-accordion\";i:1;s:8:\"adv-tabs\";i:1;s:12:\"progress-bar\";i:1;s:12:\"feature-list\";i:1;s:12:\"product-grid\";s:0:\"\";s:14:\"contact-form-7\";s:0:\"\";s:7:\"weforms\";s:0:\"\";s:10:\"ninja-form\";s:0:\"\";s:9:\"formstack\";s:0:\"\";s:12:\"gravity-form\";s:0:\"\";s:12:\"caldera-form\";s:0:\"\";s:7:\"wpforms\";s:0:\"\";s:10:\"fluentform\";s:0:\"\";s:8:\"typeform\";s:0:\"\";s:24:\"betterdocs-category-grid\";s:0:\"\";s:23:\"betterdocs-category-box\";s:0:\"\";s:22:\"betterdocs-search-form\";s:0:\"\";s:12:\"sticky-video\";i:1;s:14:\"event-calendar\";s:0:\"\";s:10:\"embedpress\";i:1;s:24:\"crowdfundly-organization\";i:1;s:24:\"crowdfundly-all-campaign\";i:1;s:27:\"crowdfundly-single-campaign\";i:1;s:12:\"woo-checkout\";s:0:\"\";s:8:\"woo-cart\";s:0:\"\";s:14:\"login-register\";s:0:\"\";s:18:\"woocommerce-review\";i:1;s:11:\"career-page\";i:1;s:19:\"woo-product-compare\";s:0:\"\";s:20:\"woo-product-carousel\";s:0:\"\";s:11:\"simple-menu\";i:1;s:19:\"woo-product-gallery\";s:0:\"\";s:18:\"interactive-circle\";s:0:\"\";s:14:\"better-payment\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "wpdeveloper_plugins_data", "a:1:{s:25:\"essential_adons_elementor\";a:3:{s:16:\"notice_will_show\";a:1:{s:6:\"review\";i:1663913643;}s:4:\"time\";i:1661235171;s:7:\"version\";s:5:\"5.2.3\";}}", "yes");
INSERT INTO `wp_options` VALUES("179", "eael_version", "5.2.3", "yes");
INSERT INTO `wp_options` VALUES("185", "wpins_block_notice", "a:1:{s:25:\"essential_adons_elementor\";s:25:\"essential_adons_elementor\";}", "yes");
INSERT INTO `wp_options` VALUES("161", "elementor_active_kit", "5", "yes");
INSERT INTO `wp_options` VALUES("170", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:3:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:825:{i:0;a:16:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:16:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:16:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:16:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:16:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:16:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:16:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:16:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:16:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:16:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:16:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:16:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:16:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:16:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:16:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:16:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:16:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:16:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:16:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:16:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:16:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:16:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:16:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:16:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:16:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:16:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:16:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:16:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:16:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:16:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:16:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:16:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:16:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:16:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:16:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:16:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:16:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:16:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:16:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:16:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:16:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:16:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:16:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:16:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:16:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:16:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:16:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:16:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:16:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:16:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:16:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:16:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:16:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:16:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:16:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:16:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:16:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:16:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:16:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:16:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:16:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:16:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:16:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:16:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:16:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:16:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:16:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:16:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:16:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:16:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:16:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:16:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:16:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:16:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:16:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:16:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:16:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:16:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:16:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:16:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:16:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:16:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:16:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:16:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:16:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:16:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:16:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:16:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:16:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:16:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:16:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:16:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:16:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:16:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:16:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:16:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:16:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:16:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:16:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:16:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:16:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:16:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:16:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:16:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:16:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:16:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:16:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:16:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:16:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:16:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:16:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:16:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:16:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:16:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:16:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:16:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:16:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:16:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:16:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:119;a:16:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:120;a:16:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:16:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:16:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:16:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:16:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:125;a:16:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:126;a:16:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:16:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:16:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:16:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:16:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:16:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:16:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:16:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:16:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:16:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:16:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:16:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:16:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:16:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:16:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:16:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:16:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:143;a:16:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:16:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:145;a:16:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:16:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:16:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:16:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:16:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:16:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:16:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:16:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:16:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:16:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:16:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:16:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:16:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:16:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:159;a:16:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:160;a:16:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:16:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:162;a:16:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:163;a:16:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:164;a:16:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:165;a:16:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:166;a:16:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:16:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:16:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:16:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:170;a:16:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:171;a:16:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:172;a:16:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:16:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:174;a:16:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:16:{s:4:\"tmpl\";i:1204;s:2:\"id\";i:20208;s:5:\"title\";s:49:\"Alternative Medicine Acupuncture &#8211; Business\";s:9:\"thumbnail\";s:112:\"https://library.elementor.com/wp-content/uploads/2021/10/Alternative-Medicine-Acupuncture-Business-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633880557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/lp/alternative-medicine-acupuncture-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:47:\"[\"Health\",\"Landing Pages\",\"Medical\",\"Services\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:176;a:16:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:16:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:16:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:16:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:16:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:181;a:16:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:182;a:16:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:183;a:16:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:184;a:16:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:185;a:16:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:186;a:16:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:187;a:16:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:188;a:16:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:189;a:16:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:16:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:191;a:16:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:192;a:16:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:193;a:16:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:16:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:16:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:196;a:16:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:197;a:16:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:16:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:16:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:16:{s:4:\"tmpl\";i:1215;s:2:\"id\";i:20556;s:5:\"title\";s:41:\"Faroe Islands Trip Planner &#8211; Travel\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Faroe-Islands-Trip-Planner-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634026480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/faroe-islands-trip-planner-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:26:\"[\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:201;a:16:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:16:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:16:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:204;a:16:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:16:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:16:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:207;a:16:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:16:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:209;a:16:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:16:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:211;a:16:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:16:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:213;a:16:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:16:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:16:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:216;a:16:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:16:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:218;a:16:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:219;a:16:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:220;a:16:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:221;a:16:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:16:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:223;a:16:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:16:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:225;a:16:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:226;a:16:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:16:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:228;a:16:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:16:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:230;a:16:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:231;a:16:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:232;a:16:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:16:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:16:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:235;a:16:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:16:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:237;a:16:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:16:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:239;a:16:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:16:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:241;a:16:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:16:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:16:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:16:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:16:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:16:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:16:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:16:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:16:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:16:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:16:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:252;a:16:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:16:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:254;a:16:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:255;a:16:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:256;a:16:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:16:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:258;a:16:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:16:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:260;a:16:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:261;a:16:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:16:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:263;a:16:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:264;a:16:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:16:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:16:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:16:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:268;a:16:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:269;a:16:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:16:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:271;a:16:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:272;a:16:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:16:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:274;a:16:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:16:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:16:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:277;a:16:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:278;a:16:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:279;a:16:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:16:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:281;a:16:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:16:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:16:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:16:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:285;a:16:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:286;a:16:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:287;a:16:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:288;a:16:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:289;a:16:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:290;a:16:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:16:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:16:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:16:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:16:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:16:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:296;a:16:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:16:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:16:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:16:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:16:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:301;a:16:{s:4:\"tmpl\";i:689;s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:16:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:16:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:16:{s:4:\"tmpl\";i:690;s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:16:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:16:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:307;a:16:{s:4:\"tmpl\";i:691;s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:308;a:16:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:16:{s:4:\"tmpl\";i:692;s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:16:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:16:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:16:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:16:{s:4:\"tmpl\";i:997;s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:16:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:16:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:16:{s:4:\"tmpl\";i:998;s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:16:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:318;a:16:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:16:{s:4:\"tmpl\";i:996;s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Footer\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:320;a:16:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:321;a:16:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:16:{s:4:\"tmpl\";i:995;s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Header\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:16:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:324;a:16:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:325;a:16:{s:4:\"tmpl\";i:994;s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:16:{s:4:\"tmpl\";i:1131;s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:327;a:16:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:16:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:329;a:16:{s:4:\"tmpl\";i:1130;s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Footer\",\"Hair\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:16:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:16:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:16:{s:4:\"tmpl\";i:1129;s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Hair\",\"Header\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:333;a:16:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:16:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:335;a:16:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:16:{s:4:\"tmpl\";i:641;s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"Archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:16:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:16:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:16:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:340;a:16:{s:4:\"tmpl\";i:484;s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:341;a:16:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:16:{s:4:\"tmpl\";i:487;s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:16:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:344;a:16:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:16:{s:4:\"tmpl\";i:491;s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:346;a:16:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:16:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:348;a:16:{s:4:\"tmpl\";i:488;s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:16:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:350;a:16:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:351;a:16:{s:4:\"tmpl\";i:490;s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:352;a:16:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:16:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:354;a:16:{s:4:\"tmpl\";i:496;s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:355;a:16:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:356;a:16:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:16:{s:4:\"tmpl\";i:486;s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:16:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:16:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:360;a:16:{s:4:\"tmpl\";i:495;s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:361;a:16:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:16:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:363;a:16:{s:4:\"tmpl\";i:493;s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:16:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:16:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:366;a:16:{s:4:\"tmpl\";i:485;s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:16:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:368;a:16:{s:4:\"tmpl\";i:482;s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:134;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:369;a:16:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:16:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:371;a:16:{s:4:\"tmpl\";i:483;s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:321;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:372;a:16:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:373;a:16:{s:4:\"tmpl\";i:492;s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:92;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:374;a:16:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:16:{s:4:\"tmpl\";i:489;s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:381;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:376;a:16:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:16:{s:4:\"tmpl\";i:494;s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:273;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:16:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:16:{s:4:\"tmpl\";i:425;s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:68;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:380;a:16:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:16:{s:4:\"tmpl\";i:423;s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:127;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:382;a:16:{s:4:\"tmpl\";i:534;s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:76;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:383;a:16:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:16:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:385;a:16:{s:4:\"tmpl\";i:535;s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:313;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:16:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:16:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:388;a:16:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:389;a:16:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:16:{s:4:\"tmpl\";i:430;s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:187;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:391;a:16:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:16:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:16:{s:4:\"tmpl\";i:476;s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:106;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:16:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:395;a:16:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:396;a:16:{s:4:\"tmpl\";i:478;s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:335;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:397;a:16:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:398;a:16:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\"