/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-11-22 03:47:57 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpgfi_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=419 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=3926 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_alm` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `repeaterDefault` longtext NOT NULL,
  `repeaterType` text NOT NULL,
  `pluginVersion` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wpgfi_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wpgfi_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int(11) DEFAULT '0',
  `actions_succeeded_count` int(11) DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=5364 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=12680 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1605 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_wpmailsmtp_debug_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `initiator` text COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpgfi_wpmailsmtp_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wpgfi_actionscheduler_actions */
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("389", "action_scheduler/migration_hook", "complete", "2023-10-25 09:00:17", "2023-10-25 09:00:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698224417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698224417;}", "1", "1", "2023-10-25 09:00:25", "2023-10-25 09:00:25", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("390", "action_scheduler/migration_hook", "failed", "2023-10-25 09:01:25", "2023-10-25 09:01:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698224485;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698224485;}", "1", "1", "2023-10-25 09:01:25", "2023-10-25 09:01:25", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("391", "wp_mail_smtp_summary_report_email", "complete", "2023-10-30 14:00:00", "2023-10-30 14:00:00", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698674400;s:18:\"\0*\0first_timestamp\";i:1698674400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698674400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2023-11-01 02:44:13", "2023-11-01 02:44:13", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("392", "wp_mail_smtp_admin_notifications_update", "complete", "2023-10-25 09:02:33", "2023-10-25 09:02:33", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698224553;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698224553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-10-25 09:02:50", "2023-10-25 09:02:50", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("393", "wp_mail_smtp_admin_notifications_update", "complete", "2023-10-26 09:02:50", "2023-10-26 09:02:50", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698310970;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698310970;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-10-26 09:03:21", "2023-10-26 09:03:21", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("394", "action_scheduler/migration_hook", "complete", "2023-10-26 05:17:58", "2023-10-26 05:17:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698297478;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698297478;}", "1", "1", "2023-10-26 05:18:27", "2023-10-26 05:18:27", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("395", "action_scheduler/migration_hook", "failed", "2023-10-26 05:19:27", "2023-10-26 05:19:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698297567;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698297567;}", "1", "1", "2023-10-26 05:19:40", "2023-10-26 05:19:40", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("396", "action_scheduler/migration_hook", "complete", "2023-10-26 06:17:14", "2023-10-26 06:17:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698301034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698301034;}", "1", "1", "2023-10-26 06:17:18", "2023-10-26 06:17:18", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("397", "wp_mail_smtp_admin_notifications_update", "complete", "2023-10-27 09:03:21", "2023-10-27 09:03:21", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698397401;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698397401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-10-27 15:48:47", "2023-10-27 15:48:47", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("398", "wp_mail_smtp_admin_notifications_update", "complete", "2023-10-28 15:48:47", "2023-10-28 15:48:47", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698508127;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698508127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-10-29 12:49:19", "2023-10-29 12:49:19", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("399", "wp_mail_smtp_admin_notifications_update", "complete", "2023-10-30 12:49:19", "2023-10-30 12:49:19", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698670159;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698670159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-01 02:44:11", "2023-11-01 02:44:11", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("402", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-04 02:03:18", "2023-11-04 02:03:18", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699063398;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699063398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-05 04:01:42", "2023-11-05 04:01:42", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("400", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-02 02:44:11", "2023-11-02 02:44:11", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698893051;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698893051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-03 02:03:18", "2023-11-03 02:03:18", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("401", "wp_mail_smtp_summary_report_email", "complete", "2023-11-08 02:44:13", "2023-11-08 02:44:13", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699411453;s:18:\"\0*\0first_timestamp\";i:1698674400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699411453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2023-11-08 05:16:02", "2023-11-08 05:16:02", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("403", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-06 04:01:42", "2023-11-06 04:01:42", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699243302;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699243302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-06 04:02:23", "2023-11-06 04:02:23", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("404", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-07 04:02:23", "2023-11-07 04:02:23", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699329743;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699329743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-07 04:02:27", "2023-11-07 04:02:27", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("405", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-08 04:02:27", "2023-11-08 04:02:27", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699416147;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699416147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-08 05:16:02", "2023-11-08 05:16:02", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("406", "wp_mail_smtp_summary_report_email", "complete", "2023-11-15 05:16:02", "2023-11-15 05:16:02", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700025362;s:18:\"\0*\0first_timestamp\";i:1698674400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700025362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2023-11-15 05:43:53", "2023-11-15 05:43:53", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("408", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-10 05:17:50", "2023-11-10 05:17:50", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699593470;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699593470;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-10 05:58:35", "2023-11-10 05:58:35", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("407", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-09 05:16:02", "2023-11-09 05:16:02", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699506962;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699506962;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-09 05:17:50", "2023-11-09 05:17:50", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("409", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-11 05:58:35", "2023-11-11 05:58:35", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699682315;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699682315;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-12 04:55:39", "2023-11-12 04:55:39", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("410", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-13 04:55:39", "2023-11-13 04:55:39", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699851339;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699851339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-13 07:20:11", "2023-11-13 07:20:11", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("411", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-14 07:20:11", "2023-11-14 07:20:11", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699946411;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699946411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-15 01:19:30", "2023-11-15 01:19:30", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("412", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-16 01:19:30", "2023-11-16 01:19:30", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700097570;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700097570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-16 02:54:06", "2023-11-16 02:54:06", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("413", "wp_mail_smtp_summary_report_email", "pending", "2023-11-22 05:43:53", "2023-11-22 05:43:53", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700631833;s:18:\"\0*\0first_timestamp\";i:1698674400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700631833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("414", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-17 02:54:06", "2023-11-17 02:54:06", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700189646;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700189646;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-18 03:29:17", "2023-11-18 03:29:17", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("415", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-19 03:29:17", "2023-11-19 03:29:17", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700364557;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700364557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-20 01:53:47", "2023-11-20 01:53:47", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("416", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-21 01:53:47", "2023-11-21 01:53:47", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700531627;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700531627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-21 01:54:17", "2023-11-21 01:54:17", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("417", "wp_mail_smtp_admin_notifications_update", "complete", "2023-11-22 01:54:17", "2023-11-22 01:54:17", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700618057;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700618057;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2023-11-22 03:35:44", "2023-11-22 03:35:44", "0", NULL);
INSERT INTO `wpgfi_actionscheduler_actions` VALUES("418", "wp_mail_smtp_admin_notifications_update", "pending", "2023-11-23 03:35:44", "2023-11-23 03:35:44", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700710544;s:18:\"\0*\0first_timestamp\";i:1698224553;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700710544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wpgfi_actionscheduler_groups */
INSERT INTO `wpgfi_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wpgfi_actionscheduler_groups` VALUES("2", "wp_mail_smtp");

/* INSERT TABLE DATA: wpgfi_actionscheduler_logs */
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("1", "389", "action created", "2023-10-25 08:59:17", "2023-10-25 08:59:17");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("2", "389", "action started via WP Cron", "2023-10-25 09:00:25", "2023-10-25 09:00:25");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("3", "389", "action complete via WP Cron", "2023-10-25 09:00:25", "2023-10-25 09:00:25");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("4", "390", "action created", "2023-10-25 09:00:25", "2023-10-25 09:00:25");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("5", "391", "action created", "2023-10-25 09:00:52", "2023-10-25 09:00:52");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("6", "390", "action started via WP Cron", "2023-10-25 09:01:25", "2023-10-25 09:01:25");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("7", "390", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-10-25 09:01:25", "2023-10-25 09:01:25");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("8", "392", "action created", "2023-10-25 09:01:33", "2023-10-25 09:01:33");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("9", "392", "action started via WP Cron", "2023-10-25 09:02:50", "2023-10-25 09:02:50");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("10", "392", "action complete via WP Cron", "2023-10-25 09:02:50", "2023-10-25 09:02:50");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("11", "393", "action created", "2023-10-25 09:02:50", "2023-10-25 09:02:50");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("12", "394", "action created", "2023-10-26 05:16:58", "2023-10-26 05:16:58");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("13", "394", "action started via WP Cron", "2023-10-26 05:18:27", "2023-10-26 05:18:27");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("14", "394", "action complete via WP Cron", "2023-10-26 05:18:27", "2023-10-26 05:18:27");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("15", "395", "action created", "2023-10-26 05:18:27", "2023-10-26 05:18:27");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("16", "395", "action started via Async Request", "2023-10-26 05:19:40", "2023-10-26 05:19:40");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("17", "395", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-10-26 05:19:40", "2023-10-26 05:19:40");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("18", "396", "action created", "2023-10-26 06:16:14", "2023-10-26 06:16:14");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("19", "396", "action started via WP Cron", "2023-10-26 06:17:18", "2023-10-26 06:17:18");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("20", "396", "action complete via WP Cron", "2023-10-26 06:17:18", "2023-10-26 06:17:18");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("21", "393", "action started via WP Cron", "2023-10-26 09:03:21", "2023-10-26 09:03:21");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("22", "393", "action complete via WP Cron", "2023-10-26 09:03:21", "2023-10-26 09:03:21");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("23", "397", "action created", "2023-10-26 09:03:21", "2023-10-26 09:03:21");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("24", "397", "action started via WP Cron", "2023-10-27 15:48:46", "2023-10-27 15:48:46");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("25", "397", "action complete via WP Cron", "2023-10-27 15:48:47", "2023-10-27 15:48:47");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("26", "398", "action created", "2023-10-27 15:48:47", "2023-10-27 15:48:47");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("27", "398", "action started via WP Cron", "2023-10-29 12:49:19", "2023-10-29 12:49:19");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("28", "398", "action complete via WP Cron", "2023-10-29 12:49:19", "2023-10-29 12:49:19");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("29", "399", "action created", "2023-10-29 12:49:19", "2023-10-29 12:49:19");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("30", "399", "action started via WP Cron", "2023-11-01 02:44:11", "2023-11-01 02:44:11");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("31", "399", "action complete via WP Cron", "2023-11-01 02:44:11", "2023-11-01 02:44:11");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("32", "400", "action created", "2023-11-01 02:44:11", "2023-11-01 02:44:11");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("33", "391", "action started via WP Cron", "2023-11-01 02:44:11", "2023-11-01 02:44:11");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("34", "391", "action complete via WP Cron", "2023-11-01 02:44:13", "2023-11-01 02:44:13");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("35", "401", "action created", "2023-11-01 02:44:13", "2023-11-01 02:44:13");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("36", "400", "action started via WP Cron", "2023-11-03 02:03:18", "2023-11-03 02:03:18");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("37", "400", "action complete via WP Cron", "2023-11-03 02:03:18", "2023-11-03 02:03:18");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("38", "402", "action created", "2023-11-03 02:03:18", "2023-11-03 02:03:18");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("39", "402", "action started via WP Cron", "2023-11-05 04:01:42", "2023-11-05 04:01:42");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("40", "402", "action complete via WP Cron", "2023-11-05 04:01:42", "2023-11-05 04:01:42");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("41", "403", "action created", "2023-11-05 04:01:42", "2023-11-05 04:01:42");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("42", "403", "action started via WP Cron", "2023-11-06 04:02:23", "2023-11-06 04:02:23");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("43", "403", "action complete via WP Cron", "2023-11-06 04:02:23", "2023-11-06 04:02:23");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("44", "404", "action created", "2023-11-06 04:02:23", "2023-11-06 04:02:23");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("45", "404", "action started via WP Cron", "2023-11-07 04:02:27", "2023-11-07 04:02:27");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("46", "404", "action complete via WP Cron", "2023-11-07 04:02:27", "2023-11-07 04:02:27");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("47", "405", "action created", "2023-11-07 04:02:27", "2023-11-07 04:02:27");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("48", "401", "action started via WP Cron", "2023-11-08 05:16:01", "2023-11-08 05:16:01");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("49", "401", "action complete via WP Cron", "2023-11-08 05:16:02", "2023-11-08 05:16:02");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("50", "406", "action created", "2023-11-08 05:16:02", "2023-11-08 05:16:02");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("51", "405", "action started via WP Cron", "2023-11-08 05:16:02", "2023-11-08 05:16:02");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("52", "405", "action complete via WP Cron", "2023-11-08 05:16:02", "2023-11-08 05:16:02");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("53", "407", "action created", "2023-11-08 05:16:02", "2023-11-08 05:16:02");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("54", "407", "action started via WP Cron", "2023-11-09 05:17:50", "2023-11-09 05:17:50");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("55", "407", "action complete via WP Cron", "2023-11-09 05:17:50", "2023-11-09 05:17:50");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("56", "408", "action created", "2023-11-09 05:17:50", "2023-11-09 05:17:50");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("57", "408", "action started via WP Cron", "2023-11-10 05:58:35", "2023-11-10 05:58:35");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("58", "408", "action complete via WP Cron", "2023-11-10 05:58:35", "2023-11-10 05:58:35");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("59", "409", "action created", "2023-11-10 05:58:35", "2023-11-10 05:58:35");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("60", "409", "action started via WP Cron", "2023-11-12 04:55:39", "2023-11-12 04:55:39");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("61", "409", "action complete via WP Cron", "2023-11-12 04:55:39", "2023-11-12 04:55:39");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("62", "410", "action created", "2023-11-12 04:55:39", "2023-11-12 04:55:39");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("63", "410", "action started via WP Cron", "2023-11-13 07:20:10", "2023-11-13 07:20:10");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("64", "410", "action complete via WP Cron", "2023-11-13 07:20:11", "2023-11-13 07:20:11");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("65", "411", "action created", "2023-11-13 07:20:11", "2023-11-13 07:20:11");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("66", "411", "action started via WP Cron", "2023-11-15 01:19:30", "2023-11-15 01:19:30");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("67", "411", "action complete via WP Cron", "2023-11-15 01:19:30", "2023-11-15 01:19:30");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("68", "412", "action created", "2023-11-15 01:19:30", "2023-11-15 01:19:30");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("69", "406", "action started via WP Cron", "2023-11-15 05:43:53", "2023-11-15 05:43:53");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("70", "406", "action complete via WP Cron", "2023-11-15 05:43:53", "2023-11-15 05:43:53");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("71", "413", "action created", "2023-11-15 05:43:53", "2023-11-15 05:43:53");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("72", "412", "action started via WP Cron", "2023-11-16 02:54:06", "2023-11-16 02:54:06");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("73", "412", "action complete via WP Cron", "2023-11-16 02:54:06", "2023-11-16 02:54:06");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("74", "414", "action created", "2023-11-16 02:54:06", "2023-11-16 02:54:06");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("75", "414", "action started via WP Cron", "2023-11-18 03:29:17", "2023-11-18 03:29:17");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("76", "414", "action complete via WP Cron", "2023-11-18 03:29:17", "2023-11-18 03:29:17");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("77", "415", "action created", "2023-11-18 03:29:17", "2023-11-18 03:29:17");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("78", "415", "action started via WP Cron", "2023-11-20 01:53:46", "2023-11-20 01:53:46");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("79", "415", "action complete via WP Cron", "2023-11-20 01:53:47", "2023-11-20 01:53:47");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("80", "416", "action created", "2023-11-20 01:53:47", "2023-11-20 01:53:47");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("81", "416", "action started via WP Cron", "2023-11-21 01:54:17", "2023-11-21 01:54:17");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("82", "416", "action complete via WP Cron", "2023-11-21 01:54:17", "2023-11-21 01:54:17");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("83", "417", "action created", "2023-11-21 01:54:17", "2023-11-21 01:54:17");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("84", "417", "action started via WP Cron", "2023-11-22 03:35:44", "2023-11-22 03:35:44");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("85", "417", "action complete via WP Cron", "2023-11-22 03:35:44", "2023-11-22 03:35:44");
INSERT INTO `wpgfi_actionscheduler_logs` VALUES("86", "418", "action created", "2023-11-22 03:35:44", "2023-11-22 03:35:44");

/* INSERT TABLE DATA: wpgfi_alm */
INSERT INTO `wpgfi_alm` VALUES("1", "default", "<li class=\"alm-item<?php if ( ! has_post_thumbnail() ) { echo \' no-img\'; } ?>\">\n	<?php\n		if ( has_post_thumbnail() ) {\n			the_post_thumbnail( \'alm-thumbnail\' );\n		}\n	?>\n	<h3>\n		<a href=\"<?php the_permalink(); ?>\"><?php the_title(); ?></a>\n	</h3>\n	<p class=\"entry-meta\"><?php the_time( \'F d, Y\' ); ?></p>\n	<?php the_excerpt(); ?>\n</li>\n", "default", "6.2.0.1");

/* INSERT TABLE DATA: wpgfi_comments */
INSERT INTO `wpgfi_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2023-10-23 09:03:13", "2023-10-23 09:03:13", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wpgfi_duplicator_packages */
INSERT INTO `wpgfi_duplicator_packages` VALUES("1", "20231122_gfimanpowerinternational", "d0287dd012350d7f2534_20231122034304", "23", "2023-11-22 03:47:57", "gfimi_main", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-22 03:43:04\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:33:\"20231122_gfimanpowerinternational\";s:4:\"Hash\";s:35:\"d0287dd012350d7f2534_20231122034304\";s:8:\"NameHash\";s:69:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:79:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"23.1\";s:6:\"WPUser\";s:10:\"gfimi_main\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:81:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:38:\"/home/slklwimy/public_html/staging/gfi\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1416;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7941;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-22 03:43:04\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:33:\"20231122_gfimanpowerinternational\";s:4:\"Hash\";s:35:\"d0287dd012350d7f2534_20231122034304\";s:8:\"NameHash\";s:69:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:87:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:52:\"/home/slklwimy/public_html/staging/gfi/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:82:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:153:\"/home/slklwimy/public_html/staging/gfi/wp-content/backups-dup-lite/tmp/20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:47:\"/home/slklwimy/public_html/staging/gfi/wp-admin\";i:1;s:50:\"/home/slklwimy/public_html/staging/gfi/wp-includes\";i:2;s:59:\"/home/slklwimy/public_html/staging/gfi/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:38:\"/home/slklwimy/public_html/staging/gfi\";i:1;s:38:\"/home/slklwimy/public_html/staging/gfi\";i:2;s:49:\"/home/slklwimy/public_html/staging/gfi/wp-content\";i:3;s:57:\"/home/slklwimy/public_html/staging/gfi/wp-content/uploads\";i:4;s:57:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins\";i:5;s:60:\"/home/slklwimy/public_html/staging/gfi/wp-content/mu-plugins\";i:6;s:56:\"/home/slklwimy/public_html/staging/gfi/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:70:\"/home/slklwimy/public_html/staging/gfi/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wpgfi_e_events */
INSERT INTO `wpgfi_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2023-10-23T17:04:11.268-08:00\"}", "2023-10-23 17:04:11");

/* INSERT TABLE DATA: wpgfi_e_submissions */
INSERT INTO `wpgfi_e_submissions` VALUES("1", "submission", "306c680f-7ee1-4ae9-afc7-6350cacabe72", "2", "136", "https://slk.lwi.mybluehost.me/staging/gfi/contact/", "Contact", "7276c36", "New Form", "0", "0", "130.105.154.84", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0", "1", "1", "new", "0", "{\"edit_post_id\":\"136\"}", "2023-10-25 04:58:31", "2023-10-25 04:58:32", "2023-10-25 04:58:31", "2023-10-25 04:58:32");
INSERT INTO `wpgfi_e_submissions` VALUES("2", "submission", "170e5bf9-84f3-4439-a983-09cea1064f7a", "6", "136", "https://slk.lwi.mybluehost.me/staging/gfi/contact/", "Contact", "7276c36", "New Form", "0", "0", "130.105.154.84", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0", "1", "1", "new", "0", "{\"edit_post_id\":\"136\"}", "2023-10-25 08:51:43", "2023-10-25 08:51:43", "2023-10-25 08:51:43", "2023-10-25 08:51:43");
INSERT INTO `wpgfi_e_submissions` VALUES("3", "submission", "a8e9062a-32e5-4a91-bc6e-280d7e278b53", "10", "136", "https://slk.lwi.mybluehost.me/staging/gfi/contact/", "Contact", "7276c36", "New Form", "0", "1", "112.201.171.129", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36", "2", "2", "new", "0", "{\"edit_post_id\":\"136\"}", "2023-10-25 09:06:05", "2023-10-25 09:06:07", "2023-10-25 09:06:05", "2023-10-25 09:06:07");
INSERT INTO `wpgfi_e_submissions` VALUES("4", "submission", "76a2c08b-2c53-4fa2-9703-a8272de9aafd", "14", "136", "https://slk.lwi.mybluehost.me/staging/gfi/contact-us/", "Contact Us", "7276c36", "New Form", "0", "0", "130.105.154.84", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0", "2", "1", "new", "0", "{\"edit_post_id\":\"136\"}", "2023-11-13 08:41:16", "2023-11-13 08:41:19", "2023-11-13 08:41:16", "2023-11-13 08:41:19");
INSERT INTO `wpgfi_e_submissions` VALUES("5", "submission", "ccd65e1d-aa53-4bd1-b556-7f9edcfb90c2", "18", "136", "https://slk.lwi.mybluehost.me/staging/gfi/contact-us/", "Contact Us", "7276c36", "New Form", "0", "0", "130.105.154.84", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0", "2", "1", "new", "0", "{\"edit_post_id\":\"136\"}", "2023-11-13 08:41:29", "2023-11-13 08:41:30", "2023-11-13 08:41:29", "2023-11-13 08:41:30");

/* INSERT TABLE DATA: wpgfi_e_submissions_actions_log */
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("1", "1", "email", "Email", "success", NULL, "2023-10-25 04:58:32", "2023-10-25 04:58:32", "2023-10-25 04:58:32", "2023-10-25 04:58:32");
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("2", "2", "email", "Email", "success", NULL, "2023-10-25 08:51:43", "2023-10-25 08:51:43", "2023-10-25 08:51:43", "2023-10-25 08:51:43");
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("3", "3", "email", "Email", "success", NULL, "2023-10-25 09:06:06", "2023-10-25 09:06:06", "2023-10-25 09:06:06", "2023-10-25 09:06:06");
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("4", "3", "email2", "Email 2", "success", NULL, "2023-10-25 09:06:07", "2023-10-25 09:06:07", "2023-10-25 09:06:07", "2023-10-25 09:06:07");
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("5", "4", "email", "Email", "success", NULL, "2023-11-13 08:41:19", "2023-11-13 08:41:19", "2023-11-13 08:41:19", "2023-11-13 08:41:19");
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("6", "4", "email2", "Email 2", "failed", "Your submission failed because of a server error.", "2023-11-13 08:41:19", "2023-11-13 08:41:19", "2023-11-13 08:41:19", "2023-11-13 08:41:19");
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("7", "5", "email", "Email", "success", NULL, "2023-11-13 08:41:30", "2023-11-13 08:41:30", "2023-11-13 08:41:30", "2023-11-13 08:41:30");
INSERT INTO `wpgfi_e_submissions_actions_log` VALUES("8", "5", "email2", "Email 2", "failed", "Your submission failed because of a server error.", "2023-11-13 08:41:30", "2023-11-13 08:41:30", "2023-11-13 08:41:30", "2023-11-13 08:41:30");

/* INSERT TABLE DATA: wpgfi_e_submissions_values */
INSERT INTO `wpgfi_e_submissions_values` VALUES("1", "1", "name", "sad");
INSERT INTO `wpgfi_e_submissions_values` VALUES("2", "1", "email", "sad@gmail.com");
INSERT INTO `wpgfi_e_submissions_values` VALUES("3", "1", "field_24fe6cc", "088788767878");
INSERT INTO `wpgfi_e_submissions_values` VALUES("4", "1", "message", "addws");
INSERT INTO `wpgfi_e_submissions_values` VALUES("5", "2", "name", "Test");
INSERT INTO `wpgfi_e_submissions_values` VALUES("6", "2", "email", "Test@gmail.com");
INSERT INTO `wpgfi_e_submissions_values` VALUES("7", "2", "field_24fe6cc", "123456789");
INSERT INTO `wpgfi_e_submissions_values` VALUES("8", "2", "message", "This is a test email");
INSERT INTO `wpgfi_e_submissions_values` VALUES("9", "3", "name", "Reginald Legaspi");
INSERT INTO `wpgfi_e_submissions_values` VALUES("10", "3", "email", "legaspireginald.rl@gmail.com");
INSERT INTO `wpgfi_e_submissions_values` VALUES("11", "3", "field_24fe6cc", "09190933865");
INSERT INTO `wpgfi_e_submissions_values` VALUES("12", "3", "message", "Test Dev");
INSERT INTO `wpgfi_e_submissions_values` VALUES("13", "4", "name", "test 11132023");
INSERT INTO `wpgfi_e_submissions_values` VALUES("14", "4", "email", "Test@gmail.com");
INSERT INTO `wpgfi_e_submissions_values` VALUES("15", "4", "field_24fe6cc", "123456789");
INSERT INTO `wpgfi_e_submissions_values` VALUES("16", "4", "message", "hello world");
INSERT INTO `wpgfi_e_submissions_values` VALUES("17", "5", "name", "test 11132023");
INSERT INTO `wpgfi_e_submissions_values` VALUES("18", "5", "email", "Test@gmail.com");
INSERT INTO `wpgfi_e_submissions_values` VALUES("19", "5", "field_24fe6cc", "123456789");
INSERT INTO `wpgfi_e_submissions_values` VALUES("20", "5", "message", "hello world");

/* INSERT TABLE DATA: wpgfi_options */
INSERT INTO `wpgfi_options` VALUES("1", "siteurl", "https://slk.lwi.mybluehost.me/staging/gfi", "yes");
INSERT INTO `wpgfi_options` VALUES("2", "home", "https://slk.lwi.mybluehost.me/staging/gfi", "yes");
INSERT INTO `wpgfi_options` VALUES("3", "blogname", "GFI Manpower International", "yes");
INSERT INTO `wpgfi_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wpgfi_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("6", "admin_email", "cbzncorpdedi@gmail.com", "yes");
INSERT INTO `wpgfi_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wpgfi_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wpgfi_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wpgfi_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wpgfi_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wpgfi_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wpgfi_options` VALUES("20", "default_ping_status", "", "yes");
INSERT INTO `wpgfi_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wpgfi_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wpgfi_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wpgfi_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wpgfi_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wpgfi_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wpgfi_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wpgfi_options` VALUES("29", "rewrite_rules", "a:143:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"job-opening/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"job-opening/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"job-opening/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"job-opening/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"job-opening/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"job-opening/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"job-opening/([^/]+)/embed/?$\";s:44:\"index.php?job-opening=$matches[1]&embed=true\";s:32:\"job-opening/([^/]+)/trackback/?$\";s:38:\"index.php?job-opening=$matches[1]&tb=1\";s:40:\"job-opening/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?job-opening=$matches[1]&paged=$matches[2]\";s:47:\"job-opening/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?job-opening=$matches[1]&cpage=$matches[2]\";s:36:\"job-opening/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?job-opening=$matches[1]&page=$matches[2]\";s:28:\"job-opening/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"job-opening/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"job-opening/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"job-opening/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"job-opening/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"job-opening/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"job-qualification/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"job-qualification/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"job-qualification/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"job-qualification/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"job-qualification/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"job-qualification/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"job-qualification/([^/]+)/embed/?$\";s:50:\"index.php?job-qualification=$matches[1]&embed=true\";s:38:\"job-qualification/([^/]+)/trackback/?$\";s:44:\"index.php?job-qualification=$matches[1]&tb=1\";s:46:\"job-qualification/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?job-qualification=$matches[1]&paged=$matches[2]\";s:53:\"job-qualification/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?job-qualification=$matches[1]&cpage=$matches[2]\";s:42:\"job-qualification/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?job-qualification=$matches[1]&page=$matches[2]\";s:34:\"job-qualification/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"job-qualification/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"job-qualification/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"job-qualification/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"job-qualification/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"job-qualification/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=12&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wpgfi_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wpgfi_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wpgfi_options` VALUES("33", "active_plugins", "a:7:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:33:\"ajax-load-more/ajax-load-more.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:35:\"ele-custom-skin/ele-custom-skin.php\";i:4;s:31:\"elementor-pro/elementor-pro.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";}", "yes");
INSERT INTO `wpgfi_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wpgfi_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wpgfi_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wpgfi_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("39", "recently_edited", "a:5:{i:0;s:86:\"/home/slklwimy/public_html/staging/gfi/wp-content/themes/hello-elementor/functions.php\";i:1;s:82:\"/home/slklwimy/public_html/staging/gfi/wp-content/themes/hello-elementor/style.css\";i:3;s:83:\"/home/slklwimy/public_html/staging/gfi/wp-content/themes/hello-elementor/header.php\";i:4;s:98:\"/home/slklwimy/public_html/staging/gfi/wp-content/themes/hello-elementor/template-parts/single.php\";i:5;s:98:\"/home/slklwimy/public_html/staging/gfi/wp-content/themes/hello-elementor/template-parts/footer.php\";}", "no");
INSERT INTO `wpgfi_options` VALUES("40", "template", "hello-elementor", "yes");
INSERT INTO `wpgfi_options` VALUES("41", "stylesheet", "hello-elementor", "yes");
INSERT INTO `wpgfi_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wpgfi_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wpgfi_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wpgfi_options` VALUES("46", "db_version", "56657", "yes");
INSERT INTO `wpgfi_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wpgfi_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wpgfi_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wpgfi_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wpgfi_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wpgfi_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wpgfi_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wpgfi_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wpgfi_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wpgfi_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wpgfi_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wpgfi_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wpgfi_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wpgfi_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wpgfi_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wpgfi_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wpgfi_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wpgfi_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wpgfi_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wpgfi_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wpgfi_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wpgfi_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wpgfi_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wpgfi_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wpgfi_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("79", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:37:\"user-role-editor/user-role-editor.php\";a:2:{i:0;s:16:\"User_Role_Editor\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wpgfi_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wpgfi_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("82", "page_on_front", "12", "yes");
INSERT INTO `wpgfi_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wpgfi_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wpgfi_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("91", "admin_email_lifespan", "1713603793", "yes");
INSERT INTO `wpgfi_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wpgfi_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wpgfi_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wpgfi_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wpgfi_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wpgfi_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wpgfi_options` VALUES("99", "initial_db_version", "55853", "yes");
INSERT INTO `wpgfi_options` VALUES("100", "wpgfi_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:79:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:9:\"elementor\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:47:{s:26:\"create_notes_elementor-pro\";b:1;s:12:\"create_roles\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:19:\"delete_others_pages\";b:1;s:19:\"delete_others_posts\";b:1;s:12:\"delete_pages\";b:1;s:12:\"delete_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:12:\"delete_roles\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;s:10:\"edit_pages\";b:1;s:10:\"edit_posts\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:10:\"edit_roles\";b:1;s:18:\"edit_theme_options\";b:1;s:11:\"edit_themes\";b:1;s:9:\"elementor\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:7:\"level_3\";b:1;s:7:\"level_4\";b:1;s:7:\"level_5\";b:1;s:7:\"level_6\";b:1;s:7:\"level_7\";b:1;s:10:\"list_roles\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:13:\"publish_pages\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wpgfi_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wpgfi_options` VALUES("102", "user_count", "2", "no");
INSERT INTO `wpgfi_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("104", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wpgfi_options` VALUES("105", "cron", "a:10:{i:1700624920;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1700627033;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1700643793;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1700643805;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1700643831;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1701075825;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1701093600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1701162193;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1701360644;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wpgfi_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("115", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("116", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("117", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("118", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("119", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("120", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.3.2\";s:5:\"files\";a:496:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:20:\"block/editor-rtl.css\";i:29;s:24:\"block/editor-rtl.min.css\";i:30;s:16:\"block/editor.css\";i:31;s:20:\"block/editor.min.css\";i:32;s:21:\"button/editor-rtl.css\";i:33;s:25:\"button/editor-rtl.min.css\";i:34;s:17:\"button/editor.css\";i:35;s:21:\"button/editor.min.css\";i:36;s:20:\"button/style-rtl.css\";i:37;s:24:\"button/style-rtl.min.css\";i:38;s:16:\"button/style.css\";i:39;s:20:\"button/style.min.css\";i:40;s:22:\"buttons/editor-rtl.css\";i:41;s:26:\"buttons/editor-rtl.min.css\";i:42;s:18:\"buttons/editor.css\";i:43;s:22:\"buttons/editor.min.css\";i:44;s:21:\"buttons/style-rtl.css\";i:45;s:25:\"buttons/style-rtl.min.css\";i:46;s:17:\"buttons/style.css\";i:47;s:21:\"buttons/style.min.css\";i:48;s:22:\"calendar/style-rtl.css\";i:49;s:26:\"calendar/style-rtl.min.css\";i:50;s:18:\"calendar/style.css\";i:51;s:22:\"calendar/style.min.css\";i:52;s:25:\"categories/editor-rtl.css\";i:53;s:29:\"categories/editor-rtl.min.css\";i:54;s:21:\"categories/editor.css\";i:55;s:25:\"categories/editor.min.css\";i:56;s:24:\"categories/style-rtl.css\";i:57;s:28:\"categories/style-rtl.min.css\";i:58;s:20:\"categories/style.css\";i:59;s:24:\"categories/style.min.css\";i:60;s:19:\"code/editor-rtl.css\";i:61;s:23:\"code/editor-rtl.min.css\";i:62;s:15:\"code/editor.css\";i:63;s:19:\"code/editor.min.css\";i:64;s:18:\"code/style-rtl.css\";i:65;s:22:\"code/style-rtl.min.css\";i:66;s:14:\"code/style.css\";i:67;s:18:\"code/style.min.css\";i:68;s:18:\"code/theme-rtl.css\";i:69;s:22:\"code/theme-rtl.min.css\";i:70;s:14:\"code/theme.css\";i:71;s:18:\"code/theme.min.css\";i:72;s:22:\"columns/editor-rtl.css\";i:73;s:26:\"columns/editor-rtl.min.css\";i:74;s:18:\"columns/editor.css\";i:75;s:22:\"columns/editor.min.css\";i:76;s:21:\"columns/style-rtl.css\";i:77;s:25:\"columns/style-rtl.min.css\";i:78;s:17:\"columns/style.css\";i:79;s:21:\"columns/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:30:\"comment-template/style-rtl.css\";i:85;s:34:\"comment-template/style-rtl.min.css\";i:86;s:26:\"comment-template/style.css\";i:87;s:30:\"comment-template/style.min.css\";i:88;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:89;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:90;s:38:\"comments-pagination-numbers/editor.css\";i:91;s:42:\"comments-pagination-numbers/editor.min.css\";i:92;s:34:\"comments-pagination/editor-rtl.css\";i:93;s:38:\"comments-pagination/editor-rtl.min.css\";i:94;s:30:\"comments-pagination/editor.css\";i:95;s:34:\"comments-pagination/editor.min.css\";i:96;s:33:\"comments-pagination/style-rtl.css\";i:97;s:37:\"comments-pagination/style-rtl.min.css\";i:98;s:29:\"comments-pagination/style.css\";i:99;s:33:\"comments-pagination/style.min.css\";i:100;s:29:\"comments-title/editor-rtl.css\";i:101;s:33:\"comments-title/editor-rtl.min.css\";i:102;s:25:\"comments-title/editor.css\";i:103;s:29:\"comments-title/editor.min.css\";i:104;s:23:\"comments/editor-rtl.css\";i:105;s:27:\"comments/editor-rtl.min.css\";i:106;s:19:\"comments/editor.css\";i:107;s:23:\"comments/editor.min.css\";i:108;s:22:\"comments/style-rtl.css\";i:109;s:26:\"comments/style-rtl.min.css\";i:110;s:18:\"comments/style.css\";i:111;s:22:\"comments/style.min.css\";i:112;s:20:\"cover/editor-rtl.css\";i:113;s:24:\"cover/editor-rtl.min.css\";i:114;s:16:\"cover/editor.css\";i:115;s:20:\"cover/editor.min.css\";i:116;s:19:\"cover/style-rtl.css\";i:117;s:23:\"cover/style-rtl.min.css\";i:118;s:15:\"cover/style.css\";i:119;s:19:\"cover/style.min.css\";i:120;s:22:\"details/editor-rtl.css\";i:121;s:26:\"details/editor-rtl.min.css\";i:122;s:18:\"details/editor.css\";i:123;s:22:\"details/editor.min.css\";i:124;s:21:\"details/style-rtl.css\";i:125;s:25:\"details/style-rtl.min.css\";i:126;s:17:\"details/style.css\";i:127;s:21:\"details/style.min.css\";i:128;s:20:\"embed/editor-rtl.css\";i:129;s:24:\"embed/editor-rtl.min.css\";i:130;s:16:\"embed/editor.css\";i:131;s:20:\"embed/editor.min.css\";i:132;s:19:\"embed/style-rtl.css\";i:133;s:23:\"embed/style-rtl.min.css\";i:134;s:15:\"embed/style.css\";i:135;s:19:\"embed/style.min.css\";i:136;s:19:\"embed/theme-rtl.css\";i:137;s:23:\"embed/theme-rtl.min.css\";i:138;s:15:\"embed/theme.css\";i:139;s:19:\"embed/theme.min.css\";i:140;s:19:\"file/editor-rtl.css\";i:141;s:23:\"file/editor-rtl.min.css\";i:142;s:15:\"file/editor.css\";i:143;s:19:\"file/editor.min.css\";i:144;s:18:\"file/style-rtl.css\";i:145;s:22:\"file/style-rtl.min.css\";i:146;s:14:\"file/style.css\";i:147;s:18:\"file/style.min.css\";i:148;s:23:\"footnotes/style-rtl.css\";i:149;s:27:\"footnotes/style-rtl.min.css\";i:150;s:19:\"footnotes/style.css\";i:151;s:23:\"footnotes/style.min.css\";i:152;s:23:\"freeform/editor-rtl.css\";i:153;s:27:\"freeform/editor-rtl.min.css\";i:154;s:19:\"freeform/editor.css\";i:155;s:23:\"freeform/editor.min.css\";i:156;s:22:\"gallery/editor-rtl.css\";i:157;s:26:\"gallery/editor-rtl.min.css\";i:158;s:18:\"gallery/editor.css\";i:159;s:22:\"gallery/editor.min.css\";i:160;s:21:\"gallery/style-rtl.css\";i:161;s:25:\"gallery/style-rtl.min.css\";i:162;s:17:\"gallery/style.css\";i:163;s:21:\"gallery/style.min.css\";i:164;s:21:\"gallery/theme-rtl.css\";i:165;s:25:\"gallery/theme-rtl.min.css\";i:166;s:17:\"gallery/theme.css\";i:167;s:21:\"gallery/theme.min.css\";i:168;s:20:\"group/editor-rtl.css\";i:169;s:24:\"group/editor-rtl.min.css\";i:170;s:16:\"group/editor.css\";i:171;s:20:\"group/editor.min.css\";i:172;s:19:\"group/style-rtl.css\";i:173;s:23:\"group/style-rtl.min.css\";i:174;s:15:\"group/style.css\";i:175;s:19:\"group/style.min.css\";i:176;s:19:\"group/theme-rtl.css\";i:177;s:23:\"group/theme-rtl.min.css\";i:178;s:15:\"group/theme.css\";i:179;s:19:\"group/theme.min.css\";i:180;s:21:\"heading/style-rtl.css\";i:181;s:25:\"heading/style-rtl.min.css\";i:182;s:17:\"heading/style.css\";i:183;s:21:\"heading/style.min.css\";i:184;s:19:\"html/editor-rtl.css\";i:185;s:23:\"html/editor-rtl.min.css\";i:186;s:15:\"html/editor.css\";i:187;s:19:\"html/editor.min.css\";i:188;s:20:\"image/editor-rtl.css\";i:189;s:24:\"image/editor-rtl.min.css\";i:190;s:16:\"image/editor.css\";i:191;s:20:\"image/editor.min.css\";i:192;s:19:\"image/style-rtl.css\";i:193;s:23:\"image/style-rtl.min.css\";i:194;s:15:\"image/style.css\";i:195;s:19:\"image/style.min.css\";i:196;s:19:\"image/theme-rtl.css\";i:197;s:23:\"image/theme-rtl.min.css\";i:198;s:15:\"image/theme.css\";i:199;s:19:\"image/theme.min.css\";i:200;s:29:\"latest-comments/style-rtl.css\";i:201;s:33:\"latest-comments/style-rtl.min.css\";i:202;s:25:\"latest-comments/style.css\";i:203;s:29:\"latest-comments/style.min.css\";i:204;s:27:\"latest-posts/editor-rtl.css\";i:205;s:31:\"latest-posts/editor-rtl.min.css\";i:206;s:23:\"latest-posts/editor.css\";i:207;s:27:\"latest-posts/editor.min.css\";i:208;s:26:\"latest-posts/style-rtl.css\";i:209;s:30:\"latest-posts/style-rtl.min.css\";i:210;s:22:\"latest-posts/style.css\";i:211;s:26:\"latest-posts/style.min.css\";i:212;s:18:\"list/style-rtl.css\";i:213;s:22:\"list/style-rtl.min.css\";i:214;s:14:\"list/style.css\";i:215;s:18:\"list/style.min.css\";i:216;s:25:\"media-text/editor-rtl.css\";i:217;s:29:\"media-text/editor-rtl.min.css\";i:218;s:21:\"media-text/editor.css\";i:219;s:25:\"media-text/editor.min.css\";i:220;s:24:\"media-text/style-rtl.css\";i:221;s:28:\"media-text/style-rtl.min.css\";i:222;s:20:\"media-text/style.css\";i:223;s:24:\"media-text/style.min.css\";i:224;s:19:\"more/editor-rtl.css\";i:225;s:23:\"more/editor-rtl.min.css\";i:226;s:15:\"more/editor.css\";i:227;s:19:\"more/editor.min.css\";i:228;s:30:\"navigation-link/editor-rtl.css\";i:229;s:34:\"navigation-link/editor-rtl.min.css\";i:230;s:26:\"navigation-link/editor.css\";i:231;s:30:\"navigation-link/editor.min.css\";i:232;s:29:\"navigation-link/style-rtl.css\";i:233;s:33:\"navigation-link/style-rtl.min.css\";i:234;s:25:\"navigation-link/style.css\";i:235;s:29:\"navigation-link/style.min.css\";i:236;s:33:\"navigation-submenu/editor-rtl.css\";i:237;s:37:\"navigation-submenu/editor-rtl.min.css\";i:238;s:29:\"navigation-submenu/editor.css\";i:239;s:33:\"navigation-submenu/editor.min.css\";i:240;s:25:\"navigation/editor-rtl.css\";i:241;s:29:\"navigation/editor-rtl.min.css\";i:242;s:21:\"navigation/editor.css\";i:243;s:25:\"navigation/editor.min.css\";i:244;s:24:\"navigation/style-rtl.css\";i:245;s:28:\"navigation/style-rtl.min.css\";i:246;s:20:\"navigation/style.css\";i:247;s:24:\"navigation/style.min.css\";i:248;s:23:\"nextpage/editor-rtl.css\";i:249;s:27:\"nextpage/editor-rtl.min.css\";i:250;s:19:\"nextpage/editor.css\";i:251;s:23:\"nextpage/editor.min.css\";i:252;s:24:\"page-list/editor-rtl.css\";i:253;s:28:\"page-list/editor-rtl.min.css\";i:254;s:20:\"page-list/editor.css\";i:255;s:24:\"page-list/editor.min.css\";i:256;s:23:\"page-list/style-rtl.css\";i:257;s:27:\"page-list/style-rtl.min.css\";i:258;s:19:\"page-list/style.css\";i:259;s:23:\"page-list/style.min.css\";i:260;s:24:\"paragraph/editor-rtl.css\";i:261;s:28:\"paragraph/editor-rtl.min.css\";i:262;s:20:\"paragraph/editor.css\";i:263;s:24:\"paragraph/editor.min.css\";i:264;s:23:\"paragraph/style-rtl.css\";i:265;s:27:\"paragraph/style-rtl.min.css\";i:266;s:19:\"paragraph/style.css\";i:267;s:23:\"paragraph/style.min.css\";i:268;s:25:\"post-author/style-rtl.css\";i:269;s:29:\"post-author/style-rtl.min.css\";i:270;s:21:\"post-author/style.css\";i:271;s:25:\"post-author/style.min.css\";i:272;s:33:\"post-comments-form/editor-rtl.css\";i:273;s:37:\"post-comments-form/editor-rtl.min.css\";i:274;s:29:\"post-comments-form/editor.css\";i:275;s:33:\"post-comments-form/editor.min.css\";i:276;s:32:\"post-comments-form/style-rtl.css\";i:277;s:36:\"post-comments-form/style-rtl.min.css\";i:278;s:28:\"post-comments-form/style.css\";i:279;s:32:\"post-comments-form/style.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"quote/style-rtl.css\";i:357;s:23:\"quote/style-rtl.min.css\";i:358;s:15:\"quote/style.css\";i:359;s:19:\"quote/style.min.css\";i:360;s:19:\"quote/theme-rtl.css\";i:361;s:23:\"quote/theme-rtl.min.css\";i:362;s:15:\"quote/theme.css\";i:363;s:19:\"quote/theme.min.css\";i:364;s:23:\"read-more/style-rtl.css\";i:365;s:27:\"read-more/style-rtl.min.css\";i:366;s:19:\"read-more/style.css\";i:367;s:23:\"read-more/style.min.css\";i:368;s:18:\"rss/editor-rtl.css\";i:369;s:22:\"rss/editor-rtl.min.css\";i:370;s:14:\"rss/editor.css\";i:371;s:18:\"rss/editor.min.css\";i:372;s:17:\"rss/style-rtl.css\";i:373;s:21:\"rss/style-rtl.min.css\";i:374;s:13:\"rss/style.css\";i:375;s:17:\"rss/style.min.css\";i:376;s:21:\"search/editor-rtl.css\";i:377;s:25:\"search/editor-rtl.min.css\";i:378;s:17:\"search/editor.css\";i:379;s:21:\"search/editor.min.css\";i:380;s:20:\"search/style-rtl.css\";i:381;s:24:\"search/style-rtl.min.css\";i:382;s:16:\"search/style.css\";i:383;s:20:\"search/style.min.css\";i:384;s:20:\"search/theme-rtl.css\";i:385;s:24:\"search/theme-rtl.min.css\";i:386;s:16:\"search/theme.css\";i:387;s:20:\"search/theme.min.css\";i:388;s:24:\"separator/editor-rtl.css\";i:389;s:28:\"separator/editor-rtl.min.css\";i:390;s:20:\"separator/editor.css\";i:391;s:24:\"separator/editor.min.css\";i:392;s:23:\"separator/style-rtl.css\";i:393;s:27:\"separator/style-rtl.min.css\";i:394;s:19:\"separator/style.css\";i:395;s:23:\"separator/style.min.css\";i:396;s:23:\"separator/theme-rtl.css\";i:397;s:27:\"separator/theme-rtl.min.css\";i:398;s:19:\"separator/theme.css\";i:399;s:23:\"separator/theme.min.css\";i:400;s:24:\"shortcode/editor-rtl.css\";i:401;s:28:\"shortcode/editor-rtl.min.css\";i:402;s:20:\"shortcode/editor.css\";i:403;s:24:\"shortcode/editor.min.css\";i:404;s:24:\"site-logo/editor-rtl.css\";i:405;s:28:\"site-logo/editor-rtl.min.css\";i:406;s:20:\"site-logo/editor.css\";i:407;s:24:\"site-logo/editor.min.css\";i:408;s:23:\"site-logo/style-rtl.css\";i:409;s:27:\"site-logo/style-rtl.min.css\";i:410;s:19:\"site-logo/style.css\";i:411;s:23:\"site-logo/style.min.css\";i:412;s:27:\"site-tagline/editor-rtl.css\";i:413;s:31:\"site-tagline/editor-rtl.min.css\";i:414;s:23:\"site-tagline/editor.css\";i:415;s:27:\"site-tagline/editor.min.css\";i:416;s:25:\"site-title/editor-rtl.css\";i:417;s:29:\"site-title/editor-rtl.min.css\";i:418;s:21:\"site-title/editor.css\";i:419;s:25:\"site-title/editor.min.css\";i:420;s:24:\"site-title/style-rtl.css\";i:421;s:28:\"site-title/style-rtl.min.css\";i:422;s:20:\"site-title/style.css\";i:423;s:24:\"site-title/style.min.css\";i:424;s:26:\"social-link/editor-rtl.css\";i:425;s:30:\"social-link/editor-rtl.min.css\";i:426;s:22:\"social-link/editor.css\";i:427;s:26:\"social-link/editor.min.css\";i:428;s:27:\"social-links/editor-rtl.css\";i:429;s:31:\"social-links/editor-rtl.min.css\";i:430;s:23:\"social-links/editor.css\";i:431;s:27:\"social-links/editor.min.css\";i:432;s:26:\"social-links/style-rtl.css\";i:433;s:30:\"social-links/style-rtl.min.css\";i:434;s:22:\"social-links/style.css\";i:435;s:26:\"social-links/style.min.css\";i:436;s:21:\"spacer/editor-rtl.css\";i:437;s:25:\"spacer/editor-rtl.min.css\";i:438;s:17:\"spacer/editor.css\";i:439;s:21:\"spacer/editor.min.css\";i:440;s:20:\"spacer/style-rtl.css\";i:441;s:24:\"spacer/style-rtl.min.css\";i:442;s:16:\"spacer/style.css\";i:443;s:20:\"spacer/style.min.css\";i:444;s:20:\"table/editor-rtl.css\";i:445;s:24:\"table/editor-rtl.min.css\";i:446;s:16:\"table/editor.css\";i:447;s:20:\"table/editor.min.css\";i:448;s:19:\"table/style-rtl.css\";i:449;s:23:\"table/style-rtl.min.css\";i:450;s:15:\"table/style.css\";i:451;s:19:\"table/style.min.css\";i:452;s:19:\"table/theme-rtl.css\";i:453;s:23:\"table/theme-rtl.min.css\";i:454;s:15:\"table/theme.css\";i:455;s:19:\"table/theme.min.css\";i:456;s:23:\"tag-cloud/style-rtl.css\";i:457;s:27:\"tag-cloud/style-rtl.min.css\";i:458;s:19:\"tag-cloud/style.css\";i:459;s:23:\"tag-cloud/style.min.css\";i:460;s:28:\"template-part/editor-rtl.css\";i:461;s:32:\"template-part/editor-rtl.min.css\";i:462;s:24:\"template-part/editor.css\";i:463;s:28:\"template-part/editor.min.css\";i:464;s:27:\"template-part/theme-rtl.css\";i:465;s:31:\"template-part/theme-rtl.min.css\";i:466;s:23:\"template-part/theme.css\";i:467;s:27:\"template-part/theme.min.css\";i:468;s:30:\"term-description/style-rtl.css\";i:469;s:34:\"term-description/style-rtl.min.css\";i:470;s:26:\"term-description/style.css\";i:471;s:30:\"term-description/style.min.css\";i:472;s:27:\"text-columns/editor-rtl.css\";i:473;s:31:\"text-columns/editor-rtl.min.css\";i:474;s:23:\"text-columns/editor.css\";i:475;s:27:\"text-columns/editor.min.css\";i:476;s:26:\"text-columns/style-rtl.css\";i:477;s:30:\"text-columns/style-rtl.min.css\";i:478;s:22:\"text-columns/style.css\";i:479;s:26:\"text-columns/style.min.css\";i:480;s:19:\"verse/style-rtl.css\";i:481;s:23:\"verse/style-rtl.min.css\";i:482;s:15:\"verse/style.css\";i:483;s:19:\"verse/style.min.css\";i:484;s:20:\"video/editor-rtl.css\";i:485;s:24:\"video/editor-rtl.min.css\";i:486;s:16:\"video/editor.css\";i:487;s:20:\"video/editor.min.css\";i:488;s:19:\"video/style-rtl.css\";i:489;s:23:\"video/style-rtl.min.css\";i:490;s:15:\"video/style.css\";i:491;s:19:\"video/style.min.css\";i:492;s:19:\"video/theme-rtl.css\";i:493;s:23:\"video/theme-rtl.min.css\";i:494;s:15:\"video/theme.css\";i:495;s:19:\"video/theme.min.css\";}}", "yes");
INSERT INTO `wpgfi_options` VALUES("122", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1698052362;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `wpgfi_options` VALUES("123", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wpgfi_options` VALUES("124", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wpgfi_options` VALUES("590", "wp_mail_smtp_debug", "a:0:{}", "no");
INSERT INTO `wpgfi_options` VALUES("591", "wp_mail_smtp_mail_key", "KrFU8EiKWoYoGmVtp/vox1CBMX6b9OAci/7K2Pxz8IA=", "yes");
INSERT INTO `wpgfi_options` VALUES("5334", "_site_transient_timeout_theme_roots", "1700626066", "no");
INSERT INTO `wpgfi_options` VALUES("5335", "_site_transient_theme_roots", "a:5:{s:15:\"hello-elementor\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}", "no");
INSERT INTO `wpgfi_options` VALUES("585", "wp_mail_smtp_activation_prevent_redirect", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("586", "wp_mail_smtp_review_notice", "a:2:{s:4:\"time\";i:1700184032;s:9:\"dismissed\";b:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("962", "members_addons_migrated", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("579", "action_scheduler_lock_async-request-runner", "1700624917", "yes");
INSERT INTO `wpgfi_options` VALUES("584", "wp_mail_smtp_debug_events_db_version", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("583", "wp_mail_smtp_migration_version", "5", "yes");
INSERT INTO `wpgfi_options` VALUES("592", "wp_mail_smtp_lite_sent_email_counter", "11", "yes");
INSERT INTO `wpgfi_options` VALUES("593", "wp_mail_smtp_lite_weekly_sent_email_counter", "a:4:{i:43;i:4;i:44;i:1;i:45;i:3;i:46;i:3;}", "yes");
INSERT INTO `wpgfi_options` VALUES("595", "wp_mail_smtp_notifications", "a:4:{s:6:\"update\";i:1700624144;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wpgfi_options` VALUES("963", "widget_members-widget-login", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpgfi_options` VALUES("5340", "elementor_pro_remote_info_api_data_3.16.2", "a:2:{s:7:\"timeout\";i:1700667606;s:5:\"value\";s:205526:\"{\"stable_version\":\"3.17.1\",\"last_updated\":\"2022-05-10 14:03:37\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:191311:\\\"<h2>Elementor Pro - by Elementor.com<\\/h2>\\n<h4>3.17.1 - 2023-11-01<\\/h4>\\n<ul>\\n<li>Modified controls sanitization to enforce better security policies in Code Highlight, Form, Lottie, Price List, and Video Playlist widgets<\\/li>\\n<\\/ul>\\n<h4>3.17.0 - 2023-10-25<\\/h4>\\n<ul>\\n<li>Tweak: Added AJAX pagination option or seamless page navigation between content in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>)<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Post widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Loop Grid widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Added a None option to the breakpoint options in Menu widget<\\/li>\\n<li>Tweak: Added a horizontal scrolling option in Menu widget<\\/li>\\n<li>Tweak: Upgraded minimum required PHP version to 7.3<\\/li>\\n<li>Tweak: Improved accessibility when minimize button is disabled in Table of Content widget<\\/li>\\n<li>Fix: Table of Content widget without icons displays <code>undefined<\\/code> error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17523\\\">#17523<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17768\\\">#17768<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18463\\\">#18463<\\/a>)<\\/li>\\n<li>Fix: Hover behavior issues on menu items in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23430\\\">#23430<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22431\\\">#22431<\\/a>)<\\/li>\\n<li>Fix: Links inside Loop Carousel are not working on initial load in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23705\\\">#23705<\\/a>)<\\/li>\\n<li>Fix: Popups accessible navigation adds outlines to the wrong first focusable element<\\/li>\\n<li>Fix: Dropdown area aligned to the left side of the screen if contains Tabs widget in Menu widget<\\/li>\\n<li>Fix: Content horizontal position not aligning correctly when used with carousel widgets in Menu widget<\\/li>\\n<li>Fix: Accessibility errors in PageSpeed Insights in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.16.2 - 2023-09-20<\\/h4>\\n<ul>\\n<li>Fix: Fit to Content dropdown position calculation is incorrect in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23808\\\">#23808<\\/a>)<\\/li>\\n<li>Fix: Reverted hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23804\\\">#23804<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.16.1 - 2023-09-14<\\/h4>\\n<ul>\\n<li>Fix: Dynamic tag for ACF image field is not working as expected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23757\\\">#23757<\\/a>)<\\/li>\\n<li>Fix: Sticky functionality affects padding values in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23758\\\">#23758<\\/a>)<\\/li>\\n<li>Fix: HTML list issues for padding and margin in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.16.0 - 2023-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23607\\\">#23607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22554\\\">#22554<\\/a>)<\\/li>\\n<li>Fix: \'Fallback: Recent Posts\' option malfunctions in the Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21436\\\">#21436<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23259\\\">#23259<\\/a>)<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22056\\\">#22056<\\/a>)<\\/li>\\n<li>Tweak: Used appropriate image <code>alt<\\/code> in Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17680\\\">#17680<\\/a>)<\\/li>\\n<li>Tweak: Optimized Scroll Snap functionality when using Container widget<\\/li>\\n<li>Tweak: Enhanced Elementor Role Manager functionality when using Containers<\\/li>\\n<li>Tweak: Added Notes feature to the Editor Top Bar<\\/li>\\n<li>Tweak: Replace CSS <code>float<\\/code> with other layouts in the Editor<\\/li>\\n<li>Tweak: Upgraded HTML Structure for the Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Carousel and Menu widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to a link in Posts widget<\\/li>\\n<li>Tweak: Loop Builder feature merged to version<\\/li>\\n<li>Fix: Addressed inconsistency in hover effect durations between icon, dropdown indicator colors, and text colors in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22376\\\">#22376<\\/a>)<\\/li>\\n<li>Fix: Slides break if the parent container is set to HTML A tag in Loop Carousel and Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22678\\\">#22678<\\/a>)<\\/li>\\n<li>Fix: The icon size setting is not affecting uploaded SVG icons in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22372\\\">#22372<\\/a>)<\\/li>\\n<li>Fix: Taxonomy filter does not work with slug in foreign characters (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23315\\\">#23315<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Dynamic Tags<\\/li>\\n<li>Fix: Sticky container incorrectly adjusts its width when transitioning from a smaller breakpoint to a larger one within the Editor<\\/li>\\n<\\/ul>\\n<h4>3.15.1 - 2023-08-09<\\/h4>\\n<ul>\\n<li>Fix: Improved code security enforcement in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.15.0 - 2023-07-31<\\/h4>\\n<ul>\\n<li>New: Introducing Taxonomy Filter widget - Empower visitors to seamlessly filter listings in Loop Grids based on taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3140\\\">#3140<\\/a>)<\\/li>\\n<li>Tweak: Added an &quot;Offset Sides&quot; functionality in Carousel and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21114\\\">#21114<\\/a>)<\\/li>\\n<li>Tweak: Modified the size of the Publish button in the Editor Top Bar feature (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22472\\\">#22472<\\/a>)<\\/li>\\n<li>Tweak: Improved Ajax permissions functionality for better security enforcement<\\/li>\\n<li>Tweak: Added option for pagination custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added option for navigation custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added additional styling options for navigation in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added labels to shortcode column in WordPress admin<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in Menu widget<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in My Account widget<\\/li>\\n<li>Tweak: Improved panel UI in Video Playlist widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Price List widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Slides widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Flip Box widget<\\/li>\\n<li>Tweak: Added &quot;Description HTML Tag&quot; in Call To Action widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Share Buttons widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: WooCommerce Status page failed to recognize Elementor WooCommerce widgets<\\/li>\\n<li>Fix: Pagination does not work inside single templates when using Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Incorrect saving of WooCommerce page settings in Elementor site settings under certain scenarios<\\/li>\\n<\\/ul>\\n<h4>3.14.1 - 2023-06-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved navigation on touch devices in Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22827\\\">#22827<\\/a>)<\\/li>\\n<li>Fix: Missing navigation arrows on lightbox in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22870\\\">#22870<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.14.0 - 2023-06-19<\\/h4>\\n<ul>\\n<li>New: Introducing Carousel widget - Infinite design possibilities, and nesting capabilities (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2587\\\">#2587<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>Tweak: Added Static Item Position functionality to Alternate template in Loop Grid widget<\\/li>\\n<li>Tweak: Added visual indication of Page Parts<\\/li>\\n<li>Tweak: Added dividers option between menu items in Menu widget<\\/li>\\n<li>Tweak: Changed the HTML structure of Pagination and Navigation in Loop Carousel and Nested Carousel widgets<\\/li>\\n<li>Tweak: Added shop page in WooCommerce Pages section in Site Settings<\\/li>\\n<li>Tweak: Added Text Shadow, Box Shadow and Padding control to button in Call to Action widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Video Playlist widget<\\/li>\\n<li>Tweak: Added <code>alt<\\/code> attribute to images in Video Playlist widget<\\/li>\\n<li>Tweak: Replaced select control with choose control for Flip Direction control in Flip Box widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Use <code>media_types<\\/code> array in Media controls<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11193\\\">#11193<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19871\\\">#19871<\\/a>)<\\/li>\\n<li>Fix: Responsive settings for templates don\'t work as expected when Additional Custom Breakpoints feature is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16819\\\">#16819<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19394\\\">#19394<\\/a>)<\\/li>\\n<li>Fix: Inner containers are not presented as expected in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21813\\\">#21813<\\/a>)<\\/li>\\n<li>Fix: Popup width does not support percentages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22413\\\">#22413<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x throws errors when using WooCommerce Ajax response (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22199\\\">#22199<\\/a>)<\\/li>\\n<li>Fix: Mini cart template appears as empty in various scenarios in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22789\\\">#22789<\\/a>)<\\/li>\\n<li>Fix: Order by Price doesn\'t work for the Latest products or Manual Selection in Products widget<\\/li>\\n<li>Fix: Dropdown indicator icon is not vertically aligned to the text when using icon in Menu Widget<\\/li>\\n<li>Fix: Mixed content warning in the console for Video Playlist widget<\\/li>\\n<li>Fix: Preview settings are not presented as expected after first save in Loop Template<\\/li>\\n<li>Fix: Not-crawlable link error in Video Playlist widget<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Logo widget<\\/li>\\n<li>Fix: Focus state issue on page load when using Table of Content widget<\\/li>\\n<\\/ul>\\n<h4>3.13.2 - 2023-05-22<\\/h4>\\n<ul>\\n<li>Fix: Hover settings not working as expected on Touch-Enabled devices in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22258\\\">#22258<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.1 - 2023-05-11<\\/h4>\\n<ul>\\n<li>Security Fix: Addressed security weaknesses in access management related functions<\\/li>\\n<li>Fix: Excerpt content pulled from post content is showing with HTML tags in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22367\\\">#22367<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.0 - 2023-05-08<\\/h4>\\n<ul>\\n<li>Tweak: Provided an option to assign excerpt automatically from post content in Post Excerpt dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20256\\\">#20256<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21715\\\">#21715<\\/a>)<\\/li>\\n<li>Tweak: Added Display Conditions functionality in Editor Top bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21675\\\">#21675<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22050\\\">#22050<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor_page_id<\\/code> from request URLs in the WC AJAX calls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18675\\\">#18675<\\/a>)<\\/li>\\n<li>Tweak: Added icons to menu items in Mega Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/21602\\\">#21602<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility to Toggle Button in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/2348\\\">#2348<\\/a>)<\\/li>\\n<li>Tweak: Added \'Active item state\' to top-level menu items for anchor links in the Menu widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Loop Carousel widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Slides widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Media, Testimonial and Reviews Carousel widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to Table of Content widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Search Form widget<\\/li>\\n<li>Tweak: Added accessibility to images in Slides widget<\\/li>\\n<li>Tweak: Added accessibility to images in Call To Action widget<\\/li>\\n<li>Tweak: Added accessibility to images in Media Carousel widget<\\/li>\\n<li>Tweak: Added accessibility to images in Gallery widget<\\/li>\\n<li>Tweak: Added Lazy Load support for avatar image in Post Info widget<\\/li>\\n<li>Tweak: Added Lazy Load support to various Elementor Editor and Admin images<\\/li>\\n<li>Tweak: Added Lazy Load support for author image in Author Box widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Price List widget<\\/li>\\n<li>Fix: Content width is affected by the widget\'s width when Content Width is set to Fit to Content in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21842\\\">#21842<\\/a>)<\\/li>\\n<li>Fix: Empty value on Rows field causes an error in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21451\\\">#21451<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.3 - 2023-04-23<\\/h4>\\n<ul>\\n<li>Fix: Document is not loading after assigning a CSS ID value to a menu item in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21934\\\">#21934<\\/a>)<\\/li>\\n<li>Fix: Elementor CLI causes conflicts with other CLI commands when using PHP 8+ (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21582\\\">#21582<\\/a>)<\\/li>\\n<li>Fix: Dropdown content area is not working as expected with Space Between and Margins in Menu widget<\\/li>\\n<li>Fix: Reverted the option to set a custom icon to Remove Item in Menu Cart widget<\\/li>\\n<li>Fix: Mini cart template appears as empty in various scenarios in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.12.2 - 2023-04-09<\\/h4>\\n<ul>\\n<li>Fix: Mini cart template appears as empty in various WordPress themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21836\\\">#21836<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.1 - 2023-04-02<\\/h4>\\n<ul>\\n<li>Fix: Default background colors are presented as transparent in Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21824\\\">#21824<\\/a>)<\\/li>\\n<li>Fix: Reverted the tweak of Form Submissions feature merged to the version (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21821\\\">#21821<\\/a>)<\\/li>\\n<li>Fix: Dropdown area is not closing when hovering outside of the content area in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.12.0 - 2023-03-29<\\/h4>\\n<ul>\\n<li>New: Introducing the Mega Menu with the new Menu widget - empowers you to achieve a much higher level of menu design, customization, and creativity<\\/li>\\n<li>New: Diversify your design with a Loop Alternate template - apply another template within your Loop Grid for design creativity<\\/li>\\n<li>New: Kickstart your workflow with predesigned Loop container-based templates<\\/li>\\n<li>Tweak: Added custom icon controls to various locations in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13678\\\">#13678<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17941\\\">#17941<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19295\\\">#19295<\\/a>)<\\/li>\\n<li>Tweak: Added a spacing control between navigation and slides in the Loop Carousel<\\/li>\\n<li>Tweak: Added responsive control to the \'Gap between slides\' control in the Loop Carousel<\\/li>\\n<li>Tweak: Added Custom CSS section in Loop Item template<\\/li>\\n<li>Tweak: Added an Article class metadata in Loop Item template<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in CTA widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in Flipbox widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Changed Nav Menu widget name to WordPress Menu widget<\\/li>\\n<li>Tweak: Added &quot;Form Validation&quot; control to Form widget<\\/li>\\n<li>Tweak: Updated custom messages in the Form widget<\\/li>\\n<li>Tweak: Improved accessibility in various elements in Gallery widget<\\/li>\\n<li>Tweak: Form Submissions feature merged to version<\\/li>\\n<li>Tweak: Loop feature promoted to Stable status<\\/li>\\n<li>Tweak: Page Transitions feature promoted to Stable status<\\/li>\\n<li>Tweak: Improved accessibility in filter bar in Gallery widget<\\/li>\\n<li>Tweak: Remove unused <code>aspect-ratio-*<\\/code> CSS classes<\\/li>\\n<li>Fix: Not all active breakpoints appear under &quot;Advanced Rules&quot; in popup publish settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17020\\\">#17020<\\/a>)<\\/li>\\n<li>Fix: Dynamic background image and video is not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.11.7 - 2023-03-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in WooCommerce components<\\/li>\\n<\\/ul>\\n<h4>3.11.6 - 2023-03-14<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in Author Box and Countdown widgets<\\/li>\\n<\\/ul>\\n<h4>3.11.5 - 2023-03-12<\\/h4>\\n<ul>\\n<li>Fix: Hamburger Menu Toggle not showing if breakpoint is set to Tablet Extra in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21003\\\">#21003<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.4 - 2023-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Prevented SVG file upload for better security enforcement in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.11.3 - 2023-02-26<\\/h4>\\n<ul>\\n<li>Fix: Error message appears when submitting a form placed below Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21432\\\">#21432<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x compatibility issues in various places<\\/li>\\n<\\/ul>\\n<h4>3.11.2 - 2023-02-22<\\/h4>\\n<ul>\\n<li>Fix: Save &amp; Back handle from the Loop Carousel becomes inaccessible in some cases ([#21316]<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21316\\\">https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21316<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.1 - 2023-02-15<\\/h4>\\n<ul>\\n<li>Fix: Featured Image dynamic tag is not working in Background images (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21313\\\">#21313<\\/a>)<\\/li>\\n<li>Fix: Time zone is not correct in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17485\\\">#17485<\\/a>)<\\/li>\\n<li>Fix: File upload field is not working in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21341\\\">#21341<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21314\\\">#21314<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.0 - 2023-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Carousel widget - Create powerful &amp; repeating loop templates and populate each one with dynamic content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>New: Added Date and Time Range option to Advanced Rules in Popup<\\/li>\\n<li>Tweak: Improved accessibility when opening and closing a popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9788\\\">#9788<\\/a>)<\\/li>\\n<li>Tweak: Improved accessibility of full-screen mode in Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19907\\\">#19907<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility support to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5861\\\">#5861<\\/a>)<\\/li>\\n<li>Tweak: Add <code>aria-label<\\/code> to read more link in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13784\\\">#13784<\\/a>)<\\/li>\\n<li>Tweak: Use <code>aspect-ratio<\\/code> property instead of CSS trick in Media Carousel widget<\\/li>\\n<li>Tweak: Updated translation string in Stripe widget<\\/li>\\n<li>Fix: Masonry and Columns controls are not working as expected with responsive in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20670\\\">#20670<\\/a>)<\\/li>\\n<li>Fix: Invalid attributes names in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17400\\\">#17400<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working as expected in various widgets<\\/li>\\n<li>Fix: Form fields order is not presented correctly when exported to CSV in Form Submissions<\\/li>\\n<li>Fix: Dynamic background image and video are not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.10.3 - 2023-01-29<\\/h4>\\n<ul>\\n<li>Tweak: Added introduction video to loop item information modal in Theme Builder<\\/li>\\n<li>Fix: PHP 8.x throws errors and notices in some cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21087\\\">#21087<\\/a>)<\\/li>\\n<li>Fix: Infinite Scroll and Load on click pagination are not working as expected in Archive template<\\/li>\\n<li>Fix: Show row even when values do not exist in Form Submissions<\\/li>\\n<\\/ul>\\n<h4>3.10.2 - 2023-01-17<\\/h4>\\n<ul>\\n<li>Fix: Updated compatibility tag for Elementor v3.10<\\/li>\\n<\\/ul>\\n<h4>3.10.1 - 2023-01-09<\\/h4>\\n<p>Fix: Preview Could not be loaded error message appears on pages containing the Loop Grid in a header or footer templates<\\/p>\\n<h4>3.10.0 - 2023-01-09<\\/h4>\\n<ul>\\n<li>New: Added new dynamic tag for due date in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7737\\\">#7737<\\/a>)<\\/li>\\n<li>Tweak: Added <code>modified<\\/code> and <code>comment_count<\\/code> to Order By in posts query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11159\\\">#11159<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>footer<\\/code> tag in Blockquote and Comments widgets for better semantics<\\/li>\\n<li>Fix: Compatibility issue in Imagify Media Library filters due to <code>_elementor_is_screenshot<\\/code> meta filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19988\\\">#19988<\\/a>)<\\/li>\\n<li>Fix: Hotspot Widget label icon height issues when Inline Font Icons experiment is active<\\/li>\\n<li>Fix: Editing glitch when using two loop grid widgets on the same page with the same loop item template<\\/li>\\n<li>Fix: Equal height is not working when using sections in Loop Grid widget<\\/li>\\n<li>Fix: Large amount of menu items are not appearing correctly on a mobile device in Nav Menu widget<\\/li>\\n<li>Fix: Featured Image does not change dynamically when using infinite\\/click pagination in Loop Grid widget<\\/li>\\n<li>Fix: Removed action call of non-existent <code>display_empty_cart_template()<\\/code> method in Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.9.2 - 2022-12-21<\\/h4>\\n<ul>\\n<li>Fix: JS events do not trigger in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20708\\\">#20708<\\/a>)<\\/li>\\n<li>Fix: PHP Errors appear when not using the toggle menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18636\\\">#18636<\\/a>)<\\/li>\\n<li>Fix: Popups\' backgrounds disappear when using Lazy Load Background Images experiment<\\/li>\\n<\\/ul>\\n<h4>3.9.1 - 2022-12-14<\\/h4>\\n<ul>\\n<li>Fix: WooCommerce Product Gallery dynamic tag is not working in Basic Gallery, Gallery and Image Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20678\\\">#20678<\\/a>)<\\/li>\\n<li>Fix: Hide Empty option is not working in Menu Cart widget<\\/li>\\n<li>Fix: The Stripe Button widget doesn\'t work in Templates<\\/li>\\n<\\/ul>\\n<h4>3.9.0 - 2022-12-06<\\/h4>\\n<ul>\\n<li>New: Added support for WooCommerce to Loop Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20020\\\">#20020<\\/a>)<\\/li>\\n<li>Tweak: Added more options to \'Show up to X times\' advanced rule in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8187\\\">#8187<\\/a>)<\\/li>\\n<li>Tweak: Allow saving and reloading a page while editing in-place loop item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19882\\\">#19882<\\/a>)<\\/li>\\n<li>Tweak: Added <code>$location param<\\/code> to <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18453\\\">#18453<\\/a>)<\\/li>\\n<li>Tweak: Removed redundant labels from group controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11666\\\">#11666<\\/a>)<\\/li>\\n<li>Tweak: Added support to use sections and columns as the layout structure of a Loop item template<\\/li>\\n<li>Tweak: Disabled movement when a repeater item is in focus in edit mode<\\/li>\\n<li>Tweak: Upgrade the autoprefixer package to better minify CSS files<\\/li>\\n<li>Tweak: Removed duplicate SQL queries on every page for better performance<\\/li>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Added more units options to Border Width control in various elements<\\/li>\\n<li>Tweak: Added <code>em<\\/code> units to Border Radius control in various elements<\\/li>\\n<li>Tweak: Added \'Equal height\' functionality to Loop Grid widget<\\/li>\\n<li>Fix: Issue with Related Products widget and WooCommerce Pixel Manager plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16934\\\">#16934<\\/a>)<\\/li>\\n<li>Fix: My Account widget gets hidden when using a single page template with post content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19627\\\">#19627<\\/a>)<\\/li>\\n<li>Fix: Cart is not updated when cache enabled in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19312\\\">#19312<\\/a>)<\\/li>\\n<li>Fix: Entrance animations are not working as expected with Infinite Loop and Load on CLick pagination in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20293\\\">#20293<\\/a>)<\\/li>\\n<li>Fix: Loading page issues in Form Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19973\\\">#19973<\\/a>)<\\/li>\\n<li>Fix: Recently Edited date and time not working as expected in Elementor Overview plugin in WordPress dashboard (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17966\\\">#17966<\\/a>)<\\/li>\\n<li>Fix: Recurring license mismatch error message when using translators plugins<\\/li>\\n<li>Fix: Submenu items triggers page transition instead of opening in Nav Menu widget<\\/li>\\n<li>Fix: Query values of Posts widget are not imported correctly when importing a Kit<\\/li>\\n<li>Fix: Loop items are exceeding the widget boundaries in Loop Grid widget<\\/li>\\n<li>Fix: Order by option is not working as expected when choosing Upsells, Cross-Sells and Related Products query in Products widget<\\/li>\\n<li>Fix: Various widgets disappear in certain scenarios when choosing direction Row or Column in Container<\\/li>\\n<\\/ul>\\n<h4>3.8.2 - 2022-11-21<\\/h4>\\n<ul>\\n<li>Fix: Z-index issues when applying sticky to Container<\\/li>\\n<li>Fix: Error message appears on front with Editor and Shop Manager roles when using the Loop Builder widget<\\/li>\\n<\\/ul>\\n<h4>3.8.1 - 2022-11-07<\\/h4>\\n<ul>\\n<li>Fix: Sticky inner section is not staying in the column when applying sticky option in Sections (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20203\\\">#20203<\\/a>)<\\/li>\\n<li>Fix: Post Title widget located in a loop item template disappears when enabling the hide title option inside page settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20207\\\">#20207<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20255\\\">#20255<\\/a>)<\\/li>\\n<li>Fix: ACF Dynamic data not rendering correctly in various scenarios (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20235\\\">#20235<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20258\\\">#20258<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20277\\\">#20277<\\/a>)<\\/li>\\n<li>Fix: Z-index issues when applying sticky to Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20227\\\">#20227<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.8.0 - 2022-10-30<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Builder as a beta status experiment - Create powerful &amp; repeating loop templates and populate each one with dynamic content and design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4440\\\">#4440<\\/a>)<\\/li>\\n<li>Tweak: Add <code>wp_body_open()<\\/code> to header in Header template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11562\\\">#11562<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15828\\\">#15828<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13089\\\">#13089<\\/a>)<\\/li>\\n<li>Tweak: Added support border-radius option to the Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14316\\\">#14316<\\/a>)<\\/li>\\n<li>Tweak: Import\\/Export CLI and UI mechanisms were merged into a unified service<\\/li>\\n<li>Tweak: User with no permission to Notes cannot be mentioned in a note<\\/li>\\n<li>Tweak: User with no permission to view a post cannot be mentioned in a note<\\/li>\\n<li>Tweak: Notes was added to the right click context-menu<\\/li>\\n<li>Tweak: Notes panel can be resizable<\\/li>\\n<li>Tweak: Notes panel can be dragged outside of the canvas in responsive mode in the editor<\\/li>\\n<li>Tweak: Updated form validation messages translation strings in Form widget<\\/li>\\n<li>Tweak: Updated translators comments<\\/li>\\n<li>Tweak: Theme Builder logo and Title should be clickable<\\/li>\\n<li>Tweak: Reduced API requests and DB calls on non-write setup<\\/li>\\n<li>Tweak: Added media queries to the Table of Contents widget<\\/li>\\n<li>Fix: Sticky option is not working as expected in various scenarios in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19540\\\">#19540<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19618\\\">#19618<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19777\\\">#19777<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19827\\\">#19827<\\/a>)<\\/li>\\n<li>Fix: Mixed Content errors on HTTPS in Video Playlist Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18895\\\">#18895<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18945\\\">#18945<\\/a>)<\\/li>\\n<li>Fix: Note\'s timestamp is being updated according to the last activity in Notes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19123\\\">#19123<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17582\\\">#17582<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in pagination in Posts widget<\\/li>\\n<li>Fix: Share buttons is accessible with keyboard but not clickable<\\/li>\\n<li>Fix: Sub-items icons style is missing in preview with Inline Font Icons experiment in Nav Menu widget<\\/li>\\n<li>Fix: Quotes are appearing as HTML when editing a note in Notes<\\/li>\\n<li>Fix: Label\'s Icon height increases when Inline Font Icons experiment is active in Hotspot Widget<\\/li>\\n<li>Fix: Sub conditions of templates are not overridden when importing a Kit<\\/li>\\n<li>Fix: X\\/Y Anchor Point controls were not visible for Scale and Rotate effects<\\/li>\\n<li>Fix: PHP warning notice appears in some situations when using motion effects<\\/li>\\n<\\/ul>\\n<h4>3.7.7 - 2022-09-20<\\/h4>\\n<ul>\\n<li>Fix: Default Flex Grow affects the layout when the container is set to direction Column in various widgets<\\/li>\\n<\\/ul>\\n<h4>3.7.6 - 2022-09-14<\\/h4>\\n<ul>\\n<li>Fix: Submissions menu item appears at the bottom of Elementor section in WordPress dashboard<\\/li>\\n<\\/ul>\\n<h4>3.7.5 - 2022-08-31<\\/h4>\\n<ul>\\n<li>Fix: Error message appears on front if WooCommerce is activated ([#19553] (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19553\\\">https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19553<\\/a>))<\\/li>\\n<\\/ul>\\n<h4>3.7.4 - 2022-08-29<\\/h4>\\n<ul>\\n<li>Tweak: PHP 5.6 Is deprecated<\\/li>\\n<li>Fix: Triangle icon is not being displayed in the Select field when Inline Font Icons Experiment is active in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18598\\\">#18598<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19495\\\">#19495<\\/a>)<\\/li>\\n<li>Fix: The page jumps or flickers to the video playlist on page reload in Video Playlist Widget<\\/li>\\n<\\/ul>\\n<h4>3.7.3 - 2022-07-31<\\/h4>\\n<ul>\\n<li>Tweak: Improved license mechanism for correct validation<\\/li>\\n<li>Fix: Sticky option causes unexpected results when using the Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>)<\\/li>\\n<li>Fix: Price list, Portfolio, Flip Box and Gallery widgets disappear when the direction is set to column in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18880\\\">#18880<\\/a>)<\\/li>\\n<li>Fix: Quotes characher is showing up as <code>&amp;quot;<\\/code> when editing a note in Notes<\\/li>\\n<\\/ul>\\n<h4>3.7.2 - 2022-06-15<\\/h4>\\n<ul>\\n<li>Tweak: Applied optimized file handling in various modules<\\/li>\\n<li>Fix: Related posts query options are missing in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18633\\\">#18633<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18641\\\">#18641<\\/a>)<\\/li>\\n<li>Fix: Menu Cart Icon is not being displayed on all browsers when Inline Font Icons Experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17705\\\">#17705<\\/a>)<\\/li>\\n<li>Fix: Gallery widget is not working as expected in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18408\\\">#18408<\\/a>)<\\/li>\\n<li>Fix: Flip box is not visible when the direction is set to Row in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18413\\\">#18413<\\/a>)<\\/li>\\n<li>Fix: Portfolio widget is not visible when dragged into &quot;Row&quot; direction Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17653\\\">#17653<\\/a>)<\\/li>\\n<li>Fix: Menu cart is open automatically in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18629]\\\">#18629<\\/a><\\/li>\\n<li>Fix: PHP error is being shown the license is expired in License screen<\\/li>\\n<\\/ul>\\n<h4>3.7.1 - 2022-05-16<\\/h4>\\n<ul>\\n<li>Fix: Notes icon appears as an empty square in admin top bar for users with permissions lower than Editor<\\/li>\\n<li>Fix: Notes experiment causes a PHP fatal error on some cases<\\/li>\\n<li>Fix: UI glitches in Notes feature<\\/li>\\n<\\/ul>\\n<h4>3.7.0 - 2022-05-10<\\/h4>\\n<ul>\\n<li>New: Introducing Notes - Work collaboratively directly within Elementor<\\/li>\\n<li>New: Stripe Button widget - Collect Stripe payments directly from your site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14748\\\">#14748<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Add to Cart dynamic tag - add products to cart from every widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10607\\\">#10607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11801\\\">#11801<\\/a>)<\\/li>\\n<li>New: Added WooCommerce Product Content dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16367\\\">#16367<\\/a>)<\\/li>\\n<li>Tweak: Added Related, Upsells and Cross-Sells query sources to Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8071\\\">#8071<\\/a>)<\\/li>\\n<li>Tweak: Added custom icon control to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18007\\\">#18007<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14357\\\">#14357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13151\\\">#13151<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11361\\\">#11361<\\/a>)<\\/li>\\n<li>Tweak: Added an option to minimize on Desktop device in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9933\\\">#9933<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10729\\\">#10729<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10314\\\">#10314<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6691\\\">#6691<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11774\\\">#11774<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9051\\\">#9051<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5760\\\">#5760<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9774\\\">#9774<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom option in various Product widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10263\\\">#10263<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom control in Posts and Archive Posts widgets<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added percentage unit to padding control in Additional Information customize section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added quick link to create new theme parts directly from the Finder<\\/li>\\n<li>Tweak: Added the option to add a custom template to Dashboard screen in My Account widget<\\/li>\\n<li>Tweak: Added spacing control to view cart button in various product widgets<\\/li>\\n<li>Tweak: Added the option to add a custom template to empty cart state in Cart widget<\\/li>\\n<li>Tweak: Adjusted the layout of the Payment Methods screen in the My Account widget<\\/li>\\n<li>Tweak: Added lazy load option to Media Carousel, Reviews and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added Site Identity quick link to Logo widget<\\/li>\\n<li>Tweak: Added Site Identity quick link to Site Title widget<\\/li>\\n<li>Tweak: Created an attribute that allows disabling page transition for specific links<\\/li>\\n<li>Tweak: Added dynamic tag controls to Gallery widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Countdown widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Portfolio widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Price Table widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Login widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Blockquote widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Facebook Comments widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post Navigation widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Search Form widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Author Box widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post info widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Posts widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Product Meta widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Products widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Sitemap widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Reviews widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Code Highlight widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to PayPal Button widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added missing PHP documentation to hooks<\\/li>\\n<li>Fix: Scrolling glitches on mobile devices when Sticky Effect is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17767\\\">#17767<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18330\\\">#18330<\\/a>)<\\/li>\\n<li>Fix: Only 1st honypot field is validated when using multiple honeypot fields in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18136\\\">#18136<\\/a>)<\\/li>\\n<li>Fix: Checkout button background color is not working as expected in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18289\\\">#18289<\\/a>)<\\/li>\\n<li>Fix: Button labels are not accessible for screen readers in Share buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<li>Fix: Downloads titles controls are not working in responsive in WooCommerce Purchase Summary widget<\\/li>\\n<li>Fix: Excerpt length is not working as expected in Posts and Archive Posts widgets<\\/li>\\n<li>Fix: Titles &amp; Totals weight is not working in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Product image is not appearing on Single Product Page on template load<\\/li>\\n<li>Fix: Additional Information title not editable in some scenarios in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in Cart widget<\\/li>\\n<li>Fix: UI Glitch in Masonry control in Portfolio widget<\\/li>\\n<li>Fix: Custom breakpoints experiment didn\'t work on Single post and page templates<\\/li>\\n<li>Fix: Testimonial carousel &amp; Reviews widgets disregards the <code>alt<\\/code> attribute<\\/li>\\n<li>Fix: Playlist widget deeplink didn\'t send user directly to the widget in the page<\\/li>\\n<li>Fix: Masonry option causes the images to disappear in the Editor in Posts widget<\\/li>\\n<li>Fix: Scrollbar appears after clicking on the dropdown toggle in Nav Menu widget<\\/li>\\n<li>Fix: Custom icons disappear on frontend if the pack name contains numbers<\\/li>\\n<li>Fix: Custom Font disappears if the name contains only numbers<\\/li>\\n<li>Fix: <code>end-section()<\\/code> is missing from Progress Tracker and Facebook Embed widgets<\\/li>\\n<li>Tweak: Added a filter for conditions cache query in Theme Builder<\\/li>\\n<li>Fix: Customizations lost on Ajax refresh in WooCommerce Cart widget<\\/li>\\n<li>Fix: Hello theme Header and Footer experiment is not working when WooCommerce plugin is active<\\/li>\\n<li>Fix: Color controls are not working as expected in Checkout widget<\\/li>\\n<li>Fix: Color controls are not working as expected in My Account widget<\\/li>\\n<li>Fix: Empty state widget preview in the editor is disappearing in various widgets<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in WooCommerce Cart widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-7-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.6.5 - 2022-04-12<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issues for several widgets in iOS 14 and macOS 13 devices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18090\\\">#18090<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15910\\\">#15910<\\/a>)<\\/li>\\n<li>Fix: Button Alignment doesn\'t work in Custom Add To Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17810\\\">#17810<\\/a>)<\\/li>\\n<li>Fix: PHP warning is thrown in some cases in PayPal button widget<\\/li>\\n<li>Fix: PHP 8.1 throws errors and notices in some cases<\\/li>\\n<li>Fix: PHP notice was thrown when Kit Import process initiated without display conditions<\\/li>\\n<li>Fix: Create Account button always opens on the Sign Up screen even if the user has an account in Onboarding process<\\/li>\\n<\\/ul>\\n<h4>3.6.4 - 2022-03-15<\\/h4>\\n<ul>\\n<li>Tweak: Kit import dynamic reference support for templates and dynamic tags<\\/li>\\n<li>Tweak: Updated tested up to version tag to <code>3.6.0<\\/code><\\/li>\\n<li>Fix: Sticky caused scrolling issues after clicking an element that expands the page height (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17821\\\">#17821<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17839\\\">#17839<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18069\\\">#18069<\\/a>)<\\/li>\\n<li>Fix: When saving Global widget JS error is being thrown and editor fails to load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17954\\\">#17954<\\/a>)<\\/li>\\n<li>Fix: Motion effects are missing from Background section under Style tab in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18063\\\">#18063<\\/a>)<\\/li>\\n<li>Fix: Imported Kit doesn\'t appear in the theme builder after successful import in some cases<\\/li>\\n<li>Fix: Added future Pro support to fix the Cart icon that shifted aside in Menu cart widget<\\/li>\\n<\\/ul>\\n<h4>3.6.3 - 2022-02-28<\\/h4>\\n<ul>\\n<li>Fix: Custom Code display conditions modal is not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17865\\\">#17865<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17942\\\">#17942<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17994\\\">#17994<\\/a>)<\\/li>\\n<li>Fix: Share buttons are not accessible for keyboard navigation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.6.2 - 2022-02-14<\\/h4>\\n<ul>\\n<li>Fix: Auto updates mechanism is not working as expected (this version might be also installed automatically)<\\/li>\\n<\\/ul>\\n<h4>3.6.1 - 2022-02-09<\\/h4>\\n<ul>\\n<li>Tweak: Allow connecting via generic source for future feature support<\\/li>\\n<li>Fix: Custom Code doesn\'t work when WooCommerce is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17675\\\">#17675<\\/a>)<\\/li>\\n<li>Fix: Content animation didn\'t work when Improved asset loading experiment is active Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17055\\\">#17055<\\/a>)<\\/li>\\n<li>Fix: PHP warning appears some times when trying to force-check for available updates<\\/li>\\n<li>Fix: Page transitions are being triggered when not needed<\\/li>\\n<li>Fix: Text alignment on Tablet responsive device affects base device in Testimonial Carousel widget<\\/li>\\n<li>Fix: Harden Submissions feature to prevent potential security issues<\\/li>\\n<li>Fix: Page Transitions Icon option Preloader doesn\'t work on frontend<\\/li>\\n<\\/ul>\\n<h4>3.6.0 - 2022-01-31<\\/h4>\\n<ul>\\n<li>New: WooCommerce Purchase Summary widget - Fully customize the content and style of your order summary page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5756\\\">#5756<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15862\\\">#15862<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices styling on Site Settings - Customize the appearance of WooCommerce notices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14570\\\">#14570<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15896\\\">#15896<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices widget - Set the position of WooCommerce notices on your shop pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8124\\\">#8124<\\/a>)<\\/li>\\n<li>Experiment: Page Transitions - Customize the page loading experience, and increase brand recognition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10576\\\">#10576<\\/a>)<\\/li>\\n<li>Tweak: Added WooCommerce &amp; Theme Elements widgets to Improved CSS Loading experiment to save up 126KB per page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17412\\\">#17412<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17337\\\">#17337<\\/a>)<\\/li>\\n<li>Tweak: Added new layout options in WooCommerce Add To Cart and WooCommerce Custom Add To Cart widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5437\\\">#5437<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10617\\\">#10617<\\/a>)<\\/li>\\n<li>Tweak: Added Stroke functionality for typography control in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11158\\\">#11158<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor-section-wrap<\\/code> by adding it to the Optimized DOM Output experiment (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16950\\\">#16950<\\/a>)<\\/li>\\n<li>Tweak: Added style controls for variations in WooCommerce Menu Cart widget<\\/li>\\n<li>Tweak: Added color control to navigation dots in Media Carousel, Reviews, and Slides widgets<\\/li>\\n<li>Tweak: Disabled Vimeo autoplay on edit mode when getting video data in Video Playlist widget<\\/li>\\n<li>Tweak: Added notice about Facebook\'s new EU consent policy in Facebook Button, Facebook Comments, Facebook Embed, and Facebook Page widgets<\\/li>\\n<li>Tweak: Refactor string translation calls to use native WP translation methods<\\/li>\\n<li>Tweak: Convert <code>home_url<\\/code> license API call to <code>get_site_url<\\/code> for better compatibility<\\/li>\\n<li>Tweak: Promoted Default to New Theme Builder and Scroll Snap experiments to Stable status in Experiments screen<\\/li>\\n<li>Tweak: Scroll Snap experiment set to active by default for all websites in Experiments screen<\\/li>\\n<li>Tweak: Scrolling Effects in Header and Section backgrounds are not working as expected when effects are relative to the entire page<\\/li>\\n<li>Tweak: Added &quot;Auto Updates&quot; capability to Pro versions<\\/li>\\n<li>Tweak: Removed sequenced animation hover effect option from Classic skin in Call to Action widget<\\/li>\\n<li>Tweak: Added &quot;Excerpt Length&quot; control in Post Excerpt widget<\\/li>\\n<li>Tweak: Deleted deprecated methods from Query Control module<\\/li>\\n<li>Tweak: Adjusted Inline-CSS Experiment to work with Additional Custom Breakpoints experiment<\\/li>\\n<li>Fix: Automatically open cart functionality didn\'t work in product page in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5921\\\">#5921<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16276\\\">#16276<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16879\\\">#16879<\\/a>)<\\/li>\\n<li>Fix: Buttons are not visible when there are too many products in the cart in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17283\\\">#17283<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13005\\\">#13005<\\/a>)<\\/li>\\n<li>Fix: Mini cart modal z-index is too low in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>)<\\/li>\\n<li>Fix: Side cart buttons are not visible at first glance on mobile in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>)<\\/li>\\n<li>Fix: Read More field recognizes inline HTML elements as plain text in Posts and Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16985\\\">#16985<\\/a>)<\\/li>\\n<li>Fix: Load More functionality caused JS error console in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17036\\\">#17036<\\/a>)<\\/li>\\n<li>Fix: Autoplay is not working as expected when the lazy load is active in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15304\\\">#15304<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16274\\\">#16274<\\/a>)<\\/li>\\n<li>Fix: Right navigation area wasn\'t 100% clickable in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14252\\\">#14252<\\/a>)<\\/li>\\n<li>Fix: Posts duplicate when there are two Posts widgets inside a page using pagination functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17056\\\">#17056<\\/a>)<\\/li>\\n<li>Fix: Global widget changes are not reflected on frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16820\\\">#16820<\\/a>)<\\/li>\\n<li>Fix: JS Error console message when using the Load More functionality and Post Per Page option in Posts widget<\\/li>\\n<li>Fix: Heading styling is not being loaded when Inline CSS experiment is active in Post and Page Title widgets<\\/li>\\n<li>Fix: Sticky offset not working as expected when changing device mode on the browser<\\/li>\\n<li>Fix: Scroll Snap functionality wasn\'t applied on Templates and Archives<\\/li>\\n<li>Fix: Toggle icon color didn\'t work on hover state when Inline Font Icons experiment is activated in Nav Menu widget<\\/li>\\n<li>Fix: Variations style controls are not working as expected in WooCommerce Add to Cart widget<\\/li>\\n<li>Fix: Display conditions module is not working as expected when using the new Theme Builder UI<\\/li>\\n<li>Fix: Edit header handles <code>z-index<\\/code> issues in Header document<\\/li>\\n<li>Fix: Panel icons UI glitch in Call To Action widget<\\/li>\\n<li>Fix: WordPress 5.9 <code>WP_User_query<\\/code> <code>who<\\/code> argument deprecation adjustments<\\/li>\\n<\\/ul>\\n<h4>3.5.2 - 2021-11-28<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted license mechanism to support trial period<\\/li>\\n<li>Fix: Updates made to Global Widgets do not reflect accordingly to linked widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815\\\">#16815<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle button doesn\'t change to \\u201cclose\\u201d when menu is collapsed in Nav Menu widget when Inline Font Awesome experiment is active<\\/li>\\n<li>Fix: Global Widget cannot be unlinked<\\/li>\\n<\\/ul>\\n<h4>3.5.1 - 2021-11-10<\\/h4>\\n<ul>\\n<li>Fix: Inline HTML elements appear as plain text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16816\\\">#16816<\\/a>)<\\/li>\\n<li>Fix: Dropdown items inherited values from Main Menu space between control in Nav Menu widget (<a href=\\\"(https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815)\\\">#16815<\\/a><\\/li>\\n<li>Fix: Order Summary titles style controls not applying on various devices in Cart widget<\\/li>\\n<li>Fix: Panel &quot;Need Help&quot; link is not correct in WooCommerce section in Site Settings<\\/li>\\n<\\/ul>\\n<h4>3.5.0 - 2021-11-01<\\/h4>\\n<ul>\\n<li>New: WooCommerce Checkout widget - Fully customize the content and style of your checkout page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15990\\\">#15990<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce Cart widget - Style your cart page the way you want with design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce My Account widget - Create a custom design for your my account pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: Progress Tracker widget - Motivate your customers to keep reading your site content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16576\\\">#16576<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Site Settings - Set your store pages within Elementor<\\/li>\\n<li>Experiment: Scroll Snap - Set the scene of every scroll (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10752\\\">#10752<\\/a>)<\\/li>\\n<li>Tweak: Changed infrastructure to prevent rendering bugs in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16354\\\">#16354<\\/a>)<\\/li>\\n<li>Tweak: Added the option to open submission in a new tab in Form Submissions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14967\\\">#14967<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive controls in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1851\\\">#1851<\\/a>)<\\/li>\\n<li>Tweak: Split Title and Price styling controls in Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7688\\\">#7688<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive capabilities to controls in Posts Archive widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Changed admin notice content when Pro installed without Core installed<\\/li>\\n<li>Tweak: Cleanup in <code>wp_options<\\/code> table<\\/li>\\n<li>Tweak: Changed Connect logic in Elementor top bar to simplify the connect process<\\/li>\\n<li>Tweak: Marked new Theme Builder as an Experiment and set to default for new sites<\\/li>\\n<li>Tweak: Enforced better security policies in various widgets and modules<\\/li>\\n<li>Tweak: Added load more button functionality to the Posts Archive widget<\\/li>\\n<li>Tweak: Renamed Elementor\'s responsive SCSS variables<\\/li>\\n<li>Tweak: Added dividers to horizontal layout in Nav Menu widget<\\/li>\\n<li>Tweak: Removed Google+ social network from Share Buttons widget<\\/li>\\n<li>Tweak: Convert usage of old Responsive class to use the new Breakpoints Manager<\\/li>\\n<li>Fix: jQuery in Heading doesn\'t work for not logged in users in Custom Code (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14515\\\">#14515<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14266\\\">#14266<\\/a>)<\\/li>\\n<li>Fix: Menu animation causing page horizontal scroll in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15184\\\">#15184<\\/a>)<\\/li>\\n<li>Fix: Wrong function call in Table of Content &amp; Post Excerpt widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16547\\\">#16547<\\/a>)<\\/li>\\n<li>Fix: Slides to Scroll control can\'t be set to Default if Widescreen mode has a value in Testimonial Carousel widget<\\/li>\\n<li>Fix: Sticky offset not working properly when changing device mode<\\/li>\\n<li>Fix: UTF character issues when exporting CSV file in Form Submissions<\\/li>\\n<li>Fix: Load More functionality doesn\'t work when the Posts widget placed inside an Archive template<\\/li>\\n<li>Fix: UI glitches and editing issues in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.4.2 - 2021-10-12<\\/h4>\\n<ul>\\n<li>Fix: Icons color style conflicts when Font-Awesome Inline experiment is active in Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16435\\\">#16435<\\/a>)<\\/li>\\n<li>Fix: Mini Cart hides page content when closed in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16305\\\">#16305<\\/a>)<\\/li>\\n<li>Fix: UI glitches in the Editor edit mode when inserting Post Content widget and Font-Awesome Inline experiment is active in Single Post template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16358\\\">#16358<\\/a>)<\\/li>\\n<li>Fix: Slides per view controls disappeared from multiple breakpoints in Testimonial Carousel<\\/li>\\n<li>Fix: Product variations UI glitch in Menu Cart widget<\\/li>\\n<li>Fix: Buttons UI glitch on Safari browser in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>ElementorUtils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: \\u201cSave &amp; Close \\u201cbutton in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-14<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"#11475\\\"><a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475\\\">https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475<\\/a><\\/a>, <a href=\\\"#10690\\\"><a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690<\\/a><\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor v3.1.0<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging  Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.10.3 - 2020-06-29<\\/h4>\\n<ul>\\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11596\\\">#11596<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11610\\\">#11610<\\/a>)<\\/li>\\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8646\\\">#8646<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.2 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11644\\\">#11644<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.1 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets<\\/li>\\n<li>Fix: Popup close button vertical position glitch (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10921\\\">#10921<\\/a>)<\\/li>\\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget<\\/li>\\n<li>Fix: Clicking <code>Enter<\\/code> key submits the form in Multi Step Form<\\/li>\\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues<\\/li>\\n<\\/ul>\\n<h4>2.10.0 - 2020-06-07<\\/h4>\\n<ul>\\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5975\\\">#5975<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3911\\\">#3911<\\/a>)<\\/li>\\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11026\\\">#11026<\\/a>)<\\/li>\\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5682\\\">#5682<\\/a>)<\\/li>\\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices<\\/li>\\n<li>Tweak: Added new Scroll Util for improved scrolling handling<\\/li>\\n<li>Tweak: Improved Motion Effects animation performance<\\/li>\\n<\\/ul>\\n<h4>2.9.5 - 2020-05-24<\\/h4>\\n<ul>\\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue<\\/li>\\n<\\/ul>\\n<h4>2.9.4 - 2020-05-07<\\/h4>\\n<ul>\\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability<\\/li>\\n<\\/ul>\\n<h4>2.9.3 - 2020-04-19<\\/h4>\\n<ul>\\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11023\\\">#11023<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10932\\\">#10932<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10967\\\">#10967<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11000\\\">#11000<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11049\\\">#11049<\\/a>)<\\/li>\\n<li>Fix: Escaped Form records metadata to prevent security vulnerability<\\/li>\\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading<\\/li>\\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget<\\/li>\\n<li>Fix: Document handles UI glitch<\\/li>\\n<\\/ul>\\n<h4>2.9.2 - 2020-03-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10745\\\">#10745<\\/a>)<\\/li>\\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10874\\\">#10874<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style<\\/li>\\n<li>Fix: PHP notice when using dynamic user info <code>id<\\/code><\\/li>\\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget<\\/li>\\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget<\\/li>\\n<li>Fix: Container includes Popup tags by default in Table of Contents widget<\\/li>\\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<\\/ul>\\n<h4>2.9.1 - 2020-03-16<\\/h4>\\n<ul>\\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page<\\/li>\\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles<\\/li>\\n<\\/ul>\\n<h4>2.9.0 - 2020-03-15<\\/h4>\\n<ul>\\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4985\\\">#4985<\\/a>)<\\/li>\\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3345\\\">#3345<\\/a>)<\\/li>\\n<li>New: Added Dynamic Colors tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6485\\\">#6485<\\/a>)<\\/li>\\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9293\\\">#9293<\\/a>)<\\/li>\\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5716\\\">#5716<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3642\\\">#3642<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9225\\\">#9225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9079\\\">#9079<\\/a>)<\\/li>\\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10564\\\">#10564<\\/a>)<\\/li>\\n<li>Tweak: Avoid creating empty Custom Font<\\/li>\\n<li>Tweak: Added <code>aria-expanded<\\/code> attribute to Menu Cart widget<\\/li>\\n<li>Tweak: Moved Link Actions module to Core plugin<\\/li>\\n<li>Tweak: Changed the name of \\u201cTypeKit Web Fonts by Adobe\\u201d to \\u201cAdobe Fonts\\u201d<\\/li>\\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets<\\/li>\\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated<\\/li>\\n<li>Tweak: Remove redundant <code>label_block<\\/code> parameters from several controls<\\/li>\\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget<\\/li>\\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7924\\\">#7924<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0<\\/li>\\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets<\\/li>\\n<li>Tweak: Expose external API for Swiper instances<\\/li>\\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget<\\/li>\\n<li>Tweak: Replaced nerd icons with new Elementor emojis<\\/li>\\n<li>Tweak: Added specific <code>color<\\/code> attribute to header title in Table of Contents widget<\\/li>\\n<li>Fix: Line break issues in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10585\\\">#10585<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color overrides the Table of Content list style<\\/li>\\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode<\\/li>\\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget<\\/li>\\n<li>Fix: Page Title widget render glitches in the Editor<\\/li>\\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget<\\/li>\\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget<\\/li>\\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v2-9-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.8.5 - 2020-03-08<\\/h4>\\n<ul>\\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration<\\/li>\\n<li>Fix: Missing closing bracket in Animated Headline widget<\\/li>\\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor<\\/li>\\n<\\/ul>\\n<h4>2.8.4 - 2020-02-16<\\/h4>\\n<ul>\\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget<\\/li>\\n<li>Tweak: Added RTL support for Slides widget<\\/li>\\n<li>Tweak: Display Lightbox images in Full size in Gallery widget<\\/li>\\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget<\\/li>\\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget<\\/li>\\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget<\\/li>\\n<li>Fix: Query Control throws <code>Undefined index: q<\\/code> error<\\/li>\\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget<\\/li>\\n<li>Fix: Discord forms integration fails to send submissions in some server configurations<\\/li>\\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget<\\/li>\\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget<\\/li>\\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser<\\/li>\\n<li>Fix: Missing eye icon in Single template footer preview button<\\/li>\\n<\\/ul>\\n<h4>2.8.3 - 2020-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Updated Table of Contents widget panel location<\\/li>\\n<li>Fix: ACF URL Dynamic field throws <code>undefined index<\\/code> PHP notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9929\\\">#9929<\\/a>)<\\/li>\\n<li>Fix: Gallery lightbox pagination shows images from all tabs<\\/li>\\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<li>Fix: Underline option not working in Table of Contents widget Normal state<\\/li>\\n<li>Fix: Query Control <code>Undefined index: autocomplete<\\/code> notice in some cases<\\/li>\\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.8.2 - 2019-12-19<\\/h4>\\n<ul>\\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget<\\/li>\\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive<\\/li>\\n<li>Fix: Redundant <code>&lt;br&gt;<\\/code> tags in Single theme template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9927\\\">#9927<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9928\\\">#9928<\\/a>)<\\/li>\\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown<\\/li>\\n<\\/ul>\\n<h4>2.8.1 - 2019-12-18<\\/h4>\\n<ul>\\n<li>Fix: Share Buttons widget not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9920\\\">#9920<\\/a>)<\\/li>\\n<li>Fix: Redundant <code>&lt;p&gt;<\\/code> tags added to Single Template posts<\\/li>\\n<\\/ul>\\n<h4>2.8.0 - 2019-12-18<\\/h4>\\n<ul>\\n<li>New: Table of Contents Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5171\\\">#5171<\\/a>)<\\/li>\\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9763\\\">#9763<\\/a>)<\\/li>\\n<li>Tweak: Added Random order option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9269\\\">#9269<\\/a>)<\\/li>\\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9324\\\">#9324<\\/a>)<\\/li>\\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9579\\\">#9579<\\/a>)<\\/li>\\n<li>Tweak: Major performance improvements to Gallery widget<\\/li>\\n<li>Tweak: Avoid non-existing images in Gallery widget<\\/li>\\n<li>Tweak: Added <code>tabindex<\\/code>, <code>aria-expanded<\\/code>, <code>aria-hidden<\\/code> and <code>role=\\\"navigation\\\"<\\/code> accessibility attributes to Nav Menu widget<\\/li>\\n<li>Tweak: Changed button HTML tag from <code>button<\\/code> to <code>span<\\/code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility<\\/li>\\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget<\\/li>\\n<li>Tweak: Added compatibility for Library Connect<\\/li>\\n<li>Tweak: Added i18n to Toolset date dynamic tag<\\/li>\\n<li>Tweak: Added external link support to Gallery widget<\\/li>\\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()<\\/code> in Gallery widget<\\/li>\\n<li>Tweak: Updated references to the new Schemes system location<\\/li>\\n<li>Tweak: Avoid running Gallery handler when the gallery is empty<\\/li>\\n<li>Tweak: UI Tweaks in Editor Panel<\\/li>\\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget<\\/li>\\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget<\\/li>\\n<li>Tweak: Refactor <code>register_controls()<\\/code> method in Posts widget skin trait<\\/li>\\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7646\\\">#7646<\\/a>)<\\/li>\\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9304\\\">#9304<\\/a>)<\\/li>\\n<li>Fix: <code>PHP Notice: Undefined index<\\/code> display for Author query (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9864\\\">#9864<\\/a>)<\\/li>\\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/broken-buttons-since-elementor-2-8\\/\\\">Topic<\\/a>)<\\/li>\\n<li>Fix: Avoid empty spaces in Post info widget<\\/li>\\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget<\\/li>\\n<li>Fix: Nav Menu item typography selector in Nav Menu widget<\\/li>\\n<li>Fix: Facebook Like Button widget causes flickering<\\/li>\\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain<\\/code> permalinks format<\\/li>\\n<li>Fix: Avoid running Popup triggers when set without conditions<\\/li>\\n<li>Fix: Removed &quot;Date&quot; query from Products widget<\\/li>\\n<li>Fix: Slides widget when used as a Shortcode and is hidden<\\/li>\\n<li>Fix: Custom URL being accessed on swipe in Media Carousel<\\/li>\\n<li>Fix: Media Carousel widget Cube effect glitch<\\/li>\\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page<\\/li>\\n<li>Fix: Image <code>alt<\\/code> Text not displayed on overlay in Gallery widget<\\/li>\\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin<\\/li>\\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable<\\/code><\\/li>\\n<li>Fix: Slides widget button wrapping breaks in mobile view<\\/li>\\n<li>Fix: Dynamic capabilities with the Reviews widget<\\/li>\\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget<\\/li>\\n<li>Fix: Posts widget Full Content skin not working on Single template<\\/li>\\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen<\\/li>\\n<li>Fix: Posts widget alignment issue<\\/li>\\n<li>Fix: Product Variations Clear button not working in edge cases<\\/li>\\n<li>Fix: Styling issues in Form widget submit button<\\/li>\\n<\\/ul>\\n<h4>2.7.3 - 2019-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added RTL support to Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9213\\\">#9213<\\/a>)<\\/li>\\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3<\\/li>\\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget<\\/li>\\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets<\\/li>\\n<li>Fix: Link-actions conflict with <code>?action=<\\/code> parameter in the URL<\\/li>\\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode<\\/li>\\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets<\\/li>\\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.7.2 - 2019-10-06<\\/h4>\\n<ul>\\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9209\\\">#9209<\\/a>)<\\/li>\\n<li>Fix: Content width glitch in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display<\\/code> CSS<\\/li>\\n<\\/ul>\\n<h4>2.7.1 - 2019-09-26<\\/h4>\\n<ul>\\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery<\\/li>\\n<\\/ul>\\n<h4>2.7.0 - 2019-09-24<\\/h4>\\n<ul>\\n<li>New: Enhanced Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1898\\\">#1898<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3103\\\">#3103<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4279\\\">#4279<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7631\\\">#7631<\\/a>)<\\/li>\\n<li>New: Dynamic Number (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5952\\\">#5952<\\/a>)<\\/li>\\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4617\\\">#4617<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets<\\/li>\\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5418\\\">#5418<\\/a>)<\\/li>\\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7947\\\">#7947<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8740\\\">#8740<\\/a>)<\\/li>\\n<li>Tweak: Added <code>font-display<\\/code> support to custom fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5993\\\">#5993<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-custom-fonts-font-display-support\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8800\\\">#8800<\\/a>)<\\/li>\\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8799\\\">#8799<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9030\\\">#9030<\\/a>)<\\/li>\\n<li>Tweak: Use <code>swiper.js<\\/code> instead of <code>slick.js<\\/code> in Slides widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-2-7-moving-sliders-from-slick-to-swiper\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/before_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/after_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic support for Custom field key (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7789\\\">#7789<\\/a>)<\\/li>\\n<li>Tweak: Increased expired license notice bar frequency<\\/li>\\n<li>Tweak: Changed the icon name of Slides widget<\\/li>\\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts<\\/li>\\n<li>Tweak: Use Ken Burns Effect as an external module<\\/li>\\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets<\\/li>\\n<li>Tweak: Editor Panel UI tweaks<\\/li>\\n<li>Tweak: Added DOM events on Popup show\\/hide (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-popup-events\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added option to change the variations field width in Add to Cart widget<\\/li>\\n<li>Tweak: Use select control instead of select2 in Menu Cart widget<\\/li>\\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget<\\/li>\\n<li>Tweak: Added Typography controls to HTML field in Forms widget<\\/li>\\n<li>Tweak: Allow edit selected Font file in Custom Font<\\/li>\\n<li>Tweak: Changed reCAPTCHA v3 error message<\\/li>\\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu<\\/li>\\n<li>Fix: Corrected selector for <code>removeControlSpinner()<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8790\\\">#8790<\\/a>)<\\/li>\\n<li>Fix: Slides widget navigation icons misplacement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8533\\\">#8533<\\/a>)<\\/li>\\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8527\\\">#8527<\\/a>)<\\/li>\\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1671\\\">#1671<\\/a>)<\\/li>\\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7347\\\">#7347<\\/a>)<\\/li>\\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs<\\/li>\\n<li>Fix: Removed unnecessary divider in Call to Action widget<\\/li>\\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity<\\/code> is enabled.<\\/li>\\n<li>Fix: Add support for Document\\/PageBase in Theme Builder (Core &gt;=2.7.0)<\\/li>\\n<li>Fix: Ampersand character breaks email link in Share Buttons widget<\\/li>\\n<li>Fix: Correct custom font attachment <code>mime-type<\\/code> to show uploaded Custom Fonts<\\/li>\\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget<\\/li>\\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated<\\/li>\\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving<\\/li>\\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen<\\/li>\\n<li>Fix: Translations and Strings in Share Buttons widget<\\/li>\\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control<\\/li>\\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget<\\/li>\\n<\\/ul>\\n<h4>2.6.5 - 2019-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Button style not working when <code>quantity<\\/code> is enabled in Custom Add To Cart widget<\\/li>\\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>2.6.4 - 2019-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility<\\/li>\\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget<\\/li>\\n<\\/ul>\\n<h4>2.6.3 - 2019-08-18<\\/h4>\\n<ul>\\n<li>Fix: Core version rollback to <code>&gt;2.6.0<\\/code> causes a fatal error<\\/li>\\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox<\\/li>\\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge<\\/li>\\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings<\\/li>\\n<\\/ul>\\n<h4>2.6.2 - 2019-07-30<\\/h4>\\n<ul>\\n<li>Tweak: Better accessibility support in Search Form widget<\\/li>\\n<li>Fix: UI glitched in Popup publish screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8616\\\">#8616<\\/a>)<\\/li>\\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8695\\\">#8695<\\/a>)<\\/li>\\n<li>Fix: Restored <code>library_widget_templates<\\/code> action hook for 3rd party compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8687\\\">#8687<\\/a>)<\\/li>\\n<li>Fix: Twitter Icon missing in Blockquote widget<\\/li>\\n<li>Fix: Form reCAPTCHA v3 badge position not working<\\/li>\\n<li>Fix: Renewal notice bar appears in wrong situations<\\/li>\\n<li>Fix: Draft Icon Set loads empty Icon Library<\\/li>\\n<\\/ul>\\n<h4>2.6.1 - 2019-07-24<\\/h4>\\n<ul>\\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8672\\\">#8672<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8661\\\">#8661<\\/a>)<\\/li>\\n<li>Fix: Price Table features section not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8660\\\">#8660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.6.0 - 2019-07-23<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/110\\\">#110<\\/a>)<\\/li>\\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4430\\\">#4430<\\/a>)<\\/li>\\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8213\\\">#8213<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6039\\\">#6039<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7165\\\">#7165<\\/a>)<\\/li>\\n<li>Tweak: Added Exit Animation for Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7063\\\">#7063<\\/a>)<\\/li>\\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5147\\\">#5147<\\/a>)<\\/li>\\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2180\\\">#2180<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7552\\\">#7552<\\/a>)<\\/li>\\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7928\\\">#7928<\\/a>)<\\/li>\\n<li>Tweak: Added <code>none<\\/code> breakpoint option to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7916\\\">#7916<\\/a>)<\\/li>\\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8366\\\">#8366<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor\\/query\\/query_results<\\/code> hook to Query Control to allow full control over results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7912\\\">#7912<\\/a>)<\\/li>\\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8090\\\">#8090<\\/a>)<\\/li>\\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups<\\/code> option is selected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8189\\\">#8189<\\/a>)<\\/li>\\n<li>Tweak: Added condition option to all of archive child pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8256\\\">#8256<\\/a>)<\\/li>\\n<li>Tweak: Added <code>Effects Relative To<\\/code> control to Scrolling Effects<\\/li>\\n<li>Tweak: Allow shortcodes in HTML Form field<\\/li>\\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability<\\/li>\\n<li>Tweak: Changed MailChimp <code>List<\\/code> label to <code>Audience<\\/code><\\/li>\\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup<\\/li>\\n<li>Tweak: Added <code>Deprecated Notice<\\/code> control to <code>Archive Products<\\/code> and <code>Woo Products<\\/code> widgets<\\/li>\\n<li>Tweak: Added default dynamic title for archives in Theme Builder<\\/li>\\n<li>Tweak: Added condition to show <code>Centered Slides<\\/code> control in Media Carousel widget<\\/li>\\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated<\\/li>\\n<li>Tweak: Replaced <code>select<\\/code> control with <code>choose<\\/code> control in Price List widget<\\/li>\\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor<\\/li>\\n<li>Tweak: Minor styling tweaks in the Popup publish modal<\\/li>\\n<li>Tweak: Hide ordering form in Products widget on front page<\\/li>\\n<li>Tweak: Removed page title markup when \'Hide Title\' is active<\\/li>\\n<li>Tweak: Added style controls for HTML field in Form widget<\\/li>\\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7240\\\">#7240<\\/a>)<\\/li>\\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7884\\\">#7884<\\/a>)<\\/li>\\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8497\\\">#8497<\\/a>)<\\/li>\\n<li>Fix: Missing Print icon in Share Buttons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8506\\\">#8506<\\/a>)<\\/li>\\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad<\\/li>\\n<li>Deprecated: <code>DB::save_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<li>Deprecated: <code>DB::get_plain_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.14 - 2019-07-14<\\/h4>\\n<ul>\\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8555\\\">#8555<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.13 - 2019-07-11<\\/h4>\\n<ul>\\n<li>Fix: Better WC grid support to various themes<\\/li>\\n<\\/ul>\\n<h4>2.5.12 - 2019-07-10<\\/h4>\\n<ul>\\n<li>Fix: Grid for WooCommerce Archive Product widget<\\/li>\\n<li>Fix: Remove redundant <code>whitespace<\\/code> CSS property causes style glitch in iPad<\\/li>\\n<li>Tweak: Added more compatibility for Elementor v2.6<\\/li>\\n<\\/ul>\\n<h4>2.5.11 - 2019-07-02<\\/h4>\\n<ul>\\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8460\\\">#8460<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8461\\\">#8461<\\/a>)<\\/li>\\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8396\\\">#8396<\\/a>)<\\/li>\\n<li>Fix: Missing dropdown icon in conditions screen<\\/li>\\n<\\/ul>\\n<h4>2.5.10 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6<\\/li>\\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8261\\\">#8261<\\/a>)<\\/li>\\n<li>Fix: Do not unset <code>product<\\/code> CPT if it\'s not from WooCommerce (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8160\\\">#8160<\\/a>)<\\/li>\\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8285\\\">#8285<\\/a>)<\\/li>\\n<li>Fix: Title styling not working in Products Categories widget<\\/li>\\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser<\\/li>\\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition<\\/li>\\n<\\/ul>\\n<h4>2.5.9 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>auto-confirm<\\/code> control from MailPoet to support new version of MailPoet<\\/li>\\n<li>Fix: Multiple Custom Fonts not rendered in the editor<\\/li>\\n<li>Fix: Products <code>sale<\\/code> query - handle exclude by manual selection.<\\/li>\\n<li>Fix: Product Categories grid row &amp; column style<\\/li>\\n<li>Fix: Form integration AJAX cache override<\\/li>\\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates<\\/li>\\n<\\/ul>\\n<h4>2.5.8 - 2019-05-06<\\/h4>\\n<ul>\\n<li>Fix: Popup entrance animation not working in frontend<\\/li>\\n<li>Fix: Popup Exit Intent trigger activated multiple times<\\/li>\\n<\\/ul>\\n<h4>2.5.7 - 2019-05-05<\\/h4>\\n<ul>\\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7875\\\">#7875<\\/a>)<\\/li>\\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7824\\\">#7824<\\/a>)<\\/li>\\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7395\\\">#7395<\\/a>)<\\/li>\\n<li>Fix: WC variations select style glitch in several themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8008\\\">#8008<\\/a>)<\\/li>\\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.5.6 - 2019-04-29<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>Shortcode<\\/code> dynamic from Image, Gallery and Media control<\\/li>\\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7809\\\">#7809<\\/a>)<\\/li>\\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control<\\/li>\\n<li>Fix: Query Control Related by author glitches in edge cases<\\/li>\\n<li>Fix: Query Control using terms for Products widget<\\/li>\\n<li>Fix: Posts cards style glitch in small screens<\\/li>\\n<li>Fix: Display conditions delete icon missing in small screens<\\/li>\\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor<\\/li>\\n<\\/ul>\\n<h4>2.5.5 - 2019-04-08<\\/h4>\\n<ul>\\n<li>Tweak: Allow text selection inside a Popup<\\/li>\\n<li>Fix: Added backwards compatibility for <code>tax_query<\\/code> in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7751\\\">#7751<\\/a>)<\\/li>\\n<li>Fix: Missing arguments for <code>widget_title<\\/code> filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7745\\\">#7745<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.4 - 2019-04-03<\\/h4>\\n<ul>\\n<li>Fix: Move Query from using <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<li>Fix: Offset manipulation hook removal in Query control<\\/li>\\n<li>Fix: Missing form field <code>ID<\\/code> in some edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7711\\\">#7711<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7660\\\">#7660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.3 - 2019-03-31<\\/h4>\\n<ul>\\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7673\\\">#7673<\\/a>)<\\/li>\\n<li>Fix: Missing form field names (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7651\\\">#7651<\\/a>)<\\/li>\\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7633\\\">#7633<\\/a>)<\\/li>\\n<li>Fix: <code>products_deprecated<\\/code> Query Control module compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7654\\\">#7654<\\/a>)<\\/li>\\n<li>Fix: Changed query method from <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.2 - 2019-03-27<\\/h4>\\n<ul>\\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7632\\\">#7632<\\/a>)<\\/li>\\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7635\\\">#7635<\\/a>)<\\/li>\\n<li>Fix: Manual Selection option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7634\\\">#7634<\\/a>)<\\/li>\\n<li>Fix: Incorrect condition caused handlers issues inside popup<\\/li>\\n<\\/ul>\\n<h4>2.5.1 - 2019-03-26<\\/h4>\\n<ul>\\n<li>Fix: Query Control invalid call to deprecated action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7619\\\">#7619<\\/a>)<\\/li>\\n<li>Tweak: Renamed action hook from <code>elementor_pro\\/{$widget_name}\\/query\\/{$query_id}<\\/code> to <code>elementor\\/query\\/{$query_id}<\\/code><\\/li>\\n<li>Tweak: Renamed filter hook from <code>elementor_pro\\/query_control\\/get_query_args\\/current_query<\\/code> to <code>elementor\\/query\\/get_query_args\\/current_query<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.5.0 - 2019-03-26<\\/h4>\\n<ul>\\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/72\\\">#72<\\/a>)<\\/li>\\n<li>New: Introducing Related Posts for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7306\\\">#7306<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7490\\\">#7490<\\/a>)<\\/li>\\n<li>New: Introducing Date query for Query Control<\\/li>\\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2501\\\">#2501<\\/a>)<\\/li>\\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6871\\\">#6871<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6876\\\">#6876<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule<\\/li>\\n<li>Tweak: Added full border radius control options inside Popup<\\/li>\\n<li>Tweak: Changed exit intent icon in Popups<\\/li>\\n<li>Tweak: Show only one popup in its own preview<\\/li>\\n<li>Tweak: Added responsive support to Popup entrance animation control<\\/li>\\n<li>Tweak: Conditions - Singular <code>All Pages<\\/code> string changed to <code>Pages<\\/code><\\/li>\\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7000\\\">#7000<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6779\\\">#6779<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6986\\\">#6986<\\/a>)<\\/li>\\n<li>Tweak: Decrease <code>z-index<\\/code> for Nav Menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6869\\\">#6869<\\/a>)<\\/li>\\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;<\\/li>\\n<li>Tweak: Use filter <code>get_meta_viewport<\\/code> for header templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7043\\\">#7043<\\/a>)<\\/li>\\n<li>Tweak: use filterable <code>Util::get_public_post_types()<\\/code> in Theme Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7172\\\">#7172<\\/a>)<\\/li>\\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7443\\\">#7443<\\/a>)<\\/li>\\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6913\\\">#6913<\\/a>)<\\/li>\\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling<\\/li>\\n<li>Fix: Custom ID reset to default when dragging repeater<\\/li>\\n<li>Fix: Conflict between archive-products widget and WC customizer<\\/li>\\n<li>Fix: Add to Cart widget <code>spacing<\\/code> and <code>space-between<\\/code><\\/li>\\n<li>Fix: Library view when creating a new Header or Footer<\\/li>\\n<li>Fix: Post types labels missing on Add New Template modal<\\/li>\\n<\\/ul>\\n<h4>2.4.8 - 2019-03-11<\\/h4>\\n<ul>\\n<li>Fix: Missing query section in Products widget<\\/li>\\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.7 - 2019-03-06<\\/h4>\\n<ul>\\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+<\\/li>\\n<\\/ul>\\n<h4>2.4.6 - 2019-03-04<\\/h4>\\n<ul>\\n<li>Fix: Pods gallery dynamic when empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7127\\\">#7127<\\/a>)<\\/li>\\n<li>Fix: Duplicate call for conditions screen issue<\\/li>\\n<li>Fix: Compatibility with Elementor v2.5.0<\\/li>\\n<\\/ul>\\n<h4>2.4.5 - 2019-02-18<\\/h4>\\n<ul>\\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7058\\\">#7058<\\/a>)<\\/li>\\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7083\\\">#7083<\\/a>)<\\/li>\\n<li>Fix: Show popup preview only on it\'s own preview<\\/li>\\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.4 - 2019-02-11<\\/h4>\\n<ul>\\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6690\\\">#6690<\\/a>)<\\/li>\\n<li>Tweak: Changed the term of <code>All Posts<\\/code> condition to <code>Posts<\\/code><\\/li>\\n<li>Fix: Added <code>&lt;IfModule&gt;<\\/code> to avoid 500 error when <code>mod-headers<\\/code> is missing (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7034\\\">#7034<\\/a>)<\\/li>\\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6856\\\">#6856<\\/a>)<\\/li>\\n<li>Fix: <code>Textarea<\\/code> default value in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6934\\\">#6934<\\/a>)<\\/li>\\n<li>Fix: MailPoet latest version caused fatal error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6996\\\">#6996<\\/a>)<\\/li>\\n<li>Fix: Fatal Error caused by calling MailPoet deleted method<\\/li>\\n<li>Notice: MailPoet <code>Auto Confirm<\\/code> option will now default to &quot;On&quot;<\\/li>\\n<\\/ul>\\n<h4>2.4.3 - 2019-01-30<\\/h4>\\n<ul>\\n<li>Fix: Custom Add to Cart widget responsive alignment settings<\\/li>\\n<li>Fix: Links in Post Info widget<\\/li>\\n<li>Fix: WooCommerce <code>View Cart<\\/code> string translate<\\/li>\\n<li>Fix: Wrapper classes for header\\/footer templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6884\\\">#6884<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.4.2 - 2019-01-25<\\/h4>\\n<ul>\\n<li>Tweak: Added pixel units to Close Button position control in Popups<\\/li>\\n<li>Fix: Exclude error in WC Products widget<\\/li>\\n<\\/ul>\\n<h4>2.4.1 - 2019-01-24<\\/h4>\\n<ul>\\n<li>Tweak: Added CSS classes control to Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6826\\\">#6826<\\/a>)<\\/li>\\n<li>Tweak: Added responsive image size to Testimonial Carousel widget<\\/li>\\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6842\\\">#6842<\\/a>)<\\/li>\\n<li>Fix: Support of exclude-ids in WC Products widget<\\/li>\\n<li>Fix: Popup close button not clickable<\\/li>\\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6749\\\">#6749<\\/a>)<\\/li>\\n<li>Fix: Bad anchors breaks the page JS<\\/li>\\n<li>Fix: Popup overlay shown when turned off<\\/li>\\n<\\/ul>\\n<h4>2.4.0 - 2019-01-21<\\/h4>\\n<ul>\\n<li>New: Introducing Popup Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/628\\\">#628<\\/a>)<\\/li>\\n<li>New: Added <code>Popup<\\/code> Dynamic Tag<\\/li>\\n<li>New: Added <code>Popup<\\/code> forms action after submit<\\/li>\\n<li>New: Added User Info dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6322\\\">#6322<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/theme_builder\\/archive\\/escape_nothing_found_message<\\/code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6053\\\">#6053<\\/a>)<\\/li>\\n<li>Tweak: Added <code>add_doc_to_location<\\/code> method to Allow insertion of a document to a location<\\/li>\\n<li>Fix: <code>z-index<\\/code> issue with CTA widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6486\\\">#6486<\\/a>)<\\/li>\\n<li>Fix: Hide the Post Content widget and show it only in a Single document<\\/li>\\n<li>Fix: <code>selector<\\/code> replacement in Custom CSS<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> on the real content only<\\/li>\\n<li>Fix: CSS for WC products selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6559\\\">#6559<\\/a>)<\\/li>\\n<li>Fix: Odnoklassniki share URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6638\\\">#6638<\\/a>)<\\/li>\\n<li>Fix: Custom link new tab in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5766\\\">#5766<\\/a>)<\\/li>\\n<li>Fix: <code>nofollow<\\/code> link in Flip Box &amp; CTA widgets<\\/li>\\n<li>Fix: Post Terms in Post Info widget<\\/li>\\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5386\\\">#5386<\\/a>)<\\/li>\\n<li>Fix: Accessibility labels in Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6630\\\">#6630<\\/a>)<\\/li>\\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active<\\/li>\\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget<\\/li>\\n<li>Fix: Sub-menu arrow position in Nav Menu widget<\\/li>\\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6648\\\">#6648<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.3.1 - 2018-12-19<\\/h4>\\n<ul>\\n<li>Fix: Template widget search functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6473\\\">#6473<\\/a>)<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> filter to post content in theme builder<\\/li>\\n<\\/ul>\\n<h4>2.3.0 - 2018-12-17<\\/h4>\\n<ul>\\n<li>New: Introducing Discord Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4218\\\">#4218<\\/a>)<\\/li>\\n<li>New: Introducing Slack Integration for Forms<\\/li>\\n<li>New: Introducing MailerLite Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4462\\\">#4462<\\/a>)<\\/li>\\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/utils\\/get_public_post_types<\\/code> filter hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5900\\\">#5900<\\/a>)<\\/li>\\n<li>Tweak: Added <code>loop_start<\\/code> &amp; <code>the_content<\\/code> hooks for Post Content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6173\\\">#6173<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from Page Settings<\\/li>\\n<li>Tweak: Always add the Custom CSS control to the Advanced tab<\\/li>\\n<li>Fix: In sub Term condition false positive in edge cases<\\/li>\\n<li>Fix: ToolSet Dynamic Image fallback<\\/li>\\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget<\\/li>\\n<li>Fix: Style glitch in the Conditions screen in Safari browser<\\/li>\\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6080\\\">#6080<\\/a>)<\\/li>\\n<li>Fix: The color of label won\'t change color in Widget login<\\/li>\\n<\\/ul>\\n<h4>2.2.5 - 2018-12-11<\\/h4>\\n<ul>\\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.<\\/li>\\n<li>Tweak: Added a better identifier for subpages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6362\\\">#6362<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from page settings<\\/li>\\n<li>Fix: Yahoo event URL date issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Allow timezone settings in Google event URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Avoid <code>z-index<\\/code> changes by <code>nanocss<\\/code> in build process<\\/li>\\n<li>Fix: Added missing WC upsells products CSS<\\/li>\\n<li>Fix: Nav Menu dropdown losing color on hover<\\/li>\\n<li>Fix: WC Product Add-ons CSS compatibility<\\/li>\\n<\\/ul>\\n<h4>2.2.4 - 2018-12-04<\\/h4>\\n<ul>\\n<li>Fix: Global widget not saving changes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6340\\\">#6340<\\/a>)<\\/li>\\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6334\\\">#6334<\\/a>)<\\/li>\\n<li>Fix: Forms Redirect URL action when using form field values with spaces<\\/li>\\n<\\/ul>\\n<h4>2.2.3 - 2018-11-29<\\/h4>\\n<ul>\\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu<\\/li>\\n<li>Fix: Show only supported templates in Template widget<\\/li>\\n<li>Fix: Revert conflicting fix for a default order for WC archive<\\/li>\\n<\\/ul>\\n<h4>2.2.2 - 2018-11-28<\\/h4>\\n<ul>\\n<li>Fix: Lightbox dynamic tag crashes the editor<\\/li>\\n<\\/ul>\\n<h4>2.2.1 - 2018-11-28<\\/h4>\\n<ul>\\n<li>New: Added <code>ACF File<\\/code> Dynamic tag to support text controls.<\\/li>\\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6223\\\">#6223<\\/a>)<\\/li>\\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags<\\/li>\\n<li>Tweak: Added filter <code>elementor_pro\\/dynamic_tags\\/shortcode\\/should_escape<\\/code> to avoid escaping in Shortcode dynamic tag<\\/li>\\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists<\\/li>\\n<li>Tweak: Added front-end max file size validation for upload fields<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> per Post-Type condition for theme builder<\\/li>\\n<li>Fix: Template widget panel not showing the selected template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag<\\/li>\\n<li>Fix: Add post classes only for the Single template<\\/li>\\n<li>Fix: Set document type as not editable for unsupported document like Global widget<\\/li>\\n<li>Fix: Avoid duplicate query for current WC product query<\\/li>\\n<li>Fix: Product Archive showing oldest products instead of latest<\\/li>\\n<li>Fix: CSS reset in Posts widget using cards skin<\\/li>\\n<\\/ul>\\n<h4>2.2.0 - 2018-11-19<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/290\\\">#290<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3990\\\">#3990<\\/a>)<\\/li>\\n<li>New: Added evergreen option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4459\\\">#4459<\\/a>)<\\/li>\\n<li>New: Added expire actions option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5242\\\">#5242<\\/a>)<\\/li>\\n<li>New: Introducing Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3854\\\">#3854<\\/a>)<\\/li>\\n<li>New: Introducing Sitemap widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5594\\\">#5594<\\/a>)<\\/li>\\n<li>New: Added Request Parameter dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4934\\\">#4934<\\/a>)<\\/li>\\n<li>New: Added Shortcode dynamic tag<\\/li>\\n<li>New: Added Image and Video Lightbox dynamic tag<\\/li>\\n<li>New: Added Contact URL dynamic tag<\\/li>\\n<li>New: Added Featured Image Data dynamic tag<\\/li>\\n<li>New: Added default value to each field in the Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4268\\\">#4268<\\/a>)<\\/li>\\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5321\\\">#5321<\\/a>)<\\/li>\\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5587\\\">#5587<\\/a>)<\\/li>\\n<li>Tweak: Added Form Redirect URL with form values (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2564\\\">#2564<\\/a>)<\\/li>\\n<li>Tweak: Added default post classes to template wrapper (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5959\\\">#5959<\\/a>)<\\/li>\\n<li>Tweak: Better labels for terms in Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6092\\\">#6092<\\/a>)<\\/li>\\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;<\\/li>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/condition_sub_id<\\/code> filter hook to allow template condition translations<\\/li>\\n<li>Tweak: Load the Template Library widget via Ajax for better performance<\\/li>\\n<li>Tweak: Added 404 page title for Page Title dynamic tag<\\/li>\\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6141\\\">#6141<\\/a>)<\\/li>\\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5790\\\">#5790<\\/a>)<\\/li>\\n<li>Fix: Avoid potential security risk in forms<\\/li>\\n<li>Fix: Template By Author condition conflicts with 404 page<\\/li>\\n<li>Fix: Restored WC Product Content widget in Single Product template<\\/li>\\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages<\\/li>\\n<li>Fix: Highlight active menu anchor items only when scrolled into view<\\/li>\\n<li>Fix: Carousel Pagination Progress style to support new Swiper version<\\/li>\\n<\\/ul>\\n<h4>2.1.13 - 2018-11-12<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0<\\/li>\\n<li>Fix: Settings conflict when there are multiple carousels in the page<\\/li>\\n<\\/ul>\\n<h4>2.1.12 - 2018-11-05<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3<\\/li>\\n<li>Tweak: Better performance for Template Library widget<\\/li>\\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6029\\\">#6029<\\/a>)<\\/li>\\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6001\\\">#6001<\\/a>)<\\/li>\\n<li>Fix: Custom CSS printed twice in the front-end<\\/li>\\n<li>Fix: ACF Image field PHP warning (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6051\\\">#6051<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.1.11 - 2018-10-22<\\/h4>\\n<ul>\\n<li>New: Added ACF local fields compatibility<\\/li>\\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration<\\/li>\\n<li>Fix: Exclude <code>is_embed<\\/code> from Singular condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5915\\\">#5915<\\/a>)<\\/li>\\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons<\\/li>\\n<li>Fix: Current date time dynamic tag now shows local time<\\/li>\\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink<\\/li>\\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration<\\/li>\\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF<\\/li>\\n<li>Fix: Respect password protected for a WC single product template<\\/li>\\n<li>Fix: Respect <code>order<\\/code> settings for WC archive also without pagination<\\/li>\\n<\\/ul>\\n<h4>2.1.10 - 2018-10-09<\\/h4>\\n<ul>\\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5821\\\">#5821<\\/a>)<\\/li>\\n<li>Tweak: Added link control to Animated Headline widget<\\/li>\\n<li>Fix: Mobile nav menu jump on RTL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5711\\\">#5711<\\/a>)<\\/li>\\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5830\\\">#5830<\\/a>)<\\/li>\\n<li>Fix: Added IE compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Post Content widget is now shown only on <code>Single<\\/code> templates<\\/li>\\n<li>Fix: Query Control Pagination with offset<\\/li>\\n<\\/ul>\\n<h4>2.1.9 - 2018-09-17<\\/h4>\\n<ul>\\n<li>Tweak: Added Centered Slides option for Slideshow carousel<\\/li>\\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5091\\\">#5091<\\/a>)<\\/li>\\n<li>Fix: ACF Gallery option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5740\\\">#5740<\\/a>)<\\/li>\\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5689\\\">#5689<\\/a>)<\\/li>\\n<li>Fix: Coverflow transition effect in Carousel<\\/li>\\n<li>Fix: Weird mobile behavior with Cube effect in Carousel<\\/li>\\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly<\\/li>\\n<\\/ul>\\n<h4>2.1.8 - 2018-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Added styling options for WC Additional Information widget<\\/li>\\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget<\\/li>\\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5338\\\">#5338<\\/a>)<\\/li>\\n<li>Fix: Layout of Related Product widget with WC native style<\\/li>\\n<\\/ul>\\n<h4>2.1.7 - 2018-09-03<\\/h4>\\n<ul>\\n<li>New: WC Archive Description widget<\\/li>\\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5555\\\">#5555<\\/a>)<\\/li>\\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget<\\/li>\\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5589\\\">#5589<\\/a>)<\\/li>\\n<li>Tweak: Added more blend mode options for CTA widget<\\/li>\\n<li>Tweak: Improved plugin updater method based on WordPress version<\\/li>\\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets<\\/li>\\n<li>Fix: Added default gap for products pagination<\\/li>\\n<li>Fix: Post thumbnail flickering in Safari browser<\\/li>\\n<li>Fix: Close mobile nav menu on click only in full-width mode<\\/li>\\n<li>Fix: Added trailing slash to pagination links in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.1.6 - 2018-08-28<\\/h4>\\n<ul>\\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5117\\\">#5117<\\/a>)<\\/li>\\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5491\\\">#5491<\\/a>)<\\/li>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Tweak: Deprecated Follow option in the Facebook Button widget<\\/li>\\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)<\\/li>\\n<li>Fix: Posts widget CSS when using cards skin in masonry mode<\\/li>\\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: WC product gallery links in RTL<\\/li>\\n<li>Fix: Dynamic tags in Call To Action widget<\\/li>\\n<\\/ul>\\n<h4>2.1.5 - 2018-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Fix: Posts Widget layout theme compatibility<\\/li>\\n<li>Fix: Added compatibility for WooCommerce native style<\\/li>\\n<\\/ul>\\n<h4>2.1.4 - 2018-08-19<\\/h4>\\n<ul>\\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5442\\\">#5442<\\/a>)<\\/li>\\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5460\\\">#5460<\\/a>)<\\/li>\\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget<\\/li>\\n<li>Fix: Selector specificity for WooCommerce Products widget<\\/li>\\n<li>Fix: WooCommerce conflicts in the editor in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.3 - 2018-08-15<\\/h4>\\n<ul>\\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5350\\\">#5350<\\/a>)<\\/li>\\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5375\\\">#5375<\\/a>)<\\/li>\\n<li>Fix: Added missing <code>setup_postdata<\\/code> for Product Data Tabs widget<\\/li>\\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5399\\\">#5399<\\/a>)<\\/li>\\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5254\\\">#5254<\\/a>)<\\/li>\\n<li>Fix: Carousel behavior when using a single slide<\\/li>\\n<\\/ul>\\n<h4>2.1.2 - 2018-08-12<\\/h4>\\n<ul>\\n<li>Fix: Error when ACF Pro is not installed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5367\\\">#5367<\\/a>)<\\/li>\\n<li>Fix: Edge cases in Inspector where document is a boolean<\\/li>\\n<li>Fix: Edge cases for incorrect file fields in PODS<\\/li>\\n<\\/ul>\\n<h4>2.1.1 - 2018-08-09<\\/h4>\\n<ul>\\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5345\\\">#5345<\\/a>)<\\/li>\\n<li>Fix: Flip Box effect issues<\\/li>\\n<li>Fix: ACF Options page fields support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5329\\\">#5329<\\/a>)<\\/li>\\n<li>Fix: Import Pro templates in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.0 - 2018-08-07<\\/h4>\\n<ul>\\n<li>New: Introducing WooCommerce Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1690\\\">#1690<\\/a>)<\\/li>\\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive<\\/li>\\n<li>New: Introducing Cart Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4220\\\">#4220<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4600\\\">#4600<\\/a>)<\\/li>\\n<li>New: Added integration with Toolset (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Added integration with Pods (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4129\\\">#4129<\\/a>)<\\/li>\\n<li>New: Added stick to bottom in scrolling effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4799\\\">#4799<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect to Widgets under advanced tab<\\/li>\\n<li>New: Introducing Internal URL Dynamic Tag<\\/li>\\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4597\\\">#4597<\\/a>)<\\/li>\\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4447\\\">#4447<\\/a>)<\\/li>\\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1878\\\">#1878<\\/a>)<\\/li>\\n<li>Tweak: Add Custom Query hook for Query control (<a href=\\\"https:\\/\\/developers.elementor.com\\/custom-query-filter\\/\\\">More Info<\\/a>) (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1748\\\">#1748<\\/a>)<\\/li>\\n<li>Tweak: Added form-message style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4767\\\">#4767<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4602\\\">#4602<\\/a>)<\\/li>\\n<li>Tweak: Added an support for <code>label|value<\\/code> in options field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4594\\\">#4594<\\/a>)<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> condition for theme builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4681\\\">#4681<\\/a>)<\\/li>\\n<li>Tweak: Added Activate\\/Deactivate license key via WP-CLI command (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4149\\\">#4149<\\/a>)<\\/li>\\n<li>Tweak: Added <code>is_scroll<\\/code> trigger to scrolling effect (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4340\\\">#4340<\\/a>)<\\/li>\\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4177\\\">#4177<\\/a>)<\\/li>\\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3697\\\">#3697<\\/a>)<\\/li>\\n<li>Tweak: Added style options for Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1335\\\">#1335<\\/a>)<\\/li>\\n<li>Tweak: Added button CSS ID for Forms widget<\\/li>\\n<li>Tweak: Added pixel units to Post-Info divider height control<\\/li>\\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs<\\/li>\\n<li>Tweak: Re-organize the panel categories per document type<\\/li>\\n<li>Tweak: Added ACF support for <code>options-page<\\/code> fields<\\/li>\\n<li>Tweak: Added dynamic tag for Animated headlines<\\/li>\\n<li>Tweak: Added dynamic tag for BlockQuote widget<\\/li>\\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4817\\\">#4817<\\/a>)<\\/li>\\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4324\\\">#4324<\\/a>)<\\/li>\\n<li>Fix: Initial slide in Carousel widget<\\/li>\\n<li>Fix: Stay on current slide while editing in Carousel widget<\\/li>\\n<li>Fix: Default slides per device in Carousel widget<\\/li>\\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.18 - 2018-07-27<\\/h4>\\n<ul>\\n<li>Fix: Global widget error on saving page<\\/li>\\n<\\/ul>\\n<h4>2.0.17 - 2018-07-26<\\/h4>\\n<ul>\\n<li>Fix: Sub menu indicator direction in Nav Menu widget<\\/li>\\n<li>Fix: Change the title and icon for Global Widget when is moving<\\/li>\\n<li>Fix: CSS wrapper selector for Page Document<\\/li>\\n<\\/ul>\\n<h4>2.0.16 - 2018-07-16<\\/h4>\\n<ul>\\n<li>Tweak: CSS Filter Control module is now included in Elementor<\\/li>\\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5077\\\">#5077<\\/a>)<\\/li>\\n<li>Fix: Restore current query after get Global Widget data<\\/li>\\n<li>Fix: Add action item in History on unlink Global widget<\\/li>\\n<\\/ul>\\n<h4>2.0.15 - 2018-07-10<\\/h4>\\n<ul>\\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4996\\\">#4996<\\/a>)<\\/li>\\n<li>Fix: GMT offset in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4997\\\">#4997<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.0.14 - 2018-07-08<\\/h4>\\n<ul>\\n<li>Tweak: Added set method to form record for developers (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4983\\\">#4983<\\/a>)<\\/li>\\n<li>Fix: Autoplay option for Carousels<\\/li>\\n<li>Fix: Close mobile menu on item click in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.13 - 2018-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for Elementor v2.1<\\/li>\\n<\\/ul>\\n<h4>2.0.12 - 2018-07-02<\\/h4>\\n<ul>\\n<li>Fix: Global widget PHP notices<\\/li>\\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs<\\/li>\\n<li>Fix: Form select field send all selected values on multiple selection<\\/li>\\n<li>Fix: Validate time field only if it\'s not empty<\\/li>\\n<li>Fix: ConvertKit API not saving name field<\\/li>\\n<\\/ul>\\n<h4>2.0.11 - 2018-06-12<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder <code>author<\\/code> archive condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4593\\\">#4593<\\/a>)<\\/li>\\n<li>Fix: Respect password protected posts in Post Content widget<\\/li>\\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.<\\/li>\\n<\\/ul>\\n<h4>2.0.10 - 2018-06-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> filter hook for multi-language plugins<\\/li>\\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)<\\/li>\\n<li>Fix: Fields shortcode missing after removing a field in Form widget<\\/li>\\n<li>Deprecated: <code>get_theme_templates_by_location<\\/code> is replaced by <code>get_location_templates<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.0.9 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Fix: Compatibility for PHP version 5.4<\\/li>\\n<\\/ul>\\n<h4>2.0.8 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added Active state for Nav Menu dropdown<\\/li>\\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget<\\/li>\\n<li>Tweak: Removed caption control in Site Logo widget<\\/li>\\n<li>Tweak: Added option to position currency symbol before\\/after In Price Table widget<\\/li>\\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4479\\\">#4479<\\/a>)<\\/li>\\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4342\\\">#4342<\\/a>)<\\/li>\\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4527\\\">#4527<\\/a>)<\\/li>\\n<li>Fix: Avoid rendering a template if it\'s not published<\\/li>\\n<li>Fix: 404 Page style not working<\\/li>\\n<li>Fix: Price Table button with hover animation not working in editor<\\/li>\\n<li>Fix: Styling conflict in Call to Action widget<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Adding parent wrapper class to Site Title widget<\\/li>\\n<\\/ul>\\n<h4>2.0.7 - 2018-05-16<\\/h4>\\n<ul>\\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;<\\/li>\\n<li>Fix: Open 404 template library for 404 page<\\/li>\\n<li>Tweak: Added CSS prefix for dev files<\\/li>\\n<li>Tweak: Removed product post type from display conditions<\\/li>\\n<\\/ul>\\n<h4>2.0.6 - 2018-05-15<\\/h4>\\n<ul>\\n<li>Tweak: Set type on create new single template<\\/li>\\n<li>Tweak: Always show the conditions dialog in the Draft status<\\/li>\\n<li>Tweak: Added document type <code>widget<\\/code><\\/li>\\n<li>Tweak: Added Post Custom Field tag to URL category<\\/li>\\n<li>Fix: When ACF Field Groups are Empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4428\\\">#4428<\\/a>)<\\/li>\\n<li>Fix: Links inside carousel in edge cases<\\/li>\\n<li>Fix: Responsive issue in My Templates area<\\/li>\\n<li>Fix: Image alignment for post content with text alignment<\\/li>\\n<li>Fix: Post Content widget when preview post is missing<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Style settings for Post \\/ Archive Title widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.5 - 2018-05-08<\\/h4>\\n<ul>\\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4203\\\">#4203<\\/a>)<\\/li>\\n<li>Fix: Added support for new version of reCAPTCHA<\\/li>\\n<li>Fix: Added fallback for controls after <code>post_status<\\/code><\\/li>\\n<li>Fix: Required field in forms widget<\\/li>\\n<li>Fix: Media Carousel in the Coverflow skin<\\/li>\\n<li>Fix: 404 Page show wrong template in edge cases<\\/li>\\n<li>Fix: Save the default menu in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.4 - 2018-05-02<\\/h4>\\n<ul>\\n<li>Tweak: Added parent\'s class for extended widgets<\\/li>\\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions<\\/li>\\n<li>Tweak: Initialize global model when it\'s needed<\\/li>\\n<li>Tweak: Removed some duplicate strings<\\/li>\\n<li>Tweak: Query control now includes empty terms<\\/li>\\n<li>Tweak: Design polish for conditions dialog<\\/li>\\n<li>Tweak: Decreasing <code>minimumInputLength<\\/code> to 1 of select2<\\/li>\\n<li>Fix: Editor not loading for single templates in edge cases<\\/li>\\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4310\\\">#4310<\\/a>)<\\/li>\\n<li>Fix: Slides per view not working for some effects<\\/li>\\n<li>Fix: New slides not showing in the editor<\\/li>\\n<li>Fix: Editor for section without a defined location, defaults to content area<\\/li>\\n<\\/ul>\\n<h4>2.0.3 - 2018-04-24<\\/h4>\\n<ul>\\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4214\\\">#4214<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4216\\\">#4216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4225\\\">#4225<\\/a>)<\\/li>\\n<li>Fix: Double render on frontend view in core locations<\\/li>\\n<li>Fix: Masonry not working in edge cases<\\/li>\\n<li>Fix: Added default setting for Author Info tag<\\/li>\\n<\\/ul>\\n<h4>2.0.2 - 2018-04-18<\\/h4>\\n<ul>\\n<li>Fix: Regenerate conditions to include all templates<\\/li>\\n<\\/ul>\\n<h4>2.0.1 - 2018-04-17<\\/h4>\\n<ul>\\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4136\\\">#4136<\\/a>)<\\/li>\\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4127\\\">#4127<\\/a>)<\\/li>\\n<li>Tweak: Added Divider control for Post Info widget<\\/li>\\n<li>Fix: Update admin links in Yoast Breadcrumbs widget<\\/li>\\n<li>Fix: Sticky element conflict with clearfix CSS<\\/li>\\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below<\\/li>\\n<li>Fix: Avoid running <code>wp_head<\\/code> hooks twice<\\/li>\\n<\\/ul>\\n<h4>2.0.0 - 2018-04-16<\\/h4>\\n<ul>\\n<li>New: Introducing Theme Builder - <a href=\\\"https:\\/\\/elementor.com\\/introducing-theme-builder\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/417\\\">#417<\\/a>)<\\/li>\\n<li>New: Introducing Locations API to inject custom location templates<\\/li>\\n<li>New: Introducing Display Conditions for all dynamic templates<\\/li>\\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design<\\/li>\\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/483\\\">#483<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/653\\\">#653<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/885\\\">#885<\\/a>)<\\/li>\\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Introducing Developers area with guides and API documentation - <a href=\\\"https:\\/\\/elementor.com\\/introducing-elementor-developer-api\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/451\\\">#451<\\/a>)<\\/li>\\n<li>New: Introducing <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor-hello-theme\\\">Elementor Hello Theme<\\/a> - A demonstration theme for developers<\\/li>\\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2761\\\">#2761<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2623\\\">#2623<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2109\\\">#2109<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2061\\\">#2061<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2439\\\">#2439<\\/a>)<\\/li>\\n<li>New: Design 404 page with Single template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1558\\\">#1558<\\/a>)<\\/li>\\n<li>New: Design Search Results with Archive template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3196\\\">#3196<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2590\\\">#2590<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element<\\/em> per device (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2412\\\">#2412<\\/a>)<\\/li>\\n<li>New: Integration with Custom Fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2054\\\">#2054<\\/a>)<\\/li>\\n<li>New: Partial support for Toolset integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Partial support for Pods integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2169\\\">#2169<\\/a>)<\\/li>\\n<li>New: Partial support for ACF integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2041\\\">#2041<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2059\\\">#2059<\\/a>)<\\/li>\\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3531\\\">#3531<\\/a>)<\\/li>\\n<li>Tweak: Allow brackets in Forms Tel field<\\/li>\\n<li>Tweak: Added currency format control for Price Table widget<\\/li>\\n<li>Tweak: Reduced API request for some servers<\\/li>\\n<li>Fix: Dropdown <code>border-radius<\\/code> in Nav Menu widget<\\/li>\\n<li>Fix: Price List widget layout breaks in edge cases<\\/li>\\n<li>Note: This version requires Elementor v2.0.6<\\/li>\\n<\\/ul>\\n<h4>1.15.6 - 2018-03-28<\\/h4>\\n<ul>\\n<li>Fix: Removed duplicate Custom CSS section (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3938\\\">#3938<\\/a>)<\\/li>\\n<li>Fix: <code>box-shadow<\\/code> issue with cards skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3940\\\">#3940<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.5 - 2018-03-27<\\/h4>\\n<ul>\\n<li>Fix: Added global widget compatibility for Elementor v2.0<\\/li>\\n<li>Fix: Reduced API request for some servers<\\/li>\\n<\\/ul>\\n<h4>1.15.4 - 2018-03-26<\\/h4>\\n<ul>\\n<li>Tweak: Allow brackets in phone field<\\/li>\\n<li>Tweak: Added compatibility with Yoast 7.0.+<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Support for multiple carousel setting in editor<\\/li>\\n<li>Fix: <code>on_export<\\/code> issue in forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3890\\\">#3890<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.3 - 2018-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Added unique class to field group div (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3595\\\">#3595<\\/a>)<\\/li>\\n<li>Fix: Screen Options missing when Pro is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3622\\\">#3622<\\/a>)<\\/li>\\n<li>Fix: Allow label styling even when <code>show labels<\\/code> is set hide (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3544\\\">#3544<\\/a>)<\\/li>\\n<li>Fix: Typography control not working in edge cases<\\/li>\\n<li>Fix: Safari compatibility for Search widget<\\/li>\\n<\\/ul>\\n<h4>1.15.2 - 2018-02-27<\\/h4>\\n<ul>\\n<li>Fix: Only add support mine-type if needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3543\\\">#3543<\\/a>)<\\/li>\\n<li>Fix: Better support for Old Typekit kits<\\/li>\\n<\\/ul>\\n<h4>1.15.1 - 2018-02-21<\\/h4>\\n<ul>\\n<li>Tweak: Custom font title placeholder is not <code>enter font family<\\/code><\\/li>\\n<li>Tweak: Custom font title set as required<\\/li>\\n<li>Fix: Custom font, <code>font-face<\\/code> enqueued only once if used in global (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3513\\\">#3513<\\/a>)<\\/li>\\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.<\\/li>\\n<\\/ul>\\n<h4>1.15.0 - 2018-02-19<\\/h4>\\n<ul>\\n<li>New: Added custom fonts manager for self hosted fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/852\\\">#852<\\/a>)<\\/li>\\n<li>New: Integration with Adobe TypeKit fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/631\\\">#631<\\/a>)<\\/li>\\n<li>Tweak: Clear menu from Nav Menu widget on template export<\\/li>\\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle<\\/code><\\/li>\\n<\\/ul>\\n<h4>1.14.2 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Fix: Global widget content that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.14.1 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>none<\\/code> option to content animation in CTA widget<\\/li>\\n<li>Tweak: Added <code>form_id<\\/code> to ActiveCampaign integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3422\\\">#3422<\\/a>)<\\/li>\\n<li>Fix: Page crashed when Global widget not found.<\\/li>\\n<\\/ul>\\n<h4>1.14.0 - 2018-02-12<\\/h4>\\n<ul>\\n<li>New: Added Call to Action widget<\\/li>\\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Allow zero (0) to be accepted as a field value<\\/li>\\n<li>Fix: Login form when custom login URL is set<\\/li>\\n<li>Fix: Added Day of cycle control to GetResponse integration<\\/li>\\n<\\/ul>\\n<h4>1.13.2 - 2018-01-23<\\/h4>\\n<ul>\\n<li>Tweak: Added placeholder to Password field<\\/li>\\n<li>Tweak: Removed <code>subscriber_already_exists_message<\\/code> control to prevent potential data leakage<\\/li>\\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet<\\/li>\\n<li>Fix: Changed <code>imagesLoaded()<\\/code> to Vanilla JS to avoid compatibility issues with some themes<\\/li>\\n<li>Fix: Only validate Tel field if not empty<\\/li>\\n<li>Fix: Stop slider while editing<\\/li>\\n<\\/ul>\\n<h4>1.13.1 - 2018-01-16<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with old PHP versions<\\/li>\\n<\\/ul>\\n<h4>1.13.0 - 2018-01-16<\\/h4>\\n<ul>\\n<li>New: Added File Upload field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1482\\\">#1482<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Acceptance field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1693\\\">#1693<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Date field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1868\\\">#1868<\\/a>)<\\/li>\\n<li>New: Added Time field for Forms widget<\\/li>\\n<li>New: Added Password field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2164\\\">#2164<\\/a>)<\\/li>\\n<li>New: Added HTML field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1500\\\">#1500<\\/a>)<\\/li>\\n<li>Tweak: Added characters validation for Tel field<\\/li>\\n<li>Tweak: Added min &amp; max validation for Number field<\\/li>\\n<li>Tweak: Added multiple selection for Select field<\\/li>\\n<li>Tweak: Added donReach integration for Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.12.3 - 2018-01-09<\\/h4>\\n<ul>\\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget<\\/li>\\n<li>Fix: Apply <code>url-encoding<\\/code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text<\\/li>\\n<li>Fix: Removed My Account link from dashboard widget<\\/li>\\n<\\/ul>\\n<h4>1.12.2 - 2018-01-03<\\/h4>\\n<ul>\\n<li>Tweak: Added animation none for Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2964\\\">#2964<\\/a>)<\\/li>\\n<li>Fix: Active license button style<\\/li>\\n<\\/ul>\\n<h4>1.12.1 - 2018-01-02<\\/h4>\\n<ul>\\n<li>Tweak: Removed theme-element widgets from plain content<\\/li>\\n<li>Tweak: Set all theme-element widgets to extend same widget Base<\\/li>\\n<li>Tweak: Removed credit URL in forms meta data<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.9<\\/li>\\n<li>Fix: Validate Get response Error as real error<\\/li>\\n<li>Fix: Removed responsive height control from Facebook Page widget<\\/li>\\n<\\/ul>\\n<h4>1.12.0 - 2017-12-20<\\/h4>\\n<ul>\\n<li>New: Added Drip integration to Forms<\\/li>\\n<li>New: Added ActiveCampaign integration to Forms<\\/li>\\n<li>New: Added ConverKit integration to Forms<\\/li>\\n<li>New: Added GetResponse integration to Forms<\\/li>\\n<li>New: Added form <code>id<\\/code>, <code>name<\\/code> attributes to handle integration with auto collectors like HubSpot<\\/li>\\n<li>New: Added Global API key for MailChimp to improve the workflow<\\/li>\\n<li>Tweak: Better error handling and message display for Forms<\\/li>\\n<li>Fix: PHP notice Undefined variable <code>$cc_header<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2934\\\">#2934<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.11.0 - 2017-12-11<\\/h4>\\n<ul>\\n<li>New: Added a native Comments widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Added an Author Box widget<\\/li>\\n<li>New: Added a Post Navigation widget<\\/li>\\n<li>New: Added a Yoast Breadcrumbs widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2749\\\">#2749<\\/a>)<\\/li>\\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2762\\\">#2762<\\/a>)<\\/li>\\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric<\\/li>\\n<li>Fix: Edge cases when the nav menu is empty in a stretched section<\\/li>\\n<li>Fix: Added fallback when you remove the <code>space-between<\\/code> on Swiper carousel<\\/li>\\n<\\/ul>\\n<h4>1.10.2 - 2017-12-03<\\/h4>\\n<ul>\\n<li>Fix: Missing save widget icon (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2878\\\">#2878<\\/a>)<\\/li>\\n<li>Fix: Global widgets not saving edits (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2874\\\">#2874<\\/a>)<\\/li>\\n<li>Fix: Removed <code>white-space: nowrap;<\\/code> property from vertical menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2815\\\">#2815<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.10.1 - 2017-11-30<\\/h4>\\n<ul>\\n<li>Tweak: Added default value for search form<\\/li>\\n<li>Tweak: Order template list A-Z in the library widget<\\/li>\\n<li>Tweak: get_users\\/authors query is now done using AJAX only, for better performance in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2865\\\">#2865<\\/a>)<\\/li>\\n<li>Fix: When adding <code>.00<\\/code> it is not displayed on the front<\\/li>\\n<li>Fix: Make sure space between is numeric for carousel control<\\/li>\\n<li>Fix: Added space for radio &amp; checkbox fields in form widget<\\/li>\\n<\\/ul>\\n<h4>1.10.0 - 2017-11-15<\\/h4>\\n<ul>\\n<li>New: Added native Search form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2576\\\">#2576<\\/a>)<\\/li>\\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets<\\/li>\\n<li>Tweak: Added Inline editing to Blockquote widget<\\/li>\\n<li>Fix: Animated Headline color bug (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2516\\\">#2516<\\/a>)<\\/li>\\n<li>Fix: Animated Headline with Rotating skin<\\/li>\\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations<\\/li>\\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2662\\\">#2662<\\/a>)<\\/li>\\n<li>Fix: Custom CSS gone after reloading the editor<\\/li>\\n<\\/ul>\\n<h4>1.9.5 - 2017-10-27<\\/h4>\\n<ul>\\n<li>Fix: Broken Global widget with JS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2639\\\">#2639<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.9.4 - 2017-10-24<\\/h4>\\n<ul>\\n<li>Tweak: Improved UI for notices and license page<\\/li>\\n<li>Fix: Update system conflict with other EDD plugins<\\/li>\\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2577\\\">#2577<\\/a>)<\\/li>\\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2496\\\">#2496<\\/a>)<\\/li>\\n<li>Fix: Increased submenu max-width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2558\\\">#2558<\\/a>)<\\/li>\\n<li>Fix: Save global templates without their defaults<\\/li>\\n<li>Fix: Horizontal scrolling issue with posts grid<\\/li>\\n<\\/ul>\\n<h4>1.9.3 - 2017-10-03<\\/h4>\\n<ul>\\n<li>Fix: Condition slide style that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.9.2 - 2017-10-02<\\/h4>\\n<ul>\\n<li>New: Added integration with MailPoet 3 for Forms actions<\\/li>\\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode<\\/li>\\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel<\\/li>\\n<li>Fix: Added condition for slides style section in skin bubble mode<\\/li>\\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel<\\/li>\\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows<\\/li>\\n<\\/ul>\\n<h4>1.9.1 - 2017-09-28<\\/h4>\\n<ul>\\n<li>Fix: Slides per view for slideshow carousel<\\/li>\\n<li>Fix: Final polish for the new Testimonial Carousel widget<\\/li>\\n<li>Fix: Don\'t play video if slide type is not video<\\/li>\\n<li>Fix: Removed slides style section condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2497\\\">#2497<\\/a>)<\\/li>\\n<li>Fix: Set cursor as pointer for slideshow thumbnails<\\/li>\\n<\\/ul>\\n<h4>1.9.0 - 2017-09-26<\\/h4>\\n<ul>\\n<li>New: Added Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/216\\\">#216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/347\\\">#347<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2209\\\">#2209<\\/a>)<\\/li>\\n<li>New: Added Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/715\\\">#715<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.3 - 2017-09-24<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6<\\/li>\\n<li>Fix: Remove slashes from Form sent data<\\/li>\\n<\\/ul>\\n<h4>1.8.2 - 2017-09-19<\\/h4>\\n<ul>\\n<li>Tweak: Added target URL for the tweet message in Blockquote widget<\\/li>\\n<li>Tweak: Render the slide height before the slider is finished loading<\\/li>\\n<li>Fix: Space between words for Animated Headline widget<\\/li>\\n<li>Fix: RTL compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Italic font style for Animated Headline widget<\\/li>\\n<li>Fix: Excluded Menu widget from the WP Editor text rendering<\\/li>\\n<\\/ul>\\n<h4>1.8.1 - 2017-09-18<\\/h4>\\n<ul>\\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2391\\\">#2391<\\/a>)<\\/li>\\n<li>Fix: Print the main menu only when is necessary in Menu widget<\\/li>\\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2381\\\">#2381<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.0 - 2017-09-12<\\/h4>\\n<ul>\\n<li>New: Added Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1406\\\">#1406<\\/a>)<\\/li>\\n<li>Fix: Field ID for checkbox control in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2279\\\">#2279<\\/a>)<\\/li>\\n<li>Fix: Style for Blockquote widget included<\\/li>\\n<\\/ul>\\n<h4>1.7.2 - 2017-09-07<\\/h4>\\n<ul>\\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins<\\/li>\\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2340\\\">#2340<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.7.1 - 2017-09-05<\\/h4>\\n<ul>\\n<li>Fix: Facebook SDK version<\\/li>\\n<\\/ul>\\n<h4>1.7.0 - 2017-09-05<\\/h4>\\n<ul>\\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow<\\/li>\\n<li>New: Added Facebook Embed widget for Post, Video and Comment<\\/li>\\n<li>New: Added Facebook Comments widget<\\/li>\\n<li>New: Added Facebook Page widget (Previously known as Like Box)<\\/li>\\n<li>New: Added Blockquote widget with Tweet button<\\/li>\\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets<\\/li>\\n<li>Fix: Animated headline rotating with long words<\\/li>\\n<\\/ul>\\n<h4>1.6.1 - 2017-08-28<\\/h4>\\n<ul>\\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set<\\/li>\\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser<\\/li>\\n<li>Fix: Animated headline with more than 1-word per rotation<\\/li>\\n<li>Fix: Animated Headline in two lines<\\/li>\\n<li>Fix: Some errors in Global widget<\\/li>\\n<\\/ul>\\n<h4>1.6.0 - 2017-08-22<\\/h4>\\n<ul>\\n<li>New: Added Animated Headline widget<\\/li>\\n<li>New: Added Hidden field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2038\\\">#2038<\\/a>)<\\/li>\\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher<\\/li>\\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts<\\/li>\\n<\\/ul>\\n<h4>1.5.9 - 2017-08-16<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.7<\\/li>\\n<li>Fix: Portfolio compatibility for GeneratePress theme<\\/li>\\n<li>Fix: Portfolio filter compatibility for RTL<\\/li>\\n<li>Fix: Pagination apply for all posts widget in the page<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.8 - 2017-07-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.6<\\/li>\\n<li>Fix: Improved backward compatibility for query control rename<\\/li>\\n<\\/ul>\\n<h4>1.5.7 - 2017-07-24<\\/h4>\\n<ul>\\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file<\\/li>\\n<li>Tweak: Display the label in the reCAPTCHA field for better experience<\\/li>\\n<li>Tweak: Rename <code>panel-posts-control<\\/code> to <code>query-control<\\/code> and added fallback support<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor with history feature<\\/li>\\n<li>Fix: reCAPTCHA preview on the editor<\\/li>\\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2000\\\">#2000<\\/a>)<\\/li>\\n<li>Fix: Added condition for icon size control in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.5.6 - 2017-07-12<\\/h4>\\n<ul>\\n<li>Fix: Query Control correction for taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1963\\\">#1963<\\/a>)<\\/li>\\n<li>Fix: Custom CSS override scheme color in the editor<\\/li>\\n<li>Fix: Added order by Menu Order for Query Control in WC widget<\\/li>\\n<li>Fix: Glitch with Flip Box background overlay<\\/li>\\n<\\/ul>\\n<h4>1.5.5 - 2017-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist<\\/li>\\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999<\\/li>\\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed<\\/li>\\n<li>Fix: Sorted items in filter bar by A-Z<\\/li>\\n<li>Fix: Editor glitch with Elementor v1.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1927\\\">#1927<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.5.4 - 2017-06-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved compatibility for Elementor v1.5<\\/li>\\n<li>Fix: URL default for Add To Cart widget<\\/li>\\n<li>Fix: Allowed <code>date<\\/code> and <code>birthday<\\/code> fields as text for MailChimp integration<\\/li>\\n<\\/ul>\\n<h4>1.5.3 - 2017-06-19<\\/h4>\\n<ul>\\n<li>Tweak: Make flip-box height responsive control<\\/li>\\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1829\\\">#1829<\\/a>)<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.2 - 2017-06-13<\\/h4>\\n<ul>\\n<li>Fix: Custom CSS panel location compatibility for the old versions<\\/li>\\n<\\/ul>\\n<h4>1.5.1 - 2017-06-12<\\/h4>\\n<ul>\\n<li>Fix: MailChimp update existing user registration<\\/li>\\n<li>Fix: Global widget with JS in the editor mode<\\/li>\\n<li>Fix: Label section condition in Login widget<\\/li>\\n<li>Fix: Changes to unlinked global widget do not appear in the editor<\\/li>\\n<\\/ul>\\n<h4>1.5.0 - 2017-05-23<\\/h4>\\n<ul>\\n<li>New: Added Cards, a new skin for Posts widget<\\/li>\\n<li>New: Added Exclude option to post query control group<\\/li>\\n<li>Tweak: Added <code>post_class()<\\/code> for each post in the loop<\\/li>\\n<li>Tweak: Added <code>.elementor-posts-masonry<\\/code> class when Masonry layout is enabled<\\/li>\\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0<\\/li>\\n<li>Tweak: CSS <code>autoprefixer<\\/code> now supports last 5 versions of browsers<\\/li>\\n<li>Tweak: Added <code>imageLoaded<\\/code> library for Posts &amp; Portfolio widgets<\\/li>\\n<\\/ul>\\n<h4>1.4.4 - 2017-05-18<\\/h4>\\n<ul>\\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1683\\\">#1683<\\/a>)<\\/li>\\n<li>Fix: Added <code>.elementor-form<\\/code> class to Login form to fix style glitch<\\/li>\\n<\\/ul>\\n<h4>1.4.3 - 2017-05-14<\\/h4>\\n<ul>\\n<li>Tweak: Added Redirect After Login option to Login widget<\\/li>\\n<li>Tweak: Stay in the current page after logout in Login widget<\\/li>\\n<li>Tweak: Preparation for Elementor settings tabs in future version<\\/li>\\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone<\\/li>\\n<li>Fix: Bug with <code>active<\\/code> class in portfolio filter item<\\/li>\\n<li>Fix: Higher specific list-style-type <code>none<\\/code> for filter items to override some theme style<\\/li>\\n<\\/ul>\\n<h4>1.4.2 - 2017-05-06<\\/h4>\\n<ul>\\n<li>Fix: Temporary patch for form field shortcode in some servers<\\/li>\\n<\\/ul>\\n<h4>1.4.1 - 2017-05-03<\\/h4>\\n<ul>\\n<li>Fix: Bug with custom success message in form widget<\\/li>\\n<li>Fix: Bug with meta data in email action<\\/li>\\n<\\/ul>\\n<h4>1.4.0 - 2017-05-03<\\/h4>\\n<ul>\\n<li>New: Forms: integration with MailChimp<\\/li>\\n<li>New: Forms: integration with MailPoet<\\/li>\\n<li>New: Forms: Added Email 2 action for email confirmation<\\/li>\\n<li>New: Forms: Added shortcodes for fields<\\/li>\\n<li>New: Forms: Added custom ID for fields<\\/li>\\n<li>New: Forms: Added option to edit email HTML template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>New: Added Login widget<\\/li>\\n<li>Tweak: Move <code>send_html<\\/code> control to <code>email_content_type<\\/code><\\/li>\\n<li>Fix: Email still sent even if validation failed in form widget<\\/li>\\n<\\/ul>\\n<h4>1.3.2 - 2017-05-01<\\/h4>\\n<ul>\\n<li>New: Added action <code>elementor_pro\\/init<\\/code> for better integration with Elementor Pro<\\/li>\\n<li>Fix: Posts without featured image in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1234\\\">#1234<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1382\\\">#1382<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method<\\/li>\\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser<\\/li>\\n<li>Fix: Border radius glitch on hover in Share Buttons<\\/li>\\n<\\/ul>\\n<h4>1.3.1 - 2017-04-25<\\/h4>\\n<ul>\\n<li>Fix: Conflict update with revision history module<\\/li>\\n<\\/ul>\\n<h4>1.3.0 - 2017-04-25<\\/h4>\\n<ul>\\n<li>New: Added Share Buttons widget (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/social-sharing-buttons-is-it-possible\\/\\\">Topic<\\/a>)<\\/li>\\n<li>New: Added Custom CSS for Page Settings<\\/li>\\n<li>New: Added Masonry layout for Portfolio widget<\\/li>\\n<li>New: Added Cc &amp; Bcc options to email action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1181\\\">#1181<\\/a>)<\\/li>\\n<li>New: Introduced <code>ElementorProModulesFormsClassesAction_Base<\\/code> class for better 3rd party integration for forms<\\/li>\\n<li>Tweak: Debugger module now also shows errors from Pro<\\/li>\\n<li>Tweak: Added options for Elementor Library<\\/li>\\n<li>Tweak: New base posts module for optimized performance<\\/li>\\n<li>Tweak: Adjusting Posts \\/ Portfolio to the new structure<\\/li>\\n<li>Fix: Export for posts \\/ portfolio<\\/li>\\n<li>Fix: Duplicate repeater field with switcher control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1442\\\">#1442<\\/a>)<\\/li>\\n<li>Fix: Post per Page in the query control<\\/li>\\n<li>Fix: Metadata does not come through on form emails (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1566\\\">#1566<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.2.6 - 2017-04-19<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets<\\/li>\\n<\\/ul>\\n<h4>1.2.5 - 2017-04-18<\\/h4>\\n<ul>\\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)<\\/li>\\n<\\/ul>\\n<h4>1.2.4 - 2017-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added Indian Rupee sign to Price Table widget<\\/li>\\n<li>Fix: Portfolio grid for IE11<\\/li>\\n<li>Fix: Link target blank in Price List widget<\\/li>\\n<li>Fix: Active item for filter bar in Portfolio widget<\\/li>\\n<\\/ul>\\n<h4>1.2.3 - 2017-03-06<\\/h4>\\n<ul>\\n<li>Tweak: Fully compatible with Elementor v1.3.0<\\/li>\\n<li>Tweak: Added trigger for after form submission in Forms widget<\\/li>\\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms<\\/li>\\n<li>Fix: Portfolio filter syntax in Non-Latin languages<\\/li>\\n<li>Fix: Added <code>no-repeat<\\/code> property for slide with <code>background-size:contain<\\/code><\\/li>\\n<li>Fix: Condition control &amp; Import value in Posts widgets<\\/li>\\n<li>Fix: Offset and Pagination in WordPress (<a href=\\\"https:\\/\\/codex.wordpress.org\\/Making_Custom_Queries_using_Offset_and_Pagination\\\">More Info<\\/a>)<\\/li>\\n<li>Fix: Submit handler bubbling for custom events in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.2.2 - 2017-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Change name from Side A\\/B to Front and Back in Flip Box widget<\\/li>\\n<li>Fix: Error when saving third party widgets in the global widget<\\/li>\\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)<\\/li>\\n<li>Fix: Hide the pagination when there are no links<\\/li>\\n<\\/ul>\\n<h4>1.2.1 - 2017-02-21<\\/h4>\\n<ul>\\n<li>Fix: Firefox Flip Box 3D compatibility<\\/li>\\n<\\/ul>\\n<h4>1.2.0 - 2017-02-21<\\/h4>\\n<ul>\\n<li>New: Added Flip Box widget<\\/li>\\n<li>New: Added Ken Burns effect for slides<\\/li>\\n<li>New: Added Masonry layout for Posts widget<\\/li>\\n<li>New: Added Pagination option for Posts widget<\\/li>\\n<li>Tweak: Added background size contain to slides<\\/li>\\n<li>Tweak: Improve Query control by preload items<\\/li>\\n<li>Fix: Text color for Checkbox and Radio fields<\\/li>\\n<\\/ul>\\n<h4>1.1.2 - 2017-02-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>aria-required<\\/code> for better accessibility in forms widget<\\/li>\\n<li>Fix: Conflict Call to <code>undefined<\\/code> method in Posts &amp; Portfolio widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1271\\\">#1271<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1266\\\">#1266<\\/a>)<\\/li>\\n<li>Fix: Submit button HTML after error sending<\\/li>\\n<li>Fix: Success message for <code>skip_email<\\/code> function<\\/li>\\n<li>Notice: Elementor 1.2.0 or later now required<\\/li>\\n<\\/ul>\\n<h4>1.1.1 - 2017-01-24<\\/h4>\\n<ul>\\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG<\\/code> is <code>true<\\/code><\\/li>\\n<li>Fix: Undefined variable in WC widgets<\\/li>\\n<li>Fix: Removed duplicate strings<\\/li>\\n<\\/ul>\\n<h4>1.1.0 - 2017-01-24<\\/h4>\\n<ul>\\n<li>New: Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/102\\\">#102<\\/a>)<\\/li>\\n<li>New: WooCommerce Add to Cart widget<\\/li>\\n<li>New: WooCommerce Categories widget<\\/li>\\n<li>New: WooCommerce Elements widget<\\/li>\\n<li>New: Honeypot field for Forms widgets<\\/li>\\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items<\\/li>\\n<li>Tweak: Added Required Mark for fields in Forms widget<\\/li>\\n<li>Fix: CSS selectors priority in Slides widget<\\/li>\\n<li>Fix: CSS bug in Price List widget<\\/li>\\n<li>Fix: Update all Post CSS files that includes specific Global Widget<\\/li>\\n<\\/ul>\\n<h4>1.0.9 - 2017-01-18<\\/h4>\\n<ul>\\n<li>Fix: Auto complete bug in query controls<\\/li>\\n<li>Fix: Render template with escaping slashes<\\/li>\\n<li>Fix: Reply-to field in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.0.8 - 2017-01-11<\\/h4>\\n<ul>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Removed go pro link from plugins page in admin<\\/li>\\n<\\/ul>\\n<h4>1.0.7 - 2017-01-05<\\/h4>\\n<ul>\\n<li>Tweak: Added filter by featured \\/ sale for WC Products widget<\\/li>\\n<li>Tweak: Added author control in Portfolio widget<\\/li>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Added support for empty image ratio<\\/li>\\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself<\\/li>\\n<\\/ul>\\n<h4>1.0.6 - 2017-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Added Auto-updates for local translation files<\\/li>\\n<li>Fix: Custom CSS for Global widgets<\\/li>\\n<li>Fix: Remove <code>nonce<\\/code> field (Fix some cache plugins)<\\/li>\\n<\\/ul>\\n<h4>1.0.5 - 2016-12-27<\\/h4>\\n<ul>\\n<li>Fix: Slide element bug fix - \'Link apply on\' logic<\\/li>\\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1086\\\">#1086<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.0.4 - 2016-12-21<\\/h4>\\n<ul>\\n<li>Tweak: Mobile Editing for fields in the form widget<\\/li>\\n<li>Tweak: Mobile Editing for posts<\\/li>\\n<li>Tweak: Allow send form as HTML<\\/li>\\n<li>Tweak: Improved auto upgrades for Multisite installation<\\/li>\\n<li>Tweak: Improve editor rendering experience for Portfolio widget<\\/li>\\n<li>Fix: Posts widget check if image exist<\\/li>\\n<li>Fix: Changed the clone method for global widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1042\\\">#1042<\\/a>)<\\/li>\\n<li>Fix: Bug slides in RTL (removed direction control)<\\/li>\\n<li>Fix: Slides with no height jumps when changing slides<\\/li>\\n<\\/ul>\\n<h4>1.0.3 - 2016-12-13<\\/h4>\\n<ul>\\n<li>Fix: Added escape placeholder for HTML Entities in form widget<\\/li>\\n<li>Fix: Countdown widget RTL bug<\\/li>\\n<li>Fix: Remove redundant #elementor selector for control style<\\/li>\\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>1.0.2 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form<\\/li>\\n<\\/ul>\\n<h4>1.0.1 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active<\\/li>\\n<\\/ul>\\n<h4>1.0.0 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Initial release<\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.17.1\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.3.2\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiZXAtVEpVS0FqSVBGbzI4ZU8waHZsZ3IxNjE1NDQxMTY0U0RPeTVCT2UzVThzIiwidXJsIjoiaHR0cHM6Ly9zbGsubHdpLm15Ymx1ZWhvc3QubWUvc3RhZ2luZy9nZmkiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzAwNjI0MjY3LCJleHAiOjE3MDA3MTA2Njd9.4lOKUuVgSVs94IV_K7RuP80Kq4RR9rOKnC6lBLxYluM\\/package_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiZXAtVEpVS0FqSVBGbzI4ZU8waHZsZ3IxNjE1NDQxMTY0U0RPeTVCT2UzVThzIiwidXJsIjoiaHR0cHM6Ly9zbGsubHdpLm15Ymx1ZWhvc3QubWUvc3RhZ2luZy9nZmkiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzAwNjI0MjY3LCJleHAiOjE3MDA3MTA2Njd9.4lOKUuVgSVs94IV_K7RuP80Kq4RR9rOKnC6lBLxYluM\\/package_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.7.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.3.2\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiZXAtVEpVS0FqSVBGbzI4ZU8waHZsZ3IxNjE1NDQxMTY0U0RPeTVCT2UzVThzIiwidmVyc2lvbiI6IjMuNy4wIiwidXJsIjoiaHR0cHM6Ly9zbGsubHdpLm15Ymx1ZWhvc3QubWUvc3RhZ2luZy9nZmkiLCJpYXQiOjE3MDA2MjQyNjcsImV4cCI6MTcwMDcxMDY2N30.B1cC1-bDbhnnVr6KFjtnGxt1uWuhedF8efO38bFVbQI\\/previous_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiZXAtVEpVS0FqSVBGbzI4ZU8waHZsZ3IxNjE1NDQxMTY0U0RPeTVCT2UzVThzIiwidmVyc2lvbiI6IjMuNy4wIiwidXJsIjoiaHR0cHM6Ly9zbGsubHdpLm15Ymx1ZWhvc3QubWUvc3RhZ2luZy9nZmkiLCJpYXQiOjE3MDA2MjQyNjcsImV4cCI6MTcwMDcxMDY2N30.B1cC1-bDbhnnVr6KFjtnGxt1uWuhedF8efO38bFVbQI\\/previous_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]},\"cloud\":false}\";}", "no");
INSERT INTO `wpgfi_options` VALUES("5324", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1700667461", "no");
INSERT INTO `wpgfi_options` VALUES("5325", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1700624261", "no");
INSERT INTO `wpgfi_options` VALUES("5330", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1700667462", "no");
INSERT INTO `wpgfi_options` VALUES("5331", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1700624262", "no");
INSERT INTO `wpgfi_options` VALUES("5332", "_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b", "1700667462", "no");
INSERT INTO `wpgfi_options` VALUES("5333", "_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2023/11/state-of-the-word-2023-madrid-spain/\'>State of the Word 2023 – Madrid, Spain</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2023/11/introducing-twenty-twenty-four/\'>Introducing Twenty Twenty-Four</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://dothewoo.io/now-is-the-time-for-passkeys-in-wordpress-all-the-time-with-timothy-jacobs/\'>Do The Woo Community: Now is the Time for Passkeys in WordPress, All the Time with Timothy Jacobs</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/whats-next\'>WPTavern: What’s Next?</a></li><li><a class=\'rsswidget\' href=\'https://ma.tt/2023/11/sunbird/\'>Matt: Sunbird Security Isn’t Nothing</a></li></ul></div>", "no");
INSERT INTO `wpgfi_options` VALUES("5311", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1700624406;s:7:\"checked\";a:5:{s:15:\"hello-elementor\";s:5:\"2.8.1\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:15:\"twentytwentyone\";s:3:\"1.9\";s:17:\"twentytwentythree\";s:3:\"1.2\";s:15:\"twentytwentytwo\";s:3:\"1.5\";}s:8:\"response\";a:4:{s:15:\"hello-elementor\";a:6:{s:5:\"theme\";s:15:\"hello-elementor\";s:11:\"new_version\";s:5:\"2.9.0\";s:3:\"url\";s:45:\"https://wordpress.org/themes/hello-elementor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/hello-elementor.2.9.0.zip\";s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.0\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.2.0.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.3.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.6.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:1:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.0.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wpgfi_options` VALUES("3504", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wpgfi_options` VALUES("5322", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1700667461", "no");
INSERT INTO `wpgfi_options` VALUES("5323", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Nov 2023 12:37:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.5-alpha-57130\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"State of the Word 2023 – Madrid, Spain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2023/11/state-of-the-word-2023-madrid-spain/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Nov 2023 20:03:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"sotw\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"state of the word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16429\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"The countdown is on for this year\'s State of the Word! If you missed the initial announcement a few weeks ago, mark your calendars for December 11, 2023.\n\nState of the Word is the annual keynote in which WordPress co-founder Matt Mullenweg celebrates the progress of the open source project and offers a glimpse into its future.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4327:\"\n<figure class=\"wp-block-image size-large\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/SOTW-Blue.png?resize=1024%2C683&#038;ssl=1\" alt=\"State of the Word\" class=\"wp-image-16438\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/SOTW-Blue.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/SOTW-Blue.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/SOTW-Blue.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/SOTW-Blue.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/11/SOTW-Blue.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>The countdown is on for this year&#8217;s State of the Word! If you missed the initial announcement a few weeks ago, you&#8217;ll want to mark your calendars for December 11, 2023.</p>\n\n\n\n<p>State of the Word is the annual keynote in which WordPress co-founder <a href=\"https://ma.tt/\">Matt Mullenweg</a> celebrates the progress of the open source project and offers a glimpse into its future.</p>\n\n\n\n<p>For the first time, State of the Word ventures beyond North America, bringing the WordPress community to a new and vibrant city that plays a vital role in the WordPress project &#8212; Madrid, Spain! The event will be live-streamed to WordPress enthusiasts and newcomers around the globe via the <a href=\"https://youtube.com/wordpress\">WordPress YouTube channel</a>.</p>\n\n\n\n<p>Please visit the <a href=\"https://wordpress.org/state-of-the-word\">event website</a> for more event details and live-streaming information.</p>\n\n\n\n<p><strong>What:</strong> State of the Word 2023<br><strong>When: </strong><a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2023&amp;dates=20231211T150000Z/20231211T190000Z&amp;details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+Matt+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+Madrid,+Spain,+and+is+free+for+all+to+watch+or+attend+in+person+with+a+ticket.%0A%0Ahttps://wordpress.org/state-of-the-word/\">December 11, 2023, 15:00 UTC</a> (Start of live stream)<br><strong>Where: </strong><a href=\"https://www.palacioneptuno.com/\">Palacio Neptuno</a>, Madrid, Spain<br><strong>Streaming: </strong><a href=\"https://youtube.com/wordpress\">Watch the live stream</a> on the WordPress YouTube channel.<br><strong>Tickets: </strong><a href=\"https://wordcampcentral.survey.fm/request-a-seat-sotw-2023-spain\">Request a ticket to attend in person</a>.<strong><br></strong><em>Please note that the venue’s capacity is limited; therefore, not all ticket requests will be granted. </em><br><strong>Meetups: </strong>The community will support several local watch parties globally, both in<br>person and online. <a href=\"https://wordpress.org/state-of-the-word\">Find one near you or organize one</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Have a question for Matt?</h2>\n\n\n\n<p>State of the Word will include a Q&amp;A session. If you want to participate, you can send your question to ask-matt@wordcamp.org or ask during the event via the Q&amp;A app Slido. A QR code for your submission will be provided during the event live stream.</p>\n\n\n\n<p>Given the volume of questions usually submitted, only some will be answered live, while others will be covered in a follow-up post published after the event on <a href=\"https://make.wordpress.org/project\">make.wordpress.org/project</a>.</p>\n\n\n\n<p>Is this your first State of the Word? Check out <a href=\"https://wordpress.tv/tag/state-of-the-word/\">prior events on WordPress.tv</a> for an introduction to the format.</p>\n\n\n\n<p>See you in person and online on December 11!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><em>Thank you to <a href=\"https://profiles.wordpress.org/rmartinezduque/\">Reyes Martínez</a> and <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a> for reviewing this post.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16429\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:68:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Introducing Twenty Twenty-Four\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wordpress.org/news/2023/11/introducing-twenty-twenty-four/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Nov 2023 18:29:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:6:\"Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"Twenty Twenty-Four\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Meet Twenty Twenty-Four, the most versatile default theme yet—bundled with WordPress 6.4 and ready to make it uniquely yours.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2023/11/tt4-i9-small-1.mp4\";s:6:\"length\";s:7:\"6747134\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:82:\"https://wordpress.org/news/files/2023/11/tt4-howto-replace-template_compressed.mp4\";s:6:\"length\";s:8:\"12815358\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Maggie Cabrera\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7209:\"\n<p>When it comes to designing a website, one size doesn&#8217;t fit all. We understand that every WordPress user has unique needs and goals, whether you&#8217;re an aspiring entrepreneur, a passionate photographer, a prolific writer, or a bit of them all. That&#8217;s why we are thrilled to introduce <a href=\"https://wordpress.org/themes/twentytwentyfour/\"><strong>Twenty Twenty-Four</strong></a>, the most versatile default theme yet—bundled with <a href=\"https://wordpress.org/download/releases/6-4/\">WordPress 6.4</a> and ready to make it uniquely yours.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls poster=\"https://wordpress.org/news/files/2023/11/TT4-square.jpg\" src=\"https://wordpress.org/news/files/2023/11/tt4-i9-small-1.mp4\"></video></figure>\n\n\n\n<h2 class=\"wp-block-heading\">A theme for every style</h2>\n\n\n\n<p>Unlike past default themes, Twenty Twenty-Four breaks away from the tradition of focusing on a specific topic or style. Instead, this theme has been thoughtfully crafted to cater to any type of website, regardless of its focus. The theme explores <strong>three different use cases</strong>: one designed for entrepreneurs and small businesses, another for photographers and artists, and a third tailored for writers and bloggers. Thanks to its multi-faceted nature and adaptability, Twenty Twenty-Four emerges as the perfect fit for any of your projects.</p>\n\n\n\n<p>As you dive into its templates and patterns, you will notice how the new Site Editor functionality opens up different pathways for building your site seamlessly.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Patterns at every step</h2>\n\n\n\n<p>Whether you&#8217;re looking to craft an About page, showcase your work, handle RSVPs, or design captivating landing pages, Twenty Twenty-Four has got you covered.<strong> </strong>Choose from an extensive collection of <a href=\"https://2024.wordpress.net/index.php/patterns/\"><strong>over 35 beautiful patterns</strong></a> to customize and suit your needs.</p>\n\n\n\n<p>For the first time, this theme features full-page patterns for templates like homepage, archive, search, single pages, and posts. Some are exclusively available during the template-switching and creation process, ensuring you have the right options when you need them.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://wordpress.org/news/files/2023/11/tt4-howto-replace-template_compressed.mp4\"></video></figure>\n\n\n\n<p>Moreover, you can take advantage of a variety of patterns for page sections, such as FAQs, testimonials, or pricing, to meet your site&#8217;s most specific requirements.</p>\n\n\n\n<p>With this diverse pattern library, Twenty Twenty-Four offers a flexible canvas to quickly assemble pages without having to start from scratch—saving you time and energy in the creation process. Just let your creativity flow and explore the possibilities!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" width=\"1024\" height=\"682\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/TT4-Post-Image-1.jpg?resize=1024%2C682&#038;ssl=1\" alt=\"Screenshots of Twenty Twenty-Four patterns.\" class=\"wp-image-16397\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/TT4-Post-Image-1.jpg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/TT4-Post-Image-1.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/TT4-Post-Image-1.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/TT4-Post-Image-1.jpg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/11/TT4-Post-Image-1.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Site editing in its finest form</h2>\n\n\n\n<p>Twenty Twenty-Four ushers in a new era of block themes by bringing together the latest WordPress site editing capabilities. Discover newer design tools such as background image support in Group blocks and vertical text, providing an intuitive and efficient way to create compelling, interactive content.</p>\n\n\n\n<p>Find image placeholders with predefined aspect ratio settings within patterns, allowing you to drop images that perfectly fill the space. To go one step further, make your visuals interactive by enabling lightboxes. Ideal for showcasing galleries or portfolio images, this feature allows your visitors to expand and engage with them in full-screen mode. Activate it globally for all images throughout your site or for specific ones.</p>\n\n\n\n<p>For a smoother browsing experience on your site, you can disable the &#8220;Force page reload&#8221; setting in the Query Loop block. This allows the necessary content to be loaded dynamically when switching between different pages without needing a full-page refresh.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Elegance with purpose</h2>\n\n\n\n<p>Twenty Twenty-Four goes beyond versatility with a beautiful aesthetic inspired by contemporary design trends, giving your website a sleek and modern look. Key design elements include:</p>\n\n\n\n<ul>\n<li><strong>Cardo font for headlines</strong>: The Cardo font adds a touch of elegance to your site, creating a sophisticated visual experience.</li>\n\n\n\n<li><strong>Sans-serif system font for paragraphs</strong>: The sans-serif font ensures that your texts are cleaner and easier to read, enhancing overall readability.</li>\n\n\n\n<li><strong>Eight style variations</strong>: Twenty Twenty-Four presents a light color palette for a fresh and inviting appearance out-of-the-box, but you can customize it with seven additional style variations. Each includes fonts and colors carefully curated to work beautifully alongside the patterns and templates.</li>\n\n\n\n<li><strong>Sans-serif variations</strong>: Besides the default styles, the theme offers two additional sans-serif variations, providing more choices for your site&#8217;s typography.</li>\n</ul>\n\n\n\n<p>Along with its design, Twenty Twenty-Four has been meticulously optimized for performance. This ensures that your website not only looks great but also delivers a fast and efficient user experience.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://playground.wordpress.net/?theme=twentytwentyfour\">Explore Twenty Twenty-Four now</a></div>\n</div>\n\n\n\n<p>More information can be found in the following links:</p>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/themes/twentytwentyfour/\">Download Twenty Twenty-Four</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/documentation/article/twenty-twenty-four/\">Twenty Twenty-Four Documentation</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four Kick Off</a></li>\n</ul>\n\n\n\n<p><em>The Twenty Twenty-Four theme was designed by </em><a href=\"https://profiles.wordpress.org/beafialho/\"><em>Beatriz Fialho</em></a><em> and made possible thanks to the passion and tireless work of <a href=\"https://github.com/WordPress/twentytwentyfour/blob/trunk/CONTRIBUTORS.md\">more than 120 contributors</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16394\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WP Briefing: Episode 66: Advocating Open Source Solutions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wordpress.org/news/2023/11/episode-66-advocating-open-source-solutions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Nov 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16357\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:296:\"WordPress Executive Director, Josepha Haden Chomphosy, speaks to the strategic approach to integrating open source solutions within your company and offers insight into initiating open source advocacy conversations. Tune in for a session that could redefine your company\'s technological approach.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:51:\"https://wordpress.org/news/files/2023/11/WPB066.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11349:\"\n<p>WordPress Executive Director, Josepha Haden Chomphosy, speaks to the strategic approach to integrating open source solutions within your company and offers insight into initiating open source advocacy conversations. Tune in for a session that could redefine your company&#8217;s technological approach.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@WordPress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://wordpress.org/download/releases/6-4/\">WordPress 6.4 &#8220;Shirley&#8221;</a>  &#8211; The final major release of 2023 launched on November 7 &#8211; WordPress 6.4 &#8220;Shirley.&#8221; Download and check out this empowering release. </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/10/31/whats-new-on-learn-wordpress-in-october-2023/\" target=\"_blank\" rel=\"noreferrer noopener\">The Training Team recently published</a> several new Learn resources for training guides to support Meetup Organizers. From lesson plans to online workshops, there are several ways to help you in your goals as a contributor to WordPress.</li>\n\n\n\n<li>The Diversity Team <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/diversity-speaker-training-workshop/\" target=\"_blank\" rel=\"noreferrer noopener\">recently published</a> a new Diverse Speaker Training page, providing resources for new and experienced contributors to bring more diverse speaker lineups and inclusive, diverse WP events for official WordPress Meetups and WordCamps.</li>\n\n\n\n<li>If you have a story showing how WordPress has impacted what you are doing or what people you know have done, record something and send it to <a href=\"mailto:wpbriefing@WordPress.org\">wpbriefing@WordPress.org</a>. We&#8217;d love to hear from you.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcripts</h2>\n\n\n\n<span id=\"more-16357\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing. The podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[00:00:28] (Intro music)&nbsp;</p>\n\n\n\n<p>[00:00:40] <strong>Josepha:</strong> Today, we&#8217;re talking about something I used to have a lot of experience with in my career before WordPress. I worked at a marketing agency. I wasn&#8217;t a developer. I was in data and strategy sorts of things. But part of the work heading into every project was an evaluation of what software was best. There were always a variety being considered, but WordPress was frequently one of them.</p>\n\n\n\n<p>Now, I don&#8217;t know if any of you have had that moment where you&#8217;re having to talk open source with a CTO or a CEO, but it can be nerve-wracking, to say the least. And it makes sense, right? Open source has a PR problem, especially when you&#8217;re speaking to leadership inside a business. And it doesn&#8217;t really matter the size, right?</p>\n\n\n\n<p>You&#8217;re advocating for something that requires a completely different mental model. It doesn&#8217;t fit into accepted concepts of what makes a business thrive or what makes a bet a sure thing. There were three, maybe four, concerns that came up every time I had this conversation. So, I&#8217;m going to share those concerns with you and a few possible counterpoints to get you started.</p>\n\n\n\n<p>[00:01:48] <strong>Josepha:</strong> First and always is the concern around security. I believe that this particular mismatch is rooted in an idea that controlled equals secure, which isn&#8217;t always the case. So the talking point is this. Since open source has a transparent development process, it is often more secure than proprietary software, contrary to what you might hear.</p>\n\n\n\n<p>That transparency allows vulnerabilities to be identified by independent researchers and community members and then patched quickly because you aren&#8217;t limited by who or what you know personally. </p>\n\n\n\n<p>And if you&#8217;re not having a conversation where you&#8217;re having to defend the security in open source and you just want to bring it up yourself, here is a conversation opener for that. Security is a top concern for all of us. Surprisingly, open source solutions often have stronger security measures due to the collaborative nature of their development. It&#8217;s a proactive approach to minimizing risks.&nbsp;</p>\n\n\n\n<p>[00:02:43] <strong>Josepha:</strong> A second thing that frequently came up was questions around innovation and future proofing of open source products. I think this mismatch is fully rooted in the Cathedral and the Bazaar methods of advancement. So the talking point for that one is this. Embracing open source fosters innovation. We can tap into the latest technologies and stay ahead of industry trends that way. It is specifically because we have a diverse set of viewpoints that we can make sure to quickly account for future risks, along with taking advantage of future opportunities. And by our organization being more active, we can potentially get exactly the solutions we need for our clients long term.</p>\n\n\n\n<p>And the conversation opener for this, if you are the one bringing up the topic, is I&#8217;ve been thinking about our long-term goals and how to keep our technology stack relevant. Open source not only keeps us current but also positions us as innovators in our field.</p>\n\n\n\n<p>[00:03:40] <strong>Josepha:</strong> And finally, the thing that seems to make or break the decision is the concept of independence. Part of any good business decision, especially around software, is determining upfront costs to getting started, long-term effectiveness of the chosen solution, and long-term mobility should circumstances change. Open source can address these from multiple vantage points.</p>\n\n\n\n<p>So here&#8217;s a good talking point for that one. Open source liberates us from vendor lock-in. We&#8217;re not tied to a single vendor&#8217;s roadmap or pricing changes, providing us with more options that suit our needs our clients&#8217; needs. Also, given how ubiquitous WordPress is in particular, there will always be a disaster recovery option should a senior developer leave.</p>\n\n\n\n<p>And beyond all of that, clients can own all of the content, audience attention, and clientele that we have all worked so hard to help them earn. And again, if you&#8217;re not defending things and instead choosing to bring them up as somebody who is trying to affect change in your own organization, here is a good place to start for that.</p>\n\n\n\n<p>Considering the dynamic nature of our industry, having the freedom to choose solutions independent of a specific vendor makes sure that we are always in control of our destiny.</p>\n\n\n\n<p>[00:04:59] <strong>Josepha:</strong> So, those are the three most frequent things I encountered when I was having conversations about which software to choose and what software was the best choice long term for both our organization and our client&#8217;s organizations.</p>\n\n\n\n<p>If you have been in the midst of this type of conversation and have been longing for some counterpoints, I hope this helps. But if you have been feeling in your heart of hearts that your company or organization would be better off using open source software, and of course, in my context, particularly WordPress as that software, but you&#8217;ve been worried about bringing it up, I hope this gives you the courage to get out there and be an agent of change in your organization. You can do it, and I know you can.</p>\n\n\n\n<p>[00:05:44] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:05:51] <strong>Josepha:</strong> All right, my friends, that brings us now to our small list of big things. </p>\n\n\n\n<p>[00:05:57] <strong>Josepha:</strong> First on the list, big, big thing. We launched WordPress 6.4 on November 7th, about a week ago. Be sure to download and check out the latest update on this monumental release. And while you&#8217;re doing it. Be sure to check out the new default theme that came out with it. It has a lot of patterns in it. I know I&#8217;ve talked about it quite a bit over the course of the year, but it&#8217;s really beautiful, and I think that it&#8217;s worth a good, strong highlight. So WordPress 6.4, you can get it on WordPress.org/download or inside your own host, probably. </p>\n\n\n\n<p>[00:06:29] <strong>Josepha:</strong> The second thing that we have is that the training team recently published several new Learn resources to support meetup organizers. So we&#8217;ve got over there some lesson plans, tutorials, online workshops. And there are also new materials that help you figure out how to accomplish your goals as a contributor to the WordPress project.</p>\n\n\n\n<p>[00:06:49] <strong>Josepha:</strong> And we also have a recently published new diverse speaker training page. It provides incredible resources for new and experienced contributors to bring more diverse speaker lineups and inclusive, diverse WordPress events for official WordPress meetups and WordCamps. </p>\n\n\n\n<p>[00:07:06] <strong>Josepha:</strong> And the fourth thing on our small list of big things today is that I would love to get a few voice recordings from you all, from folks who are listening to the WordPress Briefing, or folks that you know, to learn more about how WordPress has impacted you. </p>\n\n\n\n<p>One of the things that I miss the most from my days as a WordCamp organizer is that annually, I got to see people who had shown up, once at a meetup, you know, to learn what WordPress was, and then came back year after year to our WordCamp with these new goals and new successes and I got to watch their businesses change over time. And so if you have a story like that where WordPress impacted what you are doing or what people that you know have done, record something and send it to wpbriefing@WordPress.org. </p>\n\n\n\n<p>So that, my friends, is your small list of big things.</p>\n\n\n\n<p>[00:08:04] <strong>Josepha:</strong> Don&#8217;t forget to follow us on your favorite podcasting app or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever there is a new episode. If you liked what you heard today, share it with a fellow WordPresser. Or, if you had questions about what you heard, you can share those with me at wpbriefing@WordPress.org. I&#8217;m your host, Josepha Haden Chomphosy. Thanks for tuning in today for the WordPress Briefing, and I&#8217;ll see you again in a couple of weeks. </p>\n\n\n\n<p>[00:08:31] (Music outro)</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16357\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The Month in WordPress – October 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2023/11/the-month-in-wordpress-october-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Nov 2023 23:06:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:18:\"month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"September-October 2023 was yet another fun and eventful chapter in WordPress, with more WordCamps hosting exciting discussions, knowledge sharing, and learning. This month also welcomed the release of WordPress 6.4 and the Twenty Twenty-Four theme. Let’s check it out. Meet WordPress 6.4 “Shirley” WordPress 6.4 “Shirley” was released on November 7, 2023, and named after [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11694:\"\n<p>September-October 2023 was yet another fun and eventful chapter in WordPress, with more WordCamps hosting exciting discussions, knowledge sharing, and learning. This month also welcomed the release of WordPress 6.4 and the Twenty Twenty-Four theme. Let’s check it out.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Meet WordPress 6.4 “Shirley”</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=1024%2C683&#038;ssl=1\" alt=\"Shirley WordPress 6.4\" class=\"wp-image-16319\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/11/shirley/\">WordPress 6.4 “Shirley”</a> was released on November 7, 2023, and named after the iconic jazz artist Shirley Horn. With the release of WordPress 6.4 comes the new <a href=\"https://wordpress.org/themes/twentytwentyfour/\">Twenty Twenty-Four theme</a>, a multi-faceted, highly flexible default theme pre-loaded with more than 35 templates and patterns.&nbsp;</p>\n\n\n\n<p>This release includes more than 100 performance-related updates for a faster and more efficient experience. There’s also a host of new features and enhancements that help improve the content creation process and streamline site editing.&nbsp;</p>\n\n\n\n<p>WordPress 6.4 was made possible by more than 600 contributors in at least 56 countries.&nbsp;Leading this release has been an underrepresented gender team, emphasizing WordPress’ commitment to fostering diverse voices in the open source project.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-2 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-color has-dark-strokes-grey-background-color has-text-color has-background has-link-color wp-element-button\" href=\"https://wordpress.org/download/releases/6-4/\">Learn more about WordPress 6.4</a></div>\n</div>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">State of the Word 2023</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/Web-SOTW-Image-1200x800-2.png?resize=1024%2C683&#038;ssl=1\" alt=\"State of the Word 2023 in Madrid Spain on December 11, 2023 at 15:00 UTC\" class=\"wp-image-16208\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/10/Web-SOTW-Image-1200x800-2.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/10/Web-SOTW-Image-1200x800-2.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/10/Web-SOTW-Image-1200x800-2.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/10/Web-SOTW-Image-1200x800-2.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/10/Web-SOTW-Image-1200x800-2.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Mark your calendars for State of the Word! The annual keynote address delivered by the WordPress project’s co-founder, Matt Mullenweg, will be held on December 11, 2023. For the first time, the event will take place outside North America—this time with the Spanish community in <strong>Madrid, Spain</strong>.</p>\n\n\n\n<p>A live stream will be available for WordPress enthusiasts who will not be able to attend in person. Stay tuned for more information, including how to reserve a ticket, soon!</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-3 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-color has-dark-strokes-grey-background-color has-text-color has-background has-link-color wp-element-button\" href=\"https://wordpress.org/news/2023/10/state-of-the-word-2023/\">Learn more about this year’s State of the Word</a></div>\n</div>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">New in the Gutenberg plugin</h2>\n\n\n\n<p>Two new versions of Gutenberg shipped in October:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\"><strong>Gutenberg 16.8</strong></a> was released on October 11, 2023. It introduced enhancements to the Cover block and Font Library, and added the option to view the active template when editing pages.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/25/whats-new-in-gutenberg-16-9-25-october-2/\"><strong>Gutenberg 16.9</strong></a> was released on October 25, 2023. This update lets you rename nearly every block from within the editor, as well as duplicate or rename individual patterns.&nbsp;</li>\n</ul>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/10/05/core-editor-improvement-ensuring-excellence-in-the-writing-experience/\">October’s Core Editor Improvement</a> post dives into all the writing enhancements expected in the latest WordPress 6.4 release.</p>\n\n\n\n<a class=\"wp-block-jetpack-podcast-player jetpack-podcast-player__direct-link\" href=\"https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/\">https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/</a>\n\n\n\n<h2 class=\"wp-block-heading\">Team updates</h2>\n\n\n\n<ul>\n<li>The journey to update WordPress.org continues with the launch of a <a href=\"https://wordpress.org/news/2023/10/a-new-wordpress-showcase/\">new Showcase design</a>. The redesigned Showcase inspires creativity, highlights the platform’s flexibility, and demonstrates what’s possible with WordPress.</li>\n\n\n\n<li>The Performance Team held a <a href=\"https://make.wordpress.org/core/2023/09/18/hallway-hangout-performance-improvements-for-wordpress-6-4/\">Hallway Hangout</a> to discuss WordPress 6.3 performance impact in the field, diving into WordPress 6.4 performance improvements and looking ahead at what can be learned for WordPress 6.5.</li>\n\n\n\n<li>The Documentation Team created a new <a href=\"https://github.com/WordPress/documentation-end-user\">GitHub repo</a> for end-user documentation and its translations to all locales. You can find out more about this <a href=\"https://make.wordpress.org/project/2023/09/06/documentation-translation-localization/\">here</a>.</li>\n\n\n\n<li>Openverse has been awarded the <a href=\"https://wordpress.org/news/2023/09/openverse-wins-the-2023-oeg-open-infrastructure-award/\">2023 Open Education Award for Excellence in the Open Infrastructure category</a>. Congratulations!</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/07/evolving-the-fse-outreach-program/\">Learn more about the next chapter for the FSE (Full Site Editing) Outreach Program</a>, which looks to transition into a focused space for solving issues, creating resources, and facilitating conversations around adopting Phase 2 of Gutenberg.</li>\n\n\n\n<li>The Accessibility team is <a href=\"https://make.wordpress.org/accessibility/2023/09/13/accessibility-office-hours/\">holding weekly office hours</a> to discuss accessibility principles and best practices for the project.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Requests for feedback &amp; testing</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/updates/2023/11/03/mobile-team-update-november-3rd-2/\">Version 23.6</a> of the WordPress mobile app for iOS and Android is ready for testing.</li>\n</ul>\n\n\n\n<a class=\"wp-block-jetpack-podcast-player jetpack-podcast-player__direct-link\" href=\"https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/\">https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/</a>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress events updates</h2>\n\n\n\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1f9-1f1fc.png\" alt=\"🇹🇼\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> WordCamp Asia has <a href=\"https://asia.wordcamp.org/2024/call-for-sponsors-extended-to-november-30th/\">extended their call for sponsors</a> for their conference slated to take place in Taipei, Taiwan, March 7-9, 2024.&nbsp;</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e8-1f1f7.png\" alt=\"🇨🇷\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> There will be a <a href=\"https://www.eventbrite.com/e/wordpress-wpdiversity-speaker-workshop-for-women-voices-in-latin-america-tickets-621207738067?aff=oddtdtcreator\">WordPress #WPDiversity Speaker Workshop for Women Voices in Latin America</a> in San Jose, Costa Rica on November 11, 2023.</li>\n\n\n\n<li>Don’t miss these upcoming WordCamps:\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ea-1f1f8.png\" alt=\"🇪🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://valencia.wordcamp.org/2023/\">WordCamp Valencia 2023</a>, Spain on November 10-11, 2023.</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f9.png\" alt=\"🇮🇹\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://verona.wordcamp.org/2023/\">WordCamp Verona 2023</a>, Italy on November 17-18, 2023.</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ed-1f1f0.png\" alt=\"🇭🇰\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://hongkong.wordcamp.org/2023/\">WordCamp Hong Kong 2023</a>, China on November 18, 2023.</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1f5-1f1f0.png\" alt=\"🇵🇰\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://islamabad.wordcamp.org/2023/\">WordCamp Islamabad 2023</a>, Pakistan on November 25-26, 2023.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><em>Have a story we should include in the next issue of The Month in WordPress? Fill out </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>this quick form</em></a><em> to let us know.</em></p>\n\n\n\n<p><em>Thank you to </em><a href=\"https://profiles.wordpress.org/bernard0omnisend/\"><em>Bernard Meyer</em></a><em> and <a href=\"https://profiles.wordpress.org/rmartinezduque/\">Reyes Martínez</a> for their contributions to this edition of The Month in WordPress.</em></p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<h2 class=\"wp-block-heading\">Subscribe to WordPress News</h2>\n\n\n\n<p>Join other subscribers and receive WordPress news directly in your inbox.</p>\n\n\n<div class=\"wp-block-jetpack-subscriptions__supports-newline is-style-split wp-block-jetpack-subscriptions\">\n		<div>\n			<div>\n				<div>\n					<p >\n						<a href=\"https://wordpress.org/news/?post_type=post&#038;p=16365\" style=\"text-decoration: none; font-size: 16px;padding: 15px 23px 15px 23px;margin: 0px; margin-left: 10px;border-radius: 0px;border-width: 1px; background-color: #113AF5; color: #FFFFFF;\">Subscribe</a>\n					</p>\n				</div>\n			</div>\n		</div>\n	</div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16365\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.4.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2023/11/wordpress-6-4-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Nov 2023 01:45:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16332\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 6.4.1 is now available! This minor release features&#160;four bug fixes. You can review a summary of the maintenance updates in this release by reading the&#160;Release Candidate announcement or view the list of tickets on Trac. WordPress 6.4.1 is a short-cycle release. If you have sites that support automatic background updates, the update process will [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5986:\"\n<h2 class=\"wp-block-heading\">WordPress 6.4.1 is now available!</h2>\n\n\n\n<p>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=accepted&amp;status=assigned&amp;status=closed&amp;status=new&amp;status=reopened&amp;status=reviewing&amp;id=!59852&amp;milestone=6.4.1&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">four bug fixes</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2023/11/08/wordpress-6-4-1-rc1-is-now-available/\">Release Candidate announcement</a> or <a href=\"https://core.trac.wordpress.org/query?status=accepted&amp;status=assigned&amp;status=closed&amp;status=new&amp;status=reopened&amp;status=reviewing&amp;milestone=6.4.1&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">view the list of tickets on Trac</a>.</p>\n\n\n\n<p>WordPress 6.4.1 is a short-cycle release. If you have sites that support automatic background updates, the update process will begin automatically. If your site does not update automatically, you can also update from your Dashboard.</p>\n\n\n\n<p>You can&nbsp;download <a href=\"https://wordpress.org/wordpress-6.4.1.zip\">WordPress 6.4.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-4-1/\">please&nbsp;visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> and <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>. Thank you to everyone who tested the RC and 6.4.1, and raised reports.</p>\n\n\n\n<p>WordPress 6.4.1 would not have been possible without the contributions of the following people. Their quick and concerted coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"has-text-align-left\"><a href=\"https://profiles.wordpress.org/afragen/\">@afragen</a> <a href=\"https://profiles.wordpress.org/clorith/\">@clorith</a> <a href=\"https://profiles.wordpress.org/desrosj/\">@desrosj</a> <a href=\"https://profiles.wordpress.org/pbiron/\">@pbiron</a> <a href=\"https://profiles.wordpress.org/schlessera/\">@schlessera</a> <a href=\"https://profiles.wordpress.org/azaozz/\">@azaozz</a> <a href=\"https://profiles.wordpress.org/davidbaumwald/\">@davidbaumwald</a> <a href=\"https://profiles.wordpress.org/tomsommer/\">@tomsommer</a> <a href=\"https://profiles.wordpress.org/nexflaszlo/\">@nexflaszlo</a> <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">@howdy_mcgee</a> <a href=\"https://profiles.wordpress.org/baxbridge/\">@baxbridge</a> <a href=\"https://profiles.wordpress.org/earnjam/\">@earnjam</a> <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">@timothyblynjacobs</a> <a href=\"https://profiles.wordpress.org/johnbillion/\">@johnbillion</a> <a href=\"https://profiles.wordpress.org/flixos90/\">@flixos90</a> <a href=\"https://profiles.wordpress.org/joedolson/\">@joedolson</a> <a href=\"https://profiles.wordpress.org/jeffpaul/\">@jeffpaul</a> <a href=\"https://profiles.wordpress.org/zunaid321/\">@zunaid321</a> <a href=\"https://profiles.wordpress.org/courane01/\">@courane01</a> <a href=\"https://profiles.wordpress.org/audrasjb/\">@audrasjb</a> <a href=\"https://profiles.wordpress.org/tacoverdo/\">@tacoverdo</a> <a href=\"https://profiles.wordpress.org/ironprogrammer/\">@ironprogrammer</a> <a href=\"https://profiles.wordpress.org/webcommsat/\">@webcommsat</a> <a href=\"https://profiles.wordpress.org/otto42/\">@otto42</a> <a href=\"https://profiles.wordpress.org/barry/\">@barry</a> <a href=\"https://profiles.wordpress.org/chanthaboune/\">@chanthaboune</a> <a href=\"https://profiles.wordpress.org/rajinsharwar/\">@rajinsharwar</a> <a href=\"https://profiles.wordpress.org/aaroncampbell/\">@aaroncampbell</a> <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">@peterwilsoncc</a> <a href=\"https://profiles.wordpress.org/anandau14/\">@anandau14</a> <a href=\"https://profiles.wordpress.org/iandunn/\">@iandunn</a> <a href=\"https://profiles.wordpress.org/matthewjho/\">@matthewjho</a> <a href=\"https://profiles.wordpress.org/coffee2code/\">@coffee2code</a> <a href=\"https://profiles.wordpress.org/boogah/\">@boogah</a> <a href=\"https://profiles.wordpress.org/jason_the_adams/\">@jason_the_adams</a> <a href=\"https://profiles.wordpress.org/joemcgill/\">@joemcgill</a> <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">@johnjamesjacoby</a> <a href=\"https://profiles.wordpress.org/jrf/\">@jrf</a> <a href=\"https://profiles.wordpress.org/renehermi/\">@renehermi</a> <a href=\"https://profiles.wordpress.org/dlh/\">@dlh</a> <a href=\"https://profiles.wordpress.org/mukesh27/\">@mukesh27</a> <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">@sumitbagthariya16</a> <a href=\"https://profiles.wordpress.org/starbuck/\">@starbuck</a> <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">@sergeybiryukov</a> <a href=\"https://profiles.wordpress.org/ravipatel/\">@ravipatel</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;channel. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">@jeffpaul</a>&nbsp;and <a href=\"https://profiles.wordpress.org/webcommsat/\">@webcommsat</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16332\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.4 “Shirley”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2023/11/shirley/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 19:59:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16299\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:194:\"WordPress 6.4 \"Shirley\" is here! Named in honor of the iconic jazz singer and pianist Shirley Horn, this release was made possible by over 600 contributors. Download WordPress 6.4 Shirley today.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:74791:\"\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=1024%2C683&#038;ssl=1\" alt=\"Record cover with an image of Shirley Horn, a record sliding down the right side, and the words Shirley WordPress 6.4.\" class=\"wp-image-16319\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/11/Release_featured_image2-1.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Say hello to <a href=\"https://wordpress.org/download/releases/6-4/\">WordPress 6.4</a> “Shirley,” named after the iconic jazz artist <a href=\"https://wikipedia.org/wiki/Shirley_Horn\">Shirley Horn</a>. Her distinctive voice and extraordinary connection to the piano established her as one of the leading jazz musicians of her generation. Horn’s journey from the Washington D.C. jazz scene to the international stage is a testament to her dedication and perseverance. Her influence reached far beyond the confines of traditional jazz, breaking boundaries and inspiring audiences worldwide.</p>\n\n\n\n<p>Enjoy the easy pace of <a href=\"https://www.youtube.com/channel/UCS3pUiY9OmzB6bPta3-4ArQ/playlists\">Shirley Horn’s music</a> as you take in all that 6.4 offers.</p>\n\n\n\n<p>This latest version of WordPress introduces a new, versatile default theme and a suite of upgrades to empower every step of your creative journey. Craft your content seamlessly with further writing improvements. Explore more ways to bring your vision to life and streamline site editing with enhanced tools. Whether you&#8217;re new to WordPress or an experienced creator, “Shirley” has something for you. Discover the unmatched flexibility of building with blocks and let your ideas take flight.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Many of the features and enhancements in WordPress 6.4 fall in the “small but mighty” category. Along with the adaptable beauty of the Twenty Twenty-Four theme, these updates help content creators and site developers alike save time and effort while delivering the high value, low hassle WordPress experience the world has grown to expect.</p>\n<cite>Josepha Haden Chomphosy, Executive Director of WordPress</cite></blockquote>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/\">Download WordPress 6.4 today</a></div>\n</div>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">What’s inside 6.4</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Meet Twenty Twenty-Four</h3>\n\n\n\n<p>Experience site editing at its finest with <a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four</a>. This new multi-faceted default theme has been thoughtfully crafted with three distinct use cases in mind, from writers and artists to entrepreneurs. Save time and effort with its extensive collection of <a href=\"https://2024.wordpress.net/index.php/patterns/\">over 35 templates and patterns</a>—and unlock a world of creative possibilities with a few tweaks. Twenty Twenty-Four’s remarkable flexibility ensures an ideal fit for almost any type of site. <a href=\"https://2024.wordpress.net/\">Check it out in this demo</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/tt4.png?resize=1024%2C666&#038;ssl=1\" alt=\"Cropped screenshots of the Twenty Twenty-Four theme, showing its diverse use cases for photographers, bloggers, and small businesses.\" class=\"wp-image-16274\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/tt4.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/tt4.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/tt4.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/tt4.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Let your writing flow</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/10/05/core-editor-improvement-ensuring-excellence-in-the-writing-experience/\">New enhancements</a> ensure your content creation journey is smooth. Find new keyboard shortcuts in List View, smarter list merging, and enhanced control over link settings. A cohesive toolbar experience for the Navigation, List, and Quote blocks lets you work efficiently with the tooling options you need.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/writing.png?resize=1024%2C666&#038;ssl=1\" alt=\"Screenshot of a Quote block showing its improved toolbar and the text &quot;Études has saved us thousands of hours of work and has unlock insights we never thought possible.&quot;\" class=\"wp-image-16275\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/writing.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/writing.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/writing.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/writing.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">The Command Palette just got better</h3>\n\n\n\n<p>First introduced in WordPress 6.3, the Command Palette is a powerful tool to quickly find what you need, perform tasks efficiently, and speed up your building workflow. Enjoy a <a href=\"https://make.wordpress.org/core/2023/09/12/core-editor-improvement-commanding-the-command-palette/\">refreshed design and new commands</a> to perform block-specific actions in this release.</p>\n\n\n\n<figure class=\"wp-block-image size-large is-resized\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/commands.png?resize=1024%2C666&#038;ssl=1\" alt=\"Screenshot of the refreshed UI of the Command Palette. It displays a search bar with the words &quot;Search for commands&quot; and a variety of shortcuts listed below, including &quot;Add new page,&quot; &quot;Preview in a new tab,&quot; and &quot;Patterns.&quot;\" class=\"wp-image-16276\" style=\"width:680px;height:auto\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/commands.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/commands.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/commands.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/commands.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Categorize and filter patterns</h3>\n\n\n\n<p><a href=\"https://wordpress.org/patterns/\">Patterns</a> are an excellent way to leverage the potential of blocks and simplify your site-building process. WordPress 6.4 allows you to organize them with custom categories. Plus, new advanced filtering in the Patterns section of the inserter makes finding all your patterns more intuitive.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/categorize-patterns-1.png?resize=1024%2C666&#038;ssl=1\" alt=\"Screenshot of the Site Editor\'s patterns view which shows a list of patterns with custom categories, such as &quot;About,&quot; &quot;Banners,&quot; and &quot;Call to Action,&quot; patterns.\" class=\"wp-image-16278\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/categorize-patterns-1.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/categorize-patterns-1.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/categorize-patterns-1.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/categorize-patterns-1.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Get creative with more design tools</h3>\n\n\n\n<p>Build beautiful and functional layouts with an expanded set of design tools. Play with background images in Group blocks for unique designs and maintain image dimensions consistent with placeholder aspect ratios. Do you want to add buttons to your Navigation block? Now you can do it conveniently without a line of code.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/design-tools.png?resize=1024%2C666&#038;ssl=1\" alt=\"Decorative image with text &quot;Background images in Group blocks.&quot;\" class=\"wp-image-16279\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/design-tools.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/design-tools.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/design-tools.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/design-tools.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Make your images stand out</h3>\n\n\n\n<p>Enable lightbox functionality to let your site visitors enjoy full-screen, interactive images on click. Apply it globally or to specific images to customize the viewing experience.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/lightbox.png?resize=1024%2C666&#038;ssl=1\" alt=\"Decorative photo of a triangular building structure with a &quot;click to expand&quot; icon on the right top corner.\" class=\"wp-image-16280\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/lightbox.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/lightbox.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/lightbox.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/lightbox.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Rename Group blocks</h3>\n\n\n\n<p>Set custom names for Group blocks to organize and distinguish areas of your content easily. These names will be visible in List View.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/rename.png?resize=1024%2C666&#038;ssl=1\" alt=\"Screenshot of the List View tool. It shows a Group block renamed as &quot;Hero Area&quot; with inner Group blocks also with custom names, such as &quot;Content,&quot; &quot;Images,&quot; and &quot;Call to action.&quot;\" class=\"wp-image-16281\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/rename.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/rename.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/rename.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/rename.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Preview images in List View</h3>\n\n\n\n<p>New previews for Gallery and Image blocks in List View let you visualize and locate where images on your content are at a glance.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/list-view-images.png?resize=1024%2C666&#038;ssl=1\" alt=\"Screenshot of the List View tool, showing the new image previews for the Image and Gallery blocks.\" class=\"wp-image-16282\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/list-view-images.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/list-view-images.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/list-view-images.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/list-view-images.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Share patterns across sites</h3>\n\n\n\n<p>Need to use your custom patterns on another site? Import and export them as JSON files from the Site Editor&#8217;s patterns view.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/exporting-patterns-1.png?resize=1024%2C666&#038;ssl=1\" alt=\"Screenshot showing the &quot;Import pattern from JSON files&quot; option from the Site Editor\'s patterns view.\" class=\"wp-image-16303\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/exporting-patterns-1.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/exporting-patterns-1.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/exporting-patterns-1.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/exporting-patterns-1.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Introducing Block Hooks</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/10/15/introducing-block-hooks-for-dynamic-blocks/\">Block Hooks</a> enables developers to automatically insert dynamic blocks at specific content locations, enriching the extensibility of block themes through plugins. While considered a developer tool, this feature is geared to respect your preferences and gives you complete control to add, dismiss, and customize auto-inserted blocks to your needs.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/block-hooks.png?resize=1024%2C666&#038;ssl=1\" alt=\"Cropped screenshot showing a mini shopping cart (in a red dotted circle) inserted into a navigation menu by Block Hooks.\" class=\"wp-image-16284\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/11/block-hooks.png?resize=1024%2C666&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/11/block-hooks.png?resize=300%2C195&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/11/block-hooks.png?resize=768%2C499&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/11/block-hooks.png?w=1360&amp;ssl=1 1360w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Performance wins</h3>\n\n\n\n<p>This release includes more than 100 performance-related updates for a faster and more efficient experience. Notable enhancements focus on <a href=\"https://make.wordpress.org/core/2023/10/17/improvements-to-template-loading-in-wordpress-6-4/\">template loading performance</a> for themes (including Twenty Twenty-Four), <a href=\"https://make.wordpress.org/core/2023/10/17/script-loading-changes-in-wordpress-6-4/\">usage of the script loading strategies</a> “defer” and “async” in core, blocks, and themes, and <a href=\"https://make.wordpress.org/core/2023/10/17/new-option-functions-in-6-4/\">optimization of autoloaded options</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility highlights</h3>\n\n\n\n<p>Every release is committed to making WordPress accessible to everyone. WordPress 6.4 brings several List View improvements and aria-label support for the Navigation block, among other highlights. The admin user interface includes enhancements to button placements, &#8220;Add New&#8221; menu items context, and Site Health spoken messages. <a href=\"https://make.wordpress.org/core/2023/11/03/wordpress-6-4-accessibility-improvements/\">Learn more about all the updates</a> aimed at improving accessibility.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Other notes of interest</h3>\n\n\n\n<ul>\n<li>PHP 8.1 or 8.2 are recommended for use with WordPress 6.4. Find in-depth details on PHP support <a href=\"https://wordpress.org/news/2023/10/wordpress-6-4s-php-compatibility/\">in this post</a>.</li>\n\n\n\n<li>WordPress 6.4 <a href=\"https://make.wordpress.org/core/2023/10/16/changes-to-attachment-pages/\">disables attachment pages</a> for new installations.</li>\n</ul>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.4</h2>\n\n\n\n<p>Check out the new <a href=\"https://wordpress.org/download/releases/6-4/\">WordPress 6.4 page</a> to learn more about the numerous enhancements and features of this release.</p>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> for quick how-to videos, <a href=\"https://learn.wordpress.org/social-learning/\">online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>If you are looking for detailed technical notes on new changes, the <a href=\"https://make.wordpress.org/core/2023/10/23/wordpress-6-4-field-guide/\">WordPress 6.4 Field Guide</a> is for you. Don&#8217;t forget to subscribe to the <a href=\"https://developer.wordpress.org/news/\">Developer Blog</a> to stay on top of the latest development updates, tutorials, and more.</p>\n\n\n\n<p>For more information on installation, fixes, and file changes, visit the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-4/\">6.4 release notes</a>.</p>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.4 release squad</h2>\n\n\n\n<p>​​The WordPress 6.4 release comes to you from an <strong>underrepresented gender release squad</strong> to welcome and empower diverse voices in the WordPress open source project.</p>\n\n\n\n<div style=\"height:1px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p class=\"has-extra-large-font-size\">Being part of the 6.4 release coordination team has allowed me to closely observe the intricate release process, where every detail, no matter how minor, is meticulously addressed—taking into account various factors like performance and backward compatibility. There’s still much to learn, but I feel fortunate to have had the chance to contribute to WordPress 6.4.</p>\n<cite>Akshaya Rane, 6.4 release coordinator team member</cite></blockquote>\n\n\n\n<div style=\"height:1px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Over several weeks, the 6.4 release squad kept the release on track and moving forward by leading collective work, connecting ideas, and removing roadblocks.</p>\n\n\n\n<ul>\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">Ebonie Butler</a>, <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>. Cohort: <a href=\"https://profiles.wordpress.org/thewebprincess/\">Dee Teal</a>, <a href=\"https://profiles.wordpress.org/jaimieolmstead/\">Jaimie Olmstead</a>, <a href=\"https://profiles.wordpress.org/jyolsna/\">Jyolsna J E</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Core Tech Leads: <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>. Cohort: <a href=\"https://profiles.wordpress.org/pypwalters/\">Stephanie Walters</a></li>\n\n\n\n<li>Editor Tech Leads:&nbsp; <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>, <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan Bamber</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>. Cohort: <a href=\"https://profiles.wordpress.org/68kheart/\">Devan Ferguson</a>, <a href=\"https://profiles.wordpress.org/battelfred/\">Frédérique Battel</a>, <a href=\"https://profiles.wordpress.org/jessicagoddard/\">Jessica Goddard</a>, <a href=\"https://profiles.wordpress.org/1happyplace/\">Katie Ayres</a>, <a href=\"https://profiles.wordpress.org/martatorre/\">Marta Torre</a>, <a href=\"https://profiles.wordpress.org/ngreennc/\">Nyasha Green</a>, <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a>, <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>. Cohort: <a href=\"https://profiles.wordpress.org/emilyatmobtown/\">Emily Leffler Schulman</a></li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>, <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a>, <a href=\"https://profiles.wordpress.org/611shabnam/\">Mushrit Shabnam</a>. Cohort: <a href=\"https://profiles.wordpress.org/itsjustdj/\">D.J. Billings</a>, <a href=\"https://wordpress.org/support/users/codente/\">Jamie VanRaalte</a>, <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a>, <a href=\"https://profiles.wordpress.org/baxbridge/\">Tiffany Bridge</a>, <a href=\"https://profiles.wordpress.org/planningwrite/\">Winstina Hughes</a></li>\n\n\n\n<li>Marketing and Communications Leads: <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">Reyes Martínez</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a>. Cohort: <a href=\"https://profiles.wordpress.org/meaganhanes/\">Meagan Hanes</a>, <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Test Lead: <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a>. Cohort: <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne Bovelett</a>, <a href=\"https://profiles.wordpress.org/coachbirgit/\">Birgit Olzem</a></li>\n\n\n\n<li>Design Leads: <a href=\"https://profiles.wordpress.org/elmastudio/\">Ellen Bauer</a>, <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>. Cohort: <a href=\"https://profiles.wordpress.org/allisonplus/\">Allison Tarr</a>, <a href=\"https://profiles.wordpress.org/acirujano/\">Ana Cirujano</a>, <a href=\"https://profiles.wordpress.org/cathibosco1/\">Cathi Bosco</a>, <a href=\"https://profiles.wordpress.org/nudge/\">Sonia Gaballa</a>, <a href=\"https://profiles.wordpress.org/ohia/\">Ohia</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/clarkeemily/\">Emily Clarke</a>. Cohort: <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a></li>\n\n\n\n<li>Training Leads: <a href=\"https://profiles.wordpress.org/courtneypk/\">Courtney P.K.</a>, <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Roberston</a></li>\n\n\n\n<li>Default Theme Leads: <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a></li>\n</ul>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress believes in democratizing publishing and the freedoms that come with open source. Supporting this idea is a global and diverse community of people working together to strengthen the software.</p>\n\n\n\n<p>WordPress 6.4 reflects the countless efforts and passion of <strong>more than 600 contributors in at least 56 countries</strong>. This release also welcomed over 170 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 1150 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/6adminit/\">6adminit</a> · <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aayusha/\">aayusha</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/omarabid/\">Abid Omar</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/aegkr/\">aegkr</a> · <a href=\"https://profiles.wordpress.org/ahardyjpl/\">ahardyjpl</a> · <a href=\"https://profiles.wordpress.org/ahmedgeek/\">Ahmed Hussein</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/ajakaroth/\">ajakaroth</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/akihiroharai/\">Akihiro Harai</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alishabajracharya27/\">Alisha Bajracharya</a> · <a href=\"https://profiles.wordpress.org/allisonplus/\">Allison Tarr</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amedv/\">amedv</a> · <a href=\"https://profiles.wordpress.org/acirujano/\">Ana Cirujano</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">Andr&#233;</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/eatingrules/\">Andrew Wilder</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annashopina/\">Anna</a> · <a href=\"https://profiles.wordpress.org/askdesign/\">Anne Katzeff</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/anphira/\">anphira</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/aplauche/\">Anton Plauche</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/archon810/\">archon810</a> · <a href=\"https://profiles.wordpress.org/arena/\">arena</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/armondal/\">Arnab Mondal</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/austinginder/\">Austin Ginder</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharckra/\">azharckra</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barbmiller/\">barbmiller</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart</a> · <a href=\"https://profiles.wordpress.org/basiliskan/\">Basilis Kanonidis</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/behoney/\">behoney</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bengreeley/\">Ben Greeley</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/bfintal/\">Benjamin Intal</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/bhrugesh12/\">Bhrugesh Bavishi</a> · <a href=\"https://profiles.wordpress.org/bijayyadav/\">Bijay Yadav</a> · <a href=\"https://profiles.wordpress.org/binsaifullah/\">Binsaifullah</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/dhamibirendra/\">Birendra Dhami</a> · <a href=\"https://profiles.wordpress.org/coachbirgit/\">Birgit Olzem</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">Block Themes Pro</a> · <a href=\"https://profiles.wordpress.org/bmalsht/\">bmalsht</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/bookwyrm/\">bookwyrm</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/crazyjaco/\">Bradley Jacobs</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/bvreeman22/\">Brandon Vreeman</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/brookedot/\">Brooke.</a> · <a href=\"https://profiles.wordpress.org/trynet/\">Bud Kraus</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cathibosco1/\">Cathi Bosco</a> · <a href=\"https://profiles.wordpress.org/ceer/\">ceer</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/chipbennett/\">Chip Bennett</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a> · <a href=\"https://profiles.wordpress.org/crunnells/\">Chris Runnells</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdesrochers/\">chrisdesrochers</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courtneypk/\">Courtney Patubo Kranzke</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/littlebigthing/\">Csaba (LittleBigThings)</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/extendwings/\">Daisuke Takahashi</a> · <a href=\"https://profiles.wordpress.org/dajeema/\">Dajeema Rai</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/damonsharp/\">Damon Sharp</a> · <a href=\"https://profiles.wordpress.org/dantovbein/\">Dan Tovbein</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/queerdevperson/\">Danielle Zarcaro</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dkotter/\">Darin Kotter</a> · <a href=\"https://profiles.wordpress.org/darkfate/\">darkfate</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/dave03/\">dave03</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/desmith/\">David E. Smith</a> · <a href=\"https://profiles.wordpress.org/dfavor/\">David Favor</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/dryanpress/\">David Ryan</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dawidurbanski/\">Dawid Urbanski</a> · <a href=\"https://profiles.wordpress.org/daxelrod/\">daxelrod</a> · <a href=\"https://profiles.wordpress.org/arnedb/\">De Belser Arne</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/thewebprincess/\">Dee Teal</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/emrikol/\">Derrick Tennant</a> · <a href=\"https://profiles.wordpress.org/68kheart/\">Devan Ferguson</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dianeco/\">Diane Co</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dimitrism/\">Dimitris Mitsis</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/itsjustdj/\">DJ</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/doughamlin/\">doughamlin</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/metalandcoffee/\">Ebonie Butler</a> · <a href=\"https://profiles.wordpress.org/ediamin/\">Edi Amin</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham S.</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/elmastudio/\">Ellen Bauer</a> · <a href=\"https://profiles.wordpress.org/emailjoey/\">emailjoey</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/clarkeemily/\">Emily Clarke</a> · <a href=\"https://profiles.wordpress.org/emilyatmobtown/\">Emily Leffler Schulman</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/enodekciw/\">enodekciw</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/esratpopy/\">Esrat Sultana Popy</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian K&#228;gy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/floydwilde/\">floydwilde</a> · <a href=\"https://profiles.wordpress.org/foliovision/\">FolioVision</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/battelfred/\">Fredde Battel</a> · <a href=\"https://profiles.wordpress.org/fzhantw/\">fzhantw</a> · <a href=\"https://profiles.wordpress.org/mintindeed/\">Gabriel Koen</a> · <a href=\"https://profiles.wordpress.org/pauthake015/\">Ganesh Dahal</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyc40/\">Gary Cao</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/mokagio/\">Gio Lodi</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/gnanasekaran/\">Gnanasekaran Loganathan</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/90lines/\">GOZER</a> · <a href=\"https://profiles.wordpress.org/gpotter/\">gpotter</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gregross/\">Greg Ross</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregfuller/\">gregfuller</a> · <a href=\"https://profiles.wordpress.org/guss77/\">Guss77</a> · <a href=\"https://profiles.wordpress.org/bordoni/\">Gustavo Bordoni</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/priethor/\">H&#233;ctor Prieto</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hlunter/\">hlunter</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/incursadesigns/\">Incursa Designs</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jaimieolmstead/\">jaimieolmstead</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/jakemgold/\">Jake Goldman</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/bonkerz/\">James Hunt</a> · <a href=\"https://profiles.wordpress.org/thelovelist/\">James Janco</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/james0r/\">james0r</a> · <a href=\"https://profiles.wordpress.org/jamiemchale/\">Jamie McHale</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie VanRaalte</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/yari2u/\">Jari Vuorenmaa</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/jastos/\">jastos</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jeffeverhart383/\">Jeff Everhart</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffikus/\">jeffikus</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jesin/\">Jesin A</a> · <a href=\"https://profiles.wordpress.org/jessplease/\">Jessica Duarte</a> · <a href=\"https://profiles.wordpress.org/jessicagoddard/\">Jessica Goddard</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jick/\">Jick</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/bitmachina/\">John Hooks</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/varjodesigns/\">Joona</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordanpak/\">JordanPak</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/dunhakdis/\">Joseph G.</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/jyolsna/\">Jyolsna J E</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kalmang/\">Kalmang</a> · <a href=\"https://profiles.wordpress.org/kalpeshh/\">Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/1happyplace/\">Katie Ayres</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kevinfodness/\">Kevin Fodness</a> · <a href=\"https://profiles.wordpress.org/p51labs/\">Kevin Miller</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/khleomix/\">khleomix</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kimannwall/\">Kim Coleman</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/olein/\">Koji Kuno</a> · <a href=\"https://profiles.wordpress.org/kovshenin/\">Konstantin Kovshenin</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/kopila47/\">Kopila Shrestha</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/labunchemjong/\">Labun Chemjong</a> · <a href=\"https://profiles.wordpress.org/lancewillett/\">Lance Willett</a> · <a href=\"https://profiles.wordpress.org/lhe2012/\">LarryWEB</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/launchinteractive/\">launchinteractive</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/luckybhumkar/\">Laxmikant Bhumkar</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/lloydbudd/\">Lloyd Budd</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/lunaluna/\">lunaluna</a> · <a href=\"https://profiles.wordpress.org/lyndauwp/\">lyndauwp</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">M&#225;rcio Duarte</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madejackson/\">madejackson</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/maltfield/\">maltfield</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/marcelle42/\">marcelle42</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/martatorre/\">Marta Torre</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/masoudnkh/\">Masoud NKH</a> · <a href=\"https://profiles.wordpress.org/mathsgrinds/\">mathsgrinds</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a> · <a href=\"https://profiles.wordpress.org/mwtsn/\">Matt Watson</a> · <a href=\"https://profiles.wordpress.org/mklute101/\">Matthaus Klute</a> · <a href=\"https://profiles.wordpress.org/mattheweppelsheimer/\">Matthew Eppelsheimer</a> · <a href=\"https://profiles.wordpress.org/matthewfarlymn/\">Matthew Farlymn</a> · <a href=\"https://profiles.wordpress.org/mattheu/\">Matthew Haines-Young</a> · <a href=\"https://profiles.wordpress.org/matthewjho/\">matthewjho</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/maxinacube/\">Maxwell Morgan</a> · <a href=\"https://profiles.wordpress.org/maysi/\">maysi</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/meaganhanes/\">meagan hanes</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/mer00x/\">mer00x</a> · <a href=\"https://profiles.wordpress.org/merel1988/\">merel1988</a> · <a href=\"https://profiles.wordpress.org/michael-arestad/\">Michael Arestad</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/michelleblanchette/\">Michelle Blanchette</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/michi91/\">Michi91</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikestraw/\">Mike Straw</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski - Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mitchellaustin/\">mitchellaustin</a> · <a href=\"https://profiles.wordpress.org/mhshujon/\">Monir</a> · <a href=\"https://profiles.wordpress.org/mrinal013/\">Mrinal Haque</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/wparslan/\">Muhammad Arslan</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/611shabnam/\">Mushrit Shabnam</a> · <a href=\"https://profiles.wordpress.org/webdev8800/\">Myles Taylor</a> · <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a> · <a href=\"https://profiles.wordpress.org/nandhuraj/\">nandhuraj</a> · <a href=\"https://profiles.wordpress.org/nazgul/\">Nazgul</a> · <a href=\"https://profiles.wordpress.org/nazsabuz/\">Nazmul Sabuz</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/rahe/\">Nicolas Juen</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nicomollet/\">nicomollet</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">niravsherasiya7707</a> · <a href=\"https://profiles.wordpress.org/dasnitesh780/\">Nitesh Das</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/ngreennc/\">Nyasha</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/ohia/\">Ohia</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/pentatonicfunk/\">pentatonicfunk</a> · <a href=\"https://profiles.wordpress.org/gungeekatx/\">Pete Nelson</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/petrosparaskevopoulos/\">petrosparaskevopoulos</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walb&#248; Johnsg&#229;rd</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/piyushdeshmukh/\">piyushdeshmukh</a> · <a href=\"https://profiles.wordpress.org/plugindevs/\">Plugin Devs</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pranavjoshi/\">pranavjoshi</a> · <a href=\"https://profiles.wordpress.org/prashantbhivsane/\">Prashant</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/rlmc/\">r-c</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rebekowitz/\">Rebekah Markowitz</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renyot/\">ren</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/rmartinezduque/\">Reyes Martínez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rianrietveld/\">Rian Rietveld</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O\'Rourke</a> · <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a> · <a href=\"https://profiles.wordpress.org/robpetrin/\">robpetrin</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/ryanduff/\">Ryan Duff</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/ohryan/\">Ryan Neudorf</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/karmacharya50/\">Samir Karmacharya</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahwilliams889/\">Sarah Williams</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/saulirajala/\">saulirajala</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">saxonfletcher</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/hiyascout/\">Scout James</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/seedsca/\">Sergio Scabuzzo</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shawfactor/\">shawfactor</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shiloey/\">shilo-ey</a> · <a href=\"https://profiles.wordpress.org/shivashankerbhatta/\">Shiva Shanker Bhatta</a> · <a href=\"https://profiles.wordpress.org/shresthaaman/\">shresthaaman</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/10upsimon/\">Simon Dowdles</a> · <a href=\"https://profiles.wordpress.org/siobhan/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan Bamber</a> · <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a> · <a href=\"https://profiles.wordpress.org/sofiashendi/\">sofiashendi</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Sonia Gaballa</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">Stephanie Walters</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenerdelyi/\">Steve Erdelyi</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/subodhsun/\">Subodh Sunuwar</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sujichandran14/\">Suji K Chandran</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunitarai/\">Sunita Rai</a> · <a href=\"https://profiles.wordpress.org/suprsam/\">suprsam</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a> · <a href=\"https://profiles.wordpress.org/tahmina1du/\">Tahmina Jahan</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tejadev/\">tejadev</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a> · <a href=\"https://profiles.wordpress.org/tibbsa/\">tibbsa</a> · <a href=\"https://profiles.wordpress.org/baxbridge/\">Tiffany Bridge</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timdix/\">timdix</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomashorta/\">Tom H</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Tran Ngoc Tuan Anh</a> · <a href=\"https://profiles.wordpress.org/trinisha/\">Trinisha</a> · <a href=\"https://profiles.wordpress.org/trishasalas/\">Trisha Salas</a> · <a href=\"https://profiles.wordpress.org/tristanleboss/\">tristanleboss</a> · <a href=\"https://profiles.wordpress.org/tv-productions/\">TV productions</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a> · <a href=\"https://profiles.wordpress.org/benimub/\">Umesh Balayar</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">Upadala Vipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/valentindu62/\">valentindu62</a> · <a href=\"https://profiles.wordpress.org/valmedia2023/\">Valerie Blackburn</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/webashrafians/\">webashrafians</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a> · <a href=\"https://profiles.wordpress.org/wvega/\">Willington Vega</a> · <a href=\"https://profiles.wordpress.org/planningwrite/\">Winstina</a> · <a href=\"https://profiles.wordpress.org/winterstreet/\">winterstreet</a> · <a href=\"https://profiles.wordpress.org/wraithkenny/\">WraithKenny</a> · <a href=\"https://profiles.wordpress.org/wyrfel/\">wyrfel</a> · <a href=\"https://profiles.wordpress.org/yosephtamang/\">Yoseph Tamang</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/letraceursnork/\">Илья</a></p>\n\n\n\n<p>Over <a href=\"https://translate.wordpress.org/stats/\">60 locales have translated 90 percent</a> or more of WordPress 6.4 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved</h3>\n\n\n\n<p>Participation in WordPress is not limited to coding. If contributing appeals to you, learning more and getting involved is easy. Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a>, and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Looking ahead</h2>\n\n\n\n<p>Over the past <a href=\"https://wp20.wordpress.net/\">two decades</a>, WordPress has transformed the digital publishing landscape and empowered anyone to create and share, from <a href=\"https://wordpress.org/showcase/\">handcrafted personal stories to world-changing movements</a>.</p>\n\n\n\n<p>The present and future of WordPress hold exciting opportunities for everyone, builders and enterprises alike. The foundational work for <a href=\"https://make.wordpress.org/core/tag/phase-3/\">Phase 3</a> of the <a href=\"https://wordpress.org/about/roadmap/\">roadmap</a> continues, with efforts focused on fostering real-time collaboration and streamlining publishing flows to improve how creators and teams work together in WordPress.</p>\n\n\n\n<p>Stay on top of the latest news and contributing opportunities by subscribing to <a href=\"https://wordpress.org/news/\">WordPress News</a> and the <a href=\"https://wordpress.org/news/podcast/\">WP Briefing podcast</a>.</p>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A release haiku</h2>\n\n\n\n<p>The smooth feel of jazz<br>The cutting-edge of the web<br>Install 6.4</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16299\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.4 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/11/wordpress-6-4-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Nov 2023 19:21:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16247\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"WordPress 6.4 RC3 is ready for download and testing. Reaching this phase of the release cycle is an important milestone. Check out what\'s new and how you can help.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8230:\"\n<p>The third release candidate (RC3) for WordPress 6.4 is ready to download!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>WordPress 6.4 is <a href=\"https://make.wordpress.org/core/6-4/\">slated for release</a> on <strong>November 7, 2023</strong>—less than a week away. If you haven’t tried it, now is the time.</p>\n\n\n\n<p>You can test WordPress 6.4 RC3 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-RC3.zip\">RC3 version (zip)</a> and install it on a WordPress site.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-RC3</code></li>\n</ol>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-release-candidate-1/\">Read the RC1 announcement</a> for featured highlights, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a>. If you are looking for detailed technical notes on new features and improvements, the <a href=\"https://make.wordpress.org/core/2023/10/23/wordpress-6-4-field-guide/\"><strong>WordPress 6.4 Field Guide</strong></a> is for you.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">underrepresented gender release squad</a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<div style=\"height:5px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.4 RC3?</h2>\n\n\n\n<p>Thanks to everyone who has tested the beta and RC releases. Since RC2 was released on October 24, there have been more than 25 issues resolved. You can browse the technical details for all recent updates using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F25%2F2023..11%2F01%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets since RC2</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<div style=\"height:5px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">PHP compatibility update</h2>\n\n\n\n<p>It’s recommended to use PHP 8.1 or 8.2 with the upcoming 6.4 release. Refer to <a href=\"https://wordpress.org/news/2023/10/wordpress-6-4s-php-compatibility/\">WordPress 6.4&#8217;s PHP compatibility post</a> for more details.</p>\n\n\n\n<div style=\"height:5px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Contributing to 6.4</h2>\n\n\n\n<p>WordPress is open source software made possible by a community of people collaborating on and contributing to its development. The resources below outline various ways you can help, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Your feedback and help in testing are vital to developing the WordPress software and ensuring its quality. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Check out this guide</a> for instructions on testing WordPress 6.4 features.</p>\n\n\n\n<p>The core Query block requires more <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/#query-loop-block-pagination-enhancements\">testing and feedback</a> to ensure the latest changes to prevent full page reloads work smoothly. Please note that this setting was called &#8220;Enhanced pagination&#8221; but has recently been renamed, and it&#8217;s now referred to as &#8220;Force page reload&#8221; instead.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>During the release candidate phase of WordPress 6.4, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>Do you build themes and plugins? Your products play an integral role in extending the functionality and value of WordPress for users worldwide.</p>\n\n\n\n<p>Hopefully, you have already tested your themes and plugins with WordPress 6.4 betas. With RC3, you will want to continue your testing and update the <em>&#8220;Tested up to&#8221;</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin&#8217;s readme file</a> to 6.4.</p>\n\n\n\n<p>Please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a> if you find compatibility issues.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Documentation</h3>\n\n\n\n<p>Help the Docs team put the finishing touches on end-user documentation in time for the 6.4 release. Find out what’s needed and how you can help <a href=\"https://make.wordpress.org/docs/2023/10/25/call-for-volunteers-to-help-with-6-4-end-user-documentation/\">in this post</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Português? Русский? 日本? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<div style=\"height:5px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A RC3 haiku</h2>\n\n\n\n<p>One more week of prep<br>One more week to test the code<br>One more week til launch</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a>, <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a>, <a href=\'https://profiles.wordpress.org/luisherranz/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>luisherranz</a>, <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16247\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WP Briefing: Episode 65: Little Sun Success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2023/10/episode-65-little-sun-success/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Oct 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16227\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"Join WordPress Executive Director, Josepha Haden Chomphosy, as she looks at a recent WordPress success story with Little Sun. To help us, we spoke to two special guests with Little Sun, Romane Guégan, Senior Press and Communications Manager, and Ashley Mrozek, Senior Digital Manager. Don’t miss this opportunity for an insider’s look!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:51:\"https://wordpress.org/news/files/2023/10/WPB065.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:21512:\"\n<p>Join WordPress Executive Director Josepha Haden Chomphosy as she looks at a recent WordPress success story, the clean energy solution Little Sun, and learns about their WordPress story.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Special Guest: Romane Guégan<br>Special Guest: Ashley Mrozek <br>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li>Website: <a href=\"https://littlesun.org/\">Little Sun</a></li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/10/state-of-the-word-2023/\" target=\"_blank\" rel=\"noreferrer noopener\">State of the Word</a> &#8211; This year&#8217;s annual keynote, State of the Word, will be on December 11. Save the date to hear the WordPress project&#8217;s co-founder, <a href=\"https://ma.tt/\" target=\"_blank\" rel=\"noreferrer noopener\">Matt Mullenweg</a>, share reflections on the project&#8217;s progress and aspirations for the future of open source.</li>\n\n\n\n<li>Celebrating 10,000 Photos in the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a> &#8211; On October 11, the 10,000th photo was approved! <a href=\"https://make.wordpress.org/photos/\" target=\"_blank\" rel=\"noreferrer noopener\">The Photo Team</a> is one of the newest ways to contribute to the WordPress open source project. </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/10/18/community-team-training-11-using-the-translate-live-tool/\" target=\"_blank\" rel=\"noreferrer noopener\">Community Team Training #11: Using the Translate Live tool</a>&nbsp;&#8211; Uncover the potential of the &#8220;Translate Live&#8221; tool, which is ideal for presenting at local meetups to engage and onboard new translators for your native language. If you&#8217;re organizing a WordCamp, consider introducing this tool during your Contributor Day.</li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/10/a-new-wordpress-showcase/\" target=\"_blank\" rel=\"noreferrer noopener\">A New WordPress Showcase</a>&nbsp;&#8211; The&nbsp;journey to update&nbsp;<a href=\"https://wordpress.org/\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress.org</a>&nbsp;continues with the launch of a new&nbsp;<a href=\"https://wordpress.org/showcase/\" target=\"_blank\" rel=\"noreferrer noopener\">Showcase</a>&nbsp;design. The Showcase is a natural starting point for visitors arriving on&nbsp;WordPress.org, and it both inspires creativity and demonstrates what&#8217;s possible with WordPress.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-16227\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone, and welcome to the WordPress Briefing. The podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[00:00:28] (Intro music)&nbsp;</p>\n\n\n\n<p>[00:00:40] <strong>Josepha:</strong> Today, I&#8217;ve got a special guest with me. I have here a couple of folks from Little Sun, a nonprofit organization that recently moved its entire online presence to WordPress. And we&#8217;re talking everything from their mission statement and donations all the way to their blog and shop.</p>\n\n\n\n<p>Welcome both to the WordPress Briefing.&nbsp;</p>\n\n\n\n<p>[00:00:59] <strong>Ashley:</strong> Thank you.</p>\n\n\n\n<p>[00:01:00] <strong>Romane:</strong> Thank you.&nbsp;</p>\n\n\n\n<p>[00:01:01] <strong>Josepha:</strong> We have with us Little Sun today. Can you start by introducing yourselves and your organization? Just tell us a little bit about what you all do.&nbsp;</p>\n\n\n\n<p>[00:01:08] <strong>Romane:</strong> Hi, my name is Romane Guégan. I&#8217;m a Senior Press and Communications Manager at Little Sun.&nbsp;</p>\n\n\n\n<p>[00:01:14] <strong>Ashley:</strong> And I am Ashley Mrozek. I&#8217;m the Senior Digital Manager.&nbsp;</p>\n\n\n\n<p>[00:01:17] <strong>Josepha:</strong> So what does Little Sun do for the folks who are listening and maybe don&#8217;t know about it yet?&nbsp;</p>\n\n\n\n<p>[00:01:22] <strong>Romane:</strong> Little Sun brings full power and light to communities that live off the grid, with the focus on sub-Saharan Africa because most of the people who lack access to electricity and need them. And we also inspire people to take climate action globally.&nbsp;</p>\n\n\n\n<p>[00:01:39] <strong>Ashley:</strong> So access to solar energy helps kids who don&#8217;t have electricity and study at night. They can complete their homework at night. If their schools are in a more rural area, they will have a light to kind of guide them back home.</p>\n\n\n\n<p>We also work on a lot of electric vocation projects and hospitals. So we&#8217;re, we&#8217;re kind of supporting labors that are, are taking place in the evening, after the sun goes down, among other things.&nbsp;</p>\n\n\n\n<p>[00:02:07] <strong>Josepha:</strong> Yeah. It&#8217;s, I, I think that that is one of the things that folks, probably most of my listeners, probably take for granted, like the easy access to light. And as we all know, the sun is around a lot. And so that is one of our most readily available resources other than potentially wind power. But I think that that is a great mission. And I really think that that&#8217;s wonderful work that y&#8217;all are doing.</p>\n\n\n\n<p>So, is there a particular reason that you focus on sub-Saharan Africa? Is that where you find a majority of people who don&#8217;t have access to that kind of resource are?&nbsp;</p>\n\n\n\n<p>[00:02:43] <strong>Romane:</strong> Yeah. 70% of those people actually need in sub-Saharan Africa, where solar is actually a viable source of energy. Actually, it&#8217;s only 1% of solar, of the solar capital of the generation when we actually deliver solar energy there because there is so much potential.</p>\n\n\n\n<p>[00:03:04] <strong>Josepha:</strong> That&#8217;s amazing. So you said that you all were funded in 2012. I imagine that your business has evolved over time. So, obviously, you all are WordPress users. That&#8217;s why we have you here with us today. But before we get into the questions about WordPress itself. Why don&#8217;t you tell us a bit about how your business needs evolved over time and how you wound up needing a solution that did use WordPress?</p>\n\n\n\n<p>[00:03:31] <strong>Ashley:</strong> So I would say our focus and kind of the different initiatives that we&#8217;ve taken on since 2012 have shifted a lot based on various reasons, where our donors are, where we&#8217;ve kind of found the most need, and where we can be the most impactful.</p>\n\n\n\n<p>And I think as we go into those new geographies, our online presence has become more and more important.&nbsp;</p>\n\n\n\n<p>[00:03:55] <strong>Josepha:</strong> So, before you all switched to WordPress, I understand that you had several sites that you had to merge into one. And so I assume that as you evolved the business and your focus has changed, you realized you needed something a bit more streamlined. So, how was that transition, that migration from a lot of different sites to one big site?&nbsp;</p>\n\n\n\n<p>[00:04:17] <strong>Romane:</strong> Yeah, because we started as a global project. And then, with the time, we evolved, actually also getting new donations. And in the past, we used to have one website where we have our webshop and our mission, our vision, all of our project descriptions.</p>\n\n\n\n<p>But then we had another website only for the foundation. And then you had another foundation in the U.S. So it was the question, okay, how do we put everything together? So we actually switched from littlesun.com to littlesun.org with WordPress, and it was amazing to see how we managed with the team to create an ecosystem approach, including impact, but also sales, and fundraising.&nbsp;</p>\n\n\n\n<p>[00:05:02] <strong>Josepha:</strong> That was a big footprint that you all had, and you kind of consolidated it into one. And for all of our folks listening on the podcast, I&#8217;m going to include some links, not only to their site but then also to a few other things that we&#8217;ve mentioned in here today. So, since you made that change, how has it, how has that impacted the way that you all work with your site or with your online presence?</p>\n\n\n\n<p>[00:05:27] <strong>Ashley:</strong> Yeah, I think using WordPress and having access to WordPress has been hugely valuable for us. We&#8217;re a small team, we&#8217;re a nonprofit, so it is pretty scrappy. Everyone is kind of doing a lot of different things. We don&#8217;t have a dedicated development team. And so being able to easily customize our pages and create new landing pages or make adjustments on the site without that development help has been valuable.</p>\n\n\n\n<p>[00:05:55] <strong>Josepha:</strong> Yeah, so you don&#8217;t have a developer team now. Did you have a developer team when you had all the sites?&nbsp;</p>\n\n\n\n<p>[00:06:01] <strong>Romane:</strong> We just still work with freelancers. </p>\n\n\n\n<p>[00:06:03] <strong>Josepha:</strong> Okay, yeah. I am also not a developer, for what it&#8217;s worth, and have been working with nonprofits for a while. And I understand that problem where you have all these things you need to do and want to do, but there are also things you absolutely have to focus on in order to make your mission possible and your vision come true.</p>\n\n\n\n<p>[00:06:23] <strong>Ashley:</strong> Yeah, and I think, I think WordPress has given us a lot more, like a lot more flexibility to kind of produce new content quickly. And because of that, it&#8217;s just been a lot more efficient, too, for us, you know.&nbsp;</p>\n\n\n\n<p>[00:06:38] <strong>Josepha:</strong> And you all are using Blocks? Are you, like, the best Block builders?</p>\n\n\n\n<p>[00:06:42] <strong>Romane:</strong> Yeah, I love Blocks.&nbsp;</p>\n\n\n\n<p>[00:06:43] <strong>Josepha:</strong> Blocks are a fairly new innovation for the history of WordPress. WordPress has been around for 20 years, so we&#8217;re a nice, mature project. And we&#8217;ve really only had blocks as a functional part of the CMS for probably the last five or so. We&#8217;ve been working on the project a little bit longer. And it has been fascinating to me, like, in my own work that I have done with WordPress, kind of outside of my work with the project, to see, like, how much autonomy you get to have back as somebody who is not a developer, maybe isn&#8217;t a designer, but you do know exactly what you need to have on your site today, right?</p>\n\n\n\n<p>And having to stop and find a freelancer or stop and find some set of developers who can make those changes. For me, when I was specifically working on nonprofit stuff. That was always kind of a moment where I was like, well, I guess I&#8217;ll just go to Facebook and put that on there or something because I was faster than trying to find someone to come help you. And so, I&#8217;m so glad you love the block.</p>\n\n\n\n<p>[00:07:48] <strong>Ashley:</strong> We&#8217;ve created many a landing page.&nbsp;</p>\n\n\n\n<p>[00:07:50] <strong>Josepha:</strong> Also, your site is adorable, and your brand is adorable, in case no one&#8217;s mentioned that lately. Super cute. Super cute.</p>\n\n\n\n<p>[00:07:58] <strong>Josepha:</strong> So, we&#8217;ve talked about how you kind of took a bunch of stuff and made it into one big thing and how that&#8217;s been easier for you all to manage it. But from the standpoint of just, like, somebody who&#8217;s running a nonprofit, someone who&#8217;s running an organization, how has that transition been for your team? I know you said you don&#8217;t have a huge team, but was the move toward WordPress a net benefit over time, or was it immediately beneficial? Like, how has that been for your team? </p>\n\n\n\n<p>[00:08:27] <strong>Romane:</strong> So what&#8217;s interesting actually is that we have a team that is spread also all over the world. And so we have teams in Berlin and in U.S., and New York. In Zambia, too. What was really interesting was how people identify to the new website because now we have to really think, okay, what is the content we want people to see, but also we want our critics to see. And so it kind of unified all of our content at Little Sun. And it was much more like much easier to understand afterwards. </p>\n\n\n\n<p>[00:09:03] <strong>Josepha:</strong> Yeah.&nbsp;</p>\n\n\n\n<p>[00:09:04] <strong>Romane:</strong> And it was because we also work at the intersection of creative communications, impacts, fundraising, technology, and to be able to put everything and have it on the front. And then have the stories to tell the stories from sub-Saharan Africa, from universities who got either a Little Sun lamps or solar systems, and then we have the donation page, so basically everything could be integrated in a super easy way, and it could target different audiences easily, either it&#8217;s someone who wants to partner with us, or a donor, or just someone who wants to be part of our solar training.</p>\n\n\n\n<p>[00:09:46] <strong>Josepha:</strong> Yeah, and I mean, I think that no one will be surprised to hear that if you have multiple things that you have to get everybody to, it really increases the amount of marketing that you have to accomplish, rather than having one place for everyone to go too, and they can see everything that they might want once they arrive. So, that&#8217;s wonderful.</p>\n\n\n\n<p>[00:10:06] <strong>Ashley:</strong> I think I was just going to say, or kind of echo what Romane said about the fact that we have so many different audiences, we have partners, we have donors, we have people who are just coming to learn about solar energy, or who are interested in purchasing a lamp. I think prior to this, it was a little bit confusing for those different audiences to kind of navigate to where they were intended to go to on the site, and now it&#8217;s much more cohesive. And we often hear that from people where it&#8217;s like, it&#8217;s quite easy to, to kind to find what they need to find on the site.&nbsp;</p>\n\n\n\n<p>[00:10:39] <strong>Josepha:</strong> I define the WordPress community as anyone who is using WordPress, regardless of whether they know it or not. And so you all, in my mind, are part of the WordPress Community. And I just wondered if being part of that community has changed your approach to the way that you manage your content online or the way that you have chosen work with your business as like an online entity that also does on-the-ground, in-person thing?</p>\n\n\n\n<p>[00:11:06] <strong>Ashley:</strong> I think definitely. I think we&#8217;re kind of going back to what I said before. I think we&#8217;re much more efficient now. I think in the past, it&#8217;s the idea of, like, well, getting this web page live or publishing this is going to be, you know, we have to think about a huge timeline, that&#8217;s, is going to require a lot of resourcing, a lot of different types of expertise and people, and everything now feels like something that we can, we can launch pretty immediately, which is really wonderful too.</p>\n\n\n\n<p>I would also say just like being a part of the WordPress community too. It&#8217;s the sort of support that we&#8217;ve gotten from your team. It&#8217;s always really tailored. And I think as a nonprofit working with a, like, a much bigger business, you can be apprehensive sometimes, feeling like you won&#8217;t really get that personalized support.&nbsp;</p>\n\n\n\n<p>And I think that&#8217;s something that&#8217;s been so nice with WordPress. Is really feeling like the people we&#8217;re working with are understanding our business and taking the time to understand our needs. And I think that makes us think differently about our online presence as well because then we feel like we have that additional support, which is great.</p>\n\n\n\n<p>[00:12:12] <strong>Josepha:</strong> I&#8217;m always a fan of hearing that people who are passionate about WordPress are also passionate about helping others with WordPress. That&#8217;s one of my favorite things about us. That&#8217;s not true. I have like 25 favorite things about us. And so I need to stop saying that I have one favorite, but I never will.</p>\n\n\n\n<p>Okay, well, do you all have any last thoughts that you just want to share with me or podcast listeners that we have?&nbsp;</p>\n\n\n\n<p>[00:12:36] <strong>Ashley:</strong> Yeah, I think the, the plugins and integrations have been really useful for us. I think it can be really intimidating to bring on, like, a new tech solution or tool and feel like everything that you are already working with or have is going to become outdated or obsolete in some way. And I think it&#8217;s just been really nice to work with WordPress and have all of those transitions be really seamless for everything to connect really well. Yeah, I think that&#8217;s been. That&#8217;s hugely helpful too.&nbsp;</p>\n\n\n\n<p>[00:13:07] <strong>Josepha:</strong> So, was that part of the decision-making process? Like, do I know that this software will be around in the future so that you&#8217;re making an investment in the site now and know that it&#8217;s going to hang around now you can find people help? Like, was that part of the decision-making process?</p>\n\n\n\n<p>[00:13:21] <strong>Ashley:</strong> I think so. I mean, I guess I wasn&#8217;t completely around during the time, but I would say, like, that&#8217;s definitely something that we&#8217;re considering in any kind of tech that we&#8217;re thinking about is it can require so much work to, to kind of bring something on with such a small team. So we want to ensure that, yeah, it&#8217;s going to last, it has longevity, and it&#8217;s going to work with the tools that we already have. So I think all of that is really important for sure.&nbsp;</p>\n\n\n\n<p>[00:13:48] <strong>Josepha:</strong> Well, thank you both so much for joining me. Like I said, we&#8217;ll have a link to littlesun.org in the notes so that you all can learn more about their project and see their beautiful site with their beautiful little solar sunflowers.</p>\n\n\n\n<p>Thank you both for being with me today.&nbsp;</p>\n\n\n\n<p>[00:14:04] <strong>Romane:</strong> Thank you so much.&nbsp;</p>\n\n\n\n<p>[00:14:05] <strong>Ashley:</strong> Thank you so much for having us.</p>\n\n\n\n<p>[00:14:07] (Music interlude)</p>\n\n\n\n<p>[00:14:11] <strong>Josepha:</strong> What a wonderful organization. I&#8217;m so glad that they found WordPress and that it works for them. Let&#8217;s continue our tour today with the small list of big things.</p>\n\n\n\n<p>Item number one, it&#8217;s time to save the date: December 11th, 2023, for this year&#8217;s State of the Word. State of the Word is the annual keynote address delivered by the WordPress Project co-founder Matt Mullenweg. Every year, the event shares reflections on the project&#8217;s progress and aspirations for the future of open source. And so, if that is something that you like to tune into, December 11th is your day.&nbsp;</p>\n\n\n\n<p>Second thing on our list is that we are celebrating our 10,000th photo submission. So, on October 11th, the 10,000th photo was approved. The Photo Team is one of the newest ways to contribute to the WordPress open source project, and it feeds all of those photos into Openverse as well.</p>\n\n\n\n<p>The third thing on our list today is that I want to tell you about a community team training module that just came out. It&#8217;s specifically about the Translate Live tool, and it is ideal for presenting at your local meetups to engage and onboard new translators for your native language. If you&#8217;re organizing a WordCamp, consider introducing this tool during your Contributor Day. I will leave a link for this in the show notes so that it is easy to find.&nbsp;</p>\n\n\n\n<p>And item number four, the journey to update WordPress.org, continues with the launch of a new Showcase design. The Showcase is a natural starting point for a lot of visitors who are on WordPress.org. It inspires creativity and also demonstrates what&#8217;s possible with WordPress. So, stop on by there, it&#8217;s WordPress.org/showcase, and give it a bit of a look.</p>\n\n\n\n<p>[00:15:58] <strong>Josepha:</strong> And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. And don&#8217;t forget to follow us on your favorite podcast app or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever a new episode drops. And if you like what you heard today, share it with a fellow WordPresser. Or, if you had questions about what you heard today, you can share those with me at wprebriefing@WordPress.org. </p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks. </p>\n\n\n\n<p>[00:16:24] (Music outro)</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16227\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.4’s PHP Compatibility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2023/10/wordpress-6-4s-php-compatibility/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Oct 2023 08:40:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"PHP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16235\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"In an effort to keep the WordPress community up to date, this post provides an update on the PHP compatibility of the upcoming WordPress 6.4 release scheduled for November 7, 2023.&#160; Recommended PHP version for WordPress 6.4 It’s recommended to use PHP 8.1 or 8.2 with this upcoming release. Please refer to the Hosting page [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3117:\"\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"2400\" height=\"1350\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/WordPress-6.4s-PHP-comp.png?resize=2400%2C1350&#038;ssl=1\" alt=\"\" class=\"wp-image-16236\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/10/WordPress-6.4s-PHP-comp.png?w=2400&amp;ssl=1 2400w, https://i0.wp.com/wordpress.org/news/files/2023/10/WordPress-6.4s-PHP-comp.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/10/WordPress-6.4s-PHP-comp.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/10/WordPress-6.4s-PHP-comp.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/10/WordPress-6.4s-PHP-comp.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/10/WordPress-6.4s-PHP-comp.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>In an effort to keep the WordPress community up to date, this post provides an update on the PHP compatibility of the upcoming WordPress 6.4 release scheduled for November 7, 2023.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Recommended PHP version for WordPress 6.4</strong></h3>\n\n\n\n<p>It’s recommended to use PHP 8.1 or 8.2 with this upcoming release. Please refer to the Hosting page for more detailed information, including <a href=\"https://make.wordpress.org/core/handbook/references/php-compatibility-and-wordpress-versions/\">a few known issues</a>.&nbsp;</p>\n\n\n\n<p>Reach out to your hosting company to explore PHP upgrade options.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Why does compatibility matter?</strong></h3>\n\n\n\n<p>PHP is a programming language on which the WordPress code is based. This language runs on the server, and it is critical to keep it updated for security and functionality. Various teams within the WordPress open source project work to both test and fix any issues with new PHP versions so you can update with confidence that the WordPress core software is compatible.&nbsp;</p>\n\n\n\n<p>Happy WordPress-ing!&nbsp;</p>\n\n\n\n<p><em>Thank you to <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a> <a href=\'https://profiles.wordpress.org/barry/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>barry</a> <a href=\'https://profiles.wordpress.org/ironprogrammer/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ironprogrammer</a> <a href=\'https://profiles.wordpress.org/hellofromtonya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hellofromtonya</a> <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> <a href=\'https://profiles.wordpress.org/costdev/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>costdev</a> <a href=\'https://profiles.wordpress.org/javiercasares/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>javiercasares</a> for reviewing and contributing to the effort of this post.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16235\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.4 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/10/wordpress-6-4-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Oct 2023 16:45:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16219\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"WordPress 6.4 RC2 is ready for download and testing. Reaching this phase of the release cycle is an important milestone. Check out what\'s new and how you can help.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Meher Bala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6586:\"\n<p>The second release candidate (RC2) for WordPress 6.4 is now available!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>WordPress 6.4 is <a href=\"https://make.wordpress.org/core/6-4/\">slated for release</a> on <strong>November 7, 2023</strong>—two weeks from today. If you haven’t tried it, now is the time.</p>\n\n\n\n<p>You can test WordPress 6.4 RC2 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-RC2.zip\">RC2 version (zip)</a> and install it on a WordPress site.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-RC2</code></li>\n</ol>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-release-candidate-1/\">Read the RC1 announcement</a> for featured highlights, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a>. If you are looking for detailed technical notes on new features and improvements, the <a href=\"https://make.wordpress.org/core/2023/10/23/wordpress-6-4-field-guide/\"><strong>WordPress 6.4 Field Guide</strong></a> is for you.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">underrepresented gender release squad</a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.4 RC2?</h2>\n\n\n\n<p>Thanks to everyone who has tested the beta and RC releases. Since RC1 was released on October 17, there have been more than 25 issues resolved. You can browse the technical details for all recent updates using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F18%2F2023..10%2F24%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets since RC1</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Contributing to 6.4</h2>\n\n\n\n<p>WordPress is open source software made possible by a community of people collaborating on and contributing to its development. The resources below outline various ways you can help, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Your feedback and help in testing are vital to developing the WordPress software and ensuring its quality. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Check out this guide</a> for instructions on testing WordPress 6.4 features.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>During the release candidate phase of WordPress 6.4, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>Do you build themes and plugins? Your products play an integral role in extending the functionality and value of WordPress for users worldwide.</p>\n\n\n\n<p>Hopefully, you have already tested your themes and plugins with WordPress 6.4 betas. With RC2, you will want to continue your testing and update the <em>&#8220;Tested up to&#8221;</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin&#8217;s readme file</a> to 6.4.</p>\n\n\n\n<p>Please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a> if you find compatibility issues.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Português? Русский? 日本? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A RC2 haiku</h2>\n\n\n\n<p>You have been waiting<br>Download and give it a test<br>RC2 is here</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/michelleames/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>michelleames</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 22 Nov 2023 03:37:41 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 20 Nov 2023 12:37:05 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20211220193300\";}", "no");
INSERT INTO `wpgfi_options` VALUES("5327", "_site_transient_community-events-5eeaa8a5b5eb43404c9baef9e33bdcf0", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:13:\"112.201.171.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wpgfi_options` VALUES("5328", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1700667462", "no");
INSERT INTO `wpgfi_options` VALUES("5329", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"Do The Woo Community: Now is the Time for Passkeys in WordPress, All the Time with Timothy Jacobs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=78528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/now-is-the-time-for-passkeys-in-wordpress-all-the-time-with-timothy-jacobs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:584:\"<p>On Emerging Tech, Timothy Jacobs of SolidWP explores passkeys, a security tech for WordPress. Eliminating passwords, it uses biometric data, ensuring user safety and resisting phishing. Adopted by major firms, passkeys promise enhanced WordPress security.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/now-is-the-time-for-passkeys-in-wordpress-all-the-time-with-timothy-jacobs/\">Now is the Time for Passkeys in WordPress, All the Time with Timothy Jacobs</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Nov 2023 08:39:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"WPTavern: What’s Next?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=151422\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://wptavern.com/whats-next\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3868:\"<p>First, I&#8217;d like to repeat <a href=\"https://wptavern.com/last-call#comment-445773\">my comment</a> to <a href=\"https://twitter.com/pollyplummer\">Sarah</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Sarah, you are amazing. Your insightful writing and journalism has been a gift to the WordPress world, and shaped how the project has evolved for the better. It’s a key and major contribution to the community. Thank you, deeply, and I can’t wait to see what you do next. Ten years… wow!</p>\n</blockquote>\n\n\n\n<p>I&#8217;m sorry I haven&#8217;t had the time to find a new writer for the Tavern in the time between when Sarah gave her notice a few weeks ago and now. There&#8217;s never a dull moment in tech and my priorities with <a href=\"https://wordpress.org/\">WordPress core</a> and <a href=\"https://automattic.com/\">Automattic</a> ended up taking more time than I expected. Funding and supporting the Tavern to do independent WordPress journalism is an important part of the WP ecosystem—we need a site that covers our space without care for affiliate links.</p>\n\n\n\n<p>If you have:</p>\n\n\n\n<ul>\n<li>Impeccable integrity</li>\n\n\n\n<li>Relentless curiosity</li>\n\n\n\n<li>A blogger&#8217;s hustle</li>\n\n\n\n<li>Passion for news and technology</li>\n\n\n\n<li>Technical ability to tinker with WordPress, plugins, and themes</li>\n</ul>\n\n\n\n<p>Please send an email to matt at my last name dot com, with [wptavern] at the beginning of the subject, and the following things in the email:</p>\n\n\n\n<ol>\n<li>Why you think you&#8217;d be best in the world for this job.</li>\n\n\n\n<li>Links to three things you&#8217;ve written that you feel represent your style well.</li>\n\n\n\n<li>A link to your homepage and any social media you keep up with.</li>\n\n\n\n<li>Link or attach a resume, but don&#8217;t worry too much about this, the first two are more important.</li>\n\n\n\n<li>Your <a href=\"https://w.org/\">W.org</a> username, and sign up for the Slack there so I can ping you.</li>\n</ol>\n\n\n\n<p>And please send in the application by November 24th! We&#8217;ll take this week off but hopefully come back blazing after Thanksgiving. I&#8217;ll review everything over the weekend when I have some time off planned.</p>\n\n\n\n<p>We&#8217;ll try out a number of folks on an hourly contract ($25/hr, same as Automattic) as a trial, and if that goes well we&#8217;ll aim to hire two full-time writers by the end of the year. A full-time offer also includes generous benefits including full coverage on health care and 6% 401k matching. You&#8217;ll be an employee of <a href=\"https://audrey.co/\">Audrey</a>.</p>\n\n\n\n<p>The job is to write frequently about the goings-on in the WordPress world and foster a healthy discussion and community here on the site. If you&#8217;re doing your job well, it should be reflected in traffic and comments on the site.  You will set the tone and discussion in the WordPress community, and drive the narrative. Every post will be syndicated to every wp-admin in the world. You don&#8217;t have to start out a WordPress expert, but you&#8217;ll become one. You&#8217;ll have a ton of autonomy, so need to be self-driven and able to manage yourself. (You can ask previous writers how much I was in their hair. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f600.png\" alt=\"😀\" class=\"wp-smiley\" />)</p>\n\n\n\n<p><em>Midjourney prompt: a stunning landscape scene with a tranquil atmosphere. The foreground showcases a calm, crystal-clear lake reflecting the serene blue sky above. On the horizon, a majestic mountain range rises, covered in lush, green vegetation. The central focus of the image is the sun, just starting to rise above the peaks, casting a warm, golden glow across the entire scene. Its rays create a mesmerizing play of light on the water&#8217;s surface, symbolizing hope, new beginnings, and the promise of a brighter future.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Nov 2023 01:47:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Matt: Sunbird Security Isn’t Nothing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=106183\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2023/11/sunbird/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7495:\"<p>This might get lost in the <a href=\"https://www.techmeme.com/231117/p18#a231117p18\">OpenAI earthquake happening</a>, but it&#8217;s important so I wanted to post about it. (And gosh! <a href=\"https://www.reuters.com/technology/space/spacex-starship-launched-test-flight-texas-after-last-one-blew-up-2023-11-18/\">A Starship launch</a>, which is amazing. We live in interesting times.) On Tuesday, <a href=\"https://us.nothing.tech/\">Nothing</a>, who makes the cleanest and most interesting Android phones (and whose earbuds sound great), <a href=\"https://www.youtube.com/watch?v=ji5HwS3bhlU\">announced via my favorite tech video channel, MKBHD, that the phones would support iMessage on Android</a>, so you can be a blue bubble with your friends. This got a lot of pickup!</p>\n\n\n\n<img width=\"604\" height=\"297\" src=\"https://i0.wp.com/ma.tt/files/2023/11/86cac-1dbenrruyxhyhfjyghrs4sg-1024x504.jpeg?resize=604%2C297&ssl=1\" alt=\"\" class=\"wp-image-106204\" />\n\n\n\n<p>It got a little buried, though, because on Thursday <a href=\"https://9to5mac.com/2023/11/16/apple-rcs-coming-to-iphone/\">Apple said it was going to support the RCS standard</a>, which Google and others had been lobbying hard for. However, it&#8217;s doing the bare minimum: RCS isn&#8217;t actually encrypted, and Apple&#8217;s not doing the Google proprietary thing to encrypt it, and so non-Apple people <a href=\"https://9to5mac.com/2023/11/16/apple-confirms-rcs-messages-will-have-green-bubbles/\">still get green bubbles</a>. (More on that later.)</p>\n\n\n\n<p>iMessage on Android (and Windows!) is on the roadmap for Texts, <a href=\"https://ma.tt/2023/10/texts-joins-automattic/\">the all-in-one messaging platform Automattic acquired last month</a>. The Texts team is obsessed with security, and that&#8217;s part of why the platform is desktop-only right now—to keep everything 100% client-side and fully encrypted in a way that could never be accessed by the team, or have any compromise in the middle, they&#8217;ve been taking their time to get the engineering right on the mobile versions. So they poked around the Sunbird app that Nothing partnered with, and it wasn&#8217;t pretty. Here&#8217;s Texts founder Kishan Bagaria:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">texts team took a quick look at the tech behind nothing chats and found out it\'s extremely insecure<br /><br />it\'s not even using HTTPS, credentials are sent over plaintext HTTP<br /><br />backend is running an instance of BlueBubbles, which doesn\'t support end-to-end encryption yet <a href=\"https://t.co/IcWyIbKE86\">pic.twitter.com/IcWyIbKE86</a></p>&mdash; Kishan Bagaria (@KishanBagaria) <a href=\"https://twitter.com/KishanBagaria/status/1725586252630540555?ref_src=twsrc%5Etfw\">November 17, 2023</a></blockquote>\n</div>\n\n\n\n<p>The BlueBubbles thing might be a mistake, but seeing the unencrypted data on the wire definitely wasn&#8217;t. Sunbird replied and doubled down on Twitter, citing some ISO standard and claiming it was &#8220;encrypted.&#8221;</p>\n\n\n\n<p>Okay! Now you&#8217;re caught up to Friday. Texts says Sunbird isn&#8217;t secure, Sunbird says it is. He said, she said, right? Not quite—there are receipts. <a href=\"https://texts.blog/2023/11/18/sunbird-security/\">This blog post lays out even more than Kishan tweeted originally and shares code so you can confirm this yourself</a>. tl; dr: Sunbird puts all your iMessages and attachments into Firebase.</p>\n\n\n\n<p>What should you take away from this?</p>\n\n\n\n<p><strong>Nothing</strong> (the company) still makes amazing hardware that you should absolutely check out and use. It&#8217;s my favorite Android experience. I think the company got bamboozled by Sunbird, and unfortunately this went mainstream on MKBHD.</p>\n\n\n\n<p><strong>Sunbird</strong> appears either not to understand security or to lie about it, and probably misled Nothing. I would recommend double-checking what that team claims in the future.</p>\n\n\n\n<p>Who should we actually be upset with? </p>\n\n\n\n<p><strong>Apple</strong>. </p>\n\n\n\n<p>You shouldn&#8217;t need to jump through all these hoops to have a blue bubble on iMessage. Design can create great things; it can also harm. Apple&#8217;s design decisions to &#8220;magically&#8221; upgrade SMS or texts or RCS into iMessage, which is better and more secure, creates a green-bubble ghetto that&#8217;s also a terrible user experience for anyone not on an Apple-made device.</p>\n\n\n\n<p>I&#8217;ve heard stories of teenagers being ostracized because they couldn&#8217;t afford an iPhone, of group chats rejecting people who turn the chat from blue to green. I know that sounds petty, but do you remember middle school? It&#8217;s about status, and Apple knows that. Everything they make bleeds status and signaling. They&#8217;re the best in the world at it, and I should know—I&#8217;m typing this post from a M3 Max black MacBook with 128GB of RAM. But while status signaling with amazing hardware and design touches is harmless, in software and social settings in can be harmful.</p>\n\n\n\n<p>Regardless of how it started, today the green bubble indicates cheaper, lower-status, less secure. Apple&#8217;s half-hearted support of RCS just continues this. Sunbird (and others) shouldn&#8217;t need to jump through so many hoops around this stuff by reverse engineering. Apple should open up iMessage APIs so it can be natively supported just like every other 100M+ messaging platform is: Telegram, Signal, WhatsApp, et al. Teens who can&#8217;t afford or don&#8217;t want an iPhone should be able to have an app that lets them connect with their friends as peers, securely and with all the features that are easy to support in messaging.</p>\n\n\n\n<p>Tim Cook, Apple, we love you. Trillion-dollar company, and lots of room still to grow. Allowing iMessage/FaceTime to interoperate (like it used to!) might take .01% off your growth rate, but it&#8217;s the right thing for humanity. Yes, I know Google is shady too, and they&#8217;re locked in this smartphone death match with you. But take person-to-person communication out of the struggle, make it a DMZ, and be content to compete in all the other areas you&#8217;re currently crushing: design, silicon, <a href=\"https://www.apple.com/macos/continuity/\">Continuity</a>, security, privacy, customer experience, retail stores, spatial audio, the list goes on.</p>\n\n\n\n<p>I have no idea how to get in touch with YouTubers, but Marques, if you see this, I&#8217;m happy to chat about the future of technology, open source, freedom, and privacy.</p>\n\n\n\n<p>Update: As I was writing this, <a href=\"https://9to5google.com/2023/11/18/nothing-chats-sunbird-unencrypted-data-privacy-nightmare/\">the Nothing Chats app has been pulled from the Play store</a>.</p>\n\n\n\n<p>Update 2: From my colleague Batuhan:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I’ve been banned from <a href=\"https://twitter.com/sunbirdapp?ref_src=twsrc%5Etfw\">@sunbirdapp</a>’s Discord, probably because I made a tool that deletes some of the data they keep. <br /><br />If you are a Sunbird/Nothing Chats user, here’s my recommendation, in order:<br /><br />&#8211; Change your Apple ID password *now* and revoke their session<br />&#8211; Remove the app<br />-…</p>&mdash; batuhan içöz (@batuhan) <a href=\"https://twitter.com/batuhan/status/1725985096463724838?ref_src=twsrc%5Etfw\">November 18, 2023</a></blockquote>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Nov 2023 16:57:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Gutenberg Times: State of the Word, 2024 release schedule, WooCommerce 8.3 and more – Weekend Edition 274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=26349\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://gutenbergtimes.com/state-of-the-word-2024-release-schedule-woocommerce-8-3-and-more-weekend-edition-274/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15459:\"<p>Howdy, </p>\n\n\n\n<p>Now the Fall has come to Munich, Germany and as the Floridian weather wimp, I have to go into hibernation like Mama Bear. To counteract the urge to crawl back into bed, I practiced some exposure therapy with at least 6,000 steps outside in full gear (tuck, gloves, cape, and shawl), even in the rain. It helped a little, and I am not afraid of the cold anymore. That&#8217;s my win for this week. I will let you know how it goes when snow falls. What are the small wins in your life right now? </p>\n\n\n\n<p>I am sad that <a href=\"https://wptavern.com/last-call\">Sarah Gooding, after a decade writing for the WPTavern, is moving on to a new endeavor</a>. She has been a great supporter of the Gutenberg Times, and an even greater supporter of the WordPress Community as a whole. Over three thousand articles.  Day in, day out, she kept her ear on the pulse, separated the wheat from the chuff, and helped thousands of WordPress users understand how WordPress works, how businesses thrive in the open-source market and explained some of the more technical decisions and development to us mere mortals. She&#8217;ll be missed for sure, and we wish her a great start into the new adventures. </p>\n\n\n\n<p>Gutenberg wise, there is some wonderful work being done. Learn more below and enjoy the newsletter. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ul></div>\n</div></div>\n\n\n\n\n<p>On <strong>December 11, 2023, at 15:00 UTC, Matt Mullenweg</strong>, co-founder of WordPress, will give the State of the Word keynote. This year for the first time ever not from the United States. </p>\n\n\n\n<p>If you want to be there in person, join a watch party near you or watch the live stream, <strong>Dan Soschin</strong> has the details in his post. <a href=\"https://wordpress.org/news/2023/11/state-of-the-word-2023-madrid-spain/\"><strong>State of the Word 2023 – Madrid, Spain</strong></a>. For the Q &amp; A session, you can send it your question via email or wait for the <a href=\"https://www.slido.com/\">Slido APP</a> QR code at the event. </p>\n\n\n\n<a href=\"https://wordpress.org/news/2023/11/state-of-the-word-2023-madrid-spain/\"><img width=\"652\" height=\"435\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/11/image.png?resize=652%2C435&ssl=1\" alt=\"\" class=\"wp-image-26400\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>In her post <a href=\"https://make.wordpress.org/core/2023/11/06/proposal-2024-major-release-timing/\"><strong>Proposal: 2024 Major Release Timing</strong></a>, executive Director and release lead of WordPress 6.4, <strong>Josepha Haden Chomphosy </strong>proposed the release schedule for 2024. She envisions again three major releases of WordPress: </p>\n\n\n\n<ul>\n<li>6.5 –&nbsp;Beta&nbsp;1 on Feb. 13, final release on Mar. 26 (WordCamp&nbsp;Asia Mar. 7-9)</li>\n\n\n\n<li>6.6 – Beta 1 on Jun. 4, final release on Jul. 16 (WordCamp Europe Jun. 13-15)</li>\n\n\n\n<li>6.7 – Beta 1 on Sep. 24, final release on Nov. 5 (WordCamp US still TBD)</li>\n</ul>\n\n\n\n<p>Giving a Gutenberg release cycle every other week, the last Gutenberg plugin version that will make it into the next WordPress version 6.5 is 17.7. That&#8217;s six more versions to get new features ready and tested before they make it into core. Speaking of testing, <strong>Andre Maneiro</strong> just released <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v17.1.0-rc.1\"><strong>Gutenberg 17.1 RC 1</strong></a> for testing. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Meanwhile, the work for WordPress 6.4 is not done: <strong>Femy Praseeth,</strong> release lead  for documentation, published a  <a href=\"https://make.wordpress.org/docs/2023/10/25/call-for-volunteers-to-help-with-6-4-end-user-documentation/\"><strong>Call for volunteers to help with 6.4 end-user documentation</strong></a>. It&#8217;s a great chance to apply your knowledge of how to use WordPress and help others to understand it too. You&#8217;ll find onboarding information, a list of tasks and links to the handbook in the post. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-no-vertical-margin\"><strong>🎙️ </strong> Latest episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-92/\">Gutenberg Changelog #92 – Twenty-Twenty-Four, WordPress 6.4 and Gutenberg 16.9 and 17.0</a> with Jessica Lyschik as special guest, hosted by Birgit Pauli-Haack</p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>For the default theme, Twenty-Twenty-Four developers had three uses cases in mind and provided patterns and page layouts for bloggers, portfolio artists and small business owners. <strong>Jamie Marsland</strong> took them by their word and he created five new websites using Twenty-Twenty-four. In his video  <a href=\"https://www.youtube.com/watch?v=qoX3uNmH5LY\"><strong>Is this the best WordPress Theme ever! </strong></a>he shows you how he built five sites, only using the built-in patterns, block variations and style variations. The examples, are one-page, a woo-commerce theme and also a small business website. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>If you are looking for a second (or third or fourth) opinion on the Twenty-Twenty-Four theme, <strong><a href=\"https://twitter.com/mattmedeiros\">Matt Medeiros</a></strong>, feels you should <a href=\"https://www.youtube.com/watch?v=0H37o1SBFr4\"><strong>Watch this before you try Twenty Twenty-Four theme for WordPress</strong></a>. Medeiros top four takeaways: </p>\n\n\n\n<ul>\n<li>Groups allow you to style sections of content and turn them into reusable patterns. </li>\n\n\n\n<li>The site editor lets you edit styles, templates, and parts for the whole site. </li>\n\n\n\n<li>Template parts like headers and footers apply across templates. </li>\n\n\n\n<li>The query loop block customizes how posts/content are displayed. </li>\n</ul>\n\n\n\n<p> &#8220;While not yet perfect, Twenty Twenty-Four shows the direction WordPress is headed for easy site building without needing page builders or premium themes.&#8221; he wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his video, <a href=\"https://www.youtube.com/watch?v=erT8LxuI5r4\"><strong>Mastering WordPress 6.4 in under 5 Minutes: every feature revealed</strong></a>, <strong>Dave Smith</strong> walks you through the key features of the new WordPress release: new default theme, image Lightbox, background image for group block, List view updates and enhancements to patterns management, vertical text orientation and adding buttons to the Navigation block. It&#8217;s a great overview if you want to know what&#8217;s new in WordPress 6.4 for content creators.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Using the site of the <em><a href=\"https://block-museum.com/\">Museum of Block Art</a></em>, <strong>Anne McCarthy</strong> demonstrated in this video the impact of the enhanced pagination that came with WordPress 6.4 to the Query block. <strong><a href=\"https://www.youtube.com/watch?v=y7YHFncLvD4\">Effortless Pagination: How a new WordPress 6.4 feature elevates the user experience</a>.</strong> </p>\n\n\n\n<img width=\"652\" height=\"409\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/11/Screenshot-2023-11-15-at-16.45.01.png?resize=652%2C409&ssl=1\" alt=\"\" class=\"wp-image-26357\" />\n\n\n\n<p>Last week, we mentioned the new block theme by Ellen Bauer and Manuel Esposito.. <strong>Sarah Gooding</strong> gave it a review, <a href=\"https://wptavern.com/elmastudio-releases-moog-a-free-block-theme-for-blogs\"><strong>ElmaStudio Releases Moog: A Free Block Theme for Blogs</strong></a>. &#8220;It features a minimal and bold layout with a responsive, masonry style grid on the homepage. Moog is well suited to blogs or even small magazine websites, with options to radically change the style with the click of a button.&#8221; she wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>A new version of WooCommerce is now available. <strong>Nigel Stevenson</strong>  has the release notes for you. <a href=\"https://developer.woo.com/2023/11/16/woocommerce-8-3-0-released/\"><strong>WooCommerce 8.3.0 Released</strong></a>. He highlighted: </p>\n\n\n\n<ul>\n<li>For new installation, Card, Check-out and Order confirmation blocks are switched on by default. </li>\n\n\n\n<li>For existing stores, the release provides an effortless migration using the page creation tool</li>\n\n\n\n<li>Marketplace and Extension pages are revamped, and </li>\n\n\n\n<li>the mobile app onboarding experience has been improved</li>\n</ul>\n\n\n\n<p><strong>Sarah Gooding</strong> shared more details in <a href=\"https://wptavern.com/woocommerce-8-3-makes-cart-checkout-and-order-confirmation-blocks-default-on-new-installations\"><strong>WooCommerce 8.3 Makes Cart, Checkout, and Order Confirmation Blocks Default on New Installations</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On Learn.WordPress, <a href=\"https://twitter.com/LauraAdamonis\"><strong>Laura Adamonis</strong></a> posted a tutorial on <a href=\"https://learn.wordpress.org/tutorial/how-to-create-a-menu-with-the-navigation-block-2/\"><strong>How to create a menu with the navigation block</strong></a>. The description reads: &#8220;This tutorial will walk a user through how to create a menu with the navigation block in the site editor of updated 6.4. The tutorial will use the 2024 theme. It will also touch on moving menu items, creating a second menu, adding a button and a sub-menu&#8221;. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Brian Coords</strong> wrote in his post <a href=\"https://www.briancoords.com/custom-settings-screens-in-block-themes/\"><strong>Custom Settings Screens in Block Themes</strong></a> about his approach and considering all API options available. Customizer and Settings API after suitable for the task, Coords selected the Gutenberg design language and components and their more contemporary look to get started. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> is running a <a href=\"https://www.youtube.com/watch?v=VroaPsoTFkg\">WordPress Block Theme Live Special</a> on YouTube  with Rich Tabor,&nbsp;on the <strong>13th December, 20:00 UTC</strong> &#8220;If you are looking to get into WordPress Block Themes then this session is for you. Rich Tabor, Core Gutenberg Product Manager, is helping me explain the basics and more advanced features of Block Themes.&#8221; he wrote in the description. </p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>The latest recipe of <strong>Ryan Welcher&#8217;s </strong> <em>Block Developer Cook Book</em>, is about <strong><a href=\"https://www.youtube.com/watch?v=MtVRifFbUaQ\">Connecting to Post Meta</a></strong> and you&#8217;ll learn to extract and update data from WordPress custom post meta, &#8220;adding a flavorful twist to your post meta management.&#8221; he wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-right has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: &#8220;Blocks of ice ready for next years ice hotel&#8221; by Rose Robinson is licensed under CC BY-NC-ND 2.0</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Nov 2023 09:49:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"WPTavern: Last Call\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=151409\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/last-call\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4939:\"<p>This has been an emotional, bittersweet morning for me, reading through old posts, as I close the book on my time at this beloved publication. Today is my last day before moving on to embrace a new challenge in the world of tech.&nbsp;&nbsp;</p>\n\n\n\n<p>In 2013, the year I started writing at the Tavern, just <a href=\"https://w3techs.com/technologies/history_overview/content_management/all/y\">17.4% of the web</a> was running on WordPress, but the momentum I felt at that <a href=\"https://wptavern.com/matt-mullenwegs-state-of-the-word-highlights-internationalization-mobile-and-new-tools-for-wordpress-contributors\">last WordCamp San Francisco</a> was intoxicating and undeniable. It marked the ascendency of the global WordPress community and the move to embrace new tools like Slack and GitHub for contributing to core.</p>\n\n\n\n<p>At that time, one frustrating thing I frequently heard was &#8220;It&#8217;s just WordPress, don&#8217;t take it so seriously.&#8221; Yet there we were, standing on the edge of an amazing acceleration of WordPress&#8217; adoption and expansion of the ecosystem that brought meaningful work to millions and gave people a voice on the web. It was never &#8220;just WordPress&#8221; to me. As the software enters its third decade, powering 43% of the world&#8217;s websites, WordPress continues to be an irrepressible force of good on the web. I&#8217;d like to think the Tavern had a small part in that.</p>\n\n\n\n<p>I want to thank past colleagues Jeff Chandler, Justin Tadlock, and Nathan Wrigley, as well as Matt Mullenweg for supporting the publication for so many years. We have done a lot of daily reporting but the Tavern keeper is a watchdog at heart. Our commitment to serving the public interest was instrumental in holding companies, authorities, and the open source project accountable, and I am proud of the work we did together.</p>\n\n\n\n<p>When I started, I had no idea how I would fully embrace the challenge of writing, editing, and publishing&nbsp;WordPress news every day. It changed me. Writing news is an intensely public job that comes with a nearly constant onslaught of criticism. I found that showing up even on my worst days forged a level of discipline that was previously inaccessible to me. Today, 3,021 articles later, publishing is in my blood.</p>\n\n\n\n<p>To our wonderful community of readers: Thank you for trusting us to tell your stories. Thank you to every one of you who chose to speak to the press &#8211; both on the record and anonymously when something needed to come to light. You made it possible for the Tavern to become the most authoritative and reliable source of WordPress news on the web.</p>\n\n\n\n<p>We navigated many challenging times together and celebrated previously unbelievable milestones. I&#8217;ve been privileged to have a front row seat to your innovation and determination, and I&#8217;ll continue cheering for your success. Thank you, beautiful WordPress community.</p>\n\n\n\n<p>In honor of 10 years at the Tavern, I&#8217;ll leave you with 10 of my favorite articles for a short trip down memory lane. </p>\n\n\n\n<p><a href=\"https://wptavern.com/finding-freedom-and-opportunity-with-wordpress-how-wolf-bishop-overcame-prison-and-addiction-to-launch-a-career\">Finding Freedom and Opportunity With WordPress: How Wolf Bishop Overcame Prison and Addiction to Launch a Career</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/how-the-welch-news-uses-wordpress-to-keep-local-news-alive-in-west-virginia\">How The Welch News Uses WordPress To Keep Local News Alive in West Virginia</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/amp-has-irreparably-damaged-publishers-trust-in-google-led-initiatives\">AMP Has Irreparably Damaged Publishers’ Trust in Google-led Initiatives</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/wordpress-turns-20\">WordPress Turns 20</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/tectonic-shifts-in-retail-industry-are-creating-unprecedented-opportunities-for-independent-stores\">Tectonic Shifts in Retail Industry are Creating Unprecedented Opportunities for Independent Stores</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/finding-wordpress-in-the-post-print-news-era\">Finding WordPress in the Post-Print News Era</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/wordpress-5-0-rc-expected-on-u-s-thanksgiving-holiday-despite-last-minute-pushback-from-contributors\">WordPress 5.0 RC Expected on U.S. Thanksgiving Holiday, Despite Last-Minute Pushback from Contributors</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/wordpress-smiley-wars-will-core-adopt-new-emoticons\">WordPress Smiley Wars: Will Core Adopt New Emoticons?</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/rip-buddypress-default-theme-finally-laid-to-rest-in-1-9\">RIP BuddyPress Default Theme: Finally Laid to Rest in 1.9</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/wordpress-beyond-boundaries-a-recap-of-wordcamp-europe-2014\">WordPress Beyond Boundaries: A Recap of WordCamp Europe 2014</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 20:50:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Talking Woo Agencies with Andrew Behla and Patrick Garman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=63221\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/a-woobiz-chat-with-agency-owners-andrew-behla-and-patrick-garman/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:469:\"<p>Listen in as they chat about market disruptions, business tools, client off hour expectations and the differentiators that set Woo apart from other ecommerce platforms.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/a-woobiz-chat-with-agency-owners-andrew-behla-and-patrick-garman/\">Talking Woo Agencies with Andrew Behla and Patrick Garman</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Do The Woo Community: WooCommerce Development Insights &amp; Empowering Clients with DJ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=63183\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://dothewoo.io/woocommerce-development-insights-empowering-clients-with-d-j/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:455:\"<p>DJ\'s development skills with WooCommerce blend his willingness to learn quickly and deeply while giving his clients more empowerment over their site.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-development-insights-empowering-clients-with-d-j/\">WooCommerce Development Insights &#038; Empowering Clients with DJ</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Do The Woo Community: A Roundtable Chat with Clara Lee, Product Marketing at WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=63172\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://dothewoo.io/a-roundtable-chat-with-clara-lee-product-marketing-at-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:442:\"<p>A conversation with Clara Lee takes a deep dive behind the scenes into the product marketing at WooCommerce and what makes it tick.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/a-roundtable-chat-with-clara-lee-product-marketing-at-woocommerce/\">A Roundtable Chat with Clara Lee, Product Marketing at WooCommerce</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: A Mastering WooCommerce Snippets with Rodolfo Melogli\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=63160\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://dothewoo.io/a-master-of-woocommerce-snippets-rodolfo-melogli/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"<p>Listen in as Rodolfo talks about dedicating his site over the years to help developers level up their coding skills. </p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/a-master-of-woocommerce-snippets-rodolfo-melogli/\">A Mastering WooCommerce Snippets with Rodolfo Melogli</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: All You Need to Know to Organize a WooCommerce Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=63052\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/all-you-need-to-know-to-organize-a-woocommerce-meetup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:410:\"<p>When you get five meetup co-organizers together for a chat, the insights and experiences shared are going to flood the gates</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/all-you-need-to-know-to-organize-a-woocommerce-meetup/\">All You Need to Know to Organize a WooCommerce Meetup</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Do The Woo Community: When Did You First Do the Woo?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62904\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://dothewoo.io/when-did-you-first-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"<p>Listen in as we hear from ten past guests about how they discovered and started using WooCommerce. </p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/when-did-you-first-do-the-woo/\">When Did You First Do the Woo?</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Do The Woo Community: WooCommerce and Mobile Apps with Scott Bolinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62878\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/woocommerce-and-mobile-apps-with-scott-bolinger/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:401:\"<p>Whether it\'s your clients site or your own store, you may or may not be keeping mobile apps aligned with what you are building.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-and-mobile-apps-with-scott-bolinger/\">WooCommerce and Mobile Apps with Scott Bolinger</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Do The Woo Community: A Look at WordPress Core and Blocks with Grzegorz Ziolkowski\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://dothewoo.io/wordpress-core-and-blocks-with-grzegorz-ziolkowski/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:423:\"<p>We catch up with what\'s happening with blocks and get some insights from Greg on how WooCommerce blocks play into the bigger picture.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/wordpress-core-and-blocks-with-grzegorz-ziolkowski/\">A Look at WordPress Core and Blocks with Grzegorz Ziolkowski</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: A Roundtable Discussion with Warren Holmes, COO at WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62612\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://dothewoo.io/a-roundtable-discussion-with-warren-holmes-coo-at-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:439:\"<p>Warren Holmes has been with WooCommerce for 10 years and sheds some light on  very important questions with his insights and experience.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/a-roundtable-discussion-with-warren-holmes-coo-at-woocommerce/\">A Roundtable Discussion with Warren Holmes, COO at WooCommerce</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Do The Woo Community: Hooking and Integrating WooCommerce into Warehousing with David Baumwald\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/hooking-woocommerce-into-warehousing-with-david-baumwald/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:475:\"<p>From being an expert into hooking WooCommerce into a warehouse to being a release lead for WordPress Core, David has done a lot as a full stack developer for 17 years.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/hooking-woocommerce-into-warehousing-with-david-baumwald/\">Hooking and Integrating WooCommerce into Warehousing with David Baumwald</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Do The Woo Community: Developers and Meetups with Alicia St. Rose and David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62561\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/developers-and-meetups-with-alicia-st-rose-and-david-bisset/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:466:\"<p>There are a lot of opportunities for developers to attend or even start up a WordPress or WooCommerce meetup. Alicia and David dive into it from first-hand experience.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/developers-and-meetups-with-alicia-st-rose-and-david-bisset/\">Developers and Meetups with Alicia St. Rose and David Bisset</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Do The Woo Community: Keeping Woo Devs on Top of WordPress Core with Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/keeping-on-top-of-wordpress-core-with-jonathan-desrosiers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"<p>As a WooCommerce builder, you need to keep on top of all the major changes in WordPress core. This episode will get you started.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/keeping-on-top-of-wordpress-core-with-jonathan-desrosiers/\">Keeping Woo Devs on Top of WordPress Core with Jonathan Desrosiers</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"Do The Woo Community: Promoting Products to WooCommerce Developers and Agencies with Jodie Florenza and Michael Bragg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62463\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/promoting-products-to-woocommerce-developers-and-agencies/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:439:\"<p>Get agencies and developers to become your fans and  recommend and use your WooCommerce product or service.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/promoting-products-to-woocommerce-developers-and-agencies/\">Promoting Products to WooCommerce Developers and Agencies with Jodie Florenza and Michael Bragg</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Do The Woo Community: A Deep Dive into the WooCommerce User Community with Jonathan Wold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62397\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/woocommerce-roundtable-with-guest-jonathan-wold/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:361:\"<p>A great conversation around the WooCommerce ecosystem and community.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-roundtable-with-guest-jonathan-wold/\">A Deep Dive into the WooCommerce User Community with Jonathan Wold</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: Funding and Growth for WooCommerce Shops with Aidan Corbett\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62385\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://dothewoo.io/funding-growth-and-deliberation-with-aidan-corbett/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:433:\"<p>Aidan shares thoughts on outside funding, seasonal inventory, low risk businesses and how he views WooCommerce favorably as a deliberate choice.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/funding-growth-and-deliberation-with-aidan-corbett/\">Funding and Growth for WooCommerce Shops with Aidan Corbett</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Do The Woo Community: A Q&amp;A on Developer Advocacy at WooCommerce with Allen Smith\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62378\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://dothewoo.io/question-and-answer-with-allen-smith-developer-advocate-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:443:\"<p>Listen in to this live chat with Allen Smith as we talk about WooCommerce documentation, resources, contributing, headless and more.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/question-and-answer-with-allen-smith-developer-advocate-woocommerce/\">A Q&#038;A on Developer Advocacy at WooCommerce with Allen Smith</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Do The Woo Community: Conversation, Chatter and Core with BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62369\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://dothewoo.io/conversation-chatter-and-core/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:371:\"<p>We are bring more conversation to the podcast. Added perspectives through both the Woo Builder Events and WordPress core.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/conversation-chatter-and-core/\">Conversation, Chatter and Core with BobWP</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Do The Woo Community: Training, Open Source and WooCommerce with Robbie Adair\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://dothewoo.io/training-open-source-and-woocommerce-with-robbie-adair/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:418:\"<p>Listen in as Robbie shares her diverse background of open source work through her agency and her experience with online training.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/training-open-source-and-woocommerce-with-robbie-adair/\">Training, Open Source and WooCommerce with Robbie Adair</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: WooCommerce, eCommerce and Accessibility with Amber Hinds\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/woocommerce-ecommerce-and-accessibility-with-amber-hinds/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:430:\"<p>This conversation takes us deeper into accessibility. Not only do we learn the important basics, but how eCommerce fits into the picture.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-ecommerce-and-accessibility-with-amber-hinds/\">WooCommerce, eCommerce and Accessibility with Amber Hinds</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Do The Woo Community: The WooCommerce Marketplace with Adepeju Oduye\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62218\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/the-woocommerce-marketplace-with-adepeju-oduye/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"<p>Listen in as Adepeju Oduye talks about developers, selling on WooCommerce and the future of the marketplace.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/the-woocommerce-marketplace-with-adepeju-oduye/\">The WooCommerce Marketplace with Adepeju Oduye</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Do The Woo Community: Online Events for the WooCommerce Builder Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62070\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://dothewoo.io/online-events-for-the-woocommerce-builder-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"<p>Listen as the co-organizers chat about what WooCommerce builders can expect if they attend the weekly events.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/online-events-for-the-woocommerce-builder-community/\">Online Events for the WooCommerce Builder Community</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Do The Woo Community: A Conversation Around WooCommerce Blocks Gary, Darren and Manos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=62037\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://dothewoo.io/a-conversation-around-woocommerce-blocks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:419:\"<p>Darren Ethier and Gary Murray from WooCommerce join Manos Psychogyiopoulos, Head of Product at SomewhereWarm to talk WooCommerce blocks.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/a-conversation-around-woocommerce-blocks/\">A Conversation Around WooCommerce Blocks Gary, Darren and Manos</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Do The Woo Community: Building a WooCommerce Store on WordPress.com with Timmy Crawford\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61960\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://dothewoo.io/woocommerce-on-wordpress-com-with-timmy-crawford/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:407:\"<p>Timmy works on the Woo team and shares what people may not now about building a WooCommerce shop on WordPress.com.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-on-wordpress-com-with-timmy-crawford/\">Building a WooCommerce Store on WordPress.com with Timmy Crawford</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Growing an Agency and WooCommerce Enterprise Sites with Jake Goldman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61796\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://dothewoo.io/growing-an-agency-enterprise-and-woocommerce-with-jake-goldman/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:423:\"<p>Jakes shares his insights about WooCommerce in the enterprise state as well as the 10-year growth of his agency. </p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/growing-an-agency-enterprise-and-woocommerce-with-jake-goldman/\">Growing an Agency and WooCommerce Enterprise Sites with Jake Goldman</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Do The Woo Community: The Do the Woo WooCommerce Builder Survey 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/how-2020-played-out-for-woocommerce-businesses/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:386:\"<p>In this episode I share the results of my WooCommerce Builder Survey and some snippets on 2020 from past episodes.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/how-2020-played-out-for-woocommerce-businesses/\">The Do the Woo WooCommerce Builder Survey 2020</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Walking Clients Through the WooCommerce Journey with Alicia St. Rose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61614\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/taking-clients-on-the-entire-woocommerce-journey-with-alicia-st-rose/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:475:\"<p>Alicia brings in a unique combination of coaching and development that takes her clients through the entire process of building and growing your site or shop. </p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/taking-clients-on-the-entire-woocommerce-journey-with-alicia-st-rose/\">Walking Clients Through the WooCommerce Journey with Alicia St. Rose</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Do The Woo Community: Celebrating 100 Episodes on Do the Woo Podcast with an AMA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61519\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/celebrating-100-episodes-on-do-the-woo-podcast-with-an-ama/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:362:\"<p>When we hit 100 episodes it’s time for questions and celebration</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/celebrating-100-episodes-on-do-the-woo-podcast-with-an-ama/\">Celebrating 100 Episodes on Do the Woo Podcast with an AMA</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Do The Woo Community: Load Testing and Building WooCommerce Sites with Lauri Kasti\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://dothewoo.io/load-testing-and-woocommerce-with-lauri-robert-and-zach/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"<p>Listen in to an interesting deep-dive into load testing your WooCommerce shop.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/load-testing-and-woocommerce-with-lauri-robert-and-zach/\">Load Testing and Building WooCommerce Sites with Lauri Kasti</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Do The Woo Community: WooCommerce and Accessibility Tips with Bet Hannon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61478\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://dothewoo.io/woocommerce-and-accessibility-with-bet-hannon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:417:\"<p>Bet has a deep passion for accessibility. This is filled with stories, insights and tips for both WooCommerce and WordPress sites in general. </p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-and-accessibility-with-bet-hannon/\">WooCommerce and Accessibility Tips with Bet Hannon</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: A Guide to Agency Rebranding and Growth with Patrick Garman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61390\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://dothewoo.io/agency-rebranding-and-growth-with-patrick-garman-from-mindsize/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"<p>Patrick talks about the WooCommerce space over the years, the rebranding of his agency Mindsize and the potential WooCommerce has.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/agency-rebranding-and-growth-with-patrick-garman-from-mindsize/\">A Guide to Agency Rebranding and Growth with Patrick Garman</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Do The Woo Community: A WooCommerce Reunion with Adii, Magnus and Mark\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61362\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://dothewoo.io/a-woo-reunion-with-adii-magnus-and-mark/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:426:\"<p>in 2007 three guys, two from South Africa and one from Norway got together when an idea to start a theme shop called WooThemes. Well, one thing led to another.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/a-woo-reunion-with-adii-magnus-and-mark/\">A WooCommerce Reunion with Adii, Magnus and Mark</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: SEO, WooCommerce and Building Plugins with Marieke van de Rakt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61256\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://dothewoo.io/seo-woocommerce-marieke-van-de-rakt-yoast-do-the-woo-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:409:\"<p>In this episode we chat with Marieke, CEO at Yoast SEO about eCommerce SEO, building plugins and local SEO.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/seo-woocommerce-marieke-van-de-rakt-yoast-do-the-woo-podcast/\">SEO, WooCommerce and Building Plugins with Marieke van de Rakt</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"Do The Woo Community: The Perfect Blend of WooCommerce Freelancing and Community with Noelle Steegs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61178\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/freelancing-community-and-woocommerce-with-noelle-steegs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:444:\"<p>Noëlle Steegs is one of those rare freelancers that jumped on WordPress and WooCommerce at the same time. And the rest is history.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/freelancing-community-and-woocommerce-with-noelle-steegs/\">The Perfect Blend of WooCommerce Freelancing and Community with Noelle Steegs</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"Do The Woo Community: Ten Things I Wish I Knew When Starting My eCommerce Business with Christie and Dave\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61108\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://dothewoo.io/ten-tips-starting-ecommerce-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:446:\"<p>This tip-filled episode results from a threaded tweet based on someone who share what they wish they had known when they started their eCommerce site. </p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/ten-tips-starting-ecommerce-site/\">Ten Things I Wish I Knew When Starting My eCommerce Business with Christie and Dave</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Do The Woo Community: A Web Designer Who Codes with Michael Bragg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=61063\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://dothewoo.io/designer-developer-woocommerce-michael-bragg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"<p>Michael designs and codes and brings a unique talent that is truly a commodity for the ecosystem.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/designer-developer-woocommerce-michael-bragg/\">A Web Designer Who Codes with Michael Bragg</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"Do The Woo Community: How a Diverse Web Career Led to WordPress and WooCommerce with Sharon Yates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60947\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://dothewoo.io/diverse-web-career-leading-to-woocommerce-sharon-yates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:448:\"<p>Sharon Yates, owner of Creative Mouse Studio, chats with us about her experience in the tech industry, including WordPress and WooCommerce.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/diverse-web-career-leading-to-woocommerce-sharon-yates/\">How a Diverse Web Career Led to WordPress and WooCommerce with Sharon Yates</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Do The Woo Community: Do the Woo Chats with WordFest Organizers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60926\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://dothewoo.io/do-the-woo-chats-with-wordfest-organizers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"<p>Listen in to learn more about WordFest, tips for Woo builders and a bit of \"in hindsight, we should have used WooCommerce\".</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/do-the-woo-chats-with-wordfest-organizers/\">Do the Woo Chats with WordFest Organizers</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Do The Woo Community: Building WooCommerce Community and Stores in Nigeria with Mary Job\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60810\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://dothewoo.io/building-woocommerce-community-and-stores-in-nigeria-with-mary-job/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:404:\"<p>Mary Job has the passion to bring WordPress and WooCommerce to Nigeria and beyond in Africa.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/building-woocommerce-community-and-stores-in-nigeria-with-mary-job/\">Building WooCommerce Community and Stores in Nigeria with Mary Job</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Do The Woo Community: WooCommerce Builder Tips from the Pros for 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60623\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://dothewoo.io/woocommerce-builder-tips-for-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"<p>Listen to these tips from some WooCommerce pros for builders of products, services and websites in 2021.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-builder-tips-for-2021/\">WooCommerce Builder Tips from the Pros for 2021</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Do The Woo Community: Finding Resilience with WooCommerce Products in 2020 with Colin Daniels\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60517\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/resilience-with-woocommerce-products-in-2020-with-colin-daniels/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:423:\"<p>A chat about bootstrapping to product sales and when you are hit with product challenges resulting from 2020.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/resilience-with-woocommerce-products-in-2020-with-colin-daniels/\">Finding Resilience with WooCommerce Products in 2020 with Colin Daniels</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Do The Woo Community: Bringing Pride, Experience and Business Smarts to WooCommerce with Cami MacNamara\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60427\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://dothewoo.io/solopreneur-woocommerce-cami-macnamara/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:412:\"<p>Hear how one solopreneur is moving into the WooCommerce space and how she manages her business as a single owner.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/solopreneur-woocommerce-cami-macnamara/\">Bringing Pride, Experience and Business Smarts to WooCommerce with Cami MacNamara</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Do The Woo Community: Post Black Friday in 2020 with WooCommerce Plugin Shops\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://dothewoo.io/post-black-friday-in-2020-with-woocommerce-plugin-shops/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:418:\"<p>Listen in to hear how this year\'s Black Friday and Cyber Sunday sales went for three popular WooCommerce plugin shops this year.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/post-black-friday-in-2020-with-woocommerce-plugin-shops/\">Post Black Friday in 2020 with WooCommerce Plugin Shops</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"Do The Woo Community: Perspectives from Inside and Outside of the WooCommerce Ecosystem with Robert Jacobi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60326\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://dothewoo.io/outside-inside-woocommerce-ecosystem-robert-jacobi/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"<p>Robert Jacobi, Industry Analyst Strategist shares a very diverse background in the web space, open source and WooCommerce.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/outside-inside-woocommerce-ecosystem-robert-jacobi/\">Perspectives from Inside and Outside of the WooCommerce Ecosystem with Robert Jacobi</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: What is a WooCommerce Builder and a Look at the Opportunities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60234\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://dothewoo.io/woocommerce-builders-and-opportunities/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"<p>A lively discussion around who the Woo builders are and what opportunities can be found in thee ecosystem.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/woocommerce-builders-and-opportunities/\">What is a WooCommerce Builder and a Look at the Opportunities</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: Working with WooCommerce and Subscriptions Support with Sarah Rennick\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=60196\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/subscriptions-and-woocommerce-support-with-sarah-rennick/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:488:\"<p>We have a chance to talk about her transition to Automattic, a bit around the space of subscriptions and, of course, her active role in support at WooCommerce as a Happiness Engineer.</p>\n<p>&gt;&gt; The post <a href=\"https://dothewoo.io/subscriptions-and-woocommerce-support-with-sarah-rennick/\">Working with WooCommerce and Subscriptions Support with Sarah Rennick</a> appeared first on <a href=\"https://dothewoo.io\">Do the Woo - a WooCommerce and WordPress Builder Podcast</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 14:30:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 22 Nov 2023 03:37:42 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Wed, 22 Nov 2023 03:15:32 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20211220193300\";}", "no");
INSERT INTO `wpgfi_options` VALUES("4973", "_site_transient_timeout_community-events-29d91dc4ab3b5567aa229065bc0f56f7", "1700584374", "no");
INSERT INTO `wpgfi_options` VALUES("4974", "_site_transient_community-events-29d91dc4ab3b5567aa229065bc0f56f7", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:13:\"130.105.154.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wpgfi_options` VALUES("5315", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1700645856", "no");
INSERT INTO `wpgfi_options` VALUES("5316", "_transient_action_scheduler_last_pastdue_actions_check", "1700624256", "no");
INSERT INTO `wpgfi_options` VALUES("5358", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-22 03:43:04\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:33:\"20231122_gfimanpowerinternational\";s:4:\"Hash\";s:35:\"d0287dd012350d7f2534_20231122034304\";s:8:\"NameHash\";s:69:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:79:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:38:\"/home/slklwimy/public_html/staging/gfi\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1416;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7941;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-22 03:43:04\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:33:\"20231122_gfimanpowerinternational\";s:4:\"Hash\";s:35:\"d0287dd012350d7f2534_20231122034304\";s:8:\"NameHash\";s:69:\"20231122_gfimanpowerinternational_d0287dd012350d7f2534_20231122034304\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:52:\"/home/slklwimy/public_html/staging/gfi/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:47:\"/home/slklwimy/public_html/staging/gfi/wp-admin\";i:1;s:50:\"/home/slklwimy/public_html/staging/gfi/wp-includes\";i:2;s:59:\"/home/slklwimy/public_html/staging/gfi/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:38:\"/home/slklwimy/public_html/staging/gfi\";i:1;s:38:\"/home/slklwimy/public_html/staging/gfi\";i:2;s:49:\"/home/slklwimy/public_html/staging/gfi/wp-content\";i:3;s:57:\"/home/slklwimy/public_html/staging/gfi/wp-content/uploads\";i:4;s:57:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins\";i:5;s:60:\"/home/slklwimy/public_html/staging/gfi/wp-content/mu-plugins\";i:6;s:56:\"/home/slklwimy/public_html/staging/gfi/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:70:\"/home/slklwimy/public_html/staging/gfi/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wpgfi_options` VALUES("149", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wpgfi_options` VALUES("202", "elementor_log", "a:8:{s:32:\"2cc3fadf832176ee6086ee0cb2692535\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:103:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:7:\"\0*\0line\";i:175;s:7:\"\0*\0date\";s:19:\"2023-10-23 09:07:11\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:21:\"Undefined index: data\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:56;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2023-10-25 06:03:05\";i:1;s:19:\"2023-10-25 06:29:22\";i:2;s:19:\"2023-10-25 06:35:01\";i:3;s:19:\"2023-10-25 07:46:44\";i:4;s:19:\"2023-10-25 08:26:56\";i:5;s:19:\"2023-10-25 10:54:39\";i:6;s:19:\"2023-10-25 12:21:26\";i:7;s:19:\"2023-10-26 02:14:11\";i:8;s:19:\"2023-10-26 02:27:59\";i:9;s:19:\"2023-10-26 05:08:56\";i:10;s:19:\"2023-10-26 05:09:17\";i:11;s:19:\"2023-10-26 05:19:59\";i:12;s:19:\"2023-10-26 06:17:30\";i:13;s:19:\"2023-10-27 01:42:13\";i:14;s:19:\"2023-10-27 04:23:39\";i:15;s:19:\"2023-11-05 04:13:31\";i:16;s:19:\"2023-11-05 12:01:41\";i:17;s:19:\"2023-11-06 01:12:13\";i:18;s:19:\"2023-11-06 03:02:52\";i:19;s:19:\"2023-11-07 02:08:45\";i:20;s:19:\"2023-11-07 02:21:40\";i:21;s:19:\"2023-11-07 04:35:13\";i:22;s:19:\"2023-11-07 06:31:49\";i:23;s:19:\"2023-11-07 09:25:41\";i:24;s:19:\"2023-11-07 09:43:32\";i:25;s:19:\"2023-11-07 10:36:27\";i:26;s:19:\"2023-11-07 11:49:46\";i:27;s:19:\"2023-11-07 12:11:55\";i:28;s:19:\"2023-11-08 10:20:15\";i:29;s:19:\"2023-11-08 10:33:11\";i:30;s:19:\"2023-11-08 15:05:16\";i:31;s:19:\"2023-11-09 01:20:28\";i:32;s:19:\"2023-11-09 03:54:27\";i:33;s:19:\"2023-11-09 03:54:32\";i:34;s:19:\"2023-11-10 07:11:10\";i:35;s:19:\"2023-11-14 01:56:15\";i:36;s:19:\"2023-11-14 06:21:08\";i:37;s:19:\"2023-11-14 06:26:38\";i:38;s:19:\"2023-11-16 02:54:21\";i:39;s:19:\"2023-11-16 02:54:41\";i:40;s:19:\"2023-11-17 01:19:25\";i:41;s:19:\"2023-11-21 08:48:51\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:21:\"Undefined index: data\";s:4:\"file\";s:103:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:4:\"line\";i:175;s:5:\"trace\";b:1;}}s:32:\"9a265cd7ec074eda7c026c6297c590e1\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"804251\";s:7:\"\0*\0file\";s:105:\"https://slk.lwi.mybluehost.me/staging/gfi/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2023-10-24 01:55:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:69:\"Cannot read properties of undefined (reading &#039;toLowerCase&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-24 01:55:12\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1698112512\";s:7:\"message\";s:59:\"Cannot read properties of undefined (reading \'toLowerCase\')\";s:3:\"url\";s:105:\"https://slk.lwi.mybluehost.me/staging/gfi/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"804251\";}}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"804758\";s:7:\"\0*\0file\";s:105:\"https://slk.lwi.mybluehost.me/staging/gfi/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2023-10-24 01:55:23\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:21;s:14:\"\0*\0times_dates\";a:21:{i:0;s:19:\"2023-10-24 01:55:23\";i:1;s:19:\"2023-10-24 01:55:23\";i:2;s:19:\"2023-10-24 01:55:23\";i:3;s:19:\"2023-10-24 01:55:23\";i:4;s:19:\"2023-10-24 01:55:23\";i:5;s:19:\"2023-10-25 02:44:05\";i:6;s:19:\"2023-10-25 02:44:05\";i:7;s:19:\"2023-10-25 02:44:05\";i:8;s:19:\"2023-10-25 02:44:07\";i:9;s:19:\"2023-10-25 02:44:07\";i:10;s:19:\"2023-10-25 02:44:07\";i:11;s:19:\"2023-10-25 02:44:07\";i:12;s:19:\"2023-10-25 02:44:07\";i:13;s:19:\"2023-10-25 02:44:07\";i:14;s:19:\"2023-10-25 02:44:07\";i:15;s:19:\"2023-11-06 07:03:39\";i:16;s:19:\"2023-11-06 07:03:39\";i:17;s:19:\"2023-11-06 07:03:39\";i:18;s:19:\"2023-11-06 07:03:39\";i:19;s:19:\"2023-11-06 07:03:39\";i:20;s:19:\"2023-11-06 07:03:39\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1698112523\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:105:\"https://slk.lwi.mybluehost.me/staging/gfi/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"804758\";}}s:32:\"58fb37337126433428b9342b4ff6938d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"28722\";s:7:\"\0*\0file\";s:151:\"https://slk.lwi.mybluehost.me/staging/gfi/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.3.2\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2023-10-24 02:26:02\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of undefined (reading &#039;value&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:20;s:14:\"\0*\0times_dates\";a:20:{i:0;s:19:\"2023-10-24 02:26:02\";i:1;s:19:\"2023-10-24 05:47:14\";i:2;s:19:\"2023-10-24 14:07:26\";i:3;s:19:\"2023-10-24 14:07:37\";i:4;s:19:\"2023-10-24 14:44:06\";i:5;s:19:\"2023-10-25 03:20:11\";i:6;s:19:\"2023-10-25 04:02:31\";i:7;s:19:\"2023-10-25 06:02:47\";i:8;s:19:\"2023-10-25 06:29:18\";i:9;s:19:\"2023-10-25 06:32:49\";i:10;s:19:\"2023-10-25 06:59:18\";i:11;s:19:\"2023-10-25 07:09:08\";i:12;s:19:\"2023-10-25 08:30:17\";i:13;s:19:\"2023-10-25 08:30:24\";i:14;s:19:\"2023-10-25 08:58:51\";i:15;s:19:\"2023-10-26 05:09:32\";i:16;s:19:\"2023-11-06 01:31:19\";i:17;s:19:\"2023-11-07 03:58:25\";i:18;s:19:\"2023-11-07 10:36:36\";i:19;s:19:\"2023-11-07 11:33:31\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1698114362\";s:7:\"message\";s:53:\"Cannot read properties of undefined (reading \'value\')\";s:3:\"url\";s:151:\"https://slk.lwi.mybluehost.me/staging/gfi/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.3.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"28722\";}}s:32:\"41f5945b586ad407707be9f7ea38d501\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:114:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/modules/dynamic-tags/acf/tags/acf-text.php\";s:7:\"\0*\0line\";i:33;s:7:\"\0*\0date\";s:19:\"2023-10-24 13:59:17\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:19:\"Undefined offset: 1\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:13;s:14:\"\0*\0times_dates\";a:13:{i:0;s:19:\"2023-10-24 13:59:17\";i:1;s:19:\"2023-10-24 14:14:35\";i:2;s:19:\"2023-10-24 14:19:59\";i:3;s:19:\"2023-10-24 14:24:20\";i:4;s:19:\"2023-10-24 14:25:44\";i:5;s:19:\"2023-10-24 14:26:15\";i:6;s:19:\"2023-10-24 15:10:56\";i:7;s:19:\"2023-10-25 04:09:41\";i:8;s:19:\"2023-11-06 01:57:51\";i:9;s:19:\"2023-11-06 02:14:30\";i:10;s:19:\"2023-11-06 03:08:21\";i:11;s:19:\"2023-11-16 02:55:19\";i:12;s:19:\"2023-11-16 02:55:24\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:19:\"Undefined offset: 1\";s:4:\"file\";s:114:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/modules/dynamic-tags/acf/tags/acf-text.php\";s:4:\"line\";i:33;s:5:\"trace\";b:1;}}s:32:\"13297aebef0a19fe74a5e4fe2e839171\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:105:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:7:\"\0*\0line\";i:363;s:7:\"\0*\0date\";s:19:\"2023-10-24 14:10:23\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:7;s:14:\"\0*\0times_dates\";a:7:{i:0;s:19:\"2023-10-24 14:10:23\";i:1;s:19:\"2023-10-25 02:48:03\";i:2;s:19:\"2023-10-25 03:55:35\";i:3;s:19:\"2023-10-25 03:58:07\";i:4;s:19:\"2023-10-25 03:58:15\";i:5;s:19:\"2023-11-05 11:52:31\";i:6;s:19:\"2023-11-06 09:28:50\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type null\";s:4:\"file\";s:105:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:4:\"line\";i:363;s:5:\"trace\";b:1;}}s:32:\"230072103bbee145167f85f8261837c7\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:129:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:7:\"\0*\0line\";i:150;s:7:\"\0*\0date\";s:19:\"2023-10-24 15:03:02\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Undefined index: condition_type\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:129:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:150;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:3:{s:8:\"function\";s:28:\"normalize_template_json_item\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}i:2;a:3:{s:4:\"file\";s:129:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:120;s:8:\"function\";s:9:\"array_map\";}i:3;a:5:{s:4:\"file\";s:129:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:59;s:8:\"function\";s:24:\"normalize_templates_json\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:90:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor/data/base/endpoint.php\";s:4:\"line\";i:158;s:8:\"function\";s:9:\"get_items\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:109;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2023-11-08 10:20:15\";i:1;s:19:\"2023-11-08 10:20:15\";i:2;s:19:\"2023-11-08 10:20:15\";i:3;s:19:\"2023-11-08 10:33:13\";i:4;s:19:\"2023-11-08 10:33:13\";i:5;s:19:\"2023-11-08 10:33:13\";i:6;s:19:\"2023-11-08 15:05:17\";i:7;s:19:\"2023-11-08 15:05:17\";i:8;s:19:\"2023-11-08 15:05:17\";i:9;s:19:\"2023-11-09 01:20:29\";i:10;s:19:\"2023-11-09 01:20:29\";i:11;s:19:\"2023-11-09 01:20:29\";i:12;s:19:\"2023-11-09 03:54:27\";i:13;s:19:\"2023-11-09 03:54:27\";i:14;s:19:\"2023-11-09 03:54:27\";i:15;s:19:\"2023-11-09 03:54:33\";i:16;s:19:\"2023-11-09 03:54:33\";i:17;s:19:\"2023-11-09 03:54:33\";i:18;s:19:\"2023-11-10 07:11:11\";i:19;s:19:\"2023-11-10 07:11:11\";i:20;s:19:\"2023-11-10 07:11:11\";i:21;s:19:\"2023-11-14 01:56:15\";i:22;s:19:\"2023-11-14 01:56:15\";i:23;s:19:\"2023-11-14 01:56:15\";i:24;s:19:\"2023-11-14 06:21:09\";i:25;s:19:\"2023-11-14 06:21:09\";i:26;s:19:\"2023-11-14 06:21:09\";i:27;s:19:\"2023-11-14 06:26:39\";i:28;s:19:\"2023-11-14 06:26:39\";i:29;s:19:\"2023-11-14 06:26:39\";i:30;s:19:\"2023-11-16 02:54:23\";i:31;s:19:\"2023-11-16 02:54:23\";i:32;s:19:\"2023-11-16 02:54:23\";i:33;s:19:\"2023-11-16 02:54:42\";i:34;s:19:\"2023-11-16 02:54:42\";i:35;s:19:\"2023-11-16 02:54:42\";i:36;s:19:\"2023-11-17 01:19:26\";i:37;s:19:\"2023-11-17 01:19:26\";i:38;s:19:\"2023-11-17 01:19:26\";i:39;s:19:\"2023-11-21 08:48:52\";i:40;s:19:\"2023-11-21 08:48:52\";i:41;s:19:\"2023-11-21 08:48:52\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Undefined index: condition_type\";s:4:\"file\";s:129:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:150;s:5:\"trace\";b:1;}}s:32:\"5233349576763ba60bdfa2d85fb96534\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:110:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/modules/forms/classes/ajax-handler.php\";s:7:\"\0*\0line\";i:76;s:7:\"\0*\0date\";s:19:\"2023-10-25 03:46:17\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:24:\"Undefined index: form_id\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2023-10-25 03:46:17\";i:1;s:19:\"2023-10-25 03:46:25\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:24:\"Undefined index: form_id\";s:4:\"file\";s:110:\"/home/slklwimy/public_html/staging/gfi/wp-content/plugins/elementor-pro/modules/forms/classes/ajax-handler.php\";s:4:\"line\";i:76;s:5:\"trace\";b:1;}}}", "no");
INSERT INTO `wpgfi_options` VALUES("203", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `wpgfi_options` VALUES("155", "elementor_active_kit", "6", "yes");
INSERT INTO `wpgfi_options` VALUES("156", "elementor_font_display", "swap", "yes");
INSERT INTO `wpgfi_options` VALUES("165", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:19:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:19:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:19:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:19:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:19:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:19:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:19:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:19:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:19:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:19:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:19:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:19:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:19:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:19:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:19:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:19:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:19:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:19:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:19:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:19:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:19:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:19:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:19:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:19:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:19:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:19:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:19:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:19:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:19:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:19:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:19:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:19:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:19:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:19:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:19:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:19:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:19:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:19:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:19:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:19:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:19:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:19:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:19:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:19:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:19:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:19:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:19:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:19:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:19:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:19:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:19:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:19:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:19:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:19:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:19:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:19:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:19:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:19:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:19:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:19:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:19:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:19:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:19:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:19:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:19:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:19:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:19:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:19:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:19:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:19:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:19:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:19:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:19:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:19:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:19:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:19:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:19:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:19:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:19:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:19:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:19:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:19:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:19:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:19:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:19:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:19:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:19:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:19:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:19:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:19:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:19:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:19:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:19:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:19:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:19:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:19:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:19:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:19:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:19:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:19:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:19:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:19:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:19:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:19:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:19:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:19:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:19:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:19:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:19:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:19:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:19:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:19:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:19:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:19:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:19:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:19:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:19:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:19:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:19:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:19:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:19:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:19:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:19:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:19:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:19:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:19:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:19:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:19:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:19:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:19:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:19:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:19:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:19:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:19:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:19:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:19:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:19:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:19:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:19:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:19:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:19:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:19:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:19:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:19:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:19:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:19:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:19:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:19:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:19:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:19:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:19:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:19:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:19:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:19:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:19:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:19:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:19:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:19:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:19:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:19:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:19:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:19:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:19:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:19:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:19:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:19:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:19:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:19:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:19:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:19:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:19:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:19:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:19:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:19:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:19:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:19:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:19:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:19:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:19:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:19:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:19:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:19:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:19:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:19:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:19:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:19:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:19:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:19:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:19:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:19:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:19:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:19:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:19:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:19:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:19:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:19:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:19:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:19:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:19:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:19:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:19:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:19:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:19:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:19:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:19:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:19:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:19:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:19:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:19:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:19:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:19:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:19:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:19:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:19:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:19:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:19:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:19:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:19:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:19:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:19:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:19:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:19:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:19:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:19:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:19:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:19:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:19:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:19:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:19:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:19:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:19:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:19:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:19:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:19:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:19:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:19:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:19:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:19:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:19:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:19:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:19:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:19:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:19:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:19:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:19:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:19:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:19:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:19:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:19:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:19:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:19:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:19:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:19:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:19:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:19:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:19:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:19:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:19:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:19:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:19:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:19:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:19:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:19:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:19:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:19:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:19:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:19:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:19:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:19:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:19:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:19:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:19:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:19:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:19:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:19:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:19:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:19:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:19:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:19:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:19:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:19:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:19:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:19:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:19:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:19:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:19:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:19:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:19:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:19:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:19:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:19:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:19:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:19:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:19:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:19:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:19:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:19:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:19:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:19:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:19:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:19:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:19:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:19:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:19:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:19:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:19:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:19:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:19:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:19:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:19:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:19:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:19:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:19:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:19:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:19:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:19:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:19:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:19:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:19:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:19:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:19:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:19:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:19:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:19:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:19:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:19:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:19:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:19:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:19:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:19:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:19:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:19:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:19:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:333;a:19:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:19:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:335;a:19:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:19:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:19:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:19:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:19:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:340;a:19:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:341;a:19:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:19:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:19:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:344;a:19:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:19:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:19:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:19:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:348;a:19:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:19:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:350;a:19:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:19:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:352;a:19:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:19:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:19:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:355;a:19:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:356;a:19:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:19:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:19:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:19:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:360;a:19:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"Beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:361;a:19:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:19:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:363;a:19:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:19:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:19:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:366;a:19:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:19:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:368;a:19:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:19:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:19:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:371;a:19:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:372;a:19:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:373;a:19:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\"