(function ($) {

    var PremiumMiniCartHandler = function ($scope, $) {

        var settings = $scope.find('.pa-woo-mc__outer-container').data('settings');

        if (!settings) {
            return;
        }

        // using the same classes in the off-canvas widget.
        $('html').addClass('msection-html');

        var $bodyInnerWrap = $("body .premium-magic-section-body-inner"),
            triggerEvent = settings.trigger,
            isHidden = true,
            type = settings.type,
            id = $scope.data('id'),
            style = settings.style,
            hoverTimeout,
            paodometer,
            paSubtotalOdometer;

        // shouldn't this be if it's a slide menu only?
        if ($(".premium-magic-section-body-inner").length < 1)
            $("body").wrapInner('<div class="premium-magic-section-body-inner" />');

        //Put the overlay on top and make sure it only one overlay per widget is added.
        $('.premium-magic-section-body-inner > .pa-woo-mc__overlay-' + id).remove();
        $('.premium-magic-section-body-inner').prepend($scope.find('.pa-woo-mc__overlay'));

        $scope.find('.pa-woo-mc__inner-container').off('click.paToggleMiniCart mouseenter.paToggleMiniCart mouseleave.paToggleMiniCart');

        // counting Effect.
        getWraptoOrg(10);

        initWidgetEvents();

        initCartContentEvents();

        updateCartDynamicText();

        initCountingEffect();

        if (settings.crossSells) {
            setTimeout(function() {
                initCrossSellsCarousel();
            }, 0);
        }

        // Reinitialize the event listeners after the mini cart is refreshed.
        $(document.body).on('wc_fragments_loaded wc_fragments_refreshed', function(e) {

            hideContentIfEmptyCart();
            initCartContentEvents();
            updateCartDynamicText();

            if (settings.crossSells) {
                setTimeout(function() {
                    initCrossSellsCarousel();
                }, 0);
            }

            // counting effect.
            if ( $scope.hasClass('premium-mc-counting-yes') ) {
                setTimeout(function() {
                    var newCount = $scope.find('.pa-woo-mc__count-placeholder').text(),
                        newSubtotal = $scope.find('.pa-woo-mc__text-wrapper .pa-woo-mc__subtotal-placeholder').text();

                    if ($scope.find('.pa-woo-mc__badge.pa-counting').length ) {
                        paodometer.update(newCount);
                    }

                    if ($scope.find('.pa-woo-mc__subtotal.pa-counting .pa-woo-mc__subtotal-val').length) {
                        paSubtotalOdometer.update(newSubtotal);
                    }
                }, 0);
            }
        });

        /**Helper Function */

        function initCountingEffect() {
            var isEnabled = $scope.hasClass('premium-mc-counting-yes');

            if ( ! isEnabled ) {
                return;
            }

            if ($scope.find('.pa-woo-mc__badge.pa-counting .odometer-wrapper').length ) {
                paodometer = new Odometer({
                    el: $scope.find('.pa-woo-mc__badge.pa-counting .odometer-wrapper')[0],
                    value: $scope.find('.pa-woo-mc__count-placeholder').text(),
                    format: '(,ddd).dd'
                });
            }

            if($scope.find('.pa-woo-mc__subtotal.pa-counting .pa-woo-mc__subtotal-val').length) {
                paSubtotalOdometer = new Odometer({
                    el: $scope.find('.pa-woo-mc__subtotal.pa-counting .pa-woo-mc__subtotal-val')[0],
                    value: $scope.find('.pa-woo-mc__text-wrapper .pa-woo-mc__subtotal-placeholder').text(),
                    format: '(,ddd).dd'
                });
            }
        }

        function initCrossSellsCarousel() {
            $scope.find('.pa-woo-mc__cross-sells').slick({
                infinite: true,
                draggable: true,
                pauseOnHover: true,
                arrows: false,
                slidesToShow: settings.slidesToShow || 3,
                slidesToScroll: settings.slidesToScroll || 1,
                speed: settings.speed || 1000,
                autoplay: settings.autoplay,
                autoplaySpeed: settings.autoplaySpeed || 5000
            });

            //cross sells nav.
            $scope.find('.pa-woo-mc__cross-sells-arrows a').on('click.paCrossSellsNav', function () {

                if ($(this).hasClass('prev-arrow')) {
                    $scope.find('.pa-woo-mc__cross-sells').slick('slickPrev');

                } else if ($(this).hasClass('next-arrow')) {
                    $scope.find('.pa-woo-mc__cross-sells').slick('slickNext');
                }
            });

            if ( $scope.find('.pa-woo-mc__cross-sells .pa-woo-mc__cross-sell-product').length > 1 ) {
                // show carousel arrows.
                $scope.find('.pa-woo-mc__cross-sells-arrows')
                .css({
                    visibility: 'inherit',
                    opacity: '1'
                });

            } else {
                // hide carousel arrows.
                $scope.find('.pa-woo-mc__cross-sells-arrows')
                .css({
                    visibility: 'hidden',
                    opacity: '0'
                });
            }
        }

        /**Hides the cart footer if the cart is empty. */
        function hideContentIfEmptyCart() {

            if ( $('.pa-woo-mc__content-wrapper-' + id + ' .pa-woo-mc__empty-msg').length ) {
                $('.pa-woo-mc__content-wrapper-' + id).addClass('pa-hide-content');
            } else {
                $('.pa-woo-mc__content-wrapper-' + id).removeClass('pa-hide-content');
            }
        }

        /**Restores the body to its initial state */
        function getWraptoOrg(duration) {

            if (!duration)
                duration = 500;

            $('body').addClass('animating');

            $bodyInnerWrap.css('transform', 'none');

            $('html').css('height', 'auto');

            setTimeout(function () {

                $('html').removeClass('offcanvas-open');
                $('body').removeClass('animating');
            }, duration);

        }

        /** Handles Mini Cart Display */
        function toggleMiniCart(e) {
            if ('hover' === triggerEvent) {
                e.stopPropagation();

                clearTimeout(hoverTimeout);
                $scope.find('.pa-woo-mc__content-wrapper-' + id).removeClass('premium-addons__v-hidden').addClass('pa-woo-mc__open');
            } else {

                if ('menu' === type) {
                    $scope.find('.pa-woo-mc__content-wrapper-' + id).removeClass('premium-addons__v-hidden').toggleClass('pa-woo-mc__open');

                } else {
                    if (isHidden) {
                        $scope.find('.pa-woo-mc__content-wrapper-' + id).css('display', 'flex');

                        $('html').css({
                            'height': '100%',
                            // 'overflow-y': 'scroll'
                        });

                        $('html').addClass('offcanvas-open');

                        //Show overlay.
                        $(".pa-woo-mc__overlay-" + id).removeClass("premium-addons__v-hidden");

                        //Show the content if reveal or similar effects.
                        $scope.find('.pa-woo-mc__content-wrapper-' + id).removeClass('premium-addons__v-hidden');

                        $scope.find('.pa-woo-mc__content-wrapper-' + id).removeClass('pa-woo-mc__anim-' + style);

                        setTimeout(function () {
                            isHidden = false;
                        }, 550);
                    }
                }
            }

            // refresh carousel on opening the mini cart.
            if ($scope.find(".slick-slider").length > 0) {
                $scope.find('.pa-woo-mc__cross-sells').slick('setPosition');
            }
        }

        /**
         * Updates Cart Dynamic Text.
         * We add the text here as it gets replaced with only the items' count when
         * WC Fragments are refreshed.
         */
        function updateCartDynamicText() {

            var countTxt = $scope.find('div[data-pa-count-txt]').data('pa-count-txt');

            if (countTxt) {
                var itemCount = $scope.find('.pa-woo-mc__cart-count').text();

                if ( $scope.hasClass('pa-woo-mc__layout-3') ) {
                    // in layout 3, the count text is inside the cart header.
                    $scope.find('.pa-woo-mc__cart-header .pa-woo-mc__cart-count').text(itemCount + ' ' + countTxt);
                } else {
                    if ( countTxt.includes('{{count}}') ) { // all layouts but layout 3.
                        var newTxt = countTxt.replace("{{count}}", '<span class="pa-woo-mc__cart-count">' + itemCount + '</span>');
                        $scope.find('.pa-woo-mc__cart-footer .pa-woo-mc__subtotal-heading').html(newTxt);
                    }

                }
            }

            if (settings.removeTxt) {
                $scope.find('.pa-woo-mc__remove-item span').text(settings.removeTxt);
            }

            if ( settings.crossSellTxt){
                $scope.find('.pa-woo-mc__cross-sells-heading').text( settings.crossSellTxt );
            }

            // updating the progressbar.
            if ( $scope.find('.pa-woo-mc__progressbar-wrapper').length ) {
                var subtotal = parseFloat( $scope.find('.pa-woo-mc__progressbar-wrapper .pa-woo-mc__subtotal-placeholder').text()),
                    progressTxt = $scope.find('.pa-woo-mc__progressbar-wrapper').data('pa-progress-txt'),
                    freeShippingThreshold = parseFloat( $scope.find('.pa-woo-mc__progressbar-wrapper').data('pa-progress-threshold') ),
                    progressVal = parseFloat(((subtotal /freeShippingThreshold) * 100).toFixed(2)),
                    completeTxt = $scope.find('.pa-woo-mc__progressbar-wrapper').data('pa-progress-complete');

                $scope.find('.pa-woo-mc__progressbar').attr('value', progressVal);

                if ( (subtotal >= freeShippingThreshold) && completeTxt ) {
                    $scope.find('.pa-woo-mc__progress-heading').html(completeTxt);
                } else {
                    $scope.find('.pa-woo-mc__progress-heading').html(progressTxt);
                }

                // update its message if the purchase threshold is met.
            }
        }

        /** Adds Cart Items' Events.
         * Updating the item quantity, or deleting it.
        */
        function initCartContentEvents() {

            $('.pa-woo-mc__qty-btn').on('click', function (e) {
                e.stopPropagation();

                var $input = $(this).parent().find('.pa-woo-mc__input')[0],
                    itemStock = parseInt($($input).attr('max')),
                    currentVal = parseInt($($input).val());

                if ($(this).hasClass('plus')) {
                    if (currentVal >= itemStock) {
                        $(this).parents('.pa-woo-mc__item-wrapper').find('.pa-woo-mc__item-notice').text(PAWooMCartSettings.stock_msg + itemStock);
                    } else {
                        $input.stepUp();
                        $($input).trigger('change');
                    }

                } else {

                    $input.stepDown();
                    $($input).trigger('change');
                }
            });

            // update item quantity.
            $scope.find('.pa-woo-mc__input').on('change', function () {

                var itemKey = $(this).attr('name').replace('cart-', ''),
                    newQty = $(this).val();

                if ('1' === newQty) {
                    $(this).siblings('.pa-woo-mc__qty-btn.minus').addClass('disabled');
                } else {
                    $(this).siblings('.pa-woo-mc__qty-btn.minus').removeClass('disabled');
                }

                sendCartAjax('pa_update_mc_qty', itemKey, newQty);
            });

            // delete cart item.
            $scope.find('.pa-woo-mc__remove-item').on('click.paRemoveCartItem', function (e) {
                e.stopPropagation();
                var itemKey = $(this).data('pa-item-key').replace('cart-', '');
                sendCartAjax('pa_delete_cart_item', itemKey, false);
            });

            $scope.find('.pa-woo-mc__input').on('click', function(e) {
                e.stopPropagation();
            });

        }

        /**
         * Sends an ajax request to update/delete a cart item.
         *
         * @param {String} action Request action.
         * @param {String} itemKey Items's key.
         * @param {Boolean|String} qty false|item quantity.
         */
        function sendCartAjax(action, itemKey, extraData) {

            var data = {
                action: action,
                nonce: PAWooMCartSettings.mini_cart_nonce,
            };

            if ('pa_delete_cart_items' !== action) {
                data.itemKey = itemKey;
            }

            if ( 'pa_update_mc_qty' === action && extraData ) {
                data.quantity = extraData;
            }

            if ('pa_apply_coupon' === action){
                data.couponCode = extraData
            }

            $.ajax({
                url: PAWooMCartSettings.ajaxurl,
                dataType: 'JSON',
                type: 'POST',
                data: data,
                beforeSend: function () {
                    $scope.find('.pa-woo-mc__widget-shopping-outer-wrapper').append('<div class="premium-loading-feed"><div class="premium-loader"></div></div>');
                },
                success: function(res) {

                    $(document.body).trigger('wc_fragment_refresh');

                    if ('pa_apply_coupon' === action ) {
                        var noticeTxt = typeof res.data === 'string'? res.data : 'Coupon was applied successfully.';

                        if (noticeTxt.includes('successfully')) {
                            $scope.find('.pa-woo-mc__coupon-notice').removeClass('pa-error-notice').text(noticeTxt);

                        } else {
                            $scope.find('.pa-woo-mc__coupon-notice').addClass('pa-error-notice').text(noticeTxt);
                        }
                    }
                },
                error: function (err) {
                    console.log(err);

                    if ('pa_apply_coupon' === action ) {
                        $scope.find('.pa-woo-mc__coupon-notice').addClass('pa-error-notice').text(err.data);
                    }
                },
                complete: function (res) {
                    $scope.find('.premium-loading-feed').remove();
                }
            });
        }

        /** Add the widget's basic events, doesn't need to be re-added on cart fragments refresh */
        function initWidgetEvents() {

            if ('click' === triggerEvent) {
                $scope.find('.pa-woo-mc__inner-container').on('click.paToggleMiniCart', toggleMiniCart);
            } else {
                // hover => mini window.
                $scope.find('.pa-woo-mc__inner-container').on('mouseenter.paToggleMiniCart', toggleMiniCart);
                $scope.on('mouseleave.paToggleMiniCart', function (e) {

                    hoverTimeout = setTimeout(function () {
                        $scope.find('.pa-woo-mc__content-wrapper-' + id).removeClass('pa-woo-mc__open');
                    }, 300);
                });
            }

            // remove all btn.
            $scope.find('.pa-woo-mc__remove-all-btn').on('click.paConfirm', function() {
                $(this).hide();
                $scope.find('.pa-woo-mc__empty-mc-confirm').css('display', 'flex');
            });

            $scope.find('.pa-woo-mc__confirm-btn').on('click.paEmptyMC', function() {

                if($(this).hasClass('pa-empty-mc')) {
                    sendCartAjax('pa_delete_cart_items', false, false);
                }

                // show the main message anyway.
                $scope.find('.pa-woo-mc__remove-all-btn').show();
                $scope.find('.pa-woo-mc__empty-mc-confirm').hide();
            });

            // apply coupon.
            $scope.find('.pa-woo-mc__coupon-submit').on('click', function() {
                var couponCode = $scope.find('.pa-woo-mc__coupon-field').val();

                if (couponCode) {
                    sendCartAjax('pa_apply_coupon', false, couponCode);
                }
            });

            //On Click outside, close everything.
            if (settings.clickOutside) {

                $("body").on("click", function (event) {
                    var mcContent = ".premium-tabs-nav-list-item, .pa-woo-mc__content-wrapper, .pa-woo-mc__content-wrapper *, .pa-woo-mc__inner-container, .pa-woo-mc__inner-container *";

                    if (!$(event.target).is($(mcContent))) {
                        if ('menu' === type) {
                            $scope.find('.pa-woo-mc__content-wrapper-' + id).removeClass('pa-woo-mc__open');
                        } else {
                            !isHidden && $scope.find(".pa-woo-mc__close-button").trigger("click");
                        }
                    }
                });
            }

            /**
             * Events: Closing the slide menu.
             */
            $scope.find(".pa-woo-mc__close-button").on("click", function () {
                $(".pa-woo-mc__overlay-" + id).addClass("premium-addons__v-hidden");

                //Add the default styling again.
                $scope.find('.pa-woo-mc__content-wrapper-' + id).addClass('pa-woo-mc__anim-' + style);

                setTimeout(function () {
                    isHidden = true;
                    $scope.find('.pa-woo-mc__content-wrapper-' + id).css('display', 'none');
                }, 500);

            });

            if (settings.coupon) {

                $scope.find('.pa-woo-mc__coupon-toggler').click(function () {
                    if ($scope.find('.pa-woo-mc__coupon-wrapper').is(':visible')) {
                        $scope.find('.pa-woo-mc__coupon-wrapper').slideUp();
                    } else {
                        $scope.find('.pa-woo-mc__coupon-wrapper').slideDown();
                    }
                });
            }
        }
    };

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/premium-mini-cart.default', PremiumMiniCartHandler);
    });
})(jQuery);