<?php
/**
 * Plugin Name: Custom Chatbot Widget
 * Description: A custom Elementor widget for the chatbot.
 * Version: 1.0
 * Author: Your Name
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

// Register Custom Widget
function register_chatbot_widget($widgets_manager) {
    require_once(__DIR__ . '/chatbot-widget.php');
    $widgets_manager->register(new \Chatbot_Widget());
}
add_action('elementor/widgets/register', 'register_chatbot_widget');

// Load JS and CSS
function enqueue_chatbot_assets() {
    wp_enqueue_style('chatbot-style', plugin_dir_url(__FILE__) . 'chatbot-style.css');
    wp_enqueue_script('chatbot-script', plugin_dir_url(__FILE__) . 'chatbot-script.js', ['jquery'], false, true);
}
add_action('wp_enqueue_scripts', 'enqueue_chatbot_assets');
