document.addEventListener("DOMContentLoaded", function () {
    const chatBox = document.getElementById("chatbot");
    const inputField = document.getElementById("chat-input");
    const sendButton = document.getElementById("send-message");
    const chatIcon = document.getElementById("chatbot-icon");

    const wpAjaxUrl = "/staging/sapientus/wp-admin/admin-ajax.php";

     function appendMessage(sender, message) {
        let chatMessages = document.getElementById("chat-messages");
    
        let messageContainer = document.createElement("div");
        messageContainer.classList.add("chat-message");
    
        if (sender === "You") {
            messageContainer.classList.add("user");
        } else {
            messageContainer.classList.add("bot");
        }
    
        let now = new Date();
        let hours = now.getHours();
        let minutes = now.getMinutes();
        let ampm = hours >= 12 ? "PM" : "AM";
        hours = hours % 12 || 12; 
        minutes = minutes < 10 ? "0" + minutes : minutes; 
        let timeString = `${hours}:${minutes} ${ampm}`;
    

        let dateString = now.toLocaleDateString('en-US', {
            year: 'numeric',
            month: 'long',
            day: 'numeric'
        });
    
    
        // Create sender label
        let senderLabel = document.createElement("div");
        senderLabel.classList.add("chat-sender");
        senderLabel.textContent = sender === "You" ? "You" : "Sapientus AI Chatbot";
    
        // Create message bubble
        let messageBubble = document.createElement("div");
        messageBubble.classList.add("message-bubble");
        messageBubble.innerHTML = message;
    
        // Create timestamp
        let timestamp = document.createElement("div");
        timestamp.classList.add("chat-timestamp");
        timestamp.textContent = `${dateString} ${timeString}`; // Show date and time
    
        // Append elements
        messageContainer.appendChild(senderLabel);
        messageContainer.appendChild(messageBubble);
        messageContainer.appendChild(timestamp);
    
        chatMessages.appendChild(messageContainer);
        chatMessages.scrollTop = chatMessages.scrollHeight; // Auto-scroll to latest message
    }



    function sendMessage() {
        let message = inputField.value.trim();
        if (message === "") return;

        appendMessage("You", message);
        inputField.value = "";

       let userId = localStorage.getItem("chatbot_user_id");
        if (!userId) {
            userId = "chat_" + Date.now() + Math.random().toString(36).substring(2, 10);
            localStorage.setItem("chatbot_user_id", userId);
        }
    
        let formData = new FormData();
        formData.append("action", "chatbot_request");
        formData.append("message", message);
        formData.append("user_id", userId);

        fetch(wpAjaxUrl, {
            method: "POST",
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                let parsed = JSON.parse(data.data.response);
                appendMessage("Bot", parsed.reply);
            } else {
                appendMessage("Bot", "Error: " + data.data.error);
            }
        })
        .catch(() => {
            appendMessage("Bot", "Sorry, something went wrong.");
        });
    }

    sendButton.addEventListener("click", sendMessage);
    inputField.addEventListener("keypress", function (event) {
        if (event.key === "Enter") {
            sendMessage();
        }
    });
    
});

document.addEventListener("DOMContentLoaded", function () {
    const picker = new EmojiMart.Picker({
        set: "apple",
        onEmojiSelect: (emoji) => {
            document.getElementById("chat-input").value += emoji.native;
        },
    });

    document.getElementById("emoji-picker").appendChild(picker);

    document.getElementById("emoji-button").addEventListener("click", function () {
        let pickerDiv = document.getElementById("emoji-picker");
        pickerDiv.style.display = pickerDiv.style.display === "none" ? "block" : "none";
    });

    document.addEventListener("click", function (e) {
        if (!document.getElementById("chat-input-container").contains(e.target)) {
            document.getElementById("emoji-picker").style.display = "none";
        }
    });
});

function toggleChat() {
    const chatBox = document.getElementById("chatbot");
    let chatIcon = document.getElementById("chatbot-icon");
      if (chatBox.style.display === "none" || chatBox.style.display === "") {
        chatBox.style.display = "flex"; // Show chat
        chatIcon.style.display = "none"; // Hide icon
    } else {
        chatBox.style.display = "none"; // Hide chat
        chatIcon.style.display = "block"; // Show icon
    }
    // chatBox.classList.toggle("open");
}


document.addEventListener("DOMContentLoaded", function() {
    let userId = localStorage.getItem("chatbot_user_id");

    if (!userId) {
        userId = "chat_" + Date.now() + Math.random().toString(36).substring(2, 10);
        localStorage.setItem("chatbot_user_id", userId);
    }

    // Store user ID in a hidden input or send it with messages
    window.chatbotUserId = userId;
});

