jQuery(document).ready(function($) {

    const nav = document.querySelector("nav");
    const dropdown = document.querySelector(".dropdown-item");
    const img = document.getElementById("monkeylogo");

    const black = document.querySelectorAll(".logo__black");
    const white = document.querySelectorAll(".logo__white");

    const logo_black_nav_white = document.querySelectorAll(".logo__black__nav__white");
    const logo_white_nav_black = document.querySelectorAll(".logo__white__nav__black");

    //ALL BLACK
    black.forEach((i) => {
        if (i) {
            let option = {
                rootMargin : "0px 0px 0px 0px",
                threshold : 0,
            };

            if($(i).attr("data-rootMargin"))
            {
                option.rootMargin = $(i).attr("data-rootMargin");
            }

            if($(i).attr("data-threshold"))
            {
                option.threshold = parseFloat($(i).attr("data-threshold"));
            }

            const blackObserver = new IntersectionObserver
                (function(
                    entries, 
                    blackObserver
                ) {
                    entries.forEach(entry => {
                        console.log("black " + entry.isIntersecting);
                        //console.log(entry.target);
                        if(entry.isIntersecting){
                            //BLACK
                            nav.classList.add("visited");
                            dropdown.classList.add("dropdownvisited");
                            img.src = "../th3monkeys/templates/themonkeys/images/TH3MONKEYS-Logo-OnWhiteBG.svg";
                        } else {
                            
                        }
                    });
                },option);  
            blackObserver.observe(i);
        }
    })

    //ALL WHITE
    white.forEach((i) => {
        if (i) {
            let option = {
                rootMargin : "0px 0px 0px 0px",
                threshold : 0,
            };

            if($(i).attr("data-rootMargin"))
            {
                option.rootMargin = $(i).attr("data-rootMargin");
            }

            if($(i).attr("data-threshold"))
            {
                option.threshold = parseFloat($(i).attr("data-threshold"));
            }

            const whiteObserver = new IntersectionObserver
                (function(
                    entries, 
                    whiteObserver
                ) {
                    entries.forEach(entry => {
                        console.log("white " + entry.isIntersecting);
                        //console.log(entry.target);
                        if(entry.isIntersecting){
                            //WHITE
                            nav.classList.remove("visited");
                            dropdown.classList.remove("dropdownvisited");
                            img.src = "../th3monkeys/templates/themonkeys/images/TH3MONKEYS-Logo-OnBlackBG.svg";
                        } else {
                            
                        }
                    });
                },option);  
            whiteObserver.observe(i);
        }
    })

    //LOGO BLACK NAV WHITE
    logo_black_nav_white.forEach((i) => {
        if (i) {
            let option = {
                rootMargin : "0px 0px 0px 0px",
                threshold : 0,
            };

            if($(i).attr("data-rootMargin"))
            {
                option.rootMargin = $(i).attr("data-rootMargin");
            }

            if($(i).attr("data-threshold"))
            {
                option.threshold = parseFloat($(i).attr("data-threshold"));
            }

            const logoBlackNavWhiteObserver = new IntersectionObserver
                (function(
                    entries, 
                    logoBlackNavWhiteObserver
                ) {
                    entries.forEach(entry => {
                        console.log("logoBlackNavWhite " + entry.isIntersecting);
                        //console.log(entry.target);
                        if(entry.isIntersecting){
                            //BLACK LOGO
                            img.src = "../th3monkeys/templates/themonkeys/images/TH3MONKEYS-Logo-OnWhiteBG.svg";
            
                            //WHITE NAV
                            nav.classList.remove("visited");
                            dropdown.classList.remove("dropdownvisited");
                        } else {
                            
                        }
                    });
                },option);  
            logoBlackNavWhiteObserver.observe(i);
        }
    })

    //LOGO WHITE NAV BLACK
    var num = 1;
    logo_white_nav_black.forEach((i) => {
        if (i) {
            let option = {
                rootMargin : "0px 0px 0px 0px",
                threshold : 0,
            };

            if($(i).attr("data-rootMargin"))
            {
                option.rootMargin = $(i).attr("data-rootMargin");
            }

            if($(i).attr("data-threshold"))
            {
                option.threshold = parseFloat($(i).attr("data-threshold"));
            }

            const logoWhiteNavBlackObserver = new IntersectionObserver
                (function(
                    entries, 
                    logoWhiteNavBlackObserver
                ) {
                    entries.forEach(entry => {
                        console.log("logoWhiteNavBlack " + entry.isIntersecting);
                        if(entry.isIntersecting){
                            //WHITE LOGO
                            img.src = "../th3monkeys/templates/themonkeys/images/TH3MONKEYS-Logo-OnBlackBG.svg";
            
                            //BLACK NAV
                            nav.classList.add("visited");
                            dropdown.classList.add("dropdownvisited");
                        } else {
                            
                        }
                    });
                },option);  
            logoWhiteNavBlackObserver.observe(i);
        }
    })
});