jQuery(document).ready(function($) {

    //Video Controls
    $("#myVideo").prop('muted', true);

    $(".mute-video3").click(function () {
        if ($("#myVideo").prop('muted')) {
            $("#myVideo").prop('muted', false);
            $(this).find('i').toggleClass('fa-volume-mute fa-volume-up'); // changing icon
        } else {
            $("#myVideo").prop('muted', true);
            $(this).find('i').toggleClass('fa-volume-up fa-volume-mute'); // changing icon
        }
        //console.log($("#myVideo").prop('muted'))
    });

    //Progress Bar
    var vid = document.getElementById("myVideo");
    vid.ontimeupdate = function(){
      var percentage = ( vid.currentTime / vid.duration ) * 100;
      $("#custom-seekbar3 span").css("width", percentage+"%");
    };
    
    $("#custom-seekbar3").on("click", function(e){
        var offset = $(this).offset();
        var left = (e.pageX - offset.left);
        var totalWidth = $("#custom-seekbar3").width();
        var percentage = ( left / totalWidth );
        var vidTime = vid.duration * percentage;
        vid.currentTime = vidTime;
    });//click()

    

    var videoTag = $('video').get(0);
    videoTag.addEventListener("loadedmetadata", function(event) {
    videoRatio = videoTag.videoWidth / videoTag.videoHeight;
    targetRatio = $(videoTag).width() / $(videoTag).height();
        if (videoRatio < targetRatio) {
        $(videoTag).css("transform", "scaleX(" + (targetRatio / videoRatio) + ")");
        } else if (targetRatio < videoRatio) {
        $(videoTag).css("transform", "scaleY(" + (videoRatio / targetRatio) + ")");
        } else {
        $(videoTag).css("transform", "");
        }
    });

});